/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "grepfield_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\ngrepfield: looks for patterns within a specific field of a flat-file\n");
  fprintf(stderr, "\nusage: %s <options> <pattern> [file ...] \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help               print this message and exit\n");
	fprintf(stderr, "  -V, --version            print version info and exit\n");
	fprintf(stderr, "  -d, --delim <delim>      field separator string (default: 0xfe)\n");
	fprintf(stderr, "  -o, --outfile <outfile>  output file name (default: stdout)\n");
	fprintf(stderr, "  -f, --field <field>      index of field to scan (1-based)\n");
	fprintf(stderr, "  -F, --field-label <field_label>\n                           label of field to scan (1-based)\n");
	fprintf(stderr, "  -v, --invert             print only non-matching lines\n");
	fprintf(stderr, "  -i, --ignore-case        do case-insensitive matches\n");
	fprintf(stderr, "  -p, --preserve_header    preserve the header line of the first file and discard\n                           all other headers.\n");
	fprintf(stderr, "\nif no field is specified, the entire input line is scanned.");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"version", no_argument, 0, 'V'},
	{"delim", required_argument, 0, 'd'},
	{"outfile", required_argument, 0, 'o'},
	{"field", required_argument, 0, 'f'},
	{"field-label", required_argument, 0, 'F'},
	{"invert", no_argument, 0, 'v'},
	{"ignore-case", no_argument, 0, 'i'},
	{"preserve_header", no_argument, 0, 'p'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVd:o:f:F:vip", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->version = 1;
				break;
			case 'd':
				args->delim = optarg;
				break;
			case 'o':
				args->outfile = optarg;
				break;
			case 'f':
				args->field = optarg;
				break;
			case 'F':
				args->field_label = optarg;
				break;
			case 'v':
				args->invert = 1;
				break;
			case 'i':
				args->ignore_case = 1;
				break;
			case 'p':
				args->preserve_header = 1;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

