/************************************
     Copyright 2009 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file hashjoin_main.h
 *  @brief defines structure to hold command-line arguments and protypes
 *  some functions.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifndef HASHJOIN_MAIN_H
#define HASHJOIN_MAIN_H

/* user-defined things in arg table */

/* end user-defined things */

/** exit code to use when invoked with usage() or version(). */
#define EXIT_HELP 1
/** exit code to use when everything was okay. */
#define EXIT_OKAY 0
/** exit code to use when there was an i/o-related error. */
#define EXIT_FILE_ERR -1
/** exit code to use when there was an error allocating memory. */
#define EXIT_MEM_ERR -2

/** current version of the application. */
#define APPLICATION_VERSION "0.1"
/** short description of what the app does. */
#define APPLICATION_DESCRIPTION "joins dimensional fields from a file into a data stream"

/** structure to hold commandline options & arguments.
 */
struct cmdargs {
	int help;	/**< @brief print this message and exit */
	int version;	/**< @brief print version info and exit */
	char *delim;	/**< @brief input data field separator string */
	char *dimension_file;	/**< @brief the file containing dimensional data */
	char *dimension_delim;	/**< @brief dimension file field separator string (if different from the data stream delimiter) */
	char *data_key_fields;	/**< @brief a list of lookup key field indexes in the data stream */
	char *dimension_key_fields;	/**< @brief a list of lookup key field indexes in the dimension file */
	char *key_labels;	/**< @brief a list of lookup key field labels */
	char *dimension_fields;	/**< @brief a list of dimensional field indexes to add to the data */
	char *dimension_field_labels;	/**< @brief a list of dimensional field labels to add to the data */
	char *dimension_labels;	/**< @brief output labels for added fields when the data stream has a header and the dimension file does not. */
};


/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int, char **, struct cmdargs *);

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage ( char * );

/** @brief prints application version.
  */
void version ( void );

/** @brief beginning of primary application logic section called by main().
  * 
  * @param args contains the parsed cmd-line options & arguments.
  * @param argc number of cmd-line arguments.
  * @param argv list of cmd-line arguments
  * @param optind index of the first non-option cmd-line argument.
  * 
  * @return exit status for main() to return.
  */
int hashjoin( struct cmdargs *args, int argc, char *argv[], int optind );

#endif

#ifdef __cplusplus
}
#endif
