/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1999 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/
#ifndef __FXVESA_H__
#define __FXVESA_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __3DFX_H__
#  include "3dfx.h"
#endif

typedef enum
{
   VESA_ERR_NONE,
   VESA_ERR_DPMI_MAPPING_FAILED,
   VESA_ERR_MODE_NOT_SUPPORTED,
   VESA_ERR_MODE_NOT_SET
} VesaErr_t;

int  VesaInit( FxU16 mode );
void       *VesaGetPtr( void );
void        VesaEnd( void );
const char *VesaGetErrorString( VesaErr_t err );

#ifdef __cplusplus
}
#endif

#endif
