# Contributing

## Building

Install Rust with [rustup](https://rustup.rs/), then clone the code.

```
$ git clone git@github.com:Wilfred/difftastic.git
$ cd difftastic
```

Difftastic uses [Cargo](https://doc.rust-lang.org/cargo/) for
building.

```
$ cargo build
```

Debug builds are significantly slower than release builds. For files
with more than fifty lines, it's usually worth using an optimised
build.

```
$ cargo build --release
```

## Manual

This website is generated with
[mdbook](https://github.com/rust-lang/mdBook/). mdbook can be
installed with Cargo.

*Note: difftastic uses an older Rust toolchain version. You have to run `cargo install mdbook` outside of the repository directory. Otherwise, installation fails.*

```
$ cargo install mdbook
```

You can then use the `mdbook` binary to build and serve the site
locally.

```
$ cd manual
$ mdbook serve
```

## API Documentation

You can browse the internal API documentation generated by rustdoc
[here](https://difftastic.wilfred.me.uk/rustdoc/difft/).

Difftastic's internal docs are not available on docs.rs, as it [does
not support binary crates today](https://difftastic.wilfred.me.uk/rustdoc/difft/).

## Testing

```
$ cargo test
```

There are also several files in `sample_files/` that you can use.

The best way to test difftastic is to look at history from a real
project. Set `GIT_EXTERNAL_DIFF` to point to your current build.

For example, you can run difftastic on its own source code.

```
$ GIT_EXTERNAL_DIFF=./target/release/difft git log -p --ext-diff -- src
```

## Logging

Difftastic uses the `pretty_env_logger` library to log some additional
debug information.

```
$ DFT_LOG=debug cargo run sample_files/old.jsx sample_files/new.jsx
```

See the [`env_logger`
documentation](https://docs.rs/env_logger/0.9.0/env_logger/) for full details.

## Releasing

Use Cargo to create a new release, and tag it in git. Difftastic has a
helper script for this:

```
$ ./scripts/release.sh
```

You can now increment the version in Cargo.toml and add a new entry to
CHANGELOG.md.
