/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2025-05-17
 * Description : a G'MIC settings container
 *
 * SPDX-FileCopyrightText: 2025 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * ============================================================ */

#pragma once

// Qt includes

#include <QList>
#include <QString>
#include <QUrl>
#include <QDebug>

// Digikam includes

#include "dimg.h"

using namespace Digikam;

namespace DigikamGenericGmicQtPlugin
{

class GmicQtSettings
{
public:

    GmicQtSettings()  = default;
    ~GmicQtSettings() = default;

    /**
     * Read and write settings in config file between sessions.
     */
    void  readSettings();
    void  writeSettings();

public:

    QList<QUrl> inputImages;                                    ///< Selected items to process.
    QUrl        targetUrl;                                      ///< Target url where to store generated files by G'MIC.
    QString     templateFName   = QLatin1String("gmic_output"); ///< String used as template to name files generated by G'MIC.
    int         format          = DImg::JPEG;                   ///< Image format used to store file generated by G'MIC.
    QString     gmicCommand;                                    ///< Filters command run by G'MIC processor.
};

//! qDebug stream operator. Writes property @a t to the debug output in a nicely formatted way.
QDebug operator<<(QDebug dbg, const GmicQtSettings& t);

} // namespace DigikamGenericGmicQtPlugin
