/*
insts.c

diStorm3 - Powerful disassembler for X86/AMD64
http://ragestorm.net/distorm/
distorm at gmail dot com
Copyright (C) 2003-2021 Gil Dabah
This library is licensed under the BSD license. See the file COPYING.
*/


#include "config.h"
#include "insts.h"
#include "instructions.h"


/*
 * GENERATED BY disOps at Sat May 16 13:09:42 2020
 */

_InstInfo II_MOVSXD =	/*II*/ {0x1d7, 10027};
_InstInfo II_NOP =	/*II*/ {0x53, 581};
_InstInfo II_PAUSE =	/*II*/ {0x91, 10035};
_InstInfo II_WAIT =	/*II*/ {0x53, 10042};
_InstInfo II_RDRAND =	/*II*/ {0x1d8, 10048};
_InstInfo II_3DNOW =	/*II*/ {0x1d9, 10056};

_iflags FlagsTable[101] = {
0x80000011,
0x80000000,
0x800400,
0x80800400,
0x800080,
0x800100,
0x80800100,
0x800200,
0x80800200,
0x800000,
0x1,
0x0,
0x80800000,
0x1000000,
0x81000000,
0x808000,
0x800001,
0x80020001,
0x1002000,
0x60,
0x64,
0x80000001,
0x4010000,
0x1008000,
0x80000060,
0x83000064,
0x3000064,
0x83000000,
0x3008000,
0x200,
0xc000,
0x4014000,
0x8,
0x81000009,
0x80000009,
0x1000808,
0x81000808,
0x80020009,
0x1001008,
0x81001008,
0x80000019,
0x3000009,
0x83000009,
0x83000008,
0xc0000011,
0x40000001,
0xc0800011,
0x40800001,
0xc0000019,
0xc1000001,
0xc0000001,
0xc0000003,
0x41000000,
0x40000000,
0x40000008,
0x40000009,
0x41000001,
0x43000001,
0x40000003,
0x48000000,
0x200009,
0x20000009,
0x60020009,
0x60000009,
0x80090009,
0x200b0009,
0x20020009,
0x9,
0x80100009,
0x21100009,
0x87000009,
0x20009,
0x20000008,
0x1000009,
0x10020009,
0x160009,
0x100009,
0x47000009,
0x47090009,
0x40090009,
0x80002009,
0xc0000009,
0x2001,
0x80002001,
0x410009,
0x20420009,
0x20060009,
0x120009,
0x21020009,
0xc7000019,
0x20100009,
0xc0002009,
0x40002008,
0xc0000000,
0xc0002008,
0x4020009,
0x40100009,
0x60120009,
0x41000009,
0x83000001,
0x200001
};

_InstNode Table_0F = 256;
_InstNode Table_0F_0F = 1440;
_InstNode Table_0F_38 = 1896;
_InstNode Table_0F_3A = 2152;

_InstInfo InstInfos[1246] = {
	/*II_00*/ {0x0, 11},
	/*II_01*/ {0x1, 11},
	/*II_02*/ {0x2, 11},
	/*II_03*/ {0x3, 11},
	/*II_04*/ {0x4, 11},
	/*II_05*/ {0x5, 11},
	/*II_06*/ {0x6, 16},
	/*II_07*/ {0x7, 22},
	/*II_08*/ {0x8, 27},
	/*II_09*/ {0x9, 27},
	/*II_0A*/ {0xa, 27},
	/*II_0B*/ {0xb, 27},
	/*II_0C*/ {0xc, 27},
	/*II_0D*/ {0xd, 27},
	/*II_0E*/ {0xe, 16},
	/*II_10*/ {0xf, 31},
	/*II_11*/ {0x10, 31},
	/*II_12*/ {0x11, 31},
	/*II_13*/ {0x12, 31},
	/*II_14*/ {0x13, 31},
	/*II_15*/ {0x14, 31},
	/*II_16*/ {0x15, 16},
	/*II_17*/ {0x16, 22},
	/*II_18*/ {0xf, 36},
	/*II_19*/ {0x10, 36},
	/*II_1A*/ {0x11, 36},
	/*II_1B*/ {0x12, 36},
	/*II_1C*/ {0x13, 36},
	/*II_1D*/ {0x14, 36},
	/*II_1E*/ {0x17, 16},
	/*II_1F*/ {0x18, 22},
	/*II_20*/ {0x19, 41},
	/*II_21*/ {0x1a, 41},
	/*II_22*/ {0x1b, 41},
	/*II_23*/ {0x1c, 41},
	/*II_24*/ {0x1d, 41},
	/*II_25*/ {0x1e, 41},
	/*II_27*/ {0x1f, 46},
	/*II_28*/ {0x0, 51},
	/*II_29*/ {0x1, 51},
	/*II_2A*/ {0x2, 51},
	/*II_2B*/ {0x3, 51},
	/*II_2C*/ {0x4, 51},
	/*II_2D*/ {0x5, 51},
	/*II_2F*/ {0x1f, 56},
	/*II_30*/ {0x20, 61},
	/*II_31*/ {0x21, 61},
	/*II_32*/ {0x22, 61},
	/*II_33*/ {0x23, 61},
	/*II_34*/ {0x24, 61},
	/*II_35*/ {0x25, 61},
	/*II_37*/ {0x26, 66},
	/*II_38*/ {0x27, 71},
	/*II_39*/ {0x28, 71},
	/*II_3A*/ {0x29, 71},
	/*II_3B*/ {0x2a, 71},
	/*II_3C*/ {0x2b, 71},
	/*II_3D*/ {0x2c, 71},
	/*II_3F*/ {0x26, 76},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_60*/ {0x30, 91},
	/*II_61*/ {0x30, 98},
	/*II_62*/ {0x31, 104},
	/*II_63*/ {0x32, 111},
	/*II_68*/ {0x33, 16},
	/*II_6A*/ {0x35, 16},
	/*II_6C*/ {0x36, 123},
	/*II_6D*/ {0x37, 123},
	/*II_6E*/ {0x38, 128},
	/*II_6F*/ {0x39, 128},
	/*II_70*/ {0x3a, 134},
	/*II_71*/ {0x3a, 138},
	/*II_72*/ {0x3b, 143},
	/*II_73*/ {0x3b, 147},
	/*II_74*/ {0x3c, 152},
	/*II_75*/ {0x3c, 156},
	/*II_76*/ {0x3d, 161},
	/*II_77*/ {0x3d, 166},
	/*II_78*/ {0x3e, 170},
	/*II_79*/ {0x3e, 174},
	/*II_7A*/ {0x3f, 179},
	/*II_7B*/ {0x3f, 183},
	/*II_7C*/ {0x40, 188},
	/*II_7D*/ {0x40, 192},
	/*II_7E*/ {0x41, 197},
	/*II_7F*/ {0x41, 202},
	/*II_84*/ {0x42, 206},
	/*II_85*/ {0x43, 206},
	/*II_86*/ {0x44, 212},
	/*II_87*/ {0x45, 212},
	/*II_88*/ {0x46, 218},
	/*II_89*/ {0x47, 218},
	/*II_8A*/ {0x48, 218},
	/*II_8B*/ {0x49, 218},
	/*II_8C*/ {0x4a, 218},
	/*II_8D*/ {0x4b, 223},
	/*II_8E*/ {0x4c, 218},
	/*II_90*/ {0x4d, 212},
	/*II_91*/ {0x4d, 212},
	/*II_92*/ {0x4d, 212},
	/*II_93*/ {0x4d, 212},
	/*II_94*/ {0x4d, 212},
	/*II_95*/ {0x4d, 212},
	/*II_96*/ {0x4d, 212},
	/*II_97*/ {0x4d, 212},
	/*II_9A*/ {0x4f, 260},
	/*II_9C*/ {0x50, 270},
	/*II_9D*/ {0x51, 277},
	/*II_9E*/ {0x52, 283},
	/*II_9F*/ {0x53, 289},
	/*II_A0*/ {0x54, 218},
	/*II_A1*/ {0x55, 218},
	/*II_A2*/ {0x56, 218},
	/*II_A3*/ {0x57, 218},
	/*II_A4*/ {0x58, 295},
	/*II_A5*/ {0x59, 295},
	/*II_A6*/ {0x5a, 301},
	/*II_A7*/ {0x5b, 301},
	/*II_A8*/ {0x5c, 206},
	/*II_A9*/ {0x5d, 206},
	/*II_AA*/ {0x5e, 307},
	/*II_AB*/ {0x5f, 307},
	/*II_AC*/ {0x60, 313},
	/*II_AD*/ {0x61, 313},
	/*II_AE*/ {0x62, 319},
	/*II_AF*/ {0x63, 319},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_C2*/ {0x66, 325},
	/*II_C3*/ {0x67, 325},
	/*II_C4*/ {0x68, 330},
	/*II_C5*/ {0x68, 335},
	/*II_C8*/ {0x69, 340},
	/*II_C9*/ {0x6a, 347},
	/*II_CA*/ {0x6b, 354},
	/*II_CB*/ {0x6c, 354},
	/*II_CC*/ {0x6d, 360},
	/*II_CD*/ {0x6e, 367},
	/*II_CE*/ {0x6f, 372},
	/*II_CF*/ {0x70, 378},
	/*II_D4*/ {0x71, 384},
	/*II_D5*/ {0x71, 389},
	/*II_D6*/ {0x72, 394},
	/*II_D7*/ {0x73, 400},
	/*II_E0*/ {0x74, 406},
	/*II_E1*/ {0x74, 414},
	/*II_E2*/ {0x75, 421},
	/*II_E4*/ {0x77, 447},
	/*II_E5*/ {0x78, 447},
	/*II_E6*/ {0x79, 451},
	/*II_E7*/ {0x7a, 451},
	/*II_E8*/ {0x7b, 456},
	/*II_E9*/ {0x7c, 462},
	/*II_EA*/ {0x7d, 467},
	/*II_EB*/ {0x7e, 462},
	/*II_EC*/ {0x7f, 447},
	/*II_ED*/ {0x80, 447},
	/*II_EE*/ {0x81, 451},
	/*II_EF*/ {0x82, 451},
	/*II_F1*/ {0x6d, 476},
	/*II_F4*/ {0x83, 482},
	/*II_F5*/ {0x84, 487},
	/*II_F8*/ {0x84, 492},
	/*II_F9*/ {0x84, 497},
	/*II_FA*/ {0x85, 502},
	/*II_FB*/ {0x85, 507},
	/*II_FC*/ {0x86, 512},
	/*II_FD*/ {0x86, 517},
	/*II_0F_02*/ {0x87, 522},
	/*II_0F_03*/ {0x87, 527},
	/*II_0F_05*/ {0x88, 532},
	/*II_0F_06*/ {0x89, 541},
	/*II_0F_07*/ {0x88, 547},
	/*II_0F_08*/ {0x89, 555},
	/*II_0F_09*/ {0x89, 561},
	/*II_0F_0B*/ {0x8a, 569},
	/*II_0F_0E*/ {0x8b, 574},
	/*II_0F_1F*/ {0x8c, 581},
	/*II_0F_20*/ {0x8d, 218},
	/*II_0F_21*/ {0x8e, 218},
	/*II_0F_22*/ {0x8f, 218},
	/*II_0F_23*/ {0x90, 218},
	/*II_0F_30*/ {0x89, 586},
	/*II_0F_31*/ {0x89, 593},
	/*II_0F_32*/ {0x89, 600},
	/*II_0F_33*/ {0x89, 607},
	/*II_0F_34*/ {0x88, 614},
	/*II_0F_35*/ {0x88, 624},
	/*II_0F_37*/ {0x91, 633},
	/*II_0F_40*/ {0x92, 641},
	/*II_0F_41*/ {0x92, 648},
	/*II_0F_42*/ {0x93, 656},
	/*II_0F_43*/ {0x93, 663},
	/*II_0F_44*/ {0x94, 671},
	/*II_0F_45*/ {0x94, 678},
	/*II_0F_46*/ {0x95, 686},
	/*II_0F_47*/ {0x95, 694},
	/*II_0F_48*/ {0x96, 701},
	/*II_0F_49*/ {0x96, 708},
	/*II_0F_4A*/ {0x97, 716},
	/*II_0F_4B*/ {0x97, 723},
	/*II_0F_4C*/ {0x98, 731},
	/*II_0F_4D*/ {0x98, 738},
	/*II_0F_4E*/ {0x99, 746},
	/*II_0F_4F*/ {0x99, 754},
	/*II_0F_80*/ {0x9a, 134},
	/*II_0F_81*/ {0x9a, 138},
	/*II_0F_82*/ {0x9b, 143},
	/*II_0F_83*/ {0x9b, 147},
	/*II_0F_84*/ {0x9c, 152},
	/*II_0F_85*/ {0x9c, 156},
	/*II_0F_86*/ {0x9d, 161},
	/*II_0F_87*/ {0x9d, 166},
	/*II_0F_88*/ {0x9e, 170},
	/*II_0F_89*/ {0x9e, 174},
	/*II_0F_8A*/ {0x9f, 179},
	/*II_0F_8B*/ {0x9f, 183},
	/*II_0F_8C*/ {0xa0, 188},
	/*II_0F_8D*/ {0xa0, 192},
	/*II_0F_8E*/ {0xa1, 197},
	/*II_0F_8F*/ {0xa1, 202},
	/*II_0F_90*/ {0xa2, 761},
	/*II_0F_91*/ {0xa2, 767},
	/*II_0F_92*/ {0xa3, 774},
	/*II_0F_93*/ {0xa3, 780},
	/*II_0F_94*/ {0xa4, 787},
	/*II_0F_95*/ {0xa4, 793},
	/*II_0F_96*/ {0xa5, 800},
	/*II_0F_97*/ {0xa5, 807},
	/*II_0F_98*/ {0xa6, 813},
	/*II_0F_99*/ {0xa6, 819},
	/*II_0F_9A*/ {0xa7, 826},
	/*II_0F_9B*/ {0xa7, 832},
	/*II_0F_9C*/ {0xa8, 839},
	/*II_0F_9D*/ {0xa8, 845},
	/*II_0F_9E*/ {0xa9, 852},
	/*II_0F_9F*/ {0xa9, 859},
	/*II_0F_A0*/ {0xaa, 16},
	/*II_0F_A1*/ {0xab, 22},
	/*II_0F_A2*/ {0x91, 865},
	/*II_0F_A3*/ {0xac, 872},
	/*II_0F_A8*/ {0xae, 16},
	/*II_0F_A9*/ {0xaf, 22},
	/*II_0F_AA*/ {0xb0, 882},
	/*II_0F_AB*/ {0xb1, 887},
	/*II_0F_AF*/ {0xb2, 117},
	/*II_0F_B0*/ {0xb3, 898},
	/*II_0F_B1*/ {0xb4, 898},
	/*II_0F_B2*/ {0xb5, 907},
	/*II_0F_B3*/ {0xb1, 912},
	/*II_0F_B4*/ {0xb5, 917},
	/*II_0F_B5*/ {0xb5, 922},
	/*II_0F_B6*/ {0xb6, 927},
	/*II_0F_B7*/ {0xb7, 927},
	/*II_0F_B9*/ {0x8a, 569},
	/*II_0F_BB*/ {0xb1, 934},
	/*II_0F_BE*/ {0xb6, 939},
	/*II_0F_BF*/ {0xb7, 939},
	/*II_0F_C0*/ {0xb3, 946},
	/*II_0F_C1*/ {0xb4, 946},
	/*II_0F_C3*/ {0xb8, 952},
	/*II_0F_C8*/ {0xb9, 960},
	/*II_0F_C8*/ {0xb9, 960},
	/*II_0F_C8*/ {0xb9, 960},
	/*II_0F_C8*/ {0xb9, 960},
	/*II_0F_C8*/ {0xb9, 960},
	/*II_0F_C8*/ {0xb9, 960},
	/*II_0F_C8*/ {0xb9, 960},
	/*II_0F_C8*/ {0xb9, 960},
	/*II_80_00*/ {0xba, 11},
	/*II_80_01*/ {0xbb, 27},
	/*II_80_02*/ {0xbc, 31},
	/*II_80_03*/ {0xbc, 36},
	/*II_80_04*/ {0xbd, 41},
	/*II_80_05*/ {0xba, 51},
	/*II_80_06*/ {0xbe, 61},
	/*II_80_07*/ {0xbf, 71},
	/*II_81_00*/ {0xc0, 11},
	/*II_81_01*/ {0xc1, 27},
	/*II_81_02*/ {0xc2, 31},
	/*II_81_03*/ {0xc2, 36},
	/*II_81_04*/ {0xc3, 41},
	/*II_81_05*/ {0xc0, 51},
	/*II_81_06*/ {0xc4, 61},
	/*II_81_07*/ {0xc5, 71},
	/*II_82_00*/ {0xc6, 11},
	/*II_82_01*/ {0xc7, 27},
	/*II_82_02*/ {0xc8, 31},
	/*II_82_03*/ {0xc8, 36},
	/*II_82_04*/ {0xc9, 41},
	/*II_82_05*/ {0xc6, 51},
	/*II_82_06*/ {0xca, 61},
	/*II_82_07*/ {0xcb, 71},
	/*II_83_00*/ {0xcc, 11},
	/*II_83_01*/ {0xcd, 27},
	/*II_83_02*/ {0xce, 31},
	/*II_83_03*/ {0xce, 36},
	/*II_83_04*/ {0xcf, 41},
	/*II_83_05*/ {0xcc, 51},
	/*II_83_06*/ {0xd0, 61},
	/*II_83_07*/ {0xd1, 71},
	/*II_8F_00*/ {0xd2, 22},
	/*II_C0_00*/ {0xd3, 967},
	/*II_C0_01*/ {0xd3, 972},
	/*II_C0_02*/ {0xd4, 977},
	/*II_C0_03*/ {0xd4, 982},
	/*II_C0_04*/ {0xd5, 987},
	/*II_C0_05*/ {0xd5, 992},
	/*II_C0_06*/ {0xd5, 997},
	/*II_C0_07*/ {0xd5, 1002},
	/*II_C1_00*/ {0xd6, 967},
	/*II_C1_01*/ {0xd6, 972},
	/*II_C1_02*/ {0xd7, 977},
	/*II_C1_03*/ {0xd7, 982},
	/*II_C1_04*/ {0xd8, 987},
	/*II_C1_05*/ {0xd8, 992},
	/*II_C1_06*/ {0xd8, 997},
	/*II_C1_07*/ {0xd8, 1002},
	/*II_C6_00*/ {0xd9, 218},
	/*II_C6_F8*/ {0xda, 1007},
	/*II_C7_00*/ {0xdb, 218},
	/*II_C7_F8*/ {0xdc, 1015},
	/*II_D0_00*/ {0xdd, 967},
	/*II_D0_01*/ {0xdd, 972},
	/*II_D0_02*/ {0xde, 977},
	/*II_D0_03*/ {0xde, 982},
	/*II_D0_04*/ {0xdf, 987},
	/*II_D0_05*/ {0xdf, 992},
	/*II_D0_06*/ {0xdf, 997},
	/*II_D0_07*/ {0xdf, 1002},
	/*II_D1_00*/ {0xe0, 967},
	/*II_D1_01*/ {0xe0, 972},
	/*II_D1_02*/ {0xe1, 977},
	/*II_D1_03*/ {0xe1, 982},
	/*II_D1_04*/ {0xe2, 987},
	/*II_D1_05*/ {0xe2, 992},
	/*II_D1_06*/ {0xe2, 997},
	/*II_D1_07*/ {0xe2, 1002},
	/*II_D2_00*/ {0xe3, 967},
	/*II_D2_01*/ {0xe3, 972},
	/*II_D2_02*/ {0xe4, 977},
	/*II_D2_03*/ {0xe4, 982},
	/*II_D2_04*/ {0xe5, 987},
	/*II_D2_05*/ {0xe5, 992},
	/*II_D2_06*/ {0xe5, 997},
	/*II_D2_07*/ {0xe5, 1002},
	/*II_D3_00*/ {0xe6, 967},
	/*II_D3_01*/ {0xe6, 972},
	/*II_D3_02*/ {0xe7, 977},
	/*II_D3_03*/ {0xe7, 982},
	/*II_D3_04*/ {0xe8, 987},
	/*II_D3_05*/ {0xe8, 992},
	/*II_D3_06*/ {0xe8, 997},
	/*II_D3_07*/ {0xe8, 1002},
	/*II_D8_00*/ {0xe9, 1023},
	/*II_D8_01*/ {0xe9, 1029},
	/*II_D8_02*/ {0xe9, 1035},
	/*II_D8_03*/ {0xe9, 1041},
	/*II_D8_04*/ {0xe9, 1048},
	/*II_D8_05*/ {0xe9, 1054},
	/*II_D8_06*/ {0xe9, 1061},
	/*II_D8_07*/ {0xe9, 1067},
	/*II_D8_C0*/ {0xea, 1023},
	/*II_D8_C0*/ {0xea, 1023},
	/*II_D8_C0*/ {0xea, 1023},
	/*II_D8_C0*/ {0xea, 1023},
	/*II_D8_C0*/ {0xea, 1023},
	/*II_D8_C0*/ {0xea, 1023},
	/*II_D8_C0*/ {0xea, 1023},
	/*II_D8_C0*/ {0xea, 1023},
	/*II_D8_C8*/ {0xea, 1029},
	/*II_D8_C8*/ {0xea, 1029},
	/*II_D8_C8*/ {0xea, 1029},
	/*II_D8_C8*/ {0xea, 1029},
	/*II_D8_C8*/ {0xea, 1029},
	/*II_D8_C8*/ {0xea, 1029},
	/*II_D8_C8*/ {0xea, 1029},
	/*II_D8_C8*/ {0xea, 1029},
	/*II_D8_D0*/ {0xeb, 1035},
	/*II_D8_D0*/ {0xeb, 1035},
	/*II_D8_D0*/ {0xeb, 1035},
	/*II_D8_D0*/ {0xeb, 1035},
	/*II_D8_D0*/ {0xeb, 1035},
	/*II_D8_D0*/ {0xeb, 1035},
	/*II_D8_D0*/ {0xeb, 1035},
	/*II_D8_D0*/ {0xeb, 1035},
	/*II_D8_D8*/ {0xeb, 1041},
	/*II_D8_D9*/ {0xec, 1041},
	/*II_D8_D8*/ {0xeb, 1041},
	/*II_D8_D8*/ {0xeb, 1041},
	/*II_D8_D8*/ {0xeb, 1041},
	/*II_D8_D8*/ {0xeb, 1041},
	/*II_D8_D8*/ {0xeb, 1041},
	/*II_D8_D8*/ {0xeb, 1041},
	/*II_D8_E0*/ {0xea, 1048},
	/*II_D8_E0*/ {0xea, 1048},
	/*II_D8_E0*/ {0xea, 1048},
	/*II_D8_E0*/ {0xea, 1048},
	/*II_D8_E0*/ {0xea, 1048},
	/*II_D8_E0*/ {0xea, 1048},
	/*II_D8_E0*/ {0xea, 1048},
	/*II_D8_E0*/ {0xea, 1048},
	/*II_D8_E8*/ {0xea, 1054},
	/*II_D8_E8*/ {0xea, 1054},
	/*II_D8_E8*/ {0xea, 1054},
	/*II_D8_E8*/ {0xea, 1054},
	/*II_D8_E8*/ {0xea, 1054},
	/*II_D8_E8*/ {0xea, 1054},
	/*II_D8_E8*/ {0xea, 1054},
	/*II_D8_E8*/ {0xea, 1054},
	/*II_D8_F0*/ {0xea, 1061},
	/*II_D8_F0*/ {0xea, 1061},
	/*II_D8_F0*/ {0xea, 1061},
	/*II_D8_F0*/ {0xea, 1061},
	/*II_D8_F0*/ {0xea, 1061},
	/*II_D8_F0*/ {0xea, 1061},
	/*II_D8_F0*/ {0xea, 1061},
	/*II_D8_F0*/ {0xea, 1061},
	/*II_D8_F8*/ {0xea, 1067},
	/*II_D8_F8*/ {0xea, 1067},
	/*II_D8_F8*/ {0xea, 1067},
	/*II_D8_F8*/ {0xea, 1067},
	/*II_D8_F8*/ {0xea, 1067},
	/*II_D8_F8*/ {0xea, 1067},
	/*II_D8_F8*/ {0xea, 1067},
	/*II_D8_F8*/ {0xea, 1067},
	/*II_D9_00*/ {0xe9, 1074},
	/*II_D9_02*/ {0xed, 1079},
	/*II_D9_03*/ {0xed, 1084},
	/*II_D9_04*/ {0xee, 1090},
	/*II_D9_05*/ {0xef, 1098},
	/*II_D9_C0*/ {0xeb, 1074},
	/*II_D9_C0*/ {0xeb, 1074},
	/*II_D9_C0*/ {0xeb, 1074},
	/*II_D9_C0*/ {0xeb, 1074},
	/*II_D9_C0*/ {0xeb, 1074},
	/*II_D9_C0*/ {0xeb, 1074},
	/*II_D9_C0*/ {0xeb, 1074},
	/*II_D9_C0*/ {0xeb, 1074},
	/*II_D9_C8*/ {0xeb, 1105},
	/*II_D9_C9*/ {0xec, 1105},
	/*II_D9_C8*/ {0xeb, 1105},
	/*II_D9_C8*/ {0xeb, 1105},
	/*II_D9_C8*/ {0xeb, 1105},
	/*II_D9_C8*/ {0xeb, 1105},
	/*II_D9_C8*/ {0xeb, 1105},
	/*II_D9_C8*/ {0xeb, 1105},
	/*II_D9_D0*/ {0xec, 1111},
	/*II_D9_E0*/ {0xec, 1117},
	/*II_D9_E1*/ {0xec, 1123},
	/*II_D9_E4*/ {0xec, 1129},
	/*II_D9_E5*/ {0xec, 1135},
	/*II_D9_E8*/ {0xec, 1141},
	/*II_D9_E9*/ {0xec, 1147},
	/*II_D9_EA*/ {0xec, 1155},
	/*II_D9_EB*/ {0xec, 1163},
	/*II_D9_EC*/ {0xec, 1170},
	/*II_D9_ED*/ {0xec, 1178},
	/*II_D9_EE*/ {0xec, 1186},
	/*II_D9_F0*/ {0xec, 1192},
	/*II_D9_F1*/ {0xec, 1199},
	/*II_D9_F2*/ {0xec, 1206},
	/*II_D9_F3*/ {0xec, 1213},
	/*II_D9_F4*/ {0xec, 1221},
	/*II_D9_F5*/ {0xec, 1230},
	/*II_D9_F6*/ {0xec, 1238},
	/*II_D9_F7*/ {0xec, 1247},
	/*II_D9_F8*/ {0xec, 1256},
	/*II_D9_F9*/ {0xec, 1263},
	/*II_D9_FA*/ {0xec, 1272},
	/*II_D9_FB*/ {0xec, 1279},
	/*II_D9_FC*/ {0xec, 1288},
	/*II_D9_FD*/ {0xec, 1297},
	/*II_D9_FE*/ {0xec, 1305},
	/*II_D9_FF*/ {0xec, 1311},
	/*II_DA_00*/ {0xe9, 1317},
	/*II_DA_01*/ {0xe9, 1324},
	/*II_DA_02*/ {0xe9, 1331},
	/*II_DA_03*/ {0xe9, 1338},
	/*II_DA_04*/ {0xe9, 1346},
	/*II_DA_05*/ {0xe9, 1353},
	/*II_DA_06*/ {0xe9, 1361},
	/*II_DA_07*/ {0xe9, 1368},
	/*II_DA_C0*/ {0xf0, 1376},
	/*II_DA_C0*/ {0xf0, 1376},
	/*II_DA_C0*/ {0xf0, 1376},
	/*II_DA_C0*/ {0xf0, 1376},
	/*II_DA_C0*/ {0xf0, 1376},
	/*II_DA_C0*/ {0xf0, 1376},
	/*II_DA_C0*/ {0xf0, 1376},
	/*II_DA_C0*/ {0xf0, 1376},
	/*II_DA_C8*/ {0xf1, 1384},
	/*II_DA_C8*/ {0xf1, 1384},
	/*II_DA_C8*/ {0xf1, 1384},
	/*II_DA_C8*/ {0xf1, 1384},
	/*II_DA_C8*/ {0xf1, 1384},
	/*II_DA_C8*/ {0xf1, 1384},
	/*II_DA_C8*/ {0xf1, 1384},
	/*II_DA_C8*/ {0xf1, 1384},
	/*II_DA_D0*/ {0xf2, 1392},
	/*II_DA_D0*/ {0xf2, 1392},
	/*II_DA_D0*/ {0xf2, 1392},
	/*II_DA_D0*/ {0xf2, 1392},
	/*II_DA_D0*/ {0xf2, 1392},
	/*II_DA_D0*/ {0xf2, 1392},
	/*II_DA_D0*/ {0xf2, 1392},
	/*II_DA_D0*/ {0xf2, 1392},
	/*II_DA_D8*/ {0xf3, 1401},
	/*II_DA_D8*/ {0xf3, 1401},
	/*II_DA_D8*/ {0xf3, 1401},
	/*II_DA_D8*/ {0xf3, 1401},
	/*II_DA_D8*/ {0xf3, 1401},
	/*II_DA_D8*/ {0xf3, 1401},
	/*II_DA_D8*/ {0xf3, 1401},
	/*II_DA_D8*/ {0xf3, 1401},
	/*II_DA_E9*/ {0xec, 1409},
	/*II_DB_00*/ {0xe9, 1418},
	/*II_DB_01*/ {0xf4, 1424},
	/*II_DB_02*/ {0xed, 1432},
	/*II_DB_03*/ {0xed, 1438},
	/*II_DB_05*/ {0xf5, 1074},
	/*II_DB_07*/ {0xf6, 1084},
	/*II_DB_C0*/ {0xf0, 1445},
	/*II_DB_C0*/ {0xf0, 1445},
	/*II_DB_C0*/ {0xf0, 1445},
	/*II_DB_C0*/ {0xf0, 1445},
	/*II_DB_C0*/ {0xf0, 1445},
	/*II_DB_C0*/ {0xf0, 1445},
	/*II_DB_C0*/ {0xf0, 1445},
	/*II_DB_C0*/ {0xf0, 1445},
	/*II_DB_C8*/ {0xf1, 1454},
	/*II_DB_C8*/ {0xf1, 1454},
	/*II_DB_C8*/ {0xf1, 1454},
	/*II_DB_C8*/ {0xf1, 1454},
	/*II_DB_C8*/ {0xf1, 1454},
	/*II_DB_C8*/ {0xf1, 1454},
	/*II_DB_C8*/ {0xf1, 1454},
	/*II_DB_C8*/ {0xf1, 1454},
	/*II_DB_D0*/ {0xf2, 1463},
	/*II_DB_D0*/ {0xf2, 1463},
	/*II_DB_D0*/ {0xf2, 1463},
	/*II_DB_D0*/ {0xf2, 1463},
	/*II_DB_D0*/ {0xf2, 1463},
	/*II_DB_D0*/ {0xf2, 1463},
	/*II_DB_D0*/ {0xf2, 1463},
	/*II_DB_D0*/ {0xf2, 1463},
	/*II_DB_D8*/ {0xf3, 1473},
	/*II_DB_D8*/ {0xf3, 1473},
	/*II_DB_D8*/ {0xf3, 1473},
	/*II_DB_D8*/ {0xf3, 1473},
	/*II_DB_D8*/ {0xf3, 1473},
	/*II_DB_D8*/ {0xf3, 1473},
	/*II_DB_D8*/ {0xf3, 1473},
	/*II_DB_D8*/ {0xf3, 1473},
	/*II_DB_E0*/ {0xec, 1482},
	/*II_DB_E1*/ {0xec, 1488},
	/*II_DB_E4*/ {0xec, 1496},
	/*II_DB_E8*/ {0xf7, 1504},
	/*II_DB_E8*/ {0xf7, 1504},
	/*II_DB_E8*/ {0xf7, 1504},
	/*II_DB_E8*/ {0xf7, 1504},
	/*II_DB_E8*/ {0xf7, 1504},
	/*II_DB_E8*/ {0xf7, 1504},
	/*II_DB_E8*/ {0xf7, 1504},
	/*II_DB_E8*/ {0xf7, 1504},
	/*II_DB_F0*/ {0xf8, 1512},
	/*II_DB_F0*/ {0xf8, 1512},
	/*II_DB_F0*/ {0xf8, 1512},
	/*II_DB_F0*/ {0xf8, 1512},
	/*II_DB_F0*/ {0xf8, 1512},
	/*II_DB_F0*/ {0xf8, 1512},
	/*II_DB_F0*/ {0xf8, 1512},
	/*II_DB_F0*/ {0xf8, 1512},
	/*II_DC_00*/ {0xf9, 1023},
	/*II_DC_01*/ {0xf9, 1029},
	/*II_DC_02*/ {0xf9, 1035},
	/*II_DC_03*/ {0xf9, 1041},
	/*II_DC_04*/ {0xf9, 1048},
	/*II_DC_05*/ {0xf9, 1054},
	/*II_DC_06*/ {0xf9, 1061},
	/*II_DC_07*/ {0xf9, 1067},
	/*II_DC_C0*/ {0xfa, 1023},
	/*II_DC_C0*/ {0xfa, 1023},
	/*II_DC_C0*/ {0xfa, 1023},
	/*II_DC_C0*/ {0xfa, 1023},
	/*II_DC_C0*/ {0xfa, 1023},
	/*II_DC_C0*/ {0xfa, 1023},
	/*II_DC_C0*/ {0xfa, 1023},
	/*II_DC_C0*/ {0xfa, 1023},
	/*II_DC_C8*/ {0xfa, 1029},
	/*II_DC_C8*/ {0xfa, 1029},
	/*II_DC_C8*/ {0xfa, 1029},
	/*II_DC_C8*/ {0xfa, 1029},
	/*II_DC_C8*/ {0xfa, 1029},
	/*II_DC_C8*/ {0xfa, 1029},
	/*II_DC_C8*/ {0xfa, 1029},
	/*II_DC_C8*/ {0xfa, 1029},
	/*II_DC_E0*/ {0xfa, 1054},
	/*II_DC_E0*/ {0xfa, 1054},
	/*II_DC_E0*/ {0xfa, 1054},
	/*II_DC_E0*/ {0xfa, 1054},
	/*II_DC_E0*/ {0xfa, 1054},
	/*II_DC_E0*/ {0xfa, 1054},
	/*II_DC_E0*/ {0xfa, 1054},
	/*II_DC_E0*/ {0xfa, 1054},
	/*II_DC_E8*/ {0xfa, 1048},
	/*II_DC_E8*/ {0xfa, 1048},
	/*II_DC_E8*/ {0xfa, 1048},
	/*II_DC_E8*/ {0xfa, 1048},
	/*II_DC_E8*/ {0xfa, 1048},
	/*II_DC_E8*/ {0xfa, 1048},
	/*II_DC_E8*/ {0xfa, 1048},
	/*II_DC_E8*/ {0xfa, 1048},
	/*II_DC_F0*/ {0xfa, 1067},
	/*II_DC_F0*/ {0xfa, 1067},
	/*II_DC_F0*/ {0xfa, 1067},
	/*II_DC_F0*/ {0xfa, 1067},
	/*II_DC_F0*/ {0xfa, 1067},
	/*II_DC_F0*/ {0xfa, 1067},
	/*II_DC_F0*/ {0xfa, 1067},
	/*II_DC_F0*/ {0xfa, 1067},
	/*II_DC_F8*/ {0xfa, 1061},
	/*II_DC_F8*/ {0xfa, 1061},
	/*II_DC_F8*/ {0xfa, 1061},
	/*II_DC_F8*/ {0xfa, 1061},
	/*II_DC_F8*/ {0xfa, 1061},
	/*II_DC_F8*/ {0xfa, 1061},
	/*II_DC_F8*/ {0xfa, 1061},
	/*II_DC_F8*/ {0xfa, 1061},
	/*II_DD_00*/ {0xf9, 1074},
	/*II_DD_01*/ {0xfb, 1424},
	/*II_DD_02*/ {0xfc, 1079},
	/*II_DD_03*/ {0xfc, 1084},
	/*II_DD_04*/ {0xee, 1519},
	/*II_DD_C0*/ {0xeb, 1527},
	/*II_DD_C0*/ {0xeb, 1527},
	/*II_DD_C0*/ {0xeb, 1527},
	/*II_DD_C0*/ {0xeb, 1527},
	/*II_DD_C0*/ {0xeb, 1527},
	/*II_DD_C0*/ {0xeb, 1527},
	/*II_DD_C0*/ {0xeb, 1527},
	/*II_DD_C0*/ {0xeb, 1527},
	/*II_DD_D0*/ {0xeb, 1079},
	/*II_DD_D0*/ {0xeb, 1079},
	/*II_DD_D0*/ {0xeb, 1079},
	/*II_DD_D0*/ {0xeb, 1079},
	/*II_DD_D0*/ {0xeb, 1079},
	/*II_DD_D0*/ {0xeb, 1079},
	/*II_DD_D0*/ {0xeb, 1079},
	/*II_DD_D0*/ {0xeb, 1079},
	/*II_DD_D8*/ {0xeb, 1084},
	/*II_DD_D8*/ {0xeb, 1084},
	/*II_DD_D8*/ {0xeb, 1084},
	/*II_DD_D8*/ {0xeb, 1084},
	/*II_DD_D8*/ {0xeb, 1084},
	/*II_DD_D8*/ {0xeb, 1084},
	/*II_DD_D8*/ {0xeb, 1084},
	/*II_DD_D8*/ {0xeb, 1084},
	/*II_DD_E0*/ {0xfa, 1534},
	/*II_DD_E1*/ {0xec, 1534},
	/*II_DD_E0*/ {0xfa, 1534},
	/*II_DD_E0*/ {0xfa, 1534},
	/*II_DD_E0*/ {0xfa, 1534},
	/*II_DD_E0*/ {0xfa, 1534},
	/*II_DD_E0*/ {0xfa, 1534},
	/*II_DD_E0*/ {0xfa, 1534},
	/*II_DD_E8*/ {0xeb, 1541},
	/*II_DD_E9*/ {0xec, 1541},
	/*II_DD_E8*/ {0xeb, 1541},
	/*II_DD_E8*/ {0xeb, 1541},
	/*II_DD_E8*/ {0xeb, 1541},
	/*II_DD_E8*/ {0xeb, 1541},
	/*II_DD_E8*/ {0xeb, 1541},
	/*II_DD_E8*/ {0xeb, 1541},
	/*II_DE_00*/ {0xef, 1317},
	/*II_DE_01*/ {0xef, 1324},
	/*II_DE_02*/ {0xef, 1331},
	/*II_DE_03*/ {0xef, 1338},
	/*II_DE_04*/ {0xef, 1346},
	/*II_DE_05*/ {0xef, 1353},
	/*II_DE_06*/ {0xef, 1361},
	/*II_DE_07*/ {0xef, 1368},
	/*II_DE_C0*/ {0xfa, 1549},
	/*II_DE_C1*/ {0xec, 1549},
	/*II_DE_C0*/ {0xfa, 1549},
	/*II_DE_C0*/ {0xfa, 1549},
	/*II_DE_C0*/ {0xfa, 1549},
	/*II_DE_C0*/ {0xfa, 1549},
	/*II_DE_C0*/ {0xfa, 1549},
	/*II_DE_C0*/ {0xfa, 1549},
	/*II_DE_C8*/ {0xfa, 1556},
	/*II_DE_C9*/ {0xec, 1556},
	/*II_DE_C8*/ {0xfa, 1556},
	/*II_DE_C8*/ {0xfa, 1556},
	/*II_DE_C8*/ {0xfa, 1556},
	/*II_DE_C8*/ {0xfa, 1556},
	/*II_DE_C8*/ {0xfa, 1556},
	/*II_DE_C8*/ {0xfa, 1556},
	/*II_DE_D9*/ {0xec, 1563},
	/*II_DE_E0*/ {0xfa, 1571},
	/*II_DE_E1*/ {0xec, 1571},
	/*II_DE_E0*/ {0xfa, 1571},
	/*II_DE_E0*/ {0xfa, 1571},
	/*II_DE_E0*/ {0xfa, 1571},
	/*II_DE_E0*/ {0xfa, 1571},
	/*II_DE_E0*/ {0xfa, 1571},
	/*II_DE_E0*/ {0xfa, 1571},
	/*II_DE_E8*/ {0xfa, 1579},
	/*II_DE_E9*/ {0xec, 1579},
	/*II_DE_E8*/ {0xfa, 1579},
	/*II_DE_E8*/ {0xfa, 1579},
	/*II_DE_E8*/ {0xfa, 1579},
	/*II_DE_E8*/ {0xfa, 1579},
	/*II_DE_E8*/ {0xfa, 1579},
	/*II_DE_E8*/ {0xfa, 1579},
	/*II_DE_F0*/ {0xfa, 1586},
	/*II_DE_F1*/ {0xec, 1586},
	/*II_DE_F0*/ {0xfa, 1586},
	/*II_DE_F0*/ {0xfa, 1586},
	/*II_DE_F0*/ {0xfa, 1586},
	/*II_DE_F0*/ {0xfa, 1586},
	/*II_DE_F0*/ {0xfa, 1586},
	/*II_DE_F0*/ {0xfa, 1586},
	/*II_DE_F8*/ {0xfa, 1594},
	/*II_DE_F9*/ {0xec, 1594},
	/*II_DE_F8*/ {0xfa, 1594},
	/*II_DE_F8*/ {0xfa, 1594},
	/*II_DE_F8*/ {0xfa, 1594},
	/*II_DE_F8*/ {0xfa, 1594},
	/*II_DE_F8*/ {0xfa, 1594},
	/*II_DE_F8*/ {0xfa, 1594},
	/*II_DF_00*/ {0xef, 1418},
	/*II_DF_01*/ {0xfd, 1424},
	/*II_DF_02*/ {0xfe, 1432},
	/*II_DF_03*/ {0xfe, 1438},
	/*II_DF_04*/ {0xf5, 1601},
	/*II_DF_05*/ {0xf9, 1418},
	/*II_DF_06*/ {0xf6, 1607},
	/*II_DF_07*/ {0xfc, 1438},
	/*II_DF_E8*/ {0xf7, 1614},
	/*II_DF_E8*/ {0xf7, 1614},
	/*II_DF_E8*/ {0xf7, 1614},
	/*II_DF_E8*/ {0xf7, 1614},
	/*II_DF_E8*/ {0xf7, 1614},
	/*II_DF_E8*/ {0xf7, 1614},
	/*II_DF_E8*/ {0xf7, 1614},
	/*II_DF_E8*/ {0xf7, 1614},
	/*II_DF_F0*/ {0xf7, 1623},
	/*II_DF_F0*/ {0xf7, 1623},
	/*II_DF_F0*/ {0xf7, 1623},
	/*II_DF_F0*/ {0xf7, 1623},
	/*II_DF_F0*/ {0xf7, 1623},
	/*II_DF_F0*/ {0xf7, 1623},
	/*II_DF_F0*/ {0xf7, 1623},
	/*II_DF_F0*/ {0xf7, 1623},
	/*II_F6_00*/ {0xff, 206},
	/*II_F6_02*/ {0x100, 1631},
	/*II_F6_03*/ {0x101, 1636},
	/*II_F6_04*/ {0x102, 1641},
	/*II_F6_05*/ {0x102, 117},
	/*II_F6_06*/ {0x103, 1646},
	/*II_F6_07*/ {0x103, 1651},
	/*II_F7_00*/ {0x104, 206},
	/*II_F7_02*/ {0x105, 1631},
	/*II_F7_03*/ {0x106, 1636},
	/*II_F7_04*/ {0x107, 1641},
	/*II_F7_05*/ {0x107, 117},
	/*II_F7_06*/ {0x108, 1646},
	/*II_F7_07*/ {0x108, 1651},
	/*II_FE_00*/ {0x109, 81},
	/*II_FE_01*/ {0x109, 86},
	/*II_FF_00*/ {0x10a, 81},
	/*II_FF_01*/ {0x10a, 86},
	/*II_FF_02*/ {0x10b, 456},
	/*II_FF_03*/ {0x10c, 260},
	/*II_FF_04*/ {0x10d, 462},
	/*II_FF_05*/ {0x10e, 467},
	/*II_FF_06*/ {0x10f, 16},
	/*II_0F_00_00*/ {0x110, 1657},
	/*II_0F_00_01*/ {0x111, 1663},
	/*II_0F_00_02*/ {0x112, 1668},
	/*II_0F_00_03*/ {0x113, 1674},
	/*II_0F_00_04*/ {0x114, 1679},
	/*II_0F_00_05*/ {0x114, 1685},
	/*II_0F_01_00*/ {0x115, 1691},
	/*II_0F_01_01*/ {0x115, 1697},
	/*II_0F_01_02*/ {0x116, 1703},
	/*II_0F_01_03*/ {0x116, 1709},
	/*II_0F_01_04*/ {0x117, 1715},
	/*II_0F_01_06*/ {0x118, 1721},
	/*II_0F_01_07*/ {0x119, 1727},
	/*II_0F_01_C1*/ {0x11a, 1735},
	/*II_0F_01_C2*/ {0x11a, 1743},
	/*II_0F_01_C3*/ {0x11a, 1753},
	/*II_0F_01_C4*/ {0x11a, 1763},
	/*II_0F_01_C8*/ {0x11b, 1771},
	/*II_0F_01_C9*/ {0x11b, 1780},
	/*II_0F_01_D0*/ {0x91, 1787},
	/*II_0F_01_D1*/ {0x91, 1795},
	/*II_0F_01_D4*/ {0x11a, 1803},
	/*II_0F_01_D5*/ {0x11c, 1811},
	/*II_0F_01_D8*/ {0x11d, 1817},
	/*II_0F_01_D9*/ {0x11e, 1824},
	/*II_0F_01_DA*/ {0x11f, 1833},
	/*II_0F_01_DB*/ {0x11f, 1841},
	/*II_0F_01_DC*/ {0x11e, 1849},
	/*II_0F_01_DD*/ {0x11e, 1855},
	/*II_0F_01_DE*/ {0x11f, 1861},
	/*II_0F_01_DF*/ {0x120, 1869},
	/*II_0F_01_F8*/ {0x121, 1878},
	/*II_0F_01_F9*/ {0x121, 1886},
	/*II_0F_0D_00*/ {0x122, 1894},
	/*II_0F_0D_01*/ {0x122, 1904},
	/*II_0F_0F_0C*/ {0x123, 1915},
	/*II_0F_0F_0D*/ {0x124, 1922},
	/*II_0F_0F_1C*/ {0x123, 1929},
	/*II_0F_0F_1D*/ {0x124, 1936},
	/*II_0F_0F_8A*/ {0x123, 1943},
	/*II_0F_0F_8E*/ {0x123, 1951},
	/*II_0F_0F_90*/ {0x124, 1960},
	/*II_0F_0F_94*/ {0x124, 1969},
	/*II_0F_0F_96*/ {0x124, 1976},
	/*II_0F_0F_97*/ {0x124, 1983},
	/*II_0F_0F_9A*/ {0x124, 1992},
	/*II_0F_0F_9E*/ {0x124, 1999},
	/*II_0F_0F_A0*/ {0x124, 2006},
	/*II_0F_0F_A4*/ {0x124, 2015},
	/*II_0F_0F_A6*/ {0x124, 2022},
	/*II_0F_0F_A7*/ {0x124, 2032},
	/*II_0F_0F_AA*/ {0x124, 2042},
	/*II_0F_0F_AE*/ {0x124, 2050},
	/*II_0F_0F_B0*/ {0x124, 2057},
	/*II_0F_0F_B4*/ {0x124, 2066},
	/*II_0F_0F_B6*/ {0x124, 2073},
	/*II_0F_0F_B7*/ {0x124, 2083},
	/*II_0F_0F_BB*/ {0x123, 2092},
	/*II_0F_0F_BF*/ {0x124, 2100},
	/*II_0F_10*/ {0x125, 2109},
	/*II_66_0F_10*/ {0x126, 2117},
	/*II_F3_0F_10*/ {0x127, 2125},
	/*II_F2_0F_10*/ {0x128, 2132},
	/*II_0F_11*/ {0x12d, 2109},
	/*II_66_0F_11*/ {0x12e, 2117},
	/*II_F3_0F_11*/ {0x12f, 2125},
	/*II_F2_0F_11*/ {0x130, 2132},
	/*II_66_0F_12*/ {0x135, 2190},
	/*II_F3_0F_12*/ {0x136, 2198},
	/*II_F2_0F_12*/ {0x136, 2208},
	/*II_0F_13*/ {0x13a, 2182},
	/*II_66_0F_13*/ {0x13b, 2190},
	/*II_0F_14*/ {0x13d, 2266},
	/*II_66_0F_14*/ {0x13e, 2276},
	/*II_0F_15*/ {0x13d, 2308},
	/*II_66_0F_15*/ {0x13e, 2318},
	/*II_66_0F_16*/ {0x135, 2367},
	/*II_F3_0F_16*/ {0x140, 2375},
	/*II_0F_17*/ {0x13a, 2359},
	/*II_66_0F_17*/ {0x13b, 2367},
	/*II_0F_18_00*/ {0x141, 2424},
	/*II_0F_18_01*/ {0x141, 2437},
	/*II_0F_18_02*/ {0x141, 2449},
	/*II_0F_18_03*/ {0x141, 2461},
	/*II_0F_28*/ {0x125, 2473},
	/*II_66_0F_28*/ {0x126, 2481},
	/*II_0F_29*/ {0x12d, 2473},
	/*II_66_0F_29*/ {0x12e, 2481},
	/*II_0F_2A*/ {0x142, 2507},
	/*II_66_0F_2A*/ {0x143, 2517},
	/*II_F3_0F_2A*/ {0x144, 2527},
	/*II_F2_0F_2A*/ {0x145, 2537},
	/*II_0F_2B*/ {0x146, 2569},
	/*II_66_0F_2B*/ {0x147, 2578},
	/*II_F3_0F_2B*/ {0x148, 2587},
	/*II_F2_0F_2B*/ {0x149, 2596},
	/*II_0F_2C*/ {0x14b, 2625},
	/*II_66_0F_2C*/ {0x14c, 2636},
	/*II_F3_0F_2C*/ {0x14d, 2647},
	/*II_F2_0F_2C*/ {0x14e, 2658},
	/*II_0F_2D*/ {0x14b, 2693},
	/*II_66_0F_2D*/ {0x13e, 2703},
	/*II_F3_0F_2D*/ {0x14d, 2713},
	/*II_F2_0F_2D*/ {0x14e, 2723},
	/*II_0F_2E*/ {0x150, 2755},
	/*II_66_0F_2E*/ {0x151, 2764},
	/*II_0F_2F*/ {0x150, 2793},
	/*II_66_0F_2F*/ {0x151, 2801},
	/*II_0F_50*/ {0x154, 2827},
	/*II_66_0F_50*/ {0x155, 2837},
	/*II_0F_51*/ {0x13d, 2869},
	/*II_66_0F_51*/ {0x13e, 2877},
	/*II_F3_0F_51*/ {0x157, 2885},
	/*II_F2_0F_51*/ {0x151, 2893},
	/*II_0F_52*/ {0x13d, 2937},
	/*II_F3_0F_52*/ {0x157, 2946},
	/*II_0F_53*/ {0x13d, 2975},
	/*II_F3_0F_53*/ {0x157, 2982},
	/*II_0F_54*/ {0x13d, 3005},
	/*II_66_0F_54*/ {0x13e, 3012},
	/*II_0F_55*/ {0x13d, 3035},
	/*II_66_0F_55*/ {0x13e, 3043},
	/*II_0F_56*/ {0x13d, 3069},
	/*II_66_0F_56*/ {0x13e, 3075},
	/*II_0F_57*/ {0x13d, 3095},
	/*II_66_0F_57*/ {0x13e, 3102},
	/*II_0F_58*/ {0x13d, 3125},
	/*II_66_0F_58*/ {0x13e, 3132},
	/*II_F3_0F_58*/ {0x157, 3139},
	/*II_F2_0F_58*/ {0x151, 3146},
	/*II_0F_59*/ {0x13d, 3185},
	/*II_66_0F_59*/ {0x13e, 3192},
	/*II_F3_0F_59*/ {0x157, 3199},
	/*II_F2_0F_59*/ {0x151, 3206},
	/*II_0F_5A*/ {0x151, 3245},
	/*II_66_0F_5A*/ {0x13e, 3255},
	/*II_F3_0F_5A*/ {0x158, 3265},
	/*II_F2_0F_5A*/ {0x151, 3275},
	/*II_0F_5B*/ {0x13e, 3329},
	/*II_66_0F_5B*/ {0x13e, 3339},
	/*II_F3_0F_5B*/ {0x13e, 3349},
	/*II_0F_5C*/ {0x13d, 3394},
	/*II_66_0F_5C*/ {0x13e, 3401},
	/*II_F3_0F_5C*/ {0x157, 3408},
	/*II_F2_0F_5C*/ {0x151, 3415},
	/*II_0F_5D*/ {0x13d, 3454},
	/*II_66_0F_5D*/ {0x13e, 3461},
	/*II_F3_0F_5D*/ {0x157, 3468},
	/*II_F2_0F_5D*/ {0x151, 3475},
	/*II_0F_5E*/ {0x13d, 3514},
	/*II_66_0F_5E*/ {0x13e, 3521},
	/*II_F3_0F_5E*/ {0x157, 3528},
	/*II_F2_0F_5E*/ {0x151, 3535},
	/*II_0F_5F*/ {0x13d, 3574},
	/*II_66_0F_5F*/ {0x13e, 3581},
	/*II_F3_0F_5F*/ {0x157, 3588},
	/*II_F2_0F_5F*/ {0x151, 3595},
	/*II_0F_60*/ {0x15b, 3634},
	/*II_66_0F_60*/ {0x13e, 3634},
	/*II_0F_61*/ {0x15b, 3657},
	/*II_66_0F_61*/ {0x13e, 3657},
	/*II_0F_62*/ {0x15b, 3680},
	/*II_66_0F_62*/ {0x13e, 3680},
	/*II_0F_63*/ {0x15c, 3703},
	/*II_66_0F_63*/ {0x13e, 3703},
	/*II_0F_64*/ {0x15c, 3724},
	/*II_66_0F_64*/ {0x13e, 3724},
	/*II_0F_65*/ {0x15c, 3743},
	/*II_66_0F_65*/ {0x13e, 3743},
	/*II_0F_66*/ {0x15c, 3762},
	/*II_66_0F_66*/ {0x13e, 3762},
	/*II_0F_67*/ {0x15c, 3781},
	/*II_66_0F_67*/ {0x13e, 3781},
	/*II_0F_68*/ {0x15c, 3802},
	/*II_66_0F_68*/ {0x13e, 3802},
	/*II_0F_69*/ {0x15c, 3825},
	/*II_66_0F_69*/ {0x13e, 3825},
	/*II_0F_6A*/ {0x15c, 3848},
	/*II_66_0F_6A*/ {0x13e, 3848},
	/*II_0F_6B*/ {0x15c, 3871},
	/*II_66_0F_6B*/ {0x13e, 3871},
	/*II_66_0F_6C*/ {0x13e, 3892},
	/*II_66_0F_6D*/ {0x13e, 3917},
	/*II_0F_6F*/ {0x160, 3948},
	/*II_66_0F_6F*/ {0x126, 3968},
	/*II_F3_0F_6F*/ {0x126, 3976},
	/*II_0F_74*/ {0x15c, 4065},
	/*II_66_0F_74*/ {0x13e, 4065},
	/*II_0F_75*/ {0x15c, 4084},
	/*II_66_0F_75*/ {0x13e, 4084},
	/*II_0F_76*/ {0x15c, 4103},
	/*II_66_0F_76*/ {0x13e, 4103},
	/*II_0F_77*/ {0x164, 4122},
	/*II_0F_78*/ {0x166, 4150},
	/*II_0F_79*/ {0x169, 4174},
	/*II_66_0F_79*/ {0x16a, 4158},
	/*II_F2_0F_79*/ {0x16b, 4165},
	/*II_0F_7A_30*/ {0x16c, 4183},
	/*II_0F_7A_31*/ {0x16d, 4193},
	/*II_66_0F_7C*/ {0x16e, 4203},
	/*II_F2_0F_7C*/ {0x16e, 4211},
	/*II_66_0F_7D*/ {0x16e, 4237},
	/*II_F2_0F_7D*/ {0x16e, 4245},
	/*II_F3_0F_7E*/ {0x128, 3948},
	/*II_0F_7F*/ {0x172, 3948},
	/*II_66_0F_7F*/ {0x12e, 3968},
	/*II_F3_0F_7F*/ {0x12e, 3976},
	/*II_F3_0F_B8*/ {0x176, 4360},
	/*II_0F_BA_04*/ {0x177, 872},
	/*II_0F_BA_05*/ {0x178, 887},
	/*II_0F_BA_06*/ {0x178, 912},
	/*II_0F_BA_07*/ {0x178, 934},
	/*II_0F_BC*/ {0x179, 4368},
	/*II_F3_0F_BC*/ {0x17a, 4373},
	/*II_0F_BD*/ {0x179, 4380},
	/*II_F3_0F_BD*/ {0x17b, 4385},
	/*II_0F_C7_07*/ {0x18b, 6407},
	/*II_66_0F_D0*/ {0x16e, 6416},
	/*II_F2_0F_D0*/ {0x16e, 6426},
	/*II_0F_D1*/ {0x15c, 6458},
	/*II_66_0F_D1*/ {0x13e, 6458},
	/*II_0F_D2*/ {0x15c, 6473},
	/*II_66_0F_D2*/ {0x13e, 6473},
	/*II_0F_D3*/ {0x15c, 6488},
	/*II_66_0F_D3*/ {0x13e, 6488},
	/*II_0F_D4*/ {0x151, 6503},
	/*II_66_0F_D4*/ {0x13e, 6503},
	/*II_0F_D5*/ {0x15c, 6518},
	/*II_66_0F_D5*/ {0x13e, 6518},
	/*II_66_0F_D6*/ {0x130, 3948},
	/*II_F3_0F_D6*/ {0x18c, 6535},
	/*II_F2_0F_D6*/ {0x18d, 6544},
	/*II_0F_D7*/ {0x18f, 6553},
	/*II_66_0F_D7*/ {0x190, 6553},
	/*II_0F_D8*/ {0x15c, 6574},
	/*II_66_0F_D8*/ {0x13e, 6574},
	/*II_0F_D9*/ {0x15c, 6593},
	/*II_66_0F_D9*/ {0x13e, 6593},
	/*II_0F_DA*/ {0x192, 6612},
	/*II_66_0F_DA*/ {0x13e, 6612},
	/*II_0F_DB*/ {0x15c, 6629},
	/*II_66_0F_DB*/ {0x13e, 6629},
	/*II_0F_DC*/ {0x15c, 6642},
	/*II_66_0F_DC*/ {0x13e, 6642},
	/*II_0F_DD*/ {0x15c, 6661},
	/*II_66_0F_DD*/ {0x13e, 6661},
	/*II_0F_DE*/ {0x192, 6670},
	/*II_66_0F_DE*/ {0x13e, 6670},
	/*II_0F_DF*/ {0x15c, 6687},
	/*II_66_0F_DF*/ {0x13e, 6687},
	/*II_0F_E0*/ {0x192, 6702},
	/*II_66_0F_E0*/ {0x13e, 6702},
	/*II_0F_E1*/ {0x15c, 6717},
	/*II_66_0F_E1*/ {0x13e, 6717},
	/*II_0F_E2*/ {0x15c, 6732},
	/*II_66_0F_E2*/ {0x13e, 6732},
	/*II_0F_E3*/ {0x192, 6747},
	/*II_66_0F_E3*/ {0x13e, 6747},
	/*II_0F_E4*/ {0x192, 6762},
	/*II_66_0F_E4*/ {0x13e, 6762},
	/*II_0F_E5*/ {0x15c, 6781},
	/*II_66_0F_E5*/ {0x13e, 6781},
	/*II_66_0F_E6*/ {0x13e, 6798},
	/*II_F3_0F_E6*/ {0x151, 6809},
	/*II_F2_0F_E6*/ {0x13e, 6819},
	/*II_0F_E7*/ {0x193, 6863},
	/*II_66_0F_E7*/ {0x147, 6871},
	/*II_0F_E8*/ {0x15c, 6890},
	/*II_66_0F_E8*/ {0x13e, 6890},
	/*II_0F_E9*/ {0x15c, 6907},
	/*II_66_0F_E9*/ {0x13e, 6907},
	/*II_0F_EA*/ {0x192, 6924},
	/*II_66_0F_EA*/ {0x13e, 6924},
	/*II_0F_EB*/ {0x15c, 6941},
	/*II_66_0F_EB*/ {0x13e, 6941},
	/*II_0F_EC*/ {0x15c, 6952},
	/*II_66_0F_EC*/ {0x13e, 6952},
	/*II_0F_ED*/ {0x15c, 6969},
	/*II_66_0F_ED*/ {0x13e, 6969},
	/*II_0F_EE*/ {0x192, 6986},
	/*II_66_0F_EE*/ {0x13e, 6986},
	/*II_0F_EF*/ {0x15c, 7003},
	/*II_66_0F_EF*/ {0x13e, 7003},
	/*II_F2_0F_F0*/ {0x194, 7016},
	/*II_0F_F1*/ {0x15c, 7031},
	/*II_66_0F_F1*/ {0x13e, 7031},
	/*II_0F_F2*/ {0x15c, 7046},
	/*II_66_0F_F2*/ {0x13e, 7046},
	/*II_0F_F3*/ {0x15c, 7061},
	/*II_66_0F_F3*/ {0x13e, 7061},
	/*II_0F_F4*/ {0x196, 7076},
	/*II_66_0F_F4*/ {0x13e, 7076},
	/*II_0F_F5*/ {0x15c, 7095},
	/*II_66_0F_F5*/ {0x13e, 7095},
	/*II_0F_F6*/ {0x192, 7114},
	/*II_66_0F_F6*/ {0x13e, 7114},
	/*II_0F_F7*/ {0x197, 7131},
	/*II_66_0F_F7*/ {0x198, 7141},
	/*II_0F_F8*/ {0x15c, 7166},
	/*II_66_0F_F8*/ {0x13e, 7166},
	/*II_0F_F9*/ {0x15c, 7181},
	/*II_66_0F_F9*/ {0x13e, 7181},
	/*II_0F_FA*/ {0x15c, 7196},
	/*II_66_0F_FA*/ {0x13e, 7196},
	/*II_0F_FB*/ {0x196, 7211},
	/*II_66_0F_FB*/ {0x13e, 7211},
	/*II_0F_FC*/ {0x15c, 7226},
	/*II_66_0F_FC*/ {0x13e, 7226},
	/*II_0F_FD*/ {0x15c, 7241},
	/*II_66_0F_FD*/ {0x13e, 7241},
	/*II_0F_FE*/ {0x15c, 7256},
	/*II_66_0F_FE*/ {0x13e, 7256},
	/*II_D9_06*/ {0x19a, 7271},
	/*II_9B_D9_06*/ {0x19b, 7280},
	/*II_D9_07*/ {0xfe, 7288},
	/*II_9B_D9_07*/ {0x19c, 7296},
	/*II_DB_E2*/ {0xec, 7303},
	/*II_9B_DB_E2*/ {0x19d, 7311},
	/*II_DB_E3*/ {0xec, 7318},
	/*II_9B_DB_E3*/ {0x19d, 7326},
	/*II_DD_06*/ {0x19a, 7333},
	/*II_9B_DD_06*/ {0x19b, 7341},
	/*II_DD_07*/ {0xfe, 7348},
	/*II_9B_DD_07*/ {0x19c, 7356},
	/*II_DF_E0*/ {0x19e, 7348},
	/*II_9B_DF_E0*/ {0x19f, 7356},
	/*II_0F_38_00*/ {0x1a0, 7363},
	/*II_66_0F_38_00*/ {0x1a1, 7363},
	/*II_0F_38_01*/ {0x1a0, 7380},
	/*II_66_0F_38_01*/ {0x1a1, 7380},
	/*II_0F_38_02*/ {0x1a0, 7397},
	/*II_66_0F_38_02*/ {0x1a1, 7397},
	/*II_0F_38_03*/ {0x1a0, 7414},
	/*II_66_0F_38_03*/ {0x1a1, 7414},
	/*II_0F_38_04*/ {0x1a0, 7433},
	/*II_66_0F_38_04*/ {0x1a1, 7433},
	/*II_0F_38_05*/ {0x1a0, 7456},
	/*II_66_0F_38_05*/ {0x1a1, 7456},
	/*II_0F_38_06*/ {0x1a0, 7473},
	/*II_66_0F_38_06*/ {0x1a1, 7473},
	/*II_0F_38_07*/ {0x1a0, 7490},
	/*II_66_0F_38_07*/ {0x1a1, 7490},
	/*II_0F_38_08*/ {0x1a0, 7509},
	/*II_66_0F_38_08*/ {0x1a1, 7509},
	/*II_0F_38_09*/ {0x1a0, 7526},
	/*II_66_0F_38_09*/ {0x1a1, 7526},
	/*II_0F_38_0A*/ {0x1a0, 7543},
	/*II_66_0F_38_0A*/ {0x1a1, 7543},
	/*II_0F_38_0B*/ {0x1a0, 7560},
	/*II_66_0F_38_0B*/ {0x1a1, 7560},
	/*II_66_0F_38_17*/ {0x1a3, 7651},
	/*II_0F_38_1C*/ {0x1a0, 7710},
	/*II_66_0F_38_1C*/ {0x1a1, 7710},
	/*II_0F_38_1D*/ {0x1a0, 7725},
	/*II_66_0F_38_1D*/ {0x1a1, 7725},
	/*II_0F_38_1E*/ {0x1a0, 7740},
	/*II_66_0F_38_1E*/ {0x1a1, 7740},
	/*II_66_0F_38_20*/ {0x1a8, 7755},
	/*II_66_0F_38_21*/ {0x1a9, 7776},
	/*II_66_0F_38_22*/ {0x1aa, 7797},
	/*II_66_0F_38_23*/ {0x1a8, 7818},
	/*II_66_0F_38_24*/ {0x1a9, 7839},
	/*II_66_0F_38_25*/ {0x1a8, 7860},
	/*II_66_0F_38_28*/ {0x1ac, 7881},
	/*II_66_0F_38_29*/ {0x1ac, 7898},
	/*II_66_0F_38_2A*/ {0x1ad, 7917},
	/*II_66_0F_38_2B*/ {0x1ac, 7938},
	/*II_66_0F_38_30*/ {0x1a8, 7983},
	/*II_66_0F_38_31*/ {0x1a9, 8004},
	/*II_66_0F_38_32*/ {0x1aa, 8025},
	/*II_66_0F_38_33*/ {0x1a8, 8046},
	/*II_66_0F_38_34*/ {0x1a9, 8067},
	/*II_66_0F_38_35*/ {0x1a8, 8088},
	/*II_66_0F_38_37*/ {0x1a3, 8109},
	/*II_66_0F_38_38*/ {0x1ac, 8128},
	/*II_66_0F_38_39*/ {0x1ac, 8145},
	/*II_66_0F_38_3A*/ {0x1ac, 8162},
	/*II_66_0F_38_3B*/ {0x1ac, 8179},
	/*II_66_0F_38_3C*/ {0x1ac, 8196},
	/*II_66_0F_38_3D*/ {0x1ac, 8213},
	/*II_66_0F_38_3E*/ {0x1ac, 8230},
	/*II_66_0F_38_3F*/ {0x1ac, 8247},
	/*II_66_0F_38_40*/ {0x1ac, 8264},
	/*II_66_0F_38_41*/ {0x1ac, 8281},
	/*II_66_0F_38_80*/ {0x1b0, 8306},
	/*II_66_0F_38_81*/ {0x1b0, 8314},
	/*II_66_0F_38_82*/ {0x1b0, 8323},
	/*II_66_0F_38_DB*/ {0x1b3, 9172},
	/*II_66_0F_38_DC*/ {0x1b3, 9189},
	/*II_66_0F_38_DD*/ {0x1b3, 9206},
	/*II_66_0F_38_DE*/ {0x1b3, 9231},
	/*II_66_0F_38_DF*/ {0x1b3, 9248},
	/*II_0F_38_F0*/ {0x1b6, 9273},
	/*II_F2_0F_38_F0*/ {0x1b7, 9280},
	/*II_0F_38_F1*/ {0x1b8, 9273},
	/*II_F2_0F_38_F1*/ {0x1b9, 9280},
	/*II_0F_71_02*/ {0x1d0, 6458},
	/*II_66_0F_71_02*/ {0x1d1, 6458},
	/*II_0F_71_04*/ {0x1d0, 6717},
	/*II_66_0F_71_04*/ {0x1d1, 6717},
	/*II_0F_71_06*/ {0x1d0, 7031},
	/*II_66_0F_71_06*/ {0x1d1, 7031},
	/*II_0F_72_02*/ {0x1d0, 6473},
	/*II_66_0F_72_02*/ {0x1d1, 6473},
	/*II_0F_72_04*/ {0x1d0, 6732},
	/*II_66_0F_72_04*/ {0x1d1, 6732},
	/*II_0F_72_06*/ {0x1d0, 7046},
	/*II_66_0F_72_06*/ {0x1d1, 7046},
	/*II_0F_73_02*/ {0x1d0, 6488},
	/*II_66_0F_73_02*/ {0x1d1, 6488},
	/*II_66_0F_73_03*/ {0x1d1, 9852},
	/*II_0F_73_06*/ {0x1d0, 7061},
	/*II_66_0F_73_06*/ {0x1d1, 7061},
	/*II_66_0F_73_07*/ {0x1d1, 9869},
	/*II_F3_0F_AE_00*/ {0x1d3, 9904},
	/*II_F3_0F_AE_01*/ {0x1d3, 9934},
	/*II_0F_AE_02*/ {0x1d4, 9944},
	/*II_F3_0F_AE_02*/ {0x1d3, 9953},
	/*II_0F_AE_03*/ {0x1d4, 9973},
	/*II_F3_0F_AE_03*/ {0x1d3, 9982},
	/*II_0F_C7_06*/ {0x1d6, 10002},
	/*II_66_0F_C7_06*/ {0x18b, 10011},
	/*II_F3_0F_C7_06*/ {0x18b, 10020}
};

_InstInfoEx InstInfosEx[381] = {
	/*II_69*/ {{0x34, 117}, 0x0, 3, 0, 0, 0},
	/*II_6B*/ {{0x34, 117}, 0x0, 5, 0, 0, 0},
	/*II_98*/ {{0x4e, 228}, 0x0, 0, 0, 233, 239},
	/*II_99*/ {{0x4e, 245}, 0x0, 0, 0, 250, 255},
	/*II_E3*/ {{0x76, 427}, 0x0, 0, 0, 433, 440},
	/*II_0F_A4*/ {{0xad, 876}, 0x0, 1, 0, 0, 0},
	/*II_0F_A5*/ {{0xad, 876}, 0x0, 42, 0, 0, 0},
	/*II_0F_AC*/ {{0xad, 892}, 0x0, 1, 0, 0, 0},
	/*II_0F_AD*/ {{0xad, 892}, 0x0, 42, 0, 0, 0},
	/*II_V_0F_10*/ {{0x129, 2139}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_10*/ {{0x129, 2148}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_10*/ {{0x12a, 2157}, 0x20, 31, 0, 0, 0},
	/*II_V_F2_0F_10*/ {{0x12a, 2165}, 0x20, 31, 0, 0, 0},
	/*II_VRR_F3_0F_10*/ {{0x12b, 2157}, 0x60, 0, 0, 0, 0},
	/*II_VRR_F2_0F_10*/ {{0x12c, 2165}, 0x60, 0, 0, 0, 0},
	/*II_V_0F_11*/ {{0x131, 2139}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_11*/ {{0x131, 2148}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_11*/ {{0x12a, 2157}, 0x20, 31, 0, 0, 0},
	/*II_V_F2_0F_11*/ {{0x12a, 2165}, 0x20, 31, 0, 0, 0},
	/*II_VRR_F3_0F_11*/ {{0x132, 2157}, 0x60, 0, 0, 0, 0},
	/*II_VRR_F2_0F_11*/ {{0x133, 2165}, 0x60, 0, 0, 0, 0},
	/*II_0F_12*/ {{0x134, 2173}, 0x0, 0, 0, 2182, 0},
	/*II_V_0F_12*/ {{0x137, 2217}, 0x0, 86, 0, 2227, 0},
	/*II_V_66_0F_12*/ {{0x138, 2236}, 0x0, 57, 0, 0, 0},
	/*II_V_F3_0F_12*/ {{0x129, 2245}, 0x41, 0, 0, 0, 0},
	/*II_V_F2_0F_12*/ {{0x139, 2256}, 0x41, 0, 0, 0, 0},
	/*II_V_0F_13*/ {{0x13c, 2227}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_13*/ {{0x13c, 2236}, 0x40, 0, 0, 0, 0},
	/*II_V_0F_14*/ {{0x13f, 2286}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_14*/ {{0x13f, 2297}, 0x1, 91, 0, 0, 0},
	/*II_V_0F_15*/ {{0x13f, 2328}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_15*/ {{0x13f, 2339}, 0x1, 91, 0, 0, 0},
	/*II_0F_16*/ {{0x134, 2350}, 0x0, 0, 0, 2359, 0},
	/*II_V_0F_16*/ {{0x137, 2385}, 0x0, 86, 0, 2395, 0},
	/*II_V_66_0F_16*/ {{0x138, 2404}, 0x0, 57, 0, 0, 0},
	/*II_V_F3_0F_16*/ {{0x129, 2413}, 0x41, 0, 0, 0, 0},
	/*II_V_0F_17*/ {{0x13c, 2395}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_17*/ {{0x13c, 2404}, 0x40, 0, 0, 0, 0},
	/*II_V_0F_28*/ {{0x129, 2489}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_28*/ {{0x129, 2498}, 0x41, 0, 0, 0, 0},
	/*II_V_0F_29*/ {{0x131, 2489}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_29*/ {{0x131, 2498}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_2A*/ {{0x138, 2547}, 0x2, 73, 0, 0, 0},
	/*II_V_F2_0F_2A*/ {{0x138, 2558}, 0x2, 73, 0, 0, 0},
	/*II_V_0F_2B*/ {{0x14a, 2605}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_2B*/ {{0x14a, 2615}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_2C*/ {{0x14f, 2669}, 0x42, 0, 0, 0, 0},
	/*II_V_F2_0F_2C*/ {{0x14f, 2681}, 0x42, 0, 0, 0, 0},
	/*II_V_F3_0F_2D*/ {{0x14f, 2733}, 0x42, 0, 0, 0, 0},
	/*II_V_F2_0F_2D*/ {{0x14f, 2744}, 0x42, 0, 0, 0, 0},
	/*II_V_0F_2E*/ {{0x152, 2773}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_2E*/ {{0x153, 2783}, 0x40, 0, 0, 0, 0},
	/*II_V_0F_2F*/ {{0x152, 2809}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_2F*/ {{0x153, 2818}, 0x40, 0, 0, 0, 0},
	/*II_V_0F_50*/ {{0x156, 2847}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_50*/ {{0x156, 2858}, 0x41, 0, 0, 0, 0},
	/*II_V_0F_51*/ {{0x129, 2901}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_51*/ {{0x129, 2910}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_51*/ {{0x138, 2919}, 0x0, 85, 0, 0, 0},
	/*II_V_F2_0F_51*/ {{0x138, 2928}, 0x0, 86, 0, 0, 0},
	/*II_V_0F_52*/ {{0x129, 2955}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_52*/ {{0x138, 2965}, 0x0, 85, 0, 0, 0},
	/*II_V_0F_53*/ {{0x129, 2989}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_53*/ {{0x138, 2997}, 0x0, 85, 0, 0, 0},
	/*II_V_0F_54*/ {{0x13f, 3019}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_54*/ {{0x13f, 3027}, 0x1, 91, 0, 0, 0},
	/*II_V_0F_55*/ {{0x13f, 3051}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_55*/ {{0x13f, 3060}, 0x1, 91, 0, 0, 0},
	/*II_V_0F_56*/ {{0x13f, 3081}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_56*/ {{0x13f, 3088}, 0x1, 91, 0, 0, 0},
	/*II_V_0F_57*/ {{0x13f, 3109}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_57*/ {{0x13f, 3117}, 0x1, 91, 0, 0, 0},
	/*II_V_0F_58*/ {{0x13f, 3153}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_58*/ {{0x13f, 3161}, 0x1, 91, 0, 0, 0},
	/*II_V_F3_0F_58*/ {{0x138, 3169}, 0x0, 85, 0, 0, 0},
	/*II_V_F2_0F_58*/ {{0x138, 3177}, 0x0, 86, 0, 0, 0},
	/*II_V_0F_59*/ {{0x13f, 3213}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_59*/ {{0x13f, 3221}, 0x1, 91, 0, 0, 0},
	/*II_V_F3_0F_59*/ {{0x138, 3229}, 0x0, 85, 0, 0, 0},
	/*II_V_F2_0F_59*/ {{0x138, 3237}, 0x0, 86, 0, 0, 0},
	/*II_V_0F_5A*/ {{0x159, 3285}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_5A*/ {{0x15a, 3296}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_5A*/ {{0x138, 3307}, 0x0, 85, 0, 0, 0},
	/*II_V_F2_0F_5A*/ {{0x138, 3318}, 0x0, 86, 0, 0, 0},
	/*II_V_0F_5B*/ {{0x129, 3360}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_5B*/ {{0x129, 3371}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_5B*/ {{0x129, 3382}, 0x41, 0, 0, 0, 0},
	/*II_V_0F_5C*/ {{0x13f, 3422}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_5C*/ {{0x13f, 3430}, 0x1, 91, 0, 0, 0},
	/*II_V_F3_0F_5C*/ {{0x138, 3438}, 0x0, 85, 0, 0, 0},
	/*II_V_F2_0F_5C*/ {{0x138, 3446}, 0x0, 86, 0, 0, 0},
	/*II_V_0F_5D*/ {{0x13f, 3482}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_5D*/ {{0x13f, 3490}, 0x1, 91, 0, 0, 0},
	/*II_V_F3_0F_5D*/ {{0x138, 3498}, 0x0, 85, 0, 0, 0},
	/*II_V_F2_0F_5D*/ {{0x138, 3506}, 0x0, 86, 0, 0, 0},
	/*II_V_0F_5E*/ {{0x13f, 3542}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_5E*/ {{0x13f, 3550}, 0x1, 91, 0, 0, 0},
	/*II_V_F3_0F_5E*/ {{0x138, 3558}, 0x0, 85, 0, 0, 0},
	/*II_V_F2_0F_5E*/ {{0x138, 3566}, 0x0, 86, 0, 0, 0},
	/*II_V_0F_5F*/ {{0x13f, 3602}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_5F*/ {{0x13f, 3610}, 0x1, 91, 0, 0, 0},
	/*II_V_F3_0F_5F*/ {{0x138, 3618}, 0x0, 85, 0, 0, 0},
	/*II_V_F2_0F_5F*/ {{0x138, 3626}, 0x0, 86, 0, 0, 0},
	/*II_V_66_0F_60*/ {{0x138, 3645}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_61*/ {{0x138, 3668}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_62*/ {{0x138, 3691}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_63*/ {{0x138, 3713}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_64*/ {{0x138, 3733}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_65*/ {{0x138, 3752}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_66*/ {{0x138, 3771}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_67*/ {{0x138, 3791}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_68*/ {{0x138, 3813}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_69*/ {{0x138, 3836}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_6A*/ {{0x138, 3859}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_6B*/ {{0x138, 3881}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_6C*/ {{0x138, 3904}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_6D*/ {{0x138, 3929}, 0x0, 87, 0, 0, 0},
	/*II_0F_6E*/ {{0x15d, 3942}, 0x0, 0, 0, 0, 3948},
	/*II_66_0F_6E*/ {{0x15e, 3942}, 0x0, 0, 0, 0, 3948},
	/*II_V_66_0F_6E*/ {{0x15f, 3954}, 0x46, 0, 0, 3961, 0},
	/*II_V_66_0F_6F*/ {{0x129, 3984}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_6F*/ {{0x129, 3993}, 0x41, 0, 0, 0, 0},
	/*II_0F_70*/ {{0x161, 4002}, 0x0, 1, 0, 0, 0},
	/*II_66_0F_70*/ {{0x162, 4010}, 0x0, 1, 0, 0, 0},
	/*II_F3_0F_70*/ {{0x162, 4018}, 0x0, 1, 0, 0, 0},
	/*II_F2_0F_70*/ {{0x162, 4027}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_70*/ {{0x163, 4036}, 0x40, 1, 0, 0, 0},
	/*II_V_F3_0F_70*/ {{0x163, 4045}, 0x40, 1, 0, 0, 0},
	/*II_V_F2_0F_70*/ {{0x163, 4055}, 0x40, 1, 0, 0, 0},
	/*II_V_66_0F_74*/ {{0x138, 4074}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_75*/ {{0x138, 4093}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_76*/ {{0x138, 4112}, 0x0, 87, 0, 0, 0},
	/*II_V_0F_77*/ {{0x165, 4128}, 0x49, 0, 0, 4140, 0},
	/*II_66_0F_78*/ {{0x167, 4158}, 0x0, 49, 0, 0, 0},
	/*II_F2_0F_78*/ {{0x168, 4165}, 0x0, 48, 49, 0, 0},
	/*II_V_66_0F_7C*/ {{0x13f, 4219}, 0x1, 91, 0, 0, 0},
	/*II_V_F2_0F_7C*/ {{0x13f, 4228}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_7D*/ {{0x13f, 4253}, 0x1, 91, 0, 0, 0},
	/*II_V_F2_0F_7D*/ {{0x13f, 4262}, 0x1, 91, 0, 0, 0},
	/*II_0F_7E*/ {{0x16f, 3942}, 0x0, 0, 0, 0, 3948},
	/*II_66_0F_7E*/ {{0x170, 3942}, 0x0, 0, 0, 0, 3948},
	/*II_V_66_0F_7E*/ {{0x171, 3954}, 0x46, 0, 0, 3961, 0},
	/*II_V_F3_0F_7E*/ {{0x153, 3961}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_7F*/ {{0x131, 3984}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_7F*/ {{0x131, 3993}, 0x41, 0, 0, 0, 0},
	/*II_0F_AE_04*/ {{0x173, 4271}, 0x0, 0, 0, 0, 4278},
	/*II_0F_AE_05*/ {{0x174, 4287}, 0x0, 0, 0, 4295, 4303},
	/*II_0F_AE_06*/ {{0x174, 4313}, 0x0, 0, 0, 4321, 4331},
	/*II_0F_AE_07*/ {{0x175, 4343}, 0x0, 0, 0, 4351, 0},
	/*II_0F_C2*/ {{0x17c, 4392}, 0x0, 0, 0, 4401, 4410},
	/*II_66_0F_C2*/ {{0x17d, 4471}, 0x0, 0, 0, 4480, 4489},
	/*II_F3_0F_C2*/ {{0x17e, 4550}, 0x0, 0, 0, 4559, 4568},
	/*II_F2_0F_C2*/ {{0x17f, 4629}, 0x0, 0, 0, 4638, 4647},
	/*II_V_0F_C2*/ {{0x180, 4708}, 0x1, 91, 0, 4718, 4728},
	/*II_V_66_0F_C2*/ {{0x180, 5110}, 0x1, 91, 0, 5120, 5130},
	/*II_V_F3_0F_C2*/ {{0x181, 5512}, 0x0, 85, 0, 5522, 5532},
	/*II_V_F2_0F_C2*/ {{0x181, 5914}, 0x0, 86, 0, 5924, 5934},
	/*II_0F_C4*/ {{0x182, 6316}, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C4*/ {{0x183, 6316}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_C4*/ {{0x184, 6324}, 0x0, 79, 1, 0, 0},
	/*II_0F_C5*/ {{0x185, 6333}, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C5*/ {{0x186, 6333}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_C5*/ {{0x187, 6341}, 0x40, 1, 0, 0, 0},
	/*II_0F_C6*/ {{0x188, 6350}, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C6*/ {{0x162, 6358}, 0x0, 1, 0, 0, 0},
	/*II_V_0F_C6*/ {{0x189, 6366}, 0x1, 91, 1, 0, 0},
	/*II_V_66_0F_C6*/ {{0x189, 6375}, 0x1, 91, 1, 0, 0},
	/*II_0F_C7_01*/ {{0x18a, 6384}, 0x0, 0, 0, 0, 6395},
	/*II_V_66_0F_D0*/ {{0x13f, 6436}, 0x1, 91, 0, 0, 0},
	/*II_V_F2_0F_D0*/ {{0x13f, 6447}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_D1*/ {{0x138, 6465}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_D2*/ {{0x138, 6480}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_D3*/ {{0x138, 6495}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_D4*/ {{0x138, 6510}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_D5*/ {{0x138, 6526}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_D6*/ {{0x18e, 3961}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_D7*/ {{0x191, 6563}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_D8*/ {{0x138, 6583}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_D9*/ {{0x138, 6602}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_DA*/ {{0x138, 6620}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_DB*/ {{0x138, 6635}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_DC*/ {{0x138, 6651}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_DD*/ {{0x138, 6651}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_DE*/ {{0x138, 6678}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_DF*/ {{0x138, 6694}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_E0*/ {{0x138, 6709}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_E1*/ {{0x138, 6724}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_E2*/ {{0x138, 6739}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_E3*/ {{0x138, 6754}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_E4*/ {{0x138, 6771}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_E5*/ {{0x138, 6789}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_E6*/ {{0x15a, 6829}, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_E6*/ {{0x159, 6841}, 0x41, 0, 0, 0, 0},
	/*II_V_F2_0F_E6*/ {{0x15a, 6852}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_E7*/ {{0x14a, 6880}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_E8*/ {{0x138, 6898}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_E9*/ {{0x138, 6915}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_EA*/ {{0x138, 6932}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_EB*/ {{0x138, 6946}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_EC*/ {{0x138, 6960}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_ED*/ {{0x138, 6977}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_EE*/ {{0x138, 6994}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_EF*/ {{0x138, 7009}, 0x0, 87, 0, 0, 0},
	/*II_V_F2_0F_F0*/ {{0x195, 7023}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_F1*/ {{0x138, 7038}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_F2*/ {{0x138, 7053}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_F3*/ {{0x138, 7068}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_F4*/ {{0x138, 7085}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_F5*/ {{0x138, 7104}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_F6*/ {{0x138, 7122}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_F7*/ {{0x199, 7153}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_F8*/ {{0x138, 7173}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_F9*/ {{0x138, 7188}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_FA*/ {{0x138, 7203}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_FB*/ {{0x138, 7218}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_FC*/ {{0x138, 7233}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_FD*/ {{0x138, 7248}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_FE*/ {{0x138, 7263}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_00*/ {{0x138, 7371}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_01*/ {{0x138, 7388}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_02*/ {{0x138, 7405}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_03*/ {{0x138, 7423}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_04*/ {{0x138, 7444}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_05*/ {{0x138, 7464}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_06*/ {{0x138, 7481}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_07*/ {{0x138, 7499}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_08*/ {{0x138, 7517}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_09*/ {{0x138, 7534}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_0A*/ {{0x138, 7551}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_0B*/ {{0x138, 7570}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_0C*/ {{0x13f, 7581}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_38_0D*/ {{0x13f, 7592}, 0x1, 91, 0, 0, 0},
	/*II_V_66_0F_38_0E*/ {{0x129, 7603}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_38_0F*/ {{0x129, 7612}, 0x41, 0, 0, 0, 0},
	/*II_66_0F_38_10*/ {{0x1a2, 7621}, 0x0, 32, 0, 0, 0},
	/*II_66_0F_38_14*/ {{0x1a2, 7631}, 0x0, 32, 0, 0, 0},
	/*II_66_0F_38_15*/ {{0x1a2, 7641}, 0x0, 32, 0, 0, 0},
	/*II_V_66_0F_38_17*/ {{0x129, 7658}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_38_18*/ {{0x1a4, 7666}, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_38_19*/ {{0x1a5, 7680}, 0x50, 0, 0, 0, 0},
	/*II_V_66_0F_38_1A*/ {{0x1a6, 7694}, 0x50, 0, 0, 0, 0},
	/*II_V_66_0F_38_1C*/ {{0x1a7, 7717}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_1D*/ {{0x1a7, 7732}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_1E*/ {{0x1a7, 7747}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_20*/ {{0x153, 7765}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_21*/ {{0x152, 7786}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_22*/ {{0x1ab, 7807}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_23*/ {{0x153, 7828}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_24*/ {{0x152, 7849}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_25*/ {{0x153, 7870}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_28*/ {{0x138, 7889}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_29*/ {{0x138, 7907}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_2A*/ {{0x1ae, 7927}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_2B*/ {{0x138, 7948}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_2C*/ {{0x13f, 7959}, 0x1, 67, 0, 0, 0},
	/*II_V_66_0F_38_2D*/ {{0x13f, 7971}, 0x1, 67, 0, 0, 0},
	/*II_V_66_0F_38_2E*/ {{0x1af, 7959}, 0x1, 36, 0, 0, 0},
	/*II_V_66_0F_38_2F*/ {{0x1af, 7971}, 0x1, 36, 0, 0, 0},
	/*II_V_66_0F_38_30*/ {{0x153, 7993}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_31*/ {{0x152, 8014}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_32*/ {{0x1ab, 8035}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_33*/ {{0x153, 8056}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_34*/ {{0x152, 8077}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_35*/ {{0x153, 8098}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_37*/ {{0x138, 8118}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_38*/ {{0x138, 8136}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_39*/ {{0x138, 8153}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_3A*/ {{0x138, 8170}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_3B*/ {{0x138, 8187}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_3C*/ {{0x138, 8204}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_3D*/ {{0x138, 8221}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_3E*/ {{0x138, 8238}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_3F*/ {{0x138, 8255}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_40*/ {{0x138, 8272}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_41*/ {{0x1a7, 8293}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_96*/ {{0x1b1, 8332}, 0x7, 91, 0, 8348, 0},
	/*II_V_66_0F_38_97*/ {{0x1b1, 8364}, 0x7, 91, 0, 8380, 0},
	/*II_V_66_0F_38_98*/ {{0x1b1, 8396}, 0x7, 91, 0, 8409, 0},
	/*II_V_66_0F_38_99*/ {{0x1b2, 8422}, 0x6, 88, 0, 8435, 0},
	/*II_V_66_0F_38_9A*/ {{0x1b1, 8448}, 0x7, 91, 0, 8461, 0},
	/*II_V_66_0F_38_9B*/ {{0x1b2, 8474}, 0x6, 88, 0, 8487, 0},
	/*II_V_66_0F_38_9C*/ {{0x1b1, 8500}, 0x7, 91, 0, 8514, 0},
	/*II_V_66_0F_38_9D*/ {{0x1b2, 8528}, 0x6, 88, 0, 8542, 0},
	/*II_V_66_0F_38_9E*/ {{0x1b1, 8556}, 0x7, 91, 0, 8570, 0},
	/*II_V_66_0F_38_9F*/ {{0x1b2, 8584}, 0x6, 88, 0, 8598, 0},
	/*II_V_66_0F_38_A6*/ {{0x1b1, 8612}, 0x7, 91, 0, 8628, 0},
	/*II_V_66_0F_38_A7*/ {{0x1b1, 8644}, 0x7, 91, 0, 8660, 0},
	/*II_V_66_0F_38_A8*/ {{0x1b1, 8676}, 0x7, 91, 0, 8689, 0},
	/*II_V_66_0F_38_A9*/ {{0x1b2, 8702}, 0x6, 88, 0, 8715, 0},
	/*II_V_66_0F_38_AA*/ {{0x1b1, 8728}, 0x7, 91, 0, 8741, 0},
	/*II_V_66_0F_38_AB*/ {{0x1b2, 8754}, 0x6, 88, 0, 8767, 0},
	/*II_V_66_0F_38_AC*/ {{0x1b1, 8780}, 0x7, 91, 0, 8794, 0},
	/*II_V_66_0F_38_AD*/ {{0x1b2, 8808}, 0x6, 88, 0, 8822, 0},
	/*II_V_66_0F_38_AE*/ {{0x1b1, 8836}, 0x7, 91, 0, 8850, 0},
	/*II_V_66_0F_38_AF*/ {{0x1b2, 8864}, 0x6, 88, 0, 8878, 0},
	/*II_V_66_0F_38_B6*/ {{0x1b1, 8892}, 0x7, 91, 0, 8908, 0},
	/*II_V_66_0F_38_B7*/ {{0x1b1, 8924}, 0x7, 91, 0, 8940, 0},
	/*II_V_66_0F_38_B8*/ {{0x1b1, 8956}, 0x7, 91, 0, 8969, 0},
	/*II_V_66_0F_38_B9*/ {{0x1b2, 8982}, 0x6, 88, 0, 8995, 0},
	/*II_V_66_0F_38_BA*/ {{0x1b1, 9008}, 0x7, 91, 0, 9021, 0},
	/*II_V_66_0F_38_BB*/ {{0x1b2, 9034}, 0x6, 88, 0, 9047, 0},
	/*II_V_66_0F_38_BC*/ {{0x1b1, 9060}, 0x7, 91, 0, 9074, 0},
	/*II_V_66_0F_38_BD*/ {{0x1b2, 9088}, 0x6, 88, 0, 9102, 0},
	/*II_V_66_0F_38_BE*/ {{0x1b1, 9116}, 0x7, 91, 0, 9130, 0},
	/*II_V_66_0F_38_BF*/ {{0x1b2, 9144}, 0x6, 88, 0, 9158, 0},
	/*II_V_66_0F_38_DB*/ {{0x1b4, 9180}, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_DC*/ {{0x1b5, 9197}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_DD*/ {{0x1b5, 9218}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_DE*/ {{0x1b5, 9239}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_38_DF*/ {{0x1b5, 9260}, 0x0, 87, 0, 0, 0},
	/*II_V_66_0F_3A_04*/ {{0x1ba, 7581}, 0x41, 1, 0, 0, 0},
	/*II_V_66_0F_3A_05*/ {{0x1ba, 7592}, 0x41, 1, 0, 0, 0},
	/*II_V_66_0F_3A_06*/ {{0x1bb, 9287}, 0x10, 89, 1, 0, 0},
	/*II_66_0F_3A_08*/ {{0x1a2, 9299}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_08*/ {{0x1ba, 9308}, 0x41, 1, 0, 0, 0},
	/*II_66_0F_3A_09*/ {{0x1a2, 9318}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_09*/ {{0x1ba, 9327}, 0x41, 1, 0, 0, 0},
	/*II_66_0F_3A_0A*/ {{0x1bc, 9337}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0A*/ {{0x184, 9346}, 0x0, 85, 1, 0, 0},
	/*II_66_0F_3A_0B*/ {{0x1bd, 9356}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0B*/ {{0x184, 9365}, 0x0, 86, 1, 0, 0},
	/*II_66_0F_3A_0C*/ {{0x1a2, 9375}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0C*/ {{0x189, 9384}, 0x1, 91, 1, 0, 0},
	/*II_66_0F_3A_0D*/ {{0x1a2, 9394}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0D*/ {{0x189, 9403}, 0x1, 91, 1, 0, 0},
	/*II_66_0F_3A_0E*/ {{0x1a2, 9413}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0E*/ {{0x184, 9422}, 0x0, 87, 1, 0, 0},
	/*II_0F_3A_0F*/ {{0x1be, 9432}, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_0F*/ {{0x1bf, 9432}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0F*/ {{0x184, 9441}, 0x0, 87, 1, 0, 0},
	/*II_66_0F_3A_14*/ {{0x1c0, 9451}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_14*/ {{0x1c1, 9459}, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_15*/ {{0x1c2, 6333}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_15*/ {{0x1c3, 6341}, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_16*/ {{0x1c4, 9468}, 0x0, 1, 0, 0, 9476},
	/*II_V_66_0F_3A_16*/ {{0x1c5, 9484}, 0x46, 1, 0, 9493, 0},
	/*II_66_0F_3A_17*/ {{0x1c6, 9502}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_17*/ {{0x1c7, 9513}, 0x40, 1, 0, 0, 0},
	/*II_V_66_0F_3A_18*/ {{0x1bb, 9525}, 0x10, 87, 1, 0, 0},
	/*II_V_66_0F_3A_19*/ {{0x1c8, 9538}, 0x50, 1, 0, 0, 0},
	/*II_66_0F_3A_20*/ {{0x1c9, 9552}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_20*/ {{0x184, 9560}, 0x0, 80, 1, 0, 0},
	/*II_66_0F_3A_21*/ {{0x1bc, 9569}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_21*/ {{0x184, 9579}, 0x0, 85, 1, 0, 0},
	/*II_66_0F_3A_22*/ {{0x1ca, 9590}, 0x0, 1, 0, 0, 9598},
	/*II_V_66_0F_3A_22*/ {{0x184, 9606}, 0x6, 73, 1, 9615, 0},
	/*II_66_0F_3A_40*/ {{0x1a2, 9624}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_40*/ {{0x189, 9630}, 0x1, 91, 1, 0, 0},
	/*II_66_0F_3A_41*/ {{0x1a2, 9637}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_41*/ {{0x184, 9643}, 0x0, 87, 1, 0, 0},
	/*II_66_0F_3A_42*/ {{0x1a2, 9650}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_42*/ {{0x184, 9659}, 0x0, 87, 1, 0, 0},
	/*II_66_0F_3A_44*/ {{0x1cb, 9669}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_44*/ {{0x1cc, 9680}, 0x0, 87, 1, 0, 0},
	/*II_V_66_0F_3A_4A*/ {{0x189, 9692}, 0x1, 91, 37, 0, 0},
	/*II_V_66_0F_3A_4B*/ {{0x189, 9703}, 0x1, 91, 37, 0, 0},
	/*II_V_66_0F_3A_4C*/ {{0x184, 9714}, 0x0, 87, 35, 0, 0},
	/*II_66_0F_3A_60*/ {{0x1cd, 9725}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_60*/ {{0x163, 9736}, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_61*/ {{0x1cd, 9748}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_61*/ {{0x163, 9759}, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_62*/ {{0x1cd, 9771}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_62*/ {{0x163, 9782}, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_63*/ {{0x1cd, 9794}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_63*/ {{0x163, 9805}, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_DF*/ {{0x1ce, 9817}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_DF*/ {{0x1cf, 9834}, 0x40, 1, 0, 0, 0},
	/*II_V_66_0F_71_02*/ {{0x1d2, 6465}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_71_04*/ {{0x1d2, 6724}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_71_06*/ {{0x1d2, 7038}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_02*/ {{0x1d2, 6480}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_04*/ {{0x1d2, 6739}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_06*/ {{0x1d2, 7053}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_02*/ {{0x1d2, 6495}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_03*/ {{0x1d2, 9860}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_06*/ {{0x1d2, 7068}, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_07*/ {{0x1d2, 9877}, 0x0, 1, 0, 0, 0},
	/*II_0F_AE_00*/ {{0x173, 9886}, 0x0, 0, 0, 0, 9894},
	/*II_0F_AE_01*/ {{0x173, 9914}, 0x0, 0, 0, 0, 9923},
	/*II_V_0F_AE_02*/ {{0x1d5, 9963}, 0x40, 0, 0, 0, 0},
	/*II_V_0F_AE_03*/ {{0x1d5, 9992}, 0x40, 0, 0, 0, 0}
};

_InstNode InstructionsTree[5688] = {
/* 0 - _00 */  0x2000,
/* 1 - _01 */  0x2001,
/* 2 - _02 */  0x2002,
/* 3 - _03 */  0x2003,
/* 4 - _04 */  0x2004,
/* 5 - _05 */  0x2005,
/* 6 - _06 */  0x2006,
/* 7 - _07 */  0x2007,
/* 8 - _08 */  0x2008,
/* 9 - _09 */  0x2009,
/* a - _0A */  0x200a,
/* b - _0B */  0x200b,
/* c - _0C */  0x200c,
/* d - _0D */  0x200d,
/* e - _0E */  0x200e,
/* f - _0F */  0xa100,
/* 10 - _10 */  0x200f,
/* 11 - _11 */  0x2010,
/* 12 - _12 */  0x2011,
/* 13 - _13 */  0x2012,
/* 14 - _14 */  0x2013,
/* 15 - _15 */  0x2014,
/* 16 - _16 */  0x2015,
/* 17 - _17 */  0x2016,
/* 18 - _18 */  0x2017,
/* 19 - _19 */  0x2018,
/* 1a - _1A */  0x2019,
/* 1b - _1B */  0x201a,
/* 1c - _1C */  0x201b,
/* 1d - _1D */  0x201c,
/* 1e - _1E */  0x201d,
/* 1f - _1F */  0x201e,
/* 20 - _20 */  0x201f,
/* 21 - _21 */  0x2020,
/* 22 - _22 */  0x2021,
/* 23 - _23 */  0x2022,
/* 24 - _24 */  0x2023,
/* 25 - _25 */  0x2024,
/* 26 -  */  0,
/* 27 - _27 */  0x2025,
/* 28 - _28 */  0x2026,
/* 29 - _29 */  0x2027,
/* 2a - _2A */  0x2028,
/* 2b - _2B */  0x2029,
/* 2c - _2C */  0x202a,
/* 2d - _2D */  0x202b,
/* 2e -  */  0,
/* 2f - _2F */  0x202c,
/* 30 - _30 */  0x202d,
/* 31 - _31 */  0x202e,
/* 32 - _32 */  0x202f,
/* 33 - _33 */  0x2030,
/* 34 - _34 */  0x2031,
/* 35 - _35 */  0x2032,
/* 36 -  */  0,
/* 37 - _37 */  0x2033,
/* 38 - _38 */  0x2034,
/* 39 - _39 */  0x2035,
/* 3a - _3A */  0x2036,
/* 3b - _3B */  0x2037,
/* 3c - _3C */  0x2038,
/* 3d - _3D */  0x2039,
/* 3e -  */  0,
/* 3f - _3F */  0x203a,
/* 40 - _40 */  0x203b,
/* 41 - _40 */  0x203c,
/* 42 - _40 */  0x203d,
/* 43 - _40 */  0x203e,
/* 44 - _40 */  0x203f,
/* 45 - _40 */  0x2040,
/* 46 - _40 */  0x2041,
/* 47 - _40 */  0x2042,
/* 48 - _48 */  0x2043,
/* 49 - _48 */  0x2044,
/* 4a - _48 */  0x2045,
/* 4b - _48 */  0x2046,
/* 4c - _48 */  0x2047,
/* 4d - _48 */  0x2048,
/* 4e - _48 */  0x2049,
/* 4f - _48 */  0x204a,
/* 50 - _50 */  0x204b,
/* 51 - _50 */  0x204c,
/* 52 - _50 */  0x204d,
/* 53 - _50 */  0x204e,
/* 54 - _50 */  0x204f,
/* 55 - _50 */  0x2050,
/* 56 - _50 */  0x2051,
/* 57 - _50 */  0x2052,
/* 58 - _58 */  0x2053,
/* 59 - _58 */  0x2054,
/* 5a - _58 */  0x2055,
/* 5b - _58 */  0x2056,
/* 5c - _58 */  0x2057,
/* 5d - _58 */  0x2058,
/* 5e - _58 */  0x2059,
/* 5f - _58 */  0x205a,
/* 60 - _60 */  0x205b,
/* 61 - _61 */  0x205c,
/* 62 - _62 */  0x205d,
/* 63 - _63 */  0x605e,
/* 64 -  */  0,
/* 65 -  */  0,
/* 66 -  */  0,
/* 67 -  */  0,
/* 68 - _68 */  0x205f,
/* 69 - _69 */  0x4000,
/* 6a - _6A */  0x2060,
/* 6b - _6B */  0x4001,
/* 6c - _6C */  0x2061,
/* 6d - _6D */  0x2062,
/* 6e - _6E */  0x2063,
/* 6f - _6F */  0x2064,
/* 70 - _70 */  0x2065,
/* 71 - _71 */  0x2066,
/* 72 - _72 */  0x2067,
/* 73 - _73 */  0x2068,
/* 74 - _74 */  0x2069,
/* 75 - _75 */  0x206a,
/* 76 - _76 */  0x206b,
/* 77 - _77 */  0x206c,
/* 78 - _78 */  0x206d,
/* 79 - _79 */  0x206e,
/* 7a - _7A */  0x206f,
/* 7b - _7B */  0x2070,
/* 7c - _7C */  0x2071,
/* 7d - _7D */  0x2072,
/* 7e - _7E */  0x2073,
/* 7f - _7F */  0x2074,
/* 80 - _80 */  0x8200,
/* 81 - _81 */  0x8208,
/* 82 - _82 */  0x8210,
/* 83 - _83 */  0x8218,
/* 84 - _84 */  0x2075,
/* 85 - _85 */  0x2076,
/* 86 - _86 */  0x2077,
/* 87 - _87 */  0x2078,
/* 88 - _88 */  0x2079,
/* 89 - _89 */  0x207a,
/* 8a - _8A */  0x207b,
/* 8b - _8B */  0x207c,
/* 8c - _8C */  0x207d,
/* 8d - _8D */  0x607e,
/* 8e - _8E */  0x207f,
/* 8f - _8F */  0x8220,
/* 90 - _90 */  0x6080,
/* 91 - _91 */  0x2081,
/* 92 - _92 */  0x2082,
/* 93 - _93 */  0x2083,
/* 94 - _94 */  0x2084,
/* 95 - _95 */  0x2085,
/* 96 - _96 */  0x2086,
/* 97 - _97 */  0x2087,
/* 98 - _98 */  0x4002,
/* 99 - _99 */  0x4003,
/* 9a - _9A */  0x2088,
/* 9b -  */  0,
/* 9c - _9C */  0x2089,
/* 9d - _9D */  0x208a,
/* 9e - _9E */  0x208b,
/* 9f - _9F */  0x208c,
/* a0 - _A0 */  0x208d,
/* a1 - _A1 */  0x208e,
/* a2 - _A2 */  0x208f,
/* a3 - _A3 */  0x2090,
/* a4 - _A4 */  0x2091,
/* a5 - _A5 */  0x2092,
/* a6 - _A6 */  0x2093,
/* a7 - _A7 */  0x2094,
/* a8 - _A8 */  0x2095,
/* a9 - _A9 */  0x2096,
/* aa - _AA */  0x2097,
/* ab - _AB */  0x2098,
/* ac - _AC */  0x2099,
/* ad - _AD */  0x209a,
/* ae - _AE */  0x209b,
/* af - _AF */  0x209c,
/* b0 - _B0 */  0x209d,
/* b1 - _B0 */  0x209e,
/* b2 - _B0 */  0x209f,
/* b3 - _B0 */  0x20a0,
/* b4 - _B0 */  0x20a1,
/* b5 - _B0 */  0x20a2,
/* b6 - _B0 */  0x20a3,
/* b7 - _B0 */  0x20a4,
/* b8 - _B8 */  0x20a5,
/* b9 - _B8 */  0x20a6,
/* ba - _B8 */  0x20a7,
/* bb - _B8 */  0x20a8,
/* bc - _B8 */  0x20a9,
/* bd - _B8 */  0x20aa,
/* be - _B8 */  0x20ab,
/* bf - _B8 */  0x20ac,
/* c0 - _C0 */  0x8228,
/* c1 - _C1 */  0x8230,
/* c2 - _C2 */  0x20ad,
/* c3 - _C3 */  0x20ae,
/* c4 - _C4 */  0x20af,
/* c5 - _C5 */  0x20b0,
/* c6 - _C6 */  0xc238,
/* c7 - _C7 */  0xc280,
/* c8 - _C8 */  0x20b1,
/* c9 - _C9 */  0x20b2,
/* ca - _CA */  0x20b3,
/* cb - _CB */  0x20b4,
/* cc - _CC */  0x20b5,
/* cd - _CD */  0x20b6,
/* ce - _CE */  0x20b7,
/* cf - _CF */  0x20b8,
/* d0 - _D0 */  0x82c8,
/* d1 - _D1 */  0x82d0,
/* d2 - _D2 */  0x82d8,
/* d3 - _D3 */  0x82e0,
/* d4 - _D4 */  0x20b9,
/* d5 - _D5 */  0x20ba,
/* d6 - _D6 */  0x20bb,
/* d7 - _D7 */  0x20bc,
/* d8 - _D8 */  0xc2e8,
/* d9 - _D9 */  0xc330,
/* da - _DA */  0xc378,
/* db - _DB */  0xc3c0,
/* dc - _DC */  0xc408,
/* dd - _DD */  0xc450,
/* de - _DE */  0xc498,
/* df - _DF */  0xc4e0,
/* e0 - _E0 */  0x20bd,
/* e1 - _E1 */  0x20be,
/* e2 - _E2 */  0x20bf,
/* e3 - _E3 */  0x4004,
/* e4 - _E4 */  0x20c0,
/* e5 - _E5 */  0x20c1,
/* e6 - _E6 */  0x20c2,
/* e7 - _E7 */  0x20c3,
/* e8 - _E8 */  0x20c4,
/* e9 - _E9 */  0x20c5,
/* ea - _EA */  0x20c6,
/* eb - _EB */  0x20c7,
/* ec - _EC */  0x20c8,
/* ed - _ED */  0x20c9,
/* ee - _EE */  0x20ca,
/* ef - _EF */  0x20cb,
/* f0 -  */  0,
/* f1 - _F1 */  0x20cc,
/* f2 -  */  0,
/* f3 -  */  0,
/* f4 - _F4 */  0x20cd,
/* f5 - _F5 */  0x20ce,
/* f6 - _F6 */  0x8528,
/* f7 - _F7 */  0x8530,
/* f8 - _F8 */  0x20cf,
/* f9 - _F9 */  0x20d0,
/* fa - _FA */  0x20d1,
/* fb - _FB */  0x20d2,
/* fc - _FC */  0x20d3,
/* fd - _FD */  0x20d4,
/* fe - _FE */  0x8538,
/* ff - _FF */  0x8540,
/* 100 - _0F_00 */  0x8548,
/* 101 - _0F_01 */  0xc550,
/* 102 - _0F_02 */  0x20d5,
/* 103 - _0F_03 */  0x20d6,
/* 104 -  */  0,
/* 105 - _0F_05 */  0x20d7,
/* 106 - _0F_06 */  0x20d8,
/* 107 - _0F_07 */  0x20d9,
/* 108 - _0F_08 */  0x20da,
/* 109 - _0F_09 */  0x20db,
/* 10a -  */  0,
/* 10b - _0F_0B */  0x20dc,
/* 10c -  */  0,
/* 10d - _0F_0D */  0x8598,
/* 10e - _0F_0E */  0x20dd,
/* 10f - _0F_0F */  0xa5a0,
/* 110 - _0F_10 */  0xe6a0,
/* 111 - _0F_11 */  0xe6ac,
/* 112 - _0F_12 */  0xe6b8,
/* 113 - _0F_13 */  0xe6c4,
/* 114 - _0F_14 */  0xe6d0,
/* 115 - _0F_15 */  0xe6dc,
/* 116 - _0F_16 */  0xe6e8,
/* 117 - _0F_17 */  0xe6f4,
/* 118 - _0F_18 */  0x8700,
/* 119 -  */  0,
/* 11a -  */  0,
/* 11b -  */  0,
/* 11c -  */  0,
/* 11d -  */  0,
/* 11e -  */  0,
/* 11f - _0F_1F */  0x20de,
/* 120 - _0F_20 */  0x20df,
/* 121 - _0F_21 */  0x20e0,
/* 122 - _0F_22 */  0x20e1,
/* 123 - _0F_23 */  0x20e2,
/* 124 -  */  0,
/* 125 -  */  0,
/* 126 -  */  0,
/* 127 -  */  0,
/* 128 - _0F_28 */  0xe708,
/* 129 - _0F_29 */  0xe714,
/* 12a - _0F_2A */  0xe720,
/* 12b - _0F_2B */  0xe72c,
/* 12c - _0F_2C */  0xe738,
/* 12d - _0F_2D */  0xe744,
/* 12e - _0F_2E */  0xe750,
/* 12f - _0F_2F */  0xe75c,
/* 130 - _0F_30 */  0x20e3,
/* 131 - _0F_31 */  0x20e4,
/* 132 - _0F_32 */  0x20e5,
/* 133 - _0F_33 */  0x20e6,
/* 134 - _0F_34 */  0x20e7,
/* 135 - _0F_35 */  0x20e8,
/* 136 -  */  0,
/* 137 - _0F_37 */  0x20e9,
/* 138 - _0F_38 */  0xa768,
/* 139 -  */  0,
/* 13a - _0F_3A */  0xa868,
/* 13b -  */  0,
/* 13c -  */  0,
/* 13d -  */  0,
/* 13e -  */  0,
/* 13f -  */  0,
/* 140 - _0F_40 */  0x20ea,
/* 141 - _0F_41 */  0x20eb,
/* 142 - _0F_42 */  0x20ec,
/* 143 - _0F_43 */  0x20ed,
/* 144 - _0F_44 */  0x20ee,
/* 145 - _0F_45 */  0x20ef,
/* 146 - _0F_46 */  0x20f0,
/* 147 - _0F_47 */  0x20f1,
/* 148 - _0F_48 */  0x20f2,
/* 149 - _0F_49 */  0x20f3,
/* 14a - _0F_4A */  0x20f4,
/* 14b - _0F_4B */  0x20f5,
/* 14c - _0F_4C */  0x20f6,
/* 14d - _0F_4D */  0x20f7,
/* 14e - _0F_4E */  0x20f8,
/* 14f - _0F_4F */  0x20f9,
/* 150 - _0F_50 */  0xe968,
/* 151 - _0F_51 */  0xe974,
/* 152 - _0F_52 */  0xe980,
/* 153 - _0F_53 */  0xe98c,
/* 154 - _0F_54 */  0xe998,
/* 155 - _0F_55 */  0xe9a4,
/* 156 - _0F_56 */  0xe9b0,
/* 157 - _0F_57 */  0xe9bc,
/* 158 - _0F_58 */  0xe9c8,
/* 159 - _0F_59 */  0xe9d4,
/* 15a - _0F_5A */  0xe9e0,
/* 15b - _0F_5B */  0xe9ec,
/* 15c - _0F_5C */  0xe9f8,
/* 15d - _0F_5D */  0xea04,
/* 15e - _0F_5E */  0xea10,
/* 15f - _0F_5F */  0xea1c,
/* 160 - _0F_60 */  0xea28,
/* 161 - _0F_61 */  0xea34,
/* 162 - _0F_62 */  0xea40,
/* 163 - _0F_63 */  0xea4c,
/* 164 - _0F_64 */  0xea58,
/* 165 - _0F_65 */  0xea64,
/* 166 - _0F_66 */  0xea70,
/* 167 - _0F_67 */  0xea7c,
/* 168 - _0F_68 */  0xea88,
/* 169 - _0F_69 */  0xea94,
/* 16a - _0F_6A */  0xeaa0,
/* 16b - _0F_6B */  0xeaac,
/* 16c - _0F_6C */  0xeab8,
/* 16d - _0F_6D */  0xeac4,
/* 16e - _0F_6E */  0xead0,
/* 16f - _0F_6F */  0xeadc,
/* 170 - _0F_70 */  0xeae8,
/* 171 - _0F_71 */  0x8af4,
/* 172 - _0F_72 */  0x8afc,
/* 173 - _0F_73 */  0x8b04,
/* 174 - _0F_74 */  0xeb0c,
/* 175 - _0F_75 */  0xeb18,
/* 176 - _0F_76 */  0xeb24,
/* 177 - _0F_77 */  0xeb30,
/* 178 - _0F_78 */  0xeb3c,
/* 179 - _0F_79 */  0xeb48,
/* 17a - _0F_7A */  0xab54,
/* 17b -  */  0,
/* 17c - _0F_7C */  0xec54,
/* 17d - _0F_7D */  0xec60,
/* 17e - _0F_7E */  0xec6c,
/* 17f - _0F_7F */  0xec78,
/* 180 - _0F_80 */  0x20fa,
/* 181 - _0F_81 */  0x20fb,
/* 182 - _0F_82 */  0x20fc,
/* 183 - _0F_83 */  0x20fd,
/* 184 - _0F_84 */  0x20fe,
/* 185 - _0F_85 */  0x20ff,
/* 186 - _0F_86 */  0x2100,
/* 187 - _0F_87 */  0x2101,
/* 188 - _0F_88 */  0x2102,
/* 189 - _0F_89 */  0x2103,
/* 18a - _0F_8A */  0x2104,
/* 18b - _0F_8B */  0x2105,
/* 18c - _0F_8C */  0x2106,
/* 18d - _0F_8D */  0x2107,
/* 18e - _0F_8E */  0x2108,
/* 18f - _0F_8F */  0x2109,
/* 190 - _0F_90 */  0x210a,
/* 191 - _0F_91 */  0x210b,
/* 192 - _0F_92 */  0x210c,
/* 193 - _0F_93 */  0x210d,
/* 194 - _0F_94 */  0x210e,
/* 195 - _0F_95 */  0x210f,
/* 196 - _0F_96 */  0x2110,
/* 197 - _0F_97 */  0x2111,
/* 198 - _0F_98 */  0x2112,
/* 199 - _0F_99 */  0x2113,
/* 19a - _0F_9A */  0x2114,
/* 19b - _0F_9B */  0x2115,
/* 19c - _0F_9C */  0x2116,
/* 19d - _0F_9D */  0x2117,
/* 19e - _0F_9E */  0x2118,
/* 19f - _0F_9F */  0x2119,
/* 1a0 - _0F_A0 */  0x211a,
/* 1a1 - _0F_A1 */  0x211b,
/* 1a2 - _0F_A2 */  0x211c,
/* 1a3 - _0F_A3 */  0x211d,
/* 1a4 - _0F_A4 */  0x4005,
/* 1a5 - _0F_A5 */  0x4006,
/* 1a6 -  */  0,
/* 1a7 -  */  0,
/* 1a8 - _0F_A8 */  0x211e,
/* 1a9 - _0F_A9 */  0x211f,
/* 1aa - _0F_AA */  0x2120,
/* 1ab - _0F_AB */  0x2121,
/* 1ac - _0F_AC */  0x4007,
/* 1ad - _0F_AD */  0x4008,
/* 1ae - _0F_AE */  0x8c84,
/* 1af - _0F_AF */  0x2122,
/* 1b0 - _0F_B0 */  0x2123,
/* 1b1 - _0F_B1 */  0x2124,
/* 1b2 - _0F_B2 */  0x2125,
/* 1b3 - _0F_B3 */  0x2126,
/* 1b4 - _0F_B4 */  0x2127,
/* 1b5 - _0F_B5 */  0x2128,
/* 1b6 - _0F_B6 */  0x2129,
/* 1b7 - _0F_B7 */  0x212a,
/* 1b8 - _0F_B8 */  0xec8c,
/* 1b9 - _0F_B9 */  0x212b,
/* 1ba - _0F_BA */  0x8c98,
/* 1bb - _0F_BB */  0x212c,
/* 1bc - _0F_BC */  0xeca0,
/* 1bd - _0F_BD */  0xecac,
/* 1be - _0F_BE */  0x212d,
/* 1bf - _0F_BF */  0x212e,
/* 1c0 - _0F_C0 */  0x212f,
/* 1c1 - _0F_C1 */  0x2130,
/* 1c2 - _0F_C2 */  0xecb8,
/* 1c3 - _0F_C3 */  0x2131,
/* 1c4 - _0F_C4 */  0xecc4,
/* 1c5 - _0F_C5 */  0xecd0,
/* 1c6 - _0F_C6 */  0xecdc,
/* 1c7 - _0F_C7 */  0x8ce8,
/* 1c8 - _0F_C8 */  0x2132,
/* 1c9 - _0F_C8 */  0x2133,
/* 1ca - _0F_C8 */  0x2134,
/* 1cb - _0F_C8 */  0x2135,
/* 1cc - _0F_C8 */  0x2136,
/* 1cd - _0F_C8 */  0x2137,
/* 1ce - _0F_C8 */  0x2138,
/* 1cf - _0F_C8 */  0x2139,
/* 1d0 - _0F_D0 */  0xecf0,
/* 1d1 - _0F_D1 */  0xecfc,
/* 1d2 - _0F_D2 */  0xed08,
/* 1d3 - _0F_D3 */  0xed14,
/* 1d4 - _0F_D4 */  0xed20,
/* 1d5 - _0F_D5 */  0xed2c,
/* 1d6 - _0F_D6 */  0xed38,
/* 1d7 - _0F_D7 */  0xed44,
/* 1d8 - _0F_D8 */  0xed50,
/* 1d9 - _0F_D9 */  0xed5c,
/* 1da - _0F_DA */  0xed68,
/* 1db - _0F_DB */  0xed74,
/* 1dc - _0F_DC */  0xed80,
/* 1dd - _0F_DD */  0xed8c,
/* 1de - _0F_DE */  0xed98,
/* 1df - _0F_DF */  0xeda4,
/* 1e0 - _0F_E0 */  0xedb0,
/* 1e1 - _0F_E1 */  0xedbc,
/* 1e2 - _0F_E2 */  0xedc8,
/* 1e3 - _0F_E3 */  0xedd4,
/* 1e4 - _0F_E4 */  0xede0,
/* 1e5 - _0F_E5 */  0xedec,
/* 1e6 - _0F_E6 */  0xedf8,
/* 1e7 - _0F_E7 */  0xee04,
/* 1e8 - _0F_E8 */  0xee10,
/* 1e9 - _0F_E9 */  0xee1c,
/* 1ea - _0F_EA */  0xee28,
/* 1eb - _0F_EB */  0xee34,
/* 1ec - _0F_EC */  0xee40,
/* 1ed - _0F_ED */  0xee4c,
/* 1ee - _0F_EE */  0xee58,
/* 1ef - _0F_EF */  0xee64,
/* 1f0 - _0F_F0 */  0xee70,
/* 1f1 - _0F_F1 */  0xee7c,
/* 1f2 - _0F_F2 */  0xee88,
/* 1f3 - _0F_F3 */  0xee94,
/* 1f4 - _0F_F4 */  0xeea0,
/* 1f5 - _0F_F5 */  0xeeac,
/* 1f6 - _0F_F6 */  0xeeb8,
/* 1f7 - _0F_F7 */  0xeec4,
/* 1f8 - _0F_F8 */  0xeed0,
/* 1f9 - _0F_F9 */  0xeedc,
/* 1fa - _0F_FA */  0xeee8,
/* 1fb - _0F_FB */  0xeef4,
/* 1fc - _0F_FC */  0xef00,
/* 1fd - _0F_FD */  0xef0c,
/* 1fe - _0F_FE */  0xef18,
/* 1ff -  */  0,
/* 200 - _80_00 */  0x213a,
/* 201 - _80_01 */  0x213b,
/* 202 - _80_02 */  0x213c,
/* 203 - _80_03 */  0x213d,
/* 204 - _80_04 */  0x213e,
/* 205 - _80_05 */  0x213f,
/* 206 - _80_06 */  0x2140,
/* 207 - _80_07 */  0x2141,
/* 208 - _81_00 */  0x2142,
/* 209 - _81_01 */  0x2143,
/* 20a - _81_02 */  0x2144,
/* 20b - _81_03 */  0x2145,
/* 20c - _81_04 */  0x2146,
/* 20d - _81_05 */  0x2147,
/* 20e - _81_06 */  0x2148,
/* 20f - _81_07 */  0x2149,
/* 210 - _82_00 */  0x214a,
/* 211 - _82_01 */  0x214b,
/* 212 - _82_02 */  0x214c,
/* 213 - _82_03 */  0x214d,
/* 214 - _82_04 */  0x214e,
/* 215 - _82_05 */  0x214f,
/* 216 - _82_06 */  0x2150,
/* 217 - _82_07 */  0x2151,
/* 218 - _83_00 */  0x2152,
/* 219 - _83_01 */  0x2153,
/* 21a - _83_02 */  0x2154,
/* 21b - _83_03 */  0x2155,
/* 21c - _83_04 */  0x2156,
/* 21d - _83_05 */  0x2157,
/* 21e - _83_06 */  0x2158,
/* 21f - _83_07 */  0x2159,
/* 220 - _8F_00 */  0x215a,
/* 221 -  */  0,
/* 222 -  */  0,
/* 223 -  */  0,
/* 224 -  */  0,
/* 225 -  */  0,
/* 226 -  */  0,
/* 227 -  */  0,
/* 228 - _C0_00 */  0x215b,
/* 229 - _C0_01 */  0x215c,
/* 22a - _C0_02 */  0x215d,
/* 22b - _C0_03 */  0x215e,
/* 22c - _C0_04 */  0x215f,
/* 22d - _C0_05 */  0x2160,
/* 22e - _C0_06 */  0x2161,
/* 22f - _C0_07 */  0x2162,
/* 230 - _C1_00 */  0x2163,
/* 231 - _C1_01 */  0x2164,
/* 232 - _C1_02 */  0x2165,
/* 233 - _C1_03 */  0x2166,
/* 234 - _C1_04 */  0x2167,
/* 235 - _C1_05 */  0x2168,
/* 236 - _C1_06 */  0x2169,
/* 237 - _C1_07 */  0x216a,
/* 238 - _C6_00 */  0x216b,
/* 239 -  */  0,
/* 23a -  */  0,
/* 23b -  */  0,
/* 23c -  */  0,
/* 23d -  */  0,
/* 23e -  */  0,
/* 23f -  */  0,
/* 240 -  */  0,
/* 241 -  */  0,
/* 242 -  */  0,
/* 243 -  */  0,
/* 244 -  */  0,
/* 245 -  */  0,
/* 246 -  */  0,
/* 247 -  */  0,
/* 248 -  */  0,
/* 249 -  */  0,
/* 24a -  */  0,
/* 24b -  */  0,
/* 24c -  */  0,
/* 24d -  */  0,
/* 24e -  */  0,
/* 24f -  */  0,
/* 250 -  */  0,
/* 251 -  */  0,
/* 252 -  */  0,
/* 253 -  */  0,
/* 254 -  */  0,
/* 255 -  */  0,
/* 256 -  */  0,
/* 257 -  */  0,
/* 258 -  */  0,
/* 259 -  */  0,
/* 25a -  */  0,
/* 25b -  */  0,
/* 25c -  */  0,
/* 25d -  */  0,
/* 25e -  */  0,
/* 25f -  */  0,
/* 260 -  */  0,
/* 261 -  */  0,
/* 262 -  */  0,
/* 263 -  */  0,
/* 264 -  */  0,
/* 265 -  */  0,
/* 266 -  */  0,
/* 267 -  */  0,
/* 268 -  */  0,
/* 269 -  */  0,
/* 26a -  */  0,
/* 26b -  */  0,
/* 26c -  */  0,
/* 26d -  */  0,
/* 26e -  */  0,
/* 26f -  */  0,
/* 270 -  */  0,
/* 271 -  */  0,
/* 272 -  */  0,
/* 273 -  */  0,
/* 274 -  */  0,
/* 275 -  */  0,
/* 276 -  */  0,
/* 277 -  */  0,
/* 278 - _C6_F8 */  0x216c,
/* 279 -  */  0,
/* 27a -  */  0,
/* 27b -  */  0,
/* 27c -  */  0,
/* 27d -  */  0,
/* 27e -  */  0,
/* 27f -  */  0,
/* 280 - _C7_00 */  0x216d,
/* 281 -  */  0,
/* 282 -  */  0,
/* 283 -  */  0,
/* 284 -  */  0,
/* 285 -  */  0,
/* 286 -  */  0,
/* 287 -  */  0,
/* 288 -  */  0,
/* 289 -  */  0,
/* 28a -  */  0,
/* 28b -  */  0,
/* 28c -  */  0,
/* 28d -  */  0,
/* 28e -  */  0,
/* 28f -  */  0,
/* 290 -  */  0,
/* 291 -  */  0,
/* 292 -  */  0,
/* 293 -  */  0,
/* 294 -  */  0,
/* 295 -  */  0,
/* 296 -  */  0,
/* 297 -  */  0,
/* 298 -  */  0,
/* 299 -  */  0,
/* 29a -  */  0,
/* 29b -  */  0,
/* 29c -  */  0,
/* 29d -  */  0,
/* 29e -  */  0,
/* 29f -  */  0,
/* 2a0 -  */  0,
/* 2a1 -  */  0,
/* 2a2 -  */  0,
/* 2a3 -  */  0,
/* 2a4 -  */  0,
/* 2a5 -  */  0,
/* 2a6 -  */  0,
/* 2a7 -  */  0,
/* 2a8 -  */  0,
/* 2a9 -  */  0,
/* 2aa -  */  0,
/* 2ab -  */  0,
/* 2ac -  */  0,
/* 2ad -  */  0,
/* 2ae -  */  0,
/* 2af -  */  0,
/* 2b0 -  */  0,
/* 2b1 -  */  0,
/* 2b2 -  */  0,
/* 2b3 -  */  0,
/* 2b4 -  */  0,
/* 2b5 -  */  0,
/* 2b6 -  */  0,
/* 2b7 -  */  0,
/* 2b8 -  */  0,
/* 2b9 -  */  0,
/* 2ba -  */  0,
/* 2bb -  */  0,
/* 2bc -  */  0,
/* 2bd -  */  0,
/* 2be -  */  0,
/* 2bf -  */  0,
/* 2c0 - _C7_F8 */  0x216e,
/* 2c1 -  */  0,
/* 2c2 -  */  0,
/* 2c3 -  */  0,
/* 2c4 -  */  0,
/* 2c5 -  */  0,
/* 2c6 -  */  0,
/* 2c7 -  */  0,
/* 2c8 - _D0_00 */  0x216f,
/* 2c9 - _D0_01 */  0x2170,
/* 2ca - _D0_02 */  0x2171,
/* 2cb - _D0_03 */  0x2172,
/* 2cc - _D0_04 */  0x2173,
/* 2cd - _D0_05 */  0x2174,
/* 2ce - _D0_06 */  0x2175,
/* 2cf - _D0_07 */  0x2176,
/* 2d0 - _D1_00 */  0x2177,
/* 2d1 - _D1_01 */  0x2178,
/* 2d2 - _D1_02 */  0x2179,
/* 2d3 - _D1_03 */  0x217a,
/* 2d4 - _D1_04 */  0x217b,
/* 2d5 - _D1_05 */  0x217c,
/* 2d6 - _D1_06 */  0x217d,
/* 2d7 - _D1_07 */  0x217e,
/* 2d8 - _D2_00 */  0x217f,
/* 2d9 - _D2_01 */  0x2180,
/* 2da - _D2_02 */  0x2181,
/* 2db - _D2_03 */  0x2182,
/* 2dc - _D2_04 */  0x2183,
/* 2dd - _D2_05 */  0x2184,
/* 2de - _D2_06 */  0x2185,
/* 2df - _D2_07 */  0x2186,
/* 2e0 - _D3_00 */  0x2187,
/* 2e1 - _D3_01 */  0x2188,
/* 2e2 - _D3_02 */  0x2189,
/* 2e3 - _D3_03 */  0x218a,
/* 2e4 - _D3_04 */  0x218b,
/* 2e5 - _D3_05 */  0x218c,
/* 2e6 - _D3_06 */  0x218d,
/* 2e7 - _D3_07 */  0x218e,
/* 2e8 - _D8_00 */  0x218f,
/* 2e9 - _D8_01 */  0x2190,
/* 2ea - _D8_02 */  0x2191,
/* 2eb - _D8_03 */  0x2192,
/* 2ec - _D8_04 */  0x2193,
/* 2ed - _D8_05 */  0x2194,
/* 2ee - _D8_06 */  0x2195,
/* 2ef - _D8_07 */  0x2196,
/* 2f0 - _D8_C0 */  0x2197,
/* 2f1 - _D8_C0 */  0x2198,
/* 2f2 - _D8_C0 */  0x2199,
/* 2f3 - _D8_C0 */  0x219a,
/* 2f4 - _D8_C0 */  0x219b,
/* 2f5 - _D8_C0 */  0x219c,
/* 2f6 - _D8_C0 */  0x219d,
/* 2f7 - _D8_C0 */  0x219e,
/* 2f8 - _D8_C8 */  0x219f,
/* 2f9 - _D8_C8 */  0x21a0,
/* 2fa - _D8_C8 */  0x21a1,
/* 2fb - _D8_C8 */  0x21a2,
/* 2fc - _D8_C8 */  0x21a3,
/* 2fd - _D8_C8 */  0x21a4,
/* 2fe - _D8_C8 */  0x21a5,
/* 2ff - _D8_C8 */  0x21a6,
/* 300 - _D8_D0 */  0x21a7,
/* 301 - _D8_D0 */  0x21a8,
/* 302 - _D8_D0 */  0x21a9,
/* 303 - _D8_D0 */  0x21aa,
/* 304 - _D8_D0 */  0x21ab,
/* 305 - _D8_D0 */  0x21ac,
/* 306 - _D8_D0 */  0x21ad,
/* 307 - _D8_D0 */  0x21ae,
/* 308 - _D8_D8 */  0x21af,
/* 309 - _D8_D9 */  0x21b0,
/* 30a - _D8_D8 */  0x21b1,
/* 30b - _D8_D8 */  0x21b2,
/* 30c - _D8_D8 */  0x21b3,
/* 30d - _D8_D8 */  0x21b4,
/* 30e - _D8_D8 */  0x21b5,
/* 30f - _D8_D8 */  0x21b6,
/* 310 - _D8_E0 */  0x21b7,
/* 311 - _D8_E0 */  0x21b8,
/* 312 - _D8_E0 */  0x21b9,
/* 313 - _D8_E0 */  0x21ba,
/* 314 - _D8_E0 */  0x21bb,
/* 315 - _D8_E0 */  0x21bc,
/* 316 - _D8_E0 */  0x21bd,
/* 317 - _D8_E0 */  0x21be,
/* 318 - _D8_E8 */  0x21bf,
/* 319 - _D8_E8 */  0x21c0,
/* 31a - _D8_E8 */  0x21c1,
/* 31b - _D8_E8 */  0x21c2,
/* 31c - _D8_E8 */  0x21c3,
/* 31d - _D8_E8 */  0x21c4,
/* 31e - _D8_E8 */  0x21c5,
/* 31f - _D8_E8 */  0x21c6,
/* 320 - _D8_F0 */  0x21c7,
/* 321 - _D8_F0 */  0x21c8,
/* 322 - _D8_F0 */  0x21c9,
/* 323 - _D8_F0 */  0x21ca,
/* 324 - _D8_F0 */  0x21cb,
/* 325 - _D8_F0 */  0x21cc,
/* 326 - _D8_F0 */  0x21cd,
/* 327 - _D8_F0 */  0x21ce,
/* 328 - _D8_F8 */  0x21cf,
/* 329 - _D8_F8 */  0x21d0,
/* 32a - _D8_F8 */  0x21d1,
/* 32b - _D8_F8 */  0x21d2,
/* 32c - _D8_F8 */  0x21d3,
/* 32d - _D8_F8 */  0x21d4,
/* 32e - _D8_F8 */  0x21d5,
/* 32f - _D8_F8 */  0x21d6,
/* 330 - _D9_00 */  0x21d7,
/* 331 -  */  0,
/* 332 - _D9_02 */  0x21d8,
/* 333 - _D9_03 */  0x21d9,
/* 334 - _D9_04 */  0x21da,
/* 335 - _D9_05 */  0x21db,
/* 336 - _D9_06 */  0xef24,
/* 337 - _D9_07 */  0xef30,
/* 338 - _D9_C0 */  0x21dc,
/* 339 - _D9_C0 */  0x21dd,
/* 33a - _D9_C0 */  0x21de,
/* 33b - _D9_C0 */  0x21df,
/* 33c - _D9_C0 */  0x21e0,
/* 33d - _D9_C0 */  0x21e1,
/* 33e - _D9_C0 */  0x21e2,
/* 33f - _D9_C0 */  0x21e3,
/* 340 - _D9_C8 */  0x21e4,
/* 341 - _D9_C9 */  0x21e5,
/* 342 - _D9_C8 */  0x21e6,
/* 343 - _D9_C8 */  0x21e7,
/* 344 - _D9_C8 */  0x21e8,
/* 345 - _D9_C8 */  0x21e9,
/* 346 - _D9_C8 */  0x21ea,
/* 347 - _D9_C8 */  0x21eb,
/* 348 - _D9_D0 */  0x21ec,
/* 349 -  */  0,
/* 34a -  */  0,
/* 34b -  */  0,
/* 34c -  */  0,
/* 34d -  */  0,
/* 34e -  */  0,
/* 34f -  */  0,
/* 350 -  */  0,
/* 351 -  */  0,
/* 352 -  */  0,
/* 353 -  */  0,
/* 354 -  */  0,
/* 355 -  */  0,
/* 356 -  */  0,
/* 357 -  */  0,
/* 358 - _D9_E0 */  0x21ed,
/* 359 - _D9_E1 */  0x21ee,
/* 35a -  */  0,
/* 35b -  */  0,
/* 35c - _D9_E4 */  0x21ef,
/* 35d - _D9_E5 */  0x21f0,
/* 35e -  */  0,
/* 35f -  */  0,
/* 360 - _D9_E8 */  0x21f1,
/* 361 - _D9_E9 */  0x21f2,
/* 362 - _D9_EA */  0x21f3,
/* 363 - _D9_EB */  0x21f4,
/* 364 - _D9_EC */  0x21f5,
/* 365 - _D9_ED */  0x21f6,
/* 366 - _D9_EE */  0x21f7,
/* 367 -  */  0,
/* 368 - _D9_F0 */  0x21f8,
/* 369 - _D9_F1 */  0x21f9,
/* 36a - _D9_F2 */  0x21fa,
/* 36b - _D9_F3 */  0x21fb,
/* 36c - _D9_F4 */  0x21fc,
/* 36d - _D9_F5 */  0x21fd,
/* 36e - _D9_F6 */  0x21fe,
/* 36f - _D9_F7 */  0x21ff,
/* 370 - _D9_F8 */  0x2200,
/* 371 - _D9_F9 */  0x2201,
/* 372 - _D9_FA */  0x2202,
/* 373 - _D9_FB */  0x2203,
/* 374 - _D9_FC */  0x2204,
/* 375 - _D9_FD */  0x2205,
/* 376 - _D9_FE */  0x2206,
/* 377 - _D9_FF */  0x2207,
/* 378 - _DA_00 */  0x2208,
/* 379 - _DA_01 */  0x2209,
/* 37a - _DA_02 */  0x220a,
/* 37b - _DA_03 */  0x220b,
/* 37c - _DA_04 */  0x220c,
/* 37d - _DA_05 */  0x220d,
/* 37e - _DA_06 */  0x220e,
/* 37f - _DA_07 */  0x220f,
/* 380 - _DA_C0 */  0x2210,
/* 381 - _DA_C0 */  0x2211,
/* 382 - _DA_C0 */  0x2212,
/* 383 - _DA_C0 */  0x2213,
/* 384 - _DA_C0 */  0x2214,
/* 385 - _DA_C0 */  0x2215,
/* 386 - _DA_C0 */  0x2216,
/* 387 - _DA_C0 */  0x2217,
/* 388 - _DA_C8 */  0x2218,
/* 389 - _DA_C8 */  0x2219,
/* 38a - _DA_C8 */  0x221a,
/* 38b - _DA_C8 */  0x221b,
/* 38c - _DA_C8 */  0x221c,
/* 38d - _DA_C8 */  0x221d,
/* 38e - _DA_C8 */  0x221e,
/* 38f - _DA_C8 */  0x221f,
/* 390 - _DA_D0 */  0x2220,
/* 391 - _DA_D0 */  0x2221,
/* 392 - _DA_D0 */  0x2222,
/* 393 - _DA_D0 */  0x2223,
/* 394 - _DA_D0 */  0x2224,
/* 395 - _DA_D0 */  0x2225,
/* 396 - _DA_D0 */  0x2226,
/* 397 - _DA_D0 */  0x2227,
/* 398 - _DA_D8 */  0x2228,
/* 399 - _DA_D8 */  0x2229,
/* 39a - _DA_D8 */  0x222a,
/* 39b - _DA_D8 */  0x222b,
/* 39c - _DA_D8 */  0x222c,
/* 39d - _DA_D8 */  0x222d,
/* 39e - _DA_D8 */  0x222e,
/* 39f - _DA_D8 */  0x222f,
/* 3a0 -  */  0,
/* 3a1 -  */  0,
/* 3a2 -  */  0,
/* 3a3 -  */  0,
/* 3a4 -  */  0,
/* 3a5 -  */  0,
/* 3a6 -  */  0,
/* 3a7 -  */  0,
/* 3a8 -  */  0,
/* 3a9 - _DA_E9 */  0x2230,
/* 3aa -  */  0,
/* 3ab -  */  0,
/* 3ac -  */  0,
/* 3ad -  */  0,
/* 3ae -  */  0,
/* 3af -  */  0,
/* 3b0 -  */  0,
/* 3b1 -  */  0,
/* 3b2 -  */  0,
/* 3b3 -  */  0,
/* 3b4 -  */  0,
/* 3b5 -  */  0,
/* 3b6 -  */  0,
/* 3b7 -  */  0,
/* 3b8 -  */  0,
/* 3b9 -  */  0,
/* 3ba -  */  0,
/* 3bb -  */  0,
/* 3bc -  */  0,
/* 3bd -  */  0,
/* 3be -  */  0,
/* 3bf -  */  0,
/* 3c0 - _DB_00 */  0x2231,
/* 3c1 - _DB_01 */  0x2232,
/* 3c2 - _DB_02 */  0x2233,
/* 3c3 - _DB_03 */  0x2234,
/* 3c4 -  */  0,
/* 3c5 - _DB_05 */  0x2235,
/* 3c6 -  */  0,
/* 3c7 - _DB_07 */  0x2236,
/* 3c8 - _DB_C0 */  0x2237,
/* 3c9 - _DB_C0 */  0x2238,
/* 3ca - _DB_C0 */  0x2239,
/* 3cb - _DB_C0 */  0x223a,
/* 3cc - _DB_C0 */  0x223b,
/* 3cd - _DB_C0 */  0x223c,
/* 3ce - _DB_C0 */  0x223d,
/* 3cf - _DB_C0 */  0x223e,
/* 3d0 - _DB_C8 */  0x223f,
/* 3d1 - _DB_C8 */  0x2240,
/* 3d2 - _DB_C8 */  0x2241,
/* 3d3 - _DB_C8 */  0x2242,
/* 3d4 - _DB_C8 */  0x2243,
/* 3d5 - _DB_C8 */  0x2244,
/* 3d6 - _DB_C8 */  0x2245,
/* 3d7 - _DB_C8 */  0x2246,
/* 3d8 - _DB_D0 */  0x2247,
/* 3d9 - _DB_D0 */  0x2248,
/* 3da - _DB_D0 */  0x2249,
/* 3db - _DB_D0 */  0x224a,
/* 3dc - _DB_D0 */  0x224b,
/* 3dd - _DB_D0 */  0x224c,
/* 3de - _DB_D0 */  0x224d,
/* 3df - _DB_D0 */  0x224e,
/* 3e0 - _DB_D8 */  0x224f,
/* 3e1 - _DB_D8 */  0x2250,
/* 3e2 - _DB_D8 */  0x2251,
/* 3e3 - _DB_D8 */  0x2252,
/* 3e4 - _DB_D8 */  0x2253,
/* 3e5 - _DB_D8 */  0x2254,
/* 3e6 - _DB_D8 */  0x2255,
/* 3e7 - _DB_D8 */  0x2256,
/* 3e8 - _DB_E0 */  0x2257,
/* 3e9 - _DB_E1 */  0x2258,
/* 3ea - _DB_E2 */  0xef3c,
/* 3eb - _DB_E3 */  0xef48,
/* 3ec - _DB_E4 */  0x2259,
/* 3ed -  */  0,
/* 3ee -  */  0,
/* 3ef -  */  0,
/* 3f0 - _DB_E8 */  0x225a,
/* 3f1 - _DB_E8 */  0x225b,
/* 3f2 - _DB_E8 */  0x225c,
/* 3f3 - _DB_E8 */  0x225d,
/* 3f4 - _DB_E8 */  0x225e,
/* 3f5 - _DB_E8 */  0x225f,
/* 3f6 - _DB_E8 */  0x2260,
/* 3f7 - _DB_E8 */  0x2261,
/* 3f8 - _DB_F0 */  0x2262,
/* 3f9 - _DB_F0 */  0x2263,
/* 3fa - _DB_F0 */  0x2264,
/* 3fb - _DB_F0 */  0x2265,
/* 3fc - _DB_F0 */  0x2266,
/* 3fd - _DB_F0 */  0x2267,
/* 3fe - _DB_F0 */  0x2268,
/* 3ff - _DB_F0 */  0x2269,
/* 400 -  */  0,
/* 401 -  */  0,
/* 402 -  */  0,
/* 403 -  */  0,
/* 404 -  */  0,
/* 405 -  */  0,
/* 406 -  */  0,
/* 407 -  */  0,
/* 408 - _DC_00 */  0x226a,
/* 409 - _DC_01 */  0x226b,
/* 40a - _DC_02 */  0x226c,
/* 40b - _DC_03 */  0x226d,
/* 40c - _DC_04 */  0x226e,
/* 40d - _DC_05 */  0x226f,
/* 40e - _DC_06 */  0x2270,
/* 40f - _DC_07 */  0x2271,
/* 410 - _DC_C0 */  0x2272,
/* 411 - _DC_C0 */  0x2273,
/* 412 - _DC_C0 */  0x2274,
/* 413 - _DC_C0 */  0x2275,
/* 414 - _DC_C0 */  0x2276,
/* 415 - _DC_C0 */  0x2277,
/* 416 - _DC_C0 */  0x2278,
/* 417 - _DC_C0 */  0x2279,
/* 418 - _DC_C8 */  0x227a,
/* 419 - _DC_C8 */  0x227b,
/* 41a - _DC_C8 */  0x227c,
/* 41b - _DC_C8 */  0x227d,
/* 41c - _DC_C8 */  0x227e,
/* 41d - _DC_C8 */  0x227f,
/* 41e - _DC_C8 */  0x2280,
/* 41f - _DC_C8 */  0x2281,
/* 420 -  */  0,
/* 421 -  */  0,
/* 422 -  */  0,
/* 423 -  */  0,
/* 424 -  */  0,
/* 425 -  */  0,
/* 426 -  */  0,
/* 427 -  */  0,
/* 428 -  */  0,
/* 429 -  */  0,
/* 42a -  */  0,
/* 42b -  */  0,
/* 42c -  */  0,
/* 42d -  */  0,
/* 42e -  */  0,
/* 42f -  */  0,
/* 430 - _DC_E0 */  0x2282,
/* 431 - _DC_E0 */  0x2283,
/* 432 - _DC_E0 */  0x2284,
/* 433 - _DC_E0 */  0x2285,
/* 434 - _DC_E0 */  0x2286,
/* 435 - _DC_E0 */  0x2287,
/* 436 - _DC_E0 */  0x2288,
/* 437 - _DC_E0 */  0x2289,
/* 438 - _DC_E8 */  0x228a,
/* 439 - _DC_E8 */  0x228b,
/* 43a - _DC_E8 */  0x228c,
/* 43b - _DC_E8 */  0x228d,
/* 43c - _DC_E8 */  0x228e,
/* 43d - _DC_E8 */  0x228f,
/* 43e - _DC_E8 */  0x2290,
/* 43f - _DC_E8 */  0x2291,
/* 440 - _DC_F0 */  0x2292,
/* 441 - _DC_F0 */  0x2293,
/* 442 - _DC_F0 */  0x2294,
/* 443 - _DC_F0 */  0x2295,
/* 444 - _DC_F0 */  0x2296,
/* 445 - _DC_F0 */  0x2297,
/* 446 - _DC_F0 */  0x2298,
/* 447 - _DC_F0 */  0x2299,
/* 448 - _DC_F8 */  0x229a,
/* 449 - _DC_F8 */  0x229b,
/* 44a - _DC_F8 */  0x229c,
/* 44b - _DC_F8 */  0x229d,
/* 44c - _DC_F8 */  0x229e,
/* 44d - _DC_F8 */  0x229f,
/* 44e - _DC_F8 */  0x22a0,
/* 44f - _DC_F8 */  0x22a1,
/* 450 - _DD_00 */  0x22a2,
/* 451 - _DD_01 */  0x22a3,
/* 452 - _DD_02 */  0x22a4,
/* 453 - _DD_03 */  0x22a5,
/* 454 - _DD_04 */  0x22a6,
/* 455 -  */  0,
/* 456 - _DD_06 */  0xef54,
/* 457 - _DD_07 */  0xef60,
/* 458 - _DD_C0 */  0x22a7,
/* 459 - _DD_C0 */  0x22a8,
/* 45a - _DD_C0 */  0x22a9,
/* 45b - _DD_C0 */  0x22aa,
/* 45c - _DD_C0 */  0x22ab,
/* 45d - _DD_C0 */  0x22ac,
/* 45e - _DD_C0 */  0x22ad,
/* 45f - _DD_C0 */  0x22ae,
/* 460 -  */  0,
/* 461 -  */  0,
/* 462 -  */  0,
/* 463 -  */  0,
/* 464 -  */  0,
/* 465 -  */  0,
/* 466 -  */  0,
/* 467 -  */  0,
/* 468 - _DD_D0 */  0x22af,
/* 469 - _DD_D0 */  0x22b0,
/* 46a - _DD_D0 */  0x22b1,
/* 46b - _DD_D0 */  0x22b2,
/* 46c - _DD_D0 */  0x22b3,
/* 46d - _DD_D0 */  0x22b4,
/* 46e - _DD_D0 */  0x22b5,
/* 46f - _DD_D0 */  0x22b6,
/* 470 - _DD_D8 */  0x22b7,
/* 471 - _DD_D8 */  0x22b8,
/* 472 - _DD_D8 */  0x22b9,
/* 473 - _DD_D8 */  0x22ba,
/* 474 - _DD_D8 */  0x22bb,
/* 475 - _DD_D8 */  0x22bc,
/* 476 - _DD_D8 */  0x22bd,
/* 477 - _DD_D8 */  0x22be,
/* 478 - _DD_E0 */  0x22bf,
/* 479 - _DD_E1 */  0x22c0,
/* 47a - _DD_E0 */  0x22c1,
/* 47b - _DD_E0 */  0x22c2,
/* 47c - _DD_E0 */  0x22c3,
/* 47d - _DD_E0 */  0x22c4,
/* 47e - _DD_E0 */  0x22c5,
/* 47f - _DD_E0 */  0x22c6,
/* 480 - _DD_E8 */  0x22c7,
/* 481 - _DD_E9 */  0x22c8,
/* 482 - _DD_E8 */  0x22c9,
/* 483 - _DD_E8 */  0x22ca,
/* 484 - _DD_E8 */  0x22cb,
/* 485 - _DD_E8 */  0x22cc,
/* 486 - _DD_E8 */  0x22cd,
/* 487 - _DD_E8 */  0x22ce,
/* 488 -  */  0,
/* 489 -  */  0,
/* 48a -  */  0,
/* 48b -  */  0,
/* 48c -  */  0,
/* 48d -  */  0,
/* 48e -  */  0,
/* 48f -  */  0,
/* 490 -  */  0,
/* 491 -  */  0,
/* 492 -  */  0,
/* 493 -  */  0,
/* 494 -  */  0,
/* 495 -  */  0,
/* 496 -  */  0,
/* 497 -  */  0,
/* 498 - _DE_00 */  0x22cf,
/* 499 - _DE_01 */  0x22d0,
/* 49a - _DE_02 */  0x22d1,
/* 49b - _DE_03 */  0x22d2,
/* 49c - _DE_04 */  0x22d3,
/* 49d - _DE_05 */  0x22d4,
/* 49e - _DE_06 */  0x22d5,
/* 49f - _DE_07 */  0x22d6,
/* 4a0 - _DE_C0 */  0x22d7,
/* 4a1 - _DE_C1 */  0x22d8,
/* 4a2 - _DE_C0 */  0x22d9,
/* 4a3 - _DE_C0 */  0x22da,
/* 4a4 - _DE_C0 */  0x22db,
/* 4a5 - _DE_C0 */  0x22dc,
/* 4a6 - _DE_C0 */  0x22dd,
/* 4a7 - _DE_C0 */  0x22de,
/* 4a8 - _DE_C8 */  0x22df,
/* 4a9 - _DE_C9 */  0x22e0,
/* 4aa - _DE_C8 */  0x22e1,
/* 4ab - _DE_C8 */  0x22e2,
/* 4ac - _DE_C8 */  0x22e3,
/* 4ad - _DE_C8 */  0x22e4,
/* 4ae - _DE_C8 */  0x22e5,
/* 4af - _DE_C8 */  0x22e6,
/* 4b0 -  */  0,
/* 4b1 -  */  0,
/* 4b2 -  */  0,
/* 4b3 -  */  0,
/* 4b4 -  */  0,
/* 4b5 -  */  0,
/* 4b6 -  */  0,
/* 4b7 -  */  0,
/* 4b8 -  */  0,
/* 4b9 - _DE_D9 */  0x22e7,
/* 4ba -  */  0,
/* 4bb -  */  0,
/* 4bc -  */  0,
/* 4bd -  */  0,
/* 4be -  */  0,
/* 4bf -  */  0,
/* 4c0 - _DE_E0 */  0x22e8,
/* 4c1 - _DE_E1 */  0x22e9,
/* 4c2 - _DE_E0 */  0x22ea,
/* 4c3 - _DE_E0 */  0x22eb,
/* 4c4 - _DE_E0 */  0x22ec,
/* 4c5 - _DE_E0 */  0x22ed,
/* 4c6 - _DE_E0 */  0x22ee,
/* 4c7 - _DE_E0 */  0x22ef,
/* 4c8 - _DE_E8 */  0x22f0,
/* 4c9 - _DE_E9 */  0x22f1,
/* 4ca - _DE_E8 */  0x22f2,
/* 4cb - _DE_E8 */  0x22f3,
/* 4cc - _DE_E8 */  0x22f4,
/* 4cd - _DE_E8 */  0x22f5,
/* 4ce - _DE_E8 */  0x22f6,
/* 4cf - _DE_E8 */  0x22f7,
/* 4d0 - _DE_F0 */  0x22f8,
/* 4d1 - _DE_F1 */  0x22f9,
/* 4d2 - _DE_F0 */  0x22fa,
/* 4d3 - _DE_F0 */  0x22fb,
/* 4d4 - _DE_F0 */  0x22fc,
/* 4d5 - _DE_F0 */  0x22fd,
/* 4d6 - _DE_F0 */  0x22fe,
/* 4d7 - _DE_F0 */  0x22ff,
/* 4d8 - _DE_F8 */  0x2300,
/* 4d9 - _DE_F9 */  0x2301,
/* 4da - _DE_F8 */  0x2302,
/* 4db - _DE_F8 */  0x2303,
/* 4dc - _DE_F8 */  0x2304,
/* 4dd - _DE_F8 */  0x2305,
/* 4de - _DE_F8 */  0x2306,
/* 4df - _DE_F8 */  0x2307,
/* 4e0 - _DF_00 */  0x2308,
/* 4e1 - _DF_01 */  0x2309,
/* 4e2 - _DF_02 */  0x230a,
/* 4e3 - _DF_03 */  0x230b,
/* 4e4 - _DF_04 */  0x230c,
/* 4e5 - _DF_05 */  0x230d,
/* 4e6 - _DF_06 */  0x230e,
/* 4e7 - _DF_07 */  0x230f,
/* 4e8 -  */  0,
/* 4e9 -  */  0,
/* 4ea -  */  0,
/* 4eb -  */  0,
/* 4ec -  */  0,
/* 4ed -  */  0,
/* 4ee -  */  0,
/* 4ef -  */  0,
/* 4f0 -  */  0,
/* 4f1 -  */  0,
/* 4f2 -  */  0,
/* 4f3 -  */  0,
/* 4f4 -  */  0,
/* 4f5 -  */  0,
/* 4f6 -  */  0,
/* 4f7 -  */  0,
/* 4f8 -  */  0,
/* 4f9 -  */  0,
/* 4fa -  */  0,
/* 4fb -  */  0,
/* 4fc -  */  0,
/* 4fd -  */  0,
/* 4fe -  */  0,
/* 4ff -  */  0,
/* 500 -  */  0,
/* 501 -  */  0,
/* 502 -  */  0,
/* 503 -  */  0,
/* 504 -  */  0,
/* 505 -  */  0,
/* 506 -  */  0,
/* 507 -  */  0,
/* 508 - _DF_E0 */  0xef6c,
/* 509 -  */  0,
/* 50a -  */  0,
/* 50b -  */  0,
/* 50c -  */  0,
/* 50d -  */  0,
/* 50e -  */  0,
/* 50f -  */  0,
/* 510 - _DF_E8 */  0x2310,
/* 511 - _DF_E8 */  0x2311,
/* 512 - _DF_E8 */  0x2312,
/* 513 - _DF_E8 */  0x2313,
/* 514 - _DF_E8 */  0x2314,
/* 515 - _DF_E8 */  0x2315,
/* 516 - _DF_E8 */  0x2316,
/* 517 - _DF_E8 */  0x2317,
/* 518 - _DF_F0 */  0x2318,
/* 519 - _DF_F0 */  0x2319,
/* 51a - _DF_F0 */  0x231a,
/* 51b - _DF_F0 */  0x231b,
/* 51c - _DF_F0 */  0x231c,
/* 51d - _DF_F0 */  0x231d,
/* 51e - _DF_F0 */  0x231e,
/* 51f - _DF_F0 */  0x231f,
/* 520 -  */  0,
/* 521 -  */  0,
/* 522 -  */  0,
/* 523 -  */  0,
/* 524 -  */  0,
/* 525 -  */  0,
/* 526 -  */  0,
/* 527 -  */  0,
/* 528 - _F6_00 */  0x2320,
/* 529 -  */  0,
/* 52a - _F6_02 */  0x2321,
/* 52b - _F6_03 */  0x2322,
/* 52c - _F6_04 */  0x2323,
/* 52d - _F6_05 */  0x2324,
/* 52e - _F6_06 */  0x2325,
/* 52f - _F6_07 */  0x2326,
/* 530 - _F7_00 */  0x2327,
/* 531 -  */  0,
/* 532 - _F7_02 */  0x2328,
/* 533 - _F7_03 */  0x2329,
/* 534 - _F7_04 */  0x232a,
/* 535 - _F7_05 */  0x232b,
/* 536 - _F7_06 */  0x232c,
/* 537 - _F7_07 */  0x232d,
/* 538 - _FE_00 */  0x232e,
/* 539 - _FE_01 */  0x232f,
/* 53a -  */  0,
/* 53b -  */  0,
/* 53c -  */  0,
/* 53d -  */  0,
/* 53e -  */  0,
/* 53f -  */  0,
/* 540 - _FF_00 */  0x2330,
/* 541 - _FF_01 */  0x2331,
/* 542 - _FF_02 */  0x2332,
/* 543 - _FF_03 */  0x2333,
/* 544 - _FF_04 */  0x2334,
/* 545 - _FF_05 */  0x2335,
/* 546 - _FF_06 */  0x2336,
/* 547 -  */  0,
/* 548 - _0F_00_00 */  0x2337,
/* 549 - _0F_00_01 */  0x2338,
/* 54a - _0F_00_02 */  0x2339,
/* 54b - _0F_00_03 */  0x233a,
/* 54c - _0F_00_04 */  0x233b,
/* 54d - _0F_00_05 */  0x233c,
/* 54e -  */  0,
/* 54f -  */  0,
/* 550 - _0F_01_00 */  0x233d,
/* 551 - _0F_01_01 */  0x233e,
/* 552 - _0F_01_02 */  0x233f,
/* 553 - _0F_01_03 */  0x2340,
/* 554 - _0F_01_04 */  0x2341,
/* 555 -  */  0,
/* 556 - _0F_01_06 */  0x2342,
/* 557 - _0F_01_07 */  0x2343,
/* 558 -  */  0,
/* 559 - _0F_01_C1 */  0x2344,
/* 55a - _0F_01_C2 */  0x2345,
/* 55b - _0F_01_C3 */  0x2346,
/* 55c - _0F_01_C4 */  0x2347,
/* 55d -  */  0,
/* 55e -  */  0,
/* 55f -  */  0,
/* 560 - _0F_01_C8 */  0x2348,
/* 561 - _0F_01_C9 */  0x2349,
/* 562 -  */  0,
/* 563 -  */  0,
/* 564 -  */  0,
/* 565 -  */  0,
/* 566 -  */  0,
/* 567 -  */  0,
/* 568 - _0F_01_D0 */  0x234a,
/* 569 - _0F_01_D1 */  0x234b,
/* 56a -  */  0,
/* 56b -  */  0,
/* 56c - _0F_01_D4 */  0x234c,
/* 56d - _0F_01_D5 */  0x234d,
/* 56e -  */  0,
/* 56f -  */  0,
/* 570 - _0F_01_D8 */  0x234e,
/* 571 - _0F_01_D9 */  0x234f,
/* 572 - _0F_01_DA */  0x2350,
/* 573 - _0F_01_DB */  0x2351,
/* 574 - _0F_01_DC */  0x2352,
/* 575 - _0F_01_DD */  0x2353,
/* 576 - _0F_01_DE */  0x2354,
/* 577 - _0F_01_DF */  0x2355,
/* 578 -  */  0,
/* 579 -  */  0,
/* 57a -  */  0,
/* 57b -  */  0,
/* 57c -  */  0,
/* 57d -  */  0,
/* 57e -  */  0,
/* 57f -  */  0,
/* 580 -  */  0,
/* 581 -  */  0,
/* 582 -  */  0,
/* 583 -  */  0,
/* 584 -  */  0,
/* 585 -  */  0,
/* 586 -  */  0,
/* 587 -  */  0,
/* 588 -  */  0,
/* 589 -  */  0,
/* 58a -  */  0,
/* 58b -  */  0,
/* 58c -  */  0,
/* 58d -  */  0,
/* 58e -  */  0,
/* 58f -  */  0,
/* 590 - _0F_01_F8 */  0x2356,
/* 591 - _0F_01_F9 */  0x2357,
/* 592 -  */  0,
/* 593 -  */  0,
/* 594 -  */  0,
/* 595 -  */  0,
/* 596 -  */  0,
/* 597 -  */  0,
/* 598 - _0F_0D_00 */  0x2358,
/* 599 - _0F_0D_01 */  0x2359,
/* 59a -  */  0,
/* 59b -  */  0,
/* 59c -  */  0,
/* 59d -  */  0,
/* 59e -  */  0,
/* 59f -  */  0,
/* 5a0 -  */  0,
/* 5a1 -  */  0,
/* 5a2 -  */  0,
/* 5a3 -  */  0,
/* 5a4 -  */  0,
/* 5a5 -  */  0,
/* 5a6 -  */  0,
/* 5a7 -  */  0,
/* 5a8 -  */  0,
/* 5a9 -  */  0,
/* 5aa -  */  0,
/* 5ab -  */  0,
/* 5ac - _0F_0F_0C */  0x235a,
/* 5ad - _0F_0F_0D */  0x235b,
/* 5ae -  */  0,
/* 5af -  */  0,
/* 5b0 -  */  0,
/* 5b1 -  */  0,
/* 5b2 -  */  0,
/* 5b3 -  */  0,
/* 5b4 -  */  0,
/* 5b5 -  */  0,
/* 5b6 -  */  0,
/* 5b7 -  */  0,
/* 5b8 -  */  0,
/* 5b9 -  */  0,
/* 5ba -  */  0,
/* 5bb -  */  0,
/* 5bc - _0F_0F_1C */  0x235c,
/* 5bd - _0F_0F_1D */  0x235d,
/* 5be -  */  0,
/* 5bf -  */  0,
/* 5c0 -  */  0,
/* 5c1 -  */  0,
/* 5c2 -  */  0,
/* 5c3 -  */  0,
/* 5c4 -  */  0,
/* 5c5 -  */  0,
/* 5c6 -  */  0,
/* 5c7 -  */  0,
/* 5c8 -  */  0,
/* 5c9 -  */  0,
/* 5ca -  */  0,
/* 5cb -  */  0,
/* 5cc -  */  0,
/* 5cd -  */  0,
/* 5ce -  */  0,
/* 5cf -  */  0,
/* 5d0 -  */  0,
/* 5d1 -  */  0,
/* 5d2 -  */  0,
/* 5d3 -  */  0,
/* 5d4 -  */  0,
/* 5d5 -  */  0,
/* 5d6 -  */  0,
/* 5d7 -  */  0,
/* 5d8 -  */  0,
/* 5d9 -  */  0,
/* 5da -  */  0,
/* 5db -  */  0,
/* 5dc -  */  0,
/* 5dd -  */  0,
/* 5de -  */  0,
/* 5df -  */  0,
/* 5e0 -  */  0,
/* 5e1 -  */  0,
/* 5e2 -  */  0,
/* 5e3 -  */  0,
/* 5e4 -  */  0,
/* 5e5 -  */  0,
/* 5e6 -  */  0,
/* 5e7 -  */  0,
/* 5e8 -  */  0,
/* 5e9 -  */  0,
/* 5ea -  */  0,
/* 5eb -  */  0,
/* 5ec -  */  0,
/* 5ed -  */  0,
/* 5ee -  */  0,
/* 5ef -  */  0,
/* 5f0 -  */  0,
/* 5f1 -  */  0,
/* 5f2 -  */  0,
/* 5f3 -  */  0,
/* 5f4 -  */  0,
/* 5f5 -  */  0,
/* 5f6 -  */  0,
/* 5f7 -  */  0,
/* 5f8 -  */  0,
/* 5f9 -  */  0,
/* 5fa -  */  0,
/* 5fb -  */  0,
/* 5fc -  */  0,
/* 5fd -  */  0,
/* 5fe -  */  0,
/* 5ff -  */  0,
/* 600 -  */  0,
/* 601 -  */  0,
/* 602 -  */  0,
/* 603 -  */  0,
/* 604 -  */  0,
/* 605 -  */  0,
/* 606 -  */  0,
/* 607 -  */  0,
/* 608 -  */  0,
/* 609 -  */  0,
/* 60a -  */  0,
/* 60b -  */  0,
/* 60c -  */  0,
/* 60d -  */  0,
/* 60e -  */  0,
/* 60f -  */  0,
/* 610 -  */  0,
/* 611 -  */  0,
/* 612 -  */  0,
/* 613 -  */  0,
/* 614 -  */  0,
/* 615 -  */  0,
/* 616 -  */  0,
/* 617 -  */  0,
/* 618 -  */  0,
/* 619 -  */  0,
/* 61a -  */  0,
/* 61b -  */  0,
/* 61c -  */  0,
/* 61d -  */  0,
/* 61e -  */  0,
/* 61f -  */  0,
/* 620 -  */  0,
/* 621 -  */  0,
/* 622 -  */  0,
/* 623 -  */  0,
/* 624 -  */  0,
/* 625 -  */  0,
/* 626 -  */  0,
/* 627 -  */  0,
/* 628 -  */  0,
/* 629 -  */  0,
/* 62a - _0F_0F_8A */  0x235e,
/* 62b -  */  0,
/* 62c -  */  0,
/* 62d -  */  0,
/* 62e - _0F_0F_8E */  0x235f,
/* 62f -  */  0,
/* 630 - _0F_0F_90 */  0x2360,
/* 631 -  */  0,
/* 632 -  */  0,
/* 633 -  */  0,
/* 634 - _0F_0F_94 */  0x2361,
/* 635 -  */  0,
/* 636 - _0F_0F_96 */  0x2362,
/* 637 - _0F_0F_97 */  0x2363,
/* 638 -  */  0,
/* 639 -  */  0,
/* 63a - _0F_0F_9A */  0x2364,
/* 63b -  */  0,
/* 63c -  */  0,
/* 63d -  */  0,
/* 63e - _0F_0F_9E */  0x2365,
/* 63f -  */  0,
/* 640 - _0F_0F_A0 */  0x2366,
/* 641 -  */  0,
/* 642 -  */  0,
/* 643 -  */  0,
/* 644 - _0F_0F_A4 */  0x2367,
/* 645 -  */  0,
/* 646 - _0F_0F_A6 */  0x2368,
/* 647 - _0F_0F_A7 */  0x2369,
/* 648 -  */  0,
/* 649 -  */  0,
/* 64a - _0F_0F_AA */  0x236a,
/* 64b -  */  0,
/* 64c -  */  0,
/* 64d -  */  0,
/* 64e - _0F_0F_AE */  0x236b,
/* 64f -  */  0,
/* 650 - _0F_0F_B0 */  0x236c,
/* 651 -  */  0,
/* 652 -  */  0,
/* 653 -  */  0,
/* 654 - _0F_0F_B4 */  0x236d,
/* 655 -  */  0,
/* 656 - _0F_0F_B6 */  0x236e,
/* 657 - _0F_0F_B7 */  0x236f,
/* 658 -  */  0,
/* 659 -  */  0,
/* 65a -  */  0,
/* 65b - _0F_0F_BB */  0x2370,
/* 65c -  */  0,
/* 65d -  */  0,
/* 65e -  */  0,
/* 65f - _0F_0F_BF */  0x2371,
/* 660 -  */  0,
/* 661 -  */  0,
/* 662 -  */  0,
/* 663 -  */  0,
/* 664 -  */  0,
/* 665 -  */  0,
/* 666 -  */  0,
/* 667 -  */  0,
/* 668 -  */  0,
/* 669 -  */  0,
/* 66a -  */  0,
/* 66b -  */  0,
/* 66c -  */  0,
/* 66d -  */  0,
/* 66e -  */  0,
/* 66f -  */  0,
/* 670 -  */  0,
/* 671 -  */  0,
/* 672 -  */  0,
/* 673 -  */  0,
/* 674 -  */  0,
/* 675 -  */  0,
/* 676 -  */  0,
/* 677 -  */  0,
/* 678 -  */  0,
/* 679 -  */  0,
/* 67a -  */  0,
/* 67b -  */  0,
/* 67c -  */  0,
/* 67d -  */  0,
/* 67e -  */  0,
/* 67f -  */  0,
/* 680 -  */  0,
/* 681 -  */  0,
/* 682 -  */  0,
/* 683 -  */  0,
/* 684 -  */  0,
/* 685 -  */  0,
/* 686 -  */  0,
/* 687 -  */  0,
/* 688 -  */  0,
/* 689 -  */  0,
/* 68a -  */  0,
/* 68b -  */  0,
/* 68c -  */  0,
/* 68d -  */  0,
/* 68e -  */  0,
/* 68f -  */  0,
/* 690 -  */  0,
/* 691 -  */  0,
/* 692 -  */  0,
/* 693 -  */  0,
/* 694 -  */  0,
/* 695 -  */  0,
/* 696 -  */  0,
/* 697 -  */  0,
/* 698 -  */  0,
/* 699 -  */  0,
/* 69a -  */  0,
/* 69b -  */  0,
/* 69c -  */  0,
/* 69d -  */  0,
/* 69e -  */  0,
/* 69f -  */  0,
/* 6a0 - _0F_10 */  0x2372,
/* 6a1 - _66_0F_10 */  0x2373,
/* 6a2 - _F3_0F_10 */  0x2374,
/* 6a3 - _F2_0F_10 */  0x2375,
/* 6a4 - _V_0F_10 */  0x4009,
/* 6a5 - _V_66_0F_10 */  0x400a,
/* 6a6 - _V_F3_0F_10 */  0x400b,
/* 6a7 - _V_F2_0F_10 */  0x400c,
/* 6a8 -  */  0,
/* 6a9 -  */  0,
/* 6aa - _VRR_F3_0F_10 */  0x400d,
/* 6ab - _VRR_F2_0F_10 */  0x400e,
/* 6ac - _0F_11 */  0x2376,
/* 6ad - _66_0F_11 */  0x2377,
/* 6ae - _F3_0F_11 */  0x2378,
/* 6af - _F2_0F_11 */  0x2379,
/* 6b0 - _V_0F_11 */  0x400f,
/* 6b1 - _V_66_0F_11 */  0x4010,
/* 6b2 - _V_F3_0F_11 */  0x4011,
/* 6b3 - _V_F2_0F_11 */  0x4012,
/* 6b4 -  */  0,
/* 6b5 -  */  0,
/* 6b6 - _VRR_F3_0F_11 */  0x4013,
/* 6b7 - _VRR_F2_0F_11 */  0x4014,
/* 6b8 - _0F_12 */  0x4015,
/* 6b9 - _66_0F_12 */  0x237a,
/* 6ba - _F3_0F_12 */  0x237b,
/* 6bb - _F2_0F_12 */  0x237c,
/* 6bc - _V_0F_12 */  0x4016,
/* 6bd - _V_66_0F_12 */  0x4017,
/* 6be - _V_F3_0F_12 */  0x4018,
/* 6bf - _V_F2_0F_12 */  0x4019,
/* 6c0 -  */  0,
/* 6c1 -  */  0,
/* 6c2 -  */  0,
/* 6c3 -  */  0,
/* 6c4 - _0F_13 */  0x237d,
/* 6c5 - _66_0F_13 */  0x237e,
/* 6c6 -  */  0,
/* 6c7 -  */  0,
/* 6c8 - _V_0F_13 */  0x401a,
/* 6c9 - _V_66_0F_13 */  0x401b,
/* 6ca -  */  0,
/* 6cb -  */  0,
/* 6cc -  */  0,
/* 6cd -  */  0,
/* 6ce -  */  0,
/* 6cf -  */  0,
/* 6d0 - _0F_14 */  0x237f,
/* 6d1 - _66_0F_14 */  0x2380,
/* 6d2 -  */  0,
/* 6d3 -  */  0,
/* 6d4 - _V_0F_14 */  0x401c,
/* 6d5 - _V_66_0F_14 */  0x401d,
/* 6d6 -  */  0,
/* 6d7 -  */  0,
/* 6d8 -  */  0,
/* 6d9 -  */  0,
/* 6da -  */  0,
/* 6db -  */  0,
/* 6dc - _0F_15 */  0x2381,
/* 6dd - _66_0F_15 */  0x2382,
/* 6de -  */  0,
/* 6df -  */  0,
/* 6e0 - _V_0F_15 */  0x401e,
/* 6e1 - _V_66_0F_15 */  0x401f,
/* 6e2 -  */  0,
/* 6e3 -  */  0,
/* 6e4 -  */  0,
/* 6e5 -  */  0,
/* 6e6 -  */  0,
/* 6e7 -  */  0,
/* 6e8 - _0F_16 */  0x4020,
/* 6e9 - _66_0F_16 */  0x2383,
/* 6ea - _F3_0F_16 */  0x2384,
/* 6eb -  */  0,
/* 6ec - _V_0F_16 */  0x4021,
/* 6ed - _V_66_0F_16 */  0x4022,
/* 6ee - _V_F3_0F_16 */  0x4023,
/* 6ef -  */  0,
/* 6f0 -  */  0,
/* 6f1 -  */  0,
/* 6f2 -  */  0,
/* 6f3 -  */  0,
/* 6f4 - _0F_17 */  0x2385,
/* 6f5 - _66_0F_17 */  0x2386,
/* 6f6 -  */  0,
/* 6f7 -  */  0,
/* 6f8 - _V_0F_17 */  0x4024,
/* 6f9 - _V_66_0F_17 */  0x4025,
/* 6fa -  */  0,
/* 6fb -  */  0,
/* 6fc -  */  0,
/* 6fd -  */  0,
/* 6fe -  */  0,
/* 6ff -  */  0,
/* 700 - _0F_18_00 */  0x2387,
/* 701 - _0F_18_01 */  0x2388,
/* 702 - _0F_18_02 */  0x2389,
/* 703 - _0F_18_03 */  0x238a,
/* 704 -  */  0,
/* 705 -  */  0,
/* 706 -  */  0,
/* 707 -  */  0,
/* 708 - _0F_28 */  0x238b,
/* 709 - _66_0F_28 */  0x238c,
/* 70a -  */  0,
/* 70b -  */  0,
/* 70c - _V_0F_28 */  0x4026,
/* 70d - _V_66_0F_28 */  0x4027,
/* 70e -  */  0,
/* 70f -  */  0,
/* 710 -  */  0,
/* 711 -  */  0,
/* 712 -  */  0,
/* 713 -  */  0,
/* 714 - _0F_29 */  0x238d,
/* 715 - _66_0F_29 */  0x238e,
/* 716 -  */  0,
/* 717 -  */  0,
/* 718 - _V_0F_29 */  0x4028,
/* 719 - _V_66_0F_29 */  0x4029,
/* 71a -  */  0,
/* 71b -  */  0,
/* 71c -  */  0,
/* 71d -  */  0,
/* 71e -  */  0,
/* 71f -  */  0,
/* 720 - _0F_2A */  0x238f,
/* 721 - _66_0F_2A */  0x2390,
/* 722 - _F3_0F_2A */  0x2391,
/* 723 - _F2_0F_2A */  0x2392,
/* 724 -  */  0,
/* 725 -  */  0,
/* 726 - _V_F3_0F_2A */  0x402a,
/* 727 - _V_F2_0F_2A */  0x402b,
/* 728 -  */  0,
/* 729 -  */  0,
/* 72a -  */  0,
/* 72b -  */  0,
/* 72c - _0F_2B */  0x2393,
/* 72d - _66_0F_2B */  0x2394,
/* 72e - _F3_0F_2B */  0x2395,
/* 72f - _F2_0F_2B */  0x2396,
/* 730 - _V_0F_2B */  0x402c,
/* 731 - _V_66_0F_2B */  0x402d,
/* 732 -  */  0,
/* 733 -  */  0,
/* 734 -  */  0,
/* 735 -  */  0,
/* 736 -  */  0,
/* 737 -  */  0,
/* 738 - _0F_2C */  0x2397,
/* 739 - _66_0F_2C */  0x2398,
/* 73a - _F3_0F_2C */  0x2399,
/* 73b - _F2_0F_2C */  0x239a,
/* 73c -  */  0,
/* 73d -  */  0,
/* 73e - _V_F3_0F_2C */  0x402e,
/* 73f - _V_F2_0F_2C */  0x402f,
/* 740 -  */  0,
/* 741 -  */  0,
/* 742 -  */  0,
/* 743 -  */  0,
/* 744 - _0F_2D */  0x239b,
/* 745 - _66_0F_2D */  0x239c,
/* 746 - _F3_0F_2D */  0x239d,
/* 747 - _F2_0F_2D */  0x239e,
/* 748 -  */  0,
/* 749 -  */  0,
/* 74a - _V_F3_0F_2D */  0x4030,
/* 74b - _V_F2_0F_2D */  0x4031,
/* 74c -  */  0,
/* 74d -  */  0,
/* 74e -  */  0,
/* 74f -  */  0,
/* 750 - _0F_2E */  0x239f,
/* 751 - _66_0F_2E */  0x23a0,
/* 752 -  */  0,
/* 753 -  */  0,
/* 754 - _V_0F_2E */  0x4032,
/* 755 - _V_66_0F_2E */  0x4033,
/* 756 -  */  0,
/* 757 -  */  0,
/* 758 -  */  0,
/* 759 -  */  0,
/* 75a -  */  0,
/* 75b -  */  0,
/* 75c - _0F_2F */  0x23a1,
/* 75d - _66_0F_2F */  0x23a2,
/* 75e -  */  0,
/* 75f -  */  0,
/* 760 - _V_0F_2F */  0x4034,
/* 761 - _V_66_0F_2F */  0x4035,
/* 762 -  */  0,
/* 763 -  */  0,
/* 764 -  */  0,
/* 765 -  */  0,
/* 766 -  */  0,
/* 767 -  */  0,
/* 768 - _0F_38_00 */  0xef78,
/* 769 - _0F_38_01 */  0xef84,
/* 76a - _0F_38_02 */  0xef90,
/* 76b - _0F_38_03 */  0xef9c,
/* 76c - _0F_38_04 */  0xefa8,
/* 76d - _0F_38_05 */  0xefb4,
/* 76e - _0F_38_06 */  0xefc0,
/* 76f - _0F_38_07 */  0xefcc,
/* 770 - _0F_38_08 */  0xefd8,
/* 771 - _0F_38_09 */  0xefe4,
/* 772 - _0F_38_0A */  0xeff0,
/* 773 - _0F_38_0B */  0xeffc,
/* 774 - _0F_38_0C */  0xf008,
/* 775 - _0F_38_0D */  0xf014,
/* 776 - _0F_38_0E */  0xf020,
/* 777 - _0F_38_0F */  0xf02c,
/* 778 - _0F_38_10 */  0xf038,
/* 779 -  */  0,
/* 77a -  */  0,
/* 77b -  */  0,
/* 77c - _0F_38_14 */  0xf044,
/* 77d - _0F_38_15 */  0xf050,
/* 77e -  */  0,
/* 77f - _0F_38_17 */  0xf05c,
/* 780 - _0F_38_18 */  0xf068,
/* 781 - _0F_38_19 */  0xf074,
/* 782 - _0F_38_1A */  0xf080,
/* 783 -  */  0,
/* 784 - _0F_38_1C */  0xf08c,
/* 785 - _0F_38_1D */  0xf098,
/* 786 - _0F_38_1E */  0xf0a4,
/* 787 -  */  0,
/* 788 - _0F_38_20 */  0xf0b0,
/* 789 - _0F_38_21 */  0xf0bc,
/* 78a - _0F_38_22 */  0xf0c8,
/* 78b - _0F_38_23 */  0xf0d4,
/* 78c - _0F_38_24 */  0xf0e0,
/* 78d - _0F_38_25 */  0xf0ec,
/* 78e -  */  0,
/* 78f -  */  0,
/* 790 - _0F_38_28 */  0xf0f8,
/* 791 - _0F_38_29 */  0xf104,
/* 792 - _0F_38_2A */  0xf110,
/* 793 - _0F_38_2B */  0xf11c,
/* 794 - _0F_38_2C */  0xf128,
/* 795 - _0F_38_2D */  0xf134,
/* 796 - _0F_38_2E */  0xf140,
/* 797 - _0F_38_2F */  0xf14c,
/* 798 - _0F_38_30 */  0xf158,
/* 799 - _0F_38_31 */  0xf164,
/* 79a - _0F_38_32 */  0xf170,
/* 79b - _0F_38_33 */  0xf17c,
/* 79c - _0F_38_34 */  0xf188,
/* 79d - _0F_38_35 */  0xf194,
/* 79e -  */  0,
/* 79f - _0F_38_37 */  0xf1a0,
/* 7a0 - _0F_38_38 */  0xf1ac,
/* 7a1 - _0F_38_39 */  0xf1b8,
/* 7a2 - _0F_38_3A */  0xf1c4,
/* 7a3 - _0F_38_3B */  0xf1d0,
/* 7a4 - _0F_38_3C */  0xf1dc,
/* 7a5 - _0F_38_3D */  0xf1e8,
/* 7a6 - _0F_38_3E */  0xf1f4,
/* 7a7 - _0F_38_3F */  0xf200,
/* 7a8 - _0F_38_40 */  0xf20c,
/* 7a9 - _0F_38_41 */  0xf218,
/* 7aa -  */  0,
/* 7ab -  */  0,
/* 7ac -  */  0,
/* 7ad -  */  0,
/* 7ae -  */  0,
/* 7af -  */  0,
/* 7b0 -  */  0,
/* 7b1 -  */  0,
/* 7b2 -  */  0,
/* 7b3 -  */  0,
/* 7b4 -  */  0,
/* 7b5 -  */  0,
/* 7b6 -  */  0,
/* 7b7 -  */  0,
/* 7b8 -  */  0,
/* 7b9 -  */  0,
/* 7ba -  */  0,
/* 7bb -  */  0,
/* 7bc -  */  0,
/* 7bd -  */  0,
/* 7be -  */  0,
/* 7bf -  */  0,
/* 7c0 -  */  0,
/* 7c1 -  */  0,
/* 7c2 -  */  0,
/* 7c3 -  */  0,
/* 7c4 -  */  0,
/* 7c5 -  */  0,
/* 7c6 -  */  0,
/* 7c7 -  */  0,
/* 7c8 -  */  0,
/* 7c9 -  */  0,
/* 7ca -  */  0,
/* 7cb -  */  0,
/* 7cc -  */  0,
/* 7cd -  */  0,
/* 7ce -  */  0,
/* 7cf -  */  0,
/* 7d0 -  */  0,
/* 7d1 -  */  0,
/* 7d2 -  */  0,
/* 7d3 -  */  0,
/* 7d4 -  */  0,
/* 7d5 -  */  0,
/* 7d6 -  */  0,
/* 7d7 -  */  0,
/* 7d8 -  */  0,
/* 7d9 -  */  0,
/* 7da -  */  0,
/* 7db -  */  0,
/* 7dc -  */  0,
/* 7dd -  */  0,
/* 7de -  */  0,
/* 7df -  */  0,
/* 7e0 -  */  0,
/* 7e1 -  */  0,
/* 7e2 -  */  0,
/* 7e3 -  */  0,
/* 7e4 -  */  0,
/* 7e5 -  */  0,
/* 7e6 -  */  0,
/* 7e7 -  */  0,
/* 7e8 - _0F_38_80 */  0xf224,
/* 7e9 - _0F_38_81 */  0xf230,
/* 7ea - _0F_38_82 */  0xf23c,
/* 7eb -  */  0,
/* 7ec -  */  0,
/* 7ed -  */  0,
/* 7ee -  */  0,
/* 7ef -  */  0,
/* 7f0 -  */  0,
/* 7f1 -  */  0,
/* 7f2 -  */  0,
/* 7f3 -  */  0,
/* 7f4 -  */  0,
/* 7f5 -  */  0,
/* 7f6 -  */  0,
/* 7f7 -  */  0,
/* 7f8 -  */  0,
/* 7f9 -  */  0,
/* 7fa -  */  0,
/* 7fb -  */  0,
/* 7fc -  */  0,
/* 7fd -  */  0,
/* 7fe - _0F_38_96 */  0xf248,
/* 7ff - _0F_38_97 */  0xf254,
/* 800 - _0F_38_98 */  0xf260,
/* 801 - _0F_38_99 */  0xf26c,
/* 802 - _0F_38_9A */  0xf278,
/* 803 - _0F_38_9B */  0xf284,
/* 804 - _0F_38_9C */  0xf290,
/* 805 - _0F_38_9D */  0xf29c,
/* 806 - _0F_38_9E */  0xf2a8,
/* 807 - _0F_38_9F */  0xf2b4,
/* 808 -  */  0,
/* 809 -  */  0,
/* 80a -  */  0,
/* 80b -  */  0,
/* 80c -  */  0,
/* 80d -  */  0,
/* 80e - _0F_38_A6 */  0xf2c0,
/* 80f - _0F_38_A7 */  0xf2cc,
/* 810 - _0F_38_A8 */  0xf2d8,
/* 811 - _0F_38_A9 */  0xf2e4,
/* 812 - _0F_38_AA */  0xf2f0,
/* 813 - _0F_38_AB */  0xf2fc,
/* 814 - _0F_38_AC */  0xf308,
/* 815 - _0F_38_AD */  0xf314,
/* 816 - _0F_38_AE */  0xf320,
/* 817 - _0F_38_AF */  0xf32c,
/* 818 -  */  0,
/* 819 -  */  0,
/* 81a -  */  0,
/* 81b -  */  0,
/* 81c -  */  0,
/* 81d -  */  0,
/* 81e - _0F_38_B6 */  0xf338,
/* 81f - _0F_38_B7 */  0xf344,
/* 820 - _0F_38_B8 */  0xf350,
/* 821 - _0F_38_B9 */  0xf35c,
/* 822 - _0F_38_BA */  0xf368,
/* 823 - _0F_38_BB */  0xf374,
/* 824 - _0F_38_BC */  0xf380,
/* 825 - _0F_38_BD */  0xf38c,
/* 826 - _0F_38_BE */  0xf398,
/* 827 - _0F_38_BF */  0xf3a4,
/* 828 -  */  0,
/* 829 -  */  0,
/* 82a -  */  0,
/* 82b -  */  0,
/* 82c -  */  0,
/* 82d -  */  0,
/* 82e -  */  0,
/* 82f -  */  0,
/* 830 -  */  0,
/* 831 -  */  0,
/* 832 -  */  0,
/* 833 -  */  0,
/* 834 -  */  0,
/* 835 -  */  0,
/* 836 -  */  0,
/* 837 -  */  0,
/* 838 -  */  0,
/* 839 -  */  0,
/* 83a -  */  0,
/* 83b -  */  0,
/* 83c -  */  0,
/* 83d -  */  0,
/* 83e -  */  0,
/* 83f -  */  0,
/* 840 -  */  0,
/* 841 -  */  0,
/* 842 -  */  0,
/* 843 - _0F_38_DB */  0xf3b0,
/* 844 - _0F_38_DC */  0xf3bc,
/* 845 - _0F_38_DD */  0xf3c8,
/* 846 - _0F_38_DE */  0xf3d4,
/* 847 - _0F_38_DF */  0xf3e0,
/* 848 -  */  0,
/* 849 -  */  0,
/* 84a -  */  0,
/* 84b -  */  0,
/* 84c -  */  0,
/* 84d -  */  0,
/* 84e -  */  0,
/* 84f -  */  0,
/* 850 -  */  0,
/* 851 -  */  0,
/* 852 -  */  0,
/* 853 -  */  0,
/* 854 -  */  0,
/* 855 -  */  0,
/* 856 -  */  0,
/* 857 -  */  0,
/* 858 - _0F_38_F0 */  0xf3ec,
/* 859 - _0F_38_F1 */  0xf3f8,
/* 85a -  */  0,
/* 85b -  */  0,
/* 85c -  */  0,
/* 85d -  */  0,
/* 85e -  */  0,
/* 85f -  */  0,
/* 860 -  */  0,
/* 861 -  */  0,
/* 862 -  */  0,
/* 863 -  */  0,
/* 864 -  */  0,
/* 865 -  */  0,
/* 866 -  */  0,
/* 867 -  */  0,
/* 868 -  */  0,
/* 869 -  */  0,
/* 86a -  */  0,
/* 86b -  */  0,
/* 86c - _0F_3A_04 */  0xf404,
/* 86d - _0F_3A_05 */  0xf410,
/* 86e - _0F_3A_06 */  0xf41c,
/* 86f -  */  0,
/* 870 - _0F_3A_08 */  0xf428,
/* 871 - _0F_3A_09 */  0xf434,
/* 872 - _0F_3A_0A */  0xf440,
/* 873 - _0F_3A_0B */  0xf44c,
/* 874 - _0F_3A_0C */  0xf458,
/* 875 - _0F_3A_0D */  0xf464,
/* 876 - _0F_3A_0E */  0xf470,
/* 877 - _0F_3A_0F */  0xf47c,
/* 878 -  */  0,
/* 879 -  */  0,
/* 87a -  */  0,
/* 87b -  */  0,
/* 87c - _0F_3A_14 */  0xf488,
/* 87d - _0F_3A_15 */  0xf494,
/* 87e - _0F_3A_16 */  0xf4a0,
/* 87f - _0F_3A_17 */  0xf4ac,
/* 880 - _0F_3A_18 */  0xf4b8,
/* 881 - _0F_3A_19 */  0xf4c4,
/* 882 -  */  0,
/* 883 -  */  0,
/* 884 -  */  0,
/* 885 -  */  0,
/* 886 -  */  0,
/* 887 -  */  0,
/* 888 - _0F_3A_20 */  0xf4d0,
/* 889 - _0F_3A_21 */  0xf4dc,
/* 88a - _0F_3A_22 */  0xf4e8,
/* 88b -  */  0,
/* 88c -  */  0,
/* 88d -  */  0,
/* 88e -  */  0,
/* 88f -  */  0,
/* 890 -  */  0,
/* 891 -  */  0,
/* 892 -  */  0,
/* 893 -  */  0,
/* 894 -  */  0,
/* 895 -  */  0,
/* 896 -  */  0,
/* 897 -  */  0,
/* 898 -  */  0,
/* 899 -  */  0,
/* 89a -  */  0,
/* 89b -  */  0,
/* 89c -  */  0,
/* 89d -  */  0,
/* 89e -  */  0,
/* 89f -  */  0,
/* 8a0 -  */  0,
/* 8a1 -  */  0,
/* 8a2 -  */  0,
/* 8a3 -  */  0,
/* 8a4 -  */  0,
/* 8a5 -  */  0,
/* 8a6 -  */  0,
/* 8a7 -  */  0,
/* 8a8 - _0F_3A_40 */  0xf4f4,
/* 8a9 - _0F_3A_41 */  0xf500,
/* 8aa - _0F_3A_42 */  0xf50c,
/* 8ab -  */  0,
/* 8ac - _0F_3A_44 */  0xf518,
/* 8ad -  */  0,
/* 8ae -  */  0,
/* 8af -  */  0,
/* 8b0 -  */  0,
/* 8b1 -  */  0,
/* 8b2 - _0F_3A_4A */  0xf524,
/* 8b3 - _0F_3A_4B */  0xf530,
/* 8b4 - _0F_3A_4C */  0xf53c,
/* 8b5 -  */  0,
/* 8b6 -  */  0,
/* 8b7 -  */  0,
/* 8b8 -  */  0,
/* 8b9 -  */  0,
/* 8ba -  */  0,
/* 8bb -  */  0,
/* 8bc -  */  0,
/* 8bd -  */  0,
/* 8be -  */  0,
/* 8bf -  */  0,
/* 8c0 -  */  0,
/* 8c1 -  */  0,
/* 8c2 -  */  0,
/* 8c3 -  */  0,
/* 8c4 -  */  0,
/* 8c5 -  */  0,
/* 8c6 -  */  0,
/* 8c7 -  */  0,
/* 8c8 - _0F_3A_60 */  0xf548,
/* 8c9 - _0F_3A_61 */  0xf554,
/* 8ca - _0F_3A_62 */  0xf560,
/* 8cb - _0F_3A_63 */  0xf56c,
/* 8cc -  */  0,
/* 8cd -  */  0,
/* 8ce -  */  0,
/* 8cf -  */  0,
/* 8d0 -  */  0,
/* 8d1 -  */  0,
/* 8d2 -  */  0,
/* 8d3 -  */  0,
/* 8d4 -  */  0,
/* 8d5 -  */  0,
/* 8d6 -  */  0,
/* 8d7 -  */  0,
/* 8d8 -  */  0,
/* 8d9 -  */  0,
/* 8da -  */  0,
/* 8db -  */  0,
/* 8dc -  */  0,
/* 8dd -  */  0,
/* 8de -  */  0,
/* 8df -  */  0,
/* 8e0 -  */  0,
/* 8e1 -  */  0,
/* 8e2 -  */  0,
/* 8e3 -  */  0,
/* 8e4 -  */  0,
/* 8e5 -  */  0,
/* 8e6 -  */  0,
/* 8e7 -  */  0,
/* 8e8 -  */  0,
/* 8e9 -  */  0,
/* 8ea -  */  0,
/* 8eb -  */  0,
/* 8ec -  */  0,
/* 8ed -  */  0,
/* 8ee -  */  0,
/* 8ef -  */  0,
/* 8f0 -  */  0,
/* 8f1 -  */  0,
/* 8f2 -  */  0,
/* 8f3 -  */  0,
/* 8f4 -  */  0,
/* 8f5 -  */  0,
/* 8f6 -  */  0,
/* 8f7 -  */  0,
/* 8f8 -  */  0,
/* 8f9 -  */  0,
/* 8fa -  */  0,
/* 8fb -  */  0,
/* 8fc -  */  0,
/* 8fd -  */  0,
/* 8fe -  */  0,
/* 8ff -  */  0,
/* 900 -  */  0,
/* 901 -  */  0,
/* 902 -  */  0,
/* 903 -  */  0,
/* 904 -  */  0,
/* 905 -  */  0,
/* 906 -  */  0,
/* 907 -  */  0,
/* 908 -  */  0,
/* 909 -  */  0,
/* 90a -  */  0,
/* 90b -  */  0,
/* 90c -  */  0,
/* 90d -  */  0,
/* 90e -  */  0,
/* 90f -  */  0,
/* 910 -  */  0,
/* 911 -  */  0,
/* 912 -  */  0,
/* 913 -  */  0,
/* 914 -  */  0,
/* 915 -  */  0,
/* 916 -  */  0,
/* 917 -  */  0,
/* 918 -  */  0,
/* 919 -  */  0,
/* 91a -  */  0,
/* 91b -  */  0,
/* 91c -  */  0,
/* 91d -  */  0,
/* 91e -  */  0,
/* 91f -  */  0,
/* 920 -  */  0,
/* 921 -  */  0,
/* 922 -  */  0,
/* 923 -  */  0,
/* 924 -  */  0,
/* 925 -  */  0,
/* 926 -  */  0,
/* 927 -  */  0,
/* 928 -  */  0,
/* 929 -  */  0,
/* 92a -  */  0,
/* 92b -  */  0,
/* 92c -  */  0,
/* 92d -  */  0,
/* 92e -  */  0,
/* 92f -  */  0,
/* 930 -  */  0,
/* 931 -  */  0,
/* 932 -  */  0,
/* 933 -  */  0,
/* 934 -  */  0,
/* 935 -  */  0,
/* 936 -  */  0,
/* 937 -  */  0,
/* 938 -  */  0,
/* 939 -  */  0,
/* 93a -  */  0,
/* 93b -  */  0,
/* 93c -  */  0,
/* 93d -  */  0,
/* 93e -  */  0,
/* 93f -  */  0,
/* 940 -  */  0,
/* 941 -  */  0,
/* 942 -  */  0,
/* 943 -  */  0,
/* 944 -  */  0,
/* 945 -  */  0,
/* 946 -  */  0,
/* 947 - _0F_3A_DF */  0xf578,
/* 948 -  */  0,
/* 949 -  */  0,
/* 94a -  */  0,
/* 94b -  */  0,
/* 94c -  */  0,
/* 94d -  */  0,
/* 94e -  */  0,
/* 94f -  */  0,
/* 950 -  */  0,
/* 951 -  */  0,
/* 952 -  */  0,
/* 953 -  */  0,
/* 954 -  */  0,
/* 955 -  */  0,
/* 956 -  */  0,
/* 957 -  */  0,
/* 958 -  */  0,
/* 959 -  */  0,
/* 95a -  */  0,
/* 95b -  */  0,
/* 95c -  */  0,
/* 95d -  */  0,
/* 95e -  */  0,
/* 95f -  */  0,
/* 960 -  */  0,
/* 961 -  */  0,
/* 962 -  */  0,
/* 963 -  */  0,
/* 964 -  */  0,
/* 965 -  */  0,
/* 966 -  */  0,
/* 967 -  */  0,
/* 968 - _0F_50 */  0x23a3,
/* 969 - _66_0F_50 */  0x23a4,
/* 96a -  */  0,
/* 96b -  */  0,
/* 96c - _V_0F_50 */  0x4036,
/* 96d - _V_66_0F_50 */  0x4037,
/* 96e -  */  0,
/* 96f -  */  0,
/* 970 -  */  0,
/* 971 -  */  0,
/* 972 -  */  0,
/* 973 -  */  0,
/* 974 - _0F_51 */  0x23a5,
/* 975 - _66_0F_51 */  0x23a6,
/* 976 - _F3_0F_51 */  0x23a7,
/* 977 - _F2_0F_51 */  0x23a8,
/* 978 - _V_0F_51 */  0x4038,
/* 979 - _V_66_0F_51 */  0x4039,
/* 97a - _V_F3_0F_51 */  0x403a,
/* 97b - _V_F2_0F_51 */  0x403b,
/* 97c -  */  0,
/* 97d -  */  0,
/* 97e -  */  0,
/* 97f -  */  0,
/* 980 - _0F_52 */  0x23a9,
/* 981 -  */  0,
/* 982 - _F3_0F_52 */  0x23aa,
/* 983 -  */  0,
/* 984 - _V_0F_52 */  0x403c,
/* 985 -  */  0,
/* 986 - _V_F3_0F_52 */  0x403d,
/* 987 -  */  0,
/* 988 -  */  0,
/* 989 -  */  0,
/* 98a -  */  0,
/* 98b -  */  0,
/* 98c - _0F_53 */  0x23ab,
/* 98d -  */  0,
/* 98e - _F3_0F_53 */  0x23ac,
/* 98f -  */  0,
/* 990 - _V_0F_53 */  0x403e,
/* 991 -  */  0,
/* 992 - _V_F3_0F_53 */  0x403f,
/* 993 -  */  0,
/* 994 -  */  0,
/* 995 -  */  0,
/* 996 -  */  0,
/* 997 -  */  0,
/* 998 - _0F_54 */  0x23ad,
/* 999 - _66_0F_54 */  0x23ae,
/* 99a -  */  0,
/* 99b -  */  0,
/* 99c - _V_0F_54 */  0x4040,
/* 99d - _V_66_0F_54 */  0x4041,
/* 99e -  */  0,
/* 99f -  */  0,
/* 9a0 -  */  0,
/* 9a1 -  */  0,
/* 9a2 -  */  0,
/* 9a3 -  */  0,
/* 9a4 - _0F_55 */  0x23af,
/* 9a5 - _66_0F_55 */  0x23b0,
/* 9a6 -  */  0,
/* 9a7 -  */  0,
/* 9a8 - _V_0F_55 */  0x4042,
/* 9a9 - _V_66_0F_55 */  0x4043,
/* 9aa -  */  0,
/* 9ab -  */  0,
/* 9ac -  */  0,
/* 9ad -  */  0,
/* 9ae -  */  0,
/* 9af -  */  0,
/* 9b0 - _0F_56 */  0x23b1,
/* 9b1 - _66_0F_56 */  0x23b2,
/* 9b2 -  */  0,
/* 9b3 -  */  0,
/* 9b4 - _V_0F_56 */  0x4044,
/* 9b5 - _V_66_0F_56 */  0x4045,
/* 9b6 -  */  0,
/* 9b7 -  */  0,
/* 9b8 -  */  0,
/* 9b9 -  */  0,
/* 9ba -  */  0,
/* 9bb -  */  0,
/* 9bc - _0F_57 */  0x23b3,
/* 9bd - _66_0F_57 */  0x23b4,
/* 9be -  */  0,
/* 9bf -  */  0,
/* 9c0 - _V_0F_57 */  0x4046,
/* 9c1 - _V_66_0F_57 */  0x4047,
/* 9c2 -  */  0,
/* 9c3 -  */  0,
/* 9c4 -  */  0,
/* 9c5 -  */  0,
/* 9c6 -  */  0,
/* 9c7 -  */  0,
/* 9c8 - _0F_58 */  0x23b5,
/* 9c9 - _66_0F_58 */  0x23b6,
/* 9ca - _F3_0F_58 */  0x23b7,
/* 9cb - _F2_0F_58 */  0x23b8,
/* 9cc - _V_0F_58 */  0x4048,
/* 9cd - _V_66_0F_58 */  0x4049,
/* 9ce - _V_F3_0F_58 */  0x404a,
/* 9cf - _V_F2_0F_58 */  0x404b,
/* 9d0 -  */  0,
/* 9d1 -  */  0,
/* 9d2 -  */  0,
/* 9d3 -  */  0,
/* 9d4 - _0F_59 */  0x23b9,
/* 9d5 - _66_0F_59 */  0x23ba,
/* 9d6 - _F3_0F_59 */  0x23bb,
/* 9d7 - _F2_0F_59 */  0x23bc,
/* 9d8 - _V_0F_59 */  0x404c,
/* 9d9 - _V_66_0F_59 */  0x404d,
/* 9da - _V_F3_0F_59 */  0x404e,
/* 9db - _V_F2_0F_59 */  0x404f,
/* 9dc -  */  0,
/* 9dd -  */  0,
/* 9de -  */  0,
/* 9df -  */  0,
/* 9e0 - _0F_5A */  0x23bd,
/* 9e1 - _66_0F_5A */  0x23be,
/* 9e2 - _F3_0F_5A */  0x23bf,
/* 9e3 - _F2_0F_5A */  0x23c0,
/* 9e4 - _V_0F_5A */  0x4050,
/* 9e5 - _V_66_0F_5A */  0x4051,
/* 9e6 - _V_F3_0F_5A */  0x4052,
/* 9e7 - _V_F2_0F_5A */  0x4053,
/* 9e8 -  */  0,
/* 9e9 -  */  0,
/* 9ea -  */  0,
/* 9eb -  */  0,
/* 9ec - _0F_5B */  0x23c1,
/* 9ed - _66_0F_5B */  0x23c2,
/* 9ee - _F3_0F_5B */  0x23c3,
/* 9ef -  */  0,
/* 9f0 - _V_0F_5B */  0x4054,
/* 9f1 - _V_66_0F_5B */  0x4055,
/* 9f2 - _V_F3_0F_5B */  0x4056,
/* 9f3 -  */  0,
/* 9f4 -  */  0,
/* 9f5 -  */  0,
/* 9f6 -  */  0,
/* 9f7 -  */  0,
/* 9f8 - _0F_5C */  0x23c4,
/* 9f9 - _66_0F_5C */  0x23c5,
/* 9fa - _F3_0F_5C */  0x23c6,
/* 9fb - _F2_0F_5C */  0x23c7,
/* 9fc - _V_0F_5C */  0x4057,
/* 9fd - _V_66_0F_5C */  0x4058,
/* 9fe - _V_F3_0F_5C */  0x4059,
/* 9ff - _V_F2_0F_5C */  0x405a,
/* a00 -  */  0,
/* a01 -  */  0,
/* a02 -  */  0,
/* a03 -  */  0,
/* a04 - _0F_5D */  0x23c8,
/* a05 - _66_0F_5D */  0x23c9,
/* a06 - _F3_0F_5D */  0x23ca,
/* a07 - _F2_0F_5D */  0x23cb,
/* a08 - _V_0F_5D */  0x405b,
/* a09 - _V_66_0F_5D */  0x405c,
/* a0a - _V_F3_0F_5D */  0x405d,
/* a0b - _V_F2_0F_5D */  0x405e,
/* a0c -  */  0,
/* a0d -  */  0,
/* a0e -  */  0,
/* a0f -  */  0,
/* a10 - _0F_5E */  0x23cc,
/* a11 - _66_0F_5E */  0x23cd,
/* a12 - _F3_0F_5E */  0x23ce,
/* a13 - _F2_0F_5E */  0x23cf,
/* a14 - _V_0F_5E */  0x405f,
/* a15 - _V_66_0F_5E */  0x4060,
/* a16 - _V_F3_0F_5E */  0x4061,
/* a17 - _V_F2_0F_5E */  0x4062,
/* a18 -  */  0,
/* a19 -  */  0,
/* a1a -  */  0,
/* a1b -  */  0,
/* a1c - _0F_5F */  0x23d0,
/* a1d - _66_0F_5F */  0x23d1,
/* a1e - _F3_0F_5F */  0x23d2,
/* a1f - _F2_0F_5F */  0x23d3,
/* a20 - _V_0F_5F */  0x4063,
/* a21 - _V_66_0F_5F */  0x4064,
/* a22 - _V_F3_0F_5F */  0x4065,
/* a23 - _V_F2_0F_5F */  0x4066,
/* a24 -  */  0,
/* a25 -  */  0,
/* a26 -  */  0,
/* a27 -  */  0,
/* a28 - _0F_60 */  0x23d4,
/* a29 - _66_0F_60 */  0x23d5,
/* a2a -  */  0,
/* a2b -  */  0,
/* a2c -  */  0,
/* a2d - _V_66_0F_60 */  0x4067,
/* a2e -  */  0,
/* a2f -  */  0,
/* a30 -  */  0,
/* a31 -  */  0,
/* a32 -  */  0,
/* a33 -  */  0,
/* a34 - _0F_61 */  0x23d6,
/* a35 - _66_0F_61 */  0x23d7,
/* a36 -  */  0,
/* a37 -  */  0,
/* a38 -  */  0,
/* a39 - _V_66_0F_61 */  0x4068,
/* a3a -  */  0,
/* a3b -  */  0,
/* a3c -  */  0,
/* a3d -  */  0,
/* a3e -  */  0,
/* a3f -  */  0,
/* a40 - _0F_62 */  0x23d8,
/* a41 - _66_0F_62 */  0x23d9,
/* a42 -  */  0,
/* a43 -  */  0,
/* a44 -  */  0,
/* a45 - _V_66_0F_62 */  0x4069,
/* a46 -  */  0,
/* a47 -  */  0,
/* a48 -  */  0,
/* a49 -  */  0,
/* a4a -  */  0,
/* a4b -  */  0,
/* a4c - _0F_63 */  0x23da,
/* a4d - _66_0F_63 */  0x23db,
/* a4e -  */  0,
/* a4f -  */  0,
/* a50 -  */  0,
/* a51 - _V_66_0F_63 */  0x406a,
/* a52 -  */  0,
/* a53 -  */  0,
/* a54 -  */  0,
/* a55 -  */  0,
/* a56 -  */  0,
/* a57 -  */  0,
/* a58 - _0F_64 */  0x23dc,
/* a59 - _66_0F_64 */  0x23dd,
/* a5a -  */  0,
/* a5b -  */  0,
/* a5c -  */  0,
/* a5d - _V_66_0F_64 */  0x406b,
/* a5e -  */  0,
/* a5f -  */  0,
/* a60 -  */  0,
/* a61 -  */  0,
/* a62 -  */  0,
/* a63 -  */  0,
/* a64 - _0F_65 */  0x23de,
/* a65 - _66_0F_65 */  0x23df,
/* a66 -  */  0,
/* a67 -  */  0,
/* a68 -  */  0,
/* a69 - _V_66_0F_65 */  0x406c,
/* a6a -  */  0,
/* a6b -  */  0,
/* a6c -  */  0,
/* a6d -  */  0,
/* a6e -  */  0,
/* a6f -  */  0,
/* a70 - _0F_66 */  0x23e0,
/* a71 - _66_0F_66 */  0x23e1,
/* a72 -  */  0,
/* a73 -  */  0,
/* a74 -  */  0,
/* a75 - _V_66_0F_66 */  0x406d,
/* a76 -  */  0,
/* a77 -  */  0,
/* a78 -  */  0,
/* a79 -  */  0,
/* a7a -  */  0,
/* a7b -  */  0,
/* a7c - _0F_67 */  0x23e2,
/* a7d - _66_0F_67 */  0x23e3,
/* a7e -  */  0,
/* a7f -  */  0,
/* a80 -  */  0,
/* a81 - _V_66_0F_67 */  0x406e,
/* a82 -  */  0,
/* a83 -  */  0,
/* a84 -  */  0,
/* a85 -  */  0,
/* a86 -  */  0,
/* a87 -  */  0,
/* a88 - _0F_68 */  0x23e4,
/* a89 - _66_0F_68 */  0x23e5,
/* a8a -  */  0,
/* a8b -  */  0,
/* a8c -  */  0,
/* a8d - _V_66_0F_68 */  0x406f,
/* a8e -  */  0,
/* a8f -  */  0,
/* a90 -  */  0,
/* a91 -  */  0,
/* a92 -  */  0,
/* a93 -  */  0,
/* a94 - _0F_69 */  0x23e6,
/* a95 - _66_0F_69 */  0x23e7,
/* a96 -  */  0,
/* a97 -  */  0,
/* a98 -  */  0,
/* a99 - _V_66_0F_69 */  0x4070,
/* a9a -  */  0,
/* a9b -  */  0,
/* a9c -  */  0,
/* a9d -  */  0,
/* a9e -  */  0,
/* a9f -  */  0,
/* aa0 - _0F_6A */  0x23e8,
/* aa1 - _66_0F_6A */  0x23e9,
/* aa2 -  */  0,
/* aa3 -  */  0,
/* aa4 -  */  0,
/* aa5 - _V_66_0F_6A */  0x4071,
/* aa6 -  */  0,
/* aa7 -  */  0,
/* aa8 -  */  0,
/* aa9 -  */  0,
/* aaa -  */  0,
/* aab -  */  0,
/* aac - _0F_6B */  0x23ea,
/* aad - _66_0F_6B */  0x23eb,
/* aae -  */  0,
/* aaf -  */  0,
/* ab0 -  */  0,
/* ab1 - _V_66_0F_6B */  0x4072,
/* ab2 -  */  0,
/* ab3 -  */  0,
/* ab4 -  */  0,
/* ab5 -  */  0,
/* ab6 -  */  0,
/* ab7 -  */  0,
/* ab8 -  */  0,
/* ab9 - _66_0F_6C */  0x23ec,
/* aba -  */  0,
/* abb -  */  0,
/* abc -  */  0,
/* abd - _V_66_0F_6C */  0x4073,
/* abe -  */  0,
/* abf -  */  0,
/* ac0 -  */  0,
/* ac1 -  */  0,
/* ac2 -  */  0,
/* ac3 -  */  0,
/* ac4 -  */  0,
/* ac5 - _66_0F_6D */  0x23ed,
/* ac6 -  */  0,
/* ac7 -  */  0,
/* ac8 -  */  0,
/* ac9 - _V_66_0F_6D */  0x4074,
/* aca -  */  0,
/* acb -  */  0,
/* acc -  */  0,
/* acd -  */  0,
/* ace -  */  0,
/* acf -  */  0,
/* ad0 - _0F_6E */  0x4075,
/* ad1 - _66_0F_6E */  0x4076,
/* ad2 -  */  0,
/* ad3 -  */  0,
/* ad4 -  */  0,
/* ad5 - _V_66_0F_6E */  0x4077,
/* ad6 -  */  0,
/* ad7 -  */  0,
/* ad8 -  */  0,
/* ad9 -  */  0,
/* ada -  */  0,
/* adb -  */  0,
/* adc - _0F_6F */  0x23ee,
/* add - _66_0F_6F */  0x23ef,
/* ade - _F3_0F_6F */  0x23f0,
/* adf -  */  0,
/* ae0 -  */  0,
/* ae1 - _V_66_0F_6F */  0x4078,
/* ae2 - _V_F3_0F_6F */  0x4079,
/* ae3 -  */  0,
/* ae4 -  */  0,
/* ae5 -  */  0,
/* ae6 -  */  0,
/* ae7 -  */  0,
/* ae8 - _0F_70 */  0x407a,
/* ae9 - _66_0F_70 */  0x407b,
/* aea - _F3_0F_70 */  0x407c,
/* aeb - _F2_0F_70 */  0x407d,
/* aec -  */  0,
/* aed - _V_66_0F_70 */  0x407e,
/* aee - _V_F3_0F_70 */  0x407f,
/* aef - _V_F2_0F_70 */  0x4080,
/* af0 -  */  0,
/* af1 -  */  0,
/* af2 -  */  0,
/* af3 -  */  0,
/* af4 -  */  0,
/* af5 -  */  0,
/* af6 - _0F_71_02 */  0xf584,
/* af7 -  */  0,
/* af8 - _0F_71_04 */  0xf590,
/* af9 -  */  0,
/* afa - _0F_71_06 */  0xf59c,
/* afb -  */  0,
/* afc -  */  0,
/* afd -  */  0,
/* afe - _0F_72_02 */  0xf5a8,
/* aff -  */  0,
/* b00 - _0F_72_04 */  0xf5b4,
/* b01 -  */  0,
/* b02 - _0F_72_06 */  0xf5c0,
/* b03 -  */  0,
/* b04 -  */  0,
/* b05 -  */  0,
/* b06 - _0F_73_02 */  0xf5cc,
/* b07 - _0F_73_03 */  0xf5d8,
/* b08 -  */  0,
/* b09 -  */  0,
/* b0a - _0F_73_06 */  0xf5e4,
/* b0b - _0F_73_07 */  0xf5f0,
/* b0c - _0F_74 */  0x23f1,
/* b0d - _66_0F_74 */  0x23f2,
/* b0e -  */  0,
/* b0f -  */  0,
/* b10 -  */  0,
/* b11 - _V_66_0F_74 */  0x4081,
/* b12 -  */  0,
/* b13 -  */  0,
/* b14 -  */  0,
/* b15 -  */  0,
/* b16 -  */  0,
/* b17 -  */  0,
/* b18 - _0F_75 */  0x23f3,
/* b19 - _66_0F_75 */  0x23f4,
/* b1a -  */  0,
/* b1b -  */  0,
/* b1c -  */  0,
/* b1d - _V_66_0F_75 */  0x4082,
/* b1e -  */  0,
/* b1f -  */  0,
/* b20 -  */  0,
/* b21 -  */  0,
/* b22 -  */  0,
/* b23 -  */  0,
/* b24 - _0F_76 */  0x23f5,
/* b25 - _66_0F_76 */  0x23f6,
/* b26 -  */  0,
/* b27 -  */  0,
/* b28 -  */  0,
/* b29 - _V_66_0F_76 */  0x4083,
/* b2a -  */  0,
/* b2b -  */  0,
/* b2c -  */  0,
/* b2d -  */  0,
/* b2e -  */  0,
/* b2f -  */  0,
/* b30 - _0F_77 */  0x23f7,
/* b31 -  */  0,
/* b32 -  */  0,
/* b33 -  */  0,
/* b34 - _V_0F_77 */  0x4084,
/* b35 -  */  0,
/* b36 -  */  0,
/* b37 -  */  0,
/* b38 -  */  0,
/* b39 -  */  0,
/* b3a -  */  0,
/* b3b -  */  0,
/* b3c - _0F_78 */  0x23f8,
/* b3d - _66_0F_78 */  0x4085,
/* b3e -  */  0,
/* b3f - _F2_0F_78 */  0x4086,
/* b40 -  */  0,
/* b41 -  */  0,
/* b42 -  */  0,
/* b43 -  */  0,
/* b44 -  */  0,
/* b45 -  */  0,
/* b46 -  */  0,
/* b47 -  */  0,
/* b48 - _0F_79 */  0x23f9,
/* b49 - _66_0F_79 */  0x23fa,
/* b4a -  */  0,
/* b4b - _F2_0F_79 */  0x23fb,
/* b4c -  */  0,
/* b4d -  */  0,
/* b4e -  */  0,
/* b4f -  */  0,
/* b50 -  */  0,
/* b51 -  */  0,
/* b52 -  */  0,
/* b53 -  */  0,
/* b54 -  */  0,
/* b55 -  */  0,
/* b56 -  */  0,
/* b57 -  */  0,
/* b58 -  */  0,
/* b59 -  */  0,
/* b5a -  */  0,
/* b5b -  */  0,
/* b5c -  */  0,
/* b5d -  */  0,
/* b5e -  */  0,
/* b5f -  */  0,
/* b60 -  */  0,
/* b61 -  */  0,
/* b62 -  */  0,
/* b63 -  */  0,
/* b64 -  */  0,
/* b65 -  */  0,
/* b66 -  */  0,
/* b67 -  */  0,
/* b68 -  */  0,
/* b69 -  */  0,
/* b6a -  */  0,
/* b6b -  */  0,
/* b6c -  */  0,
/* b6d -  */  0,
/* b6e -  */  0,
/* b6f -  */  0,
/* b70 -  */  0,
/* b71 -  */  0,
/* b72 -  */  0,
/* b73 -  */  0,
/* b74 -  */  0,
/* b75 -  */  0,
/* b76 -  */  0,
/* b77 -  */  0,
/* b78 -  */  0,
/* b79 -  */  0,
/* b7a -  */  0,
/* b7b -  */  0,
/* b7c -  */  0,
/* b7d -  */  0,
/* b7e -  */  0,
/* b7f -  */  0,
/* b80 -  */  0,
/* b81 -  */  0,
/* b82 -  */  0,
/* b83 -  */  0,
/* b84 - _0F_7A_30 */  0x23fc,
/* b85 - _0F_7A_31 */  0x23fd,
/* b86 -  */  0,
/* b87 -  */  0,
/* b88 -  */  0,
/* b89 -  */  0,
/* b8a -  */  0,
/* b8b -  */  0,
/* b8c -  */  0,
/* b8d -  */  0,
/* b8e -  */  0,
/* b8f -  */  0,
/* b90 -  */  0,
/* b91 -  */  0,
/* b92 -  */  0,
/* b93 -  */  0,
/* b94 -  */  0,
/* b95 -  */  0,
/* b96 -  */  0,
/* b97 -  */  0,
/* b98 -  */  0,
/* b99 -  */  0,
/* b9a -  */  0,
/* b9b -  */  0,
/* b9c -  */  0,
/* b9d -  */  0,
/* b9e -  */  0,
/* b9f -  */  0,
/* ba0 -  */  0,
/* ba1 -  */  0,
/* ba2 -  */  0,
/* ba3 -  */  0,
/* ba4 -  */  0,
/* ba5 -  */  0,
/* ba6 -  */  0,
/* ba7 -  */  0,
/* ba8 -  */  0,
/* ba9 -  */  0,
/* baa -  */  0,
/* bab -  */  0,
/* bac -  */  0,
/* bad -  */  0,
/* bae -  */  0,
/* baf -  */  0,
/* bb0 -  */  0,
/* bb1 -  */  0,
/* bb2 -  */  0,
/* bb3 -  */  0,
/* bb4 -  */  0,
/* bb5 -  */  0,
/* bb6 -  */  0,
/* bb7 -  */  0,
/* bb8 -  */  0,
/* bb9 -  */  0,
/* bba -  */  0,
/* bbb -  */  0,
/* bbc -  */  0,
/* bbd -  */  0,
/* bbe -  */  0,
/* bbf -  */  0,
/* bc0 -  */  0,
/* bc1 -  */  0,
/* bc2 -  */  0,
/* bc3 -  */  0,
/* bc4 -  */  0,
/* bc5 -  */  0,
/* bc6 -  */  0,
/* bc7 -  */  0,
/* bc8 -  */  0,
/* bc9 -  */  0,
/* bca -  */  0,
/* bcb -  */  0,
/* bcc -  */  0,
/* bcd -  */  0,
/* bce -  */  0,
/* bcf -  */  0,
/* bd0 -  */  0,
/* bd1 -  */  0,
/* bd2 -  */  0,
/* bd3 -  */  0,
/* bd4 -  */  0,
/* bd5 -  */  0,
/* bd6 -  */  0,
/* bd7 -  */  0,
/* bd8 -  */  0,
/* bd9 -  */  0,
/* bda -  */  0,
/* bdb -  */  0,
/* bdc -  */  0,
/* bdd -  */  0,
/* bde -  */  0,
/* bdf -  */  0,
/* be0 -  */  0,
/* be1 -  */  0,
/* be2 -  */  0,
/* be3 -  */  0,
/* be4 -  */  0,
/* be5 -  */  0,
/* be6 -  */  0,
/* be7 -  */  0,
/* be8 -  */  0,
/* be9 -  */  0,
/* bea -  */  0,
/* beb -  */  0,
/* bec -  */  0,
/* bed -  */  0,
/* bee -  */  0,
/* bef -  */  0,
/* bf0 -  */  0,
/* bf1 -  */  0,
/* bf2 -  */  0,
/* bf3 -  */  0,
/* bf4 -  */  0,
/* bf5 -  */  0,
/* bf6 -  */  0,
/* bf7 -  */  0,
/* bf8 -  */  0,
/* bf9 -  */  0,
/* bfa -  */  0,
/* bfb -  */  0,
/* bfc -  */  0,
/* bfd -  */  0,
/* bfe -  */  0,
/* bff -  */  0,
/* c00 -  */  0,
/* c01 -  */  0,
/* c02 -  */  0,
/* c03 -  */  0,
/* c04 -  */  0,
/* c05 -  */  0,
/* c06 -  */  0,
/* c07 -  */  0,
/* c08 -  */  0,
/* c09 -  */  0,
/* c0a -  */  0,
/* c0b -  */  0,
/* c0c -  */  0,
/* c0d -  */  0,
/* c0e -  */  0,
/* c0f -  */  0,
/* c10 -  */  0,
/* c11 -  */  0,
/* c12 -  */  0,
/* c13 -  */  0,
/* c14 -  */  0,
/* c15 -  */  0,
/* c16 -  */  0,
/* c17 -  */  0,
/* c18 -  */  0,
/* c19 -  */  0,
/* c1a -  */  0,
/* c1b -  */  0,
/* c1c -  */  0,
/* c1d -  */  0,
/* c1e -  */  0,
/* c1f -  */  0,
/* c20 -  */  0,
/* c21 -  */  0,
/* c22 -  */  0,
/* c23 -  */  0,
/* c24 -  */  0,
/* c25 -  */  0,
/* c26 -  */  0,
/* c27 -  */  0,
/* c28 -  */  0,
/* c29 -  */  0,
/* c2a -  */  0,
/* c2b -  */  0,
/* c2c -  */  0,
/* c2d -  */  0,
/* c2e -  */  0,
/* c2f -  */  0,
/* c30 -  */  0,
/* c31 -  */  0,
/* c32 -  */  0,
/* c33 -  */  0,
/* c34 -  */  0,
/* c35 -  */  0,
/* c36 -  */  0,
/* c37 -  */  0,
/* c38 -  */  0,
/* c39 -  */  0,
/* c3a -  */  0,
/* c3b -  */  0,
/* c3c -  */  0,
/* c3d -  */  0,
/* c3e -  */  0,
/* c3f -  */  0,
/* c40 -  */  0,
/* c41 -  */  0,
/* c42 -  */  0,
/* c43 -  */  0,
/* c44 -  */  0,
/* c45 -  */  0,
/* c46 -  */  0,
/* c47 -  */  0,
/* c48 -  */  0,
/* c49 -  */  0,
/* c4a -  */  0,
/* c4b -  */  0,
/* c4c -  */  0,
/* c4d -  */  0,
/* c4e -  */  0,
/* c4f -  */  0,
/* c50 -  */  0,
/* c51 -  */  0,
/* c52 -  */  0,
/* c53 -  */  0,
/* c54 -  */  0,
/* c55 - _66_0F_7C */  0x23fe,
/* c56 -  */  0,
/* c57 - _F2_0F_7C */  0x23ff,
/* c58 -  */  0,
/* c59 - _V_66_0F_7C */  0x4087,
/* c5a -  */  0,
/* c5b - _V_F2_0F_7C */  0x4088,
/* c5c -  */  0,
/* c5d -  */  0,
/* c5e -  */  0,
/* c5f -  */  0,
/* c60 -  */  0,
/* c61 - _66_0F_7D */  0x2400,
/* c62 -  */  0,
/* c63 - _F2_0F_7D */  0x2401,
/* c64 -  */  0,
/* c65 - _V_66_0F_7D */  0x4089,
/* c66 -  */  0,
/* c67 - _V_F2_0F_7D */  0x408a,
/* c68 -  */  0,
/* c69 -  */  0,
/* c6a -  */  0,
/* c6b -  */  0,
/* c6c - _0F_7E */  0x408b,
/* c6d - _66_0F_7E */  0x408c,
/* c6e - _F3_0F_7E */  0x2402,
/* c6f -  */  0,
/* c70 -  */  0,
/* c71 - _V_66_0F_7E */  0x408d,
/* c72 - _V_F3_0F_7E */  0x408e,
/* c73 -  */  0,
/* c74 -  */  0,
/* c75 -  */  0,
/* c76 -  */  0,
/* c77 -  */  0,
/* c78 - _0F_7F */  0x2403,
/* c79 - _66_0F_7F */  0x2404,
/* c7a - _F3_0F_7F */  0x2405,
/* c7b -  */  0,
/* c7c -  */  0,
/* c7d - _V_66_0F_7F */  0x408f,
/* c7e - _V_F3_0F_7F */  0x4090,
/* c7f -  */  0,
/* c80 -  */  0,
/* c81 -  */  0,
/* c82 -  */  0,
/* c83 -  */  0,
/* c84 - _0F_AE_00 */  0xf5fc,
/* c85 - _0F_AE_01 */  0xf608,
/* c86 - _0F_AE_02 */  0xf614,
/* c87 - _0F_AE_03 */  0xf620,
/* c88 - _0F_AE_04 */  0x4091,
/* c89 - _0F_AE_05 */  0x4092,
/* c8a - _0F_AE_06 */  0x4093,
/* c8b - _0F_AE_07 */  0x4094,
/* c8c -  */  0,
/* c8d -  */  0,
/* c8e - _F3_0F_B8 */  0x2406,
/* c8f -  */  0,
/* c90 -  */  0,
/* c91 -  */  0,
/* c92 -  */  0,
/* c93 -  */  0,
/* c94 -  */  0,
/* c95 -  */  0,
/* c96 -  */  0,
/* c97 -  */  0,
/* c98 -  */  0,
/* c99 -  */  0,
/* c9a -  */  0,
/* c9b -  */  0,
/* c9c - _0F_BA_04 */  0x2407,
/* c9d - _0F_BA_05 */  0x2408,
/* c9e - _0F_BA_06 */  0x2409,
/* c9f - _0F_BA_07 */  0x240a,
/* ca0 - _0F_BC */  0x240b,
/* ca1 -  */  0,
/* ca2 - _F3_0F_BC */  0x240c,
/* ca3 -  */  0,
/* ca4 -  */  0,
/* ca5 -  */  0,
/* ca6 -  */  0,
/* ca7 -  */  0,
/* ca8 -  */  0,
/* ca9 -  */  0,
/* caa -  */  0,
/* cab -  */  0,
/* cac - _0F_BD */  0x240d,
/* cad -  */  0,
/* cae - _F3_0F_BD */  0x240e,
/* caf -  */  0,
/* cb0 -  */  0,
/* cb1 -  */  0,
/* cb2 -  */  0,
/* cb3 -  */  0,
/* cb4 -  */  0,
/* cb5 -  */  0,
/* cb6 -  */  0,
/* cb7 -  */  0,
/* cb8 - _0F_C2 */  0x4095,
/* cb9 - _66_0F_C2 */  0x4096,
/* cba - _F3_0F_C2 */  0x4097,
/* cbb - _F2_0F_C2 */  0x4098,
/* cbc - _V_0F_C2 */  0x4099,
/* cbd - _V_66_0F_C2 */  0x409a,
/* cbe - _V_F3_0F_C2 */  0x409b,
/* cbf - _V_F2_0F_C2 */  0x409c,
/* cc0 -  */  0,
/* cc1 -  */  0,
/* cc2 -  */  0,
/* cc3 -  */  0,
/* cc4 - _0F_C4 */  0x409d,
/* cc5 - _66_0F_C4 */  0x409e,
/* cc6 -  */  0,
/* cc7 -  */  0,
/* cc8 -  */  0,
/* cc9 - _V_66_0F_C4 */  0x409f,
/* cca -  */  0,
/* ccb -  */  0,
/* ccc -  */  0,
/* ccd -  */  0,
/* cce -  */  0,
/* ccf -  */  0,
/* cd0 - _0F_C5 */  0x40a0,
/* cd1 - _66_0F_C5 */  0x40a1,
/* cd2 -  */  0,
/* cd3 -  */  0,
/* cd4 -  */  0,
/* cd5 - _V_66_0F_C5 */  0x40a2,
/* cd6 -  */  0,
/* cd7 -  */  0,
/* cd8 -  */  0,
/* cd9 -  */  0,
/* cda -  */  0,
/* cdb -  */  0,
/* cdc - _0F_C6 */  0x40a3,
/* cdd - _66_0F_C6 */  0x40a4,
/* cde -  */  0,
/* cdf -  */  0,
/* ce0 - _V_0F_C6 */  0x40a5,
/* ce1 - _V_66_0F_C6 */  0x40a6,
/* ce2 -  */  0,
/* ce3 -  */  0,
/* ce4 -  */  0,
/* ce5 -  */  0,
/* ce6 -  */  0,
/* ce7 -  */  0,
/* ce8 -  */  0,
/* ce9 - _0F_C7_01 */  0x40a7,
/* cea -  */  0,
/* ceb -  */  0,
/* cec -  */  0,
/* ced -  */  0,
/* cee - _0F_C7_06 */  0xf62c,
/* cef - _0F_C7_07 */  0x240f,
/* cf0 -  */  0,
/* cf1 - _66_0F_D0 */  0x2410,
/* cf2 -  */  0,
/* cf3 - _F2_0F_D0 */  0x2411,
/* cf4 -  */  0,
/* cf5 - _V_66_0F_D0 */  0x40a8,
/* cf6 -  */  0,
/* cf7 - _V_F2_0F_D0 */  0x40a9,
/* cf8 -  */  0,
/* cf9 -  */  0,
/* cfa -  */  0,
/* cfb -  */  0,
/* cfc - _0F_D1 */  0x2412,
/* cfd - _66_0F_D1 */  0x2413,
/* cfe -  */  0,
/* cff -  */  0,
/* d00 -  */  0,
/* d01 - _V_66_0F_D1 */  0x40aa,
/* d02 -  */  0,
/* d03 -  */  0,
/* d04 -  */  0,
/* d05 -  */  0,
/* d06 -  */  0,
/* d07 -  */  0,
/* d08 - _0F_D2 */  0x2414,
/* d09 - _66_0F_D2 */  0x2415,
/* d0a -  */  0,
/* d0b -  */  0,
/* d0c -  */  0,
/* d0d - _V_66_0F_D2 */  0x40ab,
/* d0e -  */  0,
/* d0f -  */  0,
/* d10 -  */  0,
/* d11 -  */  0,
/* d12 -  */  0,
/* d13 -  */  0,
/* d14 - _0F_D3 */  0x2416,
/* d15 - _66_0F_D3 */  0x2417,
/* d16 -  */  0,
/* d17 -  */  0,
/* d18 -  */  0,
/* d19 - _V_66_0F_D3 */  0x40ac,
/* d1a -  */  0,
/* d1b -  */  0,
/* d1c -  */  0,
/* d1d -  */  0,
/* d1e -  */  0,
/* d1f -  */  0,
/* d20 - _0F_D4 */  0x2418,
/* d21 - _66_0F_D4 */  0x2419,
/* d22 -  */  0,
/* d23 -  */  0,
/* d24 -  */  0,
/* d25 - _V_66_0F_D4 */  0x40ad,
/* d26 -  */  0,
/* d27 -  */  0,
/* d28 -  */  0,
/* d29 -  */  0,
/* d2a -  */  0,
/* d2b -  */  0,
/* d2c - _0F_D5 */  0x241a,
/* d2d - _66_0F_D5 */  0x241b,
/* d2e -  */  0,
/* d2f -  */  0,
/* d30 -  */  0,
/* d31 - _V_66_0F_D5 */  0x40ae,
/* d32 -  */  0,
/* d33 -  */  0,
/* d34 -  */  0,
/* d35 -  */  0,
/* d36 -  */  0,
/* d37 -  */  0,
/* d38 -  */  0,
/* d39 - _66_0F_D6 */  0x241c,
/* d3a - _F3_0F_D6 */  0x241d,
/* d3b - _F2_0F_D6 */  0x241e,
/* d3c -  */  0,
/* d3d - _V_66_0F_D6 */  0x40af,
/* d3e -  */  0,
/* d3f -  */  0,
/* d40 -  */  0,
/* d41 -  */  0,
/* d42 -  */  0,
/* d43 -  */  0,
/* d44 - _0F_D7 */  0x241f,
/* d45 - _66_0F_D7 */  0x2420,
/* d46 -  */  0,
/* d47 -  */  0,
/* d48 -  */  0,
/* d49 - _V_66_0F_D7 */  0x40b0,
/* d4a -  */  0,
/* d4b -  */  0,
/* d4c -  */  0,
/* d4d -  */  0,
/* d4e -  */  0,
/* d4f -  */  0,
/* d50 - _0F_D8 */  0x2421,
/* d51 - _66_0F_D8 */  0x2422,
/* d52 -  */  0,
/* d53 -  */  0,
/* d54 -  */  0,
/* d55 - _V_66_0F_D8 */  0x40b1,
/* d56 -  */  0,
/* d57 -  */  0,
/* d58 -  */  0,
/* d59 -  */  0,
/* d5a -  */  0,
/* d5b -  */  0,
/* d5c - _0F_D9 */  0x2423,
/* d5d - _66_0F_D9 */  0x2424,
/* d5e -  */  0,
/* d5f -  */  0,
/* d60 -  */  0,
/* d61 - _V_66_0F_D9 */  0x40b2,
/* d62 -  */  0,
/* d63 -  */  0,
/* d64 -  */  0,
/* d65 -  */  0,
/* d66 -  */  0,
/* d67 -  */  0,
/* d68 - _0F_DA */  0x2425,
/* d69 - _66_0F_DA */  0x2426,
/* d6a -  */  0,
/* d6b -  */  0,
/* d6c -  */  0,
/* d6d - _V_66_0F_DA */  0x40b3,
/* d6e -  */  0,
/* d6f -  */  0,
/* d70 -  */  0,
/* d71 -  */  0,
/* d72 -  */  0,
/* d73 -  */  0,
/* d74 - _0F_DB */  0x2427,
/* d75 - _66_0F_DB */  0x2428,
/* d76 -  */  0,
/* d77 -  */  0,
/* d78 -  */  0,
/* d79 - _V_66_0F_DB */  0x40b4,
/* d7a -  */  0,
/* d7b -  */  0,
/* d7c -  */  0,
/* d7d -  */  0,
/* d7e -  */  0,
/* d7f -  */  0,
/* d80 - _0F_DC */  0x2429,
/* d81 - _66_0F_DC */  0x242a,
/* d82 -  */  0,
/* d83 -  */  0,
/* d84 -  */  0,
/* d85 - _V_66_0F_DC */  0x40b5,
/* d86 -  */  0,
/* d87 -  */  0,
/* d88 -  */  0,
/* d89 -  */  0,
/* d8a -  */  0,
/* d8b -  */  0,
/* d8c - _0F_DD */  0x242b,
/* d8d - _66_0F_DD */  0x242c,
/* d8e -  */  0,
/* d8f -  */  0,
/* d90 -  */  0,
/* d91 - _V_66_0F_DD */  0x40b6,
/* d92 -  */  0,
/* d93 -  */  0,
/* d94 -  */  0,
/* d95 -  */  0,
/* d96 -  */  0,
/* d97 -  */  0,
/* d98 - _0F_DE */  0x242d,
/* d99 - _66_0F_DE */  0x242e,
/* d9a -  */  0,
/* d9b -  */  0,
/* d9c -  */  0,
/* d9d - _V_66_0F_DE */  0x40b7,
/* d9e -  */  0,
/* d9f -  */  0,
/* da0 -  */  0,
/* da1 -  */  0,
/* da2 -  */  0,
/* da3 -  */  0,
/* da4 - _0F_DF */  0x242f,
/* da5 - _66_0F_DF */  0x2430,
/* da6 -  */  0,
/* da7 -  */  0,
/* da8 -  */  0,
/* da9 - _V_66_0F_DF */  0x40b8,
/* daa -  */  0,
/* dab -  */  0,
/* dac -  */  0,
/* dad -  */  0,
/* dae -  */  0,
/* daf -  */  0,
/* db0 - _0F_E0 */  0x2431,
/* db1 - _66_0F_E0 */  0x2432,
/* db2 -  */  0,
/* db3 -  */  0,
/* db4 -  */  0,
/* db5 - _V_66_0F_E0 */  0x40b9,
/* db6 -  */  0,
/* db7 -  */  0,
/* db8 -  */  0,
/* db9 -  */  0,
/* dba -  */  0,
/* dbb -  */  0,
/* dbc - _0F_E1 */  0x2433,
/* dbd - _66_0F_E1 */  0x2434,
/* dbe -  */  0,
/* dbf -  */  0,
/* dc0 -  */  0,
/* dc1 - _V_66_0F_E1 */  0x40ba,
/* dc2 -  */  0,
/* dc3 -  */  0,
/* dc4 -  */  0,
/* dc5 -  */  0,
/* dc6 -  */  0,
/* dc7 -  */  0,
/* dc8 - _0F_E2 */  0x2435,
/* dc9 - _66_0F_E2 */  0x2436,
/* dca -  */  0,
/* dcb -  */  0,
/* dcc -  */  0,
/* dcd - _V_66_0F_E2 */  0x40bb,
/* dce -  */  0,
/* dcf -  */  0,
/* dd0 -  */  0,
/* dd1 -  */  0,
/* dd2 -  */  0,
/* dd3 -  */  0,
/* dd4 - _0F_E3 */  0x2437,
/* dd5 - _66_0F_E3 */  0x2438,
/* dd6 -  */  0,
/* dd7 -  */  0,
/* dd8 -  */  0,
/* dd9 - _V_66_0F_E3 */  0x40bc,
/* dda -  */  0,
/* ddb -  */  0,
/* ddc -  */  0,
/* ddd -  */  0,
/* dde -  */  0,
/* ddf -  */  0,
/* de0 - _0F_E4 */  0x2439,
/* de1 - _66_0F_E4 */  0x243a,
/* de2 -  */  0,
/* de3 -  */  0,
/* de4 -  */  0,
/* de5 - _V_66_0F_E4 */  0x40bd,
/* de6 -  */  0,
/* de7 -  */  0,
/* de8 -  */  0,
/* de9 -  */  0,
/* dea -  */  0,
/* deb -  */  0,
/* dec - _0F_E5 */  0x243b,
/* ded - _66_0F_E5 */  0x243c,
/* dee -  */  0,
/* def -  */  0,
/* df0 -  */  0,
/* df1 - _V_66_0F_E5 */  0x40be,
/* df2 -  */  0,
/* df3 -  */  0,
/* df4 -  */  0,
/* df5 -  */  0,
/* df6 -  */  0,
/* df7 -  */  0,
/* df8 -  */  0,
/* df9 - _66_0F_E6 */  0x243d,
/* dfa - _F3_0F_E6 */  0x243e,
/* dfb - _F2_0F_E6 */  0x243f,
/* dfc -  */  0,
/* dfd - _V_66_0F_E6 */  0x40bf,
/* dfe - _V_F3_0F_E6 */  0x40c0,
/* dff - _V_F2_0F_E6 */  0x40c1,
/* e00 -  */  0,
/* e01 -  */  0,
/* e02 -  */  0,
/* e03 -  */  0,
/* e04 - _0F_E7 */  0x2440,
/* e05 - _66_0F_E7 */  0x2441,
/* e06 -  */  0,
/* e07 -  */  0,
/* e08 -  */  0,
/* e09 - _V_66_0F_E7 */  0x40c2,
/* e0a -  */  0,
/* e0b -  */  0,
/* e0c -  */  0,
/* e0d -  */  0,
/* e0e -  */  0,
/* e0f -  */  0,
/* e10 - _0F_E8 */  0x2442,
/* e11 - _66_0F_E8 */  0x2443,
/* e12 -  */  0,
/* e13 -  */  0,
/* e14 -  */  0,
/* e15 - _V_66_0F_E8 */  0x40c3,
/* e16 -  */  0,
/* e17 -  */  0,
/* e18 -  */  0,
/* e19 -  */  0,
/* e1a -  */  0,
/* e1b -  */  0,
/* e1c - _0F_E9 */  0x2444,
/* e1d - _66_0F_E9 */  0x2445,
/* e1e -  */  0,
/* e1f -  */  0,
/* e20 -  */  0,
/* e21 - _V_66_0F_E9 */  0x40c4,
/* e22 -  */  0,
/* e23 -  */  0,
/* e24 -  */  0,
/* e25 -  */  0,
/* e26 -  */  0,
/* e27 -  */  0,
/* e28 - _0F_EA */  0x2446,
/* e29 - _66_0F_EA */  0x2447,
/* e2a -  */  0,
/* e2b -  */  0,
/* e2c -  */  0,
/* e2d - _V_66_0F_EA */  0x40c5,
/* e2e -  */  0,
/* e2f -  */  0,
/* e30 -  */  0,
/* e31 -  */  0,
/* e32 -  */  0,
/* e33 -  */  0,
/* e34 - _0F_EB */  0x2448,
/* e35 - _66_0F_EB */  0x2449,
/* e36 -  */  0,
/* e37 -  */  0,
/* e38 -  */  0,
/* e39 - _V_66_0F_EB */  0x40c6,
/* e3a -  */  0,
/* e3b -  */  0,
/* e3c -  */  0,
/* e3d -  */  0,
/* e3e -  */  0,
/* e3f -  */  0,
/* e40 - _0F_EC */  0x244a,
/* e41 - _66_0F_EC */  0x244b,
/* e42 -  */  0,
/* e43 -  */  0,
/* e44 -  */  0,
/* e45 - _V_66_0F_EC */  0x40c7,
/* e46 -  */  0,
/* e47 -  */  0,
/* e48 -  */  0,
/* e49 -  */  0,
/* e4a -  */  0,
/* e4b -  */  0,
/* e4c - _0F_ED */  0x244c,
/* e4d - _66_0F_ED */  0x244d,
/* e4e -  */  0,
/* e4f -  */  0,
/* e50 -  */  0,
/* e51 - _V_66_0F_ED */  0x40c8,
/* e52 -  */  0,
/* e53 -  */  0,
/* e54 -  */  0,
/* e55 -  */  0,
/* e56 -  */  0,
/* e57 -  */  0,
/* e58 - _0F_EE */  0x244e,
/* e59 - _66_0F_EE */  0x244f,
/* e5a -  */  0,
/* e5b -  */  0,
/* e5c -  */  0,
/* e5d - _V_66_0F_EE */  0x40c9,
/* e5e -  */  0,
/* e5f -  */  0,
/* e60 -  */  0,
/* e61 -  */  0,
/* e62 -  */  0,
/* e63 -  */  0,
/* e64 - _0F_EF */  0x2450,
/* e65 - _66_0F_EF */  0x2451,
/* e66 -  */  0,
/* e67 -  */  0,
/* e68 -  */  0,
/* e69 - _V_66_0F_EF */  0x40ca,
/* e6a -  */  0,
/* e6b -  */  0,
/* e6c -  */  0,
/* e6d -  */  0,
/* e6e -  */  0,
/* e6f -  */  0,
/* e70 -  */  0,
/* e71 -  */  0,
/* e72 -  */  0,
/* e73 - _F2_0F_F0 */  0x2452,
/* e74 -  */  0,
/* e75 -  */  0,
/* e76 -  */  0,
/* e77 - _V_F2_0F_F0 */  0x40cb,
/* e78 -  */  0,
/* e79 -  */  0,
/* e7a -  */  0,
/* e7b -  */  0,
/* e7c - _0F_F1 */  0x2453,
/* e7d - _66_0F_F1 */  0x2454,
/* e7e -  */  0,
/* e7f -  */  0,
/* e80 -  */  0,
/* e81 - _V_66_0F_F1 */  0x40cc,
/* e82 -  */  0,
/* e83 -  */  0,
/* e84 -  */  0,
/* e85 -  */  0,
/* e86 -  */  0,
/* e87 -  */  0,
/* e88 - _0F_F2 */  0x2455,
/* e89 - _66_0F_F2 */  0x2456,
/* e8a -  */  0,
/* e8b -  */  0,
/* e8c -  */  0,
/* e8d - _V_66_0F_F2 */  0x40cd,
/* e8e -  */  0,
/* e8f -  */  0,
/* e90 -  */  0,
/* e91 -  */  0,
/* e92 -  */  0,
/* e93 -  */  0,
/* e94 - _0F_F3 */  0x2457,
/* e95 - _66_0F_F3 */  0x2458,
/* e96 -  */  0,
/* e97 -  */  0,
/* e98 -  */  0,
/* e99 - _V_66_0F_F3 */  0x40ce,
/* e9a -  */  0,
/* e9b -  */  0,
/* e9c -  */  0,
/* e9d -  */  0,
/* e9e -  */  0,
/* e9f -  */  0,
/* ea0 - _0F_F4 */  0x2459,
/* ea1 - _66_0F_F4 */  0x245a,
/* ea2 -  */  0,
/* ea3 -  */  0,
/* ea4 -  */  0,
/* ea5 - _V_66_0F_F4 */  0x40cf,
/* ea6 -  */  0,
/* ea7 -  */  0,
/* ea8 -  */  0,
/* ea9 -  */  0,
/* eaa -  */  0,
/* eab -  */  0,
/* eac - _0F_F5 */  0x245b,
/* ead - _66_0F_F5 */  0x245c,
/* eae -  */  0,
/* eaf -  */  0,
/* eb0 -  */  0,
/* eb1 - _V_66_0F_F5 */  0x40d0,
/* eb2 -  */  0,
/* eb3 -  */  0,
/* eb4 -  */  0,
/* eb5 -  */  0,
/* eb6 -  */  0,
/* eb7 -  */  0,
/* eb8 - _0F_F6 */  0x245d,
/* eb9 - _66_0F_F6 */  0x245e,
/* eba -  */  0,
/* ebb -  */  0,
/* ebc -  */  0,
/* ebd - _V_66_0F_F6 */  0x40d1,
/* ebe -  */  0,
/* ebf -  */  0,
/* ec0 -  */  0,
/* ec1 -  */  0,
/* ec2 -  */  0,
/* ec3 -  */  0,
/* ec4 - _0F_F7 */  0x245f,
/* ec5 - _66_0F_F7 */  0x2460,
/* ec6 -  */  0,
/* ec7 -  */  0,
/* ec8 -  */  0,
/* ec9 - _V_66_0F_F7 */  0x40d2,
/* eca -  */  0,
/* ecb -  */  0,
/* ecc -  */  0,
/* ecd -  */  0,
/* ece -  */  0,
/* ecf -  */  0,
/* ed0 - _0F_F8 */  0x2461,
/* ed1 - _66_0F_F8 */  0x2462,
/* ed2 -  */  0,
/* ed3 -  */  0,
/* ed4 -  */  0,
/* ed5 - _V_66_0F_F8 */  0x40d3,
/* ed6 -  */  0,
/* ed7 -  */  0,
/* ed8 -  */  0,
/* ed9 -  */  0,
/* eda -  */  0,
/* edb -  */  0,
/* edc - _0F_F9 */  0x2463,
/* edd - _66_0F_F9 */  0x2464,
/* ede -  */  0,
/* edf -  */  0,
/* ee0 -  */  0,
/* ee1 - _V_66_0F_F9 */  0x40d4,
/* ee2 -  */  0,
/* ee3 -  */  0,
/* ee4 -  */  0,
/* ee5 -  */  0,
/* ee6 -  */  0,
/* ee7 -  */  0,
/* ee8 - _0F_FA */  0x2465,
/* ee9 - _66_0F_FA */  0x2466,
/* eea -  */  0,
/* eeb -  */  0,
/* eec -  */  0,
/* eed - _V_66_0F_FA */  0x40d5,
/* eee -  */  0,
/* eef -  */  0,
/* ef0 -  */  0,
/* ef1 -  */  0,
/* ef2 -  */  0,
/* ef3 -  */  0,
/* ef4 - _0F_FB */  0x2467,
/* ef5 - _66_0F_FB */  0x2468,
/* ef6 -  */  0,
/* ef7 -  */  0,
/* ef8 -  */  0,
/* ef9 - _V_66_0F_FB */  0x40d6,
/* efa -  */  0,
/* efb -  */  0,
/* efc -  */  0,
/* efd -  */  0,
/* efe -  */  0,
/* eff -  */  0,
/* f00 - _0F_FC */  0x2469,
/* f01 - _66_0F_FC */  0x246a,
/* f02 -  */  0,
/* f03 -  */  0,
/* f04 -  */  0,
/* f05 - _V_66_0F_FC */  0x40d7,
/* f06 -  */  0,
/* f07 -  */  0,
/* f08 -  */  0,
/* f09 -  */  0,
/* f0a -  */  0,
/* f0b -  */  0,
/* f0c - _0F_FD */  0x246b,
/* f0d - _66_0F_FD */  0x246c,
/* f0e -  */  0,
/* f0f -  */  0,
/* f10 -  */  0,
/* f11 - _V_66_0F_FD */  0x40d8,
/* f12 -  */  0,
/* f13 -  */  0,
/* f14 -  */  0,
/* f15 -  */  0,
/* f16 -  */  0,
/* f17 -  */  0,
/* f18 - _0F_FE */  0x246d,
/* f19 - _66_0F_FE */  0x246e,
/* f1a -  */  0,
/* f1b -  */  0,
/* f1c -  */  0,
/* f1d - _V_66_0F_FE */  0x40d9,
/* f1e -  */  0,
/* f1f -  */  0,
/* f20 -  */  0,
/* f21 -  */  0,
/* f22 -  */  0,
/* f23 -  */  0,
/* f24 - _D9_06 */  0x246f,
/* f25 - _9B_D9_06 */  0x2470,
/* f26 -  */  0,
/* f27 -  */  0,
/* f28 -  */  0,
/* f29 -  */  0,
/* f2a -  */  0,
/* f2b -  */  0,
/* f2c -  */  0,
/* f2d -  */  0,
/* f2e -  */  0,
/* f2f -  */  0,
/* f30 - _D9_07 */  0x2471,
/* f31 - _9B_D9_07 */  0x2472,
/* f32 -  */  0,
/* f33 -  */  0,
/* f34 -  */  0,
/* f35 -  */  0,
/* f36 -  */  0,
/* f37 -  */  0,
/* f38 -  */  0,
/* f39 -  */  0,
/* f3a -  */  0,
/* f3b -  */  0,
/* f3c - _DB_E2 */  0x2473,
/* f3d - _9B_DB_E2 */  0x2474,
/* f3e -  */  0,
/* f3f -  */  0,
/* f40 -  */  0,
/* f41 -  */  0,
/* f42 -  */  0,
/* f43 -  */  0,
/* f44 -  */  0,
/* f45 -  */  0,
/* f46 -  */  0,
/* f47 -  */  0,
/* f48 - _DB_E3 */  0x2475,
/* f49 - _9B_DB_E3 */  0x2476,
/* f4a -  */  0,
/* f4b -  */  0,
/* f4c -  */  0,
/* f4d -  */  0,
/* f4e -  */  0,
/* f4f -  */  0,
/* f50 -  */  0,
/* f51 -  */  0,
/* f52 -  */  0,
/* f53 -  */  0,
/* f54 - _DD_06 */  0x2477,
/* f55 - _9B_DD_06 */  0x2478,
/* f56 -  */  0,
/* f57 -  */  0,
/* f58 -  */  0,
/* f59 -  */  0,
/* f5a -  */  0,
/* f5b -  */  0,
/* f5c -  */  0,
/* f5d -  */  0,
/* f5e -  */  0,
/* f5f -  */  0,
/* f60 - _DD_07 */  0x2479,
/* f61 - _9B_DD_07 */  0x247a,
/* f62 -  */  0,
/* f63 -  */  0,
/* f64 -  */  0,
/* f65 -  */  0,
/* f66 -  */  0,
/* f67 -  */  0,
/* f68 -  */  0,
/* f69 -  */  0,
/* f6a -  */  0,
/* f6b -  */  0,
/* f6c - _DF_E0 */  0x247b,
/* f6d - _9B_DF_E0 */  0x247c,
/* f6e -  */  0,
/* f6f -  */  0,
/* f70 -  */  0,
/* f71 -  */  0,
/* f72 -  */  0,
/* f73 -  */  0,
/* f74 -  */  0,
/* f75 -  */  0,
/* f76 -  */  0,
/* f77 -  */  0,
/* f78 - _0F_38_00 */  0x247d,
/* f79 - _66_0F_38_00 */  0x247e,
/* f7a -  */  0,
/* f7b -  */  0,
/* f7c -  */  0,
/* f7d - _V_66_0F_38_00 */  0x40da,
/* f7e -  */  0,
/* f7f -  */  0,
/* f80 -  */  0,
/* f81 -  */  0,
/* f82 -  */  0,
/* f83 -  */  0,
/* f84 - _0F_38_01 */  0x247f,
/* f85 - _66_0F_38_01 */  0x2480,
/* f86 -  */  0,
/* f87 -  */  0,
/* f88 -  */  0,
/* f89 - _V_66_0F_38_01 */  0x40db,
/* f8a -  */  0,
/* f8b -  */  0,
/* f8c -  */  0,
/* f8d -  */  0,
/* f8e -  */  0,
/* f8f -  */  0,
/* f90 - _0F_38_02 */  0x2481,
/* f91 - _66_0F_38_02 */  0x2482,
/* f92 -  */  0,
/* f93 -  */  0,
/* f94 -  */  0,
/* f95 - _V_66_0F_38_02 */  0x40dc,
/* f96 -  */  0,
/* f97 -  */  0,
/* f98 -  */  0,
/* f99 -  */  0,
/* f9a -  */  0,
/* f9b -  */  0,
/* f9c - _0F_38_03 */  0x2483,
/* f9d - _66_0F_38_03 */  0x2484,
/* f9e -  */  0,
/* f9f -  */  0,
/* fa0 -  */  0,
/* fa1 - _V_66_0F_38_03 */  0x40dd,
/* fa2 -  */  0,
/* fa3 -  */  0,
/* fa4 -  */  0,
/* fa5 -  */  0,
/* fa6 -  */  0,
/* fa7 -  */  0,
/* fa8 - _0F_38_04 */  0x2485,
/* fa9 - _66_0F_38_04 */  0x2486,
/* faa -  */  0,
/* fab -  */  0,
/* fac -  */  0,
/* fad - _V_66_0F_38_04 */  0x40de,
/* fae -  */  0,
/* faf -  */  0,
/* fb0 -  */  0,
/* fb1 -  */  0,
/* fb2 -  */  0,
/* fb3 -  */  0,
/* fb4 - _0F_38_05 */  0x2487,
/* fb5 - _66_0F_38_05 */  0x2488,
/* fb6 -  */  0,
/* fb7 -  */  0,
/* fb8 -  */  0,
/* fb9 - _V_66_0F_38_05 */  0x40df,
/* fba -  */  0,
/* fbb -  */  0,
/* fbc -  */  0,
/* fbd -  */  0,
/* fbe -  */  0,
/* fbf -  */  0,
/* fc0 - _0F_38_06 */  0x2489,
/* fc1 - _66_0F_38_06 */  0x248a,
/* fc2 -  */  0,
/* fc3 -  */  0,
/* fc4 -  */  0,
/* fc5 - _V_66_0F_38_06 */  0x40e0,
/* fc6 -  */  0,
/* fc7 -  */  0,
/* fc8 -  */  0,
/* fc9 -  */  0,
/* fca -  */  0,
/* fcb -  */  0,
/* fcc - _0F_38_07 */  0x248b,
/* fcd - _66_0F_38_07 */  0x248c,
/* fce -  */  0,
/* fcf -  */  0,
/* fd0 -  */  0,
/* fd1 - _V_66_0F_38_07 */  0x40e1,
/* fd2 -  */  0,
/* fd3 -  */  0,
/* fd4 -  */  0,
/* fd5 -  */  0,
/* fd6 -  */  0,
/* fd7 -  */  0,
/* fd8 - _0F_38_08 */  0x248d,
/* fd9 - _66_0F_38_08 */  0x248e,
/* fda -  */  0,
/* fdb -  */  0,
/* fdc -  */  0,
/* fdd - _V_66_0F_38_08 */  0x40e2,
/* fde -  */  0,
/* fdf -  */  0,
/* fe0 -  */  0,
/* fe1 -  */  0,
/* fe2 -  */  0,
/* fe3 -  */  0,
/* fe4 - _0F_38_09 */  0x248f,
/* fe5 - _66_0F_38_09 */  0x2490,
/* fe6 -  */  0,
/* fe7 -  */  0,
/* fe8 -  */  0,
/* fe9 - _V_66_0F_38_09 */  0x40e3,
/* fea -  */  0,
/* feb -  */  0,
/* fec -  */  0,
/* fed -  */  0,
/* fee -  */  0,
/* fef -  */  0,
/* ff0 - _0F_38_0A */  0x2491,
/* ff1 - _66_0F_38_0A */  0x2492,
/* ff2 -  */  0,
/* ff3 -  */  0,
/* ff4 -  */  0,
/* ff5 - _V_66_0F_38_0A */  0x40e4,
/* ff6 -  */  0,
/* ff7 -  */  0,
/* ff8 -  */  0,
/* ff9 -  */  0,
/* ffa -  */  0,
/* ffb -  */  0,
/* ffc - _0F_38_0B */  0x2493,
/* ffd - _66_0F_38_0B */  0x2494,
/* ffe -  */  0,
/* fff -  */  0,
/* 1000 -  */  0,
/* 1001 - _V_66_0F_38_0B */  0x40e5,
/* 1002 -  */  0,
/* 1003 -  */  0,
/* 1004 -  */  0,
/* 1005 -  */  0,
/* 1006 -  */  0,
/* 1007 -  */  0,
/* 1008 -  */  0,
/* 1009 -  */  0,
/* 100a -  */  0,
/* 100b -  */  0,
/* 100c -  */  0,
/* 100d - _V_66_0F_38_0C */  0x40e6,
/* 100e -  */  0,
/* 100f -  */  0,
/* 1010 -  */  0,
/* 1011 -  */  0,
/* 1012 -  */  0,
/* 1013 -  */  0,
/* 1014 -  */  0,
/* 1015 -  */  0,
/* 1016 -  */  0,
/* 1017 -  */  0,
/* 1018 -  */  0,
/* 1019 - _V_66_0F_38_0D */  0x40e7,
/* 101a -  */  0,
/* 101b -  */  0,
/* 101c -  */  0,
/* 101d -  */  0,
/* 101e -  */  0,
/* 101f -  */  0,
/* 1020 -  */  0,
/* 1021 -  */  0,
/* 1022 -  */  0,
/* 1023 -  */  0,
/* 1024 -  */  0,
/* 1025 - _V_66_0F_38_0E */  0x40e8,
/* 1026 -  */  0,
/* 1027 -  */  0,
/* 1028 -  */  0,
/* 1029 -  */  0,
/* 102a -  */  0,
/* 102b -  */  0,
/* 102c -  */  0,
/* 102d -  */  0,
/* 102e -  */  0,
/* 102f -  */  0,
/* 1030 -  */  0,
/* 1031 - _V_66_0F_38_0F */  0x40e9,
/* 1032 -  */  0,
/* 1033 -  */  0,
/* 1034 -  */  0,
/* 1035 -  */  0,
/* 1036 -  */  0,
/* 1037 -  */  0,
/* 1038 -  */  0,
/* 1039 - _66_0F_38_10 */  0x40ea,
/* 103a -  */  0,
/* 103b -  */  0,
/* 103c -  */  0,
/* 103d -  */  0,
/* 103e -  */  0,
/* 103f -  */  0,
/* 1040 -  */  0,
/* 1041 -  */  0,
/* 1042 -  */  0,
/* 1043 -  */  0,
/* 1044 -  */  0,
/* 1045 - _66_0F_38_14 */  0x40eb,
/* 1046 -  */  0,
/* 1047 -  */  0,
/* 1048 -  */  0,
/* 1049 -  */  0,
/* 104a -  */  0,
/* 104b -  */  0,
/* 104c -  */  0,
/* 104d -  */  0,
/* 104e -  */  0,
/* 104f -  */  0,
/* 1050 -  */  0,
/* 1051 - _66_0F_38_15 */  0x40ec,
/* 1052 -  */  0,
/* 1053 -  */  0,
/* 1054 -  */  0,
/* 1055 -  */  0,
/* 1056 -  */  0,
/* 1057 -  */  0,
/* 1058 -  */  0,
/* 1059 -  */  0,
/* 105a -  */  0,
/* 105b -  */  0,
/* 105c -  */  0,
/* 105d - _66_0F_38_17 */  0x2495,
/* 105e -  */  0,
/* 105f -  */  0,
/* 1060 -  */  0,
/* 1061 - _V_66_0F_38_17 */  0x40ed,
/* 1062 -  */  0,
/* 1063 -  */  0,
/* 1064 -  */  0,
/* 1065 -  */  0,
/* 1066 -  */  0,
/* 1067 -  */  0,
/* 1068 -  */  0,
/* 1069 -  */  0,
/* 106a -  */  0,
/* 106b -  */  0,
/* 106c -  */  0,
/* 106d - _V_66_0F_38_18 */  0x40ee,
/* 106e -  */  0,
/* 106f -  */  0,
/* 1070 -  */  0,
/* 1071 -  */  0,
/* 1072 -  */  0,
/* 1073 -  */  0,
/* 1074 -  */  0,
/* 1075 -  */  0,
/* 1076 -  */  0,
/* 1077 -  */  0,
/* 1078 -  */  0,
/* 1079 - _V_66_0F_38_19 */  0x40ef,
/* 107a -  */  0,
/* 107b -  */  0,
/* 107c -  */  0,
/* 107d -  */  0,
/* 107e -  */  0,
/* 107f -  */  0,
/* 1080 -  */  0,
/* 1081 -  */  0,
/* 1082 -  */  0,
/* 1083 -  */  0,
/* 1084 -  */  0,
/* 1085 - _V_66_0F_38_1A */  0x40f0,
/* 1086 -  */  0,
/* 1087 -  */  0,
/* 1088 -  */  0,
/* 1089 -  */  0,
/* 108a -  */  0,
/* 108b -  */  0,
/* 108c - _0F_38_1C */  0x2496,
/* 108d - _66_0F_38_1C */  0x2497,
/* 108e -  */  0,
/* 108f -  */  0,
/* 1090 -  */  0,
/* 1091 - _V_66_0F_38_1C */  0x40f1,
/* 1092 -  */  0,
/* 1093 -  */  0,
/* 1094 -  */  0,
/* 1095 -  */  0,
/* 1096 -  */  0,
/* 1097 -  */  0,
/* 1098 - _0F_38_1D */  0x2498,
/* 1099 - _66_0F_38_1D */  0x2499,
/* 109a -  */  0,
/* 109b -  */  0,
/* 109c -  */  0,
/* 109d - _V_66_0F_38_1D */  0x40f2,
/* 109e -  */  0,
/* 109f -  */  0,
/* 10a0 -  */  0,
/* 10a1 -  */  0,
/* 10a2 -  */  0,
/* 10a3 -  */  0,
/* 10a4 - _0F_38_1E */  0x249a,
/* 10a5 - _66_0F_38_1E */  0x249b,
/* 10a6 -  */  0,
/* 10a7 -  */  0,
/* 10a8 -  */  0,
/* 10a9 - _V_66_0F_38_1E */  0x40f3,
/* 10aa -  */  0,
/* 10ab -  */  0,
/* 10ac -  */  0,
/* 10ad -  */  0,
/* 10ae -  */  0,
/* 10af -  */  0,
/* 10b0 -  */  0,
/* 10b1 - _66_0F_38_20 */  0x249c,
/* 10b2 -  */  0,
/* 10b3 -  */  0,
/* 10b4 -  */  0,
/* 10b5 - _V_66_0F_38_20 */  0x40f4,
/* 10b6 -  */  0,
/* 10b7 -  */  0,
/* 10b8 -  */  0,
/* 10b9 -  */  0,
/* 10ba -  */  0,
/* 10bb -  */  0,
/* 10bc -  */  0,
/* 10bd - _66_0F_38_21 */  0x249d,
/* 10be -  */  0,
/* 10bf -  */  0,
/* 10c0 -  */  0,
/* 10c1 - _V_66_0F_38_21 */  0x40f5,
/* 10c2 -  */  0,
/* 10c3 -  */  0,
/* 10c4 -  */  0,
/* 10c5 -  */  0,
/* 10c6 -  */  0,
/* 10c7 -  */  0,
/* 10c8 -  */  0,
/* 10c9 - _66_0F_38_22 */  0x249e,
/* 10ca -  */  0,
/* 10cb -  */  0,
/* 10cc -  */  0,
/* 10cd - _V_66_0F_38_22 */  0x40f6,
/* 10ce -  */  0,
/* 10cf -  */  0,
/* 10d0 -  */  0,
/* 10d1 -  */  0,
/* 10d2 -  */  0,
/* 10d3 -  */  0,
/* 10d4 -  */  0,
/* 10d5 - _66_0F_38_23 */  0x249f,
/* 10d6 -  */  0,
/* 10d7 -  */  0,
/* 10d8 -  */  0,
/* 10d9 - _V_66_0F_38_23 */  0x40f7,
/* 10da -  */  0,
/* 10db -  */  0,
/* 10dc -  */  0,
/* 10dd -  */  0,
/* 10de -  */  0,
/* 10df -  */  0,
/* 10e0 -  */  0,
/* 10e1 - _66_0F_38_24 */  0x24a0,
/* 10e2 -  */  0,
/* 10e3 -  */  0,
/* 10e4 -  */  0,
/* 10e5 - _V_66_0F_38_24 */  0x40f8,
/* 10e6 -  */  0,
/* 10e7 -  */  0,
/* 10e8 -  */  0,
/* 10e9 -  */  0,
/* 10ea -  */  0,
/* 10eb -  */  0,
/* 10ec -  */  0,
/* 10ed - _66_0F_38_25 */  0x24a1,
/* 10ee -  */  0,
/* 10ef -  */  0,
/* 10f0 -  */  0,
/* 10f1 - _V_66_0F_38_25 */  0x40f9,
/* 10f2 -  */  0,
/* 10f3 -  */  0,
/* 10f4 -  */  0,
/* 10f5 -  */  0,
/* 10f6 -  */  0,
/* 10f7 -  */  0,
/* 10f8 -  */  0,
/* 10f9 - _66_0F_38_28 */  0x24a2,
/* 10fa -  */  0,
/* 10fb -  */  0,
/* 10fc -  */  0,
/* 10fd - _V_66_0F_38_28 */  0x40fa,
/* 10fe -  */  0,
/* 10ff -  */  0,
/* 1100 -  */  0,
/* 1101 -  */  0,
/* 1102 -  */  0,
/* 1103 -  */  0,
/* 1104 -  */  0,
/* 1105 - _66_0F_38_29 */  0x24a3,
/* 1106 -  */  0,
/* 1107 -  */  0,
/* 1108 -  */  0,
/* 1109 - _V_66_0F_38_29 */  0x40fb,
/* 110a -  */  0,
/* 110b -  */  0,
/* 110c -  */  0,
/* 110d -  */  0,
/* 110e -  */  0,
/* 110f -  */  0,
/* 1110 -  */  0,
/* 1111 - _66_0F_38_2A */  0x24a4,
/* 1112 -  */  0,
/* 1113 -  */  0,
/* 1114 -  */  0,
/* 1115 - _V_66_0F_38_2A */  0x40fc,
/* 1116 -  */  0,
/* 1117 -  */  0,
/* 1118 -  */  0,
/* 1119 -  */  0,
/* 111a -  */  0,
/* 111b -  */  0,
/* 111c -  */  0,
/* 111d - _66_0F_38_2B */  0x24a5,
/* 111e -  */  0,
/* 111f -  */  0,
/* 1120 -  */  0,
/* 1121 - _V_66_0F_38_2B */  0x40fd,
/* 1122 -  */  0,
/* 1123 -  */  0,
/* 1124 -  */  0,
/* 1125 -  */  0,
/* 1126 -  */  0,
/* 1127 -  */  0,
/* 1128 -  */  0,
/* 1129 -  */  0,
/* 112a -  */  0,
/* 112b -  */  0,
/* 112c -  */  0,
/* 112d - _V_66_0F_38_2C */  0x40fe,
/* 112e -  */  0,
/* 112f -  */  0,
/* 1130 -  */  0,
/* 1131 -  */  0,
/* 1132 -  */  0,
/* 1133 -  */  0,
/* 1134 -  */  0,
/* 1135 -  */  0,
/* 1136 -  */  0,
/* 1137 -  */  0,
/* 1138 -  */  0,
/* 1139 - _V_66_0F_38_2D */  0x40ff,
/* 113a -  */  0,
/* 113b -  */  0,
/* 113c -  */  0,
/* 113d -  */  0,
/* 113e -  */  0,
/* 113f -  */  0,
/* 1140 -  */  0,
/* 1141 -  */  0,
/* 1142 -  */  0,
/* 1143 -  */  0,
/* 1144 -  */  0,
/* 1145 - _V_66_0F_38_2E */  0x4100,
/* 1146 -  */  0,
/* 1147 -  */  0,
/* 1148 -  */  0,
/* 1149 -  */  0,
/* 114a -  */  0,
/* 114b -  */  0,
/* 114c -  */  0,
/* 114d -  */  0,
/* 114e -  */  0,
/* 114f -  */  0,
/* 1150 -  */  0,
/* 1151 - _V_66_0F_38_2F */  0x4101,
/* 1152 -  */  0,
/* 1153 -  */  0,
/* 1154 -  */  0,
/* 1155 -  */  0,
/* 1156 -  */  0,
/* 1157 -  */  0,
/* 1158 -  */  0,
/* 1159 - _66_0F_38_30 */  0x24a6,
/* 115a -  */  0,
/* 115b -  */  0,
/* 115c -  */  0,
/* 115d - _V_66_0F_38_30 */  0x4102,
/* 115e -  */  0,
/* 115f -  */  0,
/* 1160 -  */  0,
/* 1161 -  */  0,
/* 1162 -  */  0,
/* 1163 -  */  0,
/* 1164 -  */  0,
/* 1165 - _66_0F_38_31 */  0x24a7,
/* 1166 -  */  0,
/* 1167 -  */  0,
/* 1168 -  */  0,
/* 1169 - _V_66_0F_38_31 */  0x4103,
/* 116a -  */  0,
/* 116b -  */  0,
/* 116c -  */  0,
/* 116d -  */  0,
/* 116e -  */  0,
/* 116f -  */  0,
/* 1170 -  */  0,
/* 1171 - _66_0F_38_32 */  0x24a8,
/* 1172 -  */  0,
/* 1173 -  */  0,
/* 1174 -  */  0,
/* 1175 - _V_66_0F_38_32 */  0x4104,
/* 1176 -  */  0,
/* 1177 -  */  0,
/* 1178 -  */  0,
/* 1179 -  */  0,
/* 117a -  */  0,
/* 117b -  */  0,
/* 117c -  */  0,
/* 117d - _66_0F_38_33 */  0x24a9,
/* 117e -  */  0,
/* 117f -  */  0,
/* 1180 -  */  0,
/* 1181 - _V_66_0F_38_33 */  0x4105,
/* 1182 -  */  0,
/* 1183 -  */  0,
/* 1184 -  */  0,
/* 1185 -  */  0,
/* 1186 -  */  0,
/* 1187 -  */  0,
/* 1188 -  */  0,
/* 1189 - _66_0F_38_34 */  0x24aa,
/* 118a -  */  0,
/* 118b -  */  0,
/* 118c -  */  0,
/* 118d - _V_66_0F_38_34 */  0x4106,
/* 118e -  */  0,
/* 118f -  */  0,
/* 1190 -  */  0,
/* 1191 -  */  0,
/* 1192 -  */  0,
/* 1193 -  */  0,
/* 1194 -  */  0,
/* 1195 - _66_0F_38_35 */  0x24ab,
/* 1196 -  */  0,
/* 1197 -  */  0,
/* 1198 -  */  0,
/* 1199 - _V_66_0F_38_35 */  0x4107,
/* 119a -  */  0,
/* 119b -  */  0,
/* 119c -  */  0,
/* 119d -  */  0,
/* 119e -  */  0,
/* 119f -  */  0,
/* 11a0 -  */  0,
/* 11a1 - _66_0F_38_37 */  0x24ac,
/* 11a2 -  */  0,
/* 11a3 -  */  0,
/* 11a4 -  */  0,
/* 11a5 - _V_66_0F_38_37 */  0x4108,
/* 11a6 -  */  0,
/* 11a7 -  */  0,
/* 11a8 -  */  0,
/* 11a9 -  */  0,
/* 11aa -  */  0,
/* 11ab -  */  0,
/* 11ac -  */  0,
/* 11ad - _66_0F_38_38 */  0x24ad,
/* 11ae -  */  0,
/* 11af -  */  0,
/* 11b0 -  */  0,
/* 11b1 - _V_66_0F_38_38 */  0x4109,
/* 11b2 -  */  0,
/* 11b3 -  */  0,
/* 11b4 -  */  0,
/* 11b5 -  */  0,
/* 11b6 -  */  0,
/* 11b7 -  */  0,
/* 11b8 -  */  0,
/* 11b9 - _66_0F_38_39 */  0x24ae,
/* 11ba -  */  0,
/* 11bb -  */  0,
/* 11bc -  */  0,
/* 11bd - _V_66_0F_38_39 */  0x410a,
/* 11be -  */  0,
/* 11bf -  */  0,
/* 11c0 -  */  0,
/* 11c1 -  */  0,
/* 11c2 -  */  0,
/* 11c3 -  */  0,
/* 11c4 -  */  0,
/* 11c5 - _66_0F_38_3A */  0x24af,
/* 11c6 -  */  0,
/* 11c7 -  */  0,
/* 11c8 -  */  0,
/* 11c9 - _V_66_0F_38_3A */  0x410b,
/* 11ca -  */  0,
/* 11cb -  */  0,
/* 11cc -  */  0,
/* 11cd -  */  0,
/* 11ce -  */  0,
/* 11cf -  */  0,
/* 11d0 -  */  0,
/* 11d1 - _66_0F_38_3B */  0x24b0,
/* 11d2 -  */  0,
/* 11d3 -  */  0,
/* 11d4 -  */  0,
/* 11d5 - _V_66_0F_38_3B */  0x410c,
/* 11d6 -  */  0,
/* 11d7 -  */  0,
/* 11d8 -  */  0,
/* 11d9 -  */  0,
/* 11da -  */  0,
/* 11db -  */  0,
/* 11dc -  */  0,
/* 11dd - _66_0F_38_3C */  0x24b1,
/* 11de -  */  0,
/* 11df -  */  0,
/* 11e0 -  */  0,
/* 11e1 - _V_66_0F_38_3C */  0x410d,
/* 11e2 -  */  0,
/* 11e3 -  */  0,
/* 11e4 -  */  0,
/* 11e5 -  */  0,
/* 11e6 -  */  0,
/* 11e7 -  */  0,
/* 11e8 -  */  0,
/* 11e9 - _66_0F_38_3D */  0x24b2,
/* 11ea -  */  0,
/* 11eb -  */  0,
/* 11ec -  */  0,
/* 11ed - _V_66_0F_38_3D */  0x410e,
/* 11ee -  */  0,
/* 11ef -  */  0,
/* 11f0 -  */  0,
/* 11f1 -  */  0,
/* 11f2 -  */  0,
/* 11f3 -  */  0,
/* 11f4 -  */  0,
/* 11f5 - _66_0F_38_3E */  0x24b3,
/* 11f6 -  */  0,
/* 11f7 -  */  0,
/* 11f8 -  */  0,
/* 11f9 - _V_66_0F_38_3E */  0x410f,
/* 11fa -  */  0,
/* 11fb -  */  0,
/* 11fc -  */  0,
/* 11fd -  */  0,
/* 11fe -  */  0,
/* 11ff -  */  0,
/* 1200 -  */  0,
/* 1201 - _66_0F_38_3F */  0x24b4,
/* 1202 -  */  0,
/* 1203 -  */  0,
/* 1204 -  */  0,
/* 1205 - _V_66_0F_38_3F */  0x4110,
/* 1206 -  */  0,
/* 1207 -  */  0,
/* 1208 -  */  0,
/* 1209 -  */  0,
/* 120a -  */  0,
/* 120b -  */  0,
/* 120c -  */  0,
/* 120d - _66_0F_38_40 */  0x24b5,
/* 120e -  */  0,
/* 120f -  */  0,
/* 1210 -  */  0,
/* 1211 - _V_66_0F_38_40 */  0x4111,
/* 1212 -  */  0,
/* 1213 -  */  0,
/* 1214 -  */  0,
/* 1215 -  */  0,
/* 1216 -  */  0,
/* 1217 -  */  0,
/* 1218 -  */  0,
/* 1219 - _66_0F_38_41 */  0x24b6,
/* 121a -  */  0,
/* 121b -  */  0,
/* 121c -  */  0,
/* 121d - _V_66_0F_38_41 */  0x4112,
/* 121e -  */  0,
/* 121f -  */  0,
/* 1220 -  */  0,
/* 1221 -  */  0,
/* 1222 -  */  0,
/* 1223 -  */  0,
/* 1224 -  */  0,
/* 1225 - _66_0F_38_80 */  0x24b7,
/* 1226 -  */  0,
/* 1227 -  */  0,
/* 1228 -  */  0,
/* 1229 -  */  0,
/* 122a -  */  0,
/* 122b -  */  0,
/* 122c -  */  0,
/* 122d -  */  0,
/* 122e -  */  0,
/* 122f -  */  0,
/* 1230 -  */  0,
/* 1231 - _66_0F_38_81 */  0x24b8,
/* 1232 -  */  0,
/* 1233 -  */  0,
/* 1234 -  */  0,
/* 1235 -  */  0,
/* 1236 -  */  0,
/* 1237 -  */  0,
/* 1238 -  */  0,
/* 1239 -  */  0,
/* 123a -  */  0,
/* 123b -  */  0,
/* 123c -  */  0,
/* 123d - _66_0F_38_82 */  0x24b9,
/* 123e -  */  0,
/* 123f -  */  0,
/* 1240 -  */  0,
/* 1241 -  */  0,
/* 1242 -  */  0,
/* 1243 -  */  0,
/* 1244 -  */  0,
/* 1245 -  */  0,
/* 1246 -  */  0,
/* 1247 -  */  0,
/* 1248 -  */  0,
/* 1249 -  */  0,
/* 124a -  */  0,
/* 124b -  */  0,
/* 124c -  */  0,
/* 124d - _V_66_0F_38_96 */  0x4113,
/* 124e -  */  0,
/* 124f -  */  0,
/* 1250 -  */  0,
/* 1251 -  */  0,
/* 1252 -  */  0,
/* 1253 -  */  0,
/* 1254 -  */  0,
/* 1255 -  */  0,
/* 1256 -  */  0,
/* 1257 -  */  0,
/* 1258 -  */  0,
/* 1259 - _V_66_0F_38_97 */  0x4114,
/* 125a -  */  0,
/* 125b -  */  0,
/* 125c -  */  0,
/* 125d -  */  0,
/* 125e -  */  0,
/* 125f -  */  0,
/* 1260 -  */  0,
/* 1261 -  */  0,
/* 1262 -  */  0,
/* 1263 -  */  0,
/* 1264 -  */  0,
/* 1265 - _V_66_0F_38_98 */  0x4115,
/* 1266 -  */  0,
/* 1267 -  */  0,
/* 1268 -  */  0,
/* 1269 -  */  0,
/* 126a -  */  0,
/* 126b -  */  0,
/* 126c -  */  0,
/* 126d -  */  0,
/* 126e -  */  0,
/* 126f -  */  0,
/* 1270 -  */  0,
/* 1271 - _V_66_0F_38_99 */  0x4116,
/* 1272 -  */  0,
/* 1273 -  */  0,
/* 1274 -  */  0,
/* 1275 -  */  0,
/* 1276 -  */  0,
/* 1277 -  */  0,
/* 1278 -  */  0,
/* 1279 -  */  0,
/* 127a -  */  0,
/* 127b -  */  0,
/* 127c -  */  0,
/* 127d - _V_66_0F_38_9A */  0x4117,
/* 127e -  */  0,
/* 127f -  */  0,
/* 1280 -  */  0,
/* 1281 -  */  0,
/* 1282 -  */  0,
/* 1283 -  */  0,
/* 1284 -  */  0,
/* 1285 -  */  0,
/* 1286 -  */  0,
/* 1287 -  */  0,
/* 1288 -  */  0,
/* 1289 - _V_66_0F_38_9B */  0x4118,
/* 128a -  */  0,
/* 128b -  */  0,
/* 128c -  */  0,
/* 128d -  */  0,
/* 128e -  */  0,
/* 128f -  */  0,
/* 1290 -  */  0,
/* 1291 -  */  0,
/* 1292 -  */  0,
/* 1293 -  */  0,
/* 1294 -  */  0,
/* 1295 - _V_66_0F_38_9C */  0x4119,
/* 1296 -  */  0,
/* 1297 -  */  0,
/* 1298 -  */  0,
/* 1299 -  */  0,
/* 129a -  */  0,
/* 129b -  */  0,
/* 129c -  */  0,
/* 129d -  */  0,
/* 129e -  */  0,
/* 129f -  */  0,
/* 12a0 -  */  0,
/* 12a1 - _V_66_0F_38_9D */  0x411a,
/* 12a2 -  */  0,
/* 12a3 -  */  0,
/* 12a4 -  */  0,
/* 12a5 -  */  0,
/* 12a6 -  */  0,
/* 12a7 -  */  0,
/* 12a8 -  */  0,
/* 12a9 -  */  0,
/* 12aa -  */  0,
/* 12ab -  */  0,
/* 12ac -  */  0,
/* 12ad - _V_66_0F_38_9E */  0x411b,
/* 12ae -  */  0,
/* 12af -  */  0,
/* 12b0 -  */  0,
/* 12b1 -  */  0,
/* 12b2 -  */  0,
/* 12b3 -  */  0,
/* 12b4 -  */  0,
/* 12b5 -  */  0,
/* 12b6 -  */  0,
/* 12b7 -  */  0,
/* 12b8 -  */  0,
/* 12b9 - _V_66_0F_38_9F */  0x411c,
/* 12ba -  */  0,
/* 12bb -  */  0,
/* 12bc -  */  0,
/* 12bd -  */  0,
/* 12be -  */  0,
/* 12bf -  */  0,
/* 12c0 -  */  0,
/* 12c1 -  */  0,
/* 12c2 -  */  0,
/* 12c3 -  */  0,
/* 12c4 -  */  0,
/* 12c5 - _V_66_0F_38_A6 */  0x411d,
/* 12c6 -  */  0,
/* 12c7 -  */  0,
/* 12c8 -  */  0,
/* 12c9 -  */  0,
/* 12ca -  */  0,
/* 12cb -  */  0,
/* 12cc -  */  0,
/* 12cd -  */  0,
/* 12ce -  */  0,
/* 12cf -  */  0,
/* 12d0 -  */  0,
/* 12d1 - _V_66_0F_38_A7 */  0x411e,
/* 12d2 -  */  0,
/* 12d3 -  */  0,
/* 12d4 -  */  0,
/* 12d5 -  */  0,
/* 12d6 -  */  0,
/* 12d7 -  */  0,
/* 12d8 -  */  0,
/* 12d9 -  */  0,
/* 12da -  */  0,
/* 12db -  */  0,
/* 12dc -  */  0,
/* 12dd - _V_66_0F_38_A8 */  0x411f,
/* 12de -  */  0,
/* 12df -  */  0,
/* 12e0 -  */  0,
/* 12e1 -  */  0,
/* 12e2 -  */  0,
/* 12e3 -  */  0,
/* 12e4 -  */  0,
/* 12e5 -  */  0,
/* 12e6 -  */  0,
/* 12e7 -  */  0,
/* 12e8 -  */  0,
/* 12e9 - _V_66_0F_38_A9 */  0x4120,
/* 12ea -  */  0,
/* 12eb -  */  0,
/* 12ec -  */  0,
/* 12ed -  */  0,
/* 12ee -  */  0,
/* 12ef -  */  0,
/* 12f0 -  */  0,
/* 12f1 -  */  0,
/* 12f2 -  */  0,
/* 12f3 -  */  0,
/* 12f4 -  */  0,
/* 12f5 - _V_66_0F_38_AA */  0x4121,
/* 12f6 -  */  0,
/* 12f7 -  */  0,
/* 12f8 -  */  0,
/* 12f9 -  */  0,
/* 12fa -  */  0,
/* 12fb -  */  0,
/* 12fc -  */  0,
/* 12fd -  */  0,
/* 12fe -  */  0,
/* 12ff -  */  0,
/* 1300 -  */  0,
/* 1301 - _V_66_0F_38_AB */  0x4122,
/* 1302 -  */  0,
/* 1303 -  */  0,
/* 1304 -  */  0,
/* 1305 -  */  0,
/* 1306 -  */  0,
/* 1307 -  */  0,
/* 1308 -  */  0,
/* 1309 -  */  0,
/* 130a -  */  0,
/* 130b -  */  0,
/* 130c -  */  0,
/* 130d - _V_66_0F_38_AC */  0x4123,
/* 130e -  */  0,
/* 130f -  */  0,
/* 1310 -  */  0,
/* 1311 -  */  0,
/* 1312 -  */  0,
/* 1313 -  */  0,
/* 1314 -  */  0,
/* 1315 -  */  0,
/* 1316 -  */  0,
/* 1317 -  */  0,
/* 1318 -  */  0,
/* 1319 - _V_66_0F_38_AD */  0x4124,
/* 131a -  */  0,
/* 131b -  */  0,
/* 131c -  */  0,
/* 131d -  */  0,
/* 131e -  */  0,
/* 131f -  */  0,
/* 1320 -  */  0,
/* 1321 -  */  0,
/* 1322 -  */  0,
/* 1323 -  */  0,
/* 1324 -  */  0,
/* 1325 - _V_66_0F_38_AE */  0x4125,
/* 1326 -  */  0,
/* 1327 -  */  0,
/* 1328 -  */  0,
/* 1329 -  */  0,
/* 132a -  */  0,
/* 132b -  */  0,
/* 132c -  */  0,
/* 132d -  */  0,
/* 132e -  */  0,
/* 132f -  */  0,
/* 1330 -  */  0,
/* 1331 - _V_66_0F_38_AF */  0x4126,
/* 1332 -  */  0,
/* 1333 -  */  0,
/* 1334 -  */  0,
/* 1335 -  */  0,
/* 1336 -  */  0,
/* 1337 -  */  0,
/* 1338 -  */  0,
/* 1339 -  */  0,
/* 133a -  */  0,
/* 133b -  */  0,
/* 133c -  */  0,
/* 133d - _V_66_0F_38_B6 */  0x4127,
/* 133e -  */  0,
/* 133f -  */  0,
/* 1340 -  */  0,
/* 1341 -  */  0,
/* 1342 -  */  0,
/* 1343 -  */  0,
/* 1344 -  */  0,
/* 1345 -  */  0,
/* 1346 -  */  0,
/* 1347 -  */  0,
/* 1348 -  */  0,
/* 1349 - _V_66_0F_38_B7 */  0x4128,
/* 134a -  */  0,
/* 134b -  */  0,
/* 134c -  */  0,
/* 134d -  */  0,
/* 134e -  */  0,
/* 134f -  */  0,
/* 1350 -  */  0,
/* 1351 -  */  0,
/* 1352 -  */  0,
/* 1353 -  */  0,
/* 1354 -  */  0,
/* 1355 - _V_66_0F_38_B8 */  0x4129,
/* 1356 -  */  0,
/* 1357 -  */  0,
/* 1358 -  */  0,
/* 1359 -  */  0,
/* 135a -  */  0,
/* 135b -  */  0,
/* 135c -  */  0,
/* 135d -  */  0,
/* 135e -  */  0,
/* 135f -  */  0,
/* 1360 -  */  0,
/* 1361 - _V_66_0F_38_B9 */  0x412a,
/* 1362 -  */  0,
/* 1363 -  */  0,
/* 1364 -  */  0,
/* 1365 -  */  0,
/* 1366 -  */  0,
/* 1367 -  */  0,
/* 1368 -  */  0,
/* 1369 -  */  0,
/* 136a -  */  0,
/* 136b -  */  0,
/* 136c -  */  0,
/* 136d - _V_66_0F_38_BA */  0x412b,
/* 136e -  */  0,
/* 136f -  */  0,
/* 1370 -  */  0,
/* 1371 -  */  0,
/* 1372 -  */  0,
/* 1373 -  */  0,
/* 1374 -  */  0,
/* 1375 -  */  0,
/* 1376 -  */  0,
/* 1377 -  */  0,
/* 1378 -  */  0,
/* 1379 - _V_66_0F_38_BB */  0x412c,
/* 137a -  */  0,
/* 137b -  */  0,
/* 137c -  */  0,
/* 137d -  */  0,
/* 137e -  */  0,
/* 137f -  */  0,
/* 1380 -  */  0,
/* 1381 -  */  0,
/* 1382 -  */  0,
/* 1383 -  */  0,
/* 1384 -  */  0,
/* 1385 - _V_66_0F_38_BC */  0x412d,
/* 1386 -  */  0,
/* 1387 -  */  0,
/* 1388 -  */  0,
/* 1389 -  */  0,
/* 138a -  */  0,
/* 138b -  */  0,
/* 138c -  */  0,
/* 138d -  */  0,
/* 138e -  */  0,
/* 138f -  */  0,
/* 1390 -  */  0,
/* 1391 - _V_66_0F_38_BD */  0x412e,
/* 1392 -  */  0,
/* 1393 -  */  0,
/* 1394 -  */  0,
/* 1395 -  */  0,
/* 1396 -  */  0,
/* 1397 -  */  0,
/* 1398 -  */  0,
/* 1399 -  */  0,
/* 139a -  */  0,
/* 139b -  */  0,
/* 139c -  */  0,
/* 139d - _V_66_0F_38_BE */  0x412f,
/* 139e -  */  0,
/* 139f -  */  0,
/* 13a0 -  */  0,
/* 13a1 -  */  0,
/* 13a2 -  */  0,
/* 13a3 -  */  0,
/* 13a4 -  */  0,
/* 13a5 -  */  0,
/* 13a6 -  */  0,
/* 13a7 -  */  0,
/* 13a8 -  */  0,
/* 13a9 - _V_66_0F_38_BF */  0x4130,
/* 13aa -  */  0,
/* 13ab -  */  0,
/* 13ac -  */  0,
/* 13ad -  */  0,
/* 13ae -  */  0,
/* 13af -  */  0,
/* 13b0 -  */  0,
/* 13b1 - _66_0F_38_DB */  0x24ba,
/* 13b2 -  */  0,
/* 13b3 -  */  0,
/* 13b4 -  */  0,
/* 13b5 - _V_66_0F_38_DB */  0x4131,
/* 13b6 -  */  0,
/* 13b7 -  */  0,
/* 13b8 -  */  0,
/* 13b9 -  */  0,
/* 13ba -  */  0,
/* 13bb -  */  0,
/* 13bc -  */  0,
/* 13bd - _66_0F_38_DC */  0x24bb,
/* 13be -  */  0,
/* 13bf -  */  0,
/* 13c0 -  */  0,
/* 13c1 - _V_66_0F_38_DC */  0x4132,
/* 13c2 -  */  0,
/* 13c3 -  */  0,
/* 13c4 -  */  0,
/* 13c5 -  */  0,
/* 13c6 -  */  0,
/* 13c7 -  */  0,
/* 13c8 -  */  0,
/* 13c9 - _66_0F_38_DD */  0x24bc,
/* 13ca -  */  0,
/* 13cb -  */  0,
/* 13cc -  */  0,
/* 13cd - _V_66_0F_38_DD */  0x4133,
/* 13ce -  */  0,
/* 13cf -  */  0,
/* 13d0 -  */  0,
/* 13d1 -  */  0,
/* 13d2 -  */  0,
/* 13d3 -  */  0,
/* 13d4 -  */  0,
/* 13d5 - _66_0F_38_DE */  0x24bd,
/* 13d6 -  */  0,
/* 13d7 -  */  0,
/* 13d8 -  */  0,
/* 13d9 - _V_66_0F_38_DE */  0x4134,
/* 13da -  */  0,
/* 13db -  */  0,
/* 13dc -  */  0,
/* 13dd -  */  0,
/* 13de -  */  0,
/* 13df -  */  0,
/* 13e0 -  */  0,
/* 13e1 - _66_0F_38_DF */  0x24be,
/* 13e2 -  */  0,
/* 13e3 -  */  0,
/* 13e4 -  */  0,
/* 13e5 - _V_66_0F_38_DF */  0x4135,
/* 13e6 -  */  0,
/* 13e7 -  */  0,
/* 13e8 -  */  0,
/* 13e9 -  */  0,
/* 13ea -  */  0,
/* 13eb -  */  0,
/* 13ec - _0F_38_F0 */  0x24bf,
/* 13ed -  */  0,
/* 13ee -  */  0,
/* 13ef - _F2_0F_38_F0 */  0x24c0,
/* 13f0 -  */  0,
/* 13f1 -  */  0,
/* 13f2 -  */  0,
/* 13f3 -  */  0,
/* 13f4 -  */  0,
/* 13f5 -  */  0,
/* 13f6 -  */  0,
/* 13f7 -  */  0,
/* 13f8 - _0F_38_F1 */  0x24c1,
/* 13f9 -  */  0,
/* 13fa -  */  0,
/* 13fb - _F2_0F_38_F1 */  0x24c2,
/* 13fc -  */  0,
/* 13fd -  */  0,
/* 13fe -  */  0,
/* 13ff -  */  0,
/* 1400 -  */  0,
/* 1401 -  */  0,
/* 1402 -  */  0,
/* 1403 -  */  0,
/* 1404 -  */  0,
/* 1405 -  */  0,
/* 1406 -  */  0,
/* 1407 -  */  0,
/* 1408 -  */  0,
/* 1409 - _V_66_0F_3A_04 */  0x4136,
/* 140a -  */  0,
/* 140b -  */  0,
/* 140c -  */  0,
/* 140d -  */  0,
/* 140e -  */  0,
/* 140f -  */  0,
/* 1410 -  */  0,
/* 1411 -  */  0,
/* 1412 -  */  0,
/* 1413 -  */  0,
/* 1414 -  */  0,
/* 1415 - _V_66_0F_3A_05 */  0x4137,
/* 1416 -  */  0,
/* 1417 -  */  0,
/* 1418 -  */  0,
/* 1419 -  */  0,
/* 141a -  */  0,
/* 141b -  */  0,
/* 141c -  */  0,
/* 141d -  */  0,
/* 141e -  */  0,
/* 141f -  */  0,
/* 1420 -  */  0,
/* 1421 - _V_66_0F_3A_06 */  0x4138,
/* 1422 -  */  0,
/* 1423 -  */  0,
/* 1424 -  */  0,
/* 1425 -  */  0,
/* 1426 -  */  0,
/* 1427 -  */  0,
/* 1428 -  */  0,
/* 1429 - _66_0F_3A_08 */  0x4139,
/* 142a -  */  0,
/* 142b -  */  0,
/* 142c -  */  0,
/* 142d - _V_66_0F_3A_08 */  0x413a,
/* 142e -  */  0,
/* 142f -  */  0,
/* 1430 -  */  0,
/* 1431 -  */  0,
/* 1432 -  */  0,
/* 1433 -  */  0,
/* 1434 -  */  0,
/* 1435 - _66_0F_3A_09 */  0x413b,
/* 1436 -  */  0,
/* 1437 -  */  0,
/* 1438 -  */  0,
/* 1439 - _V_66_0F_3A_09 */  0x413c,
/* 143a -  */  0,
/* 143b -  */  0,
/* 143c -  */  0,
/* 143d -  */  0,
/* 143e -  */  0,
/* 143f -  */  0,
/* 1440 -  */  0,
/* 1441 - _66_0F_3A_0A */  0x413d,
/* 1442 -  */  0,
/* 1443 -  */  0,
/* 1444 -  */  0,
/* 1445 - _V_66_0F_3A_0A */  0x413e,
/* 1446 -  */  0,
/* 1447 -  */  0,
/* 1448 -  */  0,
/* 1449 -  */  0,
/* 144a -  */  0,
/* 144b -  */  0,
/* 144c -  */  0,
/* 144d - _66_0F_3A_0B */  0x413f,
/* 144e -  */  0,
/* 144f -  */  0,
/* 1450 -  */  0,
/* 1451 - _V_66_0F_3A_0B */  0x4140,
/* 1452 -  */  0,
/* 1453 -  */  0,
/* 1454 -  */  0,
/* 1455 -  */  0,
/* 1456 -  */  0,
/* 1457 -  */  0,
/* 1458 -  */  0,
/* 1459 - _66_0F_3A_0C */  0x4141,
/* 145a -  */  0,
/* 145b -  */  0,
/* 145c -  */  0,
/* 145d - _V_66_0F_3A_0C */  0x4142,
/* 145e -  */  0,
/* 145f -  */  0,
/* 1460 -  */  0,
/* 1461 -  */  0,
/* 1462 -  */  0,
/* 1463 -  */  0,
/* 1464 -  */  0,
/* 1465 - _66_0F_3A_0D */  0x4143,
/* 1466 -  */  0,
/* 1467 -  */  0,
/* 1468 -  */  0,
/* 1469 - _V_66_0F_3A_0D */  0x4144,
/* 146a -  */  0,
/* 146b -  */  0,
/* 146c -  */  0,
/* 146d -  */  0,
/* 146e -  */  0,
/* 146f -  */  0,
/* 1470 -  */  0,
/* 1471 - _66_0F_3A_0E */  0x4145,
/* 1472 -  */  0,
/* 1473 -  */  0,
/* 1474 -  */  0,
/* 1475 - _V_66_0F_3A_0E */  0x4146,
/* 1476 -  */  0,
/* 1477 -  */  0,
/* 1478 -  */  0,
/* 1479 -  */  0,
/* 147a -  */  0,
/* 147b -  */  0,
/* 147c - _0F_3A_0F */  0x4147,
/* 147d - _66_0F_3A_0F */  0x4148,
/* 147e -  */  0,
/* 147f -  */  0,
/* 1480 -  */  0,
/* 1481 - _V_66_0F_3A_0F */  0x4149,
/* 1482 -  */  0,
/* 1483 -  */  0,
/* 1484 -  */  0,
/* 1485 -  */  0,
/* 1486 -  */  0,
/* 1487 -  */  0,
/* 1488 -  */  0,
/* 1489 - _66_0F_3A_14 */  0x414a,
/* 148a -  */  0,
/* 148b -  */  0,
/* 148c -  */  0,
/* 148d - _V_66_0F_3A_14 */  0x414b,
/* 148e -  */  0,
/* 148f -  */  0,
/* 1490 -  */  0,
/* 1491 -  */  0,
/* 1492 -  */  0,
/* 1493 -  */  0,
/* 1494 -  */  0,
/* 1495 - _66_0F_3A_15 */  0x414c,
/* 1496 -  */  0,
/* 1497 -  */  0,
/* 1498 -  */  0,
/* 1499 - _V_66_0F_3A_15 */  0x414d,
/* 149a -  */  0,
/* 149b -  */  0,
/* 149c -  */  0,
/* 149d -  */  0,
/* 149e -  */  0,
/* 149f -  */  0,
/* 14a0 -  */  0,
/* 14a1 - _66_0F_3A_16 */  0x414e,
/* 14a2 -  */  0,
/* 14a3 -  */  0,
/* 14a4 -  */  0,
/* 14a5 - _V_66_0F_3A_16 */  0x414f,
/* 14a6 -  */  0,
/* 14a7 -  */  0,
/* 14a8 -  */  0,
/* 14a9 -  */  0,
/* 14aa -  */  0,
/* 14ab -  */  0,
/* 14ac -  */  0,
/* 14ad - _66_0F_3A_17 */  0x4150,
/* 14ae -  */  0,
/* 14af -  */  0,
/* 14b0 -  */  0,
/* 14b1 - _V_66_0F_3A_17 */  0x4151,
/* 14b2 -  */  0,
/* 14b3 -  */  0,
/* 14b4 -  */  0,
/* 14b5 -  */  0,
/* 14b6 -  */  0,
/* 14b7 -  */  0,
/* 14b8 -  */  0,
/* 14b9 -  */  0,
/* 14ba -  */  0,
/* 14bb -  */  0,
/* 14bc -  */  0,
/* 14bd - _V_66_0F_3A_18 */  0x4152,
/* 14be -  */  0,
/* 14bf -  */  0,
/* 14c0 -  */  0,
/* 14c1 -  */  0,
/* 14c2 -  */  0,
/* 14c3 -  */  0,
/* 14c4 -  */  0,
/* 14c5 -  */  0,
/* 14c6 -  */  0,
/* 14c7 -  */  0,
/* 14c8 -  */  0,
/* 14c9 - _V_66_0F_3A_19 */  0x4153,
/* 14ca -  */  0,
/* 14cb -  */  0,
/* 14cc -  */  0,
/* 14cd -  */  0,
/* 14ce -  */  0,
/* 14cf -  */  0,
/* 14d0 -  */  0,
/* 14d1 - _66_0F_3A_20 */  0x4154,
/* 14d2 -  */  0,
/* 14d3 -  */  0,
/* 14d4 -  */  0,
/* 14d5 - _V_66_0F_3A_20 */  0x4155,
/* 14d6 -  */  0,
/* 14d7 -  */  0,
/* 14d8 -  */  0,
/* 14d9 -  */  0,
/* 14da -  */  0,
/* 14db -  */  0,
/* 14dc -  */  0,
/* 14dd - _66_0F_3A_21 */  0x4156,
/* 14de -  */  0,
/* 14df -  */  0,
/* 14e0 -  */  0,
/* 14e1 - _V_66_0F_3A_21 */  0x4157,
/* 14e2 -  */  0,
/* 14e3 -  */  0,
/* 14e4 -  */  0,
/* 14e5 -  */  0,
/* 14e6 -  */  0,
/* 14e7 -  */  0,
/* 14e8 -  */  0,
/* 14e9 - _66_0F_3A_22 */  0x4158,
/* 14ea -  */  0,
/* 14eb -  */  0,
/* 14ec -  */  0,
/* 14ed - _V_66_0F_3A_22 */  0x4159,
/* 14ee -  */  0,
/* 14ef -  */  0,
/* 14f0 -  */  0,
/* 14f1 -  */  0,
/* 14f2 -  */  0,
/* 14f3 -  */  0,
/* 14f4 -  */  0,
/* 14f5 - _66_0F_3A_40 */  0x415a,
/* 14f6 -  */  0,
/* 14f7 -  */  0,
/* 14f8 -  */  0,
/* 14f9 - _V_66_0F_3A_40 */  0x415b,
/* 14fa -  */  0,
/* 14fb -  */  0,
/* 14fc -  */  0,
/* 14fd -  */  0,
/* 14fe -  */  0,
/* 14ff -  */  0,
/* 1500 -  */  0,
/* 1501 - _66_0F_3A_41 */  0x415c,
/* 1502 -  */  0,
/* 1503 -  */  0,
/* 1504 -  */  0,
/* 1505 - _V_66_0F_3A_41 */  0x415d,
/* 1506 -  */  0,
/* 1507 -  */  0,
/* 1508 -  */  0,
/* 1509 -  */  0,
/* 150a -  */  0,
/* 150b -  */  0,
/* 150c -  */  0,
/* 150d - _66_0F_3A_42 */  0x415e,
/* 150e -  */  0,
/* 150f -  */  0,
/* 1510 -  */  0,
/* 1511 - _V_66_0F_3A_42 */  0x415f,
/* 1512 -  */  0,
/* 1513 -  */  0,
/* 1514 -  */  0,
/* 1515 -  */  0,
/* 1516 -  */  0,
/* 1517 -  */  0,
/* 1518 -  */  0,
/* 1519 - _66_0F_3A_44 */  0x4160,
/* 151a -  */  0,
/* 151b -  */  0,
/* 151c -  */  0,
/* 151d - _V_66_0F_3A_44 */  0x4161,
/* 151e -  */  0,
/* 151f -  */  0,
/* 1520 -  */  0,
/* 1521 -  */  0,
/* 1522 -  */  0,
/* 1523 -  */  0,
/* 1524 -  */  0,
/* 1525 -  */  0,
/* 1526 -  */  0,
/* 1527 -  */  0,
/* 1528 -  */  0,
/* 1529 - _V_66_0F_3A_4A */  0x4162,
/* 152a -  */  0,
/* 152b -  */  0,
/* 152c -  */  0,
/* 152d -  */  0,
/* 152e -  */  0,
/* 152f -  */  0,
/* 1530 -  */  0,
/* 1531 -  */  0,
/* 1532 -  */  0,
/* 1533 -  */  0,
/* 1534 -  */  0,
/* 1535 - _V_66_0F_3A_4B */  0x4163,
/* 1536 -  */  0,
/* 1537 -  */  0,
/* 1538 -  */  0,
/* 1539 -  */  0,
/* 153a -  */  0,
/* 153b -  */  0,
/* 153c -  */  0,
/* 153d -  */  0,
/* 153e -  */  0,
/* 153f -  */  0,
/* 1540 -  */  0,
/* 1541 - _V_66_0F_3A_4C */  0x4164,
/* 1542 -  */  0,
/* 1543 -  */  0,
/* 1544 -  */  0,
/* 1545 -  */  0,
/* 1546 -  */  0,
/* 1547 -  */  0,
/* 1548 -  */  0,
/* 1549 - _66_0F_3A_60 */  0x4165,
/* 154a -  */  0,
/* 154b -  */  0,
/* 154c -  */  0,
/* 154d - _V_66_0F_3A_60 */  0x4166,
/* 154e -  */  0,
/* 154f -  */  0,
/* 1550 -  */  0,
/* 1551 -  */  0,
/* 1552 -  */  0,
/* 1553 -  */  0,
/* 1554 -  */  0,
/* 1555 - _66_0F_3A_61 */  0x4167,
/* 1556 -  */  0,
/* 1557 -  */  0,
/* 1558 -  */  0,
/* 1559 - _V_66_0F_3A_61 */  0x4168,
/* 155a -  */  0,
/* 155b -  */  0,
/* 155c -  */  0,
/* 155d -  */  0,
/* 155e -  */  0,
/* 155f -  */  0,
/* 1560 -  */  0,
/* 1561 - _66_0F_3A_62 */  0x4169,
/* 1562 -  */  0,
/* 1563 -  */  0,
/* 1564 -  */  0,
/* 1565 - _V_66_0F_3A_62 */  0x416a,
/* 1566 -  */  0,
/* 1567 -  */  0,
/* 1568 -  */  0,
/* 1569 -  */  0,
/* 156a -  */  0,
/* 156b -  */  0,
/* 156c -  */  0,
/* 156d - _66_0F_3A_63 */  0x416b,
/* 156e -  */  0,
/* 156f -  */  0,
/* 1570 -  */  0,
/* 1571 - _V_66_0F_3A_63 */  0x416c,
/* 1572 -  */  0,
/* 1573 -  */  0,
/* 1574 -  */  0,
/* 1575 -  */  0,
/* 1576 -  */  0,
/* 1577 -  */  0,
/* 1578 -  */  0,
/* 1579 - _66_0F_3A_DF */  0x416d,
/* 157a -  */  0,
/* 157b -  */  0,
/* 157c -  */  0,
/* 157d - _V_66_0F_3A_DF */  0x416e,
/* 157e -  */  0,
/* 157f -  */  0,
/* 1580 -  */  0,
/* 1581 -  */  0,
/* 1582 -  */  0,
/* 1583 -  */  0,
/* 1584 - _0F_71_02 */  0x24c3,
/* 1585 - _66_0F_71_02 */  0x24c4,
/* 1586 -  */  0,
/* 1587 -  */  0,
/* 1588 -  */  0,
/* 1589 - _V_66_0F_71_02 */  0x416f,
/* 158a -  */  0,
/* 158b -  */  0,
/* 158c -  */  0,
/* 158d -  */  0,
/* 158e -  */  0,
/* 158f -  */  0,
/* 1590 - _0F_71_04 */  0x24c5,
/* 1591 - _66_0F_71_04 */  0x24c6,
/* 1592 -  */  0,
/* 1593 -  */  0,
/* 1594 -  */  0,
/* 1595 - _V_66_0F_71_04 */  0x4170,
/* 1596 -  */  0,
/* 1597 -  */  0,
/* 1598 -  */  0,
/* 1599 -  */  0,
/* 159a -  */  0,
/* 159b -  */  0,
/* 159c - _0F_71_06 */  0x24c7,
/* 159d - _66_0F_71_06 */  0x24c8,
/* 159e -  */  0,
/* 159f -  */  0,
/* 15a0 -  */  0,
/* 15a1 - _V_66_0F_71_06 */  0x4171,
/* 15a2 -  */  0,
/* 15a3 -  */  0,
/* 15a4 -  */  0,
/* 15a5 -  */  0,
/* 15a6 -  */  0,
/* 15a7 -  */  0,
/* 15a8 - _0F_72_02 */  0x24c9,
/* 15a9 - _66_0F_72_02 */  0x24ca,
/* 15aa -  */  0,
/* 15ab -  */  0,
/* 15ac -  */  0,
/* 15ad - _V_66_0F_72_02 */  0x4172,
/* 15ae -  */  0,
/* 15af -  */  0,
/* 15b0 -  */  0,
/* 15b1 -  */  0,
/* 15b2 -  */  0,
/* 15b3 -  */  0,
/* 15b4 - _0F_72_04 */  0x24cb,
/* 15b5 - _66_0F_72_04 */  0x24cc,
/* 15b6 -  */  0,
/* 15b7 -  */  0,
/* 15b8 -  */  0,
/* 15b9 - _V_66_0F_72_04 */  0x4173,
/* 15ba -  */  0,
/* 15bb -  */  0,
/* 15bc -  */  0,
/* 15bd -  */  0,
/* 15be -  */  0,
/* 15bf -  */  0,
/* 15c0 - _0F_72_06 */  0x24cd,
/* 15c1 - _66_0F_72_06 */  0x24ce,
/* 15c2 -  */  0,
/* 15c3 -  */  0,
/* 15c4 -  */  0,
/* 15c5 - _V_66_0F_72_06 */  0x4174,
/* 15c6 -  */  0,
/* 15c7 -  */  0,
/* 15c8 -  */  0,
/* 15c9 -  */  0,
/* 15ca -  */  0,
/* 15cb -  */  0,
/* 15cc - _0F_73_02 */  0x24cf,
/* 15cd - _66_0F_73_02 */  0x24d0,
/* 15ce -  */  0,
/* 15cf -  */  0,
/* 15d0 -  */  0,
/* 15d1 - _V_66_0F_73_02 */  0x4175,
/* 15d2 -  */  0,
/* 15d3 -  */  0,
/* 15d4 -  */  0,
/* 15d5 -  */  0,
/* 15d6 -  */  0,
/* 15d7 -  */  0,
/* 15d8 -  */  0,
/* 15d9 - _66_0F_73_03 */  0x24d1,
/* 15da -  */  0,
/* 15db -  */  0,
/* 15dc -  */  0,
/* 15dd - _V_66_0F_73_03 */  0x4176,
/* 15de -  */  0,
/* 15df -  */  0,
/* 15e0 -  */  0,
/* 15e1 -  */  0,
/* 15e2 -  */  0,
/* 15e3 -  */  0,
/* 15e4 - _0F_73_06 */  0x24d2,
/* 15e5 - _66_0F_73_06 */  0x24d3,
/* 15e6 -  */  0,
/* 15e7 -  */  0,
/* 15e8 -  */  0,
/* 15e9 - _V_66_0F_73_06 */  0x4177,
/* 15ea -  */  0,
/* 15eb -  */  0,
/* 15ec -  */  0,
/* 15ed -  */  0,
/* 15ee -  */  0,
/* 15ef -  */  0,
/* 15f0 -  */  0,
/* 15f1 - _66_0F_73_07 */  0x24d4,
/* 15f2 -  */  0,
/* 15f3 -  */  0,
/* 15f4 -  */  0,
/* 15f5 - _V_66_0F_73_07 */  0x4178,
/* 15f6 -  */  0,
/* 15f7 -  */  0,
/* 15f8 -  */  0,
/* 15f9 -  */  0,
/* 15fa -  */  0,
/* 15fb -  */  0,
/* 15fc - _0F_AE_00 */  0x4179,
/* 15fd -  */  0,
/* 15fe - _F3_0F_AE_00 */  0x24d5,
/* 15ff -  */  0,
/* 1600 -  */  0,
/* 1601 -  */  0,
/* 1602 -  */  0,
/* 1603 -  */  0,
/* 1604 -  */  0,
/* 1605 -  */  0,
/* 1606 -  */  0,
/* 1607 -  */  0,
/* 1608 - _0F_AE_01 */  0x417a,
/* 1609 -  */  0,
/* 160a - _F3_0F_AE_01 */  0x24d6,
/* 160b -  */  0,
/* 160c -  */  0,
/* 160d -  */  0,
/* 160e -  */  0,
/* 160f -  */  0,
/* 1610 -  */  0,
/* 1611 -  */  0,
/* 1612 -  */  0,
/* 1613 -  */  0,
/* 1614 - _0F_AE_02 */  0x24d7,
/* 1615 -  */  0,
/* 1616 - _F3_0F_AE_02 */  0x24d8,
/* 1617 -  */  0,
/* 1618 - _V_0F_AE_02 */  0x417b,
/* 1619 -  */  0,
/* 161a -  */  0,
/* 161b -  */  0,
/* 161c -  */  0,
/* 161d -  */  0,
/* 161e -  */  0,
/* 161f -  */  0,
/* 1620 - _0F_AE_03 */  0x24d9,
/* 1621 -  */  0,
/* 1622 - _F3_0F_AE_03 */  0x24da,
/* 1623 -  */  0,
/* 1624 - _V_0F_AE_03 */  0x417c,
/* 1625 -  */  0,
/* 1626 -  */  0,
/* 1627 -  */  0,
/* 1628 -  */  0,
/* 1629 -  */  0,
/* 162a -  */  0,
/* 162b -  */  0,
/* 162c - _0F_C7_06 */  0x24db,
/* 162d - _66_0F_C7_06 */  0x24dc,
/* 162e - _F3_0F_C7_06 */  0x24dd,
/* 162f -  */  0,
/* 1630 -  */  0,
/* 1631 -  */  0,
/* 1632 -  */  0,
/* 1633 -  */  0,
/* 1634 -  */  0,
/* 1635 -  */  0,
/* 1636 -  */  0,
/* 1637 -  */  0
};

_InstSharedInfo InstSharedInfoTable[474] = {
{0, 6, 68, 245, 0, 0, 256},
{0, 8, 72, 245, 0, 0, 256},
{0, 68, 6, 245, 0, 0, 256},
{0, 72, 8, 245, 0, 0, 256},
{1, 1, 11, 245, 0, 0, 256},
{1, 3, 13, 245, 0, 0, 256},
{2, 0, 46, 0, 0, 0, 256},
{3, 0, 46, 0, 0, 0, 256},
{0, 6, 68, 196, 16, 0, 256},
{0, 8, 72, 196, 16, 0, 256},
{0, 68, 6, 196, 16, 0, 256},
{0, 72, 8, 196, 16, 0, 256},
{1, 1, 11, 196, 16, 0, 256},
{1, 3, 13, 196, 16, 0, 256},
{4, 0, 46, 0, 0, 0, 256},
{0, 6, 68, 245, 1, 0, 256},
{0, 8, 72, 245, 1, 0, 256},
{0, 68, 6, 245, 1, 0, 256},
{0, 72, 8, 245, 1, 0, 256},
{1, 1, 11, 245, 1, 0, 256},
{1, 3, 13, 245, 1, 0, 256},
{5, 0, 46, 0, 0, 0, 256},
{6, 0, 46, 0, 0, 0, 256},
{7, 0, 46, 0, 0, 0, 256},
{8, 0, 46, 0, 0, 0, 256},
{0, 6, 68, 229, 0, 16, 256},
{0, 8, 72, 229, 0, 16, 256},
{0, 68, 6, 229, 0, 16, 256},
{0, 72, 8, 229, 0, 16, 256},
{1, 1, 11, 229, 0, 16, 256},
{1, 3, 13, 229, 0, 16, 256},
{9, 0, 0, 213, 17, 32, 256},
{0, 6, 68, 196, 0, 16, 256},
{0, 8, 72, 196, 0, 16, 256},
{0, 68, 6, 196, 0, 16, 256},
{0, 72, 8, 196, 0, 16, 256},
{1, 1, 11, 196, 0, 16, 256},
{1, 3, 13, 196, 0, 16, 256},
{9, 0, 0, 17, 16, 228, 256},
{10, 6, 68, 245, 0, 0, 256},
{10, 8, 72, 245, 0, 0, 256},
{10, 68, 6, 245, 0, 0, 256},
{10, 72, 8, 245, 0, 0, 256},
{11, 1, 11, 245, 0, 0, 256},
{11, 3, 13, 245, 0, 0, 256},
{12, 0, 18, 244, 0, 0, 256},
{13, 0, 18, 0, 0, 0, 256},
{14, 0, 18, 0, 0, 0, 256},
{15, 0, 0, 0, 0, 0, 256},
{16, 54, 8, 0, 0, 0, 256},
{10, 7, 69, 64, 0, 0, 256},
{13, 0, 3, 0, 0, 0, 256},
{17, 72, 8, 33, 0, 212, 256},
{18, 0, 5, 0, 0, 0, 256},
{19, 25, 22, 0, 8, 0, 33024},
{20, 25, 22, 0, 8, 0, 33024},
{19, 21, 25, 0, 8, 0, 33024},
{20, 21, 25, 0, 8, 0, 33024},
{13, 0, 15, 0, 32, 0, 261},
{13, 0, 15, 0, 1, 0, 261},
{13, 0, 15, 0, 64, 0, 261},
{13, 0, 15, 0, 65, 0, 261},
{13, 0, 15, 0, 128, 0, 261},
{13, 0, 15, 0, 4, 0, 261},
{13, 0, 15, 0, 160, 0, 261},
{13, 0, 15, 0, 224, 0, 261},
{10, 6, 68, 196, 0, 16, 256},
{10, 8, 72, 196, 0, 16, 256},
{0, 6, 68, 0, 0, 0, 256},
{0, 8, 72, 0, 0, 0, 256},
{21, 6, 68, 0, 0, 0, 256},
{21, 8, 72, 0, 0, 0, 256},
{21, 68, 6, 0, 0, 0, 256},
{21, 72, 8, 0, 0, 0, 256},
{21, 45, 71, 0, 0, 0, 256},
{21, 54, 8, 0, 0, 0, 256},
{21, 71, 45, 0, 0, 0, 256},
{1, 13, 18, 0, 0, 0, 256},
{22, 0, 0, 0, 0, 0, 256},
{9, 0, 50, 0, 0, 0, 257},
{23, 0, 0, 0, 0, 0, 256},
{23, 0, 0, 255, 0, 0, 256},
{11, 0, 0, 213, 0, 0, 256},
{11, 0, 0, 0, 0, 0, 256},
{1, 19, 11, 0, 0, 0, 256},
{1, 20, 13, 0, 0, 0, 256},
{1, 11, 19, 0, 0, 0, 256},
{1, 13, 20, 0, 0, 0, 256},
{24, 21, 22, 0, 8, 0, 256},
{25, 21, 22, 0, 8, 0, 256},
{19, 22, 21, 245, 8, 0, 256},
{26, 22, 21, 245, 8, 0, 256},
{11, 1, 11, 196, 0, 16, 256},
{11, 3, 13, 196, 0, 16, 256},
{19, 11, 22, 0, 8, 0, 256},
{26, 13, 22, 0, 8, 0, 256},
{19, 21, 11, 0, 8, 0, 256},
{26, 21, 13, 0, 8, 0, 256},
{19, 11, 22, 245, 8, 0, 256},
{26, 13, 22, 245, 8, 0, 256},
{1, 1, 17, 0, 0, 0, 256},
{27, 3, 18, 0, 0, 0, 256},
{13, 0, 2, 0, 0, 0, 258},
{13, 0, 0, 0, 0, 0, 258},
{16, 60, 8, 0, 0, 0, 256},
{13, 49, 47, 0, 0, 0, 256},
{13, 0, 0, 0, 0, 0, 256},
{28, 0, 2, 0, 0, 0, 258},
{28, 0, 0, 0, 0, 0, 258},
{11, 0, 0, 0, 0, 0, 262},
{11, 0, 1, 0, 0, 0, 262},
{9, 0, 0, 0, 0, 0, 262},
{28, 0, 0, 255, 0, 0, 33026},
{9, 0, 1, 196, 0, 49, 256},
{9, 0, 0, 0, 0, 0, 256},
{29, 0, 23, 0, 0, 0, 256},
{30, 0, 15, 0, 64, 0, 261},
{30, 0, 15, 0, 0, 0, 261},
{31, 0, 15, 0, 0, 0, 261},
{1, 1, 11, 0, 0, 0, 33024},
{1, 1, 14, 0, 0, 0, 33024},
{11, 11, 1, 0, 0, 0, 33024},
{11, 14, 1, 0, 0, 0, 33024},
{13, 0, 16, 0, 0, 0, 257},
{13, 0, 16, 0, 0, 0, 260},
{9, 0, 50, 0, 0, 0, 260},
{13, 0, 15, 0, 0, 0, 260},
{1, 25, 11, 0, 0, 0, 33024},
{1, 25, 14, 0, 0, 0, 33024},
{11, 11, 25, 0, 0, 0, 33024},
{11, 14, 25, 0, 0, 0, 33024},
{11, 0, 0, 0, 0, 0, 33032},
{11, 0, 0, 1, 0, 0, 256},
{11, 0, 0, 2, 0, 0, 33024},
{11, 0, 0, 8, 0, 0, 256},
{10, 69, 8, 64, 0, 0, 256},
{32, 0, 0, 0, 0, 0, 771},
{32, 0, 0, 0, 0, 0, 33024},
{32, 0, 0, 0, 0, 0, 262},
{11, 0, 0, 0, 0, 0, 3072},
{10, 0, 72, 0, 0, 0, 256},
{33, 43, 51, 0, 0, 0, 33024},
{33, 44, 51, 0, 0, 0, 33024},
{33, 51, 43, 0, 0, 0, 33024},
{33, 51, 44, 0, 0, 0, 33024},
{32, 0, 0, 0, 0, 0, 256},
{34, 72, 8, 0, 32, 0, 775},
{34, 72, 8, 0, 1, 0, 775},
{34, 72, 8, 0, 64, 0, 775},
{34, 72, 8, 0, 65, 0, 775},
{34, 72, 8, 0, 128, 0, 775},
{34, 72, 8, 0, 4, 0, 775},
{34, 72, 8, 0, 160, 0, 775},
{34, 72, 8, 0, 224, 0, 775},
{32, 0, 16, 0, 32, 0, 261},
{32, 0, 16, 0, 1, 0, 261},
{32, 0, 16, 0, 64, 0, 261},
{32, 0, 16, 0, 65, 0, 261},
{32, 0, 16, 0, 128, 0, 261},
{32, 0, 16, 0, 4, 0, 261},
{32, 0, 16, 0, 160, 0, 261},
{32, 0, 16, 0, 224, 0, 261},
{34, 0, 68, 0, 32, 0, 256},
{34, 0, 68, 0, 1, 0, 256},
{34, 0, 68, 0, 64, 0, 256},
{34, 0, 68, 0, 65, 0, 256},
{34, 0, 68, 0, 128, 0, 256},
{34, 0, 68, 0, 4, 0, 256},
{34, 0, 68, 0, 160, 0, 256},
{34, 0, 68, 0, 224, 0, 256},
{35, 0, 46, 0, 0, 0, 256},
{36, 0, 46, 0, 0, 0, 256},
{34, 8, 72, 1, 0, 244, 256},
{37, 8, 72, 197, 0, 48, 256},
{38, 0, 46, 0, 0, 0, 256},
{39, 0, 46, 0, 0, 0, 256},
{32, 0, 0, 255, 0, 0, 256},
{40, 8, 72, 1, 0, 244, 256},
{34, 72, 8, 33, 0, 212, 256},
{40, 6, 68, 245, 0, 0, 256},
{40, 8, 72, 245, 0, 0, 256},
{41, 60, 8, 0, 0, 0, 256},
{34, 68, 8, 0, 0, 0, 256},
{42, 69, 8, 0, 0, 0, 256},
{42, 10, 56, 0, 0, 0, 1536},
{43, 0, 18, 0, 0, 0, 256},
{44, 1, 68, 245, 0, 0, 256},
{44, 1, 68, 196, 16, 0, 256},
{44, 1, 68, 245, 1, 0, 256},
{44, 1, 68, 229, 0, 16, 256},
{44, 1, 68, 196, 0, 16, 256},
{45, 1, 68, 245, 0, 0, 256},
{44, 3, 72, 245, 0, 0, 256},
{44, 3, 72, 196, 16, 0, 256},
{44, 3, 72, 245, 1, 0, 256},
{44, 3, 72, 229, 0, 16, 256},
{44, 3, 72, 196, 0, 16, 256},
{45, 3, 72, 245, 0, 0, 256},
{46, 1, 68, 245, 0, 0, 256},
{46, 1, 68, 196, 16, 0, 256},
{46, 1, 68, 245, 1, 0, 256},
{46, 1, 68, 229, 0, 16, 256},
{46, 1, 68, 196, 0, 16, 256},
{47, 1, 68, 245, 0, 0, 256},
{44, 5, 72, 245, 0, 0, 256},
{48, 5, 72, 196, 16, 0, 256},
{44, 5, 72, 245, 1, 0, 256},
{48, 5, 72, 229, 0, 16, 256},
{48, 5, 72, 196, 0, 16, 256},
{45, 5, 72, 245, 0, 0, 256},
{49, 0, 72, 0, 0, 0, 256},
{50, 1, 68, 1, 0, 32, 256},
{50, 1, 68, 1, 1, 32, 256},
{50, 1, 68, 197, 0, 48, 256},
{50, 1, 72, 1, 0, 32, 256},
{50, 1, 72, 1, 1, 32, 256},
{50, 1, 72, 197, 0, 48, 256},
{51, 1, 68, 0, 0, 0, 256},
{52, 0, 1, 0, 0, 0, 768},
{51, 3, 72, 0, 0, 0, 256},
{52, 0, 16, 0, 0, 0, 768},
{50, 41, 68, 33, 0, 0, 256},
{50, 41, 68, 33, 1, 0, 256},
{50, 41, 68, 229, 0, 16, 256},
{50, 41, 72, 33, 0, 0, 256},
{50, 41, 72, 33, 1, 0, 256},
{50, 41, 72, 229, 0, 16, 256},
{50, 42, 68, 1, 0, 32, 256},
{50, 42, 68, 1, 1, 32, 256},
{50, 42, 68, 197, 0, 48, 256},
{50, 42, 72, 1, 0, 32, 256},
{50, 42, 72, 1, 1, 32, 256},
{50, 42, 72, 197, 0, 48, 256},
{45, 0, 64, 0, 0, 0, 512},
{53, 0, 28, 0, 0, 0, 512},
{53, 0, 27, 0, 0, 0, 512},
{53, 0, 0, 0, 0, 0, 512},
{50, 0, 64, 0, 0, 0, 512},
{45, 0, 54, 0, 0, 0, 512},
{45, 0, 63, 0, 0, 0, 512},
{54, 0, 28, 0, 1, 0, 768},
{54, 0, 28, 0, 64, 0, 768},
{54, 0, 28, 0, 65, 0, 768},
{54, 0, 28, 0, 4, 0, 768},
{55, 0, 64, 0, 0, 0, 1792},
{45, 0, 66, 0, 0, 0, 512},
{50, 0, 66, 0, 0, 0, 512},
{54, 0, 28, 69, 0, 0, 512},
{54, 0, 28, 69, 0, 0, 768},
{45, 0, 65, 0, 0, 0, 512},
{53, 0, 29, 0, 0, 0, 512},
{55, 0, 65, 0, 0, 0, 1792},
{50, 0, 65, 0, 0, 0, 512},
{55, 0, 63, 0, 0, 0, 1792},
{50, 0, 63, 0, 0, 0, 512},
{45, 1, 68, 196, 0, 16, 256},
{44, 0, 68, 0, 0, 0, 256},
{44, 0, 68, 245, 0, 0, 256},
{50, 0, 68, 33, 0, 212, 256},
{50, 0, 68, 0, 0, 245, 256},
{45, 3, 72, 196, 0, 16, 256},
{44, 0, 72, 0, 0, 0, 256},
{44, 0, 72, 245, 0, 0, 256},
{50, 0, 72, 33, 0, 212, 256},
{50, 0, 72, 0, 0, 245, 256},
{44, 0, 68, 244, 0, 0, 256},
{44, 0, 72, 244, 0, 0, 256},
{56, 0, 72, 0, 0, 0, 257},
{57, 0, 60, 0, 0, 0, 257},
{56, 0, 72, 0, 0, 0, 260},
{57, 0, 60, 0, 0, 0, 260},
{56, 0, 72, 0, 0, 0, 256},
{45, 0, 72, 0, 0, 0, 256},
{45, 0, 69, 0, 0, 0, 256},
{45, 0, 69, 0, 0, 0, 33024},
{55, 0, 69, 0, 0, 0, 33024},
{45, 0, 69, 64, 0, 0, 256},
{56, 0, 61, 0, 0, 0, 256},
{56, 0, 61, 0, 0, 0, 33024},
{51, 0, 71, 0, 0, 0, 256},
{58, 0, 69, 0, 0, 0, 33024},
{55, 0, 54, 0, 0, 0, 33024},
{54, 0, 0, 0, 0, 0, 3584},
{54, 0, 0, 0, 0, 0, 256},
{13, 0, 0, 0, 0, 0, 768},
{55, 0, 24, 0, 0, 0, 3840},
{54, 0, 0, 0, 0, 0, 3840},
{54, 0, 24, 0, 0, 0, 3840},
{54, 26, 24, 0, 0, 0, 3840},
{59, 0, 0, 0, 0, 0, 256},
{55, 0, 54, 0, 0, 0, 3072},
{60, 83, 52, 0, 0, 0, 3328},
{60, 83, 52, 0, 0, 0, 3072},
{34, 87, 30, 0, 0, 0, 1280},
{34, 87, 30, 0, 0, 0, 1536},
{34, 85, 30, 0, 0, 0, 1280},
{34, 86, 30, 0, 0, 0, 1536},
{61, 91, 36, 0, 0, 0, 4096},
{62, 34, 30, 0, 0, 0, 4096},
{63, 55, 30, 0, 0, 0, 4096},
{63, 57, 30, 0, 0, 0, 4096},
{34, 30, 87, 0, 0, 0, 1280},
{34, 30, 87, 0, 0, 0, 1536},
{34, 30, 85, 0, 0, 0, 1280},
{34, 30, 86, 0, 0, 0, 1536},
{61, 36, 91, 0, 0, 0, 4096},
{63, 30, 55, 0, 0, 0, 4096},
{63, 30, 57, 0, 0, 0, 4096},
{64, 86, 30, 0, 0, 0, 1280},
{34, 57, 30, 0, 0, 0, 1536},
{34, 86, 30, 0, 0, 0, 1792},
{65, 34, 30, 0, 0, 0, 4096},
{66, 34, 30, 0, 0, 0, 4096},
{61, 90, 36, 0, 0, 0, 4096},
{34, 30, 57, 0, 0, 0, 1280},
{34, 30, 57, 0, 0, 0, 1536},
{61, 30, 57, 0, 0, 0, 4096},
{67, 87, 30, 0, 0, 0, 1280},
{67, 87, 30, 0, 0, 0, 1536},
{66, 40, 36, 0, 0, 0, 4096},
{34, 87, 30, 0, 0, 0, 1792},
{55, 0, 54, 0, 0, 0, 1280},
{67, 83, 30, 0, 0, 0, 1280},
{67, 83, 30, 0, 0, 0, 1536},
{41, 76, 30, 0, 0, 0, 1280},
{41, 76, 30, 0, 0, 0, 1536},
{34, 30, 59, 0, 0, 0, 1280},
{34, 30, 59, 0, 0, 0, 1536},
{34, 30, 55, 0, 0, 0, 2816},
{34, 30, 57, 0, 0, 0, 2816},
{61, 36, 67, 0, 0, 0, 4096},
{67, 86, 52, 0, 0, 0, 1280},
{67, 87, 52, 0, 0, 0, 1536},
{41, 85, 10, 0, 0, 0, 1280},
{41, 86, 10, 0, 0, 0, 1536},
{61, 88, 33, 0, 0, 0, 4096},
{67, 85, 30, 69, 0, 0, 1280},
{67, 86, 30, 0, 0, 0, 1536},
{61, 85, 30, 0, 0, 0, 4096},
{61, 86, 30, 0, 0, 0, 4096},
{68, 31, 9, 0, 0, 0, 1280},
{68, 31, 9, 0, 0, 0, 1536},
{69, 36, 10, 0, 0, 0, 4096},
{67, 85, 30, 0, 0, 0, 1280},
{67, 85, 30, 0, 0, 0, 1536},
{61, 92, 36, 0, 0, 0, 4096},
{61, 91, 30, 0, 0, 0, 4096},
{67, 82, 52, 0, 0, 0, 1024},
{67, 83, 52, 0, 0, 0, 1024},
{70, 76, 52, 0, 0, 0, 1024},
{70, 76, 30, 0, 0, 0, 1536},
{61, 73, 30, 0, 0, 0, 4096},
{34, 83, 52, 0, 0, 0, 1024},
{71, 83, 52, 0, 0, 0, 1280},
{71, 87, 30, 0, 0, 0, 1536},
{66, 87, 30, 0, 0, 0, 4096},
{32, 0, 0, 0, 0, 0, 1024},
{72, 0, 0, 0, 0, 0, 4096},
{73, 10, 76, 0, 0, 0, 3584},
{74, 48, 31, 0, 0, 0, 2816},
{75, 31, 30, 0, 0, 0, 2816},
{73, 76, 10, 0, 0, 0, 3584},
{67, 31, 30, 0, 0, 0, 2816},
{76, 31, 30, 0, 0, 0, 2816},
{32, 86, 30, 0, 0, 0, 3584},
{32, 30, 86, 0, 0, 0, 3584},
{67, 87, 30, 0, 0, 0, 1792},
{70, 52, 76, 0, 0, 0, 1024},
{70, 30, 76, 0, 0, 0, 1536},
{61, 30, 73, 0, 0, 0, 4096},
{34, 52, 83, 0, 0, 0, 1024},
{77, 0, 54, 0, 0, 0, 256},
{78, 0, 62, 0, 0, 0, 256},
{79, 0, 62, 0, 0, 0, 256},
{80, 72, 8, 64, 0, 0, 2560},
{81, 1, 72, 1, 0, 244, 256},
{48, 1, 72, 1, 0, 244, 256},
{67, 72, 8, 64, 0, 245, 256},
{82, 72, 8, 0, 0, 0, 3584},
{83, 72, 8, 65, 0, 180, 256},
{84, 87, 30, 0, 0, 0, 1280},
{84, 87, 30, 0, 0, 0, 1536},
{84, 85, 30, 0, 0, 0, 1280},
{84, 86, 30, 0, 0, 0, 1536},
{85, 40, 36, 0, 0, 0, 4096},
{85, 34, 30, 0, 0, 0, 4096},
{71, 79, 52, 0, 0, 0, 1280},
{71, 79, 30, 0, 0, 0, 1536},
{86, 34, 30, 0, 0, 0, 4096},
{87, 53, 9, 0, 0, 0, 1280},
{71, 31, 9, 0, 0, 0, 1536},
{88, 30, 10, 0, 0, 0, 4096},
{71, 87, 30, 0, 0, 0, 1280},
{86, 40, 36, 0, 0, 0, 4096},
{89, 0, 58, 64, 0, 0, 256},
{55, 0, 57, 0, 0, 0, 3584},
{68, 53, 30, 0, 0, 0, 1536},
{68, 31, 52, 0, 0, 0, 1536},
{61, 30, 86, 0, 0, 0, 4096},
{76, 53, 9, 0, 0, 0, 1280},
{76, 31, 9, 0, 0, 0, 1536},
{69, 30, 10, 0, 0, 0, 4096},
{67, 83, 52, 0, 0, 0, 1280},
{34, 52, 57, 0, 0, 0, 1280},
{67, 54, 30, 0, 0, 0, 1792},
{61, 67, 36, 0, 0, 0, 4096},
{67, 83, 52, 0, 0, 0, 1536},
{76, 53, 52, 0, 0, 0, 1280},
{76, 31, 30, 0, 0, 0, 1536},
{90, 31, 30, 0, 0, 0, 4096},
{50, 0, 54, 0, 0, 0, 512},
{91, 0, 54, 0, 0, 0, 512},
{91, 0, 63, 0, 0, 0, 512},
{92, 0, 0, 0, 0, 0, 512},
{93, 0, 12, 0, 0, 0, 512},
{94, 0, 12, 0, 0, 0, 512},
{67, 83, 52, 0, 0, 0, 2048},
{67, 87, 30, 0, 0, 0, 2048},
{71, 87, 30, 0, 0, 0, 2304},
{67, 87, 30, 0, 0, 0, 2560},
{61, 55, 36, 0, 0, 0, 4096},
{61, 57, 38, 0, 0, 0, 4096},
{61, 59, 38, 0, 0, 0, 4096},
{61, 87, 30, 0, 0, 0, 4096},
{67, 86, 30, 0, 0, 0, 2304},
{67, 85, 30, 0, 0, 0, 2304},
{67, 84, 30, 0, 0, 0, 2304},
{61, 84, 30, 0, 0, 0, 4096},
{67, 87, 30, 0, 0, 0, 2304},
{34, 59, 30, 0, 0, 0, 2304},
{61, 59, 30, 0, 0, 0, 4096},
{66, 40, 67, 0, 0, 0, 4096},
{73, 59, 10, 0, 0, 0, 3584},
{66, 40, 36, 0, 0, 0, 4352},
{66, 34, 30, 0, 0, 0, 4352},
{67, 87, 30, 0, 0, 0, 4864},
{61, 87, 30, 0, 0, 0, 4864},
{66, 34, 30, 0, 0, 0, 4864},
{34, 72, 8, 0, 0, 0, 256},
{34, 68, 10, 0, 0, 0, 2560},
{34, 8, 72, 0, 0, 0, 256},
{34, 72, 10, 0, 0, 0, 2560},
{66, 91, 36, 0, 0, 0, 4096},
{86, 39, 38, 0, 0, 0, 4096},
{71, 85, 30, 0, 0, 0, 2304},
{71, 86, 30, 0, 0, 0, 2304},
{71, 83, 52, 0, 0, 0, 2048},
{71, 87, 30, 0, 0, 0, 2048},
{71, 30, 74, 0, 0, 0, 2304},
{88, 30, 80, 0, 0, 0, 4096},
{71, 30, 75, 0, 0, 0, 2304},
{88, 30, 81, 0, 0, 0, 4096},
{95, 30, 76, 0, 0, 0, 2304},
{66, 30, 73, 0, 0, 0, 4096},
{71, 30, 76, 0, 0, 0, 2304},
{66, 30, 70, 0, 0, 0, 4096},
{66, 38, 87, 0, 0, 0, 4096},
{71, 78, 30, 0, 0, 0, 2304},
{95, 76, 30, 0, 0, 0, 2304},
{71, 87, 30, 0, 0, 0, 4608},
{86, 34, 30, 0, 0, 0, 4608},
{71, 87, 30, 0, 0, 0, 2560},
{71, 87, 30, 0, 0, 0, 4864},
{66, 87, 30, 0, 0, 0, 4864},
{96, 1, 53, 0, 0, 0, 1024},
{55, 1, 31, 0, 0, 0, 1536},
{97, 31, 34, 0, 0, 0, 4096},
{98, 0, 10, 0, 0, 0, 3584},
{55, 0, 55, 0, 0, 0, 256},
{63, 0, 55, 0, 0, 0, 4096},
{55, 0, 54, 0, 0, 0, 3584},
{99, 70, 10, 0, 0, 0, 256},
{98, 0, 72, 0, 0, 0, 256},
{100, 83, 52, 0, 0, 0, 3072}
};

uint16_t CmpMnemonicOffsets[8] = {
0, 9, 18, 27, 39, 49, 59, 69
};
uint16_t VCmpMnemonicOffsets[32] = {
0, 10, 20, 30, 43, 54, 65, 76, 87, 100, 111, 122, 135, 149, 159, 169, 181, 194, 207, 220, 235, 249, 263, 277, 290, 303, 317, 331, 347, 361, 374, 387
};