/*

Copyright (c) 2007 Carl Byington - 510 Software Group, released under
the GPL version 3 or any later version at your choice available at
http://www.gnu.org/licenses/gpl-3.0.txt

*/

#ifndef dnsbl_include
#define dnsbl_include

#include "context.h"
#include "spamass.h"
#include "dccifd.h"
#include <stdint.h>

extern int debug_syslog;
#define dccbulk 1000

class recorder;
class url_scanner;

////////////////////////////////////////////////
// mail filter private data, held for us by sendmail
//
struct mlfiPriv
{
    // callback specific data
    SMFICTX *ctx;                           // updated everytime we fetch this priv pointer from the ctx
    bool    eom;                            // are we in eom function, so progress function can be called?
    // connection specific data
    CONFIG  *pc;                            // global filtering configuration
    int     fd;                             // to talk to dns resolver process
    bool    err;                            // did we get any errors on the resolver socket?
    uint32_t ip;                            // ip4 address of the smtp client in network order
    const char      *helo;                  // helo from client
    map<DNSBLP, bool> checked_black;        // map of dnsblp to result of (ip listed on that dnsbl)
    map<DNSWLP, bool> checked_white;        // map of dnswlp to result of (ip listed on that dnswl)
    // message specific data
    const char      *mailaddr;              // envelope from value
    const char      *queueid;               // sendmail queue id
    const char      *authenticated;         // client authenticated? if so, suppress all dnsbl checks, but check rate limits
    const char      *client_name;           // fully qualified host name of the smtp client xxx [ip.ad.dr.es] (may be forged)
          char      *client_dns_name;       // fully qualified host name of the smtp client xxx
    bool            client_dns_forged;      // rdns mismatch
    const char      *host_uribl;            // pointer to helo/client/from host name if found on uribl
    string_set      hosts_uribl;            // string set to hold the helo/client/from host name if found on uribl
    bool            helo_uribl;             // helo value on uribl
    bool            client_uribl;           // client_name on uribl
    bool            from_uribl;             // envelope from value on uribl
    bool            have_whites;            // have at least one whitelisted recipient? need to accept content and remove all non-whitelisted recipients if it fails
    bool            only_whites;            // every recipient is whitelisted?
    bool            want_spamassassin;      // at least one non-whitelisted recipient has a non zero spamassassin limit
    bool            want_dccgrey;           // at least one non-whitelisted recipient wants dcc greylisting
    bool            want_dccbulk;           // at least one non-whitelisted recipient wants dcc bulk filtering
    bool            allow_autowhitelisting; // precedence:bulk or content-type:multipart/report headers prevent autowhitelisting
    delay_whitelist delayer;                // to remember autowhitelisting until we see headers
    CONTEXT         *content_context;       // first non-whitelisted recipient with a content filtering context
    context_map     env_to;                 // map each non-whitelisted recipient to their filtering context
    recorder        *memory;                // memory for the content scanner
    url_scanner     *scanner;               // object to handle body scanning
    const char      *content_suffix;        // for url body filtering based on ip addresses of hostnames in the body
    const char      *content_message;       // ""
    const char      *uribl_suffix;          // for uribl body filtering based on hostnames in the body
    const char      *uribl_message;         // ""
    string_set      *content_host_ignore;   // ""
    SpamAssassin    *assassin;
    DccInterface    *dccifd;


    mlfiPriv();
    ~mlfiPriv();
    void reset(bool final = false); // for a new message
    void get_fd();
    void return_fd();
    size_t my_read(char *buf, size_t len);
    size_t my_write(const char *buf, size_t len);
    void need_content_filter(const char *rcpt, CONTEXT &con);
};

void my_syslog(mlfiPriv *priv, const char *text);
void my_syslog(mlfiPriv *priv, const string text);
void my_syslog(const char *text);

#endif
