/*

Copyright (c) 2007 Carl Byington - 510 Software Group, released under
the GPL version 3 or any later version at your choice available at
http://www.gnu.org/licenses/gpl-3.0.txt

*/

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "includes.h"

////////////////////////////////////////////////
// finite state machine
//
enum state {// host name recognizer states
            h_init,
            h_host,

            // html tag discarder states
            t_init,
            t_tag1,     // seen opening <
            t_tag2,     // not comment
            t_com1,     // seen !
            t_com2,     // seen first -
            t_com3,     // seen second -, looking for -->
            t_com4,     // seen first -
            t_com5,     // seen second -
            t_disc,     // looking for closing >

            // url recognizer states
            u_init,
            u_http,
            u_sla,
            u_url,

            // url decoder states  %xx
            d_init,
            d_pcnt,
            d_1,

            // html entity decoder states &#nnn;
            e_init,
            e_amp,
            e_num,

            // mime decoder states =xx
            m_init,
            m_eq,
            m_1,

            // base64 decoder states
            b_init,
            b_lf,
            b_lf2,
            b_64,

            // uuencoding decoder states
            uu_init,
            uu_lf,
            uu_lf2,
            uu_64,

            // counter for number of columns in the table
            end_state,

            // temporary states
            h_end,
            t_bin,
            t_end,
            u_reco,
            d_2,
            e_semi,
            m_2,
            m_cr,
            m_nl,
            b_cr,
            uu_cr
           };

static const char* state_names[] = {"h_init",
                                    "h_host",
                                    "t_init",
                                    "t_tag1",
                                    "t_tag2",
                                    "t_com1",
                                    "t_com2",
                                    "t_com3",
                                    "t_com4",
                                    "t_com5",
                                    "t_disc",
                                    "u_init",
                                    "u_http",
                                    "u_sla",
                                    "u_url",
                                    "d_init",
                                    "d_pcnt",
                                    "d_1",
                                    "e_init",
                                    "e_amp",
                                    "e_num",
                                    "m_init",
                                    "m_eq",
                                    "m_1",
                                    "b_init",
                                    "b_lf",
                                    "b_lf2",
                                    "b_64",
                                    "uu_init",
                                    "uu_lf",
                                    "uu_lf2",
                                    "uu_64",
                                    "end_state",
                                    "h_end",
                                    "t_bin",
                                    "t_end",
                                    "u_reco",
                                    "d_2",
                                    "e_semi",
                                    "m_2",
                                    "m_cr",
                                    "m_nl",
                                    "b_cr",
                                    "uu_cr"};

#define PENDING_LIMIT 100
class fsa {
    const char  *myname;
    u_char      pending[PENDING_LIMIT];
    int         count;
    state       st;
    state       init;
    fsa         *next1;
    fsa         *next2;
    recorder    *memory;

public:
    fsa(const char *myname_, state init, fsa *next1_, fsa *next2_, recorder *memory_);
    void push(u_char *buf, int len);
    void pusher();
    void validhost();
    void error(const char *err);
};


typedef state PARSE[end_state];

static PARSE parse_table[256] = {
  // h_init, h_host, t_init, t_tag1, t_tag2, t_com1, t_com2, t_com3, t_com4, t_com5, t_disc, u_init, u_http, u_sla , u_url,  d_init, d_pcnt, d_1,    e_init, e_amp,  e_num,  m_init, m_eq,   m_1,    b_init, b_lf,   b_lf2,  b_64    uu_init, uu_lf,   uu_lf2,  uu_64

    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x00
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x01
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x02
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x03
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x04
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x05
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x06
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x07
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x08
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com5, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x09 <tab>
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com5, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_nl,   m_init, b_lf,   b_init, b_lf2,  b_init, uu_lf,   uu_init, uu_lf2,  uu_init,  },  // 0x0a <lf>
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x0b
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x0c
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com5, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_cr,   m_init, b_init, b_init, b_init, b_cr,   uu_init, uu_init, uu_init, uu_cr,    },  // 0x0d <cr>
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x0e
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x0f
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x10
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x11 xon char
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x12
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x13 xoff char
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x14
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x15
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x16
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x17
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x18
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x19
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x1a
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x1b
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x1c
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x1d
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x1e
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x1f
    {h_init, h_end,  t_init, t_end,  t_end,  t_end,  t_end,  t_com3, t_com3, t_com5, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x20 space
    {h_init, h_end,  t_init, t_com1, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x21 !
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x22 ""
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_num,  e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x23 #
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x24 $
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_pcnt, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x25 %
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_amp,  e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x26 &
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x27 '
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x28 (
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x29 )
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x2A *
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x2B +
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x2C ,
    {h_host, h_host, t_init, t_disc, t_disc, t_com2, t_com3, t_com4, t_com5, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x2D -
    {h_host, h_host, t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x2E .
    {h_init, h_end,  t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_sla,  u_sla,  u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x2F /
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x30 0
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x31 1
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x32 2
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x33 3
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x34 4
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x35 5
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x36 6
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x37 7
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x38 8
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x39 9
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x3A :
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_semi, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x3B ;
    {h_init, h_end,  t_tag1, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x3C <
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_eq,   m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x3D =
    {h_init, h_end,  t_init, t_end,  t_end,  t_end,  t_end,  t_com3, t_com3, t_end,  t_end,  u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x3E >
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x3F ?
    {h_init, h_host, t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x40 @
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x41 A
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x42 B
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x43 C
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x44 D
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x45 E
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x46 F
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x47 G
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x48 H
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x49 I
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x4A J
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x4B K
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x4C L
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x4D M
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x4E N
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x4F O
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x50 P
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x51 Q
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x52 R
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x53 S
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x54 T
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x55 U
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x56 V
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x57 W
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_num,  m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x58 X
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x59 Y
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_64,   uu_64,   uu_64,    },  // 0x5A Z
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x5B [
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x5C backslash
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x5D ]
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x5E ^
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x5F _
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_64,   uu_64,   uu_64,    },  // 0x60 `
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x61 a
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x62 b
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x63 c
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x64 d
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x65 e
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_1,    d_2,    e_init, e_init, e_num,  m_init, m_1,    m_2,    b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x66 f
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x67 g
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x68 h
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x69 i
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x6A j
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x6B k
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x6C l
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x6D m
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x6E n
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x6F o
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x70 p
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x71 q
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x72 r
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x73 s
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_http, u_http, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x74 t
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x75 u
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x76 v
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x77 w
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_num,  m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x78 x
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x79 y
    {h_host, h_host, t_init, t_tag2, t_tag2, t_tag2, t_tag2, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_url,  u_url,  d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_64,   b_64,   b_64,   uu_init, uu_init, uu_init, uu_init,  },  // 0x7A z
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x7B {
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x7C |
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x7D }
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x7E ~
    {h_init, h_end,  t_init, t_disc, t_disc, t_disc, t_disc, t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x7f
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x80
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x81
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x82
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x83
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x84
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x85
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x86
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x87
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x88
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x89
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x8a
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x8b
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x8c
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x8d
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x8e
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x8f
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x90
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x91
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x92
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x93
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x94
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x95
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x96
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x97
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x98
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x99
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x9a
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x9b
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x9c
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x9d
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x9e
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0x9f
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa0
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa1
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa2
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa3
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa4
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa5
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa6
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa7
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa8
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xa9
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xaa
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xab
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xac
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xad
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xae
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xaf
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb0
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb1
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb2
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb3
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb4
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb5
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb6
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb7
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb8
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xb9
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xba
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xbb
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xbc
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xbd
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xbe
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xbf
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc0
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc1
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc2
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc3
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc4
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc5
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc6
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc7
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc8
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xc9
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xca
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xcb
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xcc
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xcd
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xce
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xcf
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd0
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd1
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd2
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd3
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd4
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd5
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd6
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd7
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd8
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xd9
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xda
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xdb
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xdc
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xdd
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xde
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xdf
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe0
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe1
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe2
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe3
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe4
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe5
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe6
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe7
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe8
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xe9
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xea
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xeb
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xec
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xed
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xee
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xef
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf0
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf1
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf2
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf3
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf4
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf5
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf6
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf7
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf8
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xf9
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xfa
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xfb
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xfc
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xfd
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xfe
    {h_init, h_end,  t_init, t_bin,  t_bin,  t_bin,  t_bin,  t_com3, t_com3, t_com3, t_disc, u_init, u_init, u_init, u_reco, d_init, d_init, d_init, e_init, e_init, e_init, m_init, m_init, m_init, b_init, b_init, b_init, b_init, uu_init, uu_init, uu_init, uu_init,  },  // 0xff
};


u_char hex_decode[256] = {
    0,  // 0x00
    0,  // 0x01
    0,  // 0x02
    0,  // 0x03
    0,  // 0x04
    0,  // 0x05
    0,  // 0x06
    0,  // 0x07
    0,  // 0x08
    0,  // 0x09 <tab>
    0,  // 0x0a <lf>
    0,  // 0x0b
    0,  // 0x0c
    0,  // 0x0d <cr>
    0,  // 0x0e
    0,  // 0x0f
    0,  // 0x10
    0,  // 0x11 xon char
    0,  // 0x12
    0,  // 0x13 xoff char
    0,  // 0x14
    0,  // 0x15
    0,  // 0x16
    0,  // 0x17
    0,  // 0x18
    0,  // 0x19
    0,  // 0x1a
    0,  // 0x1b
    0,  // 0x1c
    0,  // 0x1d
    0,  // 0x1e
    0,  // 0x1f
    0,  // 0x20 space
    0,  // 0x21 !
    0,  // 0x22 ""
    0,  // 0x23 #
    0,  // 0x24 $
    0,  // 0x25 %
    0,  // 0x26 &
    0,  // 0x27 '
    0,  // 0x28 (
    0,  // 0x29 )
    0,  // 0x2A *
    0,  // 0x2B +
    0,  // 0x2C ,
    0,  // 0x2D -
    0,  // 0x2E .
    0,  // 0x2F /
    0,  // 0x30 0
    1,  // 0x31 1
    2,  // 0x32 2
    3,  // 0x33 3
    4,  // 0x34 4
    5,  // 0x35 5
    6,  // 0x36 6
    7,  // 0x37 7
    8,  // 0x38 8
    9,  // 0x39 9
    0,  // 0x3A :
    0,  // 0x3B ;
    0,  // 0x3C <
    0,  // 0x3D =
    0,  // 0x3E >
    0,  // 0x3F ?
    0,  // 0x40 @
    10, // 0x41 A
    11, // 0x42 B
    12, // 0x43 C
    13, // 0x44 D
    14, // 0x45 E
    15, // 0x46 F
    0,  // 0x47 G
    0,  // 0x48 H
    0,  // 0x49 I
    0,  // 0x4A J
    0,  // 0x4B K
    0,  // 0x4C L
    0,  // 0x4D M
    0,  // 0x4E N
    0,  // 0x4F O
    0,  // 0x50 P
    0,  // 0x51 Q
    0,  // 0x52 R
    0,  // 0x53 S
    0,  // 0x54 T
    0,  // 0x55 U
    0,  // 0x56 V
    0,  // 0x57 W
    0,  // 0x58 X
    0,  // 0x59 Y
    0,  // 0x5A Z
    0,  // 0x5B [
    0,  // 0x5C backslash
    0,  // 0x5D ]
    0,  // 0x5E ^
    0,  // 0x5F _
    0,  // 0x60 `
    10, // 0x61 a
    11, // 0x62 b
    12, // 0x63 c
    13, // 0x64 d
    14, // 0x65 e
    15, // 0x66 f
    0,  // 0x67 g
    0,  // 0x68 h
    0,  // 0x69 i
    0,  // 0x6A j
    0,  // 0x6B k
    0,  // 0x6C l
    0,  // 0x6D m
    0,  // 0x6E n
    0,  // 0x6F o
    0,  // 0x70 p
    0,  // 0x71 q
    0,  // 0x72 r
    0,  // 0x73 s
    0,  // 0x74 t
    0,  // 0x75 u
    0,  // 0x76 v
    0,  // 0x77 w
    0,  // 0x78 x
    0,  // 0x79 y
    0,  // 0x7A z
    0,  // 0x7B {
    0,  // 0x7C |
    0,  // 0x7D }
    0,  // 0x7E ~
    0,  // 0x7f
    0,  // 0x80
    0,  // 0x81
    0,  // 0x82
    0,  // 0x83
    0,  // 0x84
    0,  // 0x85
    0,  // 0x86
    0,  // 0x87
    0,  // 0x88
    0,  // 0x89
    0,  // 0x8a
    0,  // 0x8b
    0,  // 0x8c
    0,  // 0x8d
    0,  // 0x8e
    0,  // 0x8f
    0,  // 0x90
    0,  // 0x91
    0,  // 0x92
    0,  // 0x93
    0,  // 0x94
    0,  // 0x95
    0,  // 0x96
    0,  // 0x97
    0,  // 0x98
    0,  // 0x99
    0,  // 0x9a
    0,  // 0x9b
    0,  // 0x9c
    0,  // 0x9d
    0,  // 0x9e
    0,  // 0x9f
    0,  // 0xa0
    0,  // 0xa1
    0,  // 0xa2
    0,  // 0xa3
    0,  // 0xa4
    0,  // 0xa5
    0,  // 0xa6
    0,  // 0xa7
    0,  // 0xa8
    0,  // 0xa9
    0,  // 0xaa
    0,  // 0xab
    0,  // 0xac
    0,  // 0xad
    0,  // 0xae
    0,  // 0xaf
    0,  // 0xb0
    0,  // 0xb1
    0,  // 0xb2
    0,  // 0xb3
    0,  // 0xb4
    0,  // 0xb5
    0,  // 0xb6
    0,  // 0xb7
    0,  // 0xb8
    0,  // 0xb9
    0,  // 0xba
    0,  // 0xbb
    0,  // 0xbc
    0,  // 0xbd
    0,  // 0xbe
    0,  // 0xbf
    0,  // 0xc0
    0,  // 0xc1
    0,  // 0xc2
    0,  // 0xc3
    0,  // 0xc4
    0,  // 0xc5
    0,  // 0xc6
    0,  // 0xc7
    0,  // 0xc8
    0,  // 0xc9
    0,  // 0xca
    0,  // 0xcb
    0,  // 0xcc
    0,  // 0xcd
    0,  // 0xce
    0,  // 0xcf
    0,  // 0xd0
    0,  // 0xd1
    0,  // 0xd2
    0,  // 0xd3
    0,  // 0xd4
    0,  // 0xd5
    0,  // 0xd6
    0,  // 0xd7
    0,  // 0xd8
    0,  // 0xd9
    0,  // 0xda
    0,  // 0xdb
    0,  // 0xdc
    0,  // 0xdd
    0,  // 0xde
    0,  // 0xdf
    0,  // 0xe0
    0,  // 0xe1
    0,  // 0xe2
    0,  // 0xe3
    0,  // 0xe4
    0,  // 0xe5
    0,  // 0xe6
    0,  // 0xe7
    0,  // 0xe8
    0,  // 0xe9
    0,  // 0xea
    0,  // 0xeb
    0,  // 0xec
    0,  // 0xed
    0,  // 0xee
    0,  // 0xef
    0,  // 0xf0
    0,  // 0xf1
    0,  // 0xf2
    0,  // 0xf3
    0,  // 0xf4
    0,  // 0xf5
    0,  // 0xf6
    0,  // 0xf7
    0,  // 0xf8
    0,  // 0xf9
    0,  // 0xfa
    0,  // 0xfb
    0,  // 0xfc
    0,  // 0xfd
    0,  // 0xfe
    0,  // 0xff
};

u_char b64_decode[256] = {
    0,  // 0x00
    0,  // 0x01
    0,  // 0x02
    0,  // 0x03
    0,  // 0x04
    0,  // 0x05
    0,  // 0x06
    0,  // 0x07
    0,  // 0x08
    0,  // 0x09 <tab>
    0,  // 0x0a <lf>
    0,  // 0x0b
    0,  // 0x0c
    0,  // 0x0d <cr>
    0,  // 0x0e
    0,  // 0x0f
    0,  // 0x10
    0,  // 0x11 xon char
    0,  // 0x12
    0,  // 0x13 xoff char
    0,  // 0x14
    0,  // 0x15
    0,  // 0x16
    0,  // 0x17
    0,  // 0x18
    0,  // 0x19
    0,  // 0x1a
    0,  // 0x1b
    0,  // 0x1c
    0,  // 0x1d
    0,  // 0x1e
    0,  // 0x1f
    0,  // 0x20 space
    0,  // 0x21 !
    0,  // 0x22 "
    0,  // 0x23 #
    0,  // 0x24 $
    0,  // 0x25 %
    0,  // 0x26 &
    0,  // 0x27 '
    0,  // 0x28 (
    0,  // 0x29 )
    0,  // 0x2A *
    62, // 0x2B +
    0,  // 0x2C ,
    0,  // 0x2D -
    0,  // 0x2E .
    63, // 0x2F /
    52, // 0x30 0
    53, // 0x31 1
    54, // 0x32 2
    55, // 0x33 3
    56, // 0x34 4
    57, // 0x35 5
    58, // 0x36 6
    59, // 0x37 7
    60, // 0x38 8
    61, // 0x39 9
    0,  // 0x3A :
    0,  // 0x3B ;
    0,  // 0x3C <
    0,  // 0x3D =
    0,  // 0x3E >
    0,  // 0x3F ?
    0,  // 0x40 @
    0,  // 0x41 A
    1,  // 0x42 B
    2,  // 0x43 C
    3,  // 0x44 D
    4,  // 0x45 E
    5,  // 0x46 F
    6,  // 0x47 G
    7,  // 0x48 H
    8,  // 0x49 I
    9,  // 0x4A J
    10, // 0x4B K
    11, // 0x4C L
    12, // 0x4D M
    13, // 0x4E N
    14, // 0x4F O
    15, // 0x50 P
    16, // 0x51 Q
    17, // 0x52 R
    18, // 0x53 S
    19, // 0x54 T
    20, // 0x55 U
    21, // 0x56 V
    22, // 0x57 W
    23, // 0x58 X
    24, // 0x59 Y
    25, // 0x5A Z
    0,  // 0x5B [
    0,  // 0x5C backslash
    0,  // 0x5D ]
    0,  // 0x5E ^
    0,  // 0x5F _
    0,  // 0x60 `
    26, // 0x61 a
    27, // 0x62 b
    28, // 0x63 c
    29, // 0x64 d
    30, // 0x65 e
    31, // 0x66 f
    32, // 0x67 g
    33, // 0x68 h
    34, // 0x69 i
    35, // 0x6A j
    36, // 0x6B k
    37, // 0x6C l
    38, // 0x6D m
    39, // 0x6E n
    40, // 0x6F o
    41, // 0x70 p
    42, // 0x71 q
    43, // 0x72 r
    44, // 0x73 s
    45, // 0x74 t
    46, // 0x75 u
    47, // 0x76 v
    48, // 0x77 w
    49, // 0x78 x
    50, // 0x79 y
    51, // 0x7A z
    0,  // 0x7B {
    0,  // 0x7C |
    0,  // 0x7D }
    0,  // 0x7E ~
    0,  // 0x7f
    0,  // 0x80
    0,  // 0x81
    0,  // 0x82
    0,  // 0x83
    0,  // 0x84
    0,  // 0x85
    0,  // 0x86
    0,  // 0x87
    0,  // 0x88
    0,  // 0x89
    0,  // 0x8a
    0,  // 0x8b
    0,  // 0x8c
    0,  // 0x8d
    0,  // 0x8e
    0,  // 0x8f
    0,  // 0x90
    0,  // 0x91
    0,  // 0x92
    0,  // 0x93
    0,  // 0x94
    0,  // 0x95
    0,  // 0x96
    0,  // 0x97
    0,  // 0x98
    0,  // 0x99
    0,  // 0x9a
    0,  // 0x9b
    0,  // 0x9c
    0,  // 0x9d
    0,  // 0x9e
    0,  // 0x9f
    0,  // 0xa0
    0,  // 0xa1
    0,  // 0xa2
    0,  // 0xa3
    0,  // 0xa4
    0,  // 0xa5
    0,  // 0xa6
    0,  // 0xa7
    0,  // 0xa8
    0,  // 0xa9
    0,  // 0xaa
    0,  // 0xab
    0,  // 0xac
    0,  // 0xad
    0,  // 0xae
    0,  // 0xaf
    0,  // 0xb0
    0,  // 0xb1
    0,  // 0xb2
    0,  // 0xb3
    0,  // 0xb4
    0,  // 0xb5
    0,  // 0xb6
    0,  // 0xb7
    0,  // 0xb8
    0,  // 0xb9
    0,  // 0xba
    0,  // 0xbb
    0,  // 0xbc
    0,  // 0xbd
    0,  // 0xbe
    0,  // 0xbf
    0,  // 0xc0
    0,  // 0xc1
    0,  // 0xc2
    0,  // 0xc3
    0,  // 0xc4
    0,  // 0xc5
    0,  // 0xc6
    0,  // 0xc7
    0,  // 0xc8
    0,  // 0xc9
    0,  // 0xca
    0,  // 0xcb
    0,  // 0xcc
    0,  // 0xcd
    0,  // 0xce
    0,  // 0xcf
    0,  // 0xd0
    0,  // 0xd1
    0,  // 0xd2
    0,  // 0xd3
    0,  // 0xd4
    0,  // 0xd5
    0,  // 0xd6
    0,  // 0xd7
    0,  // 0xd8
    0,  // 0xd9
    0,  // 0xda
    0,  // 0xdb
    0,  // 0xdc
    0,  // 0xdd
    0,  // 0xde
    0,  // 0xdf
    0,  // 0xe0
    0,  // 0xe1
    0,  // 0xe2
    0,  // 0xe3
    0,  // 0xe4
    0,  // 0xe5
    0,  // 0xe6
    0,  // 0xe7
    0,  // 0xe8
    0,  // 0xe9
    0,  // 0xea
    0,  // 0xeb
    0,  // 0xec
    0,  // 0xed
    0,  // 0xee
    0,  // 0xef
    0,  // 0xf0
    0,  // 0xf1
    0,  // 0xf2
    0,  // 0xf3
    0,  // 0xf4
    0,  // 0xf5
    0,  // 0xf6
    0,  // 0xf7
    0,  // 0xf8
    0,  // 0xf9
    0,  // 0xfa
    0,  // 0xfb
    0,  // 0xfc
    0,  // 0xfd
    0,  // 0xfe
    0,  // 0xff
};

u_char uu_decode[256] = {
    0,  // 0x00
    0,  // 0x01
    0,  // 0x02
    0,  // 0x03
    0,  // 0x04
    0,  // 0x05
    0,  // 0x06
    0,  // 0x07
    0,  // 0x08
    0,  // 0x09 <tab>
    0,  // 0x0a <lf>
    0,  // 0x0b
    0,  // 0x0c
    0,  // 0x0d <cr>
    0,  // 0x0e
    0,  // 0x0f
    0,  // 0x10
    0,  // 0x11 xon char
    0,  // 0x12
    0,  // 0x13 xoff char
    0,  // 0x14
    0,  // 0x15
    0,  // 0x16
    0,  // 0x17
    0,  // 0x18
    0,  // 0x19
    0,  // 0x1a
    0,  // 0x1b
    0,  // 0x1c
    0,  // 0x1d
    0,  // 0x1e
    0,  // 0x1f
    0,  // 0x20 space
    1,  // 0x21 !
    2,  // 0x22 "
    3,  // 0x23 #
    4,  // 0x24 $
    5,  // 0x25 %
    6,  // 0x26 &
    7,  // 0x27 '
    8,  // 0x28 (
    9,  // 0x29 )
   10,  // 0x2A *
   11,  // 0x2B +
   12,  // 0x2C ,
   13,  // 0x2D -
   14,  // 0x2E .
   15,  // 0x2F /
   16,  // 0x30 0
   17,  // 0x31 1
   18,  // 0x32 2
   19,  // 0x33 3
   20,  // 0x34 4
   21,  // 0x35 5
   22,  // 0x36 6
   23,  // 0x37 7
   24,  // 0x38 8
   25,  // 0x39 9
   26,  // 0x3A :
   27,  // 0x3B ;
   28,  // 0x3C <
   29,  // 0x3D =
   30,  // 0x3E >
   31,  // 0x3F ?
   32,  // 0x40 @
   33,  // 0x41 A
   34,  // 0x42 B
   35,  // 0x43 C
   36,  // 0x44 D
   37,  // 0x45 E
   38,  // 0x46 F
   39,  // 0x47 G
   40,  // 0x48 H
   41,  // 0x49 I
   42,  // 0x4A J
   43,  // 0x4B K
   44,  // 0x4C L
   45,  // 0x4D M
   46,  // 0x4E N
   47,  // 0x4F O
   48,  // 0x50 P
   49,  // 0x51 Q
   50,  // 0x52 R
   51,  // 0x53 S
   52,  // 0x54 T
   53,  // 0x55 U
   54,  // 0x56 V
   55,  // 0x57 W
   56,  // 0x58 X
   57,  // 0x59 Y
   58,  // 0x5A Z
   59,  // 0x5B [
   60,  // 0x5C backslash
   61,  // 0x5D ]
   62,  // 0x5E ^
   63,  // 0x5F _
    0,  // 0x60 `
    0,  // 0x61 a
    0,  // 0x62 b
    0,  // 0x63 c
    0,  // 0x64 d
    0,  // 0x65 e
    0,  // 0x66 f
    0,  // 0x67 g
    0,  // 0x68 h
    0,  // 0x69 i
    0,  // 0x6A j
    0,  // 0x6B k
    0,  // 0x6C l
    0,  // 0x6D m
    0,  // 0x6E n
    0,  // 0x6F o
    0,  // 0x70 p
    0,  // 0x71 q
    0,  // 0x72 r
    0,  // 0x73 s
    0,  // 0x74 t
    0,  // 0x75 u
    0,  // 0x76 v
    0,  // 0x77 w
    0,  // 0x78 x
    0,  // 0x79 y
    0,  // 0x7A z
    0,  // 0x7B {
    0,  // 0x7C |
    0,  // 0x7D }
    0,  // 0x7E ~
    0,  // 0x7f
    0,  // 0x80
    0,  // 0x81
    0,  // 0x82
    0,  // 0x83
    0,  // 0x84
    0,  // 0x85
    0,  // 0x86
    0,  // 0x87
    0,  // 0x88
    0,  // 0x89
    0,  // 0x8a
    0,  // 0x8b
    0,  // 0x8c
    0,  // 0x8d
    0,  // 0x8e
    0,  // 0x8f
    0,  // 0x90
    0,  // 0x91
    0,  // 0x92
    0,  // 0x93
    0,  // 0x94
    0,  // 0x95
    0,  // 0x96
    0,  // 0x97
    0,  // 0x98
    0,  // 0x99
    0,  // 0x9a
    0,  // 0x9b
    0,  // 0x9c
    0,  // 0x9d
    0,  // 0x9e
    0,  // 0x9f
    0,  // 0xa0
    0,  // 0xa1
    0,  // 0xa2
    0,  // 0xa3
    0,  // 0xa4
    0,  // 0xa5
    0,  // 0xa6
    0,  // 0xa7
    0,  // 0xa8
    0,  // 0xa9
    0,  // 0xaa
    0,  // 0xab
    0,  // 0xac
    0,  // 0xad
    0,  // 0xae
    0,  // 0xaf
    0,  // 0xb0
    0,  // 0xb1
    0,  // 0xb2
    0,  // 0xb3
    0,  // 0xb4
    0,  // 0xb5
    0,  // 0xb6
    0,  // 0xb7
    0,  // 0xb8
    0,  // 0xb9
    0,  // 0xba
    0,  // 0xbb
    0,  // 0xbc
    0,  // 0xbd
    0,  // 0xbe
    0,  // 0xbf
    0,  // 0xc0
    0,  // 0xc1
    0,  // 0xc2
    0,  // 0xc3
    0,  // 0xc4
    0,  // 0xc5
    0,  // 0xc6
    0,  // 0xc7
    0,  // 0xc8
    0,  // 0xc9
    0,  // 0xca
    0,  // 0xcb
    0,  // 0xcc
    0,  // 0xcd
    0,  // 0xce
    0,  // 0xcf
    0,  // 0xd0
    0,  // 0xd1
    0,  // 0xd2
    0,  // 0xd3
    0,  // 0xd4
    0,  // 0xd5
    0,  // 0xd6
    0,  // 0xd7
    0,  // 0xd8
    0,  // 0xd9
    0,  // 0xda
    0,  // 0xdb
    0,  // 0xdc
    0,  // 0xdd
    0,  // 0xde
    0,  // 0xdf
    0,  // 0xe0
    0,  // 0xe1
    0,  // 0xe2
    0,  // 0xe3
    0,  // 0xe4
    0,  // 0xe5
    0,  // 0xe6
    0,  // 0xe7
    0,  // 0xe8
    0,  // 0xe9
    0,  // 0xea
    0,  // 0xeb
    0,  // 0xec
    0,  // 0xed
    0,  // 0xee
    0,  // 0xef
    0,  // 0xf0
    0,  // 0xf1
    0,  // 0xf2
    0,  // 0xf3
    0,  // 0xf4
    0,  // 0xf5
    0,  // 0xf6
    0,  // 0xf7
    0,  // 0xf8
    0,  // 0xf9
    0,  // 0xfa
    0,  // 0xfb
    0,  // 0xfc
    0,  // 0xfd
    0,  // 0xfe
    0,  // 0xff
};


////////////////////////////////////////////////
//
//
recorder::recorder(mlfiPriv *priv_, string_set &html_tags_, string_set &tlds_, string_set &tldwilds_, string_set &tldnots_) {
    priv          = priv_;
    html_tags     = &html_tags_;
    tlds          = &tlds_;
    tldwilds      = &tldwilds_;
    tldnots       = &tldnots_;
    bad_html_tags = 0;
    binary_tags   = 0;
}
void recorder::empty() {
    bad_html_tags = 0;
    binary_tags   = 0;
    discard(hosts);
}
void recorder::new_url(const char *host) {
    register_string(hosts, host);
}
void recorder::binary() {
    binary_tags++;
}
void recorder::new_tag(const char *tag) {
    string_set::iterator i = html_tags->find(tag);
    if (i == html_tags->end()) {
        bad_html_tags++;
        if ((debug_syslog > 2) && (bad_html_tags < 10)) {
            // only log the first 10 bad tags
            char buf[200];
            snprintf(buf, sizeof(buf), "bad html tag %s", tag);
            my_syslog(priv, buf);
        }
    }
}


////////////////////////////////////////////////
//
//
fsa::fsa(const char *myname_, state init_, fsa *next1_, fsa *next2_, recorder *memory_) {
    myname = myname_;
    count  = 0;
    st     = init_;
    init   = init_;
    next1  = next1_;
    next2  = next2_;
    memory = memory_;
}

void fsa::error(const char *err) {
    count = 0;
    st    = init;
    if (err) memory->syslog(err);
}

void fsa::pusher() {
    if (next1) next1->push(pending, count);
    if (next2) next2->push(pending, count);
    count = 0;
}

void fsa::validhost () {
    // remove trailing periods
    while (count && (pending[count-1]== '.')) pending[--count] = '\0';
    if (!count) return; // empty string
    if (!strchr((const char *)pending, '@')) {
        // not an email address or message id
        const char *p1 = strchr((const char *)pending, '.');
        const char *p2 = strrchr((const char *)pending, '.');
        const char *p3 = strstr((const char *)pending, "..");
        size_t n = strlen((const char *)pending);
        if (p1 && (p1 != (char*)pending) && !p3 && (n > 6)) {
            // have a period, so at least two components, and no empty components, and longer than 6 chars
            in_addr ip;
            if (inet_aton((const char*)pending, &ip)) {
                // have an ip address if at least two periods
                if (p1 != p2) memory->new_url((char*)pending);
            }
            else {
                for (int i=0; i<count; i++) pending[i] = tolower(pending[i]);
                // is last component a tld?
                string_set::iterator i = memory->get_tlds()->find(p2+1);
                if (i != memory->get_tlds()->end()) memory->new_url((char*)pending);
                else {
                    i = memory->get_tldwilds()->find(p2+1);
                    if (i != memory->get_tldwilds()->end()) memory->new_url((char*)pending);
                }
            }
        }
    }
}

void fsa::push(u_char *buf, int len) {
    if (debug_syslog > 10) {
        char msg[200], mbuf[200];
        int n = sizeof(mbuf) - 1;
        if (len < n) n = len;
        memcpy(mbuf, buf, n);
        mbuf[n] = '\0';
        snprintf(msg, sizeof(msg), "%s sees %s", myname, mbuf);
        msg[sizeof(msg)-1] = '\0';
        memory->syslog(msg);
    }
    for (int i=0; i<len; i++) {
        if (count == (PENDING_LIMIT-1)) error(NULL);
        if (st >= end_state)            error("finite state machine impossible state");
        u_char c = buf[i];
        pending[count++] = c;
        if (debug_syslog > 10) {
            const char *old1 = state_names[st];
            const char *new1 = state_names[parse_table[c][st]];
            char msg[200];
            snprintf(msg, sizeof(msg), "%s at (%d,%c) switches from %s to %s", myname, i, c, old1, new1);
            memory->syslog(msg);
        }
        st = parse_table[c][st];
        switch (st) {

            //////////////////////////////
            //  host name recognizer
            case h_end: {
                if (count > 5) {
                    // need some minimal length host name
                    //otherwise binary files likely to generate false positives
                    pending[--count] = '\0';  // null terminate host name by overwriting the terminator
                    validhost();
                }
                st = h_init;
                } // fall thru

            case h_init: {
                count = 0;
                } break;


            //////////////////////////////
            //  html tag discarder
            case t_bin: {
                memory->binary();
                st    = t_disc;
                count = 0;  // discard all characters
                } break;

            case t_end: {
                if (count > 1) {
                    pending[--count] = '\0';  // null terminate html tag
                    for (int i=0; i<count; i++) pending[i] = tolower(pending[i]);
                    memory->new_tag((char*)pending);
                }
                st = (c == ' ') ? t_disc : t_init;
                } // fall thru

            case t_tag1:
            case t_com2:
            case t_com3:
            case t_com4:
            case t_com5:
            case t_disc: {
                count = 0;  // discard all characters
                } break;

            case t_init: {
                pusher();
                } break;


            //////////////////////////////
            //  url recognizer
            case u_reco: {
                if (count > 11) {   // need some minimal length host name after the protocol
                    pending[--count] = '\0';  // null terminate host name by overwriting the terminator
                    // must start with protocol
                    if (strncasecmp((const char *)pending, "http", 4) == 0) {
                        const char *p = strrchr((const char *)pending, '/');
                        if (p) {
                            count = strlen(p+1);
                            memmove(pending, p+1, count+1);
                            validhost();
                        }
                    }
                }
                st = u_init;
                } // fall thru

            case u_init: {
                count = 0;  // discard all characters
                } break;


            //////////////////////////////
            //  url decoder %xx
            case d_2: {
                pending[0] = hex_decode[pending[1]] * 16 + hex_decode[pending[2]];
                count = 1;
                st    = d_init;
                } // fall thru

            case d_init: {
                pusher();
                } break;


            //////////////////////////////
            //  html entity decoder &#nnn;  &#xnnn;
            case e_semi: {
                pending[--count] = '\0';  // null terminate the digit string by overwriting the semicolon
                u_char f = pending[2];
                if ((f == 'x') || (f == 'X')) {
                    pending[0] = strtol((const char *)pending+2, (char **)NULL, 16);
                }
                else {
                    pending[0] = atoi((const char *)pending+2);
                }
                count = 1;
                st    = e_init;
                } // fall thru

            case e_init: {
                pusher();
                } break;


            //////////////////////////////
            //  mime decoder =xx
            case m_2: {
                pending[0] = hex_decode[pending[1]] * 16 + hex_decode[pending[2]];
                count = 1;
                st    = m_init;
                } // fall thru

            case m_init: {
                pusher();
                } break;

            case m_cr: {
                count = 1;
                st    = m_eq;
                } break;

            case m_nl: {
                count = 0;
                st    = m_init;
                } break;


            //////////////////////////////
            //  base64 decoder
            case b_lf2: {
                count--;
                } break;

            case b_cr: {
                if ((count % 4) == 1) {     // base64 data with trailing cr
                    count--;                // ignore this cr
                    // might have proper b64 data
                    int cnt = 0;
                    for (int i=0; i<count; i+=4) {
                        unsigned long a1 = b64_decode[pending[i]];
                        unsigned long a2 = b64_decode[pending[i+1]];
                        unsigned long a3 = b64_decode[pending[i+2]];
                        unsigned long a4 = b64_decode[pending[i+3]];
                        unsigned long a = (a1 << 18) | (a2 << 12) | (a3 << 6) | a4;
                        pending[cnt++] = (a & 0x00ff0000) >> 16;
                        pending[cnt++] = (a & 0x0000ff00) >>  8;
                        pending[cnt++] = (a & 0x000000ff);
                        if ((char)pending[i+3] == '=') cnt--;
                        if ((char)pending[i+2] == '=') cnt--;
                    }
                    count = cnt;
                    st    = b_lf2;
                }
                else st = b_init;
                } // fall thru

            case b_lf:
            case b_init: {
                pusher();
                } break;


            //////////////////////////////
            //  uuencoding decoder
            case uu_lf2: {
                count--;
                } break;

            case uu_cr: {
                if ((count % 4) == 2) {     // leading count byte, uuencoded data, trailing cr
                    count--;                // ignore this cr
                    int bytes = uu_decode[pending[0]];      // bytes we are supposed to get from this line
                    int size  = (bytes+2)/3*4;              // encoded size of those bytes
                    if (size == count-1) {                  // encoded size matches line length
                        // might have proper uu data
                        int cnt = 0;
                        for (int i=1; i<count; i+=4) {
                            unsigned long a1 = uu_decode[pending[i]];
                            unsigned long a2 = uu_decode[pending[i+1]];
                            unsigned long a3 = uu_decode[pending[i+2]];
                            unsigned long a4 = uu_decode[pending[i+3]];
                            unsigned long a = (a1 << 18) | (a2 << 12) | (a3 << 6) | a4;
                            pending[cnt++] = (a & 0x00ff0000) >> 16;
                            pending[cnt++] = (a & 0x0000ff00) >>  8;
                            pending[cnt++] = (a & 0x000000ff);
                        }
                        count = bytes;
                        st    = uu_lf2;
                    }
                    else st = uu_init;
                }
                else st = uu_init;
                } // fall thru

            case uu_lf:
            case uu_init: {
                pusher();
                } break;


            //////////////////////////////
            //  states that just accumulate characters in the pending buffer
            case h_host:
            case t_tag2:
            case t_com1:
            case u_http:
            case u_url:
            case u_sla:
            case d_pcnt:
            case d_1:
            case e_amp:
            case e_num:
            case m_eq:
            case m_1:
            case b_64:
            case uu_64:
            default: {
                } break;
        }
    }
}


////////////////////////////////////////////////
//
//
url_scanner::url_scanner(recorder *memory) {
    host_parser = new fsa("host_parser", h_init,  NULL,        NULL,        memory);
    tags_parser = new fsa("tags_parser", t_init,  host_parser, NULL,        memory);
    urls_parser = new fsa("urls_parser", u_init,  NULL,        NULL,        memory);
    urld_parser = new fsa("urld_parser", d_init,  urls_parser, tags_parser, memory);
    html_parser = new fsa("html_parser", e_init,  urld_parser, NULL,        memory);
    mime_parser = new fsa("mime_parser", m_init,  html_parser, NULL,        memory);
    b64_parser  = new fsa("b64_parser ", b_init,  mime_parser, NULL,        memory);
    uu_parser   = new fsa("uu_parser  ", uu_init, b64_parser,  NULL,        memory);
}

url_scanner::~url_scanner() {
    delete host_parser;
    delete tags_parser;
    delete urls_parser;
    delete urld_parser;
    delete html_parser;
    delete mime_parser;
    delete b64_parser;
    delete uu_parser;
}

void url_scanner::scan(u_char *buffer, size_t length) {
    uu_parser->push(buffer, length);
}

