/********************************************************************************
    Copyright (C) 1999  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#include "output/out_yuv.hh"
#include <string.h>


VideoSink_YUVFile::VideoSink_YUVFile()
  : first(true), write_headers(false), ostr(NULL),
    pic_available(false), filename("sequence.yuv")
{
}


VideoSink_YUVFile::~VideoSink_YUVFile()
{
  if (ostr && ostr!=&cout) ofilestr.close();
}



static void Write4(ostream& ostr,uint32 val)
{
  uint8 b;
  b = (val>>24)&0xFF; ostr << b;
  b = (val>>16)&0xFF; ostr << b;
  b = (val>> 8)&0xFF; ostr << b;
  b = (val    )&0xFF; ostr << b;
}

static void Write2(ostream& ostr,uint16 val)
{
  uint8 b;
  b = (val>> 8)&0xFF; ostr << b;
  b = (val    )&0xFF; ostr << b;
}

static void Fill0(ostream& ostr,int n)
{
  uint8 b=0;
  for (int i=0;i<n;i++)
    ostr << b;
}


void VideoSink_YUVFile::ShowMBRows(DecodedImageData* dimg)
{
  nextpts = dimg->m_timing.pts;

  if (first)
    {
      if (strcmp(filename,"-")==0)
	ostr = &cout;
      else
	{
	  ofilestr.open(filename, std::ios::out | std::ios::binary);
	  ostr=&ofilestr;
	}
      writer.SetYUVStream(*ostr);
      first=false;

      framecnt=0;
    }

  DecodedImageData* decimg = Accumulate(dimg);
  if (!decimg)
    return;

  if (write_headers)
    {
      ImageParam param = decimg->m_image.AskParam();

      struct header
      {
	uint32 framenr;
	uint16 width,height;
      } hdr;

      hdr.framenr = framecnt;
      hdr.width  = param.width;
      hdr.height = param.height;

      Write4(*ostr,hdr.framenr);
      Write2(*ostr,hdr.width);
      Write2(*ostr,hdr.height);
      Fill0(*ostr,128-4-2-2);

      framecnt++;
    }

  writer.WriteImage(decimg->m_image);
}


void VideoSink_YUVFile::BeginPicture(const DecodedImageData* dimg)
{
  StartAccumulation(0,dimg->m_height-1,false);
}

void VideoSink_YUVFile::FinishedPicture()
{
  pic_available=true;
}
