
#include "system/syncer.hh"

#include <iostream>
using namespace std;

#include <sys/time.h>
#include <unistd.h>

void Syncer_Realtime::Reset()
{
  d_locked=false;
}


void Syncer_Realtime::WaitUntil(PTS pts)
{
  /* --------------- This code is a quick hack and probably has a lot of overflow problems.
  */

  struct timeval tv;
  gettimeofday(&tv,NULL);

  if (d_locked)
    {
      if (pts < d_lastpts)
	{
	  cerr << "Syncer: PTS values in system stream are invalid.\n";
	  return;
	}

      int64 usec2wait = (pts-d_lastpts)*1000*100/90/d_speed;
      int64 usec_passed = (tv.tv_sec -d_lasttime.tv_sec )*1000000 +
	(tv.tv_usec-d_lasttime.tv_usec);

      if (usec_passed<0) // fail-safe return when overflow occurred
	return;

      if (usec_passed > usec2wait)
	return;

      usec2wait -= usec_passed;

      struct timespec ts;
      ts.tv_sec  = usec2wait/1000000;
      ts.tv_nsec = (usec2wait%1000000)*1000;

      assert(ts.tv_sec<20); // I don't think any user wants to wait for so long. This must be a overflow bug.

      nanosleep(&ts,NULL);
      return;
    }  

  d_lastpts = pts;
  d_lasttime = tv;
  d_locked = true;
}

