/********************************************************************************
    Copyright (C) 1999  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#include "config.h"
#include "video12/vdecoder.hh"
#include "video12/constants.hh"
#include "video12/viddec_mods.hh"
#include "system/system1.hh"
#include "error.hh"

#include "video12/modules/idct_arai.hh" ////////////////////// TODO
#include "video12/modules/mcomp_sgl_simple.hh"

#include "libvideogfx/utility/bitstream/bitreader.hh"
#include "libvideogfx/utility/bitstream/bitreader_fast.hh"

#include <string.h>
#include <strings.h>
#include <iostream>
#include <iomanip>
#include <algorithm>
using namespace std;

#define SHOW_FRAMESIZE 0

#ifdef ENABLE_MMX
#define MMX_DCT 1
#else
#define MMX_DCT 0
#endif

#undef SEND_FULL_BFRAMES

#if ENABLE_MMX
extern "C" void IDCT_mmx(short* in,short* out);
extern "C" void IDCT_16bit8bit(short* in,Pixel* out,int skip);
extern "C" void IDCT_16bit8bit_add(short* in,Pixel* out,int skip);
#endif

extern void PrintDataHex(uint8* data,uint32 len);
extern void PrintDataBin(uint8* data,uint32 len);


// -------------------------------------------------------------------------------------------
//                                            VLC
// -------------------------------------------------------------------------------------------

#include "video12/vlc.hh"
#include "types.hh"
#include "error.hh"

#include <iostream>
#include <iomanip>
using namespace std;


#define maybeinline inline

struct DirectVLCTableEntry
{
  short bits; int nBits;
};

struct DirectVLC
{
  int    value;
  uint16 bits;
};




/************************************* MB-INCR ********************************/



static DirectVLCTableEntry vlc_mbaddrinc_tab[] =
{
  {0x08,11}, // ESCAPE-CODE

  /* table taken from MSSG-encoder */
  {0x01,1},  {0x03,3},  {0x02,3},  {0x03,4},
  {0x02,4},  {0x03,5},  {0x02,5},  {0x07,7},
  {0x06,7},  {0x0b,8},  {0x0a,8},  {0x09,8},
  {0x08,8},  {0x07,8},  {0x06,8},  {0x17,10},
  {0x16,10}, {0x15,10}, {0x14,10}, {0x13,10},
  {0x12,10}, {0x23,11}, {0x22,11}, {0x21,11},
  {0x20,11}, {0x1f,11}, {0x1e,11}, {0x1d,11},
  {0x1c,11}, {0x1b,11}, {0x1a,11}, {0x19,11},
  {0x18,11}, {0,-1}
};



static DirectVLC vlc_mbaddr[2048 /*2^11*/];

struct MBAtab
{
  uint8 mba,len;
};

static MBAtab MBA_5 [] = {
                    {7, 5}, {6, 5}, {5, 4}, {5, 4}, {4, 4}, {4, 4},
    {3, 3}, {3, 3}, {3, 3}, {3, 3}, {2, 3}, {2, 3}, {2, 3}, {2, 3},
    {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1},
    {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}
};

static MBAtab MBA_11 [] = {
    {33, 11}, {32, 11}, {31, 11}, {30, 11},
    {29, 11}, {28, 11}, {27, 11}, {26, 11},
    {25, 11}, {24, 11}, {23, 11}, {22, 11},
    {21, 10}, {21, 10}, {20, 10}, {20, 10},
    {19, 10}, {19, 10}, {18, 10}, {18, 10},
    {17, 10}, {17, 10}, {16, 10}, {16, 10},
    {15,  8}, {15,  8}, {15,  8}, {15,  8},
    {15,  8}, {15,  8}, {15,  8}, {15,  8},
    {14,  8}, {14,  8}, {14,  8}, {14,  8},
    {14,  8}, {14,  8}, {14,  8}, {14,  8},
    {13,  8}, {13,  8}, {13,  8}, {13,  8},
    {13,  8}, {13,  8}, {13,  8}, {13,  8},
    {12,  8}, {12,  8}, {12,  8}, {12,  8},
    {12,  8}, {12,  8}, {12,  8}, {12,  8},
    {11,  8}, {11,  8}, {11,  8}, {11,  8},
    {11,  8}, {11,  8}, {11,  8}, {11,  8},
    {10,  8}, {10,  8}, {10,  8}, {10,  8},
    {10,  8}, {10,  8}, {10,  8}, {10,  8},
    { 9,  7}, { 9,  7}, { 9,  7}, { 9,  7},
    { 9,  7}, { 9,  7}, { 9,  7}, { 9,  7},
    { 9,  7}, { 9,  7}, { 9,  7}, { 9,  7},
    { 9,  7}, { 9,  7}, { 9,  7}, { 9,  7},
    { 8,  7}, { 8,  7}, { 8,  7}, { 8,  7},
    { 8,  7}, { 8,  7}, { 8,  7}, { 8,  7},
    { 8,  7}, { 8,  7}, { 8,  7}, { 8,  7},
    { 8,  7}, { 8,  7}, { 8,  7}, { 8,  7}
};


maybeinline int GetMBAddrIncr(class FastBitBuf& bs)
{
#if 1
  MBAtab * tab;
  int mba;

  mba = 0;

  bs.Fill16Bits();

  while (1) {
    if (bs.Peek16BitsMSB() >= 0x10000000) {
      tab = MBA_5 - 2 + bs.PeekBitsFast(5);
      bs.SkipBitsFast(tab->len);
      return mba + tab->mba;
    } else if (bs.Peek16BitsMSB() >= 0x03000000) {
      tab = MBA_11 - 24 + bs.PeekBitsFast(11);
      bs.SkipBitsFast(tab->len);
      return mba + tab->mba;
    } else
      {
	switch (bs.PeekBits(11)) {
	case 8:         // macroblock_escape
	  mba += 33;
	  // no break here on purpose
	case 15:        // macroblock_stuffing (MPEG1 only)
	  bs.SkipBitsFast(11);
	  bs.Fill16Bits();
	  break;
	default:        // end of slice, or error
	  cerr << "GetMBAddrIncr-ERROR\n";
	  throw Excpt_Huffman(ErrSev_Warning,"Invalid MPEG stream, not existing MB-addr-incr. read. (1)");
	  return 0;
	}
      }
  }
#else
  uint16 code = bs.PeekBits(11);
  int val = vlc_mbaddr[code].value;

  bs.SkipBits(vlc_mbaddr[code].bits);

  if (val<0)
    throw Excpt_Huffman(ErrSev_Warning,"Invalid MPEG stream, not existing MB-addr-incr. read. (1)");

  if (val!=0) return val;

  int val1=33;
 loop:
  code = bs.PeekBits(11);
  val = vlc_mbaddr[code].value;
  bs.SkipBits(vlc_mbaddr[code].bits);

  if (val<0)
    throw Excpt_Huffman(ErrSev_Warning,"Invalid MPEG stream, not existing MB-addr-incr. read. (2)");

  if (val!=0) return val+val1;
  else        { val1 += 33; goto loop; }
#endif
}





/************************************* MB-MODE ********************************/





static DirectVLCTableEntry vlc_mbmode_P_tab[] =
{
  {0,0}, {3,5}, {1,2}, {0,0}, {0,0}, {0,0}, {0,0}, {0,0},
  {1,3}, {0,0}, {1,1}, {0,0}, {0,0}, {0,0}, {0,0}, {0,0},
  {0,0}, {1,6}, {1,5}, {0,0}, {0,0}, {0,0}, {0,0}, {0,0},
  {0,0}, {0,0}, {2,5}, {0,0}, {0,0}, {0,0}, {0,0}, {0,0}, {0,-1}
};

static DirectVLCTableEntry vlc_mbmode_B_tab[] =
{
  {0,0}, {3,5}, {0,0}, {0,0}, {2,3}, {0,0}, {3,3}, {0,0},
  {2,4}, {0,0}, {3,4}, {0,0}, {2,2}, {0,0}, {3,2}, {0,0},
  {0,0}, {1,6}, {0,0}, {0,0}, {0,0}, {0,0}, {2,6}, {0,0},
  {0,0}, {0,0}, {3,6}, {0,0}, {0,0}, {0,0}, {2,5}, {0,0}, {0,-1}
};


static DirectVLC vlc_mbmode_P[64 /*2^6*/];
static DirectVLC vlc_mbmode_B[64 /*2^6*/];


static int GetMBMode_I(class FastBitBuf& bs)
{
  int code = bs.PeekBits(2);
  if (code & 2)
    {
      bs.SkipBitsFast(1);
      return 1;
    }
  else
    {
      if (code!=1)
        throw Excpt_Huffman(ErrSev_Warning,"Invalid MPEG stream, not existing MB-class (I-picture) read.");

      bs.SkipBitsFast(2);
      return 17;
    }
}

static int GetMBMode_P(class FastBitBuf& bs)
{
  uint16 code = bs.PeekBits(6);
  bs.SkipBits(vlc_mbmode_P[code].bits);

  if (vlc_mbmode_P[code].value==0)
    throw Excpt_Huffman(ErrSev_Warning,"Invalid MPEG stream, not existing MB-class (P-picture) read.");

  return vlc_mbmode_P[code].value;
}

static int GetMBMode_B(class FastBitBuf& bs)
{
  uint16 code = bs.PeekBits(6);
  bs.SkipBitsFast(vlc_mbmode_B[code].bits);

  if (vlc_mbmode_B[code].value==0)
    {
      //cerr << "CODEVAL: $" << hex << code << " 6 bits " << endl;
      throw Excpt_Huffman(ErrSev_Warning,"Invalid MPEG stream, not existing MB-class (B-picture) read.");
    }

  return vlc_mbmode_B[code].value;
}

static int GetMBMode_D(class FastBitBuf& bs)
{
  int c = bs.GetBits(1);
  if (c != 1)
    {
      throw Excpt_Huffman(ErrSev_Error,"Invalid MPEG stream, invalid MB-mode in D-picture read.");
    }

  return MBMODE_INTRA;
}

static int (* GetMBMode[5])(class FastBitBuf&) =
{
  NULL,
  GetMBMode_I,
  GetMBMode_P,
  GetMBMode_B,
  GetMBMode_D
};



/************************************* MotionCode ********************************/

static DirectVLCTableEntry vlc_mcode_tab[]=
{
  /* table taken from MSSG-encoder */

  {0x01,1},  {0x01,2},  {0x01,3},  {0x01,4},
  {0x03,6},  {0x05,7},  {0x04,7},  {0x03,7},
  {0x0b,9},  {0x0a,9},  {0x09,9},  {0x11,10},
  {0x10,10}, {0x0f,10}, {0x0e,10}, {0x0d,10},
  {0x0c,10}, {0,-1}
};

static DirectVLC vlc_mc[1024 /*2^10*/];

maybeinline int GetMotionCode(class FastBitBuf& bs)
{
  uint16 code = bs.PeekBits(10);
  bs.SkipBitsFast(vlc_mc[code].bits);

  if (vlc_mc[code].value==0)
    return 0;

  if (bs.GetBits(1)==0)
    return  vlc_mc[code].value;
  else
    return -vlc_mc[code].value;
}


/************************************* CBP ********************************/

static DirectVLCTableEntry vlc_cbp_tab[]=
{
  /* table taken from MSSG-encoder */

  {0x01,9}, {0x0b,5}, {0x09,5}, {0x0d,6}, 
  {0x0d,4}, {0x17,7}, {0x13,7}, {0x1f,8}, 
  {0x0c,4}, {0x16,7}, {0x12,7}, {0x1e,8}, 
  {0x13,5}, {0x1b,8}, {0x17,8}, {0x13,8}, 
  {0x0b,4}, {0x15,7}, {0x11,7}, {0x1d,8}, 
  {0x11,5}, {0x19,8}, {0x15,8}, {0x11,8}, 
  {0x0f,6}, {0x0f,8}, {0x0d,8}, {0x03,9}, 
  {0x0f,5}, {0x0b,8}, {0x07,8}, {0x07,9}, 
  {0x0a,4}, {0x14,7}, {0x10,7}, {0x1c,8}, 
  {0x0e,6}, {0x0e,8}, {0x0c,8}, {0x02,9}, 
  {0x10,5}, {0x18,8}, {0x14,8}, {0x10,8}, 
  {0x0e,5}, {0x0a,8}, {0x06,8}, {0x06,9}, 
  {0x12,5}, {0x1a,8}, {0x16,8}, {0x12,8}, 
  {0x0d,5}, {0x09,8}, {0x05,8}, {0x05,9}, 
  {0x0c,5}, {0x08,8}, {0x04,8}, {0x04,9},
  {0x07,3}, {0x0a,5}, {0x08,5}, {0x0c,6}, {0,-1}
};

static DirectVLC vlc_cbp[512 /*2^9*/];


maybeinline int GetCBP(class FastBitBuf& bs)
{
  uint16 code = bs.PeekBits(9);
  bs.SkipBitsFast(vlc_cbp[code].bits);
  return vlc_cbp[code].value;
}


/************************************* Initialization ********************************/

static DirectVLCTableEntry vlc_DClum_tab[]=
{
  /* table taken from MSSG-encoder */
  {0x0004,3}, {0x0000,2}, {0x0001,2}, {0x0005,3}, {0x0006,3}, {0x000e,4},
  {0x001e,5}, {0x003e,6}, {0x007e,7}, {0x00fe,8}, {0x01fe,9}, {0x01ff,9}, {0,-1}
};

static DirectVLCTableEntry vlc_DCchrom_tab[]=
{
  /* table taken from MSSG-encoder */
  {0x0000,2}, {0x0001,2}, {0x0002,2}, {0x0006,3}, {0x000e,4}, {0x001e,5},
  {0x003e,6}, {0x007e,7}, {0x00fe,8}, {0x01fe,9}, {0x03fe,10},{0x03ff,10}, {0,-1}
};

static DirectVLC vlc_DClum  [1<< 9];
static DirectVLC vlc_DCchrom[1<<10];

maybeinline int GetDClumSize(class FastBitBuf& bs)
{
  uint16 code = bs.PeekBits(9);
  bs.SkipBitsFast(vlc_DClum[code].bits);
  return vlc_DClum[code].value;
}

maybeinline int GetDCchromSize(class FastBitBuf& bs)
{
  uint16 code = bs.PeekBits(10);
  bs.SkipBitsFast(vlc_DCchrom[code].bits);
  return vlc_DCchrom[code].value;
}



typedef struct {
    uint8 size;
    uint8 len;
} DCtab;

static DCtab DC_lum_5 [] = {
    {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2},
    {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2},
    {0, 3}, {0, 3}, {0, 3}, {0, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3},
    {4, 3}, {4, 3}, {4, 3}, {4, 3}, {5, 4}, {5, 4}, {6, 5}
};

static DCtab DC_long [] = {
    {6, 5}, {6, 5}, {6, 5}, {6, 5}, {6, 5}, {6, 5}, { 6, 5}, { 6, 5},
    {6, 5}, {6, 5}, {6, 5}, {6, 5}, {6, 5}, {6, 5}, { 6, 5}, { 6, 5},
    {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, { 7, 6}, { 7, 6},
    {8, 7}, {8, 7}, {8, 7}, {8, 7}, {9, 8}, {9, 8}, {10, 9}, {11, 9}
};


static DCtab DC_lum_7 [] = {
    {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2},
    {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2},
    {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2},
    {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2},

    {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2},
    {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2},
    {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2},
    {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2},

    {0, 3}, {0, 3}, {0, 3}, {0, 3}, {0, 3}, {0, 3}, {0, 3}, {0, 3},
    {0, 3}, {0, 3}, {0, 3}, {0, 3}, {0, 3}, {0, 3}, {0, 3}, {0, 3},

    {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3},
    {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3},

    {4, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3},
    {4, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3},
    {5, 4}, {5, 4}, {5, 4}, {5, 4}, {5, 4}, {5, 4}, {5, 4}, {5, 4},
    {6, 5}, {6, 5}, {6, 5}, {6, 5}, {7, 6}, {7, 6}, {8, 7}
};


#if 0
static inline int get_luma_dc_dct_diff (FastBitBuf& bs)
{
  bs.Fill16Bits();

#define bit_buf bs.d_buffer
#define bits bs.d_freebits
  DCtab * tab;
  int size;
  int dc_diff;

  if (bit_buf < 0xf8000000) {
    /* Max. codelength = 5 + max. size = 6  <= 16 , no refill needed. */

    tab = DC_lum_5 + UBITS (bit_buf, 5);
    size = tab->size;
    if (size) {
      bits += tab->len + size;
      bit_buf <<= tab->len;
      dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
      bit_buf <<= size;
      return dc_diff;
    } else {
      DUMPBITS (bit_buf, bits, 3);
      return 0;
    }
  } else {
    tab = DC_long - 0x1e0 + UBITS (bit_buf, 9);
    size = tab->size;
    if (size>=9)
      {
	DUMPBITS(bit_buf,bits,tab->len);
	bs.Fill16Bits();
	dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
	DUMPBITS(bit_buf,bits,size);
      }
    else
      {
	bits += tab->len+size;
	bit_buf <<= tab->len;
	dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
	bit_buf <<= size;
      }
    return dc_diff;
  }
#undef bit_buf
#undef bits
}
#endif

#if 1
static inline int get_luma_dc_dct_diff (FastBitBuf& bs)
{
  bs.Fill16Bits();

#define bit_buf bs.d_buffer
#define bits bs.d_freebits
  DCtab * tab;
  int size;
  int dc_diff;

  if (bit_buf < 0xfe000000) {
    /* Max. codelength = 7 + max. size = 8  <= 15 , no refill needed. */

    tab = DC_lum_7 + UBITS (bit_buf, 7);
    size = tab->size;
    if (size) {
      bits += tab->len + size;
      bit_buf <<= tab->len;
      dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
      bit_buf <<= size;
      return dc_diff;
    } else {
      DUMPBITS (bit_buf, bits, 3);
      return 0;
    }
  } else {
    tab = DC_long - 0x1e0 + UBITS (bit_buf, 9);
    size = tab->size;
    DUMPBITS(bit_buf,bits,tab->len);
    bs.Fill16Bits();
    dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
    DUMPBITS(bit_buf,bits,size);
    return dc_diff;
  }
#undef bit_buf
#undef bits
}
#endif

#if 0
static DCtab DC_small [] = {
    {1, 2}, {1, 2}, {2, 2}, {2, 2}, {0, 3}, {3, 3}
};

static inline int get_luma_dc_dct_diff(FastBitBuf& bs)
{
  bs.Fill16Bits();

#define bit_buf bs.d_buffer
#define bits bs.d_freebits
  DCtab * tab;
  int size;
  int dc_diff;

  int cnt;

  __asm__
    (
     "bsrl %1,%0\n\t"
     : "=r" (cnt) : "m" (~bit_buf)
     );

  if (cnt>=30)
    {
      tab = DC_small + UBITS(bit_buf, 3);
      size = tab->size;
      if (size) {
	bits += tab->len + size;
	bit_buf <<= tab->len;
	dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
	bit_buf <<= size;
	return dc_diff;
      } else {
	DUMPBITS (bit_buf, bits, 3);
	return 0;
      }
    } else if (cnt>=25)	{
      int len  = 32-cnt;
      size = len+1;

      bits += len+size;
      bit_buf <<= len;
      dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
      bit_buf <<= size;
      return dc_diff;
    } else {
      int len  = 32-cnt;
      size = len+1;
      DUMPBITS(bit_buf,bits,len);
      bs.Fill16Bits();
      dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
      DUMPBITS(bit_buf,bits,size);
      return dc_diff;
    }
#undef bit_buf
#undef bits
}
#endif


// -------------- chroma

static DCtab DC_chrom_5 [] = {
    {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2},
    {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2},
    {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2},
    {3, 3}, {3, 3}, {3, 3}, {3, 3}, {4, 4}, {4, 4}, {5, 5}
};


static inline int get_chroma_dc_dct_diff (FastBitBuf& bs)
{
  bs.Fill16Bits();

#define bit_buf bs.d_buffer
#define bits bs.d_freebits
  DCtab * tab;
  int size;
  int dc_diff;

  if (bit_buf < 0xf8000000) {
    /* Max. codelength = 5 + max. size = 5  <= 16 , no refill needed. */

    tab = DC_chrom_5 + UBITS (bit_buf, 5);
    size = tab->size;
    if (size) {
      bits += tab->len + size;
      bit_buf <<= tab->len;
      dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
      bit_buf <<= size;
      return dc_diff;
    } else {
      DUMPBITS (bit_buf, bits, 2);
      return 0;
    }
  } else {
    tab = DC_long - 0x3e0 + UBITS (bit_buf, 10);
    size = tab->size;
    int len = tab->len+1;
    if (size>=8)
      {
	DUMPBITS(bit_buf,bits,len);
	bs.Fill16Bits();
	dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
	DUMPBITS(bit_buf,bits,size);
      }
    else
      {
	bits += len+size;
	bit_buf <<= len;
	dc_diff = UBITS (bit_buf, size) - UBITS (SBITS (~bit_buf, 1), size);
	bit_buf <<= size;
      }
    return dc_diff;
  }
#undef bit_buf
#undef bits
}



/************************************* Run/Level pairs ********************************/

struct DCTtab {
  uint8 run, level, len;
};


/* Table B-14, DCT coefficients table zero,
 * codes 0100 ... 1xxx (used for first (DC) coefficient)
 */
static DCTtab DCTtabfirst[12] =
{
  {0,2,4}, {2,1,4}, {1,1,3}, {1,1,3},
  {0,1,1}, {0,1,1}, {0,1,1}, {0,1,1},
  {0,1,1}, {0,1,1}, {0,1,1}, {0,1,1}
};

/* Table B-14, DCT coefficients table zero,
 * codes 0100 ... 1xxx (used for all other coefficients)
 */
static DCTtab DCTtabnext[12] =
{
  {0,2,4},  {2,1,4},  {1,1,3},  {1,1,3},
  {64,0,2}, {64,0,2}, {64,0,2}, {64,0,2}, /* EOB */
  {0,1,2},  {0,1,2},  {0,1,2},  {0,1,2}
};

/* Table B-14, DCT coefficients table zero,
 * codes 000001xx ... 00111xxx
 */
static DCTtab DCTtab0[60] =
{
  {65,0,6}, {65,0,6}, {65,0,6}, {65,0,6}, /* Escape */
  {2,2,7}, {2,2,7}, {9,1,7}, {9,1,7},
  {0,4,7}, {0,4,7}, {8,1,7}, {8,1,7},
  {7,1,6}, {7,1,6}, {7,1,6}, {7,1,6},
  {6,1,6}, {6,1,6}, {6,1,6}, {6,1,6},
  {1,2,6}, {1,2,6}, {1,2,6}, {1,2,6},
  {5,1,6}, {5,1,6}, {5,1,6}, {5,1,6},
  {13,1,8}, {0,6,8}, {12,1,8}, {11,1,8},
  {3,2,8}, {1,3,8}, {0,5,8}, {10,1,8},
  {0,3,5}, {0,3,5}, {0,3,5}, {0,3,5},
  {0,3,5}, {0,3,5}, {0,3,5}, {0,3,5},
  {4,1,5}, {4,1,5}, {4,1,5}, {4,1,5},
  {4,1,5}, {4,1,5}, {4,1,5}, {4,1,5},
  {3,1,5}, {3,1,5}, {3,1,5}, {3,1,5},
  {3,1,5}, {3,1,5}, {3,1,5}, {3,1,5}
};

/* Table B-15, DCT coefficients table one,
 * codes 000001xx ... 11111111
*/
static DCTtab DCTtab0a[252] =
{
  {65,0,6}, {65,0,6}, {65,0,6}, {65,0,6}, /* Escape */
  {7,1,7}, {7,1,7}, {8,1,7}, {8,1,7},
  {6,1,7}, {6,1,7}, {2,2,7}, {2,2,7},
  {0,7,6}, {0,7,6}, {0,7,6}, {0,7,6},
  {0,6,6}, {0,6,6}, {0,6,6}, {0,6,6},
  {4,1,6}, {4,1,6}, {4,1,6}, {4,1,6},
  {5,1,6}, {5,1,6}, {5,1,6}, {5,1,6},
  {1,5,8}, {11,1,8}, {0,11,8}, {0,10,8},
  {13,1,8}, {12,1,8}, {3,2,8}, {1,4,8},
  {2,1,5}, {2,1,5}, {2,1,5}, {2,1,5},
  {2,1,5}, {2,1,5}, {2,1,5}, {2,1,5},
  {1,2,5}, {1,2,5}, {1,2,5}, {1,2,5},
  {1,2,5}, {1,2,5}, {1,2,5}, {1,2,5},
  {3,1,5}, {3,1,5}, {3,1,5}, {3,1,5},
  {3,1,5}, {3,1,5}, {3,1,5}, {3,1,5},
  {1,1,3}, {1,1,3}, {1,1,3}, {1,1,3},
  {1,1,3}, {1,1,3}, {1,1,3}, {1,1,3},
  {1,1,3}, {1,1,3}, {1,1,3}, {1,1,3},
  {1,1,3}, {1,1,3}, {1,1,3}, {1,1,3},
  {1,1,3}, {1,1,3}, {1,1,3}, {1,1,3},
  {1,1,3}, {1,1,3}, {1,1,3}, {1,1,3},
  {1,1,3}, {1,1,3}, {1,1,3}, {1,1,3},
  {1,1,3}, {1,1,3}, {1,1,3}, {1,1,3},
  {64,0,4}, {64,0,4}, {64,0,4}, {64,0,4}, /* EOB */
  {64,0,4}, {64,0,4}, {64,0,4}, {64,0,4},
  {64,0,4}, {64,0,4}, {64,0,4}, {64,0,4},
  {64,0,4}, {64,0,4}, {64,0,4}, {64,0,4},
  {0,3,4}, {0,3,4}, {0,3,4}, {0,3,4},
  {0,3,4}, {0,3,4}, {0,3,4}, {0,3,4},
  {0,3,4}, {0,3,4}, {0,3,4}, {0,3,4},
  {0,3,4}, {0,3,4}, {0,3,4}, {0,3,4},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,1,2}, {0,1,2}, {0,1,2}, {0,1,2},
  {0,2,3}, {0,2,3}, {0,2,3}, {0,2,3},
  {0,2,3}, {0,2,3}, {0,2,3}, {0,2,3},
  {0,2,3}, {0,2,3}, {0,2,3}, {0,2,3},
  {0,2,3}, {0,2,3}, {0,2,3}, {0,2,3},
  {0,2,3}, {0,2,3}, {0,2,3}, {0,2,3},
  {0,2,3}, {0,2,3}, {0,2,3}, {0,2,3},
  {0,2,3}, {0,2,3}, {0,2,3}, {0,2,3},
  {0,2,3}, {0,2,3}, {0,2,3}, {0,2,3},
  {0,4,5}, {0,4,5}, {0,4,5}, {0,4,5},
  {0,4,5}, {0,4,5}, {0,4,5}, {0,4,5},
  {0,5,5}, {0,5,5}, {0,5,5}, {0,5,5},
  {0,5,5}, {0,5,5}, {0,5,5}, {0,5,5},
  {9,1,7}, {9,1,7}, {1,3,7}, {1,3,7},
  {10,1,7}, {10,1,7}, {0,8,7}, {0,8,7},
  {0,9,7}, {0,9,7}, {0,12,8}, {0,13,8},
  {2,3,8}, {4,2,8}, {0,14,8}, {0,15,8}
};

/* Table B-14, DCT coefficients table zero,
 * codes 0000001000 ... 0000001111
 */
static DCTtab DCTtab1[8] =
{
  {16,1,10}, {5,2,10}, {0,7,10}, {2,3,10},
  {1,4,10}, {15,1,10}, {14,1,10}, {4,2,10}
};

/* Table B-15, DCT coefficients table one,
 * codes 000000100x ... 000000111x
 */
static DCTtab DCTtab1a[8] =
{
  {5,2,9}, {5,2,9}, {14,1,9}, {14,1,9},
  {2,4,10}, {16,1,10}, {15,1,9}, {15,1,9}
};

/* Table B-14/15, DCT coefficients table zero / one,
 * codes 000000010000 ... 000000011111
 */
static DCTtab DCTtab2[16] =
{
  {0,11,12}, {8,2,12}, {4,3,12}, {0,10,12},
  {2,4,12}, {7,2,12}, {21,1,12}, {20,1,12},
  {0,9,12}, {19,1,12}, {18,1,12}, {1,5,12},
  {3,3,12}, {0,8,12}, {6,2,12}, {17,1,12}
};

/* Table B-14/15, DCT coefficients table zero / one,
 * codes 0000000010000 ... 0000000011111
 */
static DCTtab DCTtab3[16] =
{
  {10,2,13}, {9,2,13}, {5,3,13}, {3,4,13},
  {2,5,13}, {1,7,13}, {1,6,13}, {0,15,13},
  {0,14,13}, {0,13,13}, {0,12,13}, {26,1,13},
  {25,1,13}, {24,1,13}, {23,1,13}, {22,1,13}
};

/* Table B-14/15, DCT coefficients table zero / one,
 * codes 00000000010000 ... 00000000011111
 */
static DCTtab DCTtab4[16] =
{
  {0,31,14}, {0,30,14}, {0,29,14}, {0,28,14},
  {0,27,14}, {0,26,14}, {0,25,14}, {0,24,14},
  {0,23,14}, {0,22,14}, {0,21,14}, {0,20,14},
  {0,19,14}, {0,18,14}, {0,17,14}, {0,16,14}
};

/* Table B-14/15, DCT coefficients table zero / one,
 * codes 000000000010000 ... 000000000011111
 */
static DCTtab DCTtab5[16] =
{
  {0,40,15}, {0,39,15}, {0,38,15}, {0,37,15},
  {0,36,15}, {0,35,15}, {0,34,15}, {0,33,15},
  {0,32,15}, {1,14,15}, {1,13,15}, {1,12,15},
  {1,11,15}, {1,10,15}, {1,9,15}, {1,8,15}
};

/* Table B-14/15, DCT coefficients table zero / one,
 * codes 0000000000010000 ... 0000000000011111
 */
static DCTtab DCTtab6[16] =
{
  {1,18,16}, {1,17,16}, {1,16,16}, {1,15,16},
  {6,3,16}, {16,2,16}, {15,2,16}, {14,2,16},
  {13,2,16}, {12,2,16}, {11,2,16}, {31,1,16},
  {30,1,16}, {29,1,16}, {28,1,16}, {27,1,16}
};


// r=0,l=0 -> EOB
// r=1,l=0 -> ESCAPE

struct CoeffTab
{
  uint8 run;
  int16 level;
  uint8 nbits;
};

static CoeffTab coefftab_first[1<<17];
static CoeffTab coefftab_nonfirst[1<<17];
static CoeffTab coefftab_B15[1<<17];

struct CoeffTabInit
{
  uint8  run;
  int16 level;
  uint8 nbits;
  uint32 bits;
};

struct CoeffTabInit2
{
  uint8  run;
  int16 level;
  char* bits;
};

CoeffTabInit coeff[] =
{
  { 0, 2,  5, 0x0008 },
  { 0, 3,  6, 0x000A },
  { 0, 4,  8, 0x000C },
  { 0, 5,  9, 0x004C },
  { 0, 6,  9, 0x0042 },
  { 0, 7, 11, 0x0014 },
  { 0, 8, 13, 0x003A },
  { 0, 9, 13, 0x0030 },
  { 0,10, 13, 0x0026 },
  { 0,11, 13, 0x0020 },
  { 0,12, 14, 0x0034 },
  { 0,13, 14, 0x0032 },
  { 0,14, 14, 0x00C0>>2 },
  { 0,15, 14, 0x00B8>>2 },
  { 0,16, 15, 0x007C>>1 },
  { 0,17, 15, 0x0078>>1 },
  { 0,18, 15, 0x0074>>1 },
  { 0,19, 15, 0x0070>>1 },
  { 0,20, 15, 0x006C>>1 },
  { 0,21, 15, 0x0068>>1 },
  { 0,22, 15, 0x0064>>1 },
  { 0,23, 15, 0x0060>>1 },
  { 0,24, 15, 0x005C>>1 },
  { 0,25, 15, 0x0058>>1 },
  { 0,26, 15, 0x0054>>1 },
  { 0,27, 15, 0x0050>>1 },
  { 0,28, 15, 0x004C>>1 },
  { 0,29, 15, 0x0048>>1 },
  { 0,30, 15, 0x0044>>1 },
  { 0,31, 15, 0x0040>>1 },
  { 0,32, 16, 0x0030 },
  { 0,33, 16, 0x002E },
  { 0,34, 16, 0x002C },
  { 0,35, 16, 0x002A },
  { 0,36, 16, 0x0028 },
  { 0,37, 16, 0x0026 },
  { 0,38, 16, 0x0024 },
  { 0,39, 16, 0x0022 },
  { 0,40, 16, 0x0020 },
  { 1, 1,  4, 0x0006 },
  { 1, 2,  7, 0x0018>>1 },
  { 1, 3,  9, 0x0025<<1 },
  { 1, 4, 11, 0x0030>>1 },
  { 1, 5, 13, 0x001B<<1 },
  { 1, 6, 14, 0x000B<<2 },
  { 1, 7, 14, 0x00A8>>2 },
  { 1, 8, 16, 0x003E },
  { 1, 9, 16, 0x003C },
  { 1,10, 16, 0x003A },
  { 1,11, 16, 0x0038 },
  { 1,12, 16, 0x0036 },
  { 1,13, 16, 0x0034 },
  { 1,14, 16, 0x0032 },
  { 1,15, 17, 0x0013<<1 },
  { 1,16, 17, 0x0012<<1 },
  { 1,17, 17, 0x0011<<1 },
  { 1,18, 17, 0x0010<<1 },
  { 2, 1,  5, 0x0005<<1 },
  { 2, 2,  8, 0x0008 },
  { 2, 3, 11, 0x002C>>1 },
  { 2, 4, 13, 0x0014<<1 },
  { 2, 5, 14, 0x00A0>>2 },
  { 3, 1,  6, 0x0038>>2 },
  { 3, 2,  9, 0x0024<<1 },
  { 3, 3, 13, 0x001C<<1 },
  { 3, 4, 14, 0x0098>>2 },
  { 4, 1,  6, 0x0030>>2 },
  { 4, 2, 11, 0x003C>>1 },
  { 4, 3, 13, 0x0012<<1 },
  { 5, 1,  7, 0x001C>>1 },
  { 5, 2, 11, 0x0024>>1 },
  { 5, 3, 14, 0x0090>>2 },
  { 6, 1,  7, 0x0014>>1 },
  { 6, 2, 13, 0x001E<<1 },
  { 6, 3, 17, 0x0014<<1 },
  { 7, 1,  7, 0x0010>>1 },
  { 7, 2, 13, 0x0015<<1 },
  { 8, 1,  8, 0x000E },
  { 8, 2, 13, 0x0011<<1 },
  { 9, 1,  8, 0x000A },
  { 9, 2, 14, 0x0088>>2 },
  {10, 1,  9, 0x0027<<1 },
  {10, 2, 14, 0x0080>>2 },
  {11, 1,  9, 0x0023<<1 },
  {11, 2, 17, 0x001A<<1 },
  {12, 1,  9, 0x0022<<1 },
  {12, 2, 17, 0x0019<<1 },
  {13, 1,  9, 0x0020<<1 },
  {13, 2, 17, 0x0018<<1 },
  {14, 1, 11, 0x0038>>1 },
  {14, 2, 17, 0x0017<<1 },
  {15, 1, 11, 0x0034>>1 },
  {15, 2, 17, 0x0016<<1 },
  {16, 1, 11, 0x0020>>1 },
  {16, 2, 17, 0x0015<<1 },
  {17, 1, 13, 0x001F<<1 },
  {18, 1, 13, 0x001A<<1 },
  {19, 1, 13, 0x0019<<1 },
  {20, 1, 13, 0x0017<<1 },
  {21, 1, 13, 0x0016<<1 },
  {22, 1, 14, 0x00F8>>2 },
  {23, 1, 14, 0x00F0>>2 },
  {24, 1, 14, 0x00E8>>2 },
  {25, 1, 14, 0x00E0>>2 },
  {26, 1, 14, 0x00D8>>2 },
  {27, 1, 17, 0x001F<<1 },
  {28, 1, 17, 0x001E<<1 },
  {29, 1, 17, 0x001D<<1 },
  {30, 1, 17, 0x001C<<1 },
  {31, 1, 17, 0x001B<<1 },
  
  { 0,0,0,0 }
};


CoeffTabInit2 coeff_B15[] =
{
  { 0, 1,  "10s" },
  { 1, 1,  "010s" },
  { 0, 2,  "110s" },
  { 2, 1,  "00101s" },
  { 0, 3,  "0111s" },
  { 3, 1,  "00111s" },
  { 4, 1,  "000110s" },
  { 1, 2,  "00110s" },
  { 5, 1,  "000111s" },
  { 6, 1,  "0000110s" },
  { 7, 1,  "0000100s" },
  { 0, 4,  "11100s" },
  { 2, 2,  "0000111s" },
  { 8, 1,  "0000101s" },
  { 9, 1,  "1111000s" },
  { 0, 5,  "11101s" },
  { 0, 6,  "000101s" },
  { 1, 3,  "1111001s" },
  { 3, 2,  "00100110s" },
  {10, 1,  "1111010s" },
  {11, 1,  "00100001s" },
  {12, 1,  "00100101s" },
  {13, 1,  "00100100s" },
  { 0, 7,  "000100s" },
  { 1, 4,  "00100111s" },
  { 2, 3,  "11111100s" },
  { 4, 2,  "11111101s" },
  { 5, 2,  "000000100s" },
  {14, 1,  "000000101s" },
  {15, 1,  "000000111s" },
  {16, 1,  "0000001101s" },
  { 0, 8,  "1111011s" },
  { 0, 9,  "1111100s" },
  { 0,10,  "00100011s" },
  { 0,11,  "00100010s" },
  { 1, 5,  "00100000s" },
  { 2, 4,  "0000001100s" },
  { 3, 3,  "000000011100s" },
  { 4, 3,  "000000010010s" },
  { 6, 2,  "000000011110s" },
  { 7, 2,  "000000010101s" },
  { 8, 2,  "000000010001s" },
  {17, 1,  "000000011111s" },
  {18, 1,  "000000011010s" },
  {19, 1,  "000000011001s" },
  {20, 1,  "000000010111s" },
  {21, 1,  "000000010110s" },
  { 0,12,  "11111010s" },
  { 0,13,  "11111011s" },
  { 0,14,  "11111110s" },
  { 0,15,  "11111111s" },
  { 1, 6,  "0000000010110s" },
  { 1, 7,  "0000000010101s" },
  { 2, 5,  "0000000010100s" },
  { 3, 4,  "0000000010011s" },
  { 5, 3,  "0000000010010s" },
  { 9, 2,  "0000000010001s" },
  {10, 2,  "0000000010000s" },
  {22, 1,  "0000000011111s" },
  {23, 1,  "0000000011110s" },
  {24, 1,  "0000000011101s" },
  {25, 1,  "0000000011100s" },
  {26, 1,  "0000000011011s" },
  { 0,16,  "00000000011111s" },
  { 0,17,  "00000000011110s" },
  { 0,18,  "00000000011101s" },
  { 0,19,  "00000000011100s" },
  { 0,20,  "00000000011011s" },
  { 0,21,  "00000000011010s" },
  { 0,22,  "00000000011001s" },
  { 0,23,  "00000000011000s" },
  { 0,24,  "00000000010111s" },
  { 0,25,  "00000000010110s" },
  { 0,26,  "00000000010101s" },
  { 0,27,  "00000000010100s" },
  { 0,28,  "00000000010011s" },
  { 0,29,  "00000000010010s" },
  { 0,30,  "00000000010001s" },
  { 0,31,  "00000000010000s" },
  { 0,32,  "000000000011000s" },
  { 0,33,  "000000000010111s" },
  { 0,34,  "000000000010110s" },
  { 0,35,  "000000000010101s" },
  { 0,36,  "000000000010100s" },
  { 0,37,  "000000000010011s" },
  { 0,38,  "000000000010010s" },
  { 0,39,  "000000000010001s" },
  { 0,40,  "000000000010000s" },
  { 1, 8,  "000000000011111s" },
  { 1, 9,  "000000000011110s" },
  { 1,10,  "000000000011101s" },
  { 1,11,  "000000000011100s" },
  { 1,12,  "000000000011011s" },
  { 1,13,  "000000000011010s" },
  { 1,14,  "000000000011001s" },
  { 1,15,  "0000000000010011s" },
  { 1,16,  "0000000000010010s" },
  { 1,17,  "0000000000010001s" },
  { 1,18,  "0000000000010000s" },
  { 6, 3,  "0000000000010100s" },
  {11, 2,  "0000000000011010s" },
  {12, 2,  "0000000000011001s" },
  {13, 2,  "0000000000011000s" },
  {14, 2,  "0000000000010111s" },
  {15, 2,  "0000000000010110s" },
  {16, 2,  "0000000000010101s" },
  {27, 1,  "0000000000011111s" },
  {28, 1,  "0000000000011110s" },
  {29, 1,  "0000000000011101s" },
  {30, 1,  "0000000000011100s" },
  {31, 1,  "0000000000011011s" },
  
  { 0,0,0 }
};


int Bin2Int(const char* s)
{
  int val=0;
  while (*s)
    {
      val<<=1;
      if (*s=='1') val++;
      s++;
    }

  return val;
}


class CoeffTabInitializer
{
public:
  CoeffTabInitializer()
  {
    for (int i=0;coeff[i].nbits;i++)
      {
	uint32 bits  = coeff[i].bits;
	int    nbits = coeff[i].nbits;

	bits <<= (17-nbits);

	Insert(coefftab_first, bits,nbits,     coeff[i].run,coeff[i].level);
	Insert(coefftab_nonfirst, bits,nbits,  coeff[i].run,coeff[i].level);

	bits |= 1<<(17-nbits);

	Insert(coefftab_first, bits,nbits,     coeff[i].run,-coeff[i].level);
	Insert(coefftab_nonfirst, bits,nbits,  coeff[i].run,-coeff[i].level);
      }

    Insert(coefftab_first,    0x2<<15,2, 0, 1);
    Insert(coefftab_first,    0x3<<15,2, 0,-1);

    Insert(coefftab_nonfirst, 0x2<<15,2, 0, 0);
    Insert(coefftab_nonfirst, 0x6<<14,3, 0, 1);
    Insert(coefftab_nonfirst, 0x7<<14,3, 0,-1);

    Insert(coefftab_first,    0x1<<11,6, 1,0);
    Insert(coefftab_nonfirst, 0x1<<11,6, 1,0);


    // B15


    for (int i=0;coeff_B15[i].bits;i++)
      {
	uint32 bits  = Bin2Int(coeff_B15[i].bits);
	int    nbits = strlen(coeff_B15[i].bits);

	bits <<= (17-nbits);
	Insert(coefftab_B15, bits,nbits,  coeff_B15[i].run, coeff_B15[i].level);
	bits |= 1<<(17-nbits);
	Insert(coefftab_B15, bits,nbits,  coeff_B15[i].run,-coeff_B15[i].level);
      }

    Insert(coefftab_B15, 0x6<<13,4, 0, 0);
    Insert(coefftab_B15, 0x1<<11,6, 1, 0);
  }

  void Insert(CoeffTab* coeff,uint32 bits,int nbits,uint8 run,int16 level)
  {
    for (int i=0 ; i < (1<<(17-nbits)) ; i++)
      {
	coeff[bits | i].run   = run;
	coeff[bits | i].level = level;
	coeff[bits | i].nbits = nbits;
      }
  }
} dummy2348756;

bool GetRunLen_old(FastBitBuf& bs,int& run,int& value ,bool B15,bool first,bool MPEG1);

/*maybeinline*/ bool GetRunLen(FastBitBuf& bs,int& run,int& value ,bool B15,bool first,bool MPEG1)
{
#if 0
  return GetRunLen_old(bs,run,value ,B15,first,MPEG1);
#endif

  uint32 code = bs.PeekBits(17);

  CoeffTab* entry;

  if (B15)
    entry = &coefftab_B15[code];
  else
    {
      if (first) entry = &coefftab_first[code];
      else       entry = &coefftab_nonfirst[code];
    }

  bs.SkipBits(entry->nbits);

  if (entry->level)
    {
      value = entry->level;
      run   = entry->run;

      return false;
    }

  if (entry->run == 0)
    {
      return true;
    }

  run = bs.GetBits(6);

  if (MPEG1)
    {
      value = bs.GetBits(8);
      if (value==0)
	value = bs.GetBits(8);
      else if (value==128)
	value = bs.GetBits(8) - 256;
      else if (value>128)
	value -= 256;
    }
  else
    {
      value = bs.GetBits(12);
      if (value==0)
	throw Excpt_Huffman(ErrSev_Warning,
			    "Invalid MPEG stream, not allowed MPEG-2 escape seq value 0 read.");

      if (value >= 0x800)
	value = -(2048-(value-0x800));
    }

  return false;
}

maybeinline bool GetRunLen_old(FastBitBuf& bs,int& run,int& value ,bool B15,bool first,bool MPEG1)
{
  uint16 code = bs.PeekBits(16);

  DCTtab* tab;

  if (!B15 && first && code&0x8000)
    {
      if (code&0x4000) value=-1;
      else             value= 1;
      run=0;

      bs.SkipBitsFast(2);
      return false;
    }

  if (code>=16384 && !B15)
    tab = &DCTtabnext[(code>>12)-4];
  else if (code>=1024)
    {
      if (B15)
        tab = &DCTtab0a[(code>>8)-4];
      else
        tab = &DCTtab0[(code>>8)-4];
    }
  else if (code>=512)
    {
      if (B15)
        tab = &DCTtab1a[(code>>6)-8];
      else
        tab = &DCTtab1[(code>>6)-8];
    }
  else if (code>=256)
    tab = &DCTtab2[(code>>4)-16];
  else if (code>=128)
    tab = &DCTtab3[(code>>3)-16];
  else if (code>=64)
    tab = &DCTtab4[(code>>2)-16];
  else if (code>=32)
    tab = &DCTtab5[(code>>1)-16];
  else if (code>=16)
    tab = &DCTtab6[code-16];
  else
    {
      MessageDisplay::Show(ErrSev_Warning,"invalid Huffman code for DCT run/level-pair");
      return false;
    }


  bs.SkipBitsFast(tab->len);

  if (tab->run==64)  // EOB
    {
      return true;
    }

  if (tab->run==65) /* escape */
    {
      if (MPEG1)
        {
          run = bs.GetBits(6);
      
          value = bs.GetBits(8);
          if (value==0)
            value = bs.GetBits(8);
          else if (value==128)
            value = bs.GetBits(8) - 256;
          else if (value>128)
            value -= 256;
        }
      else
        {
          run = bs.GetBits(6);
          value = bs.GetBits(12);
          if (value==0)
            throw Excpt_Huffman(ErrSev_Warning,
				"Invalid MPEG stream, not allowed MPEG-2 escape seq value 0 read.");

          if (value >= 0x800)
            value = -(2048-(value-0x800));
        }
    }
  else
    {
      run   = tab->run;
      value = tab->level;
      if (bs.GetBits(1))
        value = -value;
    }

  return false;
}


maybeinline bool GetRunLen_ENVELOPE(FastBitBuf& bs,int& run,int& value ,bool B15,bool first,bool MPEG1)
{
  uint32 nextbits = bs.PeekBits(20);

  for (int i=0;i<20;i++)
    {
      if (nextbits & ((1<<19)>>i)) cerr << "1"; else cerr << "0";
    }

  cerr << " ";

  bool ret = GetRunLen_old(bs,run,value,B15,first,MPEG1);
  //bool ret = GetRunLen_new(bs,run,value,B15,first,MPEG1);
  
  cerr << run << " " << value << " " << (ret ? "T" : "F") << endl;
  return ret;
}






//static void get_mpeg1_intra_block (picture_t * picture, slice_t * slice,
//                                   int16_t * dest)

#if 0
maybeinline bool GetRunLen_old(FastBitBuf& bs,int& run,int& value ,bool B15,bool first,bool MPEG1)
{
    int i;
    int j;
    int val;
    DCTtab * tab;
    uint32_t bit_buf;
    int bits;

    i = 0;

    bs.MakeLocalCopy(bit_buf,bits);
    //bit_buf = bitstream_buf;
    //bits = bitstream_bits;

    NEEDBITS (bs,bit_buf, bits);

    while (1) {
        if (bit_buf >= 0x28000000) {

            tab = DCT_B14AC_5 - 5 + UBITS (bit_buf, 5);

            i += tab->run;
            if (i >= 64)
                break;  // end of block

        normal_code:
            j = scan[i];
            bit_buf <<= tab->len;
            bits += tab->len + 1;
            val = tab->level;
            val = (val ^ SBITS (bit_buf, 1)) - SBITS (bit_buf, 1);

            value = val;

            bit_buf <<= 1;
            NEEDBITS (bs,bit_buf, bits);

            continue;

        } else if (bit_buf >= 0x04000000) {

            tab = DCT_B14_8 - 4 + UBITS (bit_buf, 8);

            i += tab->run;
            if (i < 64)
                goto normal_code;

            // escape code

            i += UBITS (bit_buf << 6, 6) - 64;
            if (i >= 64)
                break;  // illegal, but check needed to avoid buffer overflow

            j = scan[i];

            DUMPBITS (bit_buf, bits, 12);
            NEEDBITS (bs,bit_buf, bits);
            val = SBITS (bit_buf, 8);
            if (! (val & 0x7f)) {
                DUMPBITS (bit_buf, bits, 8);
                val = UBITS (bit_buf, 8) + 2 * val;
            }
            val = (val * quantizer_scale * quant_matrix[j]) / 16;

            SATURATE (val);
            dest[j] = val;

            DUMPBITS (bit_buf, bits, 8);
            NEEDBITS (bs,bit_buf, bits);

            continue;

        } else if (bit_buf >= 0x02000000) {
            tab = DCT_B14_10 - 8 + UBITS (bit_buf, 10);
            i += tab->run;
            if (i < 64)
                goto normal_code;
        } else if (bit_buf >= 0x00800000) {
            tab = DCT_13 - 16 + UBITS (bit_buf, 13);
            i += tab->run;
            if (i < 64)
                goto normal_code;
        } else if (bit_buf >= 0x00200000) {
            tab = DCT_15 - 16 + UBITS (bit_buf, 15);
            i += tab->run;
            if (i < 64)
                goto normal_code;
        } else {
            tab = DCT_16 + UBITS (bit_buf, 16);
            bit_buf <<= 16;
            bit_buf |= getword () << (bits + 16);
            i += tab->run;
            if (i < 64)
                goto normal_code;
        }
        break;  // illegal, but check needed to avoid buffer overflow
    }
    DUMPBITS (bit_buf, bits, 2);        // dump end of block code


    bs.RestoreFromLocal(bit_buf,bits);
    //bitstream_buf = bit_buf;
    //bitstream_bits = bits;
}
#endif


/************************************* initialization ********************************/

static void InitTAB(const DirectVLCTableEntry* src,DirectVLC* dest,int invalid_value)
{
  int maxbits=0;
  for (uint16 n=0; src[n].nBits>=0 ;n++)
    if (src[n].nBits>maxbits)
      maxbits=src[n].nBits;

  int size = (1<<maxbits);

  for (int i=0;i<size;i++)
    dest[i].value = invalid_value;

  for (uint16 n=0; src[n].nBits>=0 ;n++)
    if (src[n].nBits>0)
      {
        uint16 vlc_base = src[n].bits << (maxbits - src[n].nBits);
        
        for (int i=0;i<(1<<(maxbits - src[n].nBits));i++)
          {
            dest[vlc_base+i].value = n;
            dest[vlc_base+i].bits  = src[n].nBits;
          }
      }
}

static class DummyInit_23487635
{
public:
  DummyInit_23487635()
    {
      InitTAB(vlc_mbaddrinc_tab,vlc_mbaddr,-1);
      InitTAB(vlc_mbmode_P_tab,vlc_mbmode_P,0);
      InitTAB(vlc_mbmode_B_tab,vlc_mbmode_B,0);
      InitTAB(vlc_cbp_tab,vlc_cbp,-1);
      InitTAB(vlc_DClum_tab,vlc_DClum,-1);
      InitTAB(vlc_DCchrom_tab,vlc_DCchrom,-1);
      InitTAB(vlc_mcode_tab,vlc_mc,-1);
    }
} dummyinit_23845673;


// -------------------------------------------------------------------------------------------
//                                           DCTBLK
// -------------------------------------------------------------------------------------------

typedef struct {
  uint8 run;
  uint8 level;
  uint8 len;
} DCTtabb;



static DCTtabb DCT_16 [] = {
    {129, 0, 0}, {129, 0, 0}, {129, 0, 0}, {129, 0, 0},
    {129, 0, 0}, {129, 0, 0}, {129, 0, 0}, {129, 0, 0},
    {129, 0, 0}, {129, 0, 0}, {129, 0, 0}, {129, 0, 0},
    {129, 0, 0}, {129, 0, 0}, {129, 0, 0}, {129, 0, 0},
    {  2,18, 0}, {  2,17, 0}, {  2,16, 0}, {  2,15, 0},
    {  7, 3, 0}, { 17, 2, 0}, { 16, 2, 0}, { 15, 2, 0},
    { 14, 2, 0}, { 13, 2, 0}, { 12, 2, 0}, { 32, 1, 0},
    { 31, 1, 0}, { 30, 1, 0}, { 29, 1, 0}, { 28, 1, 0}
};

static DCTtabb DCT_15 [] = {
    {  1,40,15}, {  1,39,15}, {  1,38,15}, {  1,37,15},
    {  1,36,15}, {  1,35,15}, {  1,34,15}, {  1,33,15},
    {  1,32,15}, {  2,14,15}, {  2,13,15}, {  2,12,15},
    {  2,11,15}, {  2,10,15}, {  2, 9,15}, {  2, 8,15},
    {  1,31,14}, {  1,31,14}, {  1,30,14}, {  1,30,14},
    {  1,29,14}, {  1,29,14}, {  1,28,14}, {  1,28,14},
    {  1,27,14}, {  1,27,14}, {  1,26,14}, {  1,26,14},
    {  1,25,14}, {  1,25,14}, {  1,24,14}, {  1,24,14},
    {  1,23,14}, {  1,23,14}, {  1,22,14}, {  1,22,14},
    {  1,21,14}, {  1,21,14}, {  1,20,14}, {  1,20,14},
    {  1,19,14}, {  1,19,14}, {  1,18,14}, {  1,18,14},
    {  1,17,14}, {  1,17,14}, {  1,16,14}, {  1,16,14}
};

static DCTtabb DCT_13 [] = {
    { 11, 2,13}, { 10, 2,13}, {  6, 3,13}, {  4, 4,13},
    {  3, 5,13}, {  2, 7,13}, {  2, 6,13}, {  1,15,13},
    {  1,14,13}, {  1,13,13}, {  1,12,13}, { 27, 1,13},
    { 26, 1,13}, { 25, 1,13}, { 24, 1,13}, { 23, 1,13},
    {  1,11,12}, {  1,11,12}, {  9, 2,12}, {  9, 2,12},
    {  5, 3,12}, {  5, 3,12}, {  1,10,12}, {  1,10,12},
    {  3, 4,12}, {  3, 4,12}, {  8, 2,12}, {  8, 2,12},
    { 22, 1,12}, { 22, 1,12}, { 21, 1,12}, { 21, 1,12},
    {  1, 9,12}, {  1, 9,12}, { 20, 1,12}, { 20, 1,12},
    { 19, 1,12}, { 19, 1,12}, {  2, 5,12}, {  2, 5,12},
    {  4, 3,12}, {  4, 3,12}, {  1, 8,12}, {  1, 8,12},
    {  7, 2,12}, {  7, 2,12}, { 18, 1,12}, { 18, 1,12}
};

static DCTtabb DCT_B14_10 [] = {
    { 17, 1,10}, {  6, 2,10}, {  1, 7,10}, {  3, 3,10},
    {  2, 4,10}, { 16, 1,10}, { 15, 1,10}, {  5, 2,10}
};

static DCTtabb DCT_B14_8 [] = {
    { 65, 0, 6}, { 65, 0, 6}, { 65, 0, 6}, { 65, 0, 6},
    {  3, 2, 7}, {  3, 2, 7}, { 10, 1, 7}, { 10, 1, 7},
    {  1, 4, 7}, {  1, 4, 7}, {  9, 1, 7}, {  9, 1, 7},
    {  8, 1, 6}, {  8, 1, 6}, {  8, 1, 6}, {  8, 1, 6},
    {  7, 1, 6}, {  7, 1, 6}, {  7, 1, 6}, {  7, 1, 6},
    {  2, 2, 6}, {  2, 2, 6}, {  2, 2, 6}, {  2, 2, 6},
    {  6, 1, 6}, {  6, 1, 6}, {  6, 1, 6}, {  6, 1, 6},
    { 14, 1, 8}, {  1, 6, 8}, { 13, 1, 8}, { 12, 1, 8},
    {  4, 2, 8}, {  2, 3, 8}, {  1, 5, 8}, { 11, 1, 8}
};

static DCTtabb DCT_B14AC_5 [] = {
		 {  1, 3, 5}, {  5, 1, 5}, {  4, 1, 5},
    {  1, 2, 4}, {  1, 2, 4}, {  3, 1, 4}, {  3, 1, 4},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {129, 0, 2}, {129, 0, 2}, {129, 0, 2}, {129, 0, 2},
    {129, 0, 2}, {129, 0, 2}, {129, 0, 2}, {129, 0, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}
};

static DCTtabb DCT_B14DC_5 [] = {
		 {  1, 3, 5}, {  5, 1, 5}, {  4, 1, 5},
    {  1, 2, 4}, {  1, 2, 4}, {  3, 1, 4}, {  3, 1, 4},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {  1, 1, 1}, {  1, 1, 1}, {  1, 1, 1}, {  1, 1, 1},
    {  1, 1, 1}, {  1, 1, 1}, {  1, 1, 1}, {  1, 1, 1},
    {  1, 1, 1}, {  1, 1, 1}, {  1, 1, 1}, {  1, 1, 1},
    {  1, 1, 1}, {  1, 1, 1}, {  1, 1, 1}, {  1, 1, 1}
};

static DCTtabb DCT_B15_10 [] = {
    {  6, 2, 9}, {  6, 2, 9}, { 15, 1, 9}, { 15, 1, 9},
    {  3, 4,10}, { 17, 1,10}, { 16, 1, 9}, { 16, 1, 9}
};

static DCTtabb DCT_B15_8 [] = {
    { 65, 0, 6}, { 65, 0, 6}, { 65, 0, 6}, { 65, 0, 6},
    {  8, 1, 7}, {  8, 1, 7}, {  9, 1, 7}, {  9, 1, 7},
    {  7, 1, 7}, {  7, 1, 7}, {  3, 2, 7}, {  3, 2, 7},
    {  1, 7, 6}, {  1, 7, 6}, {  1, 7, 6}, {  1, 7, 6},
    {  1, 6, 6}, {  1, 6, 6}, {  1, 6, 6}, {  1, 6, 6},
    {  5, 1, 6}, {  5, 1, 6}, {  5, 1, 6}, {  5, 1, 6},
    {  6, 1, 6}, {  6, 1, 6}, {  6, 1, 6}, {  6, 1, 6},
    {  2, 5, 8}, { 12, 1, 8}, {  1,11, 8}, {  1,10, 8},
    { 14, 1, 8}, { 13, 1, 8}, {  4, 2, 8}, {  2, 4, 8},
    {  3, 1, 5}, {  3, 1, 5}, {  3, 1, 5}, {  3, 1, 5},
    {  3, 1, 5}, {  3, 1, 5}, {  3, 1, 5}, {  3, 1, 5},
    {  2, 2, 5}, {  2, 2, 5}, {  2, 2, 5}, {  2, 2, 5},
    {  2, 2, 5}, {  2, 2, 5}, {  2, 2, 5}, {  2, 2, 5},
    {  4, 1, 5}, {  4, 1, 5}, {  4, 1, 5}, {  4, 1, 5},
    {  4, 1, 5}, {  4, 1, 5}, {  4, 1, 5}, {  4, 1, 5},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3}, {  2, 1, 3},
    {129, 0, 4}, {129, 0, 4}, {129, 0, 4}, {129, 0, 4},
    {129, 0, 4}, {129, 0, 4}, {129, 0, 4}, {129, 0, 4},
    {129, 0, 4}, {129, 0, 4}, {129, 0, 4}, {129, 0, 4},
    {129, 0, 4}, {129, 0, 4}, {129, 0, 4}, {129, 0, 4},
    {  1, 3, 4}, {  1, 3, 4}, {  1, 3, 4}, {  1, 3, 4},
    {  1, 3, 4}, {  1, 3, 4}, {  1, 3, 4}, {  1, 3, 4},
    {  1, 3, 4}, {  1, 3, 4}, {  1, 3, 4}, {  1, 3, 4},
    {  1, 3, 4}, {  1, 3, 4}, {  1, 3, 4}, {  1, 3, 4},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2}, {  1, 1, 2},
    {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3},
    {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3},
    {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3},
    {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3},
    {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3},
    {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3},
    {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3},
    {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3}, {  1, 2, 3},
    {  1, 4, 5}, {  1, 4, 5}, {  1, 4, 5}, {  1, 4, 5},
    {  1, 4, 5}, {  1, 4, 5}, {  1, 4, 5}, {  1, 4, 5},
    {  1, 5, 5}, {  1, 5, 5}, {  1, 5, 5}, {  1, 5, 5},
    {  1, 5, 5}, {  1, 5, 5}, {  1, 5, 5}, {  1, 5, 5},
    { 10, 1, 7}, { 10, 1, 7}, {  2, 3, 7}, {  2, 3, 7},
    { 11, 1, 7}, { 11, 1, 7}, {  1, 8, 7}, {  1, 8, 7},
    {  1, 9, 7}, {  1, 9, 7}, {  1,12, 8}, {  1,13, 8},
    {  3, 3, 8}, {  5, 2, 8}, {  1,14, 8}, {  1,15, 8}
};


inline int DequantizeIntra(int value,int qscale,int matrix)
{
#if MMX_DCT
  return value*qscale*matrix;
#else
  return value*qscale*matrix/16;
#endif
}

inline int DequantizeInter(int value,int qscale,int matrix)
{
  // Assert(value>0);
#if MMX_DCT
  return (2*value+1) * matrix * qscale / 2;
#else
  return (2*value+1) * matrix * qscale / 32;
#endif
}

inline void Saturate(int& value)
{
#if MMX_DCT
       if (value<-2048*16) value=-2048*16;
  else if (value> 2047*16) value= 2047*16;
#else
       if (value<-2048) value=-2048;
  else if (value> 2047) value= 2047;
#endif
}


static void get_mpeg1_intra_block(class FastBitBuf& bs,short* coeff,const int* scan,
				  int quantizer_scale,
				  const int* quant_matrix)
{
  int i;
  int j;
  int val;
  DCTtabb * tab;
  uint32 bit_buf;
  int bits;

  i = 0;
  bs.MakeLocalCopy(bit_buf,bits);

  NEEDBITS (bs,bit_buf, bits);

  while (1) {
    if (bit_buf >= 0x28000000) {

      tab = DCT_B14AC_5 - 5 + UBITS (bit_buf, 5);

      i += tab->run;
      if (i >= 64)
	break;  // end of block

    normal_code:
      j = scan[i];
      bit_buf <<= tab->len;
      bits += tab->len + 1;
      val = DequantizeIntra(tab->level,quantizer_scale,quant_matrix[i]);

      // if (bitstream_get (1)) val = -val;
      val = (val ^ SBITS (bit_buf, 1)) - SBITS (bit_buf, 1);

      Saturate(val);
      coeff[j] = val;

      bit_buf <<= 1;
      NEEDBITS (bs,bit_buf, bits);

      continue;

    } else if (bit_buf >= 0x04000000) {

      tab = DCT_B14_8 - 4 + UBITS (bit_buf, 8);

      i += tab->run;
      if (i < 64)
	goto normal_code;

      // escape code

      i += UBITS (bit_buf << 6, 6) - 64;
      if (i >= 64)
	break;  // illegal, but check needed to avoid buffer overflow

      j = scan[i];

      DUMPBITS (bit_buf, bits, 12);
      NEEDBITS (bs,bit_buf, bits);
      val = SBITS (bit_buf, 8);
      if (! (val & 0x7f)) {
	DUMPBITS (bit_buf, bits, 8);
	val = UBITS (bit_buf, 8) + 2 * val;
      }
      val = DequantizeIntra(val,quantizer_scale,quant_matrix[i]);

      Saturate(val);
      coeff[j] = val;

      DUMPBITS (bit_buf, bits, 8);
      NEEDBITS (bs,bit_buf, bits);

      continue;

    } else if (bit_buf >= 0x02000000) {
      tab = DCT_B14_10 - 8 + UBITS (bit_buf, 10);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00800000) {
      tab = DCT_13 - 16 + UBITS (bit_buf, 13);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00200000) {
      tab = DCT_15 - 16 + UBITS (bit_buf, 15);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else {
      tab = DCT_16 + UBITS (bit_buf, 16);
      bit_buf <<= 16;
      bit_buf |= bs.GetNextWord() << (bits + 16);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    }
    break;  // illegal, but check needed to avoid buffer overflow
  }
  DUMPBITS (bit_buf, bits, 2);        // dump end of block code

  bs.RestoreFromLocal(bit_buf,bits);
}




static void get_mpeg1_non_intra_block(class FastBitBuf& bs,short* coeff,const int* scan,
				      int quantizer_scale,
				      const int* quant_matrix)
{
  int i;
  int j;
  int val;
  DCTtabb * tab;
  uint32 bit_buf;
  int bits;

  i = -1;

  bs.MakeLocalCopy(bit_buf,bits);

  NEEDBITS (bs,bit_buf, bits);
  if (bit_buf >= 0x28000000) {
    tab = DCT_B14DC_5 - 5 + UBITS (bit_buf, 5);
    goto entry_1;
  } else
    goto entry_2;

  while (1) {
    if (bit_buf >= 0x28000000) {

      tab = DCT_B14AC_5 - 5 + UBITS (bit_buf, 5);

    entry_1:
      i += tab->run;
      if (i >= 64)
	break;  // end of block

    normal_code:
      j = scan[i];
      bit_buf <<= tab->len;
      bits += tab->len + 1;
      val = DequantizeInter(tab->level,quantizer_scale,quant_matrix[i]);

      // if (bitstream_get (1)) val = -val;
      val = (val ^ SBITS (bit_buf, 1)) - SBITS (bit_buf, 1);

      Saturate (val);
      coeff[j] = val;

      bit_buf <<= 1;
      NEEDBITS (bs,bit_buf, bits);

      continue;

    }

  entry_2:
    if (bit_buf >= 0x04000000) {

      tab = DCT_B14_8 - 4 + UBITS (bit_buf, 8);

      i += tab->run;
      if (i < 64)
	goto normal_code;

      // escape code

      i += UBITS (bit_buf << 6, 6) - 64;
      if (i >= 64)
	break;  // illegal, but check needed to avoid buffer overflow

      j = scan[i];

      DUMPBITS (bit_buf, bits, 12);
      NEEDBITS (bs,bit_buf, bits);
      val = SBITS (bit_buf, 8);
      if (! (val & 0x7f)) {
	DUMPBITS (bit_buf, bits, 8);
	val = UBITS (bit_buf, 8) + 2 * val;
      }
      val = DequantizeInter(val + SBITS (val, 1),quantizer_scale,quant_matrix[i]);

      Saturate (val);
      coeff[j] = val;

      DUMPBITS (bit_buf, bits, 8);
      NEEDBITS (bs,bit_buf, bits);

      continue;

    } else if (bit_buf >= 0x02000000) {
      tab = DCT_B14_10 - 8 + UBITS (bit_buf, 10);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00800000) {
      tab = DCT_13 - 16 + UBITS (bit_buf, 13);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00200000) {
      tab = DCT_15 - 16 + UBITS (bit_buf, 15);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else {
      tab = DCT_16 + UBITS (bit_buf, 16);
      bit_buf <<= 16;
      bit_buf |= bs.GetNextWord() << (bits + 16);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    }
    break;  // illegal, but check needed to avoid buffer overflow
  }
  DUMPBITS (bit_buf, bits, 2);        // dump end of block code
  bs.RestoreFromLocal(bit_buf,bits);
}


static void get_intra_block_B14(class FastBitBuf& bs,short* coeff,const int* scan,
				int quantizer_scale,
				const int* quant_matrix)
{
  int i;
  int j;
  int val;
  int mismatch;
  DCTtabb * tab;
  uint32 bit_buf;
  int bits;

  i = 0;
  mismatch = ~coeff[0];

  bs.MakeLocalCopy(bit_buf,bits);

  NEEDBITS (bs,bit_buf, bits);

  while (1) {
    if (bit_buf >= 0x28000000) {

      tab = DCT_B14AC_5 - 5 + UBITS (bit_buf, 5);

      i += tab->run;
      if (i >= 64)
	break;  // end of block

    normal_code:
      j = scan[i];
      bit_buf <<= tab->len;
      bits += tab->len + 1;
      val = DequantizeIntra(tab->level , quantizer_scale , quant_matrix[i]);

      // if (bitstream_get (1)) val = -val;
      val = (val ^ SBITS (bit_buf, 1)) - SBITS (bit_buf, 1);

      Saturate (val);
      coeff[j] = val;
      mismatch ^= val;

      bit_buf <<= 1;
      NEEDBITS (bs,bit_buf, bits);

      continue;

    } else if (bit_buf >= 0x04000000) {

      tab = DCT_B14_8 - 4 + UBITS (bit_buf, 8);

      i += tab->run;
      if (i < 64)
	goto normal_code;

      // escape code

      i += UBITS (bit_buf << 6, 6) - 64;
      if (i >= 64)
	break;  // illegal, but check needed to avoid buffer overflow

      j = scan[i];

      DUMPBITS (bit_buf, bits, 12);
      NEEDBITS (bs,bit_buf, bits);
      val = DequantizeIntra(SBITS (bit_buf, 12) , quantizer_scale , quant_matrix[i]);

      Saturate(val);
      coeff[j] = val;
      mismatch ^= val;

      DUMPBITS (bit_buf, bits, 12);
      NEEDBITS (bs,bit_buf, bits);

      continue;

    } else if (bit_buf >= 0x02000000) {
      tab = DCT_B14_10 - 8 + UBITS (bit_buf, 10);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00800000) {
      tab = DCT_13 - 16 + UBITS (bit_buf, 13);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00200000) {
      tab = DCT_15 - 16 + UBITS (bit_buf, 15);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else {
      tab = DCT_16 + UBITS (bit_buf, 16);
      bit_buf <<= 16;
      bit_buf |= bs.GetNextWord () << (bits + 16);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    }
    break;  // illegal, but check needed to avoid buffer overflow
  }
  coeff[63] ^= mismatch & 1;
  DUMPBITS (bit_buf, bits, 2);        // dump end of block code
  bs.RestoreFromLocal(bit_buf,bits);
}


static void get_intra_block_B15(class FastBitBuf& bs,short* coeff,const int* scan,
				int quantizer_scale,
				const int* quant_matrix)
{
  int i;
  int j;
  int val;
  int mismatch;
  DCTtabb * tab;
  uint32 bit_buf;
  int bits;

  i = 0;
  mismatch = ~coeff[0];

  bs.MakeLocalCopy(bit_buf,bits);

  NEEDBITS (bs,bit_buf, bits);

  while (1) {
    if (bit_buf >= 0x04000000) {

      tab = DCT_B15_8 - 4 + UBITS (bit_buf, 8);

      i += tab->run;
      if (i < 64) {

      normal_code:
	j = scan[i];
	bit_buf <<= tab->len;
	bits += tab->len + 1;
	val = DequantizeIntra(tab->level , quantizer_scale , quant_matrix[i]);

	// if (bitstream_get (1)) val = -val;
	val = (val ^ SBITS (bit_buf, 1)) - SBITS (bit_buf, 1);

	Saturate(val);
	coeff[j] = val;
	mismatch ^= val;

	bit_buf <<= 1;
	NEEDBITS (bs,bit_buf, bits);

	continue;

      } else {

	// end of block. I commented out this code because if we
	// dont exit here we will still exit at the later test :)

	//if (i >= 128) break;  // end of block

	// escape code

	i += UBITS (bit_buf << 6, 6) - 64;
	if (i >= 64)
	  break;      // illegal, but check against buffer overflow

	j = scan[i];

	DUMPBITS (bit_buf, bits, 12);
	NEEDBITS (bs,bit_buf, bits);
	val = DequantizeIntra(SBITS (bit_buf, 12) , quantizer_scale , quant_matrix[i]);

	Saturate(val);
	coeff[j] = val;
	mismatch ^= val;

	DUMPBITS (bit_buf, bits, 12);
	NEEDBITS (bs,bit_buf, bits);

	continue;

      }
    } else if (bit_buf >= 0x02000000) {
      tab = DCT_B15_10 - 8 + UBITS (bit_buf, 10);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00800000) {
      tab = DCT_13 - 16 + UBITS (bit_buf, 13);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00200000) {
      tab = DCT_15 - 16 + UBITS (bit_buf, 15);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else {
      tab = DCT_16 + UBITS (bit_buf, 16);
      bit_buf <<= 16;
      bit_buf |= bs.GetNextWord() << (bits + 16);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    }
    break;  // illegal, but check needed to avoid buffer overflow
  }
  coeff[63] ^= mismatch & 1;
  DUMPBITS (bit_buf, bits, 4);        // dump end of block code
  bs.RestoreFromLocal(bit_buf,bits);
}


static void get_non_intra_block(class FastBitBuf& bs,short* coeff,const int* scan,
				int quantizer_scale,
				const int* quant_matrix)
{
  int i;
  int j;
  int val;
  int mismatch;
  DCTtabb * tab;
  uint32 bit_buf;
  int bits;

  i = -1;
  mismatch = 1;

  bs.MakeLocalCopy(bit_buf,bits);

  NEEDBITS (bs,bit_buf, bits);
  if (bit_buf >= 0x28000000) {
    tab = DCT_B14DC_5 - 5 + UBITS (bit_buf, 5);
    goto entry_1;
  } else
    goto entry_2;

  while (1) {
    if (bit_buf >= 0x28000000) {

      tab = DCT_B14AC_5 - 5 + UBITS (bit_buf, 5);

    entry_1:
      i += tab->run;
      if (i >= 64)
	break;  // end of block

    normal_code:
      j = scan[i];
      bit_buf <<= tab->len;
      bits += tab->len + 1;
      val = DequantizeInter(tab->level , quantizer_scale , quant_matrix[i]);

      // if (bitstream_get (1)) val = -val;
      val = (val ^ SBITS (bit_buf, 1)) - SBITS (bit_buf, 1);

      Saturate(val);
      coeff[j] = val;
      mismatch ^= val;

      bit_buf <<= 1;
      NEEDBITS (bs,bit_buf, bits);

      continue;

    }

  entry_2:
    if (bit_buf >= 0x04000000) {

      tab = DCT_B14_8 - 4 + UBITS (bit_buf, 8);

      i += tab->run;
      if (i < 64)
	goto normal_code;

      // escape code

      i += UBITS (bit_buf << 6, 6) - 64;
      if (i >= 64)
	break;  // illegal, but check needed to avoid buffer overflow

      j = scan[i];

      DUMPBITS (bit_buf, bits, 12);
      NEEDBITS (bs,bit_buf, bits);
      val = DequantizeInter(SBITS (bit_buf, 12) + SBITS (bit_buf, 1) , quantizer_scale, quant_matrix[i]);

      Saturate(val);
      coeff[j] = val;
      mismatch ^= val;

      DUMPBITS (bit_buf, bits, 12);
      NEEDBITS (bs,bit_buf, bits);

      continue;

    } else if (bit_buf >= 0x02000000) {
      tab = DCT_B14_10 - 8 + UBITS (bit_buf, 10);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00800000) {
      tab = DCT_13 - 16 + UBITS (bit_buf, 13);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else if (bit_buf >= 0x00200000) {
      tab = DCT_15 - 16 + UBITS (bit_buf, 15);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    } else {
      tab = DCT_16 + UBITS (bit_buf, 16);
      bit_buf <<= 16;
      bit_buf |= bs.GetNextWord () << (bits + 16);
      i += tab->run;
      if (i < 64)
	goto normal_code;
    }
    break;  // illegal, but check needed to avoid buffer overflow
  }
  coeff[63] ^= mismatch & 1;
  DUMPBITS (bit_buf, bits, 2);        // dump end of block code
  bs.RestoreFromLocal(bit_buf,bits);
}


// -------------------------------------------------------------------------------------------
//                                        Syntax-Decoder
// -------------------------------------------------------------------------------------------

#define NOBZERO 0

inline void DIV2(int& x) { if (x>=0) x/=2; else x=(x-1)/2; }

/*
  implemented syntax elements:   ( - not, o partial, + full )
  - video_sequence: o
  - sequence_header: +
  - extension_and_user_data: o
  - extension_data: o
  - user_data: -
  - sequence_extension: +
  - sequence_display_extension: -
  - sequence_scalable_extension: -
  - group_of_pictures_header: +
  - picture_header: + (excluding extra_information_picture)
  - picture_coding_extension: +
  - quant_matrix_extension: -
  - picture_display_extension: -
  - picture_temporal_scalable_extension: -
  - picture_spatial_scalable_extension: -
  - copyright_extension: -
  - picture_data: +
  - slice: +
  - macroblock: +
  - macroblock_modes: o
  - motion_vectors: +
  - motion_vector: +
  - coded_block_pattern: +
  - block: +
*/


static const int qcode2qscale[2][32] =
{
//  - 1 2 3 4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29  30  31
  { 0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58, 60, 62 },
  { 0,1,2,3,4, 5, 6, 7, 8,10,12,14,16,18,20,22,24,28,32,36,40,44,48,52,56,64,72,80,88,96,104,112 }
};


static const int scan[2][64] =
{
  { /* Zig-Zag scan pattern  */
    0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,
    12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,
    35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,
    58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63
  },
  { /* Alternate scan pattern */
    0,8,16,24,1,9,2,10,17,25,32,40,48,56,57,49,
    41,33,26,18,3,11,4,12,19,27,34,42,50,58,35,43,
    51,59,20,28,5,13,6,14,21,29,36,44,52,60,37,45,
    53,61,22,30,7,15,23,31,38,46,54,62,39,47,55,63
  }
};


static const int AlternateFromZigZag[64] =
{
// 0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15
   0, 2, 3, 9, 1, 4, 5, 7, 8,11,10,20,21,35,36,34,
  22,19,18,12, 6,13,14,16,17,24,23,33,37,48,32,38,
  47,49,25,31,15,26,27,29,30,40,39,46,50,57,45,51,
  56,58,41,44,28,42,43,53,52,55,59,62,54,60,61,63
};


VideoSyntaxTrace_Options::VideoSyntaxTrace_Options()
{
  Trace_SeqH =
  Trace_GOPH =
  Trace_PicH =
  Trace_SlcH =
  Trace_MB   =
  Trace_SliceData = false;
  Trace_DCTCoeff  = false;
}


VideoFrameSkip_Options::VideoFrameSkip_Options()
{
  DecodeI = true;
  DecodeP = true;
  DecodeB = true;
}


VideoDecoder::VideoDecoder(class PacketSource& source)
  : d_source(&source),
    d_sink(NULL),
    d_picdata(NULL),
    d_SequenceHeaderRead(false),
    d_next_packet(NULL),
    d_BFrameAvailable(false),
    d_FirstFieldInFrame(true),
    d_next_IsEmpty(true),
    d_skip_this_frame(false),
    d_curr(NULL), d_next(NULL), d_last(NULL),
    d_motcomp(NULL)
{
  d_motcomp = MotionCompensation_SglMB::Create();

#if MMX_DCT
  for (int i=0;i<2;i++)
    for (int n=0;n<64;n++)
      {
	int r=scan[i][n]/8;
	int c=scan[i][n]%8;
	d_scan[i][n]=c*8+r;
      }
#else
  for (int i=0;i<2;i++)
    for (int n=0;n<64;n++)
      d_scan[i][n]=scan[i][n];
#endif
}

VideoDecoder::~VideoDecoder()
{
  if (d_next_packet)
    delete d_next_packet;

  if (d_motcomp) delete d_motcomp;
}

SysPacket_Packet* VideoDecoder::GetNextPacket()
{
  SysPacket_Packet* pck;

  if (d_next_packet)
    {
      pck = d_next_packet;
      d_next_packet=NULL;
    }
  else
    {
      pck = d_source->GetNextPacket();
      if (pck==NULL)
        return NULL;
    }

  return pck;
}

void VideoDecoder::PushbackPacket(SysPacket_Packet* pck)
{
  Assert(d_next_packet==NULL);
  d_next_packet=pck;
}

bool VideoDecoder::DecodeAFrame()
{
  int  LastSliceRead = 0;
  bool BeganPictureDecoding = false;

  for (;;) // Read as much packets as are required to decode a picture.
    {
      // Get next stream packet.

      SysPacket_Packet* pck = GetNextPacket();
      if (pck==NULL)
        {
	  // We reached the end of the stream. Flush the remaining images.

	  // B-picture
	  if (d_BFrameAvailable)
	    {
	      Assert(d_curr);

#if SEND_FULL_BFRAMES
	      d_curr->m_may_modify = true;
	      d_sink->ShowAllMBRows(d_curr);  // Show image
#endif
	      d_sink->FinishedPicture();
	      d_curr->FreePictureData();      // Remove additional information data
	      
	      delete d_curr;
	      d_curr=NULL;
	      d_BFrameAvailable=false;

	      return true;
	    }

	  // Future reference picture
	  if (!d_next_IsEmpty)
	    {
	      d_next->m_may_modify = true;

	      d_sink->BeginPicture(d_next);
	      d_sink->ShowAllMBRows(d_next); // Show last decoded I- or P-image.
	      d_sink->FinishedPicture();
	      d_next->FreePictureData();     // Free the additional information data.
	      
	      delete d_last;
	      delete d_next;
	      d_last = d_next = NULL;

	      d_next_IsEmpty=true;
	    }

          return false;
        }


      // Decode packet data.

      BitReader bitstream(pck->data.AskContents() , pck->data.AskLength());


      uint32 startcode = bitstream.PeekBits(32);

      Assert((startcode & 0x00000100) != 0); // TODO: throw excpt

      if (IsMPEG_SLICE_START(startcode&0xFF) && d_SequenceHeaderRead && BeganPictureDecoding)
        {
          if (d_options.Trace_SliceData)
            {
              cerr << "Slice Data:\n";
              PrintDataBin(pck->data.AskContents(),pck->data.AskLength());
            }

	  FastBitBuf fastbitbuf(pck->data.AskContents() , pck->data.AskLength());
          DecodeSlice(fastbitbuf);
        }
      else
        {
	  // If we were just decoding a picture and a new picture begins, end decoding of the picture.

	  if ((startcode == STARTCODE_SEQUENCE_HEADER ||
	       startcode == STARTCODE_GROUP_START ||
	       startcode == STARTCODE_PICTURE_START) &&
	      BeganPictureDecoding)
	    {
	      PushbackPacket(pck); // This packet already belongs to the next picture.

	      /* If there's an B-image ready for display, show it.
	       */

	      if (d_BFrameAvailable)
		{
		  Assert(d_curr);
	      
#if SEND_FULL_BFRAMES
		  d_curr->m_may_modify=true;
		  d_sink->ShowAllMBRows(d_curr);  // Show image
#endif
		  d_sink->FinishedPicture();
		  d_curr->FreePictureData();         // Remove additional information data
		  d_BFrameAvailable=false;
		}

	      return true;
	    }


	  switch (startcode)
	    {
	    case STARTCODE_SEQUENCE_HEADER:
	      {
		DecodeSequenceHeader(bitstream,d_seqdata,d_quant_zz);
		d_SequenceHeaderRead=true;

		// Try to read Sequence-Extension.
		
		SysPacket_Packet* pck = GetNextPacket();
		if (pck)
		  {
		    BitReader bs(pck->data.AskContents() , pck->data.AskLength());
    
		    uint32 startcode = bs.GetBits(32);
		    if (startcode==STARTCODE_EXTENSION_START)
		      {
			if (bs.GetBits(4)==EXTID_SequenceExtension)
			  DecodeSequenceHeaderExt(bs,d_seqdata);

			delete pck;
		      }
		    else
		      PushbackPacket(pck);
		  }

		// Allocate images and precalculate some values.
		
		PostSequenceHeader();

		if (d_options.Trace_SeqH)
		  TraceSequenceHeader(d_seqdata);
	      }
	      break;

	    case STARTCODE_GROUP_START:
	      {
		GOPHeader gopdata;
		DecodeGOPHeader(bitstream,gopdata);

		if (d_options.Trace_GOPH)
		  TraceGOPHeader(gopdata);
	      }
	      break;

	    case STARTCODE_PICTURE_START:
	      if (d_SequenceHeaderRead)
		{
		  DecodePictureHeader(bitstream,d_pichdr);
		  BeganPictureDecoding=true;

		  // Try to read Picture-Coding-Extension.

		  SysPacket_Packet* pck2 = GetNextPacket();
		  if (pck2)
		    {
		      BitReader bs(pck2->data.AskContents() , pck2->data.AskLength());
    
		      uint32 startcode = bs.GetBits(32);
		      if (startcode==STARTCODE_EXTENSION_START)
			{
			  if (bs.GetBits(4)==EXTID_PictureCodingExtension)
			    DecodePictureCodingExt(bs,d_pichdr);

			  delete pck2;
			}
		      else
			PushbackPacket(pck2);
		    }

		  DecodeExtensions(2);

		  // Do some precalculations, pointer settings...

		  PostPictureHeader(pck->timing);

		  if (d_options.Trace_PicH)
		    TracePictureHeader(d_pichdr);
		}
	      break;

#if 0
	    case STARTCODE_EXTENSION_START:
	      bitstream.SkipBits(32);
	      switch (bitstream.GetBits(4))
		{
		case EXTID_SequenceExtension: DecodeSequenceExtension(bitstream); break;

		default:
		  //assert(0);
		  break;
		}
	      break;

	    case STARTCODE_ISO11172_END:
	      Assert(0); /* TODO: check: I think we'll never see this as this is thrown away because
			    it's a syntax stream element.
			 */

              //Append(d_next);
              
	      break;
#endif
	    default:
	      break;
	    }
	}

      delete pck;
    }

  return true;
}



void VideoDecoder::PostSequenceHeader()
{
  d_IsMPEG2 = d_seqdata.m_IsMPEG2;

  d_ChromaFormat = d_seqdata.m_ChromaFormat;
  switch (d_ChromaFormat)
    {
    case CHROMA_420: d_dctblks= 6; d_intra_cbp=0xFC0; mb_chr_w= 8; mb_chr_h= 8; break;
    case CHROMA_422: d_dctblks= 8; d_intra_cbp=0xFF0; mb_chr_w= 8; mb_chr_h=16; break;
    case CHROMA_444: d_dctblks=12; d_intra_cbp=0xFFF; mb_chr_w=16; mb_chr_h=16; break;
    }

  d_MBWidth  = d_seqdata.m_MBWidth =(d_seqdata.m_Width +15)/16;
  d_MBHeight = d_seqdata.m_MBHeight=(d_seqdata.m_Height+15)/16;

  ImageParam param;
  if (d_last) param=d_last->m_image.Image<Pixel>::AskParam();
  if (!d_last ||
      param.width  != d_seqdata.m_Width ||
      param.height != d_seqdata.m_Height)
    {
      specs.width  = d_seqdata.m_Width;
      specs.height = d_seqdata.m_Height;
      specs.halign = 16;
      specs.valign = 16;
      specs.colorspace = Colorspace_YUV;
      //specs.exact_size = true;
      //specs.reduced_chroma_size = true;
      switch (d_seqdata.m_ChromaFormat)
        {
        case CHROMA_444: specs.chroma = Chroma_444; break;
        case CHROMA_422: specs.chroma = Chroma_422; break;
        case CHROMA_420: specs.chroma = Chroma_420; break;
        }

      Assert(d_sink != NULL);
      if (d_last) delete d_last;
      if (d_curr) delete d_curr;
      if (d_next) delete d_next;

      d_last=d_curr=d_next=NULL;

      d_last = new DecodedImageData; d_last->m_image.Create(specs);
      d_next = new DecodedImageData; d_next->m_image.Create(specs);
      d_curr = new DecodedImageData; d_curr->m_image.Create(specs);

      for (int i=0;i<2;i++)
	{
	  d_last->m_fields[i] = d_last->m_image.CreateFieldView(i==0);
	  d_next->m_fields[i] = d_next->m_image.CreateFieldView(i==0);
	  d_curr->m_fields[i] = d_curr->m_image.CreateFieldView(i==0);
	}

      d_last->m_width  = d_next->m_width  = d_curr->m_width  = specs.width;
      d_last->m_height = d_next->m_height = d_curr->m_height = specs.height;

      bytesperline_lum = d_last->m_image.AskBitmap(Bitmap_Y ).AskTotalWidth();
      bytesperline_chr = d_last->m_image.AskBitmap(Bitmap_Cr).AskTotalWidth();
    }
}


inline void VideoDecoder::SetSPOffsets(TempRef sp_tempref,int n,  // predictor of which direction
				       TempRef predref,bool field,bool topfield) // physical location
{
  Pixel **spy,**spcr,**spcb;
  if (sp_tempref==LAST) { spy=&sp_last_y[n]; spcr=&sp_last_cr[n]; spcb=&sp_last_cb[n]; }
  else                  { spy=&sp_next_y[n]; spcr=&sp_next_cr[n]; spcb=&sp_next_cb[n]; }

  DecodedImageData* buf;
  if (predref==LAST) { buf=d_last; } else { buf=d_next; }

  if (field)
    {
      *spy  = buf->m_fields[topfield ? 0 : 1].AskBitmap(Bitmap_Y ).AskFrame()[0];
      *spcr = buf->m_fields[topfield ? 0 : 1].AskBitmap(Bitmap_Cr).AskFrame()[0];
      *spcb = buf->m_fields[topfield ? 0 : 1].AskBitmap(Bitmap_Cb).AskFrame()[0];
    }
  else
    {
      *spy  = buf->m_image.AskFrameY()[0];
      *spcr = buf->m_image.AskFrameU()[0];
      *spcb = buf->m_image.AskFrameV()[0];
    }
}

#include <sys/time.h>
#include <unistd.h>

void VideoDecoder::PostPictureHeader(const SystemTimingInformation& timing)
{
  if (0)
  {
    struct timeval tv;
    static struct timeval last_tv;
    gettimeofday(&tv,NULL);

    static int cnt=0;
    long sec_diff = tv.tv_sec - last_tv.tv_sec;
    long udiff = sec_diff * 1000000;
    udiff += tv.tv_usec-last_tv.tv_usec;

    if (cnt>0)
      cerr << cnt << " " << udiff << "\n";

    cnt++;
    last_tv=tv;
  }

  // Make some consistency checks to see if input stream is MPEG-2 compliant.

  if (d_IsMPEG2)
    {
      if (1) //options.WarnOnFalseMPEG1Fields)
        {
          if (d_pichdr.m_fullpel_fw != 0)
            {
              //Error(ErrSev_Warning,
	      //"Error in input stream (ignored): fullpel-forward motionvector requested.\n");
            }
          if (d_pichdr.m_fullpel_bw != 0)
            {
              //Error(ErrSev_Warning,
	      //"Error in input stream (ignored): fullpel-backward motionvector requested.\n");
            }
          if (d_pichdr.m_fcode[0][0] != 7)
            {
              //Error(ErrSev_Warning,
	      //"Error in input stream (ignored): forward fcode is not '7'\n");
            }
          if (d_pichdr.m_fcode[1][0] != 7)
            {
              //Error(ErrSev_Warning,
	      //"Error in input stream (ignored): backward fcode is not '7'\n");
            }
        }
    }

  d_dc_pred = (1<<(d_pichdr.m_intra_dc_precision-1));


#ifndef NDEBUG
  if (d_options.Trace_PicH)
    {
      if (timing.HasPTS) cerr << "Picture-Header-PTS: " << ((unsigned long)timing.pts) << endl;
    }
#endif


  // Order quantization matrix coefficients

  if (d_pichdr.m_alternate_scan)
    {
      for (int i=0;i<64;i++)
	{
	  d_quant_bs.m_LumIntra[i] = d_quant_zz.m_LumIntra[AlternateFromZigZag[i]];
	  d_quant_bs.m_LumInter[i] = d_quant_zz.m_LumInter[AlternateFromZigZag[i]];
	  d_quant_bs.m_ChrIntra[i] = d_quant_zz.m_ChrIntra[AlternateFromZigZag[i]];
	  d_quant_bs.m_ChrInter[i] = d_quant_zz.m_ChrInter[AlternateFromZigZag[i]];
	}
    }
  else
    {
      memcpy(d_quant_bs.m_LumIntra,d_quant_zz.m_LumIntra,64*sizeof(int));
      memcpy(d_quant_bs.m_LumInter,d_quant_zz.m_LumInter,64*sizeof(int));
      memcpy(d_quant_bs.m_ChrIntra,d_quant_zz.m_ChrIntra,64*sizeof(int));
      memcpy(d_quant_bs.m_ChrInter,d_quant_zz.m_ChrInter,64*sizeof(int));
    }

  d_scalability_mode = No_Scalability;

  if (d_pichdr.m_picture_structure == PICSTRUCT_BottomField)
    d_field_offset = 1;
  else
    d_field_offset = 0;


  // ------------------- Now the Picture-Header is completely decoded. ---------------------

  // ------------------- Semantic actions follow. ------------------------------------------


  Assert(d_sink);

  const bool IsANewFrame = (d_pichdr.m_picture_structure == PICSTRUCT_FramePicture || d_FirstFieldInFrame);

  /* Do not display images of disabled types.
   */
  if (IsANewFrame)
    {
      d_skip_this_frame =
	(!d_options.DecodeB && d_pichdr.m_picture_coding_type == PICTYPE_B) ||
	(!d_options.DecodeP && d_pichdr.m_picture_coding_type != PICTYPE_I);
	
      // /* ShallISkipThis() */ false;
    }

  if (d_skip_this_frame)
    {
      d_FirstFieldInFrame = !d_FirstFieldInFrame;
      return;
    }
    

  /* If a new I- or P-image starts, show the last decoded I- or P- frame and
     move to d_last-buffer.
  */

  if (IsANewFrame &&
      (d_pichdr.m_picture_coding_type == PICTYPE_I ||
       d_pichdr.m_picture_coding_type == PICTYPE_P))
    {
      if (!d_next_IsEmpty)
        {
	  d_next->m_may_modify=false;
	  d_sink->BeginPicture(d_next);
          d_sink->ShowAllMBRows(d_next); // Show last decoded I- or P-image.
	  d_sink->FinishedPicture();
	  d_next->FreePictureData();     // Free the additional information data.

	  swap(d_last,d_next);    // Old forward prediction image becomes new backward prefiction.
        }
    }


  // Decode a new picture.

  if (d_pichdr.m_picture_structure == PICSTRUCT_FramePicture)
    {
      if (d_pichdr.m_picture_coding_type == PICTYPE_I ||
          d_pichdr.m_picture_coding_type == PICTYPE_P)
        {
	  d_next->m_timing = timing;

          ptr_y  = d_next->m_image.AskFrameY();
          ptr_cr = d_next->m_image.AskFrameU();
          ptr_cb = d_next->m_image.AskFrameV();

	  if (d_pichdr.m_picture_coding_type==PICTYPE_P)
	    {
	      Assert(d_last);
	      SetSPOffsets(LAST,0,       // forward prediction get its data from
			   LAST,false);  // the last frame
	    }

          lineskip_lum = bytesperline_lum;
          lineskip_chr = bytesperline_chr;

          d_next_IsEmpty=false;
        }
      else  // B-picture
        {
	  d_curr->m_timing = timing;

          ptr_y  = d_curr->m_image.AskFrameY();
          ptr_cr = d_curr->m_image.AskFrameU();
          ptr_cb = d_curr->m_image.AskFrameV();

	  SetSPOffsets(LAST,0, LAST,false);  // forward prediction from last frame
	  SetSPOffsets(NEXT,0, NEXT,false);  // backward prediction from next frame

          lineskip_lum = bytesperline_lum;
          lineskip_chr = bytesperline_chr;

          d_BFrameAvailable=true;

	  d_sink->BeginPicture(d_curr);
        }

      d_FirstFieldInFrame=true;
    }

  // ---------------- field pictures ---------------

  else if (d_pichdr.m_picture_coding_type == PICTYPE_I ||
	   d_pichdr.m_picture_coding_type == PICTYPE_P)
    {
      if (d_FirstFieldInFrame)
        {
          bool topfield = (d_pichdr.m_picture_structure==PICSTRUCT_TopField);
          ptr_y  = d_next->m_fields[topfield?0:1].AskBitmap(Bitmap_Y).AskFrame();
          ptr_cr = d_next->m_fields[topfield?0:1].AskBitmap(Bitmap_U).AskFrame();
          ptr_cb = d_next->m_fields[topfield?0:1].AskBitmap(Bitmap_V).AskFrame();

	  Assert(IsANewFrame);
	  d_next->m_timing = timing;

	  if (d_pichdr.m_picture_coding_type == PICTYPE_P)
	    {
	      SetSPOffsets(LAST,0, LAST,true,true);  // backward prediction from last fields
	      SetSPOffsets(LAST,1, LAST,true,false);
	    }

          lineskip_lum = bytesperline_lum*2;
          lineskip_chr = bytesperline_chr*2;

          d_next_IsEmpty=false;
          d_FirstFieldInFrame=false;
        }
      else
        {
          bool topfield = (d_pichdr.m_picture_structure==PICSTRUCT_TopField);
          ptr_y  = d_next->m_fields[topfield?0:1].AskBitmap(Bitmap_Y).AskFrame();
          ptr_cr = d_next->m_fields[topfield?0:1].AskBitmap(Bitmap_U).AskFrame();
          ptr_cb = d_next->m_fields[topfield?0:1].AskBitmap(Bitmap_V).AskFrame();

	  if (d_pichdr.m_picture_coding_type == PICTYPE_P)
	    {
	      if (topfield)
		{
		  SetSPOffsets(LAST,0, LAST,true,true);  // top-field prediction from last frame
		  SetSPOffsets(LAST,1, NEXT,true,false); // bottom-field prediction from current frame
		}
	      else
		{
		  SetSPOffsets(LAST,0, NEXT,true,true);  // top-field prediction from current frame
		  SetSPOffsets(LAST,1, LAST,true,false); // bottom-field prediction from last frame
		}
	    }

          lineskip_lum = bytesperline_lum*2;
          lineskip_chr = bytesperline_chr*2;

          //d_next_IsEmpty=false;
          d_FirstFieldInFrame=true;
        }
    }
  else // B-Field
    {
      bool topfield = (d_pichdr.m_picture_structure==PICSTRUCT_TopField);
      ptr_y  = d_curr->m_fields[topfield?0:1].AskBitmap(Bitmap_Y).AskFrame();
      ptr_cr = d_curr->m_fields[topfield?0:1].AskBitmap(Bitmap_U).AskFrame();
      ptr_cb = d_curr->m_fields[topfield?0:1].AskBitmap(Bitmap_V).AskFrame();

      SetSPOffsets(LAST,0, LAST,true,true);  // forward prediction from last frame
      SetSPOffsets(NEXT,0, NEXT,true,true);
      SetSPOffsets(LAST,1, LAST,true,false); // backward prediction from next frame
      SetSPOffsets(NEXT,1, NEXT,true,false);

      lineskip_lum = bytesperline_lum*2;
      lineskip_chr = bytesperline_chr*2;

      if (d_FirstFieldInFrame)
	{ d_sink->BeginPicture(d_curr); }

      if (!d_FirstFieldInFrame)
        d_BFrameAvailable=true;
  
      d_FirstFieldInFrame = !d_FirstFieldInFrame;
    }


  sp_curr_y  = ptr_y[0];
  sp_curr_cb = ptr_cb[0];
  sp_curr_cr = ptr_cr[0];


  // create PictureData if needed

  if (1) // d_sink->NeedsPictureData(d_pichdr.m_picture_coding_type))
    {
      DecodedImageData* img2decode=NULL;

      if (d_pichdr.m_picture_coding_type == PICTYPE_I ||
	  d_pichdr.m_picture_coding_type == PICTYPE_P)
	{ img2decode=d_next; }
      else
	{ img2decode=d_curr; }


      int mbw=0,mbh=0;
      if (d_sink->NeedsMBData(d_pichdr.m_picture_coding_type))
	{ mbw=d_MBWidth; mbh=d_MBHeight; }

      if (d_pichdr.m_picture_structure == PICSTRUCT_FramePicture ||
	  d_FirstFieldInFrame)
	{
	  Assert(img2decode->m_picdata1==NULL);
	  if (mbw) d_picdata = img2decode->m_picdata1 = PictureData::GetPictureData(mbw,mbh);
	  img2decode->m_pichdr1 = d_pichdr;
	}
      else
	{
	  Assert(img2decode->m_picdata2==NULL);
	  if (mbw) d_picdata = img2decode->m_picdata2 = PictureData::GetPictureData(mbw,mbh);
	  img2decode->m_pichdr2 = d_pichdr;
	}

      // *((PictureHeader*)d_picdata) = d_pichdr;
    }
  else
    { d_picdata=NULL; }

  /*
    cerr << "Lineskip Lum: " << lineskip_lum << " Lineskip Chr: " << lineskip_chr << endl;
    cerr << "BPL Lum: " << bytesperline_lum << " BPL Chr: " << bytesperline_chr << endl << endl;
  */
}


void VideoDecoder::DecodeExtensions(int n)
{
  for (;;)
    {
      SysPacket_Packet* pck = GetNextPacket();
      if (pck==NULL)
        return;

      BitReader bs(pck->data.AskContents() , pck->data.AskLength());
      switch (bs.PeekBits(32))
        {
        case STARTCODE_EXTENSION_START:
          // TODO
          delete pck;
          break;
        case STARTCODE_USER_DATA:
          delete pck;
          break;
        default:
          PushbackPacket(pck);
          return;
        }
    }
}




void VideoDecoder::SetReferencePtrsFrm(struct PixPtrs_const& ptrs,const struct MotionVector& mv)
{
  ptrs.y  += ( mv.m_habs   >>1) + ( mv.m_vabs   >>1)*lineskip_lum;

  if (d_ChromaFormat==CHROMA_420)
    {
      ptrs.cr += ((mv.m_habs/2)>>1) + ((mv.m_vabs/2)>>1)*lineskip_chr;
      ptrs.cb += ((mv.m_habs/2)>>1) + ((mv.m_vabs/2)>>1)*lineskip_chr;
    }
  else if (d_ChromaFormat==CHROMA_422)
    {
      ptrs.cr += ((mv.m_habs/2)>>1) + (mv.m_vabs>>1)*lineskip_chr;
      ptrs.cb += ((mv.m_habs/2)>>1) + (mv.m_vabs>>1)*lineskip_chr;
    }
  else
    {
      ptrs.cr += (mv.m_habs>>1) + (mv.m_vabs>>1)*lineskip_chr;
      ptrs.cb += (mv.m_habs>>1) + (mv.m_vabs>>1)*lineskip_chr;
    }
}


void VideoDecoder::SetReferencePtrsFld(struct PixPtrs_const& ptrs,const struct MotionVector& mv)
{
  ptrs.y  += ( mv.m_habs   >>1) + ( mv.m_vabs   >>1)*lineskip_lum*2;

  if (d_ChromaFormat==CHROMA_420)
    {
      ptrs.cr += ((mv.m_habs/2)>>1) + ((mv.m_vabs/2)>>1)*lineskip_chr*2;
      ptrs.cb += ((mv.m_habs/2)>>1) + ((mv.m_vabs/2)>>1)*lineskip_chr*2;
    }
  else if (d_ChromaFormat==CHROMA_422)
    {
      ptrs.cr += ((mv.m_habs/2)>>1) + (mv.m_vabs>>1)*lineskip_chr*2;
      ptrs.cb += ((mv.m_habs/2)>>1) + (mv.m_vabs>>1)*lineskip_chr*2;
    }
  else
    {
      ptrs.cr += (mv.m_habs>>1) + (mv.m_vabs>>1)*lineskip_chr*2;
      ptrs.cb += (mv.m_habs>>1) + (mv.m_vabs>>1)*lineskip_chr*2;
    }
}

#if 0
inline int DequantizeIntra(int value,int qscale,int matrix)
{
#if MMX_DCT
  int deq_value = value*qscale*matrix;
#else
  int deq_value = value*qscale*matrix/16;
#endif

  return deq_value;
}

inline int DequantizeInter(int value,int qscale,int matrix)
{
#if MMX_DCT
  int sign = (value>0 ? 1 : -1);
  int deq_value = (2*value+sign) * matrix * qscale / 2;
#else
  int sign = (value>0 ? 1 : -1);
  int deq_value = (2*value+sign) * matrix * qscale / 32;
#endif

  return deq_value;
}
#endif


void VideoDecoder::SetHalfPelFlags1(struct MotionCompensation_SglMB::MCData& mcdata,
				    const struct MotionVector& mv)
{
  mcdata.LumaHalfFlags    = ( mv.m_vabs   &1);    // set MC_Last_HalfV
  mcdata.LumaHalfFlags   |= ( mv.m_habs   &1)<<1; // set MC_Last_HalfH
  mcdata.ChromaHalfFlags  = ((mv.m_vabs/2)&1);    // set MC_Last_HalfV
  mcdata.ChromaHalfFlags |= ((mv.m_habs/2)&1)<<1; // set MC_Last_HalfH
}

void VideoDecoder::SetHalfPelFlags2(struct MotionCompensation_SglMB::MCData& mcdata,
				    const struct MotionVector& lastmv,
				    const struct MotionVector& nextmv)
{
  mcdata.LumaHalfFlags    = ( lastmv.m_vabs   &1);    // set MC_Last_HalfV
  mcdata.LumaHalfFlags   |= ( lastmv.m_habs   &1)<<1; // set MC_Last_HalfH
  mcdata.ChromaHalfFlags  = ((lastmv.m_vabs/2)&1);    // set MC_Last_HalfV
  mcdata.ChromaHalfFlags |= ((lastmv.m_habs/2)&1)<<1; // set MC_Last_HalfH

  mcdata.LumaHalfFlags   |= ( nextmv.m_vabs   &1)<<2; // set MC_Next_HalfV
  mcdata.LumaHalfFlags   |= ( nextmv.m_habs   &1)<<3; // set MC_Next_HalfH
  mcdata.ChromaHalfFlags |= ((nextmv.m_vabs/2)&1)<<2; // set MC_Next_HalfV
  mcdata.ChromaHalfFlags |= ((nextmv.m_habs/2)&1)<<3; // set MC_Next_HalfH
}


void VideoDecoder::MC_Frame_FrameBased(const Macroblock& mb,uint16 mb_mode)
{
  struct MotionCompensation_SglMB::MCData mcdata;
  MotionCompensation_SglMB::MCompFunc*const* mclum_func;
  MotionCompensation_SglMB::MCompFunc*const* mcchr_func;

  mcdata.bytesperline_lum = lineskip_lum;
  mcdata.bytesperline_chr = lineskip_chr;
  mcdata.blkheight=16;
  mcdata.blkheight_chr=mb_chr_h;
                    
  mcdata.currimg.y  = dp_y;
  mcdata.currimg.cr = dp_cr;
  mcdata.currimg.cb = dp_cb;

  int offs_y  = dp_y  - sp_curr_y;
  int offs_cr = dp_cr - sp_curr_cr;
  int offs_cb = dp_cb - sp_curr_cb;
  Assert(offs_cr==offs_cb);

  if ((mb_mode & (MBMODE_MVFWD|MBMODE_MVBKW))==(MBMODE_MVFWD|MBMODE_MVBKW))
    {
      mcdata.lastimg.y  = offs_y  + sp_last_y[0];
      mcdata.lastimg.cr = offs_cr + sp_last_cr[0];
      mcdata.lastimg.cb = offs_cb + sp_last_cb[0];
                        
      mcdata.nextimg.y  = offs_y  + sp_next_y[0];
      mcdata.nextimg.cr = offs_cr + sp_next_cr[0];
      mcdata.nextimg.cb = offs_cb + sp_next_cb[0];

      SetReferencePtrsFrm(mcdata.lastimg,mb.m_forward1);
      SetReferencePtrsFrm(mcdata.nextimg,mb.m_backward1);

      SetHalfPelFlags2(mcdata,mb.m_forward1,mb.m_backward1);

      mclum_func = d_motcomp->AskMCompFunc_Dbl_Luma();
      mcchr_func = d_motcomp->AskMCompFunc_Dbl_Chroma(CHROMA_420);
    }
  else
    {
      const MotionVector* mv;
      if (mb.m_HasMotionForward)
	{
	  mv = &mb.m_forward1;

	  mcdata.lastimg.y  = offs_y  + sp_last_y[0];
	  mcdata.lastimg.cr = offs_cr + sp_last_cr[0];
	  mcdata.lastimg.cb = offs_cb + sp_last_cb[0];
	}
      else
	{
	  mv = &mb.m_backward1;

	  mcdata.lastimg.y  = offs_y  + sp_next_y[0];
	  mcdata.lastimg.cr = offs_cr + sp_next_cr[0];
	  mcdata.lastimg.cb = offs_cb + sp_next_cb[0];
	}
                        
      mcdata.nextimg.y  = mcdata.nextimg.cr = mcdata.nextimg.cb = NULL;

      SetReferencePtrsFrm(mcdata.lastimg,*mv);
      SetHalfPelFlags1(mcdata,*mv);

      mclum_func = d_motcomp->AskMCompFunc_Sgl_Luma();
      mcchr_func = d_motcomp->AskMCompFunc_Sgl_Chroma(CHROMA_420);
    }

  (*(mclum_func[mcdata.LumaHalfFlags  ]))(&mcdata);
  (*(mcchr_func[mcdata.ChromaHalfFlags]))(&mcdata);
}


void VideoDecoder::MC_Frame_FieldBased(const Macroblock& mb,uint16 mb_mode)
{
  struct MotionCompensation_SglMB::MCData mcdata;
  MotionCompensation_SglMB::MCompFunc*const* mclum_func;
  MotionCompensation_SglMB::MCompFunc*const* mcchr_func;

  int offs_y  = dp_y  - sp_curr_y;
  int offs_cr = dp_cr - sp_curr_cr;
  int offs_cb = dp_cb - sp_curr_cb;
  Assert(offs_cr==offs_cb);

  for (int i=0;i<2;i++)
    {
      const MotionVector* mvfwd;
      const MotionVector* mvbkw;
      if (i==0)
	{
	  mcdata.currimg.y  = dp_y;
	  mcdata.currimg.cr = dp_cr;
	  mcdata.currimg.cb = dp_cb;
	  mvfwd = &mb.m_forward1;
	  mvbkw = &mb.m_backward1;
	}
      else
	{
	  mcdata.currimg.y  = dp_y +lineskip_lum;
	  mcdata.currimg.cr = dp_cr+lineskip_chr;
	  mcdata.currimg.cb = dp_cb+lineskip_chr;
	  mvfwd = &mb.m_forward2;
	  mvbkw = &mb.m_backward2;
	}

      if ((mb_mode & (MBMODE_MVFWD|MBMODE_MVBKW))==(MBMODE_MVFWD|MBMODE_MVBKW))
	{
	  if (mvfwd->m_vertical_field_select)
	    {
	      mcdata.lastimg.y  = offs_y  + sp_last_y[0]  + lineskip_lum;
	      mcdata.lastimg.cr = offs_cr + sp_last_cr[0] + lineskip_chr;
	      mcdata.lastimg.cb = offs_cb + sp_last_cb[0] + lineskip_chr;
	    }
	  else
	    {
	      mcdata.lastimg.y  = offs_y  + sp_last_y[0];
	      mcdata.lastimg.cr = offs_cr + sp_last_cr[0];
	      mcdata.lastimg.cb = offs_cb + sp_last_cb[0];
	    }

	  if (mvbkw->m_vertical_field_select)
	    {
	      mcdata.nextimg.y  = offs_y  + sp_next_y[0]  + lineskip_lum;
	      mcdata.nextimg.cr = offs_cr + sp_next_cr[0] + lineskip_chr;
	      mcdata.nextimg.cb = offs_cb + sp_next_cb[0] + lineskip_chr;
	    }
	  else
	    {
	      mcdata.nextimg.y  = offs_y  + sp_next_y[0];
	      mcdata.nextimg.cr = offs_cr + sp_next_cr[0];
	      mcdata.nextimg.cb = offs_cb + sp_next_cb[0];
	    }

	  SetReferencePtrsFld(mcdata.lastimg,*mvfwd);
	  SetReferencePtrsFld(mcdata.nextimg,*mvbkw);

	  SetHalfPelFlags2(mcdata,*mvfwd,*mvbkw);
                            
	  mclum_func = d_motcomp->AskMCompFunc_Dbl_Luma();
	  mcchr_func = d_motcomp->AskMCompFunc_Dbl_Chroma(CHROMA_420);
	}
      else
	{
	  const MotionVector* mv;
	  if (mb.m_HasMotionForward)
	    {
	      mv = mvfwd;
                                
	      if (mvfwd->m_vertical_field_select)
		{
		  mcdata.lastimg.y  = offs_y  + sp_last_y[0]  + lineskip_lum;
		  mcdata.lastimg.cr = offs_cr + sp_last_cr[0] + lineskip_chr;
		  mcdata.lastimg.cb = offs_cb + sp_last_cb[0] + lineskip_chr;
		}
	      else
		{
		  mcdata.lastimg.y  = offs_y  + sp_last_y[0];
		  mcdata.lastimg.cr = offs_cr + sp_last_cr[0];
		  mcdata.lastimg.cb = offs_cb + sp_last_cb[0];
		}
	    }
	  else
	    {
	      mv = mvbkw;
                                
	      if (mvbkw->m_vertical_field_select)
		{
		  mcdata.lastimg.y  = offs_y  + sp_next_y[0]  + lineskip_lum;
		  mcdata.lastimg.cr = offs_cr + sp_next_cr[0] + lineskip_chr;
		  mcdata.lastimg.cb = offs_cb + sp_next_cb[0] + lineskip_chr;
		}
	      else
		{
		  mcdata.lastimg.y  = offs_y  + sp_next_y[0];
		  mcdata.lastimg.cr = offs_cr + sp_next_cr[0];
		  mcdata.lastimg.cb = offs_cb + sp_next_cb[0];
		}
	    }
                            
	  SetReferencePtrsFld(mcdata.lastimg,*mv);
	  SetHalfPelFlags1(mcdata,*mv);
                            
	  mclum_func = d_motcomp->AskMCompFunc_Sgl_Luma();
	  mcchr_func = d_motcomp->AskMCompFunc_Sgl_Chroma(CHROMA_420);
	}

      mcdata.bytesperline_lum = lineskip_lum*2;
      mcdata.bytesperline_chr = lineskip_chr*2;
      mcdata.blkheight=8;
      mcdata.blkheight_chr=mb_chr_h/2;

      (*(mclum_func[mcdata.LumaHalfFlags]))(&mcdata);
      (*(mcchr_func[mcdata.ChromaHalfFlags]))(&mcdata);
    }
}


void VideoDecoder::MC_Field_FieldBased(const Macroblock& mb,uint16 mb_mode)
{
  struct MotionCompensation_SglMB::MCData mcdata;
  MotionCompensation_SglMB::MCompFunc*const* mclum_func;
  MotionCompensation_SglMB::MCompFunc*const* mcchr_func;

  mcdata.currimg.y  = dp_y;
  mcdata.currimg.cr = dp_cr;
  mcdata.currimg.cb = dp_cb;

  mcdata.bytesperline_lum = lineskip_lum;
  mcdata.bytesperline_chr = lineskip_chr;
  mcdata.blkheight=16;
  mcdata.blkheight_chr=mb_chr_h;

  int offs_y  = dp_y  - sp_curr_y;
  int offs_cr = dp_cr - sp_curr_cr;
  int offs_cb = dp_cb - sp_curr_cb;
  Assert(offs_cr==offs_cb);

  if ((mb_mode & (MBMODE_MVFWD|MBMODE_MVBKW))==(MBMODE_MVFWD|MBMODE_MVBKW))
    {
      mcdata.lastimg.y  = offs_y  + sp_last_y [mb.m_forward1.m_vertical_field_select];
      mcdata.lastimg.cr = offs_cr + sp_last_cr[mb.m_forward1.m_vertical_field_select];
      mcdata.lastimg.cb = offs_cb + sp_last_cb[mb.m_forward1.m_vertical_field_select];
                        
      mcdata.nextimg.y  = offs_y  + sp_next_y [mb.m_backward1.m_vertical_field_select];
      mcdata.nextimg.cr = offs_cr + sp_next_cr[mb.m_backward1.m_vertical_field_select];
      mcdata.nextimg.cb = offs_cb + sp_next_cb[mb.m_backward1.m_vertical_field_select];
                        
      SetReferencePtrsFrm(mcdata.lastimg,mb.m_forward1);
      SetReferencePtrsFrm(mcdata.nextimg,mb.m_backward1);
                        
      SetHalfPelFlags2(mcdata,mb.m_forward1,mb.m_backward1);
                        
      mclum_func = d_motcomp->AskMCompFunc_Dbl_Luma();
      mcchr_func = d_motcomp->AskMCompFunc_Dbl_Chroma(CHROMA_420);
    }
  else
    {
      const MotionVector* mv;
      if (mb.m_HasMotionForward)
	{
	  mv = &mb.m_forward1;
                            
	  mcdata.lastimg.y  = offs_y +sp_last_y [mb.m_forward1.m_vertical_field_select];
	  mcdata.lastimg.cr = offs_cr+sp_last_cr[mb.m_forward1.m_vertical_field_select];
	  mcdata.lastimg.cb = offs_cb+sp_last_cb[mb.m_forward1.m_vertical_field_select];
	}
      else
	{
	  mv = &mb.m_backward1;
                            
	  mcdata.lastimg.y  =offs_y +sp_next_y [mb.m_backward1.m_vertical_field_select];
	  mcdata.lastimg.cr =offs_cr+sp_next_cr[mb.m_backward1.m_vertical_field_select];
	  mcdata.lastimg.cb =offs_cb+sp_next_cb[mb.m_backward1.m_vertical_field_select];
	}
                        
      SetReferencePtrsFrm(mcdata.lastimg,*mv);
      SetHalfPelFlags1(mcdata,*mv);
                        
      mclum_func = d_motcomp->AskMCompFunc_Sgl_Luma();
      mcchr_func = d_motcomp->AskMCompFunc_Sgl_Chroma(CHROMA_420);
    }
                    
  (*(mclum_func[mcdata.LumaHalfFlags]))(&mcdata);
  (*(mcchr_func[mcdata.ChromaHalfFlags]))(&mcdata);
}

void VideoDecoder::MC_Field_16x8(const Macroblock& mb,uint16 mb_mode)
{
  struct MotionCompensation_SglMB::MCData mcdata;
  MotionCompensation_SglMB::MCompFunc*const* mclum_func;
  MotionCompensation_SglMB::MCompFunc*const* mcchr_func;

  mcdata.currimg.y  = dp_y;
  mcdata.currimg.cr = dp_cr;
  mcdata.currimg.cb = dp_cb;

  mcdata.bytesperline_lum = lineskip_lum;
  mcdata.bytesperline_chr = lineskip_chr;
  mcdata.blkheight=8;
  mcdata.blkheight_chr=mb_chr_h/2;

  int offs_y  = dp_y  - sp_curr_y;
  int offs_cr = dp_cr - sp_curr_cr;
  int offs_cb = dp_cb - sp_curr_cb;
  Assert(offs_cr==offs_cb);

  for (int v=0;v<2;v++)
    {
      if ((mb_mode & (MBMODE_MVFWD|MBMODE_MVBKW))==(MBMODE_MVFWD|MBMODE_MVBKW))
	{
	  mcdata.lastimg.y  = offs_y  + sp_last_y [mb.m_vector[v][0].m_vertical_field_select];
	  mcdata.lastimg.cr = offs_cr + sp_last_cr[mb.m_vector[v][0].m_vertical_field_select];
	  mcdata.lastimg.cb = offs_cb + sp_last_cb[mb.m_vector[v][0].m_vertical_field_select];
                        
	  mcdata.nextimg.y  = offs_y  + sp_next_y [mb.m_vector[v][1].m_vertical_field_select];
	  mcdata.nextimg.cr = offs_cr + sp_next_cr[mb.m_vector[v][1].m_vertical_field_select];
	  mcdata.nextimg.cb = offs_cb + sp_next_cb[mb.m_vector[v][1].m_vertical_field_select];
                        
	  SetReferencePtrsFrm(mcdata.lastimg,mb.m_vector[v][0]);
	  SetReferencePtrsFrm(mcdata.nextimg,mb.m_vector[v][1]);
                        
	  SetHalfPelFlags2(mcdata,mb.m_vector[v][0],mb.m_vector[v][1]);
                        
	  mclum_func = d_motcomp->AskMCompFunc_Dbl_Luma();
	  mcchr_func = d_motcomp->AskMCompFunc_Dbl_Chroma(CHROMA_420);
	}
      else
	{
	  const MotionVector* mv;
	  if (mb.m_HasMotionForward)
	    {
	      mv = &mb.m_vector[v][0];
                            
	      mcdata.lastimg.y  = offs_y +sp_last_y [mb.m_vector[v][0].m_vertical_field_select];
	      mcdata.lastimg.cr = offs_cr+sp_last_cr[mb.m_vector[v][0].m_vertical_field_select];
	      mcdata.lastimg.cb = offs_cb+sp_last_cb[mb.m_vector[v][0].m_vertical_field_select];
	    }
	  else
	    {
	      mv = &mb.m_vector[v][1];
                            
	      mcdata.lastimg.y  =offs_y +sp_next_y [mb.m_vector[v][1].m_vertical_field_select];
	      mcdata.lastimg.cr =offs_cr+sp_next_cr[mb.m_vector[v][1].m_vertical_field_select];
	      mcdata.lastimg.cb =offs_cb+sp_next_cb[mb.m_vector[v][1].m_vertical_field_select];
	    }
                        
	  SetReferencePtrsFrm(mcdata.lastimg,*mv);
	  SetHalfPelFlags1(mcdata,*mv);
                        
	  mclum_func = d_motcomp->AskMCompFunc_Sgl_Luma();
	  mcchr_func = d_motcomp->AskMCompFunc_Sgl_Chroma(CHROMA_420);
	}
                    
      (*(mclum_func[mcdata.LumaHalfFlags]))(&mcdata);
      (*(mcchr_func[mcdata.ChromaHalfFlags]))(&mcdata);

      mcdata.currimg.y  += lineskip_lum*8;
      mcdata.currimg.cb += lineskip_chr*mb_chr_h/2;
      mcdata.currimg.cr += lineskip_chr*mb_chr_h/2;

      offs_y  += lineskip_lum*8;
      offs_cr += lineskip_chr*mb_chr_h/2;
      offs_cb += lineskip_chr*mb_chr_h/2;
    }
}

static bool cbblks[12] =
{ false,false,false,false,
  true, false,true, false,
  true, false,true, false
};


static int blk_xoffs[12] = { 0,8,0,8, 0,0,0,0, 8,8,8,8 };
static int blk_yoffs[12] = { 0,0,8,8, 0,0,8,8, 0,0,8,8 };

static int blk_xoffs_field[12] = { 0,8,0,8, 0,0,0,0, 8,8,8,8 };
static int blk_yoffs_field[12] = { 0,0,1,1, 0,0,1,1, 0,0,1,1 };


inline void VideoDecoder::AdvancePtrsMB()
{
  dp_y  += 16;
  dp_cr +=  mb_chr_w;
  dp_cb += mb_chr_w;
}

inline void VideoDecoder::AdvancePtrsMBRow()
{
  dp_y  += 15*lineskip_lum;
  int cskip = 7*lineskip_chr + bytesperline_chr-d_MBWidth*mb_chr_w;
  dp_cr += cskip;
  dp_cb += cskip;
}


void VideoDecoder::FlushBSlice(int mbrow)
{
#ifndef SEND_FULL_BFRAMES
  d_curr->m_may_modify = true;
  d_curr->m_src_y_start = d_field_offset;

  if (d_pichdr.m_picture_structure == PICSTRUCT_FramePicture)
    { d_curr->m_src_y_end   = 15;                d_curr->m_field_lines=false; }
  else 
    { d_curr->m_src_y_end   = 30+d_field_offset; d_curr->m_field_lines=true; }

  switch (d_pichdr.m_picture_structure)
    {
    case PICSTRUCT_FramePicture: d_curr->m_dst_y_start = mbrow*16;   break;
    case PICSTRUCT_TopField:     d_curr->m_dst_y_start = mbrow*32;   break;
    case PICSTRUCT_BottomField:  d_curr->m_dst_y_start = mbrow*32+1; break;
    }

  int end_line = d_curr->m_dst_y_start + (d_curr->m_src_y_end-d_curr->m_src_y_start);
  if (end_line >= d_seqdata.m_Height)
    {
      end_line = d_seqdata.m_Height-1;
      d_curr->m_src_y_end = end_line  + d_curr->m_src_y_start - d_curr->m_dst_y_start;
    }
      
  d_sink->ShowMBRows(d_curr);  // Show image

  const int nRows = ((d_pichdr.m_picture_structure == PICSTRUCT_FramePicture) ? 1 : 2);

  for (int n=0;n<2;n++)
    {
      sp_last_y[n]  += nRows*bytesperline_lum*16;
      sp_last_cr[n] += nRows*bytesperline_chr*mb_chr_h;
      sp_last_cb[n] += nRows*bytesperline_chr*mb_chr_h;

      sp_next_y[n]  += nRows*bytesperline_lum*16;
      sp_next_cr[n] += nRows*bytesperline_chr*mb_chr_h;
      sp_next_cb[n] += nRows*bytesperline_chr*mb_chr_h;
    }      

  dp_y  = ptr_y [0];
  dp_cr = ptr_cr[0];
  dp_cb = ptr_cb[0];
#endif
}

void VideoDecoder::DecodeSlice(class FastBitBuf& bs)
{
  try
    {
      if (d_skip_this_frame)
	return;

      const bool IsBPicture = (d_pichdr.m_picture_coding_type == PICTYPE_B);

      int startcode = bs.GetBits(24);
      Assert(startcode==0x000001);

      struct
      {
	uint16 vpos;
	uint8  priority_breakpoint;
	uint5  quantiser_scale_code;
	bool   intra_slice;
      } slicehdr; 

      slicehdr.intra_slice=false;


      // *** decode slice header ***
      slicehdr.vpos = bs.GetBits(8)-1;


      struct MotionCompensation_SglMB::MCData mcdata;
      MotionCompensation_SglMB::MCompFunc*const* mclum_func;
      MotionCompensation_SglMB::MCompFunc*const* mcchr_func;


      int PMV [2 /* f/s */] [2 /* fw/bw */] [2 /* h/v */];

#ifndef SEND_FULL_BFRAMES
      if (IsBPicture)
	{
	  // reuse the same lines every time

	  dp_y  = ptr_y [0]-16;
	  dp_cr = ptr_cr[0]-mb_chr_w;
	  dp_cb = ptr_cb[0]-mb_chr_w;
	}
      else
#endif
	{
	  dp_y  = ptr_y [slicehdr.vpos*16]-16;
	  dp_cr = ptr_cr[slicehdr.vpos*mb_chr_h]-mb_chr_w;
	  dp_cb = ptr_cb[slicehdr.vpos*mb_chr_h]-mb_chr_w;
	}

      if (d_MBHeight > 175) // <==>  height > 2800
	slicehdr.vpos += bs.GetBits(3)<<7;

      if (d_scalability_mode == DataPartitioning)
	slicehdr.priority_breakpoint = bs.GetBits(7);

      slicehdr.quantiser_scale_code = bs.GetBits(5);
      if (bs.GetBits(1)==1)
	{
	  slicehdr.intra_slice = bs.GetBits(1);
	  bs.SkipBits(7);

	  while (bs.GetBits(1)==1)
	    bs.SkipBits(8);
	}

      if (d_options.Trace_SlcH)
	{
	  cout << "SliceHeader:\n"
	       << "  vertical pos:         " << slicehdr.vpos << endl
	       << "  quantiser scale code: " << ((int)slicehdr.quantiser_scale_code) << endl
	       << "  intra slice:          " << (slicehdr.intra_slice?"true":"false") << endl;
	}


      // *** decode all macroblocks in slice ***

      int dcpred_y  = d_dc_pred;
      int dcpred_cb = d_dc_pred;
      int dcpred_cr = d_dc_pred;

      bzero((char*)&PMV[0][0][0],2*2*2*sizeof(int)); // Reset MV-predictions.

      const Macroblock* lastmb = NULL;
      uint16 last_mb_mode=0;

      int mb_addr=-1;
      int mb_row =slicehdr.vpos;
      int qcode  =slicehdr.quantiser_scale_code;

      while (bs.AskBitsLeft() >= 2 && bs.PeekBits(min((int32)bs.AskBitsLeft(),(int32)23UL)) != 0)
	{
	  if (!d_IsMPEG2)
	    {
	      // Macroblock-Stuffing

	      while (bs.PeekBits(11)==0x00F) bs.SkipBits(11);
	    }

	  int incr = GetMBAddrIncr(bs);

#ifndef NDEBUG
	  if (d_options.Trace_MB)
	    {
	      cout << "--- MB --- " << slicehdr.vpos << " " << mb_addr+1 << endl;
	      cout << "last MBAddr: " << mb_addr << " increment: " << incr << endl;
	    }
#endif

	  // Handle skipped macroblocks. Note: the first MBincr in a slice does not define skipped MBs.
	  if (incr>1 && mb_addr>=0)
	    {
	      dcpred_y  = dcpred_cb = dcpred_cr = d_dc_pred;

	      if (d_pichdr.m_picture_coding_type == PICTYPE_B)
		{
		  for (int i=incr;i>0;i--)
		    {
		      AdvancePtrsMB();
		      mb_addr++;

		      if (mb_addr==d_MBWidth)
			{
			  AdvancePtrsMBRow();
			  if (IsBPicture) FlushBSlice(mb_row);
			  mb_row++;
			  mb_addr=0;
			}

		      if (i>1)
			{
			  if (d_pichdr.m_picture_structure==PICSTRUCT_FramePicture)
			    MC_Frame_FrameBased(*lastmb,last_mb_mode);
			  else
			    MC_Field_FieldBased(*lastmb,last_mb_mode);
			}
		    }
		}
	      else if (d_pichdr.m_picture_coding_type == PICTYPE_P)
		{
		  bzero((char*)&PMV[0][0][0],2*2*2*sizeof(int)); // Reset PMVs

		  incr--;
		  mb_addr++;
		  AdvancePtrsMB();
		  if (mb_addr==d_MBWidth)
		    {
		      AdvancePtrsMBRow();
		      if (IsBPicture) FlushBSlice(mb_row);
		      mb_row++;
		      mb_addr=0;
		    }

		  while (incr)
		    {
		      int len;
		      if (mb_addr+incr >= d_MBWidth) len = d_MBWidth-mb_addr;
		      else                           len = incr;

		      int y0=mb_row*8;
		      int x0=mb_addr*8;
		      int plen = len*8;

		      const Pixel* sp = dp_y-sp_curr_y+sp_last_y[d_field_offset];
		      Pixel* dp = dp_y;

		      int h = 16;
                        
		      for (int y=0;y<h;y++)
			{
			  memcpy(dp,sp,plen+plen);
			  sp += lineskip_lum;
			  dp += lineskip_lum;
			}

		      sp = dp_cr-sp_curr_cr+sp_last_cr[d_field_offset];
		      dp = dp_cr;

		      for (int y=0;y<h/2;y++)
			{
			  memcpy(dp,sp,plen);
			  sp += lineskip_chr;
			  dp += lineskip_chr;
			}

		      sp = dp_cb-sp_curr_cb+sp_last_cb[d_field_offset];
		      dp = dp_cb;

		      for (int y=0;y<h/2;y++)
			{
			  memcpy(dp,sp,plen);
			  sp += lineskip_chr;
			  dp += lineskip_chr;
			}

		      mb_addr += len;
		      for (int i=0;i<len;i++) AdvancePtrsMB();
		      if (mb_addr==d_MBWidth)
			{
			  AdvancePtrsMBRow();
			  if (IsBPicture) FlushBSlice(mb_row);
			  mb_addr=0;
			  mb_row++;
			}
		      else
			{
			  Assert(mb_addr < d_MBWidth);
			}

		      incr -= len;
		    }
		}
	      else if (d_pichdr.m_picture_coding_type == PICTYPE_I)
		{
		  /* It is legal for the slice not to start in the first
		     column. But it is illegal to skip any macroblocks in I pictures. */
#if 1
		  throw Excpt_StreamError(ErrSev_Warning,
					  "Invalid MPEG stream. "
					  "Macroblock increment not 1 in I picture");
#endif
		}
	      else
		{ NotImplemented  /* TODO: D-pictures ? */ }
	    }
	  else
	    {
	      /* TODO: Should we do something if incr>=d_MBWidth ??? */

	      mb_addr += incr;
	      for (int i=0;i<incr;i++)
		AdvancePtrsMB();
	    }

	  assert(mb_addr <= d_MBWidth);
	  assert(mb_row  <= d_MBHeight);



	  // process around-end-of-line-wrap in MPEG-1
	  Assert(mb_addr>=0);
	  if ((uint32)mb_addr >= d_MBWidth)
	    {
	      if (d_IsMPEG2)
		throw Excpt_StreamError(ErrSev_Warning, /* TODO: Put this into a separate
							   Exceptionclass for recovering */
					"Invalid MPEG-2 input stream. "
					"Slice is wider than image width.");

	      int nlines = mb_addr/d_MBWidth;

	      for (int i=0;i<nlines;i++)
		AdvancePtrsMBRow();

	      if (IsBPicture) FlushBSlice(mb_row);

	      mb_row  += nlines;
	      mb_addr %= d_MBWidth;
	    }

	  static Macroblock s_mb;
	  Macroblock& mb = ((d_picdata && d_picdata->m_codedimage.IsInitialized()) ?
			    d_picdata->m_codedimage.Ask(mb_row,mb_addr) :
			    s_mb);


	  // -------- macroblock_modes() ----------

	  if (d_pichdr.m_picture_coding_type>4)
	    throw Excpt_StreamError(ErrSev_Error,
				    "Invalid MPEG stream, picture coding type >4 read.");

	  uint16 mb_mode = GetMBMode[d_pichdr.m_picture_coding_type](bs);



	  /* TODO: Spatial_Temporal_Weight_Code missing */

	  if (mb_mode & (MBMODE_MVFWD|MBMODE_MVBKW))
	    {
	      if (d_pichdr.m_picture_structure == PICSTRUCT_FramePicture)
		{
		  if (d_pichdr.m_frame_pred_frame_dct)
		    {
		      mb.SetFrameMotionType(Macroblock::FRMT_FrameBased);
		    }
		  else
		    {
		      mb.SetFrameMotionType((enum Macroblock::FrameMotionType)bs.GetBits(2));
		    }
		}
	      else
		{
		  mb.SetFieldMotionType((enum Macroblock::FieldMotionType)bs.GetBits(2));
		}
	    }
	  else if ((mb_mode & MBMODE_INTRA) && d_pichdr.m_concealment_motion_vectors)
	    {
	      if (d_pichdr.m_picture_structure == PICSTRUCT_FramePicture)
		{
		  mb.SetFrameMotionType(Macroblock::FRMT_FrameBased);
		}
	      else
		{
		  mb.SetFieldMotionType(Macroblock::FIMT_FieldBased);
		}
	    }

	  mb.m_FieldDCT=false;
	  if (d_IsMPEG2 &&
	      d_pichdr.m_picture_structure == PICSTRUCT_FramePicture &&
	      d_pichdr.m_frame_pred_frame_dct == false &&
	      (mb_mode & (MBMODE_INTRA|MBMODE_PATTERN)))
	    {
	      mb.m_FieldDCT = bs.GetBits(1);
	    }

	  // -------- end of macroblock_modes() -----------

	  if (!(mb_mode & MBMODE_INTRA))
	    {
	      dcpred_y  = 
		dcpred_cb = 
		dcpred_cr = d_dc_pred;
	    }

	  // Reset motionvektor predictions
	  if (((mb_mode & MBMODE_INTRA) && !d_pichdr.m_concealment_motion_vectors) ||
	      (d_pichdr.m_picture_coding_type == PICTYPE_P && !(mb_mode & MBMODE_MVFWD) && !(mb_mode & MBMODE_INTRA)))
	    {
	      bzero((char*)&PMV[0][0][0],2*2*2*sizeof(int));
	    }

	  if (mb_mode & MBMODE_QUANT)
	    qcode = bs.GetBits(5);

	  mb.m_quantiser_scale_code = qcode;


	  bool FieldMVInFramePic = (mb.m_mv_format == Macroblock::MVFormat_Frame &&
				    mb.m_frame_motion_type == Macroblock::FRMT_FieldBased);

	  if (mb.m_mv_format == Macroblock::MVFormat_Frame &&
	      mb.m_frame_motion_type == Macroblock::FRMT_DualPrime)
	    FieldMVInFramePic = true;

	  if ((mb_mode & MBMODE_MVFWD) ||
	      ((mb_mode & MBMODE_INTRA) && d_pichdr.m_concealment_motion_vectors))
	    {
	      // --- motion_vectors(0) ---

	      if (mb.m_motion_vector_count == 1)
		{
		  if (FieldMVInFramePic)
		    {
		      DIV2(PMV[0][0][1]);
		    }

		  mb.m_vector[0][0].m_habs = PMV[0][0][0];
		  mb.m_vector[0][0].m_vabs = PMV[0][0][1];

		  if (mb.m_mv_format == Macroblock::MVFormat_Field && mb.m_dmv==false)
		    { mb.m_vector[0][0].m_vertical_field_select = bs.GetBits(1); }
		  motion_vector(mb.m_vector[0][0],0,mb.m_dmv,bs);

		  PMV[0][0][0] = mb.m_vector[0][0].m_habs;
		  PMV[0][0][1] = mb.m_vector[0][0].m_vabs;

		  if (FieldMVInFramePic)
		    {
		      PMV[0][0][1] *= 2;
		    }

		  PMV[1][0][0] = PMV[0][0][0];    // Nach Table 7-9
		  PMV[1][0][1] = PMV[0][0][1];
		}
	      else
		{
		  if (FieldMVInFramePic)
		    {
		      DIV2(PMV[0][0][1]);
		      DIV2(PMV[1][0][1]);
		    }

		  mb.m_vector[0][0].m_habs = PMV[0][0][0];
		  mb.m_vector[0][0].m_vabs = PMV[0][0][1];
		  mb.m_vector[1][0].m_habs = PMV[1][0][0];
		  mb.m_vector[1][0].m_vabs = PMV[1][0][1];

		  mb.m_vector[0][0].m_vertical_field_select = bs.GetBits(1);
		  motion_vector(mb.m_vector[0][0],0,mb.m_dmv,bs);
		  mb.m_vector[1][0].m_vertical_field_select = bs.GetBits(1);
		  motion_vector(mb.m_vector[1][0],0,mb.m_dmv,bs);

		  PMV[0][0][0] = mb.m_vector[0][0].m_habs;
		  PMV[0][0][1] = mb.m_vector[0][0].m_vabs;
		  PMV[1][0][0] = mb.m_vector[1][0].m_habs;
		  PMV[1][0][1] = mb.m_vector[1][0].m_vabs;

		  if (FieldMVInFramePic)
		    {
		      PMV[0][0][1] *= 2;
		      PMV[1][0][1] *= 2;
		    }
		}
	    }

	  if (mb_mode & MBMODE_MVBKW)
	    {
	      // --- motion_vectors(1) ---

	      if (mb.m_motion_vector_count == 1)
		{
		  if (FieldMVInFramePic)
		    {
		      DIV2(PMV[0][1][1]);
		    }

		  mb.m_vector[0][1].m_habs = PMV[0][1][0];
		  mb.m_vector[0][1].m_vabs = PMV[0][1][1];

		  if (mb.m_mv_format == Macroblock::MVFormat_Field && mb.m_dmv==false)
		    { mb.m_vector[0][1].m_vertical_field_select = bs.GetBits(1); }
		  motion_vector(mb.m_vector[0][1],1,mb.m_dmv,bs);

		  PMV[0][1][0] = mb.m_vector[0][1].m_habs;
		  PMV[0][1][1] = mb.m_vector[0][1].m_vabs;

		  if (FieldMVInFramePic)
		    {
		      PMV[0][1][1] *= 2;
		    }

		  PMV[1][1][0] = PMV[0][1][0];  // Nach Table 7-9
		  PMV[1][1][1] = PMV[0][1][1];
		}
	      else
		{
		  if (FieldMVInFramePic)
		    {
		      DIV2(PMV[0][1][1]);
		      DIV2(PMV[1][1][1]);
		    }

		  mb.m_vector[0][1].m_habs = PMV[0][1][0];
		  mb.m_vector[0][1].m_vabs = PMV[0][1][1];
		  mb.m_vector[1][1].m_habs = PMV[1][1][0];
		  mb.m_vector[1][1].m_vabs = PMV[1][1][1];

		  mb.m_vector[0][1].m_vertical_field_select = bs.GetBits(1);
		  motion_vector(mb.m_vector[0][1],1,mb.m_dmv,bs);
		  mb.m_vector[1][1].m_vertical_field_select = bs.GetBits(1);
		  motion_vector(mb.m_vector[1][1],1,mb.m_dmv,bs);

		  PMV[0][1][0] = mb.m_vector[0][1].m_habs;
		  PMV[0][1][1] = mb.m_vector[0][1].m_vabs;
		  PMV[1][1][0] = mb.m_vector[1][1].m_habs;
		  PMV[1][1][1] = mb.m_vector[1][1].m_vabs;

		  if (FieldMVInFramePic)
		    {
		      PMV[0][1][1] *= 2;
		      PMV[1][1][1] *= 2;
		    }
		}
	    }

#ifndef NDEBUG
	  if (d_options.Trace_MB)
	    {
	      cout << "PMV[0][0][]: " << PMV[0][0][0] << ',' << PMV[0][0][1] << endl;
	      cout << "PMV[0][1][]: " << PMV[0][1][0] << ',' << PMV[0][1][1] << endl;
	      cout << "PMV[1][0][]: " << PMV[1][0][0] << ',' << PMV[1][0][1] << endl;
	      cout << "PMV[1][1][]: " << PMV[1][1][0] << ',' << PMV[1][1][1] << endl;
	    }
#endif

	  if ((mb_mode & MBMODE_INTRA) && d_pichdr.m_concealment_motion_vectors)
	    {
	      bs.SkipBits(1);
	    }

	  if (d_pichdr.m_picture_coding_type == PICTYPE_P && !(mb_mode & (MBMODE_MVFWD|MBMODE_INTRA)))
	    {
	      mb_mode |= MBMODE_MVFWD;
	      mb.m_forward1.m_habs=0;
	      mb.m_forward1.m_vabs=0;
	      if (d_pichdr.m_picture_structure==PICSTRUCT_FramePicture)
		{
		  mb.SetFrameMotionType(Macroblock::FRMT_FrameBased);
		}
	      else if (d_pichdr.m_picture_structure == PICSTRUCT_TopField)
		{
		  mb.SetFieldMotionType(Macroblock::FIMT_FieldBased);
		  mb.m_forward1.m_vertical_field_select = 0;
		}
	      else
		{
		  mb.SetFieldMotionType(Macroblock::FIMT_FieldBased);
		  mb.m_forward1.m_vertical_field_select = 1;
		}
	    }

	  if (mb_mode & MBMODE_INTRA) mb.m_IsIntra=true;
	  else                        mb.m_IsIntra=false;

	  mb.m_HasMotionForward  = (mb_mode & MBMODE_MVFWD);
	  mb.m_HasMotionBackward = (mb_mode & MBMODE_MVBKW);


	  // --- Motion-Compensation ---

	  if (mb_mode & (MBMODE_MVFWD|MBMODE_MVBKW))
	    {
	      if (mb.m_mv_format==Macroblock::MVFormat_Frame)
		{
		  switch (mb.m_frame_motion_type)
		    {
		    case Macroblock::FRMT_FrameBased:
		      MC_Frame_FrameBased(mb,mb_mode);
		      break;

		    case Macroblock::FRMT_FieldBased:
		      MC_Frame_FieldBased(mb,mb_mode);
		      break;

		    case Macroblock::FRMT_DualPrime:
		      cerr << "Frame: DualPrime\n";
		      break;

		    default:
		      cerr << "UNIMPLEMENTED FRAME MOTION\n";
		      break;
		    }
		}
	      else  // MV-Format: Field
		{
		  switch (mb.m_field_motion_type)
		    {
		    case Macroblock::FIMT_FieldBased:
		      MC_Field_FieldBased(mb,mb_mode);
		      break;

		    case Macroblock::FIMT_16x8MC:
		      MC_Field_16x8(mb,mb_mode);
		      //cout << "Fld 16x8\n";
		      break;
                  
		    case Macroblock::FIMT_DualPrime:
		      cerr << "Field: DualPrime\n";
		      break;

		    default:
		      cerr << "UNIMPLEMENTED FIELD MOTION\n";
		      break;
		    }
		}
	    }

	  // ------- begin of coded_block_pattern() -----------

	  uint16 cbp = 0;

	  if (mb_mode & MBMODE_PATTERN)
	    {
	      cbp=GetCBP(bs)<<6;

	      if (d_ChromaFormat==CHROMA_422)
		{ cbp |= bs.GetBits(2)<<4; }
	      else if (d_ChromaFormat==CHROMA_444)
		{ cbp |= bs.GetBits(6);    }
	    }
	  else if (mb_mode & MBMODE_INTRA)
	    {
	      cbp = d_intra_cbp;
	    }

	  // ------- end of coded_block_pattern() -----------


#ifndef NDEBUG
	  if (d_options.Trace_MB)
	    {
	      cout << "MBHdr (pos: " << mb_row << ',' << mb_addr << '=' << mb_row*d_MBWidth+mb_addr << ")\n"
		   << "  modes:  ";
	      if (mb_mode & MBMODE_QUANT)   cout << "Quant "; else cout << "..... ";
	      if (mb_mode & MBMODE_MVFWD)   cout << "MVFwd "; else cout << "..... ";
	      if (mb_mode & MBMODE_MVBKW)   cout << "MVBkw "; else cout << "..... ";
	      if (mb_mode & MBMODE_PATTERN) cout << "Pattern "; else cout << "....... ";
	      if (mb_mode & MBMODE_INTRA)   cout << "Intra\n"; else cout << ".....\n";

	      if (mb_mode & MBMODE_QUANT)   cout << "  qcode:  " << qcode << endl;
	      cout << "  nBlks:  " << d_dctblks << endl;
	      cout << "  CBP:    0x" << hex << cbp << dec << endl;

	      if (!(mb_mode & MBMODE_INTRA))
		{
		  cout << "  Prediction: ";
		  if (mb.m_mv_format==Macroblock::MVFormat_Frame)
		    {
		      switch (mb.m_frame_motion_type)
			{
			case Macroblock::FRMT_FieldBased: cout << " frame, field based\n"; break;
			case Macroblock::FRMT_FrameBased: cout << " frame, frame based\n"; break;
			case Macroblock::FRMT_DualPrime:  cout << " frame, dual prime\n"; break;
			}
		    }
		  else
		    {
		      switch (mb.m_field_motion_type)
			{
			case Macroblock::FIMT_FieldBased: cout << " field, field based\n"; break;
			case Macroblock::FIMT_16x8MC:     cout << " field, 16x8MC\n";      break;
			case Macroblock::FIMT_DualPrime:  cout << " field, dual prime\n";  break;
			}
		    }

		  cout << "fwd1 field select: " << (mb.m_forward1.m_vertical_field_select==0 ? "t\n" : "b\n");
		  cout << "fwd2 field select: " << (mb.m_forward2.m_vertical_field_select==0 ? "t\n" : "b\n");
		  cout << "bkw1 field select: " << (mb.m_backward1.m_vertical_field_select==0 ? "t\n" : "b\n");
		  cout << "bkw2 field select: " << (mb.m_backward2.m_vertical_field_select==0 ? "t\n" : "b\n");
		}

	      if (mb_mode & (MBMODE_INTRA|MBMODE_PATTERN))
		{ cout << "DCT: " << (mb.m_FieldDCT ? "field":"frame") << endl; }
	    }
#endif

	  // Decode DCT blocks.

	  int cbp_bit=0x800;

	  int qscale = qcode2qscale[d_pichdr.m_q_scale_type][mb.m_quantiser_scale_code];
	  int scanid = (d_pichdr.m_alternate_scan ? 1 : 0);

	  bool b15 = (d_pichdr.m_intra_vlc_format && (mb_mode & MBMODE_INTRA));

	  for (int b=0 ; b<d_dctblks ; b++,cbp_bit>>=1)
	    {
	      int* matrix;
	      int  mismatch_sum; // Sum of all coefficients to calculate mismatch.

	      if (mb_mode & MBMODE_INTRA)
		{
		  if (b<4) matrix=d_quant_bs.m_LumIntra;
		  else     matrix=d_quant_bs.m_ChrIntra;	
		}
	      else
		{
		  if (b<4) matrix=d_quant_bs.m_LumInter;
		  else     matrix=d_quant_bs.m_ChrInter;
		}

	      int nextcoeff;

	      if ((cbp & cbp_bit)==0)
		{
#ifndef NDEBUG
		  if (d_options.Trace_DCTCoeff)
		    cout << "all DCT-Coeff. = 0\n";
#endif
		  continue;
		}

#ifndef NDEBUG
	      if (d_options.Trace_DCTCoeff)
		cout << "DCT (" << b << "): ";
#endif

	      bzero((char*)&mb.m_blks[b].m_coeff[0],64*sizeof(short));

	      int run,value;


	      // Decode first coefficient.

	      if (mb_mode & MBMODE_INTRA)
		{
		  if (b<4)
		    {
		      int diff  = get_luma_dc_dct_diff(bs);

		      dcpred_y += diff;
		      mb.m_blks[b].m_coeff[0] = mismatch_sum
			= (dcpred_y << d_pichdr.m_intra_dc_precision_shift);
		    }
		  else
		    {
		      int diff =get_chroma_dc_dct_diff(bs);

		      int val;
		      if (cbblks[b]) { dcpred_cb+=diff; val = dcpred_cb; }
		      else           { dcpred_cr+=diff; val = dcpred_cr; }

		      mb.m_blks[b].m_coeff[0] = mismatch_sum
			= (val << d_pichdr.m_intra_dc_precision_shift);
		    }

		  nextcoeff=1;
		}

	      if (mb_mode & MBMODE_INTRA)
		{
		  if (b15)
		    {
		      get_intra_block_B15(bs,&mb.m_blks[b].m_coeff[0],d_scan[scanid],qscale,matrix);
		    }
		  else
		    {
		      if (d_IsMPEG2)
			{
			  get_intra_block_B14(bs,&mb.m_blks[b].m_coeff[0],d_scan[scanid],qscale,matrix);
			}
		      else
			{
			  get_mpeg1_intra_block(bs,&mb.m_blks[b].m_coeff[0],d_scan[scanid],qscale,matrix);
			}
		    }
		}
	      else
		{
		  if (d_IsMPEG2)
		    {
		      get_non_intra_block(bs,&mb.m_blks[b].m_coeff[0],d_scan[scanid],qscale,matrix);
		    }
		  else
		    {
		      get_mpeg1_non_intra_block(bs,&mb.m_blks[b].m_coeff[0],d_scan[scanid],qscale,matrix);
		    }
		}


	      // Apply iDCT

	      bool add_dct = !mb.m_IsIntra;

	      if (b<4)
		{
		  int lineskip;
		  Pixel* blkstart;
		  if (mb.m_FieldDCT)
		    {
		      blkstart = &dp_y[blk_yoffs_field[b]*lineskip_lum+blk_xoffs_field[b]];
		      lineskip=lineskip_lum*2;
		    }
		  else
		    {
		      blkstart = &dp_y[blk_yoffs[b]*lineskip_lum+blk_xoffs[b]];
		      lineskip=lineskip_lum;
		    }

#if MMX_DCT
		  if (add_dct)
		    {
		      IDCT_mmx(&mb.m_blks[b].m_coeff[0],
			       &mb.m_blks[b].m_coeff[0]);

		      IDCT_16bit8bit_add(&mb.m_blks[b].m_coeff[0],blkstart,lineskip);
		    }
		  else
		    {
		      mb.m_blks[b].m_coeff[0] <<= 4;
		      mb.m_blks[b].m_coeff[0] |= 0x8;
                      
		      IDCT_mmx(&mb.m_blks[b].m_coeff[0],
			       &mb.m_blks[b].m_coeff[0]);

		      IDCT_16bit8bit(&mb.m_blks[b].m_coeff[0],blkstart,lineskip);
		    }
#else
		  Pixel* op[8];
                  
		  op[0] = blkstart;
		  for (int i=1;i<8;i++)
		    op[i]=op[i-1]+lineskip;

		  IDCT_Int2b(&mb.m_blks[b].m_coeff[0], op, add_dct);
#endif
		}
	      else
		{
		  Pixel* p;
		  if (cbblks[b]) p=dp_cr; else p=dp_cb;
		  int lineskip;

		  if (mb.m_FieldDCT && d_ChromaFormat!=CHROMA_420)
		    {
		      p += blk_yoffs_field[b]*lineskip_chr+blk_xoffs_field[b];
		      lineskip = lineskip_chr*2;
		    }
		  else
		    {
		      p += blk_yoffs[b]*lineskip_chr+blk_xoffs[b];
		      lineskip = lineskip_chr;
		    }

		  // if (mb.m_blks[b].m_hasdata)
		  {
#if MMX_DCT
		    Pixel* blkstart = p;

		    if (add_dct)
		      {
			IDCT_mmx(&mb.m_blks[b].m_coeff[0],
				 &mb.m_blks[b].m_coeff[0]);

			IDCT_16bit8bit_add(&mb.m_blks[b].m_coeff[0],blkstart,lineskip);
		      }
		    else
		      {
			mb.m_blks[b].m_coeff[0] <<= 4;
			mb.m_blks[b].m_coeff[0] |= 0x8;
                      
			IDCT_mmx(&mb.m_blks[b].m_coeff[0],
				 &mb.m_blks[b].m_coeff[0]);

			IDCT_16bit8bit(&mb.m_blks[b].m_coeff[0],blkstart,lineskip);
		      }
#else
		    Pixel* op[8];

		    op[0] = p;
		    for (int i=1;i<8;i++)
		      op[i]=op[i-1]+lineskip;

		    IDCT_Int2b(&mb.m_blks[b].m_coeff[0], op, add_dct);
#endif
		  }
		}
	    }


	  if (d_pichdr.m_picture_coding_type == PICTYPE_D)
	    {
	      // D-picture requires final '1' bit (end of macroblock)
	  
	      int n = bs.GetBits(1);
	      if (n != 1)
		{
		  throw Excpt_StreamError(ErrSev_Error,
					  "Invalid MPEG stream, 'end of macroblock'-bit missing in D-picture.");
		}
	    }
	  lastmb = &mb;
	  last_mb_mode = mb_mode;
	}

      if (IsBPicture && mb_addr==d_MBWidth-1)
	{ FlushBSlice(mb_row); }
    }
  catch(Excpt_StreamError& err)
    {
      MessageDisplay::Show(err);
      MessageDisplay::Show(ErrSev_Note,"continuing anyway...");
    }
}


void VideoDecoder::motion_vector(struct MotionVector& mv,int s,bool dmv,
				 class FastBitBuf& bs)
{
  // horizontal component

  {
    const int motcode = GetMotionCode(bs);
    const int fcode   = d_pichdr.m_fcode[s][0];
    const int rsize   = fcode-1;
    int delta;
    int res;

    if (motcode!=0 && fcode !=1)
      {
        res = bs.GetBits(rsize);
        if (motcode>0)
          delta =   (( motcode-1)<<rsize) + res+1;
        else
          delta = -(((-motcode-1)<<rsize) + res+1);
      }
    else
      delta = motcode;
    
    mv.m_habs += delta;
    
    if      (mv.m_habs < (-16 << rsize))
      mv.m_habs += 32<<rsize;
    else if (mv.m_habs > ( 16 << rsize)-1)
      mv.m_habs -= 32<<rsize;

#ifndef NDEBUG
    if (d_options.Trace_MB)
      cout << "H (" << motcode << " " << res << ") -> " << delta << "  " << mv.m_habs << endl;
#endif
  }

  if (dmv)
    {
      int bits = bs.PeekBits(2);
      switch (bits)
        {
        case 0:
        case 1: mv.m_dmvector[0]= 0; bs.SkipBits(1); break;
        case 2: mv.m_dmvector[0]= 1; bs.SkipBits(2); break;
        case 3: mv.m_dmvector[0]=-1; bs.SkipBits(2); break;
        }
    }



  // vertical component

  {
    const int motcode = GetMotionCode(bs);
    const int fcode   = d_pichdr.m_fcode[s][1];
    const int rsize   = fcode-1;
    int delta;
    int res;

    if (motcode!=0 && fcode !=1)
      {
        res = bs.GetBits(rsize);
        if (motcode>0)
          delta =   (( motcode-1)<<rsize) + res+1;
        else
          delta = -(((-motcode-1)<<rsize) + res+1);
      }
    else
      delta = motcode;
    
    mv.m_vabs += delta;
    
    if      (mv.m_vabs < (-16 << rsize))
      mv.m_vabs += 32<<rsize;
    else if (mv.m_vabs > ( 16 << rsize)-1)
      mv.m_vabs -= 32<<rsize;

#ifndef NDEBUG
    if (d_options.Trace_MB)
      cout << "V (" << motcode << " " << res << ") -> " << delta << "  " << mv.m_vabs << endl;
#endif
  }

  if (dmv)
    {
      int bits = bs.PeekBits(2);
      switch (bits)
        {
        case 0:
        case 1: mv.m_dmvector[0]= 0; bs.SkipBits(1); break;
        case 2: mv.m_dmvector[0]= 1; bs.SkipBits(2); break;
        case 3: mv.m_dmvector[0]=-1; bs.SkipBits(2); break;
        }
    }


#ifndef NDEBUG
  if (d_options.Trace_MB)
        cout << "MV: " << mv.m_habs << " " << mv.m_vabs << endl;
#endif
}

#if 0
  {
  ImageParam param = d_outbuf[d_outbuf_len-1].m_image.AskParam();
  Pixel*const* p = ((Image<Pixel>*)&d_outbuf[d_outbuf_len-1].m_image)->AskFrameY();
  for (int y=0;y<param.height;y+=16)
    for (int x=0;x<param.width;x++)
      p[y][x]= (((y%160)==0) ? 255 : (((y%80)==0) ? 200 : 150));

  for (int y=0;y<param.height;y++)
    for (int x=0;x<param.width;x+=16)
      p[y][x]= (((x%160)==0) ? 255 : (((x%80)==0) ? 200 : 150));
  }
#endif

#if 0
  {
  ImageParam param; d_outbuf[d_outbuf_len-1].m_image.GetParam(param);
  Pixel*const* p = ((Image<Pixel>*)&d_outbuf[d_outbuf_len-1].m_image)->AskFrameU();
  for (int y=0;y<param.height/2;y++)
    for (int x=0;x<param.width/2;x++)
      p[y][x]=128;
  }
  {
  ImageParam param; d_outbuf[d_outbuf_len-1].m_image.GetParam(param);
  Pixel*const* p = ((Image<Pixel>*)&d_outbuf[d_outbuf_len-1].m_image)->AskFrameV();
  for (int y=0;y<param.height/2;y++)
    for (int x=0;x<param.width/2;x++)
      p[y][x]=128;
  }
#endif

