/********************************************************************************
    Copyright (C) 2001  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#include "output/out_none.hh"

VideoSink_None::VideoSink_None()
  : cnt(0), pic_available(false)
{
}


VideoSink_None::~VideoSink_None()
{
}


void VideoSink_None::ShowMBRows(DecodedImageData* dimg)
{
  nextpts = dimg->m_timing.pts;
  cnt++;

  return;
}


void VideoSink_None::BeginPicture(const DecodedImageData* dimg)
{
}

void VideoSink_None::FinishedPicture()
{
  pic_available=true;
}
