case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

case "$d_symlink" in
*define*) sln='ln -s' ;;
*) sln='ln';;
esac

echo "Extracting Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#
# $Id: Makefile.SH,v 1.6 2001/03/18 19:04:47 hurtta Exp $
#
#  Makefile for the entire ELM mail system
#
#         (C) Copyright 1986,1987, by Dave Taylor
#         (C) Copyright 1988-1992, USENET Community Trust
# 
#

#	Variables established by Configure
CAT		=	$cat
GREP		=	$grep
ECHO		=	$echo
MAKE		=	$make
PR		=	$pr
SHAR		=	$shar -s 60000
SLEEP		=	$sleep
TAR		=	$tar
TAPE		=	$rmttape

!GROK!THIS!
cat >>Makefile <<'!NO!SUBS!'
#	Other variables
SHELL			=	/bin/sh
SOURCE_FILES		=	`$(GREP) -v 'doc/' MANIFEST`
DISTRIBUTED_FILES	=	`$(CAT) MANIFEST`

# Targets
#	Give default target first and alone
default_target:	all

#	Targets that are simply executed in each subordinate makefile as is
all install uninstall lint clean: config.h config.sh Makefile
		cd lib; $(MAKE) $(MJ) -$(MAKEFLAGS) $@
		cd melib; $(MAKE) $(MJ) -$(MAKEFLAGS) $@
		cd shared_libs; $(MAKE) $(MJ) -$(MAKEFLAGS) $@	
		cd src; $(MAKE) $(MJ) -$(MAKEFLAGS) $@
		cd utils; $(MAKE) $(MJ) -$(MAKEFLAGS) $@
		cd doc; $(MAKE) $(MJ) -$(MAKEFLAGS) $@

# Check that config.h is up of date
config.h: config.h.SH config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

# Check that config.sh is up of data
config.sh: Configure hdrs/patchlevel.h	
	@echo "You must run 'sh Configure'"
	exit 1

Makefile: Makefile.SH config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

#	Targets that apply to all elm at once
listing:
		@$(ECHO) "Making source listing in file LISTING."
		@$(PR) -n -f $(SOURCE_FILES) > LISTING

shar:
		$(SHAR) $(DISTRIBUTED_FILES)

tar:
		$(TAR) cvf $(TAPE) $(DISTRIBUTED_FILES)

#	Targets that are really in subordinate make files
documentation:
	cd doc; $(MAKE) $(MJ) -$(MAKEFLAGS) $@

elm:
	cd melib; $(MAKE) $(MJ) -$(MAKEFLAGS) all
	cd lib; $(MAKE) $(MJ) -$(MAKEFLAGS) all
	cd src; $(MAKE) $(MJ) -$(MAKEFLAGS) all

#	The dummy dependency here prevents make from thinking the target is the
#	utils directory that sits in the current directory, rather than
#	an abstract target.
utils: _utils

_utils:
	cd utils; $(MAKE) $(MJ) -$(MAKEFLAGS) all

!NO!SUBS!
