/* $Id: rc_imp.h,v 1.5 2001/05/07 18:16:40 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#if ANSI_C
struct rc_save_info_rec;
#endif

/* Returns 0 on error
           1 if parsed OK
*/
typedef int rc_parse_line P_((struct rc_save_info_rec *r,
			      int lcl,
			      char *value, int lineno, char *filename,
			      int e_val,
			      int negate));
typedef int rc_parse_cline P_((struct rc_save_info_rec *r,
			       int lcl,
			       char *value, int lineno, char *filename));

typedef void rc_print_value P_((FILE *F,
				struct rc_save_info_rec *r,
				int comment));

/* Returns pointer to static buffer */
typedef char * rc_get_value P_((struct rc_save_info_rec *r));

extern struct rc_type {
    rc_parse_line      * parse_line;            /* Parse line */
    rc_parse_cline     * parse_cline;           /* Parse continuation line */
    rc_print_value     * print_value;
    rc_get_value       * get_value;

} rc_DT_SYN, rc_DT_STR, rc_DT_NUM, rc_DT_BOL,
    rc_DT_CHR, rc_DT_WEE, rc_DT_ALT, rc_DT_SRT,
    rc_DT_MLT, rc_DT_ASR, rc_DT_PRM, rc_DT_FUNC,
    rc_DT_LONG;

extern int valid_rc_type P_((struct rc_type *T));

#ifdef USE_PGP
extern struct rc_type rc_DT_PGPVER;
#endif

#define DT_SYN      &rc_DT_SYN    /* synonym entry (old name) */
#define DT_STR      &rc_DT_STR    /* string */
#define DT_NUM      &rc_DT_NUM    /* number */
#define DT_BOL      &rc_DT_BOL    /* ON/OFF (boolean) */
#define DT_WEE      &rc_DT_WEE    /* weed list */
#define DT_ALT      &rc_DT_ALT    /* alternate addresses list */
#define DT_SRT      &rc_DT_SRT    /* sort-by code */
#define DT_MLT      &rc_DT_MLT    /* multiple destinations for data */
#define DT_ASR      &rc_DT_ASR    /* sort-by code */
#define DT_PRM      &rc_DT_PRM   /* file permissions */
#define DT_FUNC     &rc_DT_FUNC  /* function to be called for process option */
#define DT_LONG     &rc_DT_LONG    /* number */
#ifdef USE_PGP
#define DT_PGPVER   &rc_DT_PGPVER    /* enum pgp_version */
#endif

/* read_rc.c. -- return NULL on failure 
                 otherwise pointer to option
*/
extern struct rc_save_info_rec  * do_set P_((int lcl, char *word1, 
					     char *word2, char *filename));
extern int is_it_on P_((char *word));
extern void weedout P_((char *string)); 
extern char * mode_to_str P_((int mode));
extern void alternatives P_((char *));     
/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
