/* $Id: ss_imp.h,v 1.9 2001/05/01 08:56:56 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#ifdef POLL_METHOD

/* Closed only implicity on exit */
extern FILE * transaction_file;

/* struct Read_Buffer is defined on mbx_imp.h */
#if ANSI_C
struct Read_Buffer;
struct Write_Buffer;
#endif

#define SS_magic   0xF100

struct streamsched;

typedef int ss_action_routine P_((struct streamsched *ss, void * data));
extern int ss_noaction_routine P_((struct streamsched *ss, void * data));

#define SS_read_act           0x01
#define SS_write_act          0x02
#define SS_timeout_act        0x04
#define SS_setup_act          0x08
#define SS_shutdown_act       0x10


typedef int ss_ReadFromStream P_((struct streamsched *ss,
				  int stack_idx,
				  struct Read_Buffer *buffer,
				  int wanted));
typedef int ss_WriteToStream P_((struct streamsched *ss, 
				 int stack_idx,
				 struct Write_Buffer *buffer));

typedef void ss_FreeThis P_((struct streamsched *ss,
			     int stack_idx));

typedef int ss_StreamAction P_((struct streamsched *ss, int stack_idx));

typedef void ss_StreamSchedule P_((struct streamsched *ss, int stack_idx,
				  int previous_needs, 
				  int *needs, int *provides));

enum SS_info { SS_ssf = 1 };

/* Unknown functions does not modify *int_val or *str_val */

typedef void ss_StreamInfo P_((struct streamsched *ss, int stack_idx,
			       enum SS_info function,
			       int *int_val,  char **str_val));

extern struct stream_type {
    char                      * tag;
    ss_ReadFromStream         * read_from_it;
    ss_WriteToStream          * write_to_it;
    ss_FreeThis               * free_it;
    ss_StreamAction           * read_action;
    ss_StreamAction           * write_action;
    ss_StreamSchedule         * schedule_data;
    ss_StreamAction           * setup_action;
    ss_StreamAction           * shutdown_action;
    ss_StreamInfo             * query_it;
			  }  SocketStream;

struct streamsched {
    unsigned short magic;        /* SS_magic */

    unsigned  short active_flags;
    
    ss_action_routine  * read_act;
    ss_action_routine  * write_act;
    ss_action_routine  * timeout_act;

    char               * error_state;
    int                timeout_sec;

    union stream_types {
	struct stream_type    **TYPE;
	struct simple_type    *simple;
	
	/* Notice that shared_type_1 and shared_type_2 is not 
	   defined on here. Shared (dynamic) libraries are free
	   to define they..
	*/
	struct shared_type_1  *generic_1;
	struct shared_type_2  *generic_2;
    }                  * this_stack;
    int                  stack_len;
    
    void * data;
};

extern void WaitStreamFor P_((struct streamsched *ss, int flags));

extern int ReadFromStream P_((struct streamsched *ss, 
			      struct Read_Buffer *buffer,
			      int wanted));

extern int WriteToStream P_((struct streamsched *ss, 
			     struct Write_Buffer *buffer));

extern struct streamsched * returnSimpleStream P_((int socket));

extern void ConfigStream P_((struct streamsched *ss,
			     ss_action_routine  * read_act,
			     ss_action_routine  * write_act,
			     ss_action_routine  * timeout_act,
			     int timeout_sec,
			     void * data));
    
extern void FreeStreamStack P_((struct streamsched **ss));

extern void add_stream_to_head P_((struct streamsched *ss,
				   union stream_types stream));

extern char * RemoveStreamError P_((struct streamsched *ss));

/* Unknown functions does not modify *int_val or *str_val */

extern void StreamInfo P_((struct streamsched *ss, 
			   enum SS_info function,
			   int *int_val,  char **str_val));
					    
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
