static char rcsid[] = "@(#)$Id: imap.c,v 1.12 2001/06/09 19:37:19 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "elmtls.h"

DEBUG_VAR(Debug,__FILE__,"tls");

#ifdef ANSI_C
static imap_capa_handler imap_STARTTLS_handler;
#endif
static int imap_STARTTLS_handler(con,capa,con_size,commands,cb_size,
				 service_config,sc_size,
				 phase)
     struct connection_cache *con;
     char *capa;
     size_t con_size;
     struct imap_callbacks *commands;
     size_t cb_size;
     struct SE_option   *service_config;
     size_t sc_size;
     enum CAPA_phase *phase;
{
    union stream_types T;
    imap_states ret1;
    int tls = 1;
    int bits;

    int ret = 1;
    char * M = NULL;

    if (con_size != sizeof (*con)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: sizeof (struct connection_cache)) = %d != %d\n",
			sizeof (*con),con_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (cb_size != sizeof (*commands)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: sizeof (struct imap_callbacks)) = %d != %d\n",
			sizeof (*commands),cb_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (sc_size != sizeof (*service_config)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: sizeof (struct struct SE_option)) = %d != %d\n",
			sizeof (*service_config),sc_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }


    if (con->type != &IMAP_connection) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: connection not IMAP connection?\n"));
	goto fail;
    }
 
    if (!tls_init(1  /* Initalize random also */)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:imap_STARTTLS_handler: Initialization failed\n"));

	goto fail;
    }
   
    /* SIC!
       Both cyrus-imap and Communigate PRO lists STARTTLS 
       on capability listing when they are already active.
    */

    StreamInfo(con -> C.stream,SS_ssf,&bits,NULL);
    if (bits > 0) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:imap_STARTTLS_handler: Already %d 'bits' encryption -- TLS already active?\n",
			bits));
	goto fail;
    }


    if (service_config) {
	if (service_config->type != &tls_options ||
	    !service_config->value) {
	    panic("TLS PANIC",__FILE__,__LINE__,"imap_STARTTLS_handler",
		  "Bad option storage",0);
	}

	if (tls_none == service_config->value->v_starttls) {
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:imap_STARTTLS_handler: tls disabled\n"));
	    goto fail;
	}

	tls = service_config->value->v_starttls;
    }


    if (!commands->start_command(con,"STARTTLS")) {
        commands->clear_command(con);
	goto fail;            /* Just fail ... */		
    }
    commands->end_command(con);

    if (!commands->command_ok(con,&ret1,NULL)) {
	commands->clear_command(con);
	goto fail;            /* Just fail .... */
    }

    commands->clear_command(con);

    /* After that we need need return failure if something
       goes wrong because connection is messed beyond repair
     */

    T = create_TLS_stream(tls);
    if (T.TYPE == NULL) {
	/* Error message ? */
	ret = 0;
	goto fail;
    }

    /* Message ????? */
    lib_transient(FRM("IMAP/%s connect to %s ..."),
		  tls ? "TLS" : "SSL",
		  con -> C.host);


    add_stream_to_head(con -> C.stream, T);

    /* Do handshake */
    while (tls_not_connected == ss_TLS_state(con -> C.stream,0)) {
	WaitStreamFor(con -> C.stream,
		      SS_setup_act);
	M =  RemoveStreamError(con -> C.stream);
        if (M)
            goto error_jump;
	
    }

    switch(ss_TLS_state(con -> C.stream,0)) {
    
    default: error_jump:
	
	if (M) {	    
	    /* Error message ? */
	    lib_error(FRM("%s"),
		      M);
	    free(M);
	    M = NULL;
	} else {
	    /* Error message ? */

	    lib_error(FRM("IMAP/%s connect to %s ... Fail"),
		      tls ? "TLS" : "SSL",
		      con -> C.host);
	}
	/* We fail hard now if connection is not OK ... */
	ret = 0;
	goto fail;

    case tls_connected:
	/* Message ????? */
	lib_error(FRM("IMAP/%s connect to %s ... Done (not verified)"),
		  tls ? "TLS" : "SSL",
		  con -> C.host);
	if (sleepmsg)
	    wait_for_timeout(sleepmsg);

	/* Need retry CAPA command */
	if (capa_prelogin == *phase)
	    *phase = capa_prelogin_again;
    }

 fail:
    return ret;

}


static struct provides_shared_IMAP_CAPA LIST[] = {
    { "STARTTLS",  1,  imap_STARTTLS_handler },
};

#ifdef ANSI_C
provides_shared_IMAP_CAPA_f provides_shared_IMAP_CAPA;
#endif
struct provides_shared_IMAP_CAPA * provides_shared_IMAP_CAPA(count,s_size)
     int *count; 
     size_t *s_size;
{
    *s_size = sizeof (struct provides_shared_IMAP_CAPA);
    
    *count = (sizeof LIST) / *s_size;

    return &(LIST[0]);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
