static char rcsid[] = "@(#)$Id: a_screen.c,v 1.6 2000/10/17 19:01:22 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/**  alias screen display routines for ELM program

**/

#include "headers.h"
#include "s_aliases.h"
#include "me.h"

char *show_status();
char *alias_type();

void alias_screen(modified) 
     int modified;
{

  
    /* Stolen from showscreen() */
  
    ClearScreen();

    alias_title(modified);
    
    last_header_page = -1;	 	/* force a redraw regardless */
    show_headers();
    
    if (mini_menu)
	show_alias_menu();
    
    show_last_error();

    /* define_softkeys(ALIAS); */
}

void alias_title(modified)
     int modified;
{
    /** display a new title line, due to re-sync'ing the aliases **/
    
    struct string * buffer = NULL;
    struct string * modmsg = NULL;

    if (modified) {
	modmsg = format_string(CATGETS(elm_msg_cat, AliasesSet, 
				       AliasesModified,
				       "(modified, resync needed) "));
    }
    else {
	modmsg = new_string(system_charset);
    }

    if (selected)
	buffer = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesSelect,
				       "Alias mode: %d shown out of %d %S[ELM %s]"),
			       selected, message_count, modmsg, version_buff);
    else if (message_count == 1)
	buffer = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesSingle,
				       "Alias mode: 1 alias %S[ELM %s]"), 
			       modmsg, version_buff);
    else
	buffer = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesPlural,
				       "Alias mode: %d aliases %S[ELM %s]"),
			       message_count, modmsg, version_buff);
    
    ClearLine(1);

    print_center(1, buffer);

    free_string(&modmsg);
    free_string(&buffer);
}

void show_alias_menu()
{
	/** write alias menu... **/
	/* Moved from alias.c */

	if (user_level == RANK_AMATEUR) {	/* Give less options  */
	    print_format_center(elm_LINES-7, 
				CATGETS(elm_msg_cat, AliasesSet, 
					AliasesRMenuLn1,
					"You can use any of the following commands by pressing the first character;"));
	    print_format_center(elm_LINES-6, 
				CATGETS(elm_msg_cat, AliasesSet, 
					AliasesRMenuLn2,
					"a)lias current message, n)ew alias, d)elete or u)ndelete an alias,"));
	    print_format_center(elm_LINES-5, 
				CATGETS(elm_msg_cat, AliasesSet, 
					AliasesRMenuLn3,
					"m)ail to alias, or r)eturn to main menu.  To view an alias, press <return>."));
	  print_format_center(elm_LINES-4, 
			      CATGETS(elm_msg_cat, AliasesSet, 
				      AliasesRMenuLn4,
				      "j = move down, k = move up, ? = help"));
	}
	else {
	    print_format_center(elm_LINES-7, 
				CATGETS(elm_msg_cat, AliasesSet, 
					AliasesMenuLn1,
					"Alias commands:  ?=help, <n>=set current to n, /=search pattern"));
	    print_format_center(elm_LINES-6, 
				CATGETS(elm_msg_cat, AliasesSet, 
					AliasesMenuLn2,
					"a)lias current message, c)hange, d)elete, e)dit aliases.text, f)ully expand,"));
	    print_format_center(elm_LINES-5, 
				CATGETS(elm_msg_cat, AliasesSet, 
					AliasesMenuLn3,
					"l)imit display, m)ail, n)ew alias, r)eturn, t)ag, u)ndelete, or e(x)it"));
	}
}

struct string *build_alias_line(entry, message_number, highlight)
     struct alias_rec *entry;
     int message_number, highlight;
{
    /** Build in buffer the alias header ... entry is the current
	message entry, 'highlight' is either TRUE or FALSE,
	and 'message_number' is the number of the message.
    **/
    
    struct string * buffer   = NULL;
    struct string * mybuffer = NULL;
    struct string * ret      = NULL;

    int name_width;
    
    buffer = format_string(FRM("%s%s%c%-3d "),
			   (highlight && arrow_cursor)? "->" : "  ",
			   show_status(entry->status,NULL),
			   (entry->status & TAGGED?  '+' : ' '),
			   message_number);
	
    /* Set the name display width. */
    name_width = elm_COLUMNS-40;

    /* Put the name and associated comment 
       (or just the address if null) in local buffer */
    if (strlen(entry->name)) {
	if (strlen(entry->comment))
	    mybuffer = format_string(FRM("%.100s, %.100s"), 
				     entry->name, entry->comment);
	else
	    mybuffer = format_string(FRM("%.100s"), 
				     entry->name);
    } else
	mybuffer = format_string(FRM("%.100s"), 
				 entry->address);
    
    /* complete line with name, type and alias. */
    ret = format_string(FRM("%S%-*.*S %s %-18.18s"),
			buffer,
			/* give max and min width parameters for 'name' */
			name_width, name_width, mybuffer,
			alias_type(entry->type),
			entry->alias);
    
    free_string(&mybuffer);
    free_string(&buffer);
    
    return ret;
}

char *alias_type(type)
int type;
{
	/** This routine returns a string showing the alias type,
	    'Person' or 'Group' aliases.  Additionally, a '(S)'
	    is appended if this is a system alias.
	**/

	static char mybuffer[10];
	extern char *a_group_name, *a_person_name, *a_system_flag;

	if (type & GROUP)    strfcpy(mybuffer, a_group_name, sizeof mybuffer);
	else		     strfcpy(mybuffer, a_person_name, sizeof mybuffer);

	if (type & SYSTEM)   strfcat(mybuffer, a_system_flag, sizeof mybuffer);
	else		     strfcat(mybuffer, "   ", sizeof mybuffer);

	return( (char *) mybuffer);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
