static char rcsid[] = "@(#)$Id: exitprog.c,v 1.6 2001/06/06 18:09:06 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "headers.h"
#include "s_elm.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

int exit_prog()
{
	/** Exit, abandoning all changes to the mailbox (if there were
	    any, and if the user say's it's ok)
	**/

	char msg[SLEN], answer;
	register int i, changes;

	DPRINT(Debug,1,
	       (&Debug, "\n\n-- exiting --\n\n"));

	/* Determine if any messages are scheduled for deletion, or if
	 * any message has changed status
	 */
	for (changes = 0, i = 0; i < message_count; i++)
	  if (ison(headers[i]->status, DELETED) || headers[i]->status_chgd)
	    changes++;
		
	if (changes) {
	  /* YES or NO on softkeys */
	  /*
	  if (hp_softkeys) {
	    define_softkeys(YESNO);
	    softkeys_on();
	  }
	  */
	  if (changes == 1)
	    elm_sfprintf(msg, sizeof msg,
			 CATGETS(elm_msg_cat, ElmSet, ElmAbandonChange,
				 "Abandon change to mailbox? (%c/%c) "), 
			 *def_ans_yes, *def_ans_no);
	  else
	    elm_sfprintf(msg, sizeof msg,
			 CATGETS(elm_msg_cat, ElmSet, ElmAbandonChangePlural,
				 "Abandon changes to mailbox? (%c/%c) "), 
			 *def_ans_yes, *def_ans_no);
	  answer = want_to(msg, *def_ans_no, elm_LINES-3, 0);

	  if(answer != *def_ans_yes) return -1;
	}

	FlushBuffer();
	leave(0);
	return 0;
}
