static char rcsid[] = "@(#)$Id: id_phrase.c,v 1.6 2001/06/09 10:55:09 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "headers.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"addr");

void zero_id_phrase(P)
     struct id_phrase *P;
{
    P->id   = NULL;
    P->text = NULL;
}

void free_id_phrase(P)
     struct id_phrase *P;
{
    if (P->id)
	free(P->id);
    P->id = NULL;
    if (P->text)
	free_string(&(P->text));    
}

int check_8bit_id_phrase(P)
     struct id_phrase *P;
{
    if (P->id && check_8bit_str(P->id))
	return TRUE;
    if (P->text && !can_ascii_string(P->text))
	return TRUE;
    return FALSE;
}

int check_8bit_string(P)
     struct string *P;
{
    if (!P)
	return FALSE;
    if (!can_ascii_string(P))
	return TRUE;
    return FALSE;
}

void write_id_phrase_header (f,hdr_name,P, top_encoding, enmime, hdr_charset)
     FILE *f;
     char *hdr_name; 
     struct id_phrase * P;
     int top_encoding;
     int enmime;
     charset_t hdr_charset;
{
    long POS = ftell(f);

#define LEN (ftell(f)-POS)
#define WRAP print_EOLN(f,top_encoding), (POS = ftell(f)), fputc(' ',f)

    char *c;

    if (!P -> id  && !P -> text) {
	DPRINT(Debug,9,
	       (&Debug,"write_id_phrase_header: (%s) -- NONE\n",
		hdr_name));
	return;
    }

    fputs(hdr_name,f);
    fputs(": ",f);

    DPRINT(Debug,9,(&Debug,
		    "write_id_phrase_header: (enmime=%d) %s: \n",
		    enmime,hdr_name));

    DPRINT(Debug,9,(&Debug,
		    "write_id_phrase_header: %s:",hdr_name));

    if (P->id) {
	fputs(P->id,f);
	DPRINT(Debug,9,(&Debug,
			"%s",P->id));
    }

    if (P->text) {
	int X = 0;

	if (string_len(P->text) &&
	    0x0020 == give_unicode_from_string(P->text,0)) {
	    
	    if ((LEN > 60)) {
		WRAP;
		DPRINT(Debug,9,(&Debug,
				"[WRAP]\n          "));
	    } else {
		fputc(' ',f);
		DPRINT(Debug,9,(&Debug," "));
	    }
	    X = 1;
	}

	while (string_len(P->text) > X) {
	    int x = X;
	    struct string * temp = clip_from_string(P->text,&X,900);
	    char * s = string_to_hdr(HDR_PHRASE,temp,
				     hdr_charset,enmime);
	    DPRINT(Debug,9,(&Debug,"{phrase quoted=%s}\n",s));
	    DPRINT(Debug,9,(&Debug,"\n          [%d..%d] ",x,X));
	    
	    for (c = s; *c != '\0'; c++) {
		if (*c == '\n' || 
		    (whitespace(*c) && (LEN > 75))) {
		    WRAP;
		    DPRINT(Debug,9,(&Debug,"[WRAP]\n          "));
		} else {
		    fputc(*c,f);
		    DPRINT(Debug,9,(&Debug,"%c",*c));
		}
	    }
	    
	    free(s);
	    free_string(&temp);
	}
    }
    print_EOLN(f,top_encoding);    
    DPRINT(Debug,9,(&Debug,"[EOLN]\n"));
}

void write_string_header (f,hdr_name,P, top_encoding, enmime, hdr_charset)
     FILE *f;
     char *hdr_name; 
     struct string * P;
     int top_encoding;
     int enmime;
     charset_t hdr_charset;
{
    long POS = ftell(f);

#define LEN (ftell(f)-POS)
#define WRAP print_EOLN(f,top_encoding), (POS = ftell(f)), fputc(' ',f)

    char *c;
    int X = 0;

    fputs(hdr_name,f);
    fputs(": ",f);

    DPRINT(Debug,9, (&Debug, "write_string_header: (enmime=%d) %s: \n",
		     enmime,hdr_name));

    DPRINT(Debug,9, (&Debug, "write_string_header: %s:",hdr_name));

    while (string_len(P) > X) {
	int x = X;
	struct string * temp = clip_from_string(P,&X,900);
	char * s = string_to_hdr(HDR_TEXT,temp,
				 hdr_charset,enmime);
	DPRINT(Debug,9, (&Debug,"{text encoded=%s}\n",s));
	DPRINT(Debug,9, (&Debug,"\n          [%d..%d] ",x,X));
	
	for (c = s; *c != '\0'; c++) {
	    if (*c == '\n' || 
		(whitespace(*c) && (LEN > 75))) {
		WRAP;
	        DPRINT(Debug,9, (&Debug,"[WRAP]\n          "));
	    } else {
		fputc(*c,f);
		DPRINT(Debug,9, (&Debug,"%c",*c));
	    }
	}
	
	free(s);
	free_string(&temp);
    }
    print_EOLN(f,top_encoding);    
    DPRINT(Debug,9, (&Debug,"[EOLN]\n"));
}

#undef LEN
#undef WRAP

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
