static char rcsid[] = "@(#)$Id: in_utils.c,v 1.17 2001/06/09 12:34:57 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.17 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Mindless I/O routines for ELM 
	
**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"
#include <errno.h>

DEBUG_VAR(Debug,__FILE__,"ui");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}
static char *us2s P_((unsigned char *str));
static char *us2s(str) 
     unsigned char *str;
{
    return (char *)str;
}

extern int errno;		/* system error number */
extern int tabspacing;

unsigned alarm();

#define isstopchar(c)		(c == ' ' || c == '\t' || c == '/')
#define isslash(c)		(c == '/')
#define erase_a_char()		{ Writechar(BACKSPACE); Writechar(' '); \
			          Writechar(BACKSPACE); FlushBuffer(); }

int want_to(question, dflt, where, clear_and_center)
     char *question;
     int dflt;
     int where, clear_and_center;
{
	/** Ask 'question' on 'where' left enough to just leave room for an
	    answer, returning the answer in lower case.
	    Echo answer as full "Yes" or "No".  'dflt' is the 
	    default answer if <return> is pressed. (Note: 'dflt' is also what 
	    will be returned if <return> is pressed!)
	**/
	register int ch, cols;

redraw:
	cols = elm_COLUMNS - (strlen(question) + 5 );	/* 5 for "Yes." + 1 */
	if (cols < 0) {
	    cols = 0;
	}

	DPRINT(Debug,3, (&Debug,"want_to: pos line=%d column=%d\n",
		   where, (clear_and_center || (cols < 2)) ? 0 : cols-2));

	MoveCursor(where, (clear_and_center || (cols < 2)) ? 0 : cols-2);
	CleartoEOLN();

	PutLineX(where, clear_and_center ? cols/2 : cols,
		 FRM("%s%c%c"), question, dflt, BACKSPACE);
	FlushBuffer();

	ch = ReadCh(REDRAW_MARK);
	if (ch == REDRAW_MARK)
	  goto redraw;
	if (ch == EOF) {
	  leave(0);
	}
	ch = tolower(ch);

	while (!( ch == *def_ans_yes || ch == *def_ans_no || ch == '\n' || ch == '\r')) {
	  ch = ReadCh(REDRAW_MARK);
	  if (ch == REDRAW_MARK)
	    goto redraw;
	  if (ch == EOF) {
	    leave(0);
	  }
#ifdef ASCII_CTYPE
	  if (isascii(ch))
#endif
	    ch = tolower(ch);
	}
	if(ch == '\n' || ch == '\r')
	  ch = dflt;

	if(ch == *def_ans_yes)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmYesWord, "Yes."));
	else if (ch == *def_ans_no)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoWord, "No."));
	else {
	    DPRINT(Debug,3,(&Debug,"want_to [%s]=%c\n",question,ch));
	  return(ch); /* Don't write anything, just return */
	}
	if (sleepmsg > 0) {
#if POLL_METHOD
	    wait_for_timeout((sleepmsg + 1) / 2);
#else
	    sleep((sleepmsg + 1) / 2);
#endif
	}
	MoveCursor(where, (clear_and_center || (cols < 2)) ? 0 : cols-2);
	CleartoEOLN();

	DPRINT(Debug,3,(&Debug,"want_to [%s]=%c\n",question,ch));
	return(ch);
}

int read_number(ch, item)
     int ch;
     char *item;
{
	/** Read a number, where 'ch' is the leading digit! **/
	
	char buff[SLEN+1];
	int  num, status;

	buff[0] = ch;
	buff[1] = '\0';

redraw:
	PutLineX(elm_LINES-3, elm_COLUMNS-40,
		 CATGETS(elm_msg_cat, ElmSet, 
			 ElmSetCurrentTo,
			 "Set current %s to :"), item);
	status = optionally_enter(buff, elm_LINES-3, elm_COLUMNS-15, 
				  OE_APPEND_CURRENT|OE_REDRAW_MARK,
				  sizeof buff);
	if (status == -1)
	  return(current);
	if (status == REDRAW_MARK)
	  goto redraw;

	if (buff[0] == '\0')
	  return(current);

	sscanf(buff,"%d", &num);
	return(num);
}
				   			
int enter_helper(info) 
     struct enter_info *info;
{
    int append_current, passwd, allowmime,
	redraw, alt_solidus, allowtab, use_editor_escape,
	tabaction;
    struct string **buffer;
    int ret = 0;

    /* Only add comma on beginning of editing ... */
    int add_comma      = 0 != (info -> flags & OE_ADD_COMMA);
    
    info->ch_count = 0;
    buffer = info->give_buffer(info,em_redraw_initial);

 restart:    /* give_buffer may modify flags .... */

    append_current = 0 != (info -> flags & OE_APPEND_CURRENT);
    passwd         = 0 != (info -> flags & OE_PASSWD);
    allowmime      = 0 != (info -> flags & OE_ALLOW_MIMEENC);
    redraw         = (info -> flags & OE_REDRAW_MARK) ? REDRAW_MARK : 0;
    alt_solidus       = 0 != (info -> flags & OE_ALT_SOLIDUS);
    use_editor_escape = 0 != (info -> flags & OE_EDITOR_ESCAPE);
    tabaction         = 0 != (info -> flags & OE_TABACTION);
    allowtab          = !tabaction;

    DPRINT(Debug,4,
	   (&Debug, 
	    "== enter_helper: ch_count=%d %s%s%s%s%s%s%s%s%s\n",
	    info->ch_count,
	    append_current    ? "append_current " : "",
	    add_comma         ? "add_comma " : "",
	    passwd            ? "passwd " : "",
	    allowmime         ? "allowmime " : "",
	    redraw            ? "redraw redraw " : "",
	    alt_solidus       ? "alt_solidus " : "",
	    use_editor_escape ? "use_editor_escape " : "",
	    allowtab          ? "allowtab " : "",
	    tabaction         ? "tabaction " : ""));

    while(buffer) {
	int escaped = OFF;

	do {
	    int wrap_column = elm_COLUMNS -5;
	    struct charset_state *ch = ReadCh2(redraw|READCH_CURSOR|
					       (escaped ? 0 : 
						READCH_term_char));	       
	reprocess_key:
	    if (!ch) {
		DPRINT(Debug,4,(&Debug, "-- enter_helper: EOF?\n"));
		/* we've hit EOF */
		
		ret = 1;
		goto out;	    
	    }
	    
	    if (ch->caller_flags) {
		DPRINT(Debug,4,(&Debug, "-- enter_helper: flags: %d\n",
				ch->caller_flags));
		add_comma = 0;
		
		switch(ch->caller_flags) {
		    int len;
		    int tab_seen;
		case REDRAW_MARK:
		    ret = REDRAW_MARK;
		    goto out;
		case TERMCH_eof_char:
		    /* we've hit EOF */
		    
		    ret = 1;
		    goto out;
		case TERMCH_backspace:		
		    if (!append_current && info->ch_count == 0 && *buffer) {
			struct string * str = new_string((*buffer)->
							 string_type);
			free_string(buffer);
			*buffer = str;
			
			info->ch_count++;
			buffer = info->give_buffer(info,em_redraw);
			goto restart;
		    }

		    /* This is tricky. Here we are dealing with all situations
		     * under which a backspace (really whatever erase char is
		     * set to, not necessarily \b) erases the previous 
		     * character. It will erase unless escaped, because if 
		     * it's escaped it is taken literally. 
		     */
		    
		    escaped = OFF;
		    tab_seen = 0;
		    
		    if (!*buffer || 0 == ((len = string_len(*buffer)))) {
			/* Wrap to previous line if possible ... */
			buffer = info->give_buffer(info,em_bs_prev);
			if (!buffer)
			    goto restart;
		    }

		    if (*buffer && 0 < (len = string_len(*buffer))) {
			int X = 0;
			struct string * str = clip_from_string(*buffer,&X,
							       len-1);
			uint16 c = give_unicode_from_string(*buffer,len-1);
			
			if (0x0009 /* HT */  == c)
			    tab_seen++;
			else if(!passwd)
			    Writechar(BACKSPACE);
			
			free_string(buffer);
			*buffer = str;
		    }
		    if(!passwd) {
			if (tab_seen) {   /* Redraw if TABulators */
			    
			    buffer = info->give_buffer(info,em_redraw);
			    goto restart;
			} else {
			    Writechar(' ');
			    Writechar(BACKSPACE);
			}
			FlushBuffer();
		    }
		    break;
		case TERMCH_word_erase:
		    if (!append_current && info->ch_count == 0 && *buffer) {
			struct string * str = new_string((*buffer)->
							 string_type);
			free_string(buffer);
			*buffer = str;
			
			info->ch_count++;
			buffer = info->give_buffer(info,em_redraw);
			goto restart;
		    }
		    
		    if (!passwd) {	/* back up a word! */
			uint16 c;
			int X = 0;
			struct string * str;
			tab_seen = 0;
			
			if (!*buffer || 0 == (len = string_len(*buffer)))
			    continue;		/* no point staying here.. */
			len--;
			
			if (0x002F /* / */
			    == give_unicode_from_string(*buffer,len)) {
			    len--;
			    erase_a_char();
			} else {			
			    while (len >= 0 && 
				   ( c = give_unicode_from_string(*buffer,
								  len)) &&
				   ( 0x0020 /* SPACE */ == c ||
				     0x0009 /* HT */    == c)) {
				len--;
				if (0x0009 /* HT */  == c)
				    tab_seen++;
				if (!tab_seen)
				    erase_a_char();
			    }
			    
			    while (len >= 0 && 
				   ( c = give_unicode_from_string(*buffer,len)) &&
				   0x0020 /* SPACE */  != c &&
				   0x0009 /* HT */     != c &&
				   0x002F /* '/' */    != c) {
				
				len--;
				if (0x0009 /* HT */  == c)
				    tab_seen++;
				if (!tab_seen)
				    erase_a_char();
			    }
			}
			str = clip_from_string(*buffer,&X,len+1);
			free_string(buffer);
			*buffer = str;
			if (tab_seen) {   /* Redraw if TABulators */
			    buffer = info->give_buffer(info,em_redraw);
			    goto restart;
			} 
		    }
		case TERMCH_reprint_char:
		    if (info->ch_count == 0) 
			buffer = info->give_buffer(info,em_redraw_initial);
		    else
			buffer = info->give_buffer(info,em_redraw);
		    goto restart;
		case TERMCH_kill_line:
		    if (*buffer) {
			struct string * str = new_string((*buffer)->
							 string_type);
			free_string(buffer);
			*buffer = str;
		    }
		    info->ch_count++;
		    buffer = info->give_buffer(info,em_redraw);
		    goto restart;
		case TERMCH_interrupt_char:
		    if (*buffer)
			free_string(buffer); /* clean up string, and... */
		    
		    ret = -1;
		    goto out;
		case LEFT_MARK:
		    buffer = info->give_buffer(info,em_left);
		    goto restart;
		case UP_MARK:
		case DOWN_MARK:
		case RIGHT_MARK:
		    if (!append_current && info->ch_count == 0 && *buffer) {
			/* Goto end of buffer */
			info->ch_count++;
			buffer = info->give_buffer(info,em_redraw);
			goto restart;
		    }
		    switch(ch->caller_flags) {
		    case UP_MARK:
			buffer = info->give_buffer(info,em_prev);
			goto restart;		
		    case DOWN_MARK:
			buffer = info->give_buffer(info,em_next);
			goto restart;		
		    case RIGHT_MARK:
			buffer = info->give_buffer(info,em_right);
                        goto restart;
		    }
		    break;
		}
	    } else if (use_editor_escape && 
		       state_is_onebyte(ch) == escape_char &&
		       info->ch_count == 0 &&
		       (!append_current || 
			!*buffer ||
			0 == string_len(*buffer))) {
		DPRINT(Debug,4,(&Debug,
				"-- enter_helper:  editor escape (%c)\n",
				escape_char));
		/* NOTE: em_editor_escape must NOT set OE_editor_escape */
		info -> flags &= ~OE_EDITOR_ESCAPE;
		buffer = info->give_buffer(info,em_editor_escape);
		goto restart;		
	    } else {
		uint16 code = give_unicode_from_state(ch);
		DPRINT(Debug,(passwd ? 51 : 4),
		       (&Debug,	    
			"-- enter_helper:  unicode=%04X\n",
					   code));
		if (info->ch_count++ == 0) {
		    if (code == 0x000A /* LF */ || 
			code == 0x000D /* CR */ ) {
			
			buffer = info->give_buffer(info,em_enter);
			goto restart;
		    } else if (alt_solidus && code == 0x002F /* '/' */) {
			ret = OE_ALT_SOLIDUS;
			goto out;
		    } else if (! append_current || !*buffer) {
			CleartoEOLN();
			if (*buffer)
			    free_string(buffer);
			*buffer = new_string(ch->charset);
		    }
		}
		
		switch (code) {
		case 0x000A: /* LF */ 
		case 0x000D: /* CR */
		    buffer = info->give_buffer(info,em_enter);
		    goto restart;
		case 0x000C: /* Ctrl-L */ 
		    if (redraw) {
			buffer = info->give_buffer(info,em_redraw);
			ret = REDRAW_MARK;
			goto out;
		    }
		    goto other;
		case 0x0000: 
		    if (*buffer)
			free_string(buffer); /* clean up string, and... */
		    
		    ret = -1;
		    goto out;
		case 0x003D:  /* '=' */
		    if (allowmime && !escaped && !passwd) {
			/* Allow user to PASTE mime encoded words 
			 * (not editing) 
			 */
			int len = string_len(*buffer);
			int ok = 1;
			int raw = '=';
			int x1,y1;
			int idx = 0;
			struct string * temp = NULL;
			struct string * temp2 = NULL;
			
			
			/* MIME encoded word can be totally 75 characters 
			   ... */
			char raw_data[80];
			uint16 c;
			
			if (len > 0 &&
			    ( c = give_unicode_from_string(*buffer,len-1)) &&
			    0x0020 /* SPACE */  != c &&
			    0x0009 /* HT */     != c)
			    goto other;
			
			GetXYLocation(&x1, &y1);
			StartBold();
			while (ok) {
			    
			    if (idx > 78) {
				ok = 0;
				break;
			    }
			    raw_data[idx++] = raw;
			    Writechar(raw);
			    
			    ch = ReadCh2(redraw|READCH_CURSOR|
					 READCH_term_char);
			    
			    if (ch -> caller_flags) {
				ok = 0;
				break;
			    }
			
			    raw = state_is_onebyte(ch);
			    DPRINT(Debug,4,(&Debug,
					    "-- enter_helper:  raw=%d (%c)\n",
					    raw,raw));
			    if (!raw) {
				ok = 0;
				break;
			    } else if ('\\' == raw) { 
				/* No escape in mime encoded word ... */
				ok = 0;
				break;
			    } else if (1 == idx && '?' != raw) {
				/* Not start with =? */
				ok = 0;
				break;
			    } else if (whitespace(raw) ||
				       '\r' == raw ||
				       '\n' == raw) {
				/* Terminating characters */
				break;
			    } else if (raw < ' ' || raw > 126) {
				ok = 0;
				break;
			    }
			}
			EndBold();
			MoveCursor(x1,y1);
			CleartoEOLN();
			raw_data[idx] = '\0';
			
			DPRINT(Debug,4,(&Debug, 
					"-- enter_helper: ok=%d, encoded word=%s\n",
					ok,raw_data));
			
			temp = hdr_to_string(HDR_TEXT,raw_data,
					     display_charset,ok);
			temp2 = cat_strings(*buffer,temp,0);
			free_string(buffer);
			*buffer = temp2;
			free_string(&temp);
			
			/* We redraw buffer on here so that it is
			   visible if catenate succeed or not ...
			*/
			buffer = info->give_buffer(info,em_redraw);
			if (!buffer)
			    goto restart;
			
			goto reprocess_key;
		    }
		    goto other;
		case 0x0009: /* HT */
		    if (tabaction) {
			DPRINT(Debug,4,(&Debug, "-- tabaction...\n"));
			buffer = info->give_buffer(info,em_tabaction);
			if (!buffer)
			    goto restart;
			break;
		    }
		    goto other;
		default:
		other:
		    if (!*buffer)
			*buffer = new_string(ch->charset);
		    if (escaped) {  /* We erase last \ */
			int len = string_len(*buffer);
			int X = 0;
			struct string * str = 
			    clip_from_string(*buffer,&X,len-1);
			
			erase_a_char();
			free_string(buffer);
			*buffer = str;
			
			escaped = OFF; 
		    } else if (code == 0x005C /* \ */ &&
			       !passwd) {
			escaped = ON;
		    } else if (add_comma &&
			       !passwd) {
			int line, col;
			int len;

			/* Add comma (,) after addresses on header
			   editing screen ... */
			
			GetXYLocation(&line, &col);
			
			if (col +1 >= elm_COLUMNS) {
			    buffer = info->give_buffer(info,em_next);
			    if (!buffer)
				goto restart;
			}
			len = string_len(*buffer);

			/* If user typed comma we not need auto-add
			   another one
			*/
			if (0x002C /* ',' */    == code)
			    add_comma = 0;
			else if (len > 0) {
			    uint16 c,c2;

			    c = give_unicode_from_string(*buffer,len-1);
			    
			    /* Add comma before TAB  or
			       after '>' and ')' */
			    if ((0x0009 /* HT */    == code &&
				 0x0009 /* HT */    != c &&
				 0x0020 /* SPACE */ != c &&
				 0x002C /* ',' */   != c) ||
				(0x0020 /* SPACE */  != code &&
				 0x003E /* '>' */   == c) ||
				0x0029 /* ')' */   == c) {
				
				add_ascii_to_string(*buffer,s2us(","));
				Writechar(',');
				
				/* Only add comma on beginning
				   of editing */
				add_comma = 0;				
			    } else if (len > 1 &&
				       (c2 = give_unicode_from_string(*buffer,
								     len-2)) &&
				       /* Add comma before last character */
				       0x002C /* ',' */   != c2 &&
				       0x0020 /* SPACE */ == c  &&
				       0x0028 /* '('  */ != code &&
				       0x003C /* '<'  */ != code) {
				int X = 0;
				struct string * str = 
				    clip_from_string(*buffer,&X,len-1);
				
				add_ascii_to_string(str,s2us(", "));
				free_string(buffer);
				*buffer = str;

				Writechar(BACKSPACE);
				Writechar(',');		
				Writechar(' ');		

				/* Only add comma on beginning
				   of editing */
				add_comma = 0;
			    } else if (0x0020 /* SPACE */ != code)
				add_comma = 0;
			}  
		    }
		    
		    /* Note that HT (0x0009) is not printable character
		       but space (0x0032) is printable character
		    */
		    if (0x0009 /* HT */    == code &&
			allowtab) {		    
			int line,col;

			GetXYLocation(&line, &col);
			
			if (!passwd &&
			    ((col / tabspacing ) +1) * tabspacing
			    >= elm_COLUMNS) {
			    buffer = info->give_buffer(info,em_next);
			    if (!buffer)
				goto restart;
			}
			
			add_state_to_string(*buffer,ch);
			if (!passwd) {
			    Write_to_screen(FRM("%C"),ch);
			    
			    /* Call possible word wrapping routine 
			     */
			    GetXYLocation(&line, &col);
			    if (col >= wrap_column) {
				buffer = info->give_buffer(info,em_wrap);
				if (!buffer)
				    goto restart;
			    }
			}
		    } else if (!state_printable(ch) && !passwd) {
			/* non-printing character - warn with bell */
			Writechar('\007');		    
			
		    } else {
			int line, col;
			
			GetXYLocation(&line, &col);
			
			if (!passwd && col +1 >= elm_COLUMNS) {
			    buffer = info->give_buffer(info,em_next);
			    if (!buffer)
				goto restart;
			}
		    
			if (!*buffer)
			    *buffer = new_string(ch->charset);
			add_state_to_string(*buffer,ch);
			if (!passwd) {
			    Write_to_screen(FRM("%C"),ch);
			    
			    /* Call possible word wrapping routine */
			    GetXYLocation(&line, &col);
			    if (col >= wrap_column) {
				buffer = info->give_buffer(info,em_wrap);
				if (!buffer)
				    goto restart;
			    }
			}
		    }
		}
	    }
	} while(1);
    }

 out:
    DPRINT(Debug,9,(&Debug,
		    "enter_helper=%d (returns)\n",ret));
    return ret;
}
			    
static struct string **gb_optionally_enter P_((struct enter_info *I,
					       enum enter_mode em));

static struct string **gb_optionally_enter(I,em)
     struct enter_info *I;
     enum enter_mode em;
{
    int passwd         = 0 != (I->flags & OE_PASSWD);
    int append_current = 0 != (I->flags & OE_APPEND_CURRENT);

    switch(em) {
    case em_redraw_initial:
	if (!append_current) {
	    PutLineX(I->px, I->py, FRM("%S"), I->pvector[0]);
	    if(!passwd && I->pvector[1]) {
		Write_to_screen(FRM("%S"), I->pvector[1]);	
		CleartoEOLN();
		MoveCursor(I->px,I->py + string_len(I->pvector[0]));
	    }
	    I->ch_count = 0;
	    break;
	}
	/* FALLTHRU */

    case em_redraw:
	PutLineX(I->px, I->py, FRM("%S"), I->pvector[0]);

	if(!passwd && I->pvector[1]) {
	    Write_to_screen(FRM("%S"), I->pvector[1]);	
	}
	CleartoEOLN();
	break;
    case em_enter:
	DPRINT(Debug,4,
	       (&Debug, "-- gb_optionally_enter(..,%d)=NULL\n",
		em));

	return NULL;
    }

    DPRINT(Debug,4,(&Debug, "-- gb_optionally_enter(..,%d)=non null\n",
		    em));


    return &(I->pvector[1]);
}


int optionally_enter2 P_((struct string **buffer, 
			 int x, int y, int flags, 
			 const char * format, const char *msg, ...));

int optionally_enter2 (
#if ANSI_C
		      struct string **buffer, 
		      int x, int y, int flags, 
		      const char * format, const char *msg, ...
#else
		      buffer, x, y, flags, format, msg, va_alist
#endif
		      )
#if !ANSI_C
     struct string **buffer;
     int x; 
     int y; 
     int flags; 
     CONST char * format; 
     CONST char *msg;
     va_dcl     
#endif
{
    
    /** This will display the string on the screen and allow the user to
	either accept it (by pressing RETURN) or alter it according to
	what the user types.   The various flags are:
	string    is the buffer to use (with optional initial value)
	x,y	   is the location we're at on the screen (-1,-1 means
	that we can't use this info and need to find out
	the current location)
	append_current  means that we have an initial string and that
	the cursor should be placed at the END of the line,
	not the beginning (the default).
	passwd	   accept non-printing characters and do not echo
	entered characters.
      
	If we hit an interrupt or EOF we'll return non-zero.
    **/
   
    int ret = 0;

    struct string *question = NULL;
    struct string *vector[2];
    struct enter_info INFO;

    static int nested_redraw_mark   = 0;

    va_list vl;

    Va_start(vl, msg);           /* defined in defs.h */
    question = elm_smessage(0,format,msg,vl);
    va_end(vl);

    if(!(x >=0 && y >= 0))
	GetXYLocation(&x, &y);
    
    if (redraw && nested_redraw_mark) {
	nested_redraw_mark = 0;
	  
	DPRINT(Debug,4,
	       (&Debug,
		"optionally_enter2: nested_redraw_mark set returning REDRAW_MARK\n"));
	ret = REDRAW_MARK;
	goto out;
    }

    nested_redraw_mark = 1;

    /** now we have the screen as we want it and the cursor in the 
	right place, we can loop around on the input and return the
	string as soon as the user presses <RETURN>
    **/

    vector[0] = question;
    vector[1] = *buffer;
    
    INFO.counter     = 0;
    INFO.pvector     = vector;
    INFO.px          = x;
    INFO.py          = y;
    INFO.give_buffer = gb_optionally_enter;
    INFO.flags       = flags;
    INFO.ch_count    = 0;
    INFO.builtin     = NULL;
    INFO.dir_p       = NULL;
    
    ret = enter_helper(&INFO);
    
    *buffer = vector[1];

 out:
    nested_redraw_mark = 0;
    free_string(&question);

    DPRINT(Debug,4,(&Debug,  
		    "-- optionally_enter2=%d (%s%s*buffer=%p%s)\n",
		    ret,
		    ret == REDRAW_MARK ? "REDRAW_MARK, ": "",
		    ret == OE_ALT_SOLIDUS ? "OE_ALT_SOLIDUS, ": "",
		    *buffer,
		    *buffer ? "" : " = NULL"));	 
    nested_redraw_mark = 0;
    return ret;
}

int optionally_enter(string, x, y, flags, size)
     char *string;
     int  x,y,flags; 
     int size;
{
    int ret;
    struct string * buffer = NULL;
    char *str = NULL;

    DPRINT(Debug,50,
	   (&Debug, 
	    "optionally_enter: flags=%d size=%d\n",
	    flags,size));

    buffer = new_string2(display_charset,s2us(string));
    
    ret = optionally_enter2(&buffer,x,y,flags,FRM(""));
    
    if (buffer)
	/* Includes only printable characters if not passwd,
	 * so we not need ask printable only characters
	 */
	str = us2s(stream_from_string(buffer,0,NULL));	    

    if (str) {
	strfcpy(string,str,size);	
    } else
	string[0] = '\0';

    DPRINT(Debug,50,(&Debug,  
		     "optionally_enter=%d string=%s\n",
		     ret,string));

    return(ret);
}

int pattern_enter(string, alt_string, x, y, alternate_prompt, 
		  string_size, alt_string_size)
     char *string, *alt_string, *alternate_prompt;
     int  x,y;
     int string_size,alt_string_size;
{
	/** This function is functionally similar to the routine
	    optionally-enter, but if the first character pressed
	    is a '/' character, then the alternate prompt and string
	    are used rather than the normal one.  This routine 
	    returns 1 if alternate was used, 0 if not
	**/

	int ch;
	register int iindex = 0, escaped = OFF;

	PutLineX(x, y, FRM("%s"), string);	
	CleartoEOLN();
	MoveCursor(x,y);

	ch = ReadCh(0|READCH_NOCURSOR);

	if (ch == '\n' || ch == '\r') {
	  return(0);	/* we're done.  No change needed */
	}
	
	if (ch == '/') {
	  int status;
	  PutLineX(x, 0, FRM("%s"), alternate_prompt);
	  CleartoEOLN();
	  status = optionally_enter(alt_string, x, strlen(alternate_prompt)+1,
				    OE_REDRAW_MARK,alt_string_size);
	  while (REDRAW_MARK == status) {
	    PutLineX(x, 0, FRM("%s"), alternate_prompt);
	    status = optionally_enter(alt_string, x, 
				      strlen(alternate_prompt)+1,
				      OE_REDRAW_MARK|OE_APPEND_CURRENT,
				      alt_string_size);
	  }

	  return(1);
	}

	CleartoEOLN();

	iindex = 0;

	if (ch == kill_line) {
	  MoveCursor(x,y);
          CleartoEOLN();
	  iindex = 0;
	}
	else if (ch != backspace) {
	  if(ch == '\\') escaped = ON;
	  Writechar(ch);
	  string[iindex++] = ch;
	}
	else if (iindex > 0) {
	  iindex--;
	  erase_a_char();
	}
	else {
	  Writechar(' ');
	  Writechar(BACKSPACE);
	}

	do {
	  FlushBuffer();
	  ch = ReadCh(0);

	  /* the following is converted from a case statement to
	     allow the variable characters (backspace, kill_line
	     and break) to be processed.  Case statements in
	     C require constants as labels, so it failed ...
	  */

	    if (ch == backspace &&
	      (!escaped || 
	       (
#ifdef ASCII_CTYPE
		!isascii(ch)||
#endif
		!isprint(ch))
	       ) ) {
	      /* This is tricky. Here we are dealing with all situations
	       * under which a backspace (really whatever erase char is
	       * set to, not necessarily \b) erases the previous character.
	       * It will erase unless escaped, because if it's escaped
	       * it is taken literally. There is one exception to that --
	       * if backspace would be rejected (we don't accept non-printing
	       * characters in non-passwd mode), we accept it here as an
	       * erasing character, for it if got rejected there would
	       * be no way of erasing a preceding backslash. */
	      escaped = OFF;
              if (iindex > 0) {
		iindex--;
		erase_a_char();
	      }
	      else {
		Writechar(' ');
		Writechar(BACKSPACE);
	      }
	    }
	    else if (ch == '\n' || ch == '\r') {
	      escaped = OFF;
	      string[iindex] = '\0';
	      return(0);
	    }
	    else if (ch == word_erase && !escaped) {
	      escaped = OFF;
	      if (iindex == 0)
	        continue;		/* no point staying here.. */
	      iindex--;
	      if (isslash(string[iindex])) {
	        erase_a_char();
	      }
	      else {
	        while (iindex >= 0 && isspace(string[iindex])) {
	          iindex--;
	          erase_a_char();
	        }

	        while (iindex >= 0 && ! isstopchar(string[iindex])) {
	          iindex--;
	          erase_a_char();
	        }
	        iindex++;/* and make sure we point at the first AVAILABLE slot */
	      }
	    }
	    else if (ch == reprint_char && !escaped) {
	      escaped = OFF;
	      string[iindex] = '\0';
	      PutLineX(x,y, FRM("%s"), string);	
	      CleartoEOLN();
	    }
	    else if (!escaped && ch == kill_line) {
	      /* needed to test if escaped since kill_line character could
	       * be a desired valid printing character */
	      escaped = OFF;
	      MoveCursor(x,y);
              CleartoEOLN();
	      iindex = 0;
	    }
	    else if (ch == '\0' || 
		     (ch == interrupt_char && !escaped)) {
	      escaped = OFF;	      
	      string[0] = '\0'; /* clean up string, and... */
	      return(-1);
	    }
	    else if (
#ifdef ASCII_CTYPE
		     !isascii(ch)||
#endif
		     !isprint(ch)) {
	      /* non-printing character - warn with bell*/
	      /* don't turn off escaping backslash since current character
	       * doesn't "use it up".
	       */
	      Writechar('\007');
	    }
	    else {  /* default case */
		if(escaped && (ch == backspace || ch == kill_line)) {
		  /* if last character was a backslash,
		   * and if this character is escapable
		   * simply write this character over it even if
		   * this character is a backslash.
		   */
		  Writechar(BACKSPACE);
		  iindex--;
		  string[iindex++] = ch;
		  Writechar(ch);
		  escaped = OFF;
		} else {
		  string[iindex++] = ch;
		  Writechar(ch);
		  escaped = ( ch == '\\' ? ON : OFF);
		}
	    }
	} while (iindex < string_size-1);

	string[iindex] = '\0';
	return(0);
}

int GetPrompt()
{
	/** This routine does a read/timeout for a single character.
	    The way that this was determined is that the routine to
	    read a character is called, then the "errno" is checked
	    against EINTR (interrupted call).  If they match, this
	    returns NO_OP_COMMAND otherwise it returns the normal
	    command.  On many systems, the EINTR will never be returned
	    so we instead longjmp from the signal handler.
	**/

	int ch;

	if (elm_timeout > 0) {
	  alarm((unsigned) elm_timeout);
	}
	if (SETJMP(GetPromptBuf)) {
	  InGetPrompt = 0;
	  ch = NO_OP_COMMAND;	  
	  alarm((unsigned) 0);

	  close_cached_connections();
	}
	else {
	  errno = 0;
	  InGetPrompt = 1;
	  ch = ReadCh(0|READCH_CURSOR);
	  if (errno == EINTR)  ch = NO_OP_COMMAND;
#ifdef	EAGAIN
	  if (errno == EAGAIN) ch = NO_OP_COMMAND;
#endif
#ifdef	EWOULDBLOCK
	  if (errno == EWOULDBLOCK) ch = NO_OP_COMMAND;
#endif
	  InGetPrompt = 0;
	  alarm((unsigned) 0);
	}
	return(ch);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
