static char rcsid[] = "@(#)$Id: newmbox.c,v 1.53 2001/06/14 18:25:44 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.53 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/**  read new folder **/

#include "headers.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"mbox");

#include <errno.h>

#include "me.h"   /* for defination of null_decode and text_decode */
extern int errno;

char *error_description();
long bytes();
#if  !defined(ANSI_C) && !defined(atol) /* avoid problems with systems that declare atol as a macro */
extern void rewind();
extern long atol();
#endif

static int read_headers P_((int));   /* Prototype */

static void session_lock_folder P_((struct folder_info *folder));

static void session_lock_folder(folder)
     struct folder_info *folder;
{

    DPRINT(Debug,10,(&Debug, 
		     "session_lock_folder: folder=%p (%s)\n",
		     folder,folder->cur_folder_sys));

  if (!sessionlock_folder(folder,SESSIONLOCK_NORMAL))
      silently_exit();	/* leave without tampering with it! */
}

int open_folder_lock(direction,folder) 
     int direction;
     struct folder_info *folder;
{
    DPRINT(Debug,10,(&Debug, 
		     "open_folder_lock: folder=%p (%s)\n",
		     folder,folder->cur_folder_sys));

  if (!sessionlock_folder(folder,SESSIONLOCK_CHECK))
      return 0;

  lock(direction, current_folder);
    
  return 1;
}

int newmbox(new_file, adds_only)
     char *new_file;
     int adds_only;
{
    /** Read a folder.
	
       new_file	- name of folder  to read. It is up to the calling
                  function to make sure that the file can be
                  read by the user. This is not checked in this
		  function. The reason why it is not checked here
		  is due to the situation where the user wants to
		  change folders: the new folder must be checked
		  for access *before* leaving the old one, which
		  is before this function gets called.
    adds_only	- set if we only want to read newly added messages to
                  same old folder.

		  **/

    int  same_file;
    struct folder_info *new_folder = NULL;
    
    /* determine whether we are changing files */
    same_file = current_folder && 
	0 == (strcmp(new_file, current_folder -> cur_folder_sys));
    
    if (same_file)
	new_folder = current_folder;
    else {
	new_folder = enter_new_folder(new_file);
    }
    return newmbox_1(new_folder,adds_only);
}

int newmbox_1(new_folder, adds_only)
     struct folder_info *new_folder;
     int adds_only;
{
    int ret;
    
    /* If we were reading a spool file and we are not just reading
     * in the additional new messages to the same file, we need to
     * truncate the corresponding tempfile.
     */
    int same_file =  new_folder == current_folder;
    
    if (!same_file) {
	if (current_folder) {
	    /* FREE current_folder */
	    leave_old_folder(current_folder,CLOSE_NORMAL);   
	}
	current_folder = new_folder;
      
	ret = sessionlock_folder(current_folder,SESSIONLOCK_NORMAL);
      
    } else {
	/* folder (as opposite to mailbox) can be session locked
	 * only when it is opened. That call can do session locking
	 * for both (folders and mailboxes)
	 */

	if (!adds_only)
	    ret = sessionlock_folder(current_folder,SESSIONLOCK_TRUNCATE);
	else
	    ret = sessionlock_folder(current_folder,SESSIONLOCK_NONE);
    }
  
    if (!ret) 
	silently_exit();

    DPRINT(Debug,10,(&Debug, 
		     "Mailfile opened: %s\n",
		     current_folder->cur_folder_sys));

    clear_error();
    clear_central_message();

 reread:
    read_headers(adds_only);

    if (ferror_folder(current_folder,1)) {
	DPRINT(Debug,1,(&Debug, 
			"error when reading mailfile: %s\n",
			current_folder->cur_folder_sys));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorWhenReading,
			  "Error when reading: %S"),
		  current_folder->cur_folder_disp);
	sleep_message();
	if (*def_ans_yes == want_to ("Error when reading! Reread folder?",
				     *def_ans_yes,elm_LINES,1)) {
	    adds_only = FALSE;
	    
	    DPRINT(Debug,1,(&Debug, 
			    "rereading mailfile: %s\n",
			    current_folder->cur_folder_sys));
	    if (sessionlock_folder(current_folder,SESSIONLOCK_TRUNCATE))
		goto reread;
	}
	
	rm_temps_exit();
    }
    
    if(!same_file)		/* limit mode off if this is a new file */
	selected = 0;
    if (!adds_only)		/* limit mode off if recreating headers */
	selected = 0;		/* because we loose the 'Visible' flag */
        
    return(0);
}


#ifdef ANSI_C
static unsigned char *sc2uc(char *str) { return (unsigned char *)str; }
#else
#define sc2uc(x) x
#endif


static time_t now = 0;

void header_clear(h) 
     struct header_rec *h;
{
  if (0 == now) now = time(NULL);

  h->lines            = 0;
  h->status           = 0;
  h->encrypted        = 0;
  h->exit_disposition = 0;
  h->status_chgd      = 0;
  h->content_length   = -1;
  h->offset           = -1;
  h->received_time    = now;
  h->env_from[0]      = '\0';
  if (h->from)
    free_addr_items(h->from);
  h->from             = NULL;
  if (h->to)
    free_addr_items(h->to);
  h->to               = NULL;
  if (h->cc)
    free_addr_items(h->cc);
  h->cc               = NULL;
  h->messageid[0]     = '\0';
  h->time_zone[0]     = '\0';
  h->time_menu[0]     = '\0';
  h->tz_offset        = 0;
  if (h->subject)
      free_string(&(h->subject));
  h->subject          = NULL;
  h->mailx_status[0]  = '\0';
  mime_t_clear (&(h->mime_rec));
  free_rec_mbx_info(h);
#ifdef USE_PGP
  h->pgp              = 0;
#endif
  h->binary           = 0;
  h->have_from        = 0;
}

void header_zero(h)
     struct header_rec *h;
{
  if (0 == now) now = time(NULL);

  h->lines            = 0;
  h->status           = 0;
  h->encrypted        = 0;
  h->exit_disposition = 0;
  h->status_chgd      = 0;
  h->content_length   = -1;
  h->offset           = -1;
  h->received_time    = now;
  h->env_from[0]      = '\0';
  h->from             = NULL;
  h->to               = NULL;
  h->cc               = NULL;
  h->messageid[0]     = '\0';
  h->time_zone[0]     = '\0';
  h->time_menu[0]     = '\0';
  h->tz_offset        = 0;
  h->subject          = NULL;
  h->mailx_status[0]  = '\0';
  mime_t_zero (&(h->mime_rec));
  h->mbx_info         = NULL;
#ifdef USE_PGP
  h->pgp              = 0;
#endif
  h->binary           = 0;
  h->have_from        = 0;
}

static int read_headers(add_new_only)
     int add_new_only;
{
    /** Reads the headers into the headers[] array and leaves the
	file rewound for further I/O requests.   If the file being
	read is a mail spool file (ie incoming) then it is copied to
	a temp file and closed, to allow more mail to arrive during 
	the elm session.  If 'add_new_only' is set, the program will copy
	the status flags from the previous data structure to the new 
	one if possible and only read in newly added messages.
    **/

    struct header_rec *current_header = NULL;
    long content_start = -1L,
	content_remaining = -1L,
	tmp;
    int lastpercent = 0,percent, count = 0;    
    int content_length_found = FALSE;
    int count_x,count_y;

    struct read_folder_state * read_state_ptr = NULL;
    CONST char *msg;
    
    if (!prepare_read_folder(current_folder,
			     add_new_only ? PREPARE_NEW_ONLY : PREPARE_NORMAL,
			     &read_state_ptr)) {
#if POLL_METHOD	  
	wait_for_timeout(5);
#else
	sleep(5);
#endif
	leave(0);
    }

    if (add_new_only)
	count = message_count;		/* next available  */

    ClearLine(elm_LINES-1);
    ClearLine(elm_LINES);
    if (add_new_only)
	PutLineX(elm_LINES, 0, CATGETS(elm_msg_cat, ElmSet, 
				       ElmReadingInMessage,
				       "Reading in %S, message: %d"),
		 current_folder->cur_folder_disp, message_count);
    else
	PutLineX(elm_LINES, 0, CATGETS(elm_msg_cat, ElmSet, 
				       ElmReadingInMessage0,
				       "Reading in %S, message: 0"), 
		 current_folder-> cur_folder_disp);

    GetXYLocation(&count_x,&count_y); count_y--;

    if ((msg = is_forwarded_folder(current_folder,read_state_ptr)) != NULL) {
	set_central_message(CATGETS(elm_msg_cat, ElmSet, ElmMailBeingForwardTo,
				    "Mail being forwarded to %s"), 
			    msg);	
    } else {
	int status;
	struct header_rec WRK;
	header_zero(&WRK);

	while ((status = 
		copy_envelope_folder(current_folder,read_state_ptr,
				     &WRK)) > 0) {

	    header_list_ptr parsed_headers = NULL;
	    header_list_ptr tmphdr;

	    char * buffer = NULL;
	    int len = 0;
	    
	    if (count % readmsginc == 0) {
		long f = copy_fbytes_folder(current_folder,
					    read_state_ptr);

		if (need_refresh_low_line())
		    PutLineX(elm_LINES, 0, CATGETS(elm_msg_cat, ElmSet, 
						   ElmReadingInMessage,
						   "Reading in %S, message: %d"),
			     current_folder->cur_folder_disp, count);

		percent = (int)(f * 100.0 / 
				current_folder->mailfile_size);
		/* calculation with integers overflow on big folders! */

		PutLineX(count_x, count_y, FRM("%d (%02d%%)"), count,percent);

		lastpercent = percent;
	    }

	    /** allocate new header pointers, if needed... **/
	    
	    if (count >= max_headers) {
		struct header_rec **new_headers;
		int new_max;

		new_max = max_headers + KLICK;
		if (max_headers == 0) {
		    new_headers = (struct header_rec **)
			safe_malloc(new_max * sizeof(struct header_rec *));
		}
		else {
		    new_headers = (struct header_rec **)
			safe_realloc((char *) headers,
				     new_max * sizeof(struct header_rec *));
		}
		headers = new_headers;
		while (max_headers < new_max)
		    headers[max_headers++] = NULL;
	    }

	    /** allocate new header structure, if needed... **/
	    
	    if (headers[count] == NULL) {
		struct header_rec *h = safe_malloc(sizeof(struct header_rec));
		
		header_zero(h);
		headers[count] = h;
	    }

	    header_clear(headers[count]);
	    *(headers[count]) = WRK;

	    current_header = headers[count];
	    /* current_header->offset is initialized 
	     * by copy_envelope_folder()
	     */
	    current_header->index_number = count+1;
	    content_length_found             = FALSE;
	    /* current_header->status is initialized 
	     * by copy_envelope_folder()
	     */
	    current_header->exit_disposition = UNSET;
	    current_header->content_length   = -1; /* not found yet */
	    content_start                    = -1L;
	    content_remaining                = -1L;
	    content_length_found             = FALSE;
	    current_header->binary           = TRUE;
	    current_header->have_from        = FALSE;
	    current_header->header_charset   = display_charset;


	    parsed_headers = read_folder_headers(read_state_ptr,current_folder,
						 current_header);

	    if (current_header->content_length > -1L)
		content_length_found = TRUE;	      

	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"Sensitivity"))) {
		if (0 == strcmp(tmphdr->body,"2"))
		    current_header->status |= PRIVATE_MAIL;
		else if (0 == strcmp(tmphdr->body,"3"))
		    current_header->status |= CONFIDENTIAL;
	    }

	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"Importance"))) {
		if (0 == strcmp(tmphdr->body,"2"))
		    current_header->status |= URGENT;
	    }

	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"Priority"))) {
		if (0 != istrcmp(tmphdr->body,"normal") &&
		    0 != istrcmp(tmphdr->body,"non-urgent"))
		    current_header->status |= URGENT;
	    }

	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"Action"))) {
		current_header->status |= ACTION;
	    }


	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"Content-Type"))) {
		if (0 == strcmp(tmphdr->body,"mailform"))
		    current_header->status |= FORM_LETTER | PRE_MIME_CONTENT;
		else if (is_pre_mime_content_type(&current_header->mime_rec,
						  tmphdr->body)) {
		    DPRINT(Debug,10,(&Debug, 
				     "NOT mime's content-type: %s\n",
				     tmphdr->body));
		    current_header->status |= PRE_MIME_CONTENT;
		}
	    }

	    if (current_header->binary) {
		DPRINT(Debug,10,(&Debug, 
				 "-- A binary message\n"));
	    }

	    if (content_length_found)
		content_remaining = current_header->content_length;
	    else
		content_remaining = -1;
	    content_start     = copy_fbytes_folder(current_folder,
						   read_state_ptr);

	    /* Notice that mark_keep_folder() also uses mime_rec.offset */
	    current_header->mime_rec.offset = content_start;
	    DPRINT(Debug,10,(&Debug, 
			     "-- content_start=%ld\n",content_start));

	    if (req_mime_hdrencoding &&
		!(current_header->status & MIME_MESSAGE)) {
		current_header -> status |= NOHDRENCODING;
		DPRINT(Debug,10,(&Debug, 
				 "-- Turning on NOHDRENCODING\n"));
	    }

	    if (!req_mime_bodyencoding && 
		!(current_header->status & PRE_MIME_CONTENT)) {
		current_header -> status |= MIME_MESSAGE;
		DPRINT(Debug,10,(&Debug, 
				 "-- Turning on MIME_MESSAGE\n"));
	    }

	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"Status"))) {
		strfcpy(current_header->mailx_status, tmphdr->body, WLEN);
		remove_possible_trailing_spaces(current_header->
						mailx_status);
		
		/* Okay readjust the status. If there's an 'R', message
		 * is read; if there is no 'R' but there is an 'O', message
		 * is unread. In any case it isn't new because a new 
		 * message wouldn't have a Status: header. 
		 * -- if message is re$ynced there may now be 
		 * Status: -header
		 */
		if (index(current_header->mailx_status, 'R') != NULL)
		    current_header->status &= ~(NEW | UNREAD);
		else if (index(current_header->mailx_status,'O') != NULL) {
		    current_header->status &= ~NEW;
		    current_header->status |= UNREAD;
		}
		if (index(current_header->mailx_status, 'r') != NULL)
		    current_header->status |= REPLIED;
	    }
	    
	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"Subject"))) {
		char * Subject = safe_strdup(tmphdr->body);

		if (current_header->subject)
		    free_string(&(current_header->subject));
		
		remove_possible_trailing_spaces(Subject);
		
		current_header->subject = 
		    hdr_to_string(HDR_TEXT,
				  Subject,
				  current_header->header_charset,
				  !(current_header -> status &
				    NOHDRENCODING) &&
				  is_rfc1522(Subject));		

		/* This does not work correctly with unknown character 
		   sets... */
		remove_control(current_header->subject);

		free(Subject);
	    } else if (!current_header->subject)
		current_header->subject = new_string(display_charset);


	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"From"))) {	    
		struct addr_item * addrs = 
		    break_down_address(tmphdr->body, 
				       !(current_header -> status & 
					 NOHDRENCODING) &&
				       is_rfc1522(tmphdr->body),
				       current_header->header_charset);
		
		if (addrs) {
		    if (current_header->from)
			free_addr_items(current_header->from);
		    current_header->from = addrs;

#if DEBUG
		    if (Debug.active > 10) {
			struct addr_item * p;
			for (p =  current_header->from; p->addr; p++) {
			    DPRINT(Debug,15,(&Debug, 
					     "-- from[%d] addr='%s' comment='%S' fullname='%S'\n",
					     p - current_header->from,
					     p->addr,
					     p->comment,
					     p->fullname));
				   
			}
		    }
#endif
		}	       
	    }


	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"To"))) {	    
		struct addr_item * addrs = 
		    break_down_address(tmphdr->body,
				       !(current_header -> status & 
					 NOHDRENCODING) &&
				       is_rfc1522(tmphdr->body),
				       current_header->header_charset);

		if (addrs) {
		    if (current_header->to)
			free_addr_items(current_header->to);
		    current_header->to = addrs;

#if DEBUG
		    if (Debug.active > 10) {
			struct addr_item * p;
			for (p =  current_header->to; p->addr; p++) {
			    DPRINT(Debug,15,(&Debug, 
					     "--   to[%d] addr='%s' comment='%S' fullname='%S'\n",
					     p - current_header->to,
					     p->addr,
					     p->comment,
					     p->fullname));
			}
		    }
#endif
		}	       
	    }

	    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
							"Cc"))) {	    
		struct addr_item * addrs = 
		    break_down_address(tmphdr->body,
				       !(current_header -> status & 
					 NOHDRENCODING) &&
				       is_rfc1522(tmphdr->body),
				       current_header->header_charset);

		if (addrs) {
		    if (current_header->cc)
			free_addr_items(current_header->cc);
		    current_header->cc = addrs;

#if DEBUG
		    if (Debug.active > 10) {
			struct addr_item * p;
			for (p =  current_header->cc; p->addr; p++) {
			    DPRINT(Debug,15,(&Debug, 
					     "--   cc[%d] addr='%s' comment='%S' fullname='%S'\n",
					     p - current_header->cc,
					     p->addr,
					     p->comment,
					     p->fullname));

			}
		    }
#endif
		}
	    }


	    if (0 != (current_header -> status & MIME_MESSAGE)) {
		long part_offset = current_header->offset;
		long body_offset = content_start;

		parse_mime_headers1(&current_header->mime_rec,
				    parsed_headers,
				    part_offset,body_offset,0,
				    current_header->header_charset);

		if (0 != (current_header->mime_rec.flags & 
			  MIME_SIGNED)) {
#ifdef USE_PGP
		    char protocol[STRING];
		    if (mime_get_param ("protocol", protocol, 
					current_header->
					mime_rec.type_opts, 
					sizeof protocol) &&
			0 == istrcmp(protocol,
					"application/pgp-signature"))
			current_header->pgp |= PGP_SIGNED_MESSAGE;
#endif
		}
	    }

	    delete_headers(&parsed_headers);

				     reset_body:

	    while (copy_body_folder(current_folder,read_state_ptr,
				    &buffer,&len,&content_remaining)) {
		long f = copy_fbytes_folder(current_folder,
					    read_state_ptr);

		percent = (int)(f * 100.0 / 
				current_folder->mailfile_size);

		/* calculation with integers overflow on big folders! */
		if (lastpercent / readdatapercentinc != 
		    percent / readdatapercentinc) {

		if (need_refresh_low_line())
		    PutLineX(elm_LINES, 0, CATGETS(elm_msg_cat, ElmSet, 
						   ElmReadingInMessage,
						   "Reading in %S, message: %d"),
			     current_folder->cur_folder_disp, count);

		    PutLineX(count_x, count_y, FRM("%d (%02d%%)"), 
			     count, percent);
		    lastpercent = percent;
		}
		DPRINT(Debug,13,(&Debug, "** fbytes=%ld,size=%ld -> %d%%\n",
			    f,current_folder->mailfile_size,percent));

		if (first_word(buffer,"From ")) {
		    if (!current_header->have_from) {
			current_header->have_from = 1;
			DPRINT(Debug,10,(&Debug, 
					 "-- Message have unescaped From \n"));
		    }
		}

		if (mime_body_keywords && first_word(buffer, START_ENCODE)) {
		    current_header->encrypted = 1;
		    DPRINT(Debug,10,(&Debug, "-- encrypted: %s\n",buffer));

		    /* Text/plain can be converted to application/X-ELM-encode
		     */
		    if (current_header->mime_rec.type == MIME_TYPE_TEXT && 
			(istrcmp(current_header->
				 mime_rec.subtype,"plain")==0)) {
			current_header->mime_rec.type = MIME_TYPE_APPLICATION;
			strfcpy(current_header->mime_rec.subtype, 
				"X-ELM-encode",
				sizeof current_header->mime_rec.subtype);
			/* Keep current_header->mime_rec.type_opts ! */
		    }
		    DPRINT(Debug,10,(&Debug, "-- encrypted, %d/%s; opts=%s\n",
				     current_header->mime_rec.type,
				     current_header->mime_rec.subtype,
				     NONULL(current_header->mime_rec.type_opts)));
		}

#ifdef USE_PGP
		if (strncmp(buffer, "-----BEGIN PGP", 14) == 0) {
		    if (strncmp(buffer + 15, "PUBLIC", 6) == 0) {
			current_header->pgp |= PGP_PUBLIC_KEY;
			DPRINT(Debug,10,(&Debug, "-- PGP PUBLIC KEY: %s\n",
					 buffer));
		    } else {
			char pgpbuffer[STRING];

			/* Text/plain can be converted to 
			 * application/pgp.  There will a possible
			 * loss of surrounding text, but there is no
			 * way to get around this without having the
			 * sender use the proper MIME type.  
			 */

			if (current_header->mime_rec.type == MIME_TYPE_TEXT && 
			    istrcmp(current_header->mime_rec.subtype,
				    "plain")==0) {
			    current_header->mime_rec.type = 
				MIME_TYPE_APPLICATION;
			    strfcpy(current_header->mime_rec.subtype, "pgp",
				    sizeof current_header->mime_rec.subtype);
			    /* Keep current_header->mime_rec.type_opts ! */
			}
		
			if (strncmp(buffer + 15, "SIG", 3) == 0) {
			    current_header->pgp |= PGP_SIGNED_MESSAGE;
			    DPRINT(Debug,10,(&Debug, "-- PGP signed: %s\n",
					     buffer));
			    
			    if (!mime_get_param("x-action",
						pgpbuffer,
						current_header->
						mime_rec.type_opts,
						sizeof(pgpbuffer))) {
				add_parameter_t(&(current_header->mime_rec),
						"x-action", "sign",
						FALSE);
			    }
			    DPRINT(Debug,10,(&Debug, 
					     "-- PGP signed, %d/%s; opts=%s\n",
					     current_header->mime_rec.type,
					     current_header->mime_rec.subtype,
					     NONULL(current_header->
						    mime_rec.type_opts)));
			} else {
			    current_header->pgp |= PGP_MESSAGE;
			    DPRINT(Debug,10,(&Debug, 
					     "-- PGP message: %s\n",
					     buffer));
			    
			    if (!mime_get_param("x-action",pgpbuffer,
						current_header->
						mime_rec.type_opts,
						sizeof(pgpbuffer))) {	       
				add_parameter_t(&(current_header->mime_rec),
						"x-action", "encrypt",FALSE);
			    }
			    DPRINT(Debug,10,(&Debug, 
					     "-- PGP message, %d/%s; opts=%s\n",
					     current_header->mime_rec.type,
					     current_header->mime_rec.subtype,
					     NONULL(current_header->
						    mime_rec.type_opts)));
			}
		    }
		}
#endif /* USE_PGP */
		
		if (buffer)
		    free(buffer);
	    }

	    headers[count]->lines =  copy_lines_folder(current_folder,
						       read_state_ptr);
	    tmp = headers[count]->content_length;
	    if (content_start >= 0L)
		headers[count]->content_length = 
		    copy_fbytes_folder(current_folder,read_state_ptr) - 
		    content_start;
	    else
		headers[count]->content_length = 0;
	    DPRINT(Debug,12,(&Debug, "-- content-length=%d\n",
		       headers[count]->content_length));
	    if (tmp >= 0 && headers[count]->content_length != tmp) {
		DPRINT(Debug,10,(&Debug, 
				 "  DIFFERS from header value (%ld)\n",
				 tmp));
	    }


	    if (!copy_envelope_end_folder(current_folder,read_state_ptr)) {
	    
		if (content_length_found) {
		    content_length_found = 0;
		    
		    if (copy_envelope_reset_body(current_folder,read_state_ptr,
						 &content_remaining))
			goto reset_body;

		}

		DPRINT(Debug,10,(&Debug, "-- Message %d parsing FAILED.\n",
				 count));
		status = -1;   /* FAIL */
		break;
	    }

	    DPRINT(Debug,10,(&Debug, "-- Message %d parsed.\n",count));
	    count++;

	    header_zero(&WRK);  /* Reset (NOT free) temporary work space */
	}
	if (status < 0) {
	    sleep_message();
	    end_read_folder(current_folder,&read_state_ptr,1);
	    MoveCursor(elm_LINES, 0);
	    Raw(OFF);
	    rm_temps_exit();
	}
    }
	
    if (!end_read_folder(current_folder,&read_state_ptr,0)) {
	sleep_message();
	MoveCursor(elm_LINES, 0);
	Raw(OFF);
	rm_temps_exit();
    }

    clear_error();

    /* Sort folder *before* we establish the current message, so that
     * the current message is based on the post-sort order.
     * Note that we have to set the global variable message_count
     * before the sort for the sort to correctly keep the correct
     * current message if we are only adding new messages here. */
    
    message_count = count;
    sort_mailbox(count, 1);
    
    /* Now lets figure what the current message should be.
     * If we are only reading in newly added messages from a mailfile
     * that already had some messages, current should remain the same.
     * If we have a folder of no messages, current should be zero.
     * Otherwise, if we have point_to_new on then the current message
     * is the first message of status NEW if there is one.
     * If we don't have point_to_new on or if there are no messages of
     * of status NEW, then the current message is the first message.
     */
    if(!(add_new_only && current != 0)) {
	if(count == 0)
	    current = 0;
	else {
	    current = 1;
	    if (point_to_new) {
		int another_count;

		for(another_count = 0; another_count < count; 
		    another_count++) {
		    if(ison(headers[another_count]->status, NEW)) {
			current = another_count+1;
			goto found_new;
		    }
		}
		for(another_count = 0; another_count < count; 
		    another_count++) {
		    if(ison(headers[another_count]->status, UNREAD)) {
			current = another_count+1;
			goto found_new;
		    }
		}
		switch (sortby) {
		case SENT_DATE:
		case RECEIVED_DATE:
		case MAILBOX_ORDER:
		    current = count;
		}
	    found_new: ;
	    }
	}
    }
    get_page(current);
    return(count);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

