static char rcsid[] = "@(#)$Id: out_utils.c,v 1.13 2001/06/09 13:37:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.13 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains routines used for output in the ELM program.

**/

#include "headers.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"ui");

static char err_buffer[SLEN];		/* store last error message */

static struct string * central_message_buffer = NULL;

static time_t LAST_ERROR = 0;

static void error_middle P_((CONST char *s));
void show_last_error()
{
    /** rewrite last error message! **/
    if(RawState()) {
	error_middle(err_buffer);
    }
}

static void error_wait P_((void));
static void error_wait()
{
    time_t M = time(NULL);

    if (LAST_ERROR + sleepmsg > M && RawState()) {
	int W = LAST_ERROR + sleepmsg  - M;
	DPRINT(Debug,7,(&Debug, 
			"sleeping for %d seconds for error message\n",
			W));
	FlushBuffer();
#if POLL_METHOD	  
	error_sleep(W);
#else
	sleep(W);
#endif
    }
}

void clear_error()
{      
    if(RawState()) {
	if ('\0' != err_buffer[0]) 
	    error_wait();
	MoveCursor(elm_LINES,0);
	CleartoEOLN();
	err_buffer[0] = '\0';
    }
}

/* Used by newmbox.c */
int need_refresh_low_line() {
    if ('\0' != err_buffer[0]) {
	clear_error();
	return 1;
    }
    return 0;
}

void set_error(s)
     char *s;
{
    strfcpy(err_buffer, s, sizeof err_buffer);
}

static void error_help P_((CONST char *s));
static void error_help (s)
     CONST char *s;
{
    MoveCursor(elm_LINES,0);
    CleartoEOLN();
    PutLine0(elm_LINES,(elm_COLUMNS-strlen(s))/2,s);
    FlushBuffer();
}

static void error_middle (s)
     CONST char *s;
{
    if(!RawState()) {
	fprintf(stderr,"%s\n", s);
	/* sleep if stderr points to terminal 
	 */
	if (isatty(2)) {
#if POLL_METHOD	  
	    wait_for_timeout(1);
#else
	    sleep(1);
#endif
	}
    } else if (strlen(s) < elm_COLUMNS && NULL == strchr(s,'\n'))
	error_help(s);
    else {
	char * s1 = safe_strdup(s);
	char *s2, *s3;
	
	for (s2=s1; *s2 != '\0'; s2 = s3) {
	    char c;
	    for (s3 = s2; *s3 != '\0' && s3 - s2 < elm_COLUMNS && *s3 != '\n'; s3++);
	    c = *s3;
	    *s3 = '\0';
	    error_help(s2);
	    *s3 = c;
	    if ('\n' == c)
		s3++;
	    if (*s3 != '\0') {   /* Wait between lines ...*/
#if POLL_METHOD	  
		error_sleep(1);
#else
		sleep(1);
#endif
	    }
	}
	free(s1);
    }
    strfcpy(err_buffer, s, sizeof err_buffer);	/* save it too! */
}

int error(s)
     CONST char *s;
{
    /** outputs error 's' to screen at line 22, centered! **/
  if (0 == strcmp(err_buffer,s)) {
      DPRINT(Debug,7,(&Debug, 
		      "-- duplicate error message\n"));
  } else {
      error_wait();
      LAST_ERROR = time(NULL);
  }
  
  DPRINT(Debug,1,(&Debug,  
		  "ERROR message: %s\n", 
		  s));
  error_middle(s);
  return 0;
}

static int transient P_((CONST char *s));
static int transient(s)
     CONST char *s;
{
    /** outputs error 's' to screen at line 22, centered! **/
    DPRINT(Debug,1,(&Debug,  
		    "TRANSIENT message: %s\n", 
		    s));
  LAST_ERROR = 0;  /* NO SLEEP  */
  error_middle(s);
  strfcpy(err_buffer, s, sizeof err_buffer);	/* save it too! */
  return 0;
}

static char * prompt_it P_((CONST char *str, int pass));
static char * prompt_it (str,pass) 
     CONST char *str;
     int pass;
{
    int len = strlen(str);
    int status;
    char buffer[200];
    int oldstate = RawState();

    Raw(ON);

    buffer[0] = '\0';
 redraw:
    PutLine0(elm_LINES-2, 0,str);
    CleartoEOS();
    show_last_error();
    status = optionally_enter(buffer,elm_LINES-2, len+1,
			      (pass ? OE_PASSWD : 0) |OE_REDRAW_MARK,
			      sizeof buffer);
    if (REDRAW_MARK == status)
	goto redraw;
    MoveCursor(elm_LINES-2,0);   /* Ack RETURN */
    CleartoEOS();

    Raw(oldstate);

    show_last_error();
    
    if (status != 0)
	return NULL;    
    return safe_strdup(buffer);
}

void out_util_setup() {
    set_error_handler(error);
    set_transient_handler(transient);
    set_prompt_handler(prompt_it);
}

void lower_prompt(s)
     char *s;
{
  /** prompt user for input on LINES-1 line, left justified **/
  
  if(RawState()) {
    PutLine0(elm_LINES-1,0,s);
    CleartoEOLN();
  } else {
    fprintf(stderr,"%s\n",s);
  }
}

void prompt(s)
     char *s;
{
  /** prompt user for input on LINES-3 line, left justified **/

  if(RawState()) {
    PutLine0(elm_LINES-3,0,s);
    CleartoEOLN();
  } else {
    fprintf(stderr,"%s\n",s);
  }
}

void set_central_message(
#if ANSI_C
			 const char *format, const char *line, ...
#else
			 format,line,va_alist
#endif
			 )
#if !ANSI_C
       int lineY;
       CONST char *format; 
       CONST char *line;
       va_dcl
#endif
{
    /** set up the given message to be displayed in the center of
	the current window **/ 

    va_list vl;

    if (central_message_buffer)
	free_string(&central_message_buffer);
    
    Va_start(vl, line);           /* defined in defs.h */       
    central_message_buffer = elm_smessage(0,format,line,vl);
    va_end(vl);    
}

void display_central_message()
{
    /** display the message if set... **/
    
    if(RawState()) {
	if (central_message_buffer) {
	    ClearLine(elm_LINES-15);
	    print_center(elm_LINES-15, central_message_buffer);
	    FlushBuffer();
	}
    }
}

void clear_central_message()
{
    /** clear the central message buffer **/

    if (central_message_buffer)
	free_string(&central_message_buffer);
}

void sleep_message() {
    if (sleepmsg > 0) {
#if POLL_METHOD	  
	error_sleep(sleepmsg);
#else
	sleep(sleepmsg);
#endif
    }
}

void print_center(line,buffer)
     int line; 
     struct string * buffer;
{
    int l1 = string_len(buffer);

    if (l1 <  elm_COLUMNS)
	PutLineX(line,(elm_COLUMNS - l1)/2,FRM("%S"),buffer);        
}

void print_format_center(
#if ANSI_C
       int lineY,const char *format, const char *line, ...
#else
       lineY,format,line,va_alist
#endif
)
#if !ANSI_C
       int lineY;
       CONST char *format; 
       CONST char *line;
       va_dcl
#endif
{
    va_list vl;

    struct string *text;

    Va_start(vl, line);           /* defined in defs.h */       
    text = elm_smessage(0,format,line,vl);
    va_end(vl);

    print_center(lineY,text);

    free_string(&text);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */


