static char rcsid[] = "@(#)$Id: strings.c,v 1.11 2001/06/09 15:34:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.11 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 		  Copyright (c) 1986, 1987 Dave Taylor
 * 		  Copyright (c) 1988, 1989, 1990, 1991 USENET Community Trust
 *****************************************************************************/

/** This file contains all the string oriented functions for the
    ELM Mailer, and lots of other generally useful string functions! 

    For BSD systems, this file also includes the function "tolower"
    to translate the given character from upper case to lower case.

**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"misc");

/** forward declarations **/

char *get_token();

char **argv_from_to(to) 
     char *to;
{
    int count=1;
    int idx = 0, q = 0, i;
    char *ptr=to;
    char *last;
    char **res;
    
    DPRINT(Debug,8, (&Debug, "argv_from_to: to=%s\n",to));
    
    while (*ptr) {
	int len = rfc822_toklen(ptr);
	if (len == 1 && *ptr == COMMA)
	    count++;
	
	ptr += len;
    }

    DPRINT(Debug,8, (&Debug,  "           count=%d\n",count));
    
    res = safe_malloc((count + 1) * sizeof (char *));
    
    ptr = to;
    last = ptr;
    while (*ptr) {
	int len = rfc822_toklen(ptr);
	DPRINT(Debug,20, (&Debug,  "   token: %.*s\n",len,ptr));
	if (len == 1 && *ptr == ',' && last && !q) {
	    int k;
	    *ptr = '\0';
	    rfc822_reap_comments(last,NULL,0);
	    k = strlen(last);
	    while(k > 0 && last[k-1] == ' ')
		k--;
	    last[k] = '\0';
	    res[idx++] = last;
	    DPRINT(Debug,20, (&Debug,  "   addr: %s\n",last));
	    last = NULL;
	} else if (len == 1 && *ptr == '<')
	    q = 1;
	else if (len == 1 && *ptr == '>')
	    q = 0;
        
	if (*ptr && !last && *ptr != ' ')
	    last = ptr;
	
	ptr += len;
    }
    
    if (last) {
	int k;
	*ptr = '\0';
	rfc822_reap_comments(last,NULL,0);
	k = strlen(last);
	while(k > 0 && last[k-1] == ' ')
	    k--;
	last[k] = '\0';
	res[idx++] = last;
	DPRINT(Debug,20, (&Debug,  
			  "   addr: %s\n",last));
	last = NULL;
    }
    res[idx] = 0;
    DPRINT(Debug,8, (&Debug,  "           idx=%d\n",idx));

    for (i = 0; i < idx; i++) 
	DPRINT(Debug,8, (&Debug,  "           [%d]=%s\n",i,res[i]));

    return res;
}

void split_word(buffer, first, rest)
     char *buffer, *first, *rest;
{
    int len;
    /** Rip the buffer into first word and rest of word, translating it
	all to lower case as we go along..
    **/
    
    /** skip leading white space, just in case.. **/
    
    while(whitespace(*buffer)) buffer++;
    
    /** now copy into 'first' until we hit white space or EOLN **/
    
    while (*buffer) {
	len = len_next_part(buffer);
	if (len == 1 && isspace(*buffer))
	    break;
	
	while (--len >= 0) {
#ifdef ASCII_CTYPE
	    if (!isascii(*buffer))
		*first = *buffer;	      
	    else
#endif
		*first = tolower((unsigned char)*buffer);
	    buffer++;
	    first++;
	}
    }
    
    *first = '\0';
	
    while (whitespace(*buffer)) buffer++;

/*
 *	no need to check rest of buffer for quoted strings, we are taking
 *	it all anyway.
 */

    for (; *buffer; buffer++, rest++)
#ifdef ASCII_CTYPE
	  if (!isascii(*buffer))
	    *rest = *buffer;	      
	  else
#endif
	    *rest = tolower((unsigned char)*buffer);
	*rest = '\0';

	return;
}

void Centerline(line, string)
     int line;
     char *string;
{
	/** Output 'string' on the given line, centered. **/

	register int length, col;

	length = strlen(string);

	if (length > elm_COLUMNS)
	  col = 0;
	else
	  col = (elm_COLUMNS - length) / 2;

	PutLine0(line, col, string);
}

char *argv_zero(string)
     CONST char *string;
{
    /** given a string of the form "/something/name" return a
	string of the form "name"... **/

    static char buffer[NLEN];
    int i, j=0;

    for (i=strlen(string)-1; string[i] != '/'; i--)
	buffer[j++] = string[i];
    buffer[j] = '\0';

    reverse(buffer);

    return( (char *) buffer);
}

#define MAX_RECURSION		20		/* up to 20 deep recursion */

char *get_token(source, keys, depth)
char *source, *keys;
int   depth;
{
	/** This function is similar to strtok() (see "opt_utils")
	    but allows nesting of calls via pointers... 
	**/

	register int  last_ch;
	static   char *buffers[MAX_RECURSION];
	char     *return_value, *sourceptr;

	if (depth > MAX_RECURSION) {
	   lib_error(CATGETS(elm_msg_cat, ElmSet, ElmGetTokenOverNested,
			     "Get_token calls nested greater than %d deep!"), 
		     MAX_RECURSION);
	   emergency_exit(0);
	}

	if (source != NULL)
	  buffers[depth] = source;
	
	sourceptr = buffers[depth];
	
	if (*sourceptr == '\0') 
	  return(NULL);		/* we hit end-of-string last time!? */

	sourceptr += qstrspn(sourceptr, keys);	  /* skip the bad.. */
	
	if (*sourceptr == '\0') {
	  buffers[depth] = sourceptr;
	  return(NULL);			/* we've hit end-of-string   */
	}

	last_ch = qstrcspn(sourceptr, keys);   /* end of good stuff   */

	return_value = sourceptr;	      /* and get the ret     */

	sourceptr += last_ch;		      /* ...value            */

	if (*sourceptr != '\0')		/** don't forget if we're at end! **/
	  sourceptr++;			      
	
	return_value[last_ch] = '\0';	      /* ..ending right      */

	buffers[depth] = sourceptr;	      /* save this, mate!    */

	return((char *) return_value);	     /* and we're outta here! */
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
