static char rcsid[] = "@(#)$Id: elmcharset.c,v 1.14 2001/06/16 10:40:37 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.14 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "elmutil.h"
#include "s_me.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"util");

extern char *optarg;		
extern int   optind;		

int main(argc, argv)
     int argc;
     char *argv[];
{
  int err = 0;
  int c;
  int global = 0;
  struct locale_map_item * MAP = NULL;
  char *targetfile = NULL;

#if DEBUG
  init_debugfile("ELMCHARSET");
#endif
  locale_init();
  user_init();
  init_defaults();
  
  while ((c = getopt(argc, argv, "Gd:w:I:")) != EOF) {
      FILE *X;
      char buf[LONG_STRING];
	  
    switch(c) {
    case 'G':
	global++;
	break;
 
    case 'd':
#if DEBUG
	set_debugging(optarg);	 
#else
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			  "Warning: system created without debugging enabled - request ignored\n"));
#endif
	break;
    case 'w' : 
	targetfile = optarg;
	if (0 != access(targetfile,WRITE_ACCESS)) {
	    int errcode = errno;
	    
	    if (errcode != ENOENT) {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  targetfile, error_description(errcode));
		err++;
		goto fail;
	    }
	}
	break;
    case 'I' :
	if (0 != access(optarg,READ_ACCESS)) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
			      "File %.50s is not readable: %s"),
		      optarg, error_description(errcode));
	    err++;
	    goto fail;
	}
	X = fopen(optarg,"r");
	if (!X) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
			      "File %.50s is not readable: %s"),
		      optarg, error_description(errcode));
	    err++;
	    goto fail;
	}
	while(fgets(buf,sizeof buf, X) != NULL) {
	    char *c;
	    int l1 = strlen(buf);
	    charset_t N;
	
	    if ('\n' == buf[l1 -1]) 
		buf[l1 - 1] = '\0';
	    else {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeTooLongLine,
				  "%30s: Too long line: %.30s..."),
			  optarg,buf);
		err++;
		break;
	    }
	    while (l1-- > 0 && whitespace(buf[l1]))
		buf[l1] = '\0';
	    c = buf;
	    while (*c && whitespace (*c)) /* skip leading whitespace */
		c++;
	    if ('#' == *c)
		continue;
	    if (!*c)
		continue;

	    N = MIME_name_to_charset(c,0);
	    if (N && 
		0 == istrcmp(N->MIME_name,c)) {
		N->flags &= ~SET_valid;

		SIGDPRINT(Debug,1, (&Debug, 
				    "Ignoring charset %s\n",
				    N->MIME_name));
	    } else {
		SIGDPRINT(Debug,5, (&Debug, 
				    "No charset %s to ignore%s%s\n",
				    c,N ? " -- was " : "",N->MIME_name));
	    }
	}
	fclose(X);
	break;
    case '?':
	err = 1;
	goto fail;
    }
  }


    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);

#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELMCHARSET program (version %s).\n",
			     version_buff);

#if 0	
	if (d >= 50) {
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    error_sleep(5+sleepmsg);	    
	}
#endif
    }
#endif

  if (!global)
      read_rc_file();

  if (optind < argc) {
      int errcount = 0;
      MAP = load_locale_map(argv[optind],&errcount);
      if (!MAP || errcount) {
	 err = 1;
	 goto fail;
      }
  }
	  
  if (!MAP) {
      if (global)
	  MAP = system_locale_map;
      else
	  MAP = user_locale_map;
  }

  if (targetfile) {
      char * tmp = elm_message(FRM("%s.N"),targetfile);
      int errcode = can_open(tmp,"w");
      FILE *f;
      
      if (errcode) {
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      f = fopen(tmp,"w");
      if (!f) {
	  int errcode = errno;
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      dump_locale_map(f,MAP);
      if (EOF == fclose(f)) {
	  int errcode = errno;
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			    "File %.50s is not writeable: %s"),
		    tmp, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      if (0 != rename(tmp,targetfile)) {
	  int errcode = errno;
	  lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
			    "Failed to rename temporary file to %.50s: %30s"),
		    targetfile, error_description(errcode));
	  
	  err++;
	  free(tmp);
	  goto fail;
      }
      free(tmp);
  }    
  else
      dump_locale_map(stdout,MAP);

 fail:
  if (err)
      lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			"%s failed; exit code=%d"),
		argv[0],err);

  return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
