/* @(#)$Id: save_opts.h,v 1.50 2001/05/07 18:16:40 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.50 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/*
 *	Defines for the storage of options portion of the Elm system.
 */

typedef struct {
    char letter;		/* menu letter on options screen */
    char *menu;			/* menu prompt */
    int  menu_msg;		/* NLS message number of menu prompt */
    char *parm;			/* parameter to modify */
    int (*post)();		/* post processing function */
    char *one_liner;		/* one line help message */
    int  one_liner_msg; 	/* NLS message number of one line help message */
    } opts_menu;


#define FL_LOCAL 0040          /* flag if changed */
#define FL_NOSPC 0100          /* flag if preserve blanks as "_" */
#define FL_SYS   0200          /* flag if only valid in system RC */
#define FL_OR    0400          /* flag if boolean value may have been set */
#define FL_AND  01000          /* flag if boolean value may have been unset */

typedef struct {
    int nlen;
    char **list;
}  enumerate_list;

typedef int option_func P_((char **value, int enter));

typedef struct rc_save_info_rec { 
    char 	     name[NLEN]; 	/* name of instruction */
    long 	     offset;		/* offset into elmrc-info file */
    struct rc_type * dt_type;           /* DT_STR, DT_NUM, DT_BOL, etc */
    int	             flags;	        /* FL_LOCAL, FL_NOSPC, etc */
    union {
	char 	*str;
	int 	*num;
	long  *l_num;
	int 	*bol;
	char 	*chr;
	char 	**weed;
	struct addr_rec **alts;
	int 	*sort;
#ifdef USE_PGP 
	enum pgp_version  *pgpver;
#endif
    } val;
    option_func      *func_val;
    int size_val;
    enumerate_list   *e_ptr;
} save_info_recs;

#define SAVE_INFO_STR(x) (save_info[x].val.str)
#define SAVE_INFO_NUM(x) (save_info[x].val.num)
#define SAVE_INFO_BOL(x) (save_info[x].val.bol)
#define SAVE_INFO_SRT(x) (save_info[x].val.sort)
#define SAVE_INFO_ASR(x) (save_info[x].val.sort)
#define SAVE_INFO_FUNC(x) (save_info[x].func_val)

extern int null_option_func P_((char **value, int enter));

#if __GNUC__ 
#define ZZZ_SAVE_TYPE save_info_recs
#define ZZZ_DT_ASR(A)        DT_ASR,0,   { sort: A }, null_option_func
#define ZZZ_DT_SRT(A)        DT_SRT,0,   { sort: A }, null_option_func
#define ZZZ_DT_STR(A)        DT_STR,0,   { str: A },  null_option_func
#define ZZZ_DT_STR_(x,A)     DT_STR,x, { str: A },  null_option_func
#define ZZZ_DT_ALT(A)        DT_ALT,0,   { alts: A }, null_option_func
#define ZZZ_DT_BOL(A)        DT_BOL,0,   { bol: A },  null_option_func
#define ZZZ_DT_BOL_(x,A)     DT_BOL,x, { bol: A },  null_option_func
#define ZZZ_DT_MLT(A)        DT_MLT,0,   { weed: A }, null_option_func
#define ZZZ_DT_SYN(A)        DT_SYN,0,   { str: A },  null_option_func
#define ZZZ_DT_NUM(A)        DT_NUM,0,   { num: A },  null_option_func
#define ZZZ_DT_LONG(A)       DT_NUM,0,   { l_num: A },null_option_func
#ifdef USE_PGP 
#define ZZZ_DT_PGPVER(A)     DT_PGPVER,0, { pgpver: A },null_option_func
#endif
#define ZZZ_DT_FUNC(A)       DT_FUNC,0,  { str: NULL }, A
#define ZZZ_DT_CHR(A)        &rc_DT_CHR,0,   { chr: A },  null_option_func
#define ZZZ_DT_PRM(A)        DT_PRM,0,   { num: A },  null_option_func
#define ZZZ_DT_WEE(A)        DT_WEE,0,   { weed: A }, null_option_func
#else


/*
 *	since many C compilers cannot init a union as a static
 *	init, make the same structure with just the char * for
 *	the union pointer.
 */
typedef struct { 
    char 	 name[NLEN]; 	        /* name of instruction */
    long 	 offset;		/* offset into elmrc-info file */
    struct rc_type * dt_type;           /* DT_STR, DT_NUM, DT_BOL, etc */
    int	          flags;	        /* FL_LOCAL, FL_NOSPC, etc */
    char 	 *str;
    option_func  *func;
    int              size_val;
    enumerate_list   *e_ptr;
} ZZZ_SAVE_TYPE;

#define ZZZ_DT_ASR(A) DT_ASR, 0,(char *)A,      null_option_func
#define ZZZ_DT_SRT(A) DT_SRT, 0,(char *)A,      null_option_func
#define ZZZ_DT_STR(A) DT_STR, 0,A,              null_option_func
#define ZZZ_DT_STR_(x,A) DT_STR,x,A,         null_option_func 
#define ZZZ_DT_ALT(A) DT_ALT, 0,(char *)A,      null_option_func
#define ZZZ_DT_BOL(A) DT_BOL, 0,(char *)A,      null_option_func
#define ZZZ_DT_BOL_(x,A) DT_BOL,x,(char *)A, null_option_func
#define ZZZ_DT_MLT(A) DT_MLT,0,(char *)A,      null_option_func
#define ZZZ_DT_SYN(A) DT_SYN,0,A,              null_option_func
#define ZZZ_DT_NUM(A) DT_NUM,0,(char *)A,      null_option_func
#define ZZZ_DT_LONG(A) DT_NUM,0,(char *)A,     null_option_func
#ifdef USE_PGP 
#define ZZZ_DT_PGPVER(A) DT_PGPVER,0,(char *)A,null_option_func
#endif
#define ZZZ_DT_FUNC(A) DT_FUNC,0,NULL, A
#define ZZZ_DT_CHR(A) &rc_DT_CHR,0,(char *)A, null_option_func
#define ZZZ_DT_PRM(A) DT_PRM,0,(char *)A, null_option_func
#define ZZZ_DT_WEE(A) DT_WEE,0,(char *)A, null_option_func
#endif

/* shared.c */
extern int give_options P_((char *tag, 
			    struct rc_save_info_rec ** rc_options,
			    int                       * rc_option_count));

extern void print_local_shared_options P_((FILE *F));
extern void post_init_shared_options P_((int *errors));

/* ===================================================================== */

#ifdef SAVE_OPTS

/* "lists" for DT_MLT.  These and DT_SYN could be eliminated if support
   of the old parameter names was dropped.
*/
static char *SIGS[]=    {"remotesignature","localsignature",NULL};
static char *ALWAYS[]=  {"alwayskeep",     "!alwaysstore",NULL};

static char * USERLEVELS[] = { "beginner", "intermediate", "expert", NULL };
static enumerate_list USERLEVEL = {3, &(USERLEVELS[0]) };

static char * NOENCODINGS[] = { "pass-7bit", "pass-8bit", "pass-binary", NULL };
static enumerate_list NOENCODING = {3, &(NOENCODINGS[0]) };

static char * ENV_FROM_SOURCES[] = { "forward-from", "from", "return-path", NULL };
static enumerate_list ENV_FROM_SOURCE = {3, &(ENV_FROM_SOURCES[0]) };

static char * HDR_PHRASE_DISPLAY_MODES[] = { "plain", "quoted", NULL };
static enumerate_list HDR_PHRASE_DISPLAY_MODE = 
{2, &(HDR_PHRASE_DISPLAY_MODES[0]) };

#if defined(USE_PGP) 
static char * PGP_SIGN_TYPES[] = { "application/pgp", "text/plain", 
				   "text/x-pgp", NULL };
static enumerate_list PGP_SIGN_TYPE = {3, &(PGP_SIGN_TYPES[0]) };

static char * PGP_VERSIONS[] = { "default", "pgp2", "pgp5", "gpg", NULL };
static enumerate_list PGP_VERSION = {4, &(PGP_VERSIONS[0]) };

#endif

ZZZ_SAVE_TYPE save_info_data[] = {
    {"add-in-reply-to-phrase",  -1L,ZZZ_DT_BOL(&add_irt_phrase), 0,  NULL},
    {"aliassortby",		-1L,ZZZ_DT_ASR(&alias_sortby), 0, NULL},
    {"allow-charset-switching", -1L,ZZZ_DT_BOL(&allow_charset_switching), 0, 
     NULL},
    {"alteditor",		-1L,ZZZ_DT_STR(alternative_editor),
     sizeof alternative_editor, NULL},
    {"alternatives",	-1L,ZZZ_DT_ALT(&alternative_addresses), 0, NULL},
    {"alwaysdelete",	-1L,ZZZ_DT_BOL(&always_del), 0, NULL},
    {"alwayskeep",		-1L,ZZZ_DT_BOL(&always_keep), 0, NULL},
    {"alwaysleave",		-1L,ZZZ_DT_MLT(ALWAYS), 0, NULL},
    {"alwaysstore",		-1L,ZZZ_DT_BOL(&always_store), 0, NULL},
    {"arrow",		-1L,ZZZ_DT_BOL_(FL_OR,&arrow_cursor), 0, NULL},
    {"ask",			-1L,ZZZ_DT_BOL(&question_me), 0,   NULL},
    {"askcc",		-1L,ZZZ_DT_BOL(&prompt_for_cc), 0, NULL},
#ifdef USE_PGP
    {"askpgpsig",		-1L,ZZZ_DT_BOL(&pgp_askpgpsig), 0, NULL},
#endif
    {"attribution",		-1L,ZZZ_DT_STR(attribution), 
     sizeof attribution, NULL},
    {"auto-cc",		-1L,ZZZ_DT_SYN("copy"), 0, NULL},
    {"autocopy",		-1L,ZZZ_DT_BOL(&auto_copy), 0, NULL},
#ifdef BACKGROUD_PROCESSES       
    { "background-wait-time",-1L,ZZZ_DT_NUM(&background_wait_time), 0, NULL }, 
#endif
    /* {"bounce",		-1L,ZZZ_DT_SYN("bounceback"), 0, NULL},
       {"bounceback",	-1L,ZZZ_DT_NUM(&bounceback), 0, NULL},
    */
    {"browser-wildcard-matching", -1L,ZZZ_DT_BOL(&browser_wildcards), 0, NULL},
    {"builtinlines",	-1L,ZZZ_DT_NUM(&builtin_lines), 0, NULL},
    {"calendar",		-1L,ZZZ_DT_STR(raw_calendar_file), 
     sizeof raw_calendar_file, NULL},
    {"cc",			-1L,ZZZ_DT_SYN("askcc"), 0, NULL},
    {"charset",             -1L,ZZZ_DT_SYN("text-charset"), 0, NULL},
    {"compatcharsets",	-1L,ZZZ_DT_FUNC(charset_compatfunc),0, NULL},
    {"configoptions",	-1L,ZZZ_DT_STR(config_options), sizeof config_options, 
     NULL},
    {"confirmappend",	-1L,ZZZ_DT_BOL(&confirm_append), 0, NULL},
    {"confirmcreate",	-1L,ZZZ_DT_BOL(&confirm_create), 0, NULL},
    {"confirmfiles",	-1L,ZZZ_DT_BOL(&confirm_files), 0, NULL},
    {"confirmfolders",	-1L,ZZZ_DT_BOL(&confirm_folders), 0, NULL},
    {"convert-comment-to-fullname",-1L,ZZZ_DT_BOL(&convert_comment), 0, NULL},
    {"copy",		-1L,ZZZ_DT_BOL(&auto_copy_sent), 0, NULL},
    {"default-nomime-charset", -1L,ZZZ_DT_STR(raw_default_nomime_charset), 
     sizeof raw_default_nomime_charset, NULL},
    {"delete",		-1L,ZZZ_DT_SYN("alwaysdelete"),   0, NULL},
    {"displaycharset",	-1L,ZZZ_DT_STR(raw_display_charset),
     sizeof raw_display_charset, NULL},
#ifdef USE_DSN
    {"dsn-success",         -1L,ZZZ_DT_BOL(&DSN_success), 0, NULL },
#endif
    {"easyeditor",		-1L,ZZZ_DT_STR(e_editor),   sizeof e_editor,   NULL},
    {"editor",		-1L,ZZZ_DT_STR(raw_editor), sizeof raw_editor, NULL},
    {"env-from-source",     -1L,ZZZ_DT_NUM(&env_from_source),
     sizeof env_from_source, &ENV_FROM_SOURCE},
    {"escape",		-1L,ZZZ_DT_CHR(&escape_char), 0,               NULL},
    {"extra-mailbox-dir",   -1L,ZZZ_DT_STR(raw_extra_mailbox_dir), 
     sizeof raw_extra_mailbox_dir,      NULL},
    {"folders",		-1L,ZZZ_DT_SYN("maildir"), 0,                  NULL},
    {"forcename",		-1L,ZZZ_DT_BOL(&force_name), 0,        NULL},
    {"form",		-1L,ZZZ_DT_SYN("forms"), 0,                    NULL},
    {"forms",		-1L,ZZZ_DT_BOL(&allow_forms), 0,       NULL},
    {"fullname",		-1L,ZZZ_DT_STR(full_username), 
     sizeof full_username, NULL},
#ifdef USE_PGP
    {"gpg",	        -1L,ZZZ_DT_STR(raw_gpg_path), 
     sizeof raw_gpg_path, NULL},
#endif
    {"header-phrase-display-mode", -1L, ZZZ_DT_NUM(&phrase_display_mode),
     0, &HDR_PHRASE_DISPLAY_MODE },
    {"hostdomain",		-1L,ZZZ_DT_STR_(FL_SYS,hostdomain), 
     sizeof hostdomain, NULL},
    {"hostfullname",	-1L,ZZZ_DT_STR_(FL_SYS,hostfullname), 
     sizeof hostfullname, NULL},
    {"hostname",		-1L,ZZZ_DT_STR_(FL_SYS,hostname),     
     sizeof hostname, NULL},
    /* {"hpkeypad",	-1L,ZZZ_DT_SYN("keypad"), 0, NULL}, */
    /* {"hpsoftkeys",	-1L,ZZZ_DT_SYN("softkeys"), 0, NULL}, */
#ifdef REMOTE_MBX
    {"imap-charset",       -1L,ZZZ_DT_STR(raw_imap_charset),
     sizeof raw_imap_charset, NULL},
    {"imap-connection-cache", -1L, ZZZ_DT_BOL(&IMAP_connection_cache), 0, NULL},
    {"imap-fast-lookup",   -1L,ZZZ_DT_BOL(&imap_fast_lookup), 0, NULL},
    {"imap-naming-convention",-1L,ZZZ_DT_BOL(&IMAP_name_convention), 0, NULL},
    {"imap-show-error",    -1L,ZZZ_DT_BOL(&IMAP_show_error), 0, NULL},
    {"imap-show-greeting", -1L,ZZZ_DT_BOL(&IMAP_show_greeting), 0, NULL},
    {"imap-show-warning",  -1L,ZZZ_DT_BOL(&IMAP_show_warning), 0, NULL},
    {"imap-use-examine",    -1L,ZZZ_DT_BOL(&IMAP_use_examine), 0, NULL},
#endif
    {"incoming-mailbox",    -1L,ZZZ_DT_STR(raw_defaultfile), 
     sizeof raw_defaultfile, NULL },
    {"iso646-charsets",     -1L,ZZZ_DT_FUNC(charset_iso646func),0, NULL},
    {"keep",		-1L,ZZZ_DT_SYN("keepempty"), 0, NULL},
    {"keepempty",		-1L,ZZZ_DT_BOL(&keep_empty_files), 0, NULL},
#ifdef USE_PGP
    {"keeppassfor",         -1L,ZZZ_DT_NUM(&pgp_keeppassfor), 0, NULL},
#endif
    /* {"keypad",	    -1L,ZZZ_DT_BOL_(FL_OR,&hp_terminal), 0, NULL},*/
    {"local-fast-lookup", -1L,ZZZ_DT_BOL(&local_fast_lookup), 0, NULL},
    {"local-fs-charset",  -1L,ZZZ_DT_STR(raw_local_fs_charset), 
     sizeof raw_local_fs_charset, NULL},
    {"localsignature",	-1L,ZZZ_DT_STR(raw_local_signature), 
     sizeof raw_local_signature, NULL},
#ifdef SYSCALL_LOCKING
    {"lock-folders",        -1L,ZZZ_DT_BOL(&lockfolders),0, NULL},
    {"lock-in-copy",        -1L,ZZZ_DT_BOL(&lock_in_copy),0, NULL},
#endif
    /* {"mailbox",		-1L,ZZZ_DT_SYN("receivedmail"), 0, NULL}, */
    {"maildir",		-1L,ZZZ_DT_STR(raw_folders), sizeof raw_folders, NULL},
    {"mailedit",		-1L,ZZZ_DT_SYN("editor"), 0, NULL},
    {"mailpermissions",	-1L,ZZZ_DT_PRM(&mail_permissions), 0, NULL},
    {"map-bin-dir",        -1L,ZZZ_DT_STR_(FL_SYS,raw_map_bindir), 
     sizeof raw_map_bindir, NULL},
    {"map-text-dir",        -1L,ZZZ_DT_STR_(FL_SYS,raw_map_txtdir), 
     sizeof raw_map_txtdir, NULL},
    {"menu",		-1L,ZZZ_DT_BOL_(FL_AND,&mini_menu), 0, NULL},
    {"menu-display-host", -1L,ZZZ_DT_BOL(&menu_display_host), 0, NULL}, 
    {"menus",		-1L,ZZZ_DT_SYN("menu"), 0, NULL},
    {"metamail",		-1L,ZZZ_DT_STR(raw_metamail_path), 
     sizeof raw_metamail_path, NULL},
    {"metoo",		-1L,ZZZ_DT_BOL(&metoo), 0, NULL},
    {"mimebodykeywords",	-1L,ZZZ_DT_BOL(&mime_body_keywords), 0, NULL},
    {"mimeforward",		-1L,ZZZ_DT_BOL(&mimeforward), 0, NULL},
    {"movepage",		-1L,ZZZ_DT_BOL(&move_when_paged), 0, NULL},
    {"movewhenpaged",	-1L,ZZZ_DT_SYN("movepage"), 0, NULL},
    {"name",		-1L,ZZZ_DT_SYN("fullname"), 0, NULL},
    {"names",		-1L,ZZZ_DT_BOL(&names_only), 0, NULL},
    {"noencoding",-1L,ZZZ_DT_NUM(&allow_no_encoding), 0, &NOENCODING},
    /* 1 (8bit): Allow 8bit without -B8BITMIME
     * 2 (biary): Allow binary without -BBINARYMIME and
     *    and 8bit without -B8BITMIME */
    {"nohdrencoding",       -1L,ZZZ_DT_BOL(&allow_no_hdrencoding), 0, NULL},
    {"noheader",		-1L,ZZZ_DT_BOL(&noheader), 0, NULL},
    {"noheaderfwd",		-1L,ZZZ_DT_BOL(&noheaderfwd), 0, NULL},
    {"page",		-1L,ZZZ_DT_SYN("pager"), 0, NULL},
    {"page-known-charsets",	-1L,ZZZ_DT_BOL(&page_known_charsets), 0, NULL},
    {"pagealternative",	-1L,ZZZ_DT_BOL(&pagealternative), 0, NULL},
    {"pagemultipart",	-1L,ZZZ_DT_BOL(&pagemultipart), 0, NULL},
    {"pager",		-1L,ZZZ_DT_STR(raw_pager), sizeof raw_pager, NULL},
    {"pagesigned",	        -1L,ZZZ_DT_BOL(&pagesigned), 0, NULL},
#ifdef USE_PGP
    {"pgp",		       -1L,ZZZ_DT_SYN("pgp2"), 0, NULL},
    {"pgp-sign-type",	-1L,ZZZ_DT_NUM(&pgp_sign_type),
     sizeof pgp_sign_type, &PGP_SIGN_TYPE},
    {"pgp-version",	       -1L,ZZZ_DT_PGPVER(&send_pgp_version),
     sizeof send_pgp_version, &PGP_VERSION},
    {"pgp2",	       -1L,ZZZ_DT_STR(raw_pgp2_path), 
     sizeof raw_pgp2_path, NULL},
    {"pgp5-dir",           -1L,ZZZ_DT_STR(raw_pgp5_dir), 
     sizeof raw_pgp5_dir, NULL},
#endif /* USE_PGP */
    {"pointnew",		-1L,ZZZ_DT_BOL(&point_to_new), 0, NULL},
    {"pointtonew",		-1L,ZZZ_DT_SYN("pointnew"), 0, NULL},
#ifdef REMOTE_MBX
    {"pop-show-greeting",  -1L,ZZZ_DT_BOL(&POP_show_greeting), 0, NULL},
#endif
    {"precedences",		-1L,ZZZ_DT_STR(allowed_precedences), 
     sizeof allowed_precedences, NULL},
    {"prefix",		-1L,ZZZ_DT_STR_(FL_NOSPC,prefixchars),
     sizeof prefixchars, NULL},
    {"print",		-1L,ZZZ_DT_STR(raw_printout), sizeof raw_printout, NULL},
    {"printmail",		-1L,ZZZ_DT_SYN("print"), 0, NULL},
    {"promptafter",	-1L,ZZZ_DT_BOL(&prompt_after_pager), 0, NULL},
    {"question",		-1L,ZZZ_DT_SYN("ask"), 0, NULL},
    {"quoteforward",	-1L,ZZZ_DT_BOL(&quote_forward), 0, NULL},
    {"readdatapercentinc",	-1L,ZZZ_DT_NUM(&readdatapercentinc), 0, NULL},
    {"readmsginc",		-1L,ZZZ_DT_NUM(&readmsginc), 0, NULL},
    {"receivedmail",	-1L,ZZZ_DT_STR(raw_recvdmail), 
     sizeof raw_recvdmail, NULL},
    {"remotesignature",	-1L,ZZZ_DT_STR(raw_remote_signature), 
     sizeof raw_remote_signature, NULL},
    {"require-mime-version-for-body-encoding",
     -1L,ZZZ_DT_BOL(&req_mime_bodyencoding), 0, NULL},
    {"require-mime-version-for-hdr-encoding",
     -1L,ZZZ_DT_BOL(&req_mime_hdrencoding), 0, NULL},
    {"resolve",		-1L,ZZZ_DT_BOL(&resolve_mode), 0, NULL},
    {"savebyname",		-1L,ZZZ_DT_SYN("savename"), 0, NULL},
    {"savemail",		-1L,ZZZ_DT_SYN("sentmail"), 0, NULL},
    {"savename",		-1L,ZZZ_DT_BOL(&save_by_name), 0, NULL},
    {"saveto",		-1L,ZZZ_DT_SYN("sentmail"), 0, NULL},
    {"send-mime-plain-text", -1L, ZZZ_DT_BOL(&send_mime_plain), 
     sizeof send_mime_plain, NULL },
    {"sentmail",		-1L,ZZZ_DT_STR(raw_sentmail), 
     sizeof raw_sentmail, NULL},
    {"shell",		-1L,ZZZ_DT_STR(raw_shell), sizeof raw_shell, NULL},
    {"show-header-errors", -1L,ZZZ_DT_BOL(&show_header_errors), 0, NULL},
#ifdef USE_PGP
    {"showpgppreamble",	-1L,ZZZ_DT_BOL(&pgp_noarmor), 0, NULL},
#endif
    {"showto",		-1L,ZZZ_DT_BOL(&showto), 0, NULL},
    {"sigdashes",		-1L,ZZZ_DT_BOL(&sig_dashes), 0, NULL},
    {"signature",		-1L,ZZZ_DT_MLT(SIGS), 0, NULL},
    {"sleepmsg",		-1L,ZZZ_DT_NUM(&sleepmsg), 0, NULL},
    /* {"softkeys",	-1L,ZZZ_DT_BOL(FL_OR,&hp_softkeys), 0, 
       NULL}, */
    {"sort",		-1L,ZZZ_DT_SYN("sortby"), 0, NULL},
    {"sort-thread-max-time", -1L, ZZZ_DT_NUM(&sort_thread_max_time), 0, NULL},
    {"sortby",		-1L,ZZZ_DT_SRT(&sortby), 0, NULL},
    {"store",		-1L,ZZZ_DT_SYN("alwaysstore"), 0, NULL},
    {"text-charset",	-1L,ZZZ_DT_STR(raw_text_charset), 
     sizeof raw_text_charset, NULL},
    {"timeout",		-1L,ZZZ_DT_LONG(&elm_timeout), 0, NULL},
    {"titles",		-1L,ZZZ_DT_BOL(&title_messages), 0, NULL},
    {"tmpdir",	       -1L,ZZZ_DT_STR(raw_temp_dir), 
     sizeof raw_temp_dir, NULL},
    {"unidata",             -1L,ZZZ_DT_STR(raw_unidata_path),
     sizeof raw_unidata_path, NULL },
#ifdef USE_DLOPEN
    {"use-library",         -1L,ZZZ_DT_FUNC(use_sharedfunc), 0, NULL}, 
#endif
#ifdef USE_PGP
    {"usepgppass",          -1L,ZZZ_DT_BOL(&pgp_keeppass), 0, NULL},
#endif
    {"userlevel",		-1L,ZZZ_DT_NUM(&user_level), 0, &USERLEVEL},
    {"username",		-1L,ZZZ_DT_SYN("fullname"), 0, NULL},
    {"usetite",		-1L,ZZZ_DT_BOL_(FL_AND,&use_tite), 0, NULL},
    {"utf7-encode-optional", -1L,ZZZ_DT_BOL(&utf7_encode_optional), 0, NULL},
    {"visualeditor",	-1L,ZZZ_DT_STR(v_editor), sizeof v_editor, NULL},
    {"weed",		-1L,ZZZ_DT_BOL(&elm_filter), 0, NULL},
    {"weedout",		-1L,ZZZ_DT_WEE(weedlist), 0, NULL},
};
int NUMBER_OF_SAVEABLE_OPTIONS=(sizeof(save_info_data)/sizeof(ZZZ_SAVE_TYPE));
save_info_recs *save_info = (save_info_recs *) save_info_data;
#else
extern save_info_recs *save_info;
extern int NUMBER_OF_SAVEABLE_OPTIONS;
#endif



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
