static char rcsid[] = "@(#)$Id: dispaddr.c,v 1.13 2001/06/06 18:08:58 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.13 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "headers.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"addr");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}

static struct string * addr_to_str P_((struct addr_item *addr));
static struct string * addr_to_str(addr)
     struct addr_item *addr;
{
    struct string    * f = NULL;
    struct addr_item * ptr;
    
    for (ptr=addr; ptr && ptr->addr; ptr++) {
	struct string  * t   = ptr->fullname;
	struct string  * t1  = new_string2(display_charset,s2us(ptr->addr));
	if (!string_len(t))
	    t = t1;
	if (!f)
	    f = dup_string(t);
	else {
	    struct string  * t2 = dup_string(f);
	    struct string  * t3;

	    add_ascii_to_string(t2,s2us(", "));
	    t3 = cat_strings(t2,t,0);
	    free_string(&f);
	    f = t3;

	    free_string(&t2);
	}
	free_string(&t1);
    }
    return f;
}

int DisplayAddress (h, f)
     struct header_rec *h;
     struct string **f;
{
    int using_to = 0;
    struct addr_item *p,*ptr;
    int okay_to = 1, okay_cc = 1;

    DPRINT(Debug,9,(&Debug, 		      		 
		    "DisplayAddress: h (header_rec)=%p\n",h));
  
    *f = NULL;
    
    if (!h->to ||
	!h->to->addr ||
	!h->to->fullname) {
	/* No To: address, must select From: address anyway.... */
	goto was_from;
    }
    
    for (p = h->from; p && p->addr && p->fullname; p++)
	/* okay_address_l returns FALSE if it IS user's address */
	if (!okay_address_l(p,NULL))
	    break;
    
    for (ptr = h->to; ptr && ptr->addr && ptr->fullname; ptr++)
	if (okay_address_l(ptr, h->from))
	    okay_to = 0;
    

    for (ptr = h->cc; ptr && ptr->addr && ptr->fullname; ptr++)
	if (!okay_address_l(ptr, h->from))
	    okay_cc = 0;


    DPRINT(Debug,6,(&Debug,
		    "DisplayAddress: okay_to=%d, okay_cc=%d, I have sender=%s (%s)\n",
		    okay_to,okay_cc, 
		    p && p->addr ? "Yes" : "No", 
		    p && p->addr ? p->addr : ""
		    ));


    if ((p && p->addr && p->fullname) ||
	addr_is_user (h->env_from)) {
	/* I sent this message.  Use the TO address.  
	 * (perhaps I have also receiver... hmm.)
	 */

	*f = addr_to_str(h->to);
	if (*f)
	    using_to = TRUE;
    } else if (okay_to && okay_cc) {

	/* This message is not addressed to me. */

	if (showto) {
	    *f = addr_to_str(h->to);
	    if (*f)
		using_to = TRUE;
	    else
		goto was_from;
	} else 
	    goto was_from;
      
    } else { /* This message is addressed to me (or sender of mail). */
    was_from:

	if (*f)
	    free_string(f);

	*f = addr_to_str(h->from);
	if (!*f) {
	    if ('\0' == h->env_from[0] || 0 == strcmp(h->env_from,"<>"))
		*f = new_string2(display_charset,s2us("Mailer Daemon"));
	    else
		*f = new_string2(display_charset,s2us(h->env_from));
	}
    }

    /* This does not work correctly with unknown character 
       sets... */
    remove_control(*f);
    
    DPRINT(Debug,6,(&Debug,
		    "DisplayAddress=%d, *f=%S\n",using_to,*f));
    return(using_to);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

