case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

echo "Extracting src/Makefile (with variable substitutions)"
: if mailermode is not 2755 then we dont need the chgrp
: set chgrp to a null command in this case
if test "$mailermode" = 755; then
	chgrp=":"
fi

case "$d_locale" in
define)
	localetarget='$(LIB)/elm.mimecharsets'
	;;
*)
	localetarget=
	;;
esac

cat >Makefile <<!GROK!THIS!
# $Id: Makefile.SH,v 1.30 2001/06/14 18:25:44 hurtta Exp $
#
#  Makefile for the ELM mail program.
#
#	Copyright (c) 1988-1992 USENET Community Trust
#	Copyright (c) 1986,1987 Dave Taylor
# 
#
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CHGRP		=	$chgrp
CHMOD		=	$chmod
CP		=	$cp
DEST		=	$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $dynamic_opt $xenlf
LIB		=	$lib
LIB2		= 	$dlopen_lib $libs 
LIBS		=	$cryptlib $termlib $dbm
LINT		=	$lint
MAILGRP		=	$mailgrp
MAILERMODE	=	$mailermode
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch
TAGS		=	ctags

LOCALETARG	=	$localetarget
RPATH           =       $rpath_opt$shlib

!GROK!THIS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'
SHLIST          = $(BIN)/elm-shared
!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =
!NO!SUBS!

fi

cat >>Makefile <<'!NO!SUBS!'

#	Other general variables
BIN		=	../bin
CFLAGS		=	-I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	../hdrs
LINTFLAGS	=	-I$(INCLDIR)
SHELL		=	/bin/sh

# 	Lists
ELM_SRC		=	addr_util.c	\
			alias.c		\
			aliaslib.c	\
			args.c		\
			a_edit.c	\
			a_screen.c	\
			a_sort.c	\
			a_quit.c	\
			attach_menu.c	\
			browser.c	\
			builtin++.c	\
			calendar.c	\
			curses.c	\
			date.c		\
			delete.c	\
			edit.c		\
			editmsg.c	\
			elm.c		\
			encode.c	\
			exitprog.c	\
			file.c		\
			file_util.c	\
			fileio.c	\
			find_alias.c	\
			forms.c		\
			hdrconfg.c	\
			help.c		\
			id_phrase.c	\
			in_utils.c	\
			init.c		\
			leavembox.c	\
			lock.c		\
			limit.c		\
			mailmsg1.c	\
			mailmsg2.c	\
			menu.c		\
			menu2.c		\
			metapager.c	\
		 	mime.c          \
			mime_encode.c	\
			mkhdrs.c	\
			newmbox.c	\
			options.c	\
			out_utils.c	\
			pattern.c	\
			pgp.c		\
			quit.c		\
			read_rc.c	\
			remail.c	\
			reply.c		\
			save_opts.c	\
			savecopy.c	\
			screen.c	\
			showmsg.c	\
			showmsg_c.c	\
			signals.c	\
			sort.c		\
			string2.c	\
			strings.c	\
			syscall.c	\
			utils.c		

ELM_OBJ		=	addr_util.o	\
			alias.o		\
			aliaslib.o	\
			args.o		\
			attach_menu.o	\
			a_edit.o	\
			a_screen.o	\
			a_sort.o	\
			a_quit.o	\
			browser.o	\
			builtin++.o	\
			calendar.o	\
			curses.o	\
			date.o		\
			delete.o	\
			edit.o		\
			editmsg.o	\
			elm.o		\
			encode.o	\
			exitprog.o	\
			file.o		\
			file_util.o	\
			fileio.o	\
			find_alias.o	\
			forms.o		\
			hdrconfg.o	\
			help.o		\
			id_phrase.o	\
			in_utils.o	\
			init.o		\
			leavembox.o	\
			lock.o		\
			limit.o		\
			mailmsg1.o	\
			mailmsg2.o	\
			menu.o		\
			menu2.o		\
			metapager.o	\
			mime.o		\
			mime_encode.o	\
			mkhdrs.o	\
			newmbox.o	\
			options.o	\
			out_utils.o	\
			pattern.o	\
			pgp.o		\
			quit.o		\
			read_rc.o	\
			remail.o	\
			reply.o		\
			save_opts.o	\
			savecopy.o	\
			screen.o	\
			showmsg.o	\
			showmsg_c.o	\
			signals.o	\
			sort.o		\
			string2.o	\
			strings.o	\
			syscall.o	\
			utils.o		

# Standard targets
all:		Makefile $(BIN)/elm $(SHLIST)

install:	Makefile $(DEST) $(LIB) $(DEST)/elm $(LOCALETARG) $(LIB)/elm.map.bin/unidata.bin 

$(DEST):
		mkdir $(DEST)

$(LIB):
		mkdir $(LIB)

$(LIB)/elm.map.bin: 
		mkdir $(LIB)/elm.map.bin

uninstall:	
		$(RM) $(DEST)/elm $(LOCALETARG) $(LIB)/elm.map.bin/unidata.bin

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		
		$(LINT) $(LINTFLAGS) $(ELM_SRC) > LINT.OUT

tags:
		$(TAGS) $(ELM_SRC)

clean: 
		$(RM) $(ELM_OBJ) $(BIN)/elm $(SHLIST)

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		$(INCLDIR)/defs.h $(INCLDIR)/elm.h $(INCLDIR)/headers.h

$(INCLDIR)/defs.h:	$(INCLDIR)/../config.h $(INCLDIR)/sysdefs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/elm.h:	$(INCLDIR)/elm_curses.h $(INCLDIR)/defs.h  $(INCLDIR)/me.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/headers.h:	$(INCLDIR)/elm_curses.h $(INCLDIR)/defs.h $(INCLDIR)/mime.h $(INCLDIR)/me.h $(INCLDIR)/elmlib.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

#	Dependencies of C object files
addr_util.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
alias.o:	$(INCLDIR)/headers.h $(INCLDIR)/ndbz.h $(INCLDIR)/s_aliases.h $(INCLDIR)/s_elm.h
aliaslib.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
args.o:		$(INCLDIR)/headers.h $(INCLDIR)/patchlevel.h $(INCLDIR)/s_elm.h
a_edit.o:	$(INCLDIR)/headers.h
a_screen.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_aliases.h
a_sort.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_aliases.h $(INCLDIR)/me.h
a_quit.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_aliases.h
attach_menu.o:	$(INCLDIR)/headers.h $(INCLDIR)/me.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h
browser.o:	$(INCLDIR)/headers.h $(INCLDIR)/me.h $(INCLDIR)/s_elm.h
builtin++.o:	$(INCLDIR)/headers.h $(INCLDIR)/me.h
calendar.o:	$(INCLDIR)/headers.h
curses.o:	$(INCLDIR)/headers.h $(INCLDIR)/me.h
date.o:		$(INCLDIR)/headers.h
delete.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
edit.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
editmsg.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
elm.o:		$(INCLDIR)/elm.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h $(INCLDIR)/patchlevel.h
encode.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
exitprog.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
file.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
file_util.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
fileio.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
find_alias.o:	$(INCLDIR)/headers.h $(INCLDIR)/me.h
forms.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
hdrconfg.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
help.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
id_phrase.o:	$(INCLDIR)/headers.h $(INCLDIR)/me.h
in_utils.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
init.o:		$(INCLDIR)/headers.h $(INCLDIR)/patchlevel.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h $(INCLDIR)/s_elm.h 
leavembox.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
limit.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_aliases.h
lock.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
mailmsg1.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
mailmsg2.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h $(INCLDIR)/menu2.h
menu2.o:	$(INCLDIR)/headers.h $(INCLDIR)/me.h $(INCLDIR)/menu2.h
menu.o:		$(INCLDIR)/headers.h $(INCLDIR)/me.h $(INCLDIR)/menu.h
metapager.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
mime.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
mime_encode.o:   $(INCLDIR)/headers.h $(INCLDIR)/me.h
mkhdrs.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
newmbox.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
options.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/save_opts.h $(INCLDIR)/rc_imp.h
out_utils.o:	$(INCLDIR)/headers.h
pattern.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
pgp.o:		$(INCLDIR)/headers.h $(INCLDIR)/me.h
quit.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
read_rc.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/save_opts.h $(INCLDIR)/rc_imp.h
remail.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
reply.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
save_opts.o:	$(INCLDIR)/save_opts.h $(INCLDIR)/headers.h $(INCLDIR)/s_elmrc.h $(INCLDIR)/rc_imp.h
savecopy.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
screen.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
showmsg.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
showmsg_c.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
signals.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
sort.o:		$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
string2.o:	$(INCLDIR)/headers.h
strings.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h
syscall.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h $(INCLDIR)/s_me.h
utils.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h $(INCLDIR)/me.h

#	Dependencies and rules for compiling C programs
$(BIN)/elm:	$& $(ELM_OBJ) ../melib/libme.a ../lib/libutil.a 
		$(CC) $(LFLAGS) -o $@ $(ELM_OBJ) ../melib/libme.a ../lib/libutil.a $(LIBS) $(LIB2)

#	Dependencies and rules for installing C programs

$(LIB)/elm.mimecharsets: $(BIN)/elm.mimecharsets $(BIN)/elmcharset ../ConfTool/killsets
		$(BIN)/elmcharset -G -I ../ConfTool/killsets -w $@ $(BIN)/elm.mimecharsets 
		$(CHMOD) u=rw,go=r $@

$(LIB)/elm.map.bin/unidata.bin: $(LIB) $(LIB)/elm.map.bin ../charset/UNIDATA/UNIDATA2.TXT $(BIN)/elmunidata 
		$(BIN)/elmunidata -I -s ../charset/UNIDATA/UNIDATA2.TXT 
		$(CHMOD) ugo=r $@

!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

$(BIN)/elm-shared: $& $(ELM_OBJ) ../melib/libme.a ../shlib/libelmme-base.so 
		$(CC) $(LFLAGS) -o $@ $(RPATH) $(ELM_OBJ) ../melib/libme.a ../shlib/libelmme-base.so $(LIBS) $(LIB2)


$(DEST)/elm:	$(BIN)/elm-shared
		-$(MV) $@ $@.old
		-$(RM) $@.old
		$(CP) $(BIN)/elm-shared $@
		$(CHGRP) $(MAILGRP) $@
		$(CHMOD) $(MAILERMODE) $@

!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'
$(DEST)/elm:	$(BIN)/elm
		-$(MV) $@ $@.old
		-$(RM) $@.old
		$(CP) $(BIN)/elm $@
		$(CHGRP) $(MAILGRP) $@
		$(CHMOD) $(MAILERMODE) $@
!NO!SUBS!

fi
