static char rcsid[] = "@(#)$Id: browser.c,v 1.19 2001/06/09 15:34:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.19 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ui");

static char *us2s P_((unsigned char *str));
static char *us2s(str) 
     unsigned char *str;
{
    return (char *)str;
}

#define GB_REDRAW    1
#define GB_MENU      2
#define GB_FILL      4
#define GB_HELP      8
#define GB_SAVE_COPY 16
#define GB_FLAGS     py
#define GB_PAGE      counter
#define GB_LINE      px

static void draw_line P_((struct enter_info *I,
			  int i,int lines_per_page));
static void draw_line(I,i,lines_per_page)
     struct enter_info *I;
     int i;
     int lines_per_page;
{
    int flags = 0;

    /* return reference to array -- do not free_string !!! */
    struct string * buffer = 
	give_line_dir(I->dir_p,i,&flags);
    int current = i == I->GB_LINE; 
    int c = '?';
    int size = elm_COLUMNS-5;
    
    switch (flags & (BROWSER_NODIR|BROWSER_NOFOLDER)) {
    case 0:                c = 'd'; break;
    case BROWSER_NODIR:    c = ' '; break;
    case BROWSER_NOFOLDER: c = 'D'; break;
    }
		
    if (current && !arrow_cursor)
	StartInverse();
    PutLineX(5 + i % lines_per_page,0,
	     FRM("%.2s%c%c %-*.*S"),
	     current && arrow_cursor ? "->" : "  ",
	     flags & BROWSER_MARKED ? 'N' : ' ',
	     c,size,size,buffer);
    if (current && !arrow_cursor)
	EndInverse();    
}

static void write_prompt P_((struct enter_info *I));
static void write_prompt(I)
     struct enter_info *I;
{
    show_last_error();
    PutLineX(elm_LINES-2,0, FRM("%S"),I->pvector[1]);
    if (I->pvector[0])
	Write_to_screen(FRM("%S"),I->pvector[0]);
    CleartoEOLN();
}

int browser_expand(XXX,name,prev_folder)
     struct folder_browser * XXX;
     struct string **name;
     struct string ** prev_folder;
{
    int ret = 0;
    int s_len;

    if (*name && (s_len=string_len(*name)) > 0) {
	switch (give_unicode_from_string(*name,0)) {
	    struct addr_item * address;
	    char *str;
	    int too_long;
		
	case 0x0040: /* '@' -- @alias ... */
	    
	    /* Lousy -- charset not converted... */
	    str = us2s(stream_from_string(*name,0,NULL));
	    address = get_alias_address_l(&(str[1]),
					  FALSE,&too_long);
	    free(str); str = NULL;
	    
	    if (address && address[0].addr ) {
		char buffer[LONG_STRING];
		struct string *S1;
		
		/* get filename from address */
		get_return_name(address[0].addr, buffer, 
				TRUE, sizeof buffer);
		
		if (buffer[0]) {
		    S1 = format_string(FRM("=%s"),buffer);
		
		    if (select_dir_item(XXX,&S1)) {
			free_string(&S1);
			if (address)
			    free_addr_items(address);
		    
			ret = 1;
			DPRINT(Debug,4,
			       (&Debug, 
				"-- browser_expand (@alias) OK\n"));
			goto out;
		    }
		    free_string(&S1);
		}
	    }
	    if (address)
		free_addr_items(address);
	    goto out;     /* Alias FAILED */
	    
	case 0x002E: /* '.' */
	    if (1 == s_len) {
		if (prev_folder && *prev_folder &&
		    select_dir_item(XXX, prev_folder)) {
		    
		    ret = 1;
		    DPRINT(Debug,4,
			   (&Debug, 			    
			    "-- browser_expand (. == previous folder) OK\n"));
		    goto out;
		}
		goto out;     /* previous folder */
	    }
	    break;  
	}
	if (select_dir_item(XXX,name))
	    ret = 1;
    }

 out:
	
    DPRINT(Debug,7, (&Debug, 
		     "browser_expand=%d\n",ret));
    
    return ret;    
}

static int cf_english P_((struct enter_info *I));
static int cf_english(I)
     struct enter_info *I;
{
    int s_len;
    if (I->pvector[0] && 
	0 == string_len(I->pvector[0])) {
	free_string(&(I->pvector[0]));
    }

    if (!I->pvector[0]) {
	PutLineX(elm_LINES-2,0, FRM("%S"),I->pvector[1]);
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoSave, "<no save>"));
	CleartoEOLN();
	MoveCursor(elm_LINES-2,string_len(I->pvector[1]));
	return 1;
    } else if ((s_len=string_len(I->pvector[0])) > 0) {
	switch (give_unicode_from_string(I->pvector[0],0)) {
	case 0x003D:  /* '='  Handle save copy prompt! */
	    if (1 == s_len) {
		PutLineX(elm_LINES-2,0, FRM("%S"),I->pvector[1]);
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmUncondSaveByName, 
					"<unconditionally save by name>"));
		CleartoEOLN();
		MoveCursor(elm_LINES-2,string_len(I->pvector[1]));
		return 1;		
	    } else if (2 == s_len &&
		       give_unicode_from_string(I->pvector[0],1) 
		       == 0x003F /* '?' */) {
		PutLineX(elm_LINES-2,0, FRM("%S"),I->pvector[1]);
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmCondSaveByName, 
					"<conditionally save by name>"));
		CleartoEOLN();
		MoveCursor(elm_LINES-2,string_len(I->pvector[1]));
		return 1;		
	    }
	    break;
	case 0x003C: /* '<' */
	    if (1 == s_len) {
		PutLineX(elm_LINES-2,0, FRM("%S"),I->pvector[1]);
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmSentFolder, "<\"sent\" folder>"));
		CleartoEOLN();
		MoveCursor(elm_LINES-2,string_len(I->pvector[1]));
		return -1;  /* SPecial prompt but normal expansion */	    
	    }
	    break;
	}
    }
    return 0;
}

static void gb_initial_text P_((void));
static void gb_initial_text()
{
    MoveCursor(elm_LINES-3, 45);
    CleartoEOS();
    show_last_error();
    
    PutLineX(elm_LINES-3, 50, 
	     CATGETS(elm_msg_cat, ElmSet, ElmUseForHelp,
		     "(Use '?' for help)"));	    
}

static void gb_initial_non_append P_((struct enter_info *I));
static void gb_initial_non_append(I)
     struct enter_info *I;
{
    PutLineX(elm_LINES-2,0, FRM("%S"),I->pvector[1]);
    if (I->pvector[0]) {
	Write_to_screen(FRM("%S"),I->pvector[0]);
	CleartoEOLN();
	MoveCursor(elm_LINES-2,string_len(I->pvector[1]));
    }
}

static void gb_initial_title P_((struct string * buffer));
static void gb_initial_title(buffer)
     struct string * buffer;
{
    ClearScreen();
    print_center(1,buffer);
}

static void browser_help P_((void));
static void browser_help()
{
    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg7N,
			    "You may get directory listing by giving directory name and pressing TAB key.\n\r"));
	    
    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg8N,
			    "Pressing LEFT key fills buffer with current directory name and \n\r"));
    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg9N,
			    "pressing RIGTH key fills buffer with current selection. \n\r"));
    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg10N,
			    "UP and DOWN keys changes current selection on directory listing.\n\r"));
    
}

static void gb_dir_title P_((struct enter_info *I,int *entries));
static void gb_dir_title(I,entries)
     struct enter_info *I;
     int *entries;
{
    struct string * buffer = give_title_dir(I->dir_p,entries);

    PutLineX(3,0,FRM("%S"),buffer);  CleartoEOLN();
    MoveCursor(4,0);                 CleartoEOLN();
	
    free_string(&buffer);    
}

static struct string **gb_browser P_((struct enter_info *I,
				      enum enter_mode em));

static struct string **gb_browser(I,em)
     struct enter_info *I;
     enum enter_mode em;
{

    int append_current = 0 != (I->flags & OE_APPEND_CURRENT);

    /* Clear screen ... */
    if (em_redraw == em)           
	I->GB_FLAGS |= GB_REDRAW ;     

    switch(em) {
	int s_len;
    case em_redraw_initial:
	
	/* POP/IMAP client code will prompt messages to same area
	   so we re-print prompt every time ... */

	if (0 != (GB_SAVE_COPY & I->GB_FLAGS)) {
	    MoveCursor(elm_LINES-2,0);
	    CleartoEOS();
	    show_last_error();	    
	} else {
	    gb_initial_text();
	}

	if (!append_current) {
	    if (0 == (GB_SAVE_COPY & I->GB_FLAGS) ||
		cf_english(I) == 0) {
		gb_initial_non_append(I);
	    }
	    I->ch_count = 0;

	    DPRINT(Debug,4,
		   (&Debug, 
		    "-- gb_browser(..,%d)=non null  (initial prompt)\n",
		    em));
	    return &(I->pvector[0]);
	}
	/* FALLTHRU */

    case em_redraw: repage:

	if (0 != (I->GB_FLAGS & GB_MENU))
	    I->GB_FLAGS |= GB_REDRAW;

	if (0 != (I->GB_FLAGS & GB_HELP))
	    I->GB_FLAGS |= GB_REDRAW;


	if (0 != (I->GB_FLAGS & GB_REDRAW)) {
	    struct string * buffer = 
		format_string(CATGETS(elm_msg_cat, ElmSet,
				      ElmFolderSelection,
				      "Folder selection"));
	    gb_initial_title(buffer);
	    free_string(&buffer);
	}

	if (0 != (I->GB_FLAGS & GB_HELP)) {	        
	    MoveCursor(3,0);    CleartoEOS();

	    if (0 != (GB_SAVE_COPY & I->GB_FLAGS)) {
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmListFoldersHelp1,
"Enter: <nothing> to not save a copy of the message,\n\
\r       '<'       to save in your \"sent\" folder ("));
		Write_to_screen(FRM("%s"), sent_mail);
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmListFoldersHelp2,
					"),\n\
\r       '='       to save by name (the folder name depends on whom the\n\
\r                     message is to, in the end),\n\
\r       '=?'      to save by name if the folder already exists,\n\
\r                     and if not, to your \"sent\" folder,\n\
\r       or a filename (a leading '=' denotes your folder directory).\n\r\n\r"
					));
	    } else {
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg1,
					"\n\r\n\rYou must specify a file or folder to "));

	    
		Write_to_screen(FRM("%S"),I->pvector[2]);
	    	    	   		    
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg2,
					" to.  Several options\n\rare available:\n\r\
\n\r  '!'  will use your incoming mailbox ("));
		
		Write_to_screen(FRM("%s"),defaultfile);
	    
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg3,
				    ")\n\r  '>'  will use your \"received\" folder ("));
		Write_to_screen(FRM("%s"),recvd_mail);
	    
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg4,
				    ")\n\r  '<'  will use your \"sent\" folder ("));
		Write_to_screen(FRM("%s"), sent_mail);
	    
		if (I->pvector[3]) {
		    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg5,
					    ")\n\r  '.' will use the previous folder ("));
		    Write_to_screen(FRM("%S"), I->pvector[3]);
		}

		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg6,
					")\n\r  '@alias' will use the default folder for \"alias\"\n\r\n\r\
If you enter a filename elm will use that file.  If the file name begins\n\r\
with a '=', elm will look for the file in your folder directory\n\r\
(your folder directory is "));
		Write_to_screen(FRM("%s)\r\n\n"),raw_folders);
		if (browser_wildcards) {
		    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg7,
					    "You may use wildcards (*?) in the name, similary as you do in the shell.\n\r"));
		}
	    }	    	    

	    browser_help();
	} 

	if (0 != (I->GB_FLAGS & GB_MENU)) {
	    int entries = 0;
	    int i;
	    int lines_per_page = elm_LINES-9;

	    gb_dir_title(I,&entries);

	    if (I->GB_PAGE > entries / lines_per_page)
		I->GB_PAGE = entries / lines_per_page;
	    if (I->GB_LINE > entries-1 && entries > 0)
		I->GB_LINE = entries-1;

	    for (i = I->GB_PAGE * lines_per_page;
		 i < entries && 
		     i < I->GB_PAGE * lines_per_page + lines_per_page;
		 i++) {
		draw_line(I,i,lines_per_page);
	    }

	    for (; i < I->GB_PAGE * lines_per_page + lines_per_page;
                 i++) {
		MoveCursor(5 + i % lines_per_page,0);
		CleartoEOLN();
	    }	    
	}

	break;
    case em_enter:
	clear_error();			   

	if (I->pvector[0] && (s_len=string_len(I->pvector[0])) > 0) {
	    switch (give_unicode_from_string(I->pvector[0],0)) {
	    case 0x003F: /* '?' */  
		if (1 == s_len) {
		    I->GB_FLAGS |= GB_HELP;
		    I->GB_FLAGS &= ~GB_MENU;
		    
		    goto repage;
		}
		break;
	    }
	    if (0 != (GB_SAVE_COPY & I->GB_FLAGS)) {
		int cf_r;
		if ((cf_r = cf_english(I)) > 0) {
		    DPRINT(Debug,4, (&Debug,  "-- gb_browser(..,%d)=NULL (save folder prompt)\n",
			       em));
#if POLL_METHOD
		    error_sleep((sleepmsg + 1) / 2);
#else
		    sleep((sleepmsg + 1) / 2);
#endif
		    return NULL;
		}
		if (cf_r < 0) {     /* Show text of cf_english() little time */
#if POLL_METHOD
		    error_sleep((sleepmsg + 1) / 2);
#else
		    sleep((sleepmsg + 1) / 2);
#endif
		}
	    }
	    if (browser_wildcards /* do wildcard match? */
		&& 
		dir_is_wildcard(I->dir_p,&(I->pvector[0]))) {
		DPRINT(Debug,4, (&Debug,  
				 "-- gb_browser(..,%d): wildcarding\n",
				 em));
		
		I->GB_FLAGS &= ~GB_HELP;
		I->GB_FLAGS |= GB_MENU | GB_REDRAW | GB_FILL;
		
		I->GB_LINE = 0;
		I->GB_PAGE = 0;
		
		if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				      &(I->pvector[0]),
				      I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		    /* Ring a bell */
		    Writechar('\007');
		}
	       
		goto repage;
	    }

	    if (!browser_expand(I->dir_p,&(I->pvector[0]),&(I->pvector[3]))) {
		break;     /* Selection FAILED -- reject ENTER */
	    }
	}
	DPRINT(Debug,4, (&Debug,  
			 "-- gb_browser(..,%d)=NULL\n",
			 em));
	return NULL;
    case em_prev:
	clear_error();
	if (0 != (I->GB_FLAGS & GB_MENU)) {
	     int lines_per_page = elm_LINES-9;
	     int oldline = I->GB_LINE;

	     int entries = 0;
	     /* Needs number of entries ... */
	     struct string * buffer = give_title_dir(I->dir_p,&entries);

	     free_string(&buffer);
	     
	     I->GB_LINE--;
	     if (I->GB_LINE < 0)
		 I->GB_LINE = 0;

	     if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				   &(I->pvector[0]),
				   I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		 /* Ring a bell */
		 Writechar('\007');
		 goto repage;
	     }

	     if (I->GB_LINE / lines_per_page != I->GB_PAGE) {
		 I->GB_PAGE = I->GB_LINE / lines_per_page;
		 goto repage;
	     }

	     if (oldline < entries)
		 draw_line(I,oldline,lines_per_page);
	     else {
		 MoveCursor(5 + oldline % lines_per_page,0);
		 CleartoEOLN();
	     }	    
	     if (I->GB_LINE < entries)
		 draw_line(I,I->GB_LINE,lines_per_page);
	}
	break;
    case em_next:
	clear_error();
	if (0 != (I->GB_FLAGS & GB_MENU)) {
	    int lines_per_page = elm_LINES-9;
	    int oldline = I->GB_LINE;

	    int entries = 0;
	    /* Needs number of entries ... */
	    struct string * buffer = give_title_dir(I->dir_p,&entries);

	    free_string(&buffer);
	    	     
	    if (entries > 0) {
		I->GB_LINE++;
		if (I->GB_LINE >= entries)
		    I->GB_LINE = entries-1;
		
		if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				      &(I->pvector[0]),
				      I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		    /* Ring a bell */
		    Writechar('\007');
		    goto repage;
		}
	    }

	     if (I->GB_LINE / lines_per_page != I->GB_PAGE) {
		 I->GB_PAGE = I->GB_LINE / lines_per_page;
		 goto repage;
	     }
	     
	     if (oldline < entries)
		 draw_line(I,oldline,lines_per_page);
	     else {
		 MoveCursor(5 + oldline % lines_per_page,0);
		 CleartoEOLN();
	     }	    
	     if (I->GB_LINE < entries)
		 draw_line(I,I->GB_LINE,lines_per_page);
	}
	break;
    case em_tabaction:
	DPRINT(Debug,8, (&Debug,  
			 "-- gb_browser - tabaction: append_current=%d ch_count=%d\n",
			 append_current,I->ch_count));
	if (!append_current && I->ch_count == 0) {
	    if (I->pvector[0])
		free_string(&(I->pvector[0]));
	    I->ch_count++;
	}

	clear_error();

	if (browser_wildcards /* do wildcard match? */
	    && 
	    dir_is_wildcard(I->dir_p,&(I->pvector[0]))) {
	    DPRINT(Debug,4, (&Debug,  
			     "-- gb_browser(..,%d): wildcarding\n",
			     em));
	    
	    I->GB_FLAGS &= ~GB_HELP;
	    I->GB_FLAGS |= GB_MENU | GB_REDRAW | GB_FILL;

	    I->GB_LINE = 0;
	    I->GB_PAGE = 0;

	    if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				  &(I->pvector[0]),
				  I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		/* Ring a bell */
		Writechar('\007');
	    }
	    
	    goto repage;
	}

	if (change_dir(I->dir_p,&(I->pvector[0]))) {
	    I->GB_FLAGS |= GB_MENU | GB_REDRAW | GB_FILL;
	    I->GB_FLAGS &= ~GB_HELP;

	    I->GB_LINE = 0;
	    I->GB_PAGE = 0;

	    if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				  &(I->pvector[0]),
				  I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		/* Ring a bell */
		Writechar('\007');
	    }
	    goto repage;
	} else {
	    /* Ring a bell */
	    Writechar('\007');
	    goto repage;
	}
	/* NOT REACHED */

    case em_left:
	clear_error();
	if (0 != (I->GB_FLAGS & GB_MENU)) {

	    if (0 == (I->GB_FLAGS & GB_FILL)) {

		if (!change_dir_up(I->dir_p,&(I->pvector[0]))) {
		    /* Ring a bell */
		    Writechar('\007');
		} else {
		    I->GB_LINE = 0;
		    I->GB_PAGE = 0;	       
		}
		goto repage;
	    } else {
		I->GB_FLAGS &= ~GB_FILL;

		if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				      &(I->pvector[0]),
				      I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		    /* Ring a bell */
		    Writechar('\007');
		    goto repage;
		}
	    }
	}
	break;
    case em_right:
	clear_error();
	if (0 != (I->GB_FLAGS & GB_MENU)) {

	    if (0 != (I->GB_FLAGS & GB_FILL)) {

		I->GB_FLAGS &= ~GB_FILL;
		
		if (!change_dir_to_entry(I->dir_p,I->GB_LINE,
					 &(I->pvector[0]))) {
		    /* Ring a bell */
		    Writechar('\007');
		} else {
		    I->GB_LINE = 0;
		    I->GB_PAGE = 0;
		}

		goto repage;

	    } else {
		I->GB_FLAGS |= GB_FILL;

		if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				      &(I->pvector[0]),
				      I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		    /* Ring a bell */
		    Writechar('\007');
		    goto repage;
		}
	    }
	}
	break;
    }

 failure:

    write_prompt(I);	 
    
    DPRINT(Debug,4, (&Debug,  
		     "-- gb_browser(..,%d)=non null\n",
		     em));
    return &(I->pvector[0]);
}


static int run_browser P_((struct folder_browser *p,
			   struct string **buffer,
			   int * redraw,
			   int save_copy,
			   struct string *word, 
			   struct string * prev_fold,
			   const char *format, const char *msg,
			   va_list args));
static int run_browser(p,buffer,redraw,save_copy,
		       word,prev_fold,format,msg,args)
     struct folder_browser *p;
     struct string **buffer;
     int * redraw;
     int save_copy;
     struct string *word;
     struct string * prev_fold;
     const char *format; 
     const char *msg;
     va_list args;
{
    int ret = 0;
    int code;
    int flags;

    struct string *text;
    struct string *vector[4];
    struct enter_info INFO;

    DPRINT(Debug,4,
	   (&Debug, "run_browser: Entering [%s]\n",format));

    text = elm_smessage(0,format,msg,args);

    vector[0] = *buffer;
    vector[1] = text;
    vector[2] = word;
    vector[3] = prev_fold;

    INFO.counter     =  0;             /* Page number here */
    INFO.pvector     = vector;
    INFO.px          = 0;              /* line number here */
    INFO.py          = 0;              /* flags       here */
    INFO.give_buffer = gb_browser;
    if (save_copy)
	INFO.flags       = OE_REDRAW_MARK | OE_TABACTION;
    else
	INFO.flags       = (*buffer ? 0 : OE_APPEND_CURRENT ) |
	    OE_REDRAW_MARK | OE_TABACTION;
    INFO.ch_count    = 0;
    INFO.builtin     = NULL;
    INFO.dir_p       = p;
    
    if (save_copy)
	INFO.GB_FLAGS |= GB_SAVE_COPY;

    clear_selection_dir(p);
    do {
	code = enter_helper(&INFO);
    } while (code == REDRAW_MARK);
    
    MoveCursor(elm_LINES-3,0);
    CleartoEOS();
    show_last_error();

    flags = give_dir_flags(p);

    if (0 != (BROWSER_SELECTED & flags))
	ret = 1;
	
    if (INFO.GB_FLAGS & GB_REDRAW)
	*redraw = TRUE;

    *buffer = vector[0];

    free_string(&text);

    DPRINT(Debug,10, (&Debug,  
		      "run_browser=%d\n",ret));

    return ret;
}


struct folder_info * folder_browser(
#if ANSI_C
				    struct folder_browser *p,
				    struct string **buffer,
				    int * redraw,
				    CONST char *format, CONST char *msg, ...
#else
				    p,buffer,redraw,format, msg, va_alist
#endif
)
#if !ANSI_C
     struct folder_browser *p;
     struct string **buffer;
     int * redraw;
     va_dcl
#endif
{
    struct folder_info *ret = NULL;
    struct string * word;
    va_list vl;


    word=format_string(CATGETS(elm_msg_cat, ElmSet, ElmChange, 
			       "change"));

    Va_start(vl, msg);           /* defined in defs.h */
    if (run_browser(p,buffer,redraw,0,word,NULL,format,msg,vl)) 
	ret = folder_from_dir_item(p);
    va_end(vl);

    free_string(&word);

    if (ret) {
	DPRINT(Debug,5,
	       (&Debug,"folder_browser=%p\n",ret));
    } else {
	DPRINT(Debug,5,
	       (&Debug,"folder_browser=NULL\n"));
    }
    
    return ret;
}

static void draw_fileline P_((struct enter_info *I,
			  int i,int lines_per_page));
static void draw_fileline(I,i,lines_per_page)
     struct enter_info *I;
     int i;
     int lines_per_page;
{
    int flags = 0;

    /* return reference to array -- do not free_string !!! */
    struct string * buffer = 
	give_line_dir(I->dir_p,i,&flags);
    int current = i == I->GB_LINE; 
    int c = '?';
    int size = elm_COLUMNS-5;

    if (0 == (flags & BROWSER_NODIR))
	c = 'D';
		
    if (current && !arrow_cursor)
	StartInverse();
    PutLineX(5 + i % lines_per_page,0,
	     FRM("%.2s%c%c  %-*.*S"),
	     current && arrow_cursor ? "->" : "  ",
	     flags & BROWSER_MARKED ? 'N' : ' ',
	     c,size,size,buffer);
    if (current && !arrow_cursor)
	EndInverse();    
}

static struct string **gb_filebrowser P_((struct enter_info *I,
				      enum enter_mode em));
static struct string **gb_filebrowser(I,em)
     struct enter_info *I;
     enum enter_mode em;
{

    int append_current = 0 != (I->flags & OE_APPEND_CURRENT);

    /* Clear screen ... */
    if (em_redraw == em)           
	I->GB_FLAGS |= GB_REDRAW ;     
    
    switch(em) {
	int s_len;
    case em_redraw_initial:
	
	/* POP/IMAP client code will prompt messages to same area
	   so we re-print prompt every time ... */

	gb_initial_text();

	if (!append_current) {
	    gb_initial_non_append(I);
	    
	    I->ch_count = 0;
	    
	    DPRINT(Debug,4,
		   (&Debug, 
		    "-- gb_filebrowser(..,%d)=non null  (initial prompt)\n",
		    em));
	    return &(I->pvector[0]);
	}
	/* FALLTHRU */

    case em_redraw: repage:

	if (0 != (I->GB_FLAGS & GB_MENU))
	    I->GB_FLAGS |= GB_REDRAW;
	
	if (0 != (I->GB_FLAGS & GB_HELP))
	    I->GB_FLAGS |= GB_REDRAW;

	if (0 != (I->GB_FLAGS & GB_REDRAW)) {
	    struct string * buffer = 
		format_string(CATGETS(elm_msg_cat, ElmSet,
				      ElmFileSelection,
				      "File selection"));
	    gb_initial_title(buffer);
	    free_string(&buffer);
	}

	if (0 != (I->GB_FLAGS & GB_HELP)) {	        
	    MoveCursor(3,0);    CleartoEOS();

	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileSpecify1,
				    "\n\r\n\rYou must specify a file to "));
	    
	    Write_to_screen(FRM("%S"),I->pvector[2]);

	    Write_to_screen(FRM(".\n\r"));

	    if (browser_wildcards) {
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmFileHelpmsg7,
					"You may use wildcards (*?) in the name, similary as you do in the shell.\n\r"));
	    }

	    browser_help();
	}

	if (0 != (I->GB_FLAGS & GB_MENU)) {
	    int entries = 0;
	    int i;
	    int lines_per_page = elm_LINES-9;

	    gb_dir_title(I,&entries);

	    if (I->GB_PAGE > entries / lines_per_page)
		I->GB_PAGE = entries / lines_per_page;
	    if (I->GB_LINE > entries-1 && entries > 0)
		I->GB_LINE = entries-1;

	    for (i = I->GB_PAGE * lines_per_page;
		 i < entries && 
		     i < I->GB_PAGE * lines_per_page + lines_per_page;
		 i++) {
		draw_fileline(I,i,lines_per_page);
	    }

	    for (; i < I->GB_PAGE * lines_per_page + lines_per_page;
                 i++) {
		MoveCursor(5 + i % lines_per_page,0);
		CleartoEOLN();
	    }	    
	}

	break;
    case em_enter:
	clear_error();			   

	if (I->pvector[0] && (s_len=string_len(I->pvector[0])) > 0) {
	    switch (give_unicode_from_string(I->pvector[0],0)) {
	    case 0x003F: /* '?' */  
		if (1 == s_len) {
		    I->GB_FLAGS |= GB_HELP;
		    I->GB_FLAGS &= ~GB_MENU;
		    
		    goto repage;
		}
		break;
	    }

	    if (browser_wildcards /* do wildcard match? */
		&& 
		dir_is_wildcard(I->dir_p,&(I->pvector[0]))) {

		DPRINT(Debug,4, (&Debug,  
				 "-- gb_filebrowser(..,%d): wildcarding\n",
				 em));
		
		I->GB_FLAGS &= ~GB_HELP;
		I->GB_FLAGS |= GB_MENU | GB_REDRAW | GB_FILL;
		
		I->GB_LINE = 0;
		I->GB_PAGE = 0;
		
		if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				      &(I->pvector[0]),
				      I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		    /* Ring a bell */
		    Writechar('\007');
		}
	       
		goto repage;
	    }

	    if (!select_dir_item(I->dir_p,&(I->pvector[0]))) {
		break;     /* Selection FAILED -- reject ENTER */
	    }
	}
	DPRINT(Debug,4, (&Debug,  
			 "-- gb_filebrowser(..,%d)=NULL\n",
			 em));
	return NULL;

    case em_prev:
	clear_error();
	if (0 != (I->GB_FLAGS & GB_MENU)) {
	     int lines_per_page = elm_LINES-9;
	     int oldline = I->GB_LINE;

	     int entries = 0;
	     /* Needs number of entries ... */
	     struct string * buffer = give_title_dir(I->dir_p,&entries);

	     free_string(&buffer);
	     
	     I->GB_LINE--;
	     if (I->GB_LINE < 0)
		 I->GB_LINE = 0;

	     if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				   &(I->pvector[0]),
				   I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		 /* Ring a bell */
		 Writechar('\007');
		 goto repage;
	     }

	     if (I->GB_LINE / lines_per_page != I->GB_PAGE) {
		 I->GB_PAGE = I->GB_LINE / lines_per_page;
		 goto repage;
	     }

	     if (oldline < entries)
		 draw_fileline(I,oldline,lines_per_page);
	     else {
		 MoveCursor(5 + oldline % lines_per_page,0);
		 CleartoEOLN();
	     }	    
	     if (I->GB_LINE < entries)
		 draw_fileline(I,I->GB_LINE,lines_per_page);
	}
	break;
    case em_next:
	clear_error();
	if (0 != (I->GB_FLAGS & GB_MENU)) {
	    int lines_per_page = elm_LINES-9;
	    int oldline = I->GB_LINE;

	    int entries = 0;
	    /* Needs number of entries ... */
	    struct string * buffer = give_title_dir(I->dir_p,&entries);

	    free_string(&buffer);
	    	     
	    if (entries > 0) {
		I->GB_LINE++;
		if (I->GB_LINE >= entries)
		    I->GB_LINE = entries-1;
		
		if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				      &(I->pvector[0]),
				      I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		    /* Ring a bell */
		    Writechar('\007');
		    goto repage;
		}
	    }

	     if (I->GB_LINE / lines_per_page != I->GB_PAGE) {
		 I->GB_PAGE = I->GB_LINE / lines_per_page;
		 goto repage;
	     }
	     
	     if (oldline < entries)
		 draw_fileline(I,oldline,lines_per_page);
	     else {
		 MoveCursor(5 + oldline % lines_per_page,0);
		 CleartoEOLN();
	     }	    
	     if (I->GB_LINE < entries)
		 draw_fileline(I,I->GB_LINE,lines_per_page);
	}
	break;
	
    case em_tabaction:
	DPRINT(Debug,10, (&Debug,  
		    "-- gb_filebrowser - tabaction: append_current=%d ch_count=%d\n",
		    append_current,I->ch_count));
	if (!append_current && I->ch_count == 0) {
	    if (I->pvector[0])
		free_string(&(I->pvector[0]));
	    I->ch_count++;
	}

	clear_error();

	if (browser_wildcards /* do wildcard match? */
	    && 
	    dir_is_wildcard(I->dir_p,&(I->pvector[0]))) {
	    DPRINT(Debug,4, (&Debug,  "-- gb_filebrowser(..,%d): wildcarding\n",
		       em));
	    
	    I->GB_FLAGS &= ~GB_HELP;
	    I->GB_FLAGS |= GB_MENU | GB_REDRAW | GB_FILL;

	    I->GB_LINE = 0;
	    I->GB_PAGE = 0;

	    if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				  &(I->pvector[0]),
				  I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		/* Ring a bell */
		Writechar('\007');
	    }
	    
	    goto repage;
	}

	if (change_dir(I->dir_p,&(I->pvector[0]))) {
	    I->GB_FLAGS |= GB_MENU | GB_REDRAW | GB_FILL;
	    I->GB_FLAGS &= ~GB_HELP;

	    I->GB_LINE = 0;
	    I->GB_PAGE = 0;

	    if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				  &(I->pvector[0]),
				  I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		/* Ring a bell */
		Writechar('\007');
	    }
	    goto repage;
	} else {
	    /* Ring a bell */
	    Writechar('\007');
	    goto repage;
	}
	/* NOT REACHED */


      
        case em_left:
	clear_error();
	if (0 != (I->GB_FLAGS & GB_MENU)) {

	    if (0 == (I->GB_FLAGS & GB_FILL)) {

		if (!change_dir_up(I->dir_p,&(I->pvector[0]))) {
		    /* Ring a bell */
		    Writechar('\007');
		} else {
		    I->GB_LINE = 0;
		    I->GB_PAGE = 0;	       
		}
		goto repage;
	    } else {
		I->GB_FLAGS &= ~GB_FILL;

		if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				      &(I->pvector[0]),
				      I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		    /* Ring a bell */
		    Writechar('\007');
		    goto repage;
		}
	    }
	}
	break;
    case em_right:
	clear_error();
	if (0 != (I->GB_FLAGS & GB_MENU)) {

	    if (0 != (I->GB_FLAGS & GB_FILL)) {

		I->GB_FLAGS &= ~GB_FILL;
		
		if (!change_dir_to_entry(I->dir_p,I->GB_LINE,
					 &(I->pvector[0]))) {
		    /* Ring a bell */
		    Writechar('\007');
		} else {
		    I->GB_LINE = 0;
		    I->GB_PAGE = 0;
		}

		goto repage;

	    } else {
		I->GB_FLAGS |= GB_FILL;

		if (!give_edit_buffer(I->dir_p,I->GB_LINE,
				      &(I->pvector[0]),
				      I->GB_FLAGS & GB_FILL ? 1 : 0)) {
		    /* Ring a bell */
		    Writechar('\007');
		    goto repage;
		}
	    }
	}
	break;
    }

 failure:

    write_prompt(I);	 
    
    DPRINT(Debug,4, (&Debug,  
		     "-- gb_filebrowser(..,%d)=non null\n",
		     em));
    return &(I->pvector[0]);
}

void gen_browser(
#if ANSI_C
				    struct folder_browser *p,
				    struct string **buffer,
				    int * redraw,
				    enum word_sel w,
				    struct string * prev_fold,
				    const char *format, const char *msg, ...
#else
				    p,buffer,redraw,w,prev_fold,
				    format, msg, va_alist
#endif
)
#if !ANSI_C
     struct folder_browser *p;
     struct string **buffer;
     int * redraw;
     enum word_sel w;
     string * prev_fold;
     CONST char *format; 
     CONST char *msg;
     va_dcl
#endif
{
    va_list vl;
    struct string * word = NULL;
    int save_copy = 0;

    switch (w) {
    case word_change: 
	word = format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmChange, "change"));
	break;
    case word_save:
	word = format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmSave, "save"));
	break;
    case word_copy:
	word = format_string(CATGETS(elm_msg_cat, ElmSet, ElmCopy, "copy"));
	break;
    case word_save_copy:
	word = format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmSaveCopy, "save copy"));
	save_copy = 1;
	break;
    case word_read:
	word = format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmRead, "read"));
	break;
    }

    Va_start(vl, msg);           /* defined in defs.h */

    run_browser(p,buffer,redraw,save_copy,word,prev_fold,
		format,msg,vl);
    va_end(vl);
   

    free_string(&word);
}

int file_browser(
#if ANSI_C
				    struct folder_browser *p,
				    struct string **buffer,
				    int * redraw,
				    enum word_sel w,
				    const char *format, const char *msg, ...
#else
				    p,buffer,redraw,w,
				    format, msg, va_alist
#endif
)
#if !ANSI_C
     struct folder_browser *p;
     struct string **buffer;
     int * redraw;
     enum word_sel w;
     CONST char *format; 
     CONST char *msg;
     va_dcl
#endif
{
    int ret = 0;
    int code;
    int flags;
    va_list vl;

    struct string *text;
    struct string *vector[4];     /* We use same vector than on folder browser
				     so that we can share routines ....
				  */
    struct enter_info INFO;
    struct string * word = NULL;

    Va_start(vl, msg);           /* defined in defs.h */


    DPRINT(Debug,5,
	   (&Debug, "file_browser: Entering [%s]\n",format));

    switch (w) {
    case word_change: 
	word = format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmChange, "change"));
	break;
    case word_save:
	word = format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmSave, "save"));
	break;
    case word_copy:
	word = format_string(CATGETS(elm_msg_cat, ElmSet, ElmCopy, "copy"));
	break;
    case word_save_copy:
	word = format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmSaveCopy, "save copy"));
	break;
    case word_read:
	word = format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmRead, "read"));
	break;
    }

    text = elm_smessage(0,format,msg,vl);

    vector[0] = *buffer;
    vector[1] = text;
    vector[2] = word;
    vector[3] = NULL;

    INFO.counter     =  0;             /* Page number here */
    INFO.pvector     = vector;
    INFO.px          = 0;              /* line number here */
    INFO.py          = 0;              /* flags       here */
    INFO.give_buffer = gb_filebrowser;

    INFO.flags       = (*buffer ? 0 : OE_APPEND_CURRENT ) |
	OE_REDRAW_MARK | OE_TABACTION;

    INFO.ch_count    = 0;
    INFO.builtin     = NULL;
    INFO.dir_p       = p;

    clear_selection_dir(p);
    do {
	code = enter_helper(&INFO);
    } while (code == REDRAW_MARK);
    
    MoveCursor(elm_LINES-3,0);
    CleartoEOS();
    show_last_error();

    va_end(vl);
   
    MoveCursor(elm_LINES-3,0);
    CleartoEOS();
    show_last_error();

    flags = give_dir_flags(p);

    if (0 != (BROWSER_SELECTED & flags))
	ret = 1;
	
    if (INFO.GB_FLAGS & GB_REDRAW)
	*redraw = TRUE;

    *buffer = vector[0];

    free_string(&text);
    free_string(&word);

    DPRINT(Debug,10, (&Debug,  "file_browser=%d\n",ret));
    
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

