static char rcsid[] = "@(#)$Id: save_opts.c,v 1.21 2001/06/09 14:29:42 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.21 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains the routine needed to allow the users to change the
    Elm parameters and then save the configuration in a ".elm/elmrc" file in
    their home directory.  With any luck this will allow them never to have
    to actually EDIT the file!!

**/

#include "headers.h"
#include "s_elmrc.h"
#include <errno.h>
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"config");

#undef onoff
#define   onoff(n)	(n == 0? "OFF":"ON")

#define absolute(x)		((x) < 0? -(x) : (x))

extern  int errno;
extern char version_buff[];

char *error_description(), *sort_name(), *alias_sort_name(), *level_name();
char *mode_to_str();
long  ftell();

#include "rc_imp.h"
#include "save_opts.h"

FILE *elminfo;		/* informational file as needed... */

static void add_comment P_((int iindex, FILE *fd));
static void build_offset_table P_((FILE *elminfo_fd));
static int find_and_store_loc P_((char *name, long  offset));

void save_options()
{
    /** Save the options currently specified to a file.  This is a
	fairly complex routine since it tries to put in meaningful
	comments and such as it goes along.  The comments are
	extracted from the file ELMRC_INFO as defined in the sysdefs.h
	file.  THAT file has the format;

		varname
		  <comment>
		  <comment>
		<blank line>

	and each comment is written ABOVE the variable to be added.  This
	program also tries to make 'pretty' stuff like the alternatives
	and such.
    **/

    FILE *newelmrc; 
    char  oldfname[SLEN], newfname[SLEN];
    
    strfcpy(newfname,user_rc_file,sizeof newfname);
    elm_sfprintf(oldfname, sizeof oldfname,
		 FRM("%s/%s"), 
		 home, old_elmrcfile);
    
    /** first off, let's see if they already HAVE a .elm/elmrc file **/
    
    save_file_stats(newfname);
    if (access(newfname, ACCESS_EXISTS) != -1) {
	/** YES!  Copy it to the file ".old.elmrc".. **/
	if (rename(newfname, oldfname) < 0)
	    DPRINT(Debug,2,(&Debug,  "Unable to rename %s to %s\n", 
			    newfname, oldfname));
	(void) elm_chown(oldfname, userid, groupid);
	
    }
    
    /** now let's open the datafile if we can... **/
    
    if ((elminfo = fopen(ELMRC_INFO, "r")) == NULL) 
	lib_error(CATGETS(elm_msg_cat, ElmrcSet, ElmrcSavingWithoutComments,
			  "Warning: saving without comments! Can't get to %s."), 
		  ELMRC_INFO);
    
    /** next, open the new .elm/elmrc file... **/
    
    if ((newelmrc = fopen(newfname, "w")) == NULL) {
	lib_error(CATGETS(elm_msg_cat, ElmrcSet, ElmrcCantSaveConfig,
			  "Can't save configuration! Can't write to %s [%s]."),
		  newfname, error_description(errno));
	return;
    }
    
    save_user_options(elminfo, newelmrc);
    restore_file_stats(newfname);
    
    lib_error(CATGETS(elm_msg_cat, ElmrcSet, ElmrcOptionsSavedIn,
		      "Options saved in file %s."), newfname);
}


int find_opt(s)
     char *s;
{
	int x, y = 0;

	for (x = 0; x < NUMBER_OF_SAVEABLE_OPTIONS; x++) {
	    y = strcmp(s, save_info[x].name);
	    if (y <= 0)
		break;
	}

	if (y != 0)
	    return(-1);
	return(x);
}

char *str_opt_nam(s, f)
     char *s;
     int f;
{
    char *t = NULL;
    
    if (0 == strcmp("aliassortby",s))
	t = alias_sort_name(SHORT);
    else if (0 == strcmp("userlevel",s))
	t = level_name(user_level);
    else {
	int x = find_opt(s);
	if (x >= 0) {
	    
	    if (!valid_rc_type(save_info[x].dt_type))
		panic("RC PANIC",__FILE__,__LINE__,"str_opt_nam",
		      "Bad config item type",0);

	    /* Returns pointer to static buffer */
	    t = save_info[x].dt_type->get_value(& save_info[x]);	    
	}
    }
    return(t);
}


void save_user_options(elminfo_fd, newelmrc)
     FILE *elminfo_fd, *newelmrc;
{
    int x, local_value;
    char buf[SLEN];

    /** save the information in the file.  If elminfo_fd == NULL don't look
	for comments!
    **/

    if (elminfo_fd != NULL) 
	build_offset_table(elminfo_fd);
    
    elm_fprintf(newelmrc, 
		CATGETS(elm_msg_cat, ElmrcSet, ElmrcOptionsFile,
			"#\n# .elm/elmrc - options file for the ELM mail system\n#\n"));

    if (strlen(full_username) > 0)
	elm_fprintf(newelmrc, 
		    CATGETS(elm_msg_cat, ElmrcSet, ElmrcSavedAutoFor,
			    "# Saved automatically by ELM %s for %s\n#\n\n"),
		    version_buff, full_username);
    else
	elm_fprintf(newelmrc, 
		    CATGETS(elm_msg_cat, ElmrcSet, ElmrcSavedAuto,
			    "# Saved automatically by ELM %s\n#\n\n"), 
		    version_buff);

    if (elminfo_fd != NULL) {
	x = FALSE;
	rewind(elminfo_fd);
	while (!x && fgets(buf, sizeof(buf), elminfo_fd) != NULL)
	    x = (strncmp(buf, "#$HDR", 5) == 0);
	if (x) {
	    while (fgets(buf, sizeof(buf), elminfo_fd) != NULL) {
		if (buf[0] != '#')
		    break;
		fputs(buf, newelmrc);
	    }
	}
    }

    for (x = 0; x < NUMBER_OF_SAVEABLE_OPTIONS; x++) {

	/** skip system-only options **/
	if (save_info[x].flags & FL_SYS) {
	    DPRINT(Debug,15,(&Debug, 
			     "Option %d -- \"%s\" system-only, flags=%0x\n",
			     x,save_info[x].name, save_info[x].flags ));
	    continue;
	}

	local_value = save_info[x].flags & FL_LOCAL;
	add_comment(x, newelmrc);

	if (!valid_rc_type(save_info[x].dt_type))
	    panic("RC PANIC",__FILE__,__LINE__,"save_user_options",
		  "Bad config item type",0);

	save_info[x].dt_type->print_value(newelmrc,
					  & save_info[x],
					  !local_value);
    }

#ifdef USE_DLOPEN
    print_local_shared_options(newelmrc);
#endif

    fclose(newelmrc);
    if ( elminfo_fd != NULL ) {
	fclose(elminfo_fd);
    }
}

static void add_comment(iindex, fd)
     int iindex;
     FILE *fd;
{	
	/** get to and add the comment to the file **/
	char buffer[SLEN];

	/** always put a blank line between options */
	fputc('\n', fd);

	/** add the comment from the comment file, if available **/
	if (save_info[iindex].offset > 0L) {
	    if (fseek(elminfo, save_info[iindex].offset, 0) == -1) {
		DPRINT(Debug,1,(&Debug, 
				"** error %s seeking to %ld in elm-info file!\n",
				error_description(errno), 
				save_info[iindex].offset));
	    } else {
		while (fgets(buffer, SLEN, elminfo) != NULL) {
		    if (buffer[0] != '#') 
			break;
		    fputs(buffer, fd);
		}
	    }
	}
}

static void build_offset_table(elminfo_fd)
     FILE *elminfo_fd;
{
	/** read in the info file and build the table of offsets.
	    This is a rather laborious puppy, but at least we can
	    do a binary search through the array for each element and
	    then we have it all at once!
	**/

	char line_buffer[SLEN];
	
	while (fgets(line_buffer, SLEN, elminfo_fd) != NULL) {
	  if (strlen(line_buffer) > 1)
	    if (line_buffer[0] != '#' && !whitespace(line_buffer[0])) {
	       no_ret(line_buffer);
	       if (find_and_store_loc(line_buffer, ftell(elminfo_fd))) {
		   DPRINT(Debug,1,(&Debug, 
				   "** Couldn't find and store \"%s\" **\n", 
				   line_buffer));
	       }
	    }
	}
}

static int find_and_store_loc(name, offset)
     char *name;
     long  offset;
{
	/** given the name and offset, find it in the table and store it **/

	int first = 0, last, middle, compare;

	last = NUMBER_OF_SAVEABLE_OPTIONS;

	while (first <= last) {

	  middle = (first+last) / 2;

	  if ((compare = strcmp(name, save_info[middle].name)) < 0) /* a < b */
	    last = middle - 1;
	  else if (compare == 0) {				    /* a = b */
	    save_info[middle].offset = offset;
	    return(0);
	  }
	  else  /* greater */					    /* a > b */
	    first = middle + 1; 
	}

	return(-1);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
