static char rcsid[] = "@(#)$Id: fastmail.c,v 1.12 2001/06/16 10:40:38 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.12 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This program is specifically written for group mailing lists and
    such batch type mail processing.  It does NOT use aliases at all,
    it does NOT read the /etc/password file to find the From: name
    of the user and does NOT expand any addresses.  It is meant 
    purely as a front-end for either /bin/mail or /usr/lib/sendmail
    (according to what is available on the current system).

         **** This program should be used with CAUTION *****

**/


/** The calling sequence for this program is:

	fastmail {args}  [ filename | - ] full-email-address 

   where args could be any (or all) of;

	   -b bcc-list		(Blind carbon copies to)
	   -c cc-list		(carbon copies to)
	   -C comment-line      (Comments:)
	   -d ...		(debug on)
	   -f from 		(from name)
	   -F from-addr		(the actual address to be put in the From: line)
	   -i msg-id            (In-Reply-To: msgid)
	   -r reply-to-address 	(Reply-To:)
	   -R references        (References:)
	   -P precedence        (Precedence:)
	   -s subject 		(subject of message)
**/

#include "elmutil.h"
#include "s_fastmail.h"

DEBUG_VAR(Debug,__FILE__,"util");

#define  binrmail	"/bin/rmail"
#define  temphome	"/tmp/fastmail."

char *get_arpa_date();
static void usage();

int main(argc, argv)
     int argc;
     char *argv[];
{

	extern char *optarg;
	extern int optind;
	FILE *tempfile;
	char from_string[SLEN], 
	  subject[SLEN];
	char filename[SLEN], tempfilename[SLEN], command_buffer[256];
	char replyto[SLEN], cc_list[SLEN], bcc_list[SLEN], to_list[SLEN];
	char from_addr[SLEN], comments[SLEN], inreplyto[NLEN];
	char references[SLEN], precedence[SLEN];
	char *p;
	int  c, sendmail_available;

#if DEBUG
	init_debugfile("FASTMAIL");
#endif
	locale_init();

	from_string[0] = '\0';
	subject[0] = '\0';
	replyto[0] = '\0';
	cc_list[0] = '\0';
	bcc_list[0] = '\0';
	to_list[0] = '\0';
	from_addr[0] = '\0';
	comments[0] = '\0';
	inreplyto[0] = '\0';
	references[0] = '\0';
	precedence[0] = '\0';

	user_init();
	init_defaults();
	read_rc_file();

	if ((p = getenv("REPLYTO")) != NULL)
	  strfcpy(replyto, p, sizeof replyto);

	while ((c = getopt(argc, argv, "b:c:C:d:f:F:i:r:R:P:s:")) != EOF) {
	  switch (c) {
	    case 'b' : strfcpy(bcc_list, optarg, 
			       sizeof bcc_list);		break;
	    case 'c' : strfcpy(cc_list, optarg, 
			       sizeof cc_list);		break;
	    case 'C' : strfcpy(comments, optarg, 
			       sizeof comments);		break;
	     case 'd' : 
#if DEBUG
		 set_debugging(optarg);	   
#else
		 lib_error(CATGETS(elm_msg_cat, FastmailSet, 
				   FastmailIngoringDebug,
				   "Warning: system created without debugging enabled - request ignored\n"));
#endif
		 break;
	    case 'f' : strfcpy(from_string, optarg,
			       sizeof from_string);	break;
	    case 'F' : strfcpy(from_addr, optarg,
			       sizeof from_addr);		break;
	    case 'i' : strfcpy(inreplyto, optarg,
			       sizeof inreplyto);		break;
	    case 'r' : strfcpy(replyto, optarg,
			       sizeof replyto);		break;
	    case 'R' : strfcpy(references, optarg,
			       sizeof references);		break;
	    case 'P' : strfcpy(precedence, optarg,
			       sizeof precedence);		break;
	    case 's' : strfcpy(subject, optarg,
			       sizeof subject);		break;
	    case '?' : usage();
 	  }
	}	



	elm_sfprintf(version_buff, sizeof version_buff,
		     FRM("%s PL%s"), VERSION, PATCHLEVEL);
	
#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the FASTMAIL program (version %s).\n",
			     version_buff);

#if 0	
	if (d >= 50) {
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    error_sleep(5+sleepmsg);	    
	}
#endif
    }
#endif

	if (optind >= argc) {
	    usage();
	}

	strfcpy(filename, argv[optind++], sizeof filename);

	if (optind >= argc) {
	    usage();
	}

	if (strcmp(filename, "-")) {
	  if (access(filename, READ_ACCESS) == -1) {
	    fprintf(stderr, "Error: can't find file %s!\n", filename);
	    exit(1);
	  }
	}

	elm_sfprintf(tempfilename, sizeof tempfilename,
		     FRM("%s%d"), 
		     temphome, getpid());

	if ((tempfile = fopen(tempfilename, "w")) == NULL) {
	  fprintf(stderr, "Couldn't open temp file %s\n", tempfilename);
	  exit(1);
	}

	/** Subject must appear even if "null" and must be first
	    at top of headers for mail because the
	    pure System V.3 mailer, in its infinite wisdom, now
	    assumes that anything the user sends is part of the 
	    message body unless either:
		1. the "-s" flag is used (although it doesn't seem
		   to be supported on all implementations?)
		2. the first line is "Subject:".  If so, then it'll
		   read until a blank line and assume all are meant
		   to be headers.
	    So the gory solution here is to move the Subject: line
	    up to the top.  I assume it won't break anyone elses program
	    or anything anyway (besides, RFC-822 specifies that the *order*
	    of headers is irrelevant).  Gahhhhh....

	    If we have been configured for a smart mailer then we don't want
	    to add a from line.  If the user has specified one then we have
	    to honor their wishes.  If they've just given a 'from name' then
	    we'll just put in the username and hope the mailer can add the
	    correct domain in.
	**/
	fprintf(tempfile, "Subject: %s\n", subject);

	if (*from_string)
	  if (*from_addr)
	      fprintf(tempfile, "From: %s (%s)\n", from_addr, from_string);
	  else
#ifdef DONT_ADD_FROM
	      fprintf(tempfile, "From: %s (%s)\n", username, from_string);
#else
	      fprintf(tempfile, "From: %s!%s (%s)\n", hostname, username, 
		      from_string);
#endif
	else
	  if (*from_addr)
	    fprintf(tempfile, "From: %s\n", from_addr);
#ifndef DONT_ADD_FROM
	  else
	    fprintf(tempfile, "From: %s!%s\n", hostname, username);
#endif

	fprintf(tempfile, "Date: %s\n", get_arpa_date());

	if (replyto[0])
	  fprintf(tempfile, "Reply-To: %s\n", replyto);

	while (optind < argc) {
	  if (to_list[0])
	    strfcat(to_list, ",", sizeof to_list);
	  strfcat(to_list, argv[optind++], sizeof to_list);
	}
	
	fprintf(tempfile, "To: %s\n", to_list);

	if (cc_list[0])
	  fprintf(tempfile, "Cc: %s\n", cc_list);

	if (references[0])
	  fprintf(tempfile, "References: %s\n", references);

	if (precedence[0])
	  fprintf(tempfile, "Precedence: %s\n", precedence);

	if (inreplyto[0])
	  fprintf(tempfile, "In-Reply-To: %s\n", inreplyto);

	if (comments[0])
	  fprintf(tempfile, "Comments: %s\n", comments);

#ifndef NO_XHEADER
	fprintf(tempfile, "X-Mailer: fastmail [version %s PL%s]\n",
	  VERSION, PATCHLEVEL);
#endif /* !NO_XHEADER */
	fprintf(tempfile, "\n");

	fclose(tempfile);

	/** now we'll cat both files to /bin/rmail or sendmail... **/

	sendmail_available = (access(sendmail, EXECUTE_ACCESS) != -1);

	DPRINT(Debug,1,(&Debug,			    
			"Mailing to %s%s%s%s%s [via %s]\n", to_list,
			(cc_list[0] ? " ":""), cc_list,
			(bcc_list[0] ? " ":""), bcc_list,
			sendmail_available? "sendmail" : "rmail"));

	elm_sfprintf(command_buffer, sizeof command_buffer,
		     FRM("cat %s %s | %s %s %s %s"), 
		     tempfilename, filename, 
		     sendmail_available? sendmail : mailer,
		     to_list, cc_list, bcc_list);

	DPRINT(Debug,1,(&Debug, 
			"%s\n", command_buffer));

	c = system(command_buffer);

	unlink(tempfilename);

	exit(c != 0);
	/*NOTREACHED*/
}

static void usage()
{

	lib_error(CATGETS(elm_msg_cat, FastmailSet, FastmailUsage,
"Usage: fastmail {args} [ filename | - ] address(es)\n\
   where {args} can be;\n\
\t-b bcc-list\n\t-c cc-list\n\t-d ...\n\
\t-C comments\n\t-f from-name\n\t-F from-addr\n\
\t-i msg-id\n\t-r reply-to\n\t-R references\n\
\t-P precedence\n\t-s subject\n\n"));

	exit(1);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

