/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------

*/
/****************************************************************************
 *    IMPLEMENTATION HEADERS
 ****************************************************************************/

#include <string.h>

#include "ecurses.h"
#include "xmalloc.h"

/****************************************************************************
 *    IMPLEMENTATION PRIVATE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

#define INITIAL_SIZE 10

/****************************************************************************
 *    IMPLEMENTATION PRIVATE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

struct pair {
  int fg;
  int bg;
};

/****************************************************************************
 *    IMPLEMENTATION REQUIRED EXTERNAL REFERENCES (AVOID)
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE DATA
 ****************************************************************************/

/**
 * this is used to pass bold flag for some colors
 */
static int bold = 0;

static int          pair_count = 0;
static int          pair_size  = 0;
static struct pair *pairs      = NULL;

/****************************************************************************
 *    INTERFACE DATA
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTIONS
 ****************************************************************************/

static int
color_value (const char *str)
{
  bold = 0;
  
  if (strcmp (str, "grey") == 0){
    bold = 1;
    return COLOR_BLACK;
  }
  
  if (strcmp (str, "black") == 0)
    return COLOR_BLACK;

  if (strcmp (str, "rose") == 0){
    bold = 1;
    return COLOR_RED;
  }
  
  if (strcmp (str, "red") == 0)
    return COLOR_RED;

  if (strcmp (str, "lime") == 0){
    bold = 1;
    return COLOR_GREEN;
  }
  
  if (strcmp (str, "green") == 0)
    return COLOR_GREEN;

  if (strcmp (str, "yellow") == 0){
    bold = 1;
    return COLOR_YELLOW;
  }

  if (strcmp (str, "orange") == 0)
    return COLOR_YELLOW;

  if (strcmp (str, "blue") == 0)
    return COLOR_BLUE;
  
  if (strcmp (str, "violet") == 0){
    bold = 1;
    return COLOR_MAGENTA;
  }
  
  if (strcmp (str, "magenta") == 0)
    return COLOR_MAGENTA;

  if (strcmp (str, "lightblue") == 0){
    bold = 1;
    return COLOR_CYAN;
  }
  
  if (strcmp (str, "cyan") == 0)
    return COLOR_CYAN;

  if (strcmp (str, "white") == 0){
    bold = 1;
    return COLOR_WHITE;
  }

  return COLOR_WHITE;
}



static int
lookup (int fg, int bg)
{
  int i;

  for (i = 0; i < pair_count; i++){
    if (pairs[i].fg == fg && pairs[i].bg == bg)
      return COLOR_PAIR (i + 1);
  }

  if (pairs == NULL){
    pair_size = INITIAL_SIZE;
    pairs     = xmalloc (pair_size * sizeof (struct pair));
  }
  
  if (pair_count == pair_size){
    pair_size *= 2;
    pairs      = xrealloc (pairs, pair_size * sizeof (struct pair));
  }

  pairs[i].bg = bg;
  pairs[i].fg = fg;

  init_pair (i + 1, fg, bg);

  pair_count++;

  return COLOR_PAIR (i + 1);
}


/****************************************************************************
 *    INTERFACE FUNCTIONS
 ****************************************************************************/

chtype
color_from_val (int fg, int bg, int bold)
{
  if (bold)
    return lookup (fg, bg) | A_BOLD;
  else
    return lookup (fg, bg);
}



chtype
color_from_str (const char *fg, const char *bg)
{
  int local_bold;
  int fg_v;
  int bg_v;

  fg_v       = color_value (fg);
  local_bold = bold;
  bg_v       = color_value (bg);

  return color_from_val (fg_v, bg_v, local_bold);
}


void
color_free_resources (void)
{
  if (pairs)
    xfree (pairs);
  pairs      = NULL;
  pair_count = 0;
  pair_size  = 0;
}

/****************************************************************************
 *    INTERFACE CLASS BODIES
 ****************************************************************************/
/****************************************************************************
 *
 *    END MODULE color.c
 *
 ****************************************************************************/
