#ifndef __STR_H__
#define __STR_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include <stdarg.h>

#ifdef __GNUC__
# define FORMAT __attribute__ ((format (printf, 2, 3)))
#else
# define FORMAT
#endif

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

typedef struct _str {
        char *str;
        int   len;
        int   size;
} str_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern str_t *str_create_size (int size);
extern str_t *str_create (void);
extern str_t *str_dup (const char *str);
extern str_t *str_from_str (char *str, int len);
extern void   str_destroy (str_t *str);
extern void   str_clear (str_t *str);
extern char  *str_finished (str_t *str);
extern void   str_put_nchar (str_t *str, int c, int n);
extern void   str_put_char (str_t *str, int c);
extern void   str_put_string_len (str_t *str, const char *s, int len);
extern void   str_put_string (str_t *str, const char *s);
extern int    str_vsprintf (str_t *str, const char *fmt, va_list ap);
extern int    str_sprintf (str_t *str, const char *fmt, ...) FORMAT;
extern void   str_chop (str_t *str);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER str.h
 *
 ****************************************************************************/
#endif
