/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------

*/
/****************************************************************************
 *    IMPLEMENTATION HEADERS
 ****************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <ctype.h>

#include "topbar.h"
#include "ecurses.h"
#include "interface.h"
#include "ask.h"
#include "color.h"
#include "keymap.h"
#include "cmd.h"
#include "help.h"
#include "sender.h"
#include "gettext.h"
#include "mailreader.h"
#include "box_selection.h"
#include "fetch.h"
#include "smtp.h"
#include "abook.h"
#include "attach.h"

/****************************************************************************
 *    IMPLEMENTATION PRIVATE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION REQUIRED EXTERNAL REFERENCES (AVOID)
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE DATA
 ****************************************************************************/

/* Toppbar window. */
static WINDOW *window;

/* Color used to display toppbar window. */
static chtype text_color;

/****************************************************************************
 *    INTERFACE DATA
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTIONS
 ****************************************************************************/


static int
print_key (int maxlen, void (*fun)(void), const char *desc)
{
        int          ret;
        struct _key *key;

        key = keymap_lookup_fun (keymaps + cmd_state_get (0), fun);
        if (key == NULL)
                return 0;

        if (key->key != '\r' && key->key != ' '
            && (! isprint (key->key) || isspace (key->key)))
                return 0;
        
        window_addch (window, ' ');
        window_addch (window, ' ');
        switch (key->key){

                case '\r':
                        window_addstr (window, "<enter>");
                        ret = 10;
                        break;

                case ' ':
                        window_addstr (window, "<space>");
                        ret = 10;
                        break;

                default:
                        window_addch (window, key->key);
                        ret = 4;
                        break;
        }
        window_addch (window, ':');

        ret += window_addnstr (window, desc, maxlen);

        return ret;
}


static void
draw_bar (void)
{
        int width, nothing;

        getmaxyx (window, nothing, width);
        
        wmove (window, 0, 0);
        
        width -= window_addnstr (window, "[" PACKAGE_STRING "]", width);

        width -= print_key (width, cmd_quit, _("Quit"));
        width -= print_key (width, help_open, _("Help"));
        switch (cmd_state_get (0)){

                case CMD_INVALID:
                        break;
                        
                case CMD_LIST:
                        width -= print_key (width, sender_open_new, _("Mail"));
                        width -= print_key (width, sender_open_reply, _("Reply"));
                        width -= print_key (width, sender_open_reply_all, _("Reply all"));
                        width -= print_key (width, sender_open_fwd, _("Forward"));
                        width -= print_key (width, mailreader_show, _("Read"));
                        width -= print_key (width, fetch_open, _("Fetch"));
                        width -= print_key (width, smtp_flush_outbox, _("Send"));
                        break;

                case CMD_READ_MAIL:
                        width -= print_key (width, mailreader_close, _("Close"));
                        width -= print_key (width, sender_open_reply, _("Reply"));
                        width -= print_key (width, sender_open_reply_all, _("Reply all"));
                        width -= print_key (width, sender_open_fwd, _("Forward"));
                        width -= print_key (width, attach_show, _("Attachments"));
                        width -= print_key (width, abook_add_show, _("Addresses"));
                        width -= print_key (width, mailreader_header_switch, _("Header"));
                        break;

                case CMD_SELECT_BOX:
                        width -= print_key (width, box_selection_hit, _("Open"));
                        break;

                case CMD_FETCH:
                        width -= print_key (width, fetch_close, _("Close"));
                        width -= print_key (width, fetch_get_mail, _("Fetch"));
                        width -= print_key (width, fetch_del_mail, _("Delete"));
                        break;

                case CMD_SENDER:
                        width -= print_key (width, sender_close, _("Cancel"));
                        width -= print_key (width, sender_go, _("Send"));
                        width -= print_key (width, sender_add_attachment, _("Attach"));
                        break;

                case CMD_ATTACH:
                        width -= print_key (width, attach_hide, _("Close"));
                        width -= print_key (width, attach_hit, _("Show"));
                        width -= print_key (width, attach_save, _("Save"));
                        width -= print_key (width, attach_save_all, _("Save all"));
                        break;

                case CMD_ABOOK:
                        width -= print_key (width, abook_hide, _("Close"));
                        width -= print_key (width, abook_compose, _("Mail"));
                        width -= print_key (width, abook_insert, _("New"));
                        width -= print_key (width, abook_hit, _("Select"));
                        break;

                case CMD_ABOOK_ADD:
                        width -= print_key (width, abook_add_hide, _("Close"));
                        width -= print_key (width, abook_add_hit, _("Add"));
                        break;

                case CMD_ASK:
                        break;

                case CMD_HELP:
                        width -= print_key (width, help_close, _("Close"));
                        break;

                case CMD_READ:
                        break;

                case CMD_DEBUG:
                        break;

                case CMD_SEARCH:
                        break;
        }
        
        while (width-- >= 0)
                window_addch (window, ' ');

        touchwin (window);
        wnoutrefresh (window);
}


/* This file is generated by interface.pl script from interface.desc,
   and inc.in. */
static WINDOW *interface_init (void);
#include "topbar.inc"

/****************************************************************************
 *    INTERFACE FUNCTIONS
 ****************************************************************************/

void
topbar_init (void)
{
        window = interface_init ();
        draw_bar ();
}



void
topbar_free_resources (void)
{
        delwin (window);
}


void
topbar_refresh (void)
{
        draw_bar ();
}

/****************************************************************************
 *    INTERFACE CLASS BODIES
 ****************************************************************************/
/****************************************************************************
 *
 *    END MODULE toppbar.c
 *
 ****************************************************************************/
