// Pablo Halpern, 1999
// Permission is granted to use, modify and distribute freely.

// Implementation of rel_ops namespace for egcs 1.1.2 library.
// A conforming implementation would define these in <utility>

#ifndef rel_ops_dot_h
#define rel_ops_dot_h 1

namespace std
{
  
namespace rel_ops
{
  // Defining != causes conflicts with iterators in egcs 1.1.2
  //  template <class T>
  //    bool operator!=(const T& t1, const T& t2) { return ! (t1 == t2); }
  template <class T>
    bool operator>(const T& t1, const T& t2) { return (t2 < t1); }
  template <class T>
    bool operator<=(const T& t1, const T& t2) { return ! (t2 < t1); }
  template <class T>
    bool operator>=(const T& t1, const T& t2) { return ! (t1 < t2); }
}

} // End namepace std


#endif /* rel_ops_dot_h */
