/* ========================================================================== */
/* Operating system API */
/*
 * Never include this file directly. Include 'posix.h' instead.
 */

#ifndef BSD_FOR_POSIX
#  error Do not include 'bsd.h' directly, include 'posix.h' instead!
#endif  /* BSD_FOR_POSIX */

#include <unistd.h>
#include <errno.h>
#include <sys/types.h>


/* ========================================================================== */
/* General stuff */

#include <sys/socket.h>

#define POSIX_MSG_PEEK  MSG_PEEK

#define posix_ssize_t  ssize_t


/* ========================================================================== */
/* ARPA internet stuff */

#include <netinet/in.h>
#include <arpa/inet.h>

#define POSIX_AF_UNSPEC  0U
#define POSIX_AF_INET    1U

typedef unsigned int  posix_sa_family_t;

#if CFG_HDR_INTTYPES_H
#   include <inttypes.h>
typedef uint16_t  posix_in_port_t;
typedef uint32_t  posix_in_addr_t;
#else
typedef CFG_UINT16_TYPE  posix_in_port_t;
typedef CFG_UINT32_TYPE  posix_in_addr_t;
#endif  /* CFG_HDR_INTTYPES_H */

/* IPv4 network address */
struct posix_in_addr
{
   posix_in_addr_t  s_addr;
};

#define struct_posix_in_addr  struct posix_in_addr

/* IPv4 socket address */
struct posix_sockaddr_in
{
   posix_sa_family_t  sin_family;
   posix_in_port_t  sin_port;
   struct_posix_in_addr  sin_addr;
};

#define struct_posix_sockaddr_in  struct posix_sockaddr_in

#if CFG_HDR_INTTYPES_H
#   include <inttypes.h>
uint16_t  posix_htons(uint16_t);
uint32_t  posix_htonl(uint32_t);
uint16_t  posix_ntohs(uint16_t);
uint32_t  posix_ntohl(uint32_t);
#else
unsigned short int  posix_htons(unsigned short int);
unsigned long int  posix_htonl(unsigned long int);
unsigned short int  posix_ntohs(unsigned short int);
unsigned long int  posix_ntohl(unsigned long int);
#endif  /* CFG_HDR_INTTYPES_H */

posix_in_addr_t  posix_inet_addr(const char*);
int  posix_inet_pton(int, const char*, void*);


/* ========================================================================== */
/* Socket API */

#include <string.h>

#define POSIX_SOCK_STREAM  0

/* Yes, this type is signed in the original BSD API */
typedef int  posix_socklen_t;

/* Maximum size socket address structure to allocate memory */
struct posix_sockaddr_storage
{
   posix_sa_family_t  ss_family;
   char  ss_data[sizeof(struct_posix_sockaddr_in)
                 - sizeof(posix_sa_family_t)];
};

#define struct_posix_sockaddr_storage  struct posix_sockaddr_storage

struct posix_sockaddr
{
   posix_sa_family_t  sa_family;
   char  sa_data[sizeof(struct_posix_sockaddr_in)
                 - sizeof(posix_sa_family_t)];
};

#define struct_posix_sockaddr  struct posix_sockaddr

struct posix_servent
{
   char*  s_name;
   char**  s_aliases;
   int  s_port;
   char*  s_proto;
};

#define struct_posix_servent  struct posix_servent

struct posix_hostent
{
   char*  h_name;
   char**  h_aliases;
   int  h_addrtype;
   int  h_length;
   char**  h_addr_list;
};

#define struct_posix_hostent  struct posix_hostent

struct_posix_servent*  posix_getservbyname(const char*, const char*);
struct_posix_hostent*  posix_gethostbyname(const char*);

int  posix_socket(int, int, int);
int  posix_connect(int, const struct_posix_sockaddr*, posix_socklen_t);

#define POSIX_SOL_SOCKET   0

#define POSIX_SO_ERROR     0
#define POSIX_SO_RCVTIMEO  1
#define POSIX_SO_SNDTIMEO  2

int  posix_getsockopt(int, int, int, void*, posix_socklen_t*);
int  posix_setsockopt(int, int, int, const void*, posix_socklen_t);

#define POSIX_POLLIN    (short int) 0x0001
#define POSIX_POLLOUT   (short int) 0x0002
#define POSIX_POLLERR   (short int) 0x0004
#define POSIX_POLLHUP   (short int) 0x0008
#define POSIX_POLLNVAL  (short int) 0x0010

typedef unsigned int  posix_nfds_t;

struct posix_pollfd
{
   int  fd;
   short int  events;
   short int  revents;
};

#define struct_posix_pollfd  struct posix_pollfd

int  posix_poll(struct_posix_pollfd [], posix_nfds_t, int);

posix_ssize_t  posix_send(int, const void*, size_t, int);
posix_ssize_t  posix_recv(int, void*, size_t, int);


/* EOF */
