#ifndef FILEUTILS_H
#define FILEUTILS_H  1


/* ========================================================================== */
/* Function prototypes */

int  fu_check_path(const char*);
int  fu_create_path(const char*, posix_mode_t);
int  fu_check_file(const char*, struct_posix_stat*);
int  fu_open_file(const char*, int*, int, posix_mode_t);
void  fu_close_file(int*, FILE**);
int  fu_lock_file(int);
int  fu_unlink_file(const char*);
int  fu_assign_stream(int, FILE**, const char*);
int  fu_sync(int, FILE*);
int  fu_read_whole_file(int, char**, size_t*);
int  fu_read_from_filedesc(int, char*, size_t*);
int  fu_write_to_filedesc(int, const char*, size_t);
int  fu_delete_tree(const char*);


#endif  /* FILEUTILS_H */

/* EOF */
