
Changelog
=========

0.18       Bugfix: Encoder for MIME encoded-words fixed (folding in the first
            line of a header field should work now)
           Bugfix: Header parser no longer collapse whitespace in FWS for
            unstructured header fields (as defined by RFC5322)
           Bugfix: MIME decoder now ignores WSP between adjacent encoded-words
            (formerly HTAB was not ignored)
           Bugfix: UTF-7 decoder fixed (has dropped character that terminates
            shift sequence directly before EOD)
           Bugfix: UTF-8 repair function fixed (failed to resync in some cases)
           Bugfix: Use FLTK default foreground color (was formerly overwritten
            with FL_BLACK and not readable in darkmode environments)
           Bugfix: Use defined gray for signature color (formerly the FLTK
            FL_GRAY_RAMP was used that is different in darkmode environments)
           Bugfix: Length highlighting in editor doesn't work for pasted
            external text (only when text containing empty lines is inserted)
           Bugfix: Cancelled articles at end of range are no longer counted
            as unread in the group list (was only broken when overview is used)
           Searching for Unicode string in current article is now supported
            (case insensitive variant based on Unicode case folding algorithm)
           Switch for case-sensitive or case-insensitive search added to GUI
            (last state is loaded from configfile on startup)
           Unicode database updated to version 13.0.0 (CaseFolding.txt added)
           The new 'force_unicode' entry in configfile set to a nonzero value
            sends all outgoing articles in Unicode, if they contain non-ASCII
            characters
           Dark background color is now usable
            Thanks to Christian Schumacher for his help
           MIME conformance reached (as defined in RFC2049 Section 2)
           MIME content type "message/rfc822" is now supported
           MIME content type "multipart/digest" is now supported
           MIME entity with unsupported content can now be saved to a file
           MIME content disposition "attachment" is respected (including the
            suggestion for a filename)
           MIME encoded-word decoder now treats LF and CR as unwanted control
            characters too
           If selected text is present, quote only selected text for followup
           In threaded view (or article list) HTAB characters are now replaced
            with SP (for consistency with OVER command according to RFC3977)
           XDG desktop entry and icon theme added (option 'CFG_XDG_DISABLE')
            Thanks to Detlef Graef and Martin Hauke for their help
            This option defaults to 1 (former behaviour)
           Introduction line can now contain newsgroups list (%g conversion,
            proposed by Marcel Logen)
           Build system: Additional awk check and useful error message added
            for POSIX character classes (detects broken mawk from Debian)
           Error tolerance of header parser improved, does now correctly split
            References header field if mandatory CFWS separators are missing
           Command line switch "-notooltips" documented in manual page
           Support for character set CESU-8 (and its IANA aliases) added
           Configuration window in GUI now allows to disable the "User-Agent"
            header field for outgoing articles (defaults to former behaviour)
           It is now possible to enable AUTHINFO USER/PASS without encrypted
            connection (option CFG_NNTP_AUTH_UNENCRYPTED). This allows to
            use stunnel instead of the internal TLS module
           TLS module no longer calls functions HMAC*(), RSA_size() and
            SSL_get_peer_certificate(). They are deprecated for OpenSSL
            API 3.0.0
           TLS module now configures the DHE groups that are negotiated for
            key exchange with LibreSSL API too
           TLS module now always prints library name and version number

0.17       Bugfix: Configuration test result for inttypes.h presence is used,
            reintroduce the test that was removed for 0.16
           Bugfix: BSD version of ntohl() for old systems was broken
           Bugfix: ISO-2022-JP decoder: Mask for unassigned codepoints fixed
           Bugfix: SHA2 support in OpenSSL 1.0.0 must be explicitly enabled
           Display article from "news" type URI in separate window (if it's not
            found in current group)
           Clickable References added (articles displayed in separate window)
           Search for Message-ID added to the Tools menu (Keyboard shortcut
            is Ctrl-s)
           Previous read article (in current group) menu entry added
           Keyboard shortcut for "Quit" changed from Ctrl-x to Ctrl-q (Proposed
            by Marcel Logen)
           Keyboard shortcut for "View source" changed from Ctrl-v to Ctrl-e
            (Proposed by Marcel Logen)
           Menu entry "Article->Mark as unread" (Ctrl-u) changed to toggle
            between read and unread state (Proposed by Marcel Logen)
           Command line option "-4" added (force usage of IPv4 network protocol)
           Flowed format: The 'flowed_insert_crlf' entry in configfile adds an
            empty line separator after every paragraph that ends with an empty
            line. Defaults to 0 (former behaviour)
           Flowed format: The behaviour of 'flowed_insert_crlf' can be requested
            by the sender of an article with "InsLine=yes" in the Content-Type
            header field.
           TLS module can now use OpenSSL 3 API (required for FFDHE group
            negotiation with TLSv1.2 and TLSv1.3 protocols)
           TLS module can now use LibreSSL 3 (formerly major version 2 was used
            to identify LibreSSL and distinguish it from OpenSSL)
           TLS modules compile time option 'CFG_USE_TLS_OWNCERTS' replaced by
            the new 'tls_owncerts' entry in configfile
           TLS modules experimental compile time option 'CFG_USE_TLS_CRLS'
            replaced by normal option 'CFG_TLS_CRLS_DISABLE'. Default is to use
            no CRLs (former behaviour) because this option increases the system
            requirements (to POSIX.1-2001 or XSI extension)
           TLS module now supports new 'crl_check' entry in configfile (ignored
            if CFG_TLS_CRLS_DISABLE is nonzero)
           TLS module now prints real LibreSSL version instead of generic 2.0.0
           TLS module no longer supports options 'CFG_USE_TLS_DHPARAM_CHECK' and
            'CFG_USE_TLS_SETSIGALG'. They were obsoleted by the OpenSSL 1.1 API
           Unicode database updated to version 12.1.0
           GUI module no longer supports experimental FLTK 1.3 option
            'USE_X11_GLYPH_SUBSTITUTION'. It was obsoleted by FLTK 1.4
           Modified LaTeX documentation to work with recent doxygen

0.16       Bugfix: Supersede now preserves Followup-To header field
           Bugfix: The code that generates the attribute "reply to own article"
            now checks the Message-IDs too (to avoid errors if the parent
            article is missing in the hierarchy)
           Bugfix: Header parser and MIME parser fixed to correctly handle
            MIME entity delimiters (for boundary strings that contain spaces)
           Bugfix: Removed Unicode range U+E0020 ... U+E007E from rejected
            control characters (deprecated since Unicode 5.1, reintroduced for
            different purpose since Unicode 9.0) (Reported by Marcel Logen)
           TLS: Protocol version TLSv1.3 according to RFC8446 is now supported
            (requires at least OpenSSL 1.1.1)
           CORE module now supports multiple article hierarchies
           Unicode database updated to version 11.0.0
           IBM852 to UTF-8 converter added
           If the OS doesn't report IPv6 as available, usage can now be forced
            with the option 'CFG_FORCE_IP6'
           Support for reproducible builds added (option 'CFG_REPRODUCIBLE')
           Some checks for system header files removed to speed up configuration
            (Build fails in any case if they are missing)
           Documentation updated

0.15       Bugfix: The Cancel-Lock was not generated with the correct Message-ID
            (since 0.14 for every posting attempt a new Message-ID is created)
           Bugfix: Unicode Canonical Composition Algorithm fixed for Hangul
            syllables (that can be represented only in decomposed form)
           Bugfix: MIME quoted-printable decoder now ignores whitespace at EOL
           Bugfix: Filenames are now generated according to the locale category
            'LC_CTYPE'
           Bugfix: NULL pointer dereference (if Message-ID generation failed)
            fixed
           Bugfix: ISO 8859-13 decoder fixed (Codepoints 0xAB to 0xAE are now
            mapped to the Unicode codepoints U+00AB to U+00AE)
           Bugfix: Character set IBM858 is now recognized as "IBM00858" too
            (its official name in the IANA registry for MIME character sets)
           Bugfix: Some of the IANA registered character set alias names were
            not accepted
           Bugfix: Removed C99 syntax from C code. Now C90 as documented
            (Reported by Dennis Preiser)
           Bugfix: Cancel control messages now use the original newsgroup list
            (Recommended by RFC5537, Section 5.3)
           Cancel control messages are no longer created with original Subject
            header field as default
           Cancel-Lock support now compliant to RFC8315 (default scheme SHA256
            uses a secret from a separate file, the old system with scheme SHA1
            and secret in configfile is still available)
           TLS: Extension "server_name" (SNI) according to RFC6066 and RFC8143
            is now supported
           Signature file can now be specified with the 'signature_file' entry
            in configfile (defaults to "~/.signature")
           NNTP: The network socket is now configured to 15s timeout (if the
            operating system supports that)
           The configfile entry "domain" is now checked to be a valid dot-atom
            according to RFC5322 (Suggested by Emil Schuster)
           New 64x64 pixmap for X11 window icon (Contributed by Stefan Claas)
           Unicode database updated to version 10.0.0
           Invalid UTF-8 encoding is now repaired for better error tolerance
           Unassigned codepoints of 8 bit character sets and rejected (ignored)
            control characters are now replaced with Unicode codepoint U+FFFD
            "REPLACEMENT CHARACTER"
           Windows codepages are now accepted with IBM names (CPxxxx) too for
            better error tolerance
           IBM775 to UTF-8 converter added
           Windows-1253 to UTF-8 converter added
           Windows-1254 to UTF-8 converter added
           Windows-1255 to UTF-8 converter added
           Windows-1257 to UTF-8 converter added
           Windows-1258 to UTF-8 converter added
           KOI8-U to UTF-8 converter added
           If FLTK 1.3.1 or higher ABI is available, the Enter key is now
            accepted to select an article from the tree/list
           If FLTK 1.3.3 or higher ABI is available, the method 'calc_tree()' is
            used for calculation of new size (instead of the ugly workaround
            that includes scrolling to the top that is required for FLTK 1.3.0)
           If FLTK 1.3.3 or higher ABI is available, the 'next_visible_item()'
            method is used to ensure that article tree/list doesn't lose focus
            if down (cursor) key is pressed on last item
           If FLTK 1.3.3 or higher ABI is available, window icon is set on X11
            (no longer an experimental feature)
           Article post processor pathname is printed to stdout in debug mode
           External editor name/pathname is printed to stdout in debug mode
           Experimental feature 'CORE_DATETIME_WITH_TZ_NAME' replaced by entry
            'timestamp_comment' in configfile (default value unchanged)
           Usage of local time for Date header field can now be disabled in GUI
            (default is local time as recommended by RFC5322)
           OpenBSD added to list of supported OS (Tested by Marcel Logen)

0.14       Bugfix: Score rule type "group" can now be used with NNTP servers
            that provide OVER capability. This is limited to the current group
            in the case of Xposts (Reported by Frank Graf)
           Bugfix: Header parser now supports RFC2231 parameter sections
           Bugfix: Windows-1250 decoder fixed (Codepoint 0x9F is now mapped to
            the Unicode codepoint U+017A)
           Bugfix: Windows-1251 decoder was broken beyond codepoint 0x8F
           Bugfix: UTF-7 decoder now accepts unterminated shift sequences at the
            end of input data
           Bugfix: UTF-7 decoder now decodes shift sequences with context (allow
            combining character sequences with codepoints outside of the shift
            sequence)
           Bugfix: Potential NULL pointer dereference fixed in UTF-8 to ISO8859
            converter (Reported by Dennis Preiser)
           Bugfix: Potential NULL pointer dereference fixed in TLS check for
            root certificate (Reported by Dennis Preiser)
           Bugfix: 2 memory leaks fixed in TLS CRL handling (Reported by Dennis
            Preiser)
           Bugifx: Potential NULL pointer dereference fixed in TLS module
           Bugifx: Potential NULL pointer dereference fixed in MIME word encoder
           Bugfix: Potential memory leak fixed in group handling
           Bugfix: Script 'mkconfig' should now be more POSIX compliant (Thanks
            to Joerg Schilling for his help)
           Bugfix: MIME decoder now supports nested multipart entities
           Bugfix: MIME decoder now use correct default for missing content type
           Bugfix: Timestamp parser now accepts CFWS in 'obs-hour', 'obs-minute'
            and 'obs-second' tokens
           Bugfix: FILTER module considered two empty strings as equal in
            function that detects own articles (should be not equal there)
           Bugfix: Format "flowed" decoder no longer append additional line
            breaks to the end of paragraphs after overlong words
           IPv6 is now supported (can be disabled with option 'CFG_IP6_DISABLE')
           TLS module can now use OpenSSL 1.1.x
           TLS module (in strong encryption mode) now creates a randomart image
            from the RSA key of the server using the "drunken bishop" algorithm
           Unicode database updated to version 9.0.0
           Unicode canonical composition engine is now able to compose starter
            pairs and hangul syllables. It should now be fully Unicode compliant
           Test program for Unicode now executes the official Unicode
            conformance test for NFC normalization
           Tooltip messages can now be disabled with the "-notooltips" command
            line switch
           Distribution suggestions (NNTP command LIST DISTRIB.PATS) can now be
            used with the 'dist_suggestions' entry in configfile (set to a non-
            zero value).
           Path for man page can now be configured with option 'CFG_MAN_PATH'
           Support for system menubar on Darwin with Cocoa is now an official
            option (can be enabled with 'USE_COCOA_SYS_MENUBAR' in "gui.cxx")
           Scoring system extended. A filter rule can now be bound to a group
            or group wildmat (Suggested by Frank Graf)
           Usage of NNTP overview (OVER capability) can now be disabled with the
            'nntp_no_over' entry in configfile (set to a nonzero value). This
            allows scoring rules to match on all groups of Xposts (otherwise
            only the current group is used for matching)
           Error tolerance of header parser improved
           Source viewer now shows all characters that are not "printable ASCII"
            as colored hexadecimal numbers
           Unsupported URI options from RFC5538 (like "news" scheme with server)
            are now detected and rejected
           Menu entry in GUI for debug mode added (more information on stderr)
           New Message-ID is generated after every failed posting attempt
           Header field "Organization" is now parsed and displayed in GUI
           NNTP compression negotiation can now be enabled/disabled in GUI
           Environment variable 'TMPDIR' is now used as recommended by POSIX
           Error tolerance of conversion from canonical to local format improved
           URI encoder of Composer now use (for the "http" scheme) percent
            encoding for all characters that are not slash or defined
            'unreserved' by RFC3986
           Format "flowed" decoder now support SHY as rewrapping point
           CSS patch for documentation style sheets added (recent versions of
            doxygen create wrong parameters)
           Windows-1256 to UTF-8 converter added
           IBM850 to UTF-8 converter added
           IBM858 to UTF-8 converter added

0.13       Security bugfix: MIME: Buffer overflow in encoded-word decoder fixed
           Security bugfix: Buffer overflow in overview parser fixed (with NNTP
            V1 protocol according to RFC977 there was no vulnerability)
           Bugfix: Off by one buffer size mismatch in postprocessor fixed
           Bugfix: Off by one buffer size mismatch in POSIX to canonical form
            converter fixed
           Bugfix: MIME: encoded-word decoder now correctly process RFC2231
            compliant 'language' tokens
           Bugfix: MIME: encoded-word encoder potential error with optional long
            ASCII line mode fixed (no problem with the default configuration)
           Bugfix: Header parser: Handling of 'encoded-word' tokens fixed
           Bugfix: Header parser: Handling of 'quoted-pair' in 'quoted-string'
            fixed
           Bugfix: MIME: Unknown "Content-Transfer-Encoding" is now handled as
            defined by RFC2045 even if no "Content-Type" header field is present
           Bugfix: POSIX: 'posix_strftime()' is now available without X/Open
            XSI extension if at least POSIX.1-2001 is available
           Bugfix: ISO8859-14 decoder fixed (Codepoint 0xFC is now mapped to the
            Unicode codepoint U+00FC)
           Bugfix: Core thread can now be canceled even if nexus handler is busy
            (this should avoid freezing while joining the core thread on exit)
           Bugfix: In unstructured header fields only the first leading space is
            removed
           Bugfix: GUI progress bar is now refreshed at "100%" and then set to
            "Busy"
           TLS module can now use LibreSSL (Build system modified)
           CMPR module for compression added
           Support for DEFLATE algorithm added (requires 'zlib' to work)
           NNTP module now supports the extension COMPRESS (according to draft)
           GUI can now show message of the day (if provided by server)
           Spaces (U+0020) are now allowed for the "Keywords" header field.

0.12       Security bugfix: Buffer overflow error in header parser fixed
           Following a recommendation of RFC5322, the "Date" header field is
            now created using local time
           For better compatibility the "Date" and (if created) "Injection-Date"
            header fields are now created with the optional 'day-of-week' token
            defined by RFC5322 (it was reported that the newsreader "PhoNews"
            doesn't work correctly if it's omitted)

0.11       Bugfix: If the last viewed article of a group is not present (e.g.
            hidden if "Only unread articles" option is active), the article
            window was not cleared and showed the last article viewed from the
            former group (Reported by Dennis Preiser)
           Bugfix: NFC normalization was applied to Unicode data in the header
            only when conversion to ISO8859 was possible, but not when the data
            was used in MIME encoded-words as UTF-8.
           Bugfix: TLS certificate check now accept subject names with wildcard
            as left-most component
           Bugfix: TLS certificate check now matches subject names (domain names
            in our case) case-insensitive
           Bugfix: If the system reports the hostname with domains, the
            generation of Message-IDs don't work as intended. Now only the
            left-most part of the hostname is used (Reported by Dennis Preiser)
           Bugfix: MIME RFC3676 decoder now calculates the line length using
            glyphs instead of bytes while rewrapping paragraphs
           Bugfix: If the identity configuration contain no names (only e-mail
            addresses) the header encoder created a space for each missing name.
            The syntax was nevertheless valid, but not as intended (Reported by
            Dennis Preiser)
           Bugfix: With empty article tree/list, clicking on "No articles" has
            triggered a fatal error that terminated the program
           Bugfix: 5 potential NULL pointer dereferences fixed in UI (Reported
            by Dennis Preiser)
           Bugfix: Invalid end of line check in header field search engine of UI
            (Reported by Dennis Preiser)
           Bugfix: Potential double free error fixed in scorefile handling
            (Reported by Dennis Preiser)
           Bugfix: Memory leak in score handling (Reported by Dennis Preiser)
           Bugfix: Potential double free error in group handling of core module
            (Reported by Dennis Preiser)
           Bugfix: Potential use after free errors in handlers for 'Newsgroups'
            and 'References' header fields (Reported by Dennis Preiser)
           Bugfix: Potential use after free error in date function of core
            module (Reported by Dennis Preiser)
           Bugfix: Potential use after free error in line buffer used for
            configuration data processing (Reported by Dennis Preiser)
           Bugfix: Potential memory leak in NNTP multiline response handling
            (Reported by Dennis Preiser)
           Bugfix: Potential NULL pointer dereference and memory leaks fixed
            in core module function for article posting
           Bugfix: Possible deadlock in postprocessor pipe I/O fixed
           OpenSSL version is now displayed correctly up to patch level "zzy"
           TLS certificate check now first matches hostname against the
            "subjectAltName" extension entries (if present)
           Quoting style can now be configured with the 'quote_style' entry in
            configfile
           Unification of quoting style can now be disabled with the
            'quote_unify' entry in configfile
           Config option for quoting style in GUI added
           NNTP driver now use immediate authentication as the default
           Test program for Unicode: UTF-7 test extended with surrogate pairs
           Test program for POSIX: Test for 'strcasecmp_l()' added
           If there is no 'display-name', use 'addr-spec' for article tree/list
            and introduction line
           Build system now check for POSIX.2 C-language binding to be available
           Scoring can now use POSIX extended regular expression matching (if
            POSIX.2 C-language binding is available)
           Test program for POSIX: Test for 'regcomp()' and 'regexec()' added
           Scoring system extended (can now filter on Subject, Message-ID and
            Newsgroups too)
           A POSIX extended regular expression for test group matching can now
            be configured with the 'testgrp_ere' entry in configfile
           A list of keywords that are automatically set for articles posted to
            test groups can now be configured with the 'testgrp_kwords' entry in
            configfile
           Reply prefix check now also detect and repair "re:" and "re: "
           Unicode database updated to version 8.0.0
           Header parser now extract content from "Distribution" header field
           Followup to newsgroup now adopt the distribution from former article
           GUI now displays the "Distribution" header field if present
           GUI now always sort articles by date for threaded view
           GUI can now sort articles with inverted order on request
           GUI can now sort articles by number for unthreaded view on request
           Build system now check compilers for C90/C++98 conformance
           Handler for file download added (HTTP/1.1 is supported)
           TLS certificate chain check now check the modulus size of RSA keys in
            strong encryption mode (keys with less than 1024 bits are rejected)
           TLS certificate chain check now check the signature algorithm in
            strong encryption mode (MD2, MD4 and MD5 based signatures are
            rejected)
           Experimental option to reject any DH parameter size below 1024 bits
            in strong encryption mode (requires at least OpenSSL 1.0.2)
           Experimental option to specify the signature algorithms for the
            TLSv1.2 "signature_algorithms" extension defined in RFC5246
            (requires at least OpenSSL 1.0.2)
           Experimental support for checking the whole certificate chain for
            revoked elements with TLS connections. CRLs are downloaded and
            maintained automatically (the GUI shows a popup window that allows
            the user to suppress CRL updates for the current session)
           Experimental support for displaying article number in tree/list

0.10       Bugfix: The Cancel-Key was not generated with the configured secret
           Bugfix: Header field "Date" now contains the correct value according
            to RFC5536/5322 (the date when the "Send" button was pressed)
           Bugfix: Replacement of header fields in composer failed if the body
            was already folded (only first line was deleted in this case)
           Bugfix: Check whether nodes are already present before adding them to
            subscribe window (Thanks to Dennis Preiser for his help)
           Bugfix: Don't strip "(was: ...)" from subject for cancel/supersede
           Bugfix: If FLTK library is compiled without multithreading support,
            a segfault occur instead of an immediate clean exit (Reported by
            Hartmut Figge)
           Bugfix: If NNTP V2 capability OVER is available, missing articles in
            overview were not automatically marked as read (Reported by Dennis
            Preiser)
           Bugfix: The threads must synchronize their calls to POSIX functions
            that are not thread-safe (because FLTK use some of them internally)
           Automatic mail redirection for bug reports if possible
           Percent encoder for generation of simple URIs added
           Subscription option for URIs with scheme "news" that represent group
           Support for external article postprocessor added
           Compile time options are now printed with "flnews -v"
           Configuration check and POSIX module support for IPv6 added (Thanks
            to Dennis Preiser for his help to find and fix bugs that were
            introduced with the new code)
           Strong cipher suite list no longer contain DSA authentication
           Support for article composition with external editor added
           Own articles are now marked with icon in article tree/list
           Replies to own articles are now marked with icon in article tree/list
           Entry "Mark all as read" in article menu was misleading. Renamed to
            "Mark all in group as read" (Reported by Marcel Logen)
           Scoring support added
           Use 'open' instead of 'xdg-open' on Darwin (Patch from Dennis
            Preiser)
           Experimental support for system menubar on Darwin with Cocoa (Patch
            from Dennis Preiser)
           Experimental support for displaying line count of articles in article
            tree/list
           Experimental support for custom fontsize in some GUI widgets
           Experimental support for window icon (requires at least FLTK 1.3.3)

0.9        Security bugfix: Buffer overflow error in ISO2022 decoder fixed
           Security bugfix: Use after free error in hierarchy manager fixed
           Security bugfix: Dereference of uninitialized pointer in UI fixed
           Bugfix: Memory leak in NNTP driver error handling fixed
           Bugfix: Memory leak in group handling fixed
           Bugfix: Multiple memory leaks in UI text buffer handling fixed
           Bugfix: If a connection was closed by the server (e.g. after timeout)
            there was a state that called 'recv()' in an infinite loop creating
            100% CPU load for the core thread. This condition is now processed
            correctly (re-establish the connection and retry)
           Bugfix: Error handling fixed after hierarchy manager failure
           Bugfix: Hyperlink detection should now be more RFC3986 compliant
            (line breaks inside URIs are still not supported and Unicode white-
            space is not accepted as delimiter)
           Bugfix: Character set of signature is now checked
           Bugfix: Article source is now stored to file in canonical form (raw)
           Bugfix: The TLS protocol version of encrypted connections is now
            correctly reported on stdout and logfile
           Bugfix: Cancel/Supersede now works without self generated Message-ID
           Bugfix: Superseding an article with Fup2 no longer execute it
           Bugfix: RFC850 address format now works in "Reply-To" field too
           Bugfix: The display name of the identity information is now correctly
            encoded using atom, quoted-string and encoded-word tokens
           Bugfix: RFC3676 decoder no longer ignores last line if the CR+LF
            termination is missing
           Bugfix: Header parser bug fixed (quoted-pair inside quoted-string)
           Bugfix: Header parser bug fixed (Sequence "\\)" inside comment)
           Header parser can now handle whitespace and comments inside mailbox
            tokens
           Header parser can now handle mailbox-list and address-list tokens
            (but in both cases only the first address is extracted and used)
           Error tolerance of header parser (against stray CR) improved
           Build system now add required system libraries to 'LIBS' (dumb
            algorithm: fixed list for every operating system)
           IBM437 to UTF-8 converter added
           UTF-7 to UTF-8 converter added
           Test program for Unicode: UTF-7 test added
           Article view can now be switched to wrapping mode
           Article printing support added
           Reply by e-mail support added (requires 'xdg-utils' to work)
           "Followup-To: poster" support added (requires 'xdg-utils' to work)
           Hyperlink handling added (some URI types require 'xdg-utils' to work)
           Limited the "creeping window" workaround offset correction to 20pt
           If signature contains no separator it is now automatically inserted
           If signature length exceeds 4 lines, a warning message is generated
           Compliance to mandatory GNKSA 2.0 rules (with exception of part 4)
           Support for generation of Cancel-Lock/Cancel-Key header fields added
           Injection-Date header field now contain timestamp of POST command
           Documentation for some configfile entries added to man page
           Content for Organization header field is now normalized before MIME
            (RFC2047) encoding
           Group tree with candidates for subscription is now sorted

0.8        Bugfix: Service name "nntps" is no longer truncated to "nntp" in
            protocol console and logfile
           Bugfix: Header parser of article compositor fixed
           Bugfix: "Mark all articles as read" now handles canceled articles too
           Bugfix: "\n-- " (without trailing newline) no longer matches as the
            signature separator in article composer
           Bugfix: A new signature is appended to superseded articles now
           Bugfix: No longer display "Cannot open file" error if "~./.signature"
            file is not present (Reported by Marcel Logen)
           Bugfix: OpenSSL vulnerability checks fixed for shared library
           TLS security vulnerability warnings can now be disabled at build time
            by setting the config option 'CFG_TLS_WARNING_DISABLE' to nonzero
           Option for ephemeral password (not stored in configfile) added
           Immediate authentication can now be requested with 'immedauth' entry
            in configfile
           Introduction format is now taken from 'intro' entry in configfile
           German localization improved (Thanks to Marcel Logen for his help)
           Organization header field is now set according to 'organization'
            entry in configfile
           Script 'configure' renamed to 'mkconfig' to prevent confusion with
            GNU autoconf
           Build system support for 'PREFIX' environment variable added
           Build system support for 'DESTDIR' environment variable to 'install'
            and 'uninstall' rules added (Suggested by Sven Hartge)
           Build system support for 'LIBS' environment variable added
           Branches without unread articles in article tree can now be hidden
           Unicode database updated to version 7.0.0
           Workaround for broken handling of Unicode ZERO WIDTH SPACE added
            (likely a bug in FLTK)
           ISO2022-JP to UTF-8 converter added
           NNTP driver now supports the OVER command
           Article header overview support added to core and UI modules
           Hyperlink detection code added (currently used only for highlighting)

0.7        Bugfix: RFC3676 decoder now calculates quotations marks to line width
           Bugfix: Unicode canonical reordering engine had produced invalid data
           Bugfix: Unicode canonical composition engine had produced invalid
            data for recursive compositions (with characters that consists of
            more than 2 codepoints)
           Bugfix: Quoted-printable encoder for MIME encoded-words had split
            atomic byte sequences for codepoints when UTF-8 encoding was used
           Bugfix: Quoted-printable encoder for MIME encoded-words had split
            Unicode codepoint sequences (Starter to next Starter)
           Bugfix: Two memory leaks in database module fixed
           Workaround for POSIX.2 check on IRIX added to configure script
           Build system modified for MIPSpro compiler
           Rename 'sa_len' in 'nntp.c' because IRIX use it in 'sys/socket.h'
            (Patch from Ingo Paschke)
           Print warning if TLS module detects an OpenSSL library containing
            potential security vulnerabilities.
           Build system now check whether FLTK header files are installed
           Build system now check whether OpenSSL header files are installed
           Build system now creates a logfile ("config.log")
           Line feeds in decoded header field bodies are replaced with '?'
           Function "Skip to next unread article" (without scroll down) added
           Function "Skip to next group with unread messages" added
           Threading of orphaned branches (by reference) improved
           Article composition editor line length highlighting added
           Support for Xpost added
           Support for Fup2 added
           Support for "Archive" header field added
           Support for "Expires" header field added
           Support for "Keywords" header field added
           Support for "Distribution" header field (RFC5537) added
           Header parser can now repair field bodies with invalid encoding
            (improved error tolerance, formerly they were rejected completely)
           Test program for Unicode decoder and normalization engine added to
            'make test' rule
           Support for superseding own articles added
           Support for canceling own articles added
           Mac Roman character set is now also accepted under some alias names

0.6        Bugfix: Reject "Followup-To: poster" (currently not supported)
           Bugfix: If we create own "Message-ID" and "Date" header-fields, an
            "Injection-Date" header field is created too (RFC5536, RFC5537)
           Bugfix: References are now correctly trimmed according to RFC5537
           Bugfix: Object file with thread-safe functions missing in test binary
           Bugfix: Header field content containing MIME encoded-word delimiters
            is now encoded in RFC2047 compliant way
           Bugfix: One byte was lost when MIME encoded-words must be splitted
            because of overlength
           Bugfix: Expect "TIS-620" declaration for ISO8859-11 character set
           Bugfix: Focus is now always set to article tree after group selection
           Bugfix: Article tree redraw/scroll fixed. It is now faster and more
            reliable (Thanks to Greg Ercolano for his help)
           Double buffering support to reduce flickering of Fl_Tree widget (can
            be disabled in configfile for better performance on slow machines)
           Sharing newsrc groupstate file with other newsreaders is now possible
            (Pathname is taken from 'newsrc' entry in configfile)
           MIME base64 encoder added
           New algorithm A1 for Message-ID creation (Message-IDs are created
            only if a domain is specified with the 'domain' entry in configfile)
           Header parser can now extract name from RFC850 compliant "From"
            header field even if name is inside a comment at the end
           Lower refresh rate of progress bar to reduce CPU load
           Searching for next unread article: If no newer unread article is
            found, wrap to oldest article once and continue searching
           ROT13 encoder/decoder added
           Article tree can now be switched to unthreaded view
           RFC3676 decoder now tolerates broken line breaks

0.5        Bugfix: Mark single article unread with group but no article selected
            have crashed the program
           Bugfix: Server configuration window no longer waste CPU time
           Bugfix: Subscription of existing groups that are not leaf nodes in
            hierarchy is now possible
           The group subscription tree now shows selectable items with bold font
           Support for RFC3676 MIME extension added
           Support for simple syntax highlighting in article content added
           Menu entry to save cooked article to file added
           Unicode NFC normalization engine added
           ISO8859-3 to UTF-8 converter added
           ISO8859-4 to UTF-8 converter added
           ISO8859-5 to UTF-8 converter added
           ISO8859-6 to UTF-8 converter added
           ISO8859-7 to UTF-8 converter added
           ISO8859-8 to UTF-8 converter added
           ISO8859-9 to UTF-8 converter added
           ISO8859-10 to UTF-8 converter added
           ISO8859-11 to UTF-8 converter added
           ISO8859-13 to UTF-8 converter added
           ISO8859-14 to UTF-8 converter added
           ISO8859-16 to UTF-8 converter added
           KOI8-R to UTF-8 converter added
           Windows-1251 to UTF-8 converter added
           Article window now shows "Message-ID" header field
           UTF-8 to ISO8859-1 converter added
           MIME encoded-word encoder added
           Support for article posting added

0.4        Bugfix: NLS: Don't use strings from NLS catalog as format strings
            anymore (Reported by Hanno Foest)
            This was a potential security vulnerability that can be exploited if
            NLS support is enabled and the program was not installed by root
           Bugfix: TIMING: 'time_msleep()' now handle remaining time correctly
            if it was interrupted by a signal
           Bugfix: NNTP: Removal of dot-stuffing was broken
           Bugfix: NNTP: Empty multiline responses are now handled correctly
           Bugfix: UI: MIME content of type "text" with unsupported subtype but
            supported character set is now displayed raw as required by RFC2049
           Bugfix: NNTP: If connection failed, don't try to send QUIT command
           Bugfix: CONF: The line length check of the parser was wrong
           Bugfix: POSIX: 'posix_snprintf()' failed with zero integer conversion
           Support for RFC2184 compliant MIME encoded-words in article header
           If content decoding failed, at least the decoded header is shown
           Support for MIME "multipart/mixed" content added
           Support for MIME "multipart/alternative" content added
           Support for NNTPS protocol (NNTP via TLS using dedicated port) added
           Support for RFC4643 compliant AUTHINFO USER authentication added
           Menu entry to change article count clamping threshold added

0.3        Bugfix: configfile and groupfile are now created again if not present
           Bugfix: Subscription now works again with empty group file
           Bugfix: Group list refresh after server change works again
           Bugfix: "Mark all as read" crashed if there was no current group
           Bugfix: 'ui_exit()' must shutdown core before destroying main window
           Bugfix: 'db_read()' may call 'close()' with invalid filedescriptor
           Bugfix: Potential NULL pointer dereference in 'My_Tree' widget fixed
           Bugfix: Data from 'posix_getenv()' is now processed with locked mutex
           Bugfix: Potential buffer overflow in 'SubscribeWindow' object fixed
           Bugfix: Resubscription added group again instead of recovering state
           Article selection via 'Enter' key removed (don't work on FLTK 1.3.0)
           Header cache is now maintained by deleting no longer required data
           Article count for GUI is now clamped to the latest 250 per group
           Menu entry to alphabetically sort group list added
           Menu entry to unsubscribe group added
           Menu entry to mark single article as unread added
           Delimiter line between header fields and article body added
           Superseded articles are now marked in GUI (but not hidden)
           Raw article source code can now be saved to file from viewer

0.2        Bugfix: Canceled articles are no longer counted as unread
           Bugfix: The core module now recovers from disconnected server
           Bugfix: Current article is now cleared if current group was changed
           Bugfix: Matching of group names with same prefix in groupfile fixed
           Bugfix: State machine replaced that lock UI operations against each
            other that are not allowed to run simultaneously
           Local article header cache added (to speed up group selection)
           Don't parse the "Path" header field anymore (because it is not used)
           Decoder for 'Newsgroups' header field added
           Decoded content of some header fields is now displayed in GUI
           Last viewed article is now stored per group and displayed at reenter
           Article source code viewer added
           The NNTP driver now send a QUIT command before closing a connection
           Orphaned (by reference) thread branches are merged by decoded subject
           Main window tiling is now saved in configfile and restored on startup

0.1        Bugfix: Invalid memory access fixed when started without configfile
           Bugfix: NNTP V2 protocol: LIST capability is now detected correctly
           Bugfix: 'main.cxx' must include 'cstring'
           Bugfix: Subscribed groups not available on server are now shown empty
           Bugfix: Changing server now correctly resets group states
           Bugfix: Current group is now correctly restored after group refresh
           DNS hostname resolver added
           RFC5536 compliant timestamp decoder added
           The 'posix_snprintf()' implementation now support field width padding
           The article tree now shows the posting date of the articles
           Pressing 'Space' key in article tree now scrolls down article
            content. On the end of content the next unread article is selected
           Pressing 'Enter' key in article tree now selects this article
           Mark all read menu entry added

0.0        POSIX based build system added (that don't require GNU tools)
           POSIX based operating system API wrapper added
           ASCII validity checking function added
           NNTP protocol (RFC977, RFC3977) driver added
           Server communication log file added
           Newsreader core added
           FLTK based GUI added
           NLS support added
           Handling for configfile added
           Group state handling added (using '.newsrc' style file)
           Article hierarchy manager added
           Reading support added
           ISO8859-1 to UTF-8 converter added
           ISO8859-2 to UTF-8 converter added
           ISO8859-15 to UTF-8 converter added
           Windows-1250 to UTF-8 converter added
           Windows-1252 to UTF-8 converter added
           Mac-Roman to UTF-8 converter added
           MIME quoted printable decoder added
           MIME base64 decoder added
           MIME encoded-word decoder added
           Unicode UTF-8 validity checking added


EOF
