#ifndef MAIN_H
#define MAIN_H  1


/* ========================================================================== */
/* Include files */

#include <time.h>


/*! \addtogroup MAIN */
/*! @{ */


/* ========================================================================== */
/* Macros */

/*! \brief Prepend module prefix and print error message */
#define PRINT_ERROR(s)  print_error(MAIN_ERR_PREFIX s)


/*! @} */


/* ========================================================================== */
/* Variables */

extern int  main_debug;
extern const char*  main_confprefix;


/* ========================================================================== */
/* Function prototypes */

void  print_error(const char*);
void  ts_environ_init(void);
void  ts_environ_exit(void);
int  ts_getenv(const char*, const char**);
int  ts_lock_ui(void);
int  ts_unlock_ui(void);


#endif  /* MAIN_H */

/* EOF */
