#ifndef TLS_H
#define TLS_H  1


/* ========================================================================== */
/* Include files */

#include "config.h"


#if CFG_USE_TLS


/* ========================================================================== */
/* Function prototypes */

int  tls_init(void);
void  tls_exit(void);
int  tls_vulnerability_check(int);
int  tls_crl_update_check(void);
void  tls_crl_update_control(int);
const char*  tls_sni(const char*);
int  tls_open(int, void**, int, const char*);
int  tls_close(void**);
int  tls_get_ciphersuite(void**, const char**, const char**, const char**);
int  tls_cert_verify(void**, void**, const char*, int);
int  tls_cert_get_string(void*, const char**);
api_posix_ssize_t  tls_send(void*, const void*, size_t);
api_posix_ssize_t  tls_recv(void*, void*, size_t, int);
void  tls_free(void*);


#endif  /* CFG_USE_TLS */


#endif  /* TLS_H */

/* EOF */
