# ==============================================================================
# Create table with NLS string to catalog number mapping
#
# Copyright (c) 2012-2013 by the developers. See the LICENSE file for details.


# ==============================================================================
# Init

BEGIN \
{
   n = 0
   limit = ENVIRON["NLS_MSGMAX"]
}


# ==============================================================================
# Ignore comments starting with "$ "

/^\$[ ]/  { }


# ==============================================================================
# Ignore empty lines

/^$/  { }


# ==============================================================================
# Delete duplicate strings

{
   rv = match($0, /^".*"/)
   if (1 == rv)
   {
      # Count strings
      ++n
      # Force awk to use 'limit' as numerical value
      if (0 + limit < n)
      {
         system("printf \"Error: Too many NLS strings!\\n\" >&2") 
         exit(1)
      }
      # Print anything that is not a duplicate of the requested string
      s = substr($0, RSTART, RLENGTH)
      printf("%s %d\n", s, n)
   }
   next
}


# EOF
