/* ========================================================================== */
/* Pixmaps for GUI
 *
 * Copyright (c) 2012-2017 by the developers. See the LICENSE file for details.
 *
 * Every pixmap definition in this file should conform to the XPM specification:
 * https://ftp.gwdg.de/pub/x11/x.org/contrib/libraries/xpm-doc-A4.PS.gz
 * Therefore we don't follow the sourcecode style rules (that are used for the
 * rest of the project) here!
 *
 * The sections are marked with horizontal lines. Ripping out the content of
 * such a section should result in a standard conformant XPM version 3 image.
 * Exception:
 * Because modern C++ compilers complain when string literals are not declared
 * 'const', we use the correct data type here even this is not strictly XPM
 * standard conformant.
 */


#if USE_WINDOW_ICON
/* Icon for window */
/* -------------------------------------------------------------------------- */
/* XPM */
static const char* xpm_window_icon[] = {
"64 64 4 1",
". c #E0F0F0",
"+ c #CFCFCF",
"x c #A4A4A4",
"* c #000000",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"........++++++..++++............................................",
".......+******..***.............................................",
".......***xxx+.x**x.............................................",
"......x**x.....***..............................................",
"......***+....x**x..............................................",
".....x**x.....***...............................................",
"...++***x+...x**x.++++++++....+++++++....++++.....+++..+++++++..",
"..x******x..+***..********+..x*******x...***+....x**x.x*******x.",
"..xx***xx...x**+.x**xxxx**x..***xxx***+.x**x.++.+***..***xxxxxx.",
"...x**x....+***..***...x**x.x**x..+***..***..x+.x**x.x**x.......",
"...***.....x**+.x**x..+***..***+..xxx+.x**x+x*xx***..xxx+..++x..",
"..x**x....+***..***...x**+.x**x........***********x.......+***..",
"..***.....x**+.x**x..+**x..***x+++++..x***xxxx****..++++++x**+..",
".x**x....+***..***...x**+..x********..+***...x***+..x********...",
".xxx.....+xx+.+xx+...xxx...+xxxxxxx+...xx+..+xxxx...+xxxxxxx+...",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................",
"................................................................"
};
/* -------------------------------------------------------------------------- */
#endif  // USE_WINDOW_ICON


/* Marker for own articles */
/* -------------------------------------------------------------------------- */
/* XPM */
static const char* xpm_own[] = {
"11 11 3 1",
". c None",
"* c #FF0000",
"+ c #808080",
"...........",
"....+*+....",
"..+*****+..",
"..*******..",
".+*******+.",
".*********.",
".+*******+.",
"..*******..",
"..+*****+..",
"....+*+....",
"..........."
};
/* -------------------------------------------------------------------------- */


/* Marker for replies to own articles */
/* -------------------------------------------------------------------------- */
/* XPM */
static const char* xpm_reply_to_own[] = {
"11 11 3 1",
". c None",
"* c #EEDD00",
"+ c #908000",
"...........",
"....+*+....",
"..+*****+..",
"..*******..",
".+*******+.",
".*********.",
".+*******+.",
"..*******..",
"..+*****+..",
"....+*+....",
"..........."
};
/* -------------------------------------------------------------------------- */


/* Marker for articles with positive score */
/* -------------------------------------------------------------------------- */
/* XPM */
static const char* xpm_score_up[] = {
"11 11 2 1",
". c None",
"* c #00DD00",
"...........",
"....***....",
"....***....",
"....***....",
".*********.",
".*********.",
".*********.",
"....***....",
"....***....",
"....***....",
"...........",
};
/* -------------------------------------------------------------------------- */


/* Marker for articles with negative score */
/* -------------------------------------------------------------------------- */
/* XPM */
static const char* xpm_score_down[] = {
"11 11 2 1",
". c None",
"* c #000000",
"...........",
".**.....**.",
".***...***.",
"..***.***..",
"...*****...",
"....***....",
"...*****...",
"..***.***..",
".***...***.",
".**.....**.",
"...........",
};
/* -------------------------------------------------------------------------- */


/* EOF */
