/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef BXX0_BASEXX_VERS_H
#define BXX0_BASEXX_VERS_H  1

#include <stddef.h>


/*! Library header for libbasexx release version
 *
 * \file      basexx_version.h
 * \author    Michael Bäuerle
 * \date      2024
 * \copyright BSD-2-Clause
 *
 * Public API (compatible between all versions with same major number).
 *
 * API documentation: \ref BASEXX_VERSION
 */


/*! \mainpage Documentation
 *
 * \verbinclude "README"
 */


/*! \defgroup BASEXX_VERSION Release version
 *
 * Release version of libbasexx library.
 */
/*! \{ */


/*! Get release version of library
 *
 * The release version is a constant string compiled into the library.
 * <br>
 * The content does not change at runtime and this function always
 * returns the same address.
 *
 * \return
 * Pointer to NUL-terminated string with format "MAJOR.MINOR.PATCH",
 * encoded with the execution character set.
 * <br>
 * A suffix may be appended at the end for snapshots and release candidates.
 */
const char *bxx0_version(void);


/*! \} */


#endif  /* BXX0_BASEXX_VERS_H */
