/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef JPIC0_I_ICONV_TABLE_NI_H
#define JPIC0_I_ICONV_TABLE_NI_H  1


/*
 * Header file for non-identical replacement mappings
 *
 * This file is used by the library and will not be installed.
 */


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/*
 * Unicode replacement codepoint for non-identical conversions
 *
 * Must be an UTF-8 octet-sequence for a single codepoint (max. 4 octets)
 * as NUL-terminated string.
 */
#define JPIC0_I_NONIDENT  "\xEF\xBF\xBD"  /* U+FFFD  REPLACEMENT CHARACTER */


/*! \endcond */


#pragma GCC visibility pop


#endif  /* JPIC0_I_ICONV_TABLE_NI_H */
