# ==============================================================================
# PMBS fragment for library
#
# SPDX-FileType: SOURCE
# SPDX-FileCopyrightText: Michael Bäuerle
# SPDX-License-Identifier: BSD-2-Clause

# Static library archive name
JPIC0_TARGET=$(PMBS_LIB_NAME).a

# Object files for library
# Attention: Old implementations of ar may truncate names to 15 characters
JPIC0_OBJS=iconv.o iconv_list.o iconv_table.o iconv_name.o iconv_version.o \
           rfc1468.o utf8.o

# Installation directories
JPIC0_INSTALL_DIRS=include/$(PMBS_LIB_NAME) lib $(PMBS_PKGCONFIGDIR) \
                   $(PMBS_MANPATH)/man3

# Clear suffix list for inference rules
.SUFFIXES:

.SUFFIXES: .c .o

# If nothing is specified, make will use the first rule
all: static

install: static
	($(PMBS_SH) -c 'for dir in $(JPIC0_INSTALL_DIRS) ; \
             do mkdir -p "$(DESTDIR)$(PMBS_PREFIX)/$$dir" ; done')
	($(PMBS_SH) ../tool/install -c -m 644 \
            ../include/$(PMBS_LIB_NAME)/iconv.h \
            "$(DESTDIR)$(PMBS_PREFIX)/include/$(PMBS_LIB_NAME)/iconv.h")
	($(PMBS_SH) ../tool/install -c -m 644 ./$(JPIC0_TARGET) \
            "$(DESTDIR)$(PMBS_PREFIX)/lib/$(JPIC0_TARGET)")
	($(PMBS_SH) ../tool/install -c -m 644 ./$(PMBS_LIB_NAME).pc \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_PKGCONFIGDIR)/$(PMBS_LIB_NAME).pc")
	($(PMBS_SH) ../tool/install -c -m 644 ./jpic0_iconvstr.3 \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_MANPATH)/man3/jpic0_iconvstr.3")
	($(PMBS_SH) ../tool/install -c -m 644 ./jpic0_print_codesets.3 \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_MANPATH)/man3/jpic0_print_codesets.3")

uninstall:
	-(command -p rm "$(DESTDIR)$(PMBS_PREFIX)/lib/$(JPIC0_TARGET)")
	-(command -p rm \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_PKGCONFIGDIR)/$(PMBS_LIB_NAME).pc")
	-(command -p rm \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_MANPATH)/man3/jpic0_iconvstr.3")
	-(command -p rm \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_MANPATH)/man3/jpic0_print_codesets.3")

# Build static library
static: $(JPIC0_TARGET) $(PMBS_LIB_NAME).pc \
        jpic0_iconvstr.3 jpic0_print_codesets.3

# Create static library
# POSIX requires the hyphen-minus in front of the options for the ar utility.
# Old BSD-based systems may not support this (set ARFLAGS to "rc" for them).
# Old SysV-based systems may not define the AR macro.
# Old BSD-based systems may need the help of ranlib to create a symbol table
# (errors for ranlib are ignored).
$(JPIC0_TARGET): $(JPIC0_OBJS)
	if test "x" != "x$(AR)" ; then ar_util=$(AR) ; else ar_util=ar ; fi ; \
            $$ar_util $(ARFLAGS) "$@" $(JPIC0_OBJS)
	-ranlib "$@"

# Release version
iconv_version.c: iconv_version.c.in
	sed -e 's,@release@,$(PMBS_RELEASE_VERSION),g' <$@.in >$@

# Mapping table
iconv_table.c: iso-2022-jp.txt iso-2022-jp_create.awk
	awk -f iso-2022-jp_create.awk iso-2022-jp.txt >$@

# Description for pkg-config
$(PMBS_LIB_NAME).pc: $(PMBS_LIB_NAME).pc.in
	sed -e 's,@prefix@,$(PMBS_PREFIX),g' \
            -e 's,@name@,$(PMBS_LIB_NAME),g' \
            -e 's,@release@,$(PMBS_RELEASE_VERSION),g' \
            <$@.in >$@

jpic0_iconvstr.3: jpic0_iconvstr.3.in
	sed -e 's,@package@,$(PMBS_LIB_NAME_BASE),g' \
            -e 's,@version@,$(PMBS_RELEASE_VERSION),g' \
            -e 's,@name@,jpic0_iconvstr,g' \
            <$@.in >$@

jpic0_print_codesets.3: jpic0_print_codesets.3.in
	sed -e 's,@package@,$(PMBS_LIB_NAME_BASE),g' \
            -e 's,@version@,$(PMBS_RELEASE_VERSION),g' \
            -e 's,@name@,jpic0_print_codesets,g' \
            <$@.in >$@

.c.o:
	$(CC) -I../include $(CPPFLAGS) $(CFLAGS) -c -o $@ $*.c
