/*
 * Supported encoding list functions
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include <stddef.h>
#include <stdio.h>

#include "libjpiconv-0/iconv.h"  /* Always include main header file first */
#include "libjpiconv-0/iconv_name.h"


/* ========================================================================== */
#if JPIC0_I_NAME_ENABLE_ALIASES
static void jpic0_i_print_alias(const jpic0_i_iso2022_jp *table)
{
    size_t i = 0;

    while (NULL != jpic0_i_name_src_alias[i].name)
    {
        if (jpic0_i_name_src_alias[i].table == table)
        {
            printf(" %s", jpic0_i_name_src_alias[i].name);
        }
        ++i;
    }
}
#endif  /* JPIC0_I_NAME_ENABLE_ALIASES */


/* ========================================================================== */
#if JPIC0_I_NAME_ENABLE_NONSTANDARD
static void jpic0_i_print_nonstd(const jpic0_i_iso2022_jp *table)
{
    size_t i = 0;

    while (NULL != jpic0_i_name_src_nonstd[i].name)
    {
        if (jpic0_i_name_src_nonstd[i].table == table)
        {
            printf(" %s", jpic0_i_name_src_nonstd[i].name);
        }
        ++i;
    }
}
#endif  /* JPIC0_I_NAME_ENABLE_NONSTANDARD */


/* ========================================================================== */
void jpic0_print_codesets(void)
{

    printf("Supported output encodings\n");
    printf("--------------------------\n");
    printf("UTF-8\n");

    printf("\nSupported input encodings\n");
    printf("-------------------------\n");
    {
        size_t i = 0;

        while (NULL != jpic0_i_name_src[i].name)
        {
            printf("%s", jpic0_i_name_src[i].name);
#if JPIC0_I_NAME_ENABLE_ALIASES
            jpic0_i_print_alias(jpic0_i_name_src[i].table);
#endif  /* JPIC0_I_NAME_ENABLE_ALIASES */
#if JPIC0_I_NAME_ENABLE_NONSTANDARD
            jpic0_i_print_nonstd(jpic0_i_name_src[i].table);
#endif  /* JPIC0_I_NAME_ENABLE_NONSTANDARD */
            printf("\n");
            ++i;
        }
    }
}
