# ==============================================================================
# PMBS fragment for test suite
#
# SPDX-FileType: SOURCE
# SPDX-FileCopyrightText: Michael Bäuerle
# SPDX-License-Identifier: BSD-2-Clause

# Object files
OBJS=unit_tests.o

# Filename of test program used for __BASE_FILE__ (if not defined by compiler)
JPIC0_CPPFLAGS=-DJPIC0_UTFILE=\"$*.c\"

# Clear suffix list for inference rules
.SUFFIXES:

.SUFFIXES: .c .o

# If nothing is specified, make will use the first rule
all: check

# Run tests with color output
check: unit_tests
	./unit_tests

# Run tests with monochrome output
test_mono: unit_tests
	./unit_tests -p

# Build unit test binary
unit_tests: $(OBJS) ../src/libjpiconv-0.a
	$(CC) $(LDFLAGS) -o unit_tests $(OBJS) ../src/libjpiconv-0.a

.c.o:
	$(CC) -I. -I../include $(CPPFLAGS) $(JPIC0_CPPFLAGS) $(CFLAGS) \
            -c -o $@ $*.c
