
Build static library with POSIX make
====================================

SPDX-FileType: DOCUMENTATION
SPDX-FileCopyrightText: NONE
SPDX-License-Identifier: CC0-1.0


Dependencies
------------
- POSIX.2-1992 (later merged into POSIX.1-2001) is required
- Utilities (basename, cat, chmod, command, ln, mkdir, printf, sed, sh, test)
- Software Development Utilities (ar, c89, make)
- Filesystem with filename length of at least 32 octets


POSIX make build system (PMBS)
------------------------------
This build system should support most Unix machines from the last three decades.

Parts that are used for all targets are located in the directory "pmbs".
Other directories may contain Makefile fragments named "Build.mk".

Many implementations of the "make" utility do not start a shell to execute the
command lines, or do not start a shell for every line, as defined by POSIX.
The build system tries to be compatible with such behaviour by using parenthesis
to get a shell and to limit side effects to command groups.
All macros should be defined before the first target rule.

This build system was tested to work with GNU make, NetBSD make, Schily make and
System V make.


Environment
-----------
Variables to override the C compiler configuration:
    CC        Compiler
    CPPFLAGS  Options for preprocessor
    CFLAGS    Options for compiler

Variables to override the library archiver configuration:
    AR        Library archiver
    ARFLAGS   Options for library archiver

Variables to override the installation path:
    DESTDIR   Destination path for packaging


Configuration
-------------
The file "pmbs/Config.mk" is used.
There is no configuration script.


Build
-----
Build static library and man pages:
    $ make

Run test suite:
    $ make check

For installation (default target prefix is "/usr/local"):
    $ make install

For uninstallation:
    $ make uninstall

For uninstallation the same environment and configuration (as for installation)
must be used.


Clean up source tree
--------------------
To delete all binary files:
    $ make clean


Documentation
-------------
Build HTML documentation:
    $ make documentation

The HTML documentation will not be installed. For convenience you can point
your browser to "doc/Documentation.html" to get redirected to the index page.
