/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef SSIC0_I_ICONV_TABLE_NI_H
#define SSIC0_I_ICONV_TABLE_NI_H  1


/*
 * Header file for non-identical replacement mappings
 *
 * This file is used by the library and will not be installed.
 */


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/*
 * Unicode replacement codepoint for non-identical conversions
 *
 * Must be an UTF-8 octet-sequence for a single codepoint as NUL-terminated
 * string.
 *
 * \attention
 * No mapping table is allowed to contain this codepoint as regular mapping.
 */
#define SSIC0_I_NI  "\xEF\xBF\xBD"  /* U+FFFD  REPLACEMENT CHARACTER */


/*
 * ISO-8859-1 replacement codepoint for non-identical conversions
 *
 * Must be an ISO-8859-1 codepoint as integer value.
 */
#define SSIC0_I_NI_ISO  0x1A  /* U+001A  SUBSTITUTE */


/*
 * US-ASCII replacement codepoint for non-identical conversions
 *
 * Must be an US-ASCII codepoint as integer value.
 */
#define SSIC0_I_NI_ASCII  0x1A  /* U+001A  SUBSTITUTE */


/*! \endcond */


#pragma GCC visibility pop


#endif  /* SSIC0_I_ICONV_TABLE_NI_H */
