#
# PMBS frontend
#
# SPDX-FileType: SOURCE
# SPDX-FileCopyrightText: Michael Bäuerle
# SPDX-License-Identifier: BSD-2-Clause
#
# Use with toplevel working directory and PMBS_BUILD_DIR in environment.
#
# Switch 'make' into POSIX compliant mode (must be the first non-comment line)
.POSIX:

# Clear suffix list for inference rules
.SUFFIXES:

# Map anything to PMBS build system
.DEFAULT:
	@printf '\n%s\n' 'Preparing build directory ...'
	mkdir -p "$(PMBS_BUILD_DIR)"
	cat ./pmbs/Config.mk ./pmbs/Rules.mk >"$(PMBS_BUILD_DIR)/Makefile"
	(cd "$(PMBS_BUILD_DIR)" && $(MAKE) $@)
