/*
 * 8-bit codepage to Unicode (UTF-8 sequence) mapping tables for libssiconv
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include "libssiconv-0/iconv_table.h"


/*
 * Lines with overlength are accepted here to keep 16 (one hexadecimal digit)
 * character codes on all lines. This is the most common representation in code
 * tables.
 */


/* ========================================================================== */
/* Dummy table for Unicode identity mapping */
const char *ssic0_i_table_utf_8[1] = { 0 };


/* ========================================================================== */
/* UTF-8 sequences for (unused) upper half of US-ASCII character set */
const char *ssic0_i_table_us_ascii[128] =
{
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-1 character set */
const char *ssic0_i_table_iso8859_1[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xC2\xA1", "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xC2\xAA", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC2\xB9", "\xC2\xBA", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xC2\xBF",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", "\xC3\x83", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xC3\x8C", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC3\x90", "\xC3\x91", "\xC3\x92", "\xC3\x93", "\xC3\x94", "\xC3\x95", "\xC3\x96", "\xC3\x97", "\xC3\x98", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC3\x9D", "\xC3\x9E", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", "\xC3\xA3", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xC3\xAC", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC3\xB0", "\xC3\xB1", "\xC3\xB2", "\xC3\xB3", "\xC3\xB4", "\xC3\xB5", "\xC3\xB6", "\xC3\xB7", "\xC3\xB8", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC3\xBD", "\xC3\xBE", "\xC3\xBF"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-2 character set */
const char *ssic0_i_table_iso8859_2[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xC4\x84", "\xCB\x98", "\xC5\x81", "\xC2\xA4", "\xC4\xBD", "\xC5\x9A", "\xC2\xA7", "\xC2\xA8", "\xC5\xA0", "\xC5\x9E", "\xC5\xA4", "\xC5\xB9", "\xC2\xAD", "\xC5\xBD", "\xC5\xBB",
   "\xC2\xB0", "\xC4\x85", "\xCB\x9B", "\xC5\x82", "\xC2\xB4", "\xC4\xBE", "\xC5\x9B", "\xCB\x87", "\xC2\xB8", "\xC5\xA1", "\xC5\x9F", "\xC5\xA5", "\xC5\xBA", "\xCB\x9D", "\xC5\xBE", "\xC5\xBC",
   "\xC5\x94", "\xC3\x81", "\xC3\x82", "\xC4\x82", "\xC3\x84", "\xC4\xB9", "\xC4\x86", "\xC3\x87", "\xC4\x8C", "\xC3\x89", "\xC4\x98", "\xC3\x8B", "\xC4\x9A", "\xC3\x8D", "\xC3\x8E", "\xC4\x8E",
   "\xC4\x90", "\xC5\x83", "\xC5\x87", "\xC3\x93", "\xC3\x94", "\xC5\x90", "\xC3\x96", "\xC3\x97", "\xC5\x98", "\xC5\xAE", "\xC3\x9A", "\xC5\xB0", "\xC3\x9C", "\xC3\x9D", "\xC5\xA2", "\xC3\x9F",
   "\xC5\x95", "\xC3\xA1", "\xC3\xA2", "\xC4\x83", "\xC3\xA4", "\xC4\xBA", "\xC4\x87", "\xC3\xA7", "\xC4\x8D", "\xC3\xA9", "\xC4\x99", "\xC3\xAB", "\xC4\x9B", "\xC3\xAD", "\xC3\xAE", "\xC4\x8F",
   "\xC4\x91", "\xC5\x84", "\xC5\x88", "\xC3\xB3", "\xC3\xB4", "\xC5\x91", "\xC3\xB6", "\xC3\xB7", "\xC5\x99", "\xC5\xAF", "\xC3\xBA", "\xC5\xB1", "\xC3\xBC", "\xC3\xBD", "\xC5\xA3", "\xCB\x99"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-3 character set */
const char *ssic0_i_table_iso8859_3[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xC4\xA6", "\xCB\x98", "\xC2\xA3", "\xC2\xA4", SSIC0_I_NI, "\xC4\xA4", "\xC2\xA7", "\xC2\xA8", "\xC4\xB0", "\xC5\x9E", "\xC4\x9E", "\xC4\xB4", "\xC2\xAD", SSIC0_I_NI, "\xC5\xBB",
   "\xC2\xB0", "\xC4\xA7", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC4\xA5", "\xC2\xB7", "\xC2\xB8", "\xC4\xB1", "\xC5\x9F", "\xC4\x9F", "\xC4\xB5", "\xC2\xBD", SSIC0_I_NI, "\xC5\xBC",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", SSIC0_I_NI, "\xC3\x84", "\xC4\x8A", "\xC4\x88", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xC3\x8C", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   SSIC0_I_NI, "\xC3\x91", "\xC3\x92", "\xC3\x93", "\xC3\x94", "\xC4\xA0", "\xC3\x96", "\xC3\x97", "\xC4\x9C", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC5\xAC", "\xC5\x9C", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", SSIC0_I_NI, "\xC3\xA4", "\xC4\x8B", "\xC4\x89", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xC3\xAC", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   SSIC0_I_NI, "\xC3\xB1", "\xC3\xB2", "\xC3\xB3", "\xC3\xB4", "\xC4\xA1", "\xC3\xB6", "\xC3\xB7", "\xC4\x9D", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC5\xAD", "\xC5\x9D", "\xCB\x99"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-4 character set */
const char *ssic0_i_table_iso8859_4[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xC4\x84", "\xC4\xB8", "\xC5\x96", "\xC2\xA4", "\xC4\xA8", "\xC4\xBB", "\xC2\xA7", "\xC2\xA8", "\xC5\xA0", "\xC4\x92", "\xC4\xA2", "\xC5\xA6", "\xC2\xAD", "\xC5\xBD", "\xC2\xAF",
   "\xC2\xB0", "\xC4\x85", "\xCB\x9B", "\xC5\x97", "\xC2\xB4", "\xC4\xA9", "\xC4\xBC", "\xCB\x87", "\xC2\xB8", "\xC5\xA1", "\xC4\x93", "\xC4\xA3", "\xC5\xA7", "\xC5\x8A", "\xC5\xBE", "\xC5\x8B",
   "\xC4\x80", "\xC3\x81", "\xC3\x82", "\xC3\x83", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC4\xAE", "\xC4\x8C", "\xC3\x89", "\xC4\x98", "\xC3\x8B", "\xC4\x96", "\xC3\x8D", "\xC3\x8E", "\xC4\xAA",
   "\xC4\x90", "\xC5\x85", "\xC5\x8C", "\xC4\xB6", "\xC3\x94", "\xC3\x95", "\xC3\x96", "\xC3\x97", "\xC3\x98", "\xC5\xB2", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC5\xA8", "\xC5\xAA", "\xC3\x9F",
   "\xC4\x81", "\xC3\xA1", "\xC3\xA2", "\xC3\xA3", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC4\xAF", "\xC4\x8D", "\xC3\xA9", "\xC4\x99", "\xC3\xAB", "\xC4\x97", "\xC3\xAD", "\xC3\xAE", "\xC4\xAB",
   "\xC4\x91", "\xC5\x86", "\xC5\x8D", "\xC4\xB7", "\xC3\xB4", "\xC3\xB5", "\xC3\xB6", "\xC3\xB7", "\xC3\xB8", "\xC5\xB3", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC5\xA9", "\xC5\xAB", "\xCB\x99"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-5 character set */
const char *ssic0_i_table_iso8859_5[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xD0\x81", "\xD0\x82", "\xD0\x83", "\xD0\x84", "\xD0\x85", "\xD0\x86", "\xD0\x87", "\xD0\x88", "\xD0\x89", "\xD0\x8A", "\xD0\x8B", "\xD0\x8C", "\xC2\xAD", "\xD0\x8E", "\xD0\x8F",
   "\xD0\x90", "\xD0\x91", "\xD0\x92", "\xD0\x93", "\xD0\x94", "\xD0\x95", "\xD0\x96", "\xD0\x97", "\xD0\x98", "\xD0\x99", "\xD0\x9A", "\xD0\x9B", "\xD0\x9C", "\xD0\x9D", "\xD0\x9E", "\xD0\x9F",
   "\xD0\xA0", "\xD0\xA1", "\xD0\xA2", "\xD0\xA3", "\xD0\xA4", "\xD0\xA5", "\xD0\xA6", "\xD0\xA7", "\xD0\xA8", "\xD0\xA9", "\xD0\xAA", "\xD0\xAB", "\xD0\xAC", "\xD0\xAD", "\xD0\xAE", "\xD0\xAF",
   "\xD0\xB0", "\xD0\xB1", "\xD0\xB2", "\xD0\xB3", "\xD0\xB4", "\xD0\xB5", "\xD0\xB6", "\xD0\xB7", "\xD0\xB8", "\xD0\xB9", "\xD0\xBA", "\xD0\xBB", "\xD0\xBC", "\xD0\xBD", "\xD0\xBE", "\xD0\xBF",
   "\xD1\x80", "\xD1\x81", "\xD1\x82", "\xD1\x83", "\xD1\x84", "\xD1\x85", "\xD1\x86", "\xD1\x87", "\xD1\x88", "\xD1\x89", "\xD1\x8A", "\xD1\x8B", "\xD1\x8C", "\xD1\x8D", "\xD1\x8E", "\xD1\x8F",
   "\xE2\x84\x96", "\xD1\x91", "\xD1\x92", "\xD1\x93", "\xD1\x94", "\xD1\x95", "\xD1\x96", "\xD1\x97", "\xD1\x98", "\xD1\x99", "\xD1\x9A", "\xD1\x9B", "\xD1\x9C", "\xC2\xA7", "\xD1\x9E", "\xD1\x9F"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-6 character set */
const char *ssic0_i_table_iso8859_6[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, "\xC2\xA4", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, "\xD8\x8C", "\xC2\xAD", SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, "\xD8\x9B", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, "\xD8\x9F",
   SSIC0_I_NI, "\xD8\xA1", "\xD8\xA2", "\xD8\xA3", "\xD8\xA4", "\xD8\xA5", "\xD8\xA6", "\xD8\xA7", "\xD8\xA8", "\xD8\xA9", "\xD8\xAA", "\xD8\xAB", "\xD8\xAC", "\xD8\xAD", "\xD8\xAE", "\xD8\xAF",
   "\xD8\xB0", "\xD8\xB1", "\xD8\xB2", "\xD8\xB3", "\xD8\xB4", "\xD8\xB5", "\xD8\xB6", "\xD8\xB7", "\xD8\xB8", "\xD8\xB9", "\xD8\xBA", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   "\xD9\x80", "\xD9\x81", "\xD9\x82", "\xD9\x83", "\xD9\x84", "\xD9\x85", "\xD9\x86", "\xD9\x87", "\xD9\x88", "\xD9\x89", "\xD9\x8A", "\xD9\x8B", "\xD9\x8C", "\xD9\x8D", "\xD9\x8E", "\xD9\x8F",
   "\xD9\x90", "\xD9\x91", "\xD9\x92", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-7 character set */
const char *ssic0_i_table_iso8859_7[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xE2\x80\x98", "\xE2\x80\x99", "\xC2\xA3", "\xE2\x82\xAC", "\xE2\x82\xAF", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xCD\xBA", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", SSIC0_I_NI, "\xE2\x80\x95",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xCE\x84", "\xCE\x85", "\xCE\x86", "\xC2\xB7", "\xCE\x88", "\xCE\x89", "\xCE\x8A", "\xC2\xBB", "\xCE\x8C", "\xC2\xBD", "\xCE\x8E", "\xCE\x8F",
   "\xCE\x90", "\xCE\x91", "\xCE\x92", "\xCE\x93", "\xCE\x94", "\xCE\x95", "\xCE\x96", "\xCE\x97", "\xCE\x98", "\xCE\x99", "\xCE\x9A", "\xCE\x9B", "\xCE\x9C", "\xCE\x9D", "\xCE\x9E", "\xCE\x9F",
   "\xCE\xA0", "\xCE\xA1", SSIC0_I_NI, "\xCE\xA3", "\xCE\xA4", "\xCE\xA5", "\xCE\xA6", "\xCE\xA7", "\xCE\xA8", "\xCE\xA9", "\xCE\xAA", "\xCE\xAB", "\xCE\xAC", "\xCE\xAD", "\xCE\xAE", "\xCE\xAF",
   "\xCE\xB0", "\xCE\xB1", "\xCE\xB2", "\xCE\xB3", "\xCE\xB4", "\xCE\xB5", "\xCE\xB6", "\xCE\xB7", "\xCE\xB8", "\xCE\xB9", "\xCE\xBA", "\xCE\xBB", "\xCE\xBC", "\xCE\xBD", "\xCE\xBE", "\xCE\xBF",
   "\xCF\x80", "\xCF\x81", "\xCF\x82", "\xCF\x83", "\xCF\x84", "\xCF\x85", "\xCF\x86", "\xCF\x87", "\xCF\x88", "\xCF\x89", "\xCF\x8A", "\xCF\x8B", "\xCF\x8C", "\xCF\x8D", "\xCF\x8E", SSIC0_I_NI
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-8 character set */
const char *ssic0_i_table_iso8859_8[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", SSIC0_I_NI, "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xC3\x97", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC2\xB9", "\xC3\xB7", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, "\xE2\x80\x97",
   "\xD7\x90", "\xD7\x91", "\xD7\x92", "\xD7\x93", "\xD7\x94", "\xD7\x95", "\xD7\x96", "\xD7\x97", "\xD7\x98", "\xD7\x99", "\xD7\x9A", "\xD7\x9B", "\xD7\x9C", "\xD7\x9D", "\xD7\x9E", "\xD7\x9F",
   "\xD7\xA0", "\xD7\xA1", "\xD7\xA2", "\xD7\xA3", "\xD7\xA4", "\xD7\xA5", "\xD7\xA6", "\xD7\xA7", "\xD7\xA8", "\xD7\xA9", "\xD7\xAA", SSIC0_I_NI, SSIC0_I_NI, "\xE2\x80\x8E", "\xE2\x80\x8F", SSIC0_I_NI
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-9 character set */
const char *ssic0_i_table_iso8859_9[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xC2\xA1", "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xC2\xAA", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC2\xB9", "\xC2\xBA", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xC2\xBF",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", "\xC3\x83", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xC3\x8C", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC4\x9E", "\xC3\x91", "\xC3\x92", "\xC3\x93", "\xC3\x94", "\xC3\x95", "\xC3\x96", "\xC3\x97", "\xC3\x98", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC4\xB0", "\xC5\x9E", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", "\xC3\xA3", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xC3\xAC", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC4\x9F", "\xC3\xB1", "\xC3\xB2", "\xC3\xB3", "\xC3\xB4", "\xC3\xB5", "\xC3\xB6", "\xC3\xB7", "\xC3\xB8", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC4\xB1", "\xC5\x9F", "\xC3\xBF"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-10 character set */
const char *ssic0_i_table_iso8859_10[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xC4\x84", "\xC4\x92", "\xC4\xA2", "\xC4\xAA", "\xC4\xA8", "\xC4\xB6", "\xC2\xA7", "\xC4\xBB", "\xC4\x90", "\xC5\xA0", "\xC5\xA6", "\xC5\xBD", "\xC2\xAD", "\xC5\xAA", "\xC5\x8A",
   "\xC2\xB0", "\xC4\x85", "\xC4\x93", "\xC4\xA3", "\xC4\xAB", "\xC4\xA9", "\xC4\xB7", "\xC2\xB7", "\xC4\xBC", "\xC4\x91", "\xC5\xA1", "\xC5\xA7", "\xC5\xBE", "\xE2\x80\x95", "\xC5\xAB", "\xC5\x8B",
   "\xC4\x80", "\xC3\x81", "\xC3\x82", "\xC3\x83", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC4\xAE", "\xC4\x8C", "\xC3\x89", "\xC4\x98", "\xC3\x8B", "\xC4\x96", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC3\x90", "\xC5\x85", "\xC5\x8C", "\xC3\x93", "\xC3\x94", "\xC3\x95", "\xC3\x96", "\xC5\xA8", "\xC3\x98", "\xC5\xB2", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC3\x9D", "\xC3\x9E", "\xC3\x9F",
   "\xC4\x81", "\xC3\xA1", "\xC3\xA2", "\xC3\xA3", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC4\xAF", "\xC4\x8D", "\xC3\xA9", "\xC4\x99", "\xC3\xAB", "\xC4\x97", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC3\xB0", "\xC5\x86", "\xC5\x8D", "\xC3\xB3", "\xC3\xB4", "\xC3\xB5", "\xC3\xB6", "\xC5\xA9", "\xC3\xB8", "\xC5\xB3", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC3\xBD", "\xC3\xBE", "\xC4\xB8"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-11 character set */
const char *ssic0_i_table_iso8859_11[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xE0\xB8\x81", "\xE0\xB8\x82", "\xE0\xB8\x83", "\xE0\xB8\x84", "\xE0\xB8\x85", "\xE0\xB8\x86", "\xE0\xB8\x87", "\xE0\xB8\x88", "\xE0\xB8\x89", "\xE0\xB8\x8A", "\xE0\xB8\x8B", "\xE0\xB8\x8C", "\xE0\xB8\x8D", "\xE0\xB8\x8E", "\xE0\xB8\x8F",
   "\xE0\xB8\x90", "\xE0\xB8\x91", "\xE0\xB8\x92", "\xE0\xB8\x93", "\xE0\xB8\x94", "\xE0\xB8\x95", "\xE0\xB8\x96", "\xE0\xB8\x97", "\xE0\xB8\x98", "\xE0\xB8\x99", "\xE0\xB8\x9A", "\xE0\xB8\x9B", "\xE0\xB8\x9C", "\xE0\xB8\x9D", "\xE0\xB8\x9E", "\xE0\xB8\x9F",
   "\xE0\xB8\xA0", "\xE0\xB8\xA1", "\xE0\xB8\xA2", "\xE0\xB8\xA3", "\xE0\xB8\xA4", "\xE0\xB8\xA5", "\xE0\xB8\xA6", "\xE0\xB8\xA7", "\xE0\xB8\xA8", "\xE0\xB8\xA9", "\xE0\xB8\xAA", "\xE0\xB8\xAB", "\xE0\xB8\xAC", "\xE0\xB8\xAD", "\xE0\xB8\xAE", "\xE0\xB8\xAF",
   "\xE0\xB8\xB0", "\xE0\xB8\xB1", "\xE0\xB8\xB2", "\xE0\xB8\xB3", "\xE0\xB8\xB4", "\xE0\xB8\xB5", "\xE0\xB8\xB6", "\xE0\xB8\xB7", "\xE0\xB8\xB8", "\xE0\xB8\xB9", "\xE0\xB8\xBA", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, "\xE0\xB8\xBF",
   "\xE0\xB9\x80", "\xE0\xB9\x81", "\xE0\xB9\x82", "\xE0\xB9\x83", "\xE0\xB9\x84", "\xE0\xB9\x85", "\xE0\xB9\x86", "\xE0\xB9\x87", "\xE0\xB9\x88", "\xE0\xB9\x89", "\xE0\xB9\x8A", "\xE0\xB9\x8B", "\xE0\xB9\x8C", "\xE0\xB9\x8D", "\xE0\xB9\x8E", "\xE0\xB9\x8F",
   "\xE0\xB9\x90", "\xE0\xB9\x91", "\xE0\xB9\x92", "\xE0\xB9\x93", "\xE0\xB9\x94", "\xE0\xB9\x95", "\xE0\xB9\x96", "\xE0\xB9\x97", "\xE0\xB9\x98", "\xE0\xB9\x99", "\xE0\xB9\x9A", "\xE0\xB9\x9B", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-13 character set */
const char *ssic0_i_table_iso8859_13[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xE2\x80\x9D", "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", "\xE2\x80\x9E", "\xC2\xA6", "\xC2\xA7", "\xC3\x98", "\xC2\xA9", "\xC5\x96", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC3\x86",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xE2\x80\x9C", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC3\xB8", "\xC2\xB9", "\xC5\x97", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xC3\xA6",
   "\xC4\x84", "\xC4\xAE", "\xC4\x80", "\xC4\x86", "\xC3\x84", "\xC3\x85", "\xC4\x98", "\xC4\x92", "\xC4\x8C", "\xC3\x89", "\xC5\xB9", "\xC4\x96", "\xC4\xA2", "\xC4\xB6", "\xC4\xAA", "\xC4\xBB",
   "\xC5\xA0", "\xC5\x83", "\xC5\x85", "\xC3\x93", "\xC5\x8C", "\xC3\x95", "\xC3\x96", "\xC3\x97", "\xC5\xB2", "\xC5\x81", "\xC5\x9A", "\xC5\xAA", "\xC3\x9C", "\xC5\xBB", "\xC5\xBD", "\xC3\x9F",
   "\xC4\x85", "\xC4\xAF", "\xC4\x81", "\xC4\x87", "\xC3\xA4", "\xC3\xA5", "\xC4\x99", "\xC4\x93", "\xC4\x8D", "\xC3\xA9", "\xC5\xBA", "\xC4\x97", "\xC4\xA3", "\xC4\xB7", "\xC4\xAB", "\xC4\xBC",
   "\xC5\xA1", "\xC5\x84", "\xC5\x86", "\xC3\xB3", "\xC5\x8D", "\xC3\xB5", "\xC3\xB6", "\xC3\xB7", "\xC5\xB3", "\xC5\x82", "\xC5\x9B", "\xC5\xAB", "\xC3\xBC", "\xC5\xBC", "\xC5\xBE", "\xE2\x80\x99"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-14 character set */
const char *ssic0_i_table_iso8859_14[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xE1\xB8\x82", "\xE1\xB8\x83", "\xC2\xA3", "\xC4\x8A", "\xC4\x8B","\xE1\xB8\x8A", "\xC2\xA7", "\xE1\xBA\x80", "\xC2\xA9", "\xE1\xBA\x82", "\xE1\xB8\x8B", "\xE1\xBB\xB2", "\xC2\xAD", "\xC2\xAE", "\xC5\xB8",
   "\xE1\xB8\x9E", "\xE1\xB8\x9F", "\xC4\xA0", "\xC4\xA1", "\xE1\xB9\x80", "\xE1\xB9\x81", "\xC2\xB6", "\xE1\xB9\x96", "\xE1\xBA\x81", "\xE1\xB9\x97", "\xE1\xBA\x83", "\xE1\xB9\xA0", "\xE1\xBB\xB3", "\xE1\xBA\x84", "\xE1\xBA\x85", "\xE1\xB9\xA1",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", "\xC3\x83", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xC3\x8C", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC5\xB4", "\xC3\x91", "\xC3\x92", "\xC3\x93", "\xC3\x94", "\xC3\x95", "\xC3\x96", "\xE1\xB9\xAA", "\xC3\x98", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC3\x9D", "\xC5\xB6", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", "\xC3\xA3", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xC3\xAC", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC5\xB5", "\xC3\xB1", "\xC3\xB2", "\xC3\xB3", "\xC3\xB4", "\xC3\xB5", "\xC3\xB6", "\xE1\xB9\xAB", "\xC3\xB8", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC3\xBD", "\xC5\xB7", "\xC3\xBF"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-15 character set */
const char *ssic0_i_table_iso8859_15[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xC2\xA1", "\xC2\xA2", "\xC2\xA3", "\xE2\x82\xAC", "\xC2\xA5", "\xC5\xA0", "\xC2\xA7", "\xC5\xA1", "\xC2\xA9", "\xC2\xAA", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC5\xBD", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC5\xBE", "\xC2\xB9", "\xC2\xBA", "\xC2\xBB", "\xC5\x92", "\xC5\x93", "\xC5\xB8", "\xC2\xBF",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", "\xC3\x83", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xC3\x8C", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC3\x90", "\xC3\x91", "\xC3\x92", "\xC3\x93", "\xC3\x94", "\xC3\x95", "\xC3\x96", "\xC3\x97", "\xC3\x98", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC3\x9D", "\xC3\x9E", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", "\xC3\xA3", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xC3\xAC", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC3\xB0", "\xC3\xB1", "\xC3\xB2", "\xC3\xB3", "\xC3\xB4", "\xC3\xB5", "\xC3\xB6", "\xC3\xB7", "\xC3\xB8", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC3\xBD", "\xC3\xBE", "\xC3\xBF"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of ISO 8859-16 character set */
const char *ssic0_i_table_iso8859_16[128] =
{
   "\xC2\x80", "\xC2\x81", "\xC2\x82", "\xC2\x83", "\xC2\x84", "\xC2\x85", "\xC2\x86", "\xC2\x87", "\xC2\x88", "\xC2\x89", "\xC2\x8A", "\xC2\x8B", "\xC2\x8C", "\xC2\x8D", "\xC2\x8E", "\xC2\x8F",
   "\xC2\x90", "\xC2\x91", "\xC2\x92", "\xC2\x93", "\xC2\x94", "\xC2\x95", "\xC2\x96", "\xC2\x97", "\xC2\x98", "\xC2\x99", "\xC2\x9A", "\xC2\x9B", "\xC2\x9C", "\xC2\x9D", "\xC2\x9E", "\xC2\x9F",
   "\xC2\xA0", "\xC4\x84", "\xC4\x85", "\xC5\x81", "\xE2\x82\xAC", "\xE2\x80\x9E", "\xC5\xA0", "\xC2\xA7", "\xC5\xA1", "\xC2\xA9", "\xC8\x98", "\xC2\xAB", "\xC5\xB9", "\xC2\xAD", "\xC5\xBA", "\xC5\xBB",
   "\xC2\xB0", "\xC2\xB1", "\xC4\x8C", "\xC5\x82", "\xC5\xBD", "\xE2\x80\x9D", "\xC2\xB6", "\xC2\xB7", "\xC5\xBE", "\xC4\x8D", "\xC8\x99", "\xC2\xBB", "\xC5\x92", "\xC5\x93", "\xC5\xB8", "\xC5\xBC",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", "\xC4\x82", "\xC3\x84", "\xC4\x86", "\xC3\x86", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xC3\x8C", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC4\x90", "\xC5\x83", "\xC3\x92", "\xC3\x93", "\xC3\x94", "\xC5\x90", "\xC3\x96", "\xC5\x9A", "\xC5\xB0", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC4\x98", "\xC8\x9A", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", "\xC4\x83", "\xC3\xA4", "\xC4\x87", "\xC3\xA6", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xC3\xAC", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC4\x91", "\xC5\x84", "\xC3\xB2", "\xC3\xB3", "\xC3\xB4", "\xC5\x91", "\xC3\xB6", "\xC5\x9B", "\xC5\xB1", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC4\x99", "\xC8\x9B", "\xC3\xBF"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of KOI8-R character set */
const char *ssic0_i_table_koi8r[128] =
{
   "\xE2\x94\x80", "\xE2\x94\x82", "\xE2\x94\x8C", "\xE2\x94\x90", "\xE2\x94\x94", "\xE2\x94\x98", "\xE2\x94\x9C", "\xE2\x94\xA4", "\xE2\x94\xAC", "\xE2\x94\xB4", "\xE2\x94\xBC", "\xE2\x96\x80", "\xE2\x96\x84", "\xE2\x96\x88", "\xE2\x96\x8C", "\xE2\x96\x90",
   "\xE2\x96\x91", "\xE2\x96\x92", "\xE2\x96\x93", "\xE2\x8C\xA0", "\xE2\x96\xA0", "\xE2\x88\x99", "\xE2\x88\x9A", "\xE2\x89\x88", "\xE2\x89\xA4", "\xE2\x89\xA5", "\xC2\xA0", "\xE2\x8C\xA1", "\xC2\xB0", "\xC2\xB2", "\xC2\xB7", "\xC3\xB7",
   "\xE2\x95\x90", "\xE2\x95\x91", "\xE2\x95\x92", "\xD1\x91", "\xE2\x95\x93", "\xE2\x95\x94", "\xE2\x95\x95", "\xE2\x95\x96", "\xE2\x95\x97", "\xE2\x95\x98", "\xE2\x95\x99", "\xE2\x95\x9A", "\xE2\x95\x9B", "\xE2\x95\x9C", "\xE2\x95\x9D", "\xE2\x95\x9E",
   "\xE2\x95\x9F", "\xE2\x95\xA0", "\xE2\x95\xA1", "\xD0\x81", "\xE2\x95\xA2", "\xE2\x95\xA3", "\xE2\x95\xA4", "\xE2\x95\xA5", "\xE2\x95\xA6", "\xE2\x95\xA7", "\xE2\x95\xA8", "\xE2\x95\xA9", "\xE2\x95\xAA", "\xE2\x95\xAB", "\xE2\x95\xAC", "\xC2\xA9",
   "\xD1\x8E", "\xD0\xB0", "\xD0\xB1", "\xD1\x86", "\xD0\xB4", "\xD0\xB5", "\xD1\x84", "\xD0\xB3", "\xD1\x85", "\xD0\xB8", "\xD0\xB9", "\xD0\xBA", "\xD0\xBB", "\xD0\xBC", "\xD0\xBD", "\xD0\xBE",
   "\xD0\xBF", "\xD1\x8F", "\xD1\x80", "\xD1\x81", "\xD1\x82", "\xD1\x83", "\xD0\xB6", "\xD0\xB2", "\xD1\x8C", "\xD1\x8B", "\xD0\xB7", "\xD1\x88", "\xD1\x8D", "\xD1\x89", "\xD1\x87", "\xD1\x8A",
   "\xD0\xAE", "\xD0\x90", "\xD0\x91", "\xD0\xA6", "\xD0\x94", "\xD0\x95", "\xD0\xA4", "\xD0\x93", "\xD0\xA5", "\xD0\x98", "\xD0\x99", "\xD0\x9A", "\xD0\x9B", "\xD0\x9C", "\xD0\x9D", "\xD0\x9E",
   "\xD0\x9F", "\xD0\xAF", "\xD0\xA0", "\xD0\xA1", "\xD0\xA2", "\xD0\xA3", "\xD0\x96", "\xD0\x92", "\xD0\xAC", "\xD0\xAB", "\xD0\x97", "\xD0\xA8", "\xD0\xAD", "\xD0\xA9", "\xD0\xA7", "\xD0\xAA"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of KOI8-U character set */
const char *ssic0_i_table_koi8u[128] =
{
   "\xE2\x94\x80", "\xE2\x94\x82", "\xE2\x94\x8C", "\xE2\x94\x90", "\xE2\x94\x94", "\xE2\x94\x98", "\xE2\x94\x9C", "\xE2\x94\xA4", "\xE2\x94\xAC", "\xE2\x94\xB4", "\xE2\x94\xBC", "\xE2\x96\x80", "\xE2\x96\x84", "\xE2\x96\x88", "\xE2\x96\x8C", "\xE2\x96\x90",
   "\xE2\x96\x91", "\xE2\x96\x92", "\xE2\x96\x93", "\xE2\x8C\xA0", "\xE2\x96\xA0", "\xE2\x88\x99", "\xE2\x88\x9A", "\xE2\x89\x88", "\xE2\x89\xA4", "\xE2\x89\xA5", "\xC2\xA0", "\xE2\x8C\xA1", "\xC2\xB0", "\xC2\xB2", "\xC2\xB7", "\xC3\xB7",
   "\xE2\x95\x90", "\xE2\x95\x91", "\xE2\x95\x92", "\xD1\x91", "\xD1\x94", "\xE2\x95\x94", "\xD1\x96", "\xD1\x97", "\xE2\x95\x97", "\xE2\x95\x98", "\xE2\x95\x99", "\xE2\x95\x9A", "\xE2\x95\x9B", "\xD2\x91", "\xE2\x95\x9D", "\xE2\x95\x9E",
   "\xE2\x95\x9F", "\xE2\x95\xA0", "\xE2\x95\xA1", "\xD0\x81", "\xD0\x84", "\xE2\x95\xA3", "\xD0\x86", "\xD0\x87", "\xE2\x95\xA6", "\xE2\x95\xA7", "\xE2\x95\xA8", "\xE2\x95\xA9", "\xE2\x95\xAA", "\xD2\x90", "\xE2\x95\xAC", "\xC2\xA9",
   "\xD1\x8E", "\xD0\xB0", "\xD0\xB1", "\xD1\x86", "\xD0\xB4", "\xD0\xB5", "\xD1\x84", "\xD0\xB3", "\xD1\x85", "\xD0\xB8", "\xD0\xB9", "\xD0\xBA", "\xD0\xBB", "\xD0\xBC", "\xD0\xBD", "\xD0\xBE",
   "\xD0\xBF", "\xD1\x8F", "\xD1\x80", "\xD1\x81", "\xD1\x82", "\xD1\x83", "\xD0\xB6", "\xD0\xB2", "\xD1\x8C", "\xD1\x8B", "\xD0\xB7", "\xD1\x88", "\xD1\x8D", "\xD1\x89", "\xD1\x87", "\xD1\x8A",
   "\xD0\xAE", "\xD0\x90", "\xD0\x91", "\xD0\xA6", "\xD0\x94", "\xD0\x95", "\xD0\xA4", "\xD0\x93", "\xD0\xA5", "\xD0\x98", "\xD0\x99", "\xD0\x9A", "\xD0\x9B", "\xD0\x9C", "\xD0\x9D", "\xD0\x9E",
   "\xD0\x9F", "\xD0\xAF", "\xD0\xA0", "\xD0\xA1", "\xD0\xA2", "\xD0\xA3", "\xD0\x96", "\xD0\x92", "\xD0\xAC", "\xD0\xAB", "\xD0\x97", "\xD0\xA8", "\xD0\xAD", "\xD0\xA9", "\xD0\xA7", "\xD0\xAA"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1250 character set */
const char *ssic0_i_table_windows_1250[128] =
{
   "\xE2\x82\xAC", SSIC0_I_NI, "\xE2\x80\x9A", SSIC0_I_NI, "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", SSIC0_I_NI, "\xE2\x80\xB0", "\xC5\xA0", "\xE2\x80\xB9", "\xC5\x9A", "\xC5\xA4", "\xC5\xBD", "\xC5\xB9",
   SSIC0_I_NI, "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", SSIC0_I_NI, "\xE2\x84\xA2", "\xC5\xA1", "\xE2\x80\xBA", "\xC5\x9B", "\xC5\xA5", "\xC5\xBE", "\xC5\xBA",
   "\xC2\xA0", "\xCB\x87", "\xCB\x98", "\xC5\x81", "\xC2\xA4", "\xC4\x84", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xC5\x9E", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC5\xBB",
   "\xC2\xB0", "\xC2\xB1", "\xCB\x9B", "\xC5\x82", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC4\x85", "\xC5\x9F", "\xC2\xBB", "\xC4\xBD", "\xCB\x9D", "\xC4\xBE", "\xC5\xBC",
   "\xC5\x94", "\xC3\x81", "\xC3\x82", "\xC4\x82", "\xC3\x84", "\xC4\xB9", "\xC4\x86", "\xC3\x87", "\xC4\x8C", "\xC3\x89", "\xC4\x98", "\xC3\x8B", "\xC4\x9A", "\xC3\x8D", "\xC3\x8E", "\xC4\x8E",
   "\xC4\x90", "\xC5\x83", "\xC5\x87", "\xC3\x93", "\xC3\x94", "\xC5\x90", "\xC3\x96", "\xC3\x97", "\xC5\x98", "\xC5\xAE", "\xC3\x9A", "\xC5\xB0", "\xC3\x9C", "\xC3\x9D", "\xC5\xA2", "\xC3\x9F",
   "\xC5\x95", "\xC3\xA1", "\xC3\xA2", "\xC4\x83", "\xC3\xA4", "\xC4\xBA", "\xC4\x87", "\xC3\xA7", "\xC4\x8D", "\xC3\xA9", "\xC4\x99", "\xC3\xAB", "\xC4\x9B", "\xC3\xAD", "\xC3\xAE", "\xC4\x8F",
   "\xC4\x91", "\xC5\x84", "\xC5\x88", "\xC3\xB3", "\xC3\xB4", "\xC5\x91", "\xC3\xB6", "\xC3\xB7", "\xC5\x99", "\xC5\xAF", "\xC3\xBA", "\xC5\xB1", "\xC3\xBC", "\xC3\xBD", "\xC5\xA3", "\xCB\x99"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1251 character set */
const char *ssic0_i_table_windows_1251[128] =
{
   "\xD0\x82", "\xD0\x83", "\xE2\x80\x9A", "\xD1\x93", "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", "\xE2\x82\xAC", "\xE2\x80\xB0", "\xD0\x89", "\xE2\x80\xB9", "\xD0\x8A", "\xD0\x8C", "\xD0\x8B", "\xD0\x8F",
   "\xD1\x92", "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", SSIC0_I_NI, "\xE2\x84\xA2", "\xD1\x99", "\xE2\x80\xBA", "\xD1\x9A", "\xD1\x9C", "\xD1\x9B", "\xD1\x9F",
   "\xC2\xA0", "\xD0\x8E", "\xD1\x9E", "\xD0\x88", "\xC2\xA4", "\xD2\x90", "\xC2\xA6", "\xC2\xA7", "\xD0\x81", "\xC2\xA9", "\xD0\x84", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xD0\x87",
   "\xC2\xB0", "\xC2\xB1", "\xD0\x86", "\xD1\x96", "\xD2\x91", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xD1\x91", "\xE2\x84\x96", "\xD1\x94", "\xC2\xBB", "\xD1\x98", "\xD0\x85", "\xD1\x95", "\xD1\x97",
   "\xD0\x90", "\xD0\x91", "\xD0\x92", "\xD0\x93", "\xD0\x94", "\xD0\x95", "\xD0\x96", "\xD0\x97", "\xD0\x98", "\xD0\x99", "\xD0\x9A", "\xD0\x9B", "\xD0\x9C", "\xD0\x9D", "\xD0\x9E", "\xD0\x9F",
   "\xD0\xA0", "\xD0\xA1", "\xD0\xA2", "\xD0\xA3", "\xD0\xA4", "\xD0\xA5", "\xD0\xA6", "\xD0\xA7", "\xD0\xA8", "\xD0\xA9", "\xD0\xAA", "\xD0\xAB", "\xD0\xAC", "\xD0\xAD", "\xD0\xAE", "\xD0\xAF",
   "\xD0\xB0", "\xD0\xB1", "\xD0\xB2", "\xD0\xB3", "\xD0\xB4", "\xD0\xB5", "\xD0\xB6", "\xD0\xB7", "\xD0\xB8", "\xD0\xB9", "\xD0\xBA", "\xD0\xBB", "\xD0\xBC", "\xD0\xBD", "\xD0\xBE", "\xD0\xBF",
   "\xD1\x80", "\xD1\x81", "\xD1\x82", "\xD1\x83", "\xD1\x84", "\xD1\x85", "\xD1\x86", "\xD1\x87", "\xD1\x88", "\xD1\x89", "\xD1\x8A", "\xD1\x8B", "\xD1\x8C", "\xD1\x8D", "\xD1\x8E", "\xD1\x8F"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1252 character set */
const char *ssic0_i_table_windows_1252[128] =
{
   "\xE2\x82\xAC", SSIC0_I_NI, "\xE2\x80\x9A", "\xC6\x92", "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", "\xCB\x86", "\xE2\x80\xB0", "\xC5\xA0", "\xE2\x80\xB9", "\xC5\x92", SSIC0_I_NI, "\xC5\xBD", SSIC0_I_NI,
   SSIC0_I_NI, "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", "\xCB\x9C", "\xE2\x84\xA2", "\xC5\xA1", "\xE2\x80\xBA", "\xC5\x93", SSIC0_I_NI, "\xC5\xBE", "\xC5\xB8",
   "\xC2\xA0", "\xC2\xA1", "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xC2\xAA", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC2\xB9", "\xC2\xBA", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xC2\xBF",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", "\xC3\x83", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xC3\x8C", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC3\x90", "\xC3\x91", "\xC3\x92", "\xC3\x93", "\xC3\x94", "\xC3\x95", "\xC3\x96", "\xC3\x97", "\xC3\x98", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC3\x9D", "\xC3\x9E", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", "\xC3\xA3", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xC3\xAC", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC3\xB0", "\xC3\xB1", "\xC3\xB2", "\xC3\xB3", "\xC3\xB4", "\xC3\xB5", "\xC3\xB6", "\xC3\xB7", "\xC3\xB8", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC3\xBD", "\xC3\xBE", "\xC3\xBF"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1253 character set */
const char *ssic0_i_table_windows_1253[128] =
{
   "\xE2\x82\xAC", SSIC0_I_NI, "\xE2\x80\x9A", "\xC6\x92", "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", SSIC0_I_NI, "\xE2\x80\xB0", SSIC0_I_NI, "\xE2\x80\xB9", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", SSIC0_I_NI, "\xE2\x84\xA2", SSIC0_I_NI, "\xE2\x80\xBA", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   "\xC2\xA0", "\xCE\x85", "\xCE\x86", "\xC2\xA3", "\xC2\xA4", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", SSIC0_I_NI, "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xE2\x80\x95",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xCE\x84", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xCE\x88", "\xCE\x89", "\xCE\x8A", "\xC2\xBB", "\xCE\x8C", "\xC2\xBD", "\xCE\x8E", "\xCE\x8F",
   "\xCE\x90", "\xCE\x91", "\xCE\x92", "\xCE\x93", "\xCE\x94", "\xCE\x95", "\xCE\x96", "\xCE\x97", "\xCE\x98", "\xCE\x99", "\xCE\x9A", "\xCE\x9B", "\xCE\x9C", "\xCE\x9D", "\xCE\x9E", "\xCE\x9F",
   "\xCE\xA0", "\xCE\xA1", SSIC0_I_NI, "\xCE\xA3", "\xCE\xA4", "\xCE\xA5", "\xCE\xA6", "\xCE\xA7", "\xCE\xA8", "\xCE\xA9", "\xCE\xAA", "\xCE\xAB", "\xCE\xAC", "\xCE\xAD", "\xCE\xAE", "\xCE\xAF",
   "\xCE\xB0", "\xCE\xB1", "\xCE\xB2", "\xCE\xB3", "\xCE\xB4", "\xCE\xB5", "\xCE\xB6", "\xCE\xB7", "\xCE\xB8", "\xCE\xB9", "\xCE\xBA", "\xCE\xBB", "\xCE\xBC", "\xCE\xBD", "\xCE\xBE", "\xCE\xBF",
   "\xCF\x80", "\xCF\x81", "\xCF\x82", "\xCF\x83", "\xCF\x84", "\xCF\x85", "\xCF\x86", "\xCF\x87", "\xCF\x88", "\xCF\x89", "\xCF\x8A", "\xCF\x8B", "\xCF\x8C", "\xCF\x8D", "\xCF\x8E", SSIC0_I_NI
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1254 character set */
const char *ssic0_i_table_windows_1254[128] =
{
   "\xE2\x82\xAC", SSIC0_I_NI, "\xE2\x80\x9A", "\xC6\x92", "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", "\xCB\x86", "\xE2\x80\xB0", "\xC5\xA0", "\xE2\x80\xB9", "\xC5\x92", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", "\xCB\x9C", "\xE2\x84\xA2", "\xC5\xA1", "\xE2\x80\xBA", "\xC5\x93", SSIC0_I_NI, SSIC0_I_NI, "\xC5\xB8",
   "\xC2\xA0", "\xC2\xA1", "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xC2\xAA", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC2\xB9", "\xC2\xBA", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xC2\xBF",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", "\xC3\x83", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xC3\x8C", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC4\x9E", "\xC3\x91", "\xC3\x92", "\xC3\x93", "\xC3\x94", "\xC3\x95", "\xC3\x96", "\xC3\x97", "\xC3\x98", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC4\xB0", "\xC5\x9E", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", "\xC3\xA3", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xC3\xAC", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC4\x9F", "\xC3\xB1", "\xC3\xB2", "\xC3\xB3", "\xC3\xB4", "\xC3\xB5", "\xC3\xB6", "\xC3\xB7", "\xC3\xB8", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC4\xB1", "\xC5\x9F", "\xC3\xBF"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1255 character set */
const char *ssic0_i_table_windows_1255[128] =
{
   "\xE2\x82\xAC", SSIC0_I_NI, "\xE2\x80\x9A", "\xC6\x92", "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", "\xCB\x86", "\xE2\x80\xB0", SSIC0_I_NI, "\xE2\x80\xB9", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", "\xCB\x9C", "\xE2\x84\xA2", SSIC0_I_NI, "\xE2\x80\xBA", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   "\xC2\xA0", "\xC2\xA1", "\xC2\xA2", "\xC2\xA3", "\xE2\x82\xAA", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xC3\x97", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC2\xB9", "\xC3\xB7", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xC2\xBF",
   "\xD6\xB0", "\xD6\xB1", "\xD6\xB2", "\xD6\xB3", "\xD6\xB4", "\xD6\xB5", "\xD6\xB6", "\xD6\xB7", "\xD6\xB8", "\xD6\xB9", "\xD6\xBA", "\xD6\xBB", "\xD6\xBC", "\xD6\xBD", "\xD6\xBE", "\xD6\xBF",
   "\xD7\x80", "\xD7\x81", "\xD7\x82", "\xD7\x83", "\xD7\xB0", "\xD7\xB1", "\xD7\xB2", "\xD7\xB3", "\xD7\xB4", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   "\xD7\x90", "\xD7\x91", "\xD7\x92", "\xD7\x93", "\xD7\x94", "\xD7\x95", "\xD7\x96", "\xD7\x97", "\xD7\x98", "\xD7\x99", "\xD7\x9A", "\xD7\x9B", "\xD7\x9C", "\xD7\x9D", "\xD7\x9E", "\xD7\x9F",
   "\xD7\xA0", "\xD7\xA1", "\xD7\xA2", "\xD7\xA3", "\xD7\xA4", "\xD7\xA5", "\xD7\xA6", "\xD7\xA7", "\xD7\xA8", "\xD7\xA9", "\xD7\xAA", SSIC0_I_NI, SSIC0_I_NI, "\xE2\x80\x8E", "\xE2\x80\x8F", SSIC0_I_NI
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1256 character set */
const char *ssic0_i_table_windows_1256[128] =
{
   "\xE2\x82\xAC", "\xD9\xBE", "\xE2\x80\x9A", "\xC6\x92", "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", "\xCB\x86", "\xE2\x80\xB0", "\xD9\xB9", "\xE2\x80\xB9", "\xC5\x92", "\xDA\x86", "\xDA\x98", "\xDA\x88",
   "\xDA\xAF", "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", "\xDA\xA9", "\xE2\x84\xA2", "\xDA\x91", "\xE2\x80\xBA", "\xC5\x93", "\xE2\x80\x8C", "\xE2\x80\x8D", "\xDA\xBA",
   "\xC2\xA0", "\xD8\x8C", "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xDA\xBE", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC2\xB9", "\xD8\x9B", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xD8\x9F",
   "\xDB\x81", "\xD8\xA1", "\xD8\xA2", "\xD8\xA3", "\xD8\xA4", "\xD8\xA5", "\xD8\xA6", "\xD8\xA7", "\xD8\xA8", "\xD8\xA9", "\xD8\xAA", "\xD8\xAB", "\xD8\xAC", "\xD8\xAD", "\xD8\xAE", "\xD8\xAF",
   "\xD8\xB0", "\xD8\xB1", "\xD8\xB2", "\xD8\xB3", "\xD8\xB4", "\xD8\xB5", "\xD8\xB6", "\xC3\x97", "\xD8\xB7", "\xD8\xB8", "\xD8\xB9", "\xD8\xBA", "\xD9\x80", "\xD9\x81", "\xD9\x82", "\xD9\x83",
   "\xC3\xA0", "\xD9\x84", "\xC3\xA2", "\xD9\x85", "\xD9\x86", "\xD9\x87", "\xD9\x88", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xD9\x89", "\xD9\x8A", "\xC3\xAE", "\xC3\xAF",
   "\xD9\x8B", "\xD9\x8C", "\xD9\x8D", "\xD9\x8E", "\xC3\xB4", "\xD9\x8F", "\xD9\x90", "\xC3\xB7", "\xD9\x91", "\xC3\xB9", "\xD9\x92", "\xC3\xBB", "\xC3\xBC", "\xE2\x80\x8E", "\xE2\x80\x8F", "\xDB\x92"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1257 character set */
const char *ssic0_i_table_windows_1257[128] =
{
   "\xE2\x82\xAC", SSIC0_I_NI, "\xE2\x80\x9A", SSIC0_I_NI, "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", SSIC0_I_NI, "\xE2\x80\xB0", SSIC0_I_NI, "\xE2\x80\xB9", SSIC0_I_NI, "\xC2\xA8", "\xCB\x87", "\xC2\xB8",
   SSIC0_I_NI, "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", SSIC0_I_NI, "\xE2\x84\xA2", SSIC0_I_NI, "\xE2\x80\xBA", SSIC0_I_NI, "\xC2\xAF", "\xCB\x9B", SSIC0_I_NI,
   "\xC2\xA0", SSIC0_I_NI, "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", SSIC0_I_NI, "\xC2\xA6", "\xC2\xA7", "\xC3\x98", "\xC2\xA9", "\xC5\x96", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC3\x86",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC3\xB8", "\xC2\xB9", "\xC5\x97", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xC3\xA6",
   "\xC4\x84", "\xC4\xAE", "\xC4\x80", "\xC4\x86", "\xC3\x84", "\xC3\x85", "\xC4\x98", "\xC4\x92", "\xC4\x8C", "\xC3\x89", "\xC5\xB9", "\xC4\x96", "\xC4\xA2", "\xC4\xB6", "\xC4\xAA", "\xC4\xBB",
   "\xC5\xA0", "\xC5\x83", "\xC5\x85", "\xC3\x93", "\xC5\x8C", "\xC3\x95", "\xC3\x96", "\xC3\x97", "\xC5\xB2", "\xC5\x81", "\xC5\x9A", "\xC5\xAA", "\xC3\x9C", "\xC5\xBB", "\xC5\xBD", "\xC3\x9F",
   "\xC4\x85", "\xC4\xAF", "\xC4\x81", "\xC4\x87", "\xC3\xA4", "\xC3\xA5", "\xC4\x99", "\xC4\x93", "\xC4\x8D", "\xC3\xA9", "\xC5\xBA", "\xC4\x97", "\xC4\xA3", "\xC4\xB7", "\xC4\xAB", "\xC4\xBC",
   "\xC5\xA1", "\xC5\x84", "\xC5\x86", "\xC3\xB3", "\xC5\x8D", "\xC3\xB5", "\xC3\xB6", "\xC3\xB7", "\xC5\xB3", "\xC5\x82", "\xC5\x9B", "\xC5\xAB", "\xC3\xBC", "\xC5\xBC", "\xC5\xBE", "\xCB\x99"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of Windows-1258 character set */
const char *ssic0_i_table_windows_1258[128] =
{
   "\xE2\x82\xAC", SSIC0_I_NI, "\xE2\x80\x9A", "\xC6\x92", "\xE2\x80\x9E", "\xE2\x80\xA6", "\xE2\x80\xA0", "\xE2\x80\xA1", "\xCB\x86", "\xE2\x80\xB0", SSIC0_I_NI, "\xE2\x80\xB9", "\xC5\x92", SSIC0_I_NI, SSIC0_I_NI, SSIC0_I_NI,
   SSIC0_I_NI, "\xE2\x80\x98", "\xE2\x80\x99", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\xA2", "\xE2\x80\x93", "\xE2\x80\x94", "\xCB\x9C", "\xE2\x84\xA2", SSIC0_I_NI, "\xE2\x80\xBA", "\xC5\x93", SSIC0_I_NI, SSIC0_I_NI, "\xC5\xB8",
   "\xC2\xA0", "\xC2\xA1", "\xC2\xA2", "\xC2\xA3", "\xC2\xA4", "\xC2\xA5", "\xC2\xA6", "\xC2\xA7", "\xC2\xA8", "\xC2\xA9", "\xC2\xAA", "\xC2\xAB", "\xC2\xAC", "\xC2\xAD", "\xC2\xAE", "\xC2\xAF",
   "\xC2\xB0", "\xC2\xB1", "\xC2\xB2", "\xC2\xB3", "\xC2\xB4", "\xC2\xB5", "\xC2\xB6", "\xC2\xB7", "\xC2\xB8", "\xC2\xB9", "\xC2\xBA", "\xC2\xBB", "\xC2\xBC", "\xC2\xBD", "\xC2\xBE", "\xC2\xBF",
   "\xC3\x80", "\xC3\x81", "\xC3\x82", "\xC4\x82", "\xC3\x84", "\xC3\x85", "\xC3\x86", "\xC3\x87", "\xC3\x88", "\xC3\x89", "\xC3\x8A", "\xC3\x8B", "\xCC\x80", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F",
   "\xC4\x90", "\xC3\x91", "\xCC\x89", "\xC3\x93", "\xC3\x94", "\xC6\xA0", "\xC3\x96", "\xC3\x97", "\xC3\x98", "\xC3\x99", "\xC3\x9A", "\xC3\x9B", "\xC3\x9C", "\xC6\xAF", "\xCC\x83", "\xC3\x9F",
   "\xC3\xA0", "\xC3\xA1", "\xC3\xA2", "\xC4\x83", "\xC3\xA4", "\xC3\xA5", "\xC3\xA6", "\xC3\xA7", "\xC3\xA8", "\xC3\xA9", "\xC3\xAA", "\xC3\xAB", "\xCC\x81", "\xC3\xAD", "\xC3\xAE", "\xC3\xAF",
   "\xC4\x91", "\xC3\xB1", "\xCC\xA3", "\xC3\xB3", "\xC3\xB4", "\xC6\xA1", "\xC3\xB6", "\xC3\xB7", "\xC3\xB8", "\xC3\xB9", "\xC3\xBA", "\xC3\xBB", "\xC3\xBC", "\xC6\xB0", "\xE2\x82\xAB", "\xC3\xBF"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of MacRoman character set */
const char *ssic0_i_table_mac_roman[128] =
{
   "\xC3\x84", "\xC3\x85", "\xC3\x87", "\xC3\x89", "\xC3\x91", "\xC3\x96", "\xC3\x9C", "\xC3\xA1", "\xC3\xA0", "\xC3\xA2", "\xC3\xA4", "\xC3\xA3", "\xC3\xA5", "\xC3\xA7", "\xC3\xA9", "\xC3\xA8",
   "\xC3\xAA", "\xC3\xAB", "\xC3\xAD", "\xC3\xAC", "\xC3\xAE", "\xC3\xAF", "\xC3\xB1", "\xC3\xB3", "\xC3\xB2", "\xC3\xB4", "\xC3\xB6", "\xC3\xB5", "\xC3\xBA", "\xC3\xB9", "\xC3\xBB", "\xC3\xBC",
   "\xE2\x80\xA0", "\xC2\xB0", "\xC2\xA2", "\xC2\xA3", "\xC2\xA7", "\xE2\x80\xA2", "\xC2\xB6", "\xC3\x9F", "\xC2\xAE", "\xC2\xA9", "\xE2\x84\xA2", "\xC2\xB4", "\xC2\xA8", "\xE2\x89\xA0", "\xC3\x86", "\xC3\x98",
   "\xE2\x88\x9E", "\xC2\xB1", "\xE2\x89\xA4", "\xE2\x89\xA5", "\xC2\xA5", "\xC2\xB5", "\xE2\x88\x82", "\xE2\x88\x91", "\xE2\x88\x8F", "\xCF\x80", "\xE2\x88\xAB", "\xC2\xAA", "\xC2\xBA", "\xE2\x84\xA6", "\xC3\xA6", "\xC3\xB8",
   "\xC2\xBF", "\xC2\xA1", "\xC2\xAC", "\xE2\x88\x9A", "\xC6\x92", "\xE2\x89\x88", "\xE2\x88\x86", "\xC2\xAB", "\xC2\xBB", "\xE2\x80\xA6", "\xC2\xA0", "\xC3\x80", "\xC3\x83", "\xC3\x95", "\xC5\x92", "\xC5\x93",
   "\xE2\x80\x93", "\xE2\x80\x94", "\xE2\x80\x9C", "\xE2\x80\x9D", "\xE2\x80\x98", "\xE2\x80\x99", "\xC3\xB7", "\xE2\x97\x8A", "\xC3\xBF", "\xC5\xB8", "\xE2\x81\x84", "\xE2\x82\xAC", "\xE2\x80\xB9", "\xE2\x80\xBA", "\xEF\xAC\x81", "\xEF\xAC\x82",
   "\xE2\x80\xA1", "\xC2\xB7", "\xE2\x80\x9A", "\xE2\x80\x9E", "\xE2\x80\xB0", "\xC3\x82", "\xC3\x8A", "\xC3\x81", "\xC3\x8B", "\xC3\x88", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F", "\xC3\x8C", "\xC3\x93", "\xC3\x94",
   SSIC0_I_NI, "\xC3\x92", "\xC3\x9A", "\xC3\x9B", "\xC3\x99", "\xC4\xB1", "\xCB\x86", "\xCB\x9C", "\xC2\xAF", "\xCB\x98", "\xCB\x99", "\xCB\x9A", "\xC2\xB8", "\xCB\x9D", "\xCB\x9B", "\xCB\x87"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of IBM437 character set */
const char *ssic0_i_table_ibm437[128] =
{
   "\xC3\x87", "\xC3\xBC", "\xC3\xA9", "\xC3\xA2", "\xC3\xA4", "\xC3\xA0", "\xC3\xA5", "\xC3\xA7", "\xC3\xAA", "\xC3\xAB", "\xC3\xA8", "\xC3\xAF", "\xC3\xAE", "\xC3\xAC", "\xC3\x84", "\xC3\x85",
   "\xC3\x89", "\xC3\xA6", "\xC3\x86", "\xC3\xB4", "\xC3\xB6", "\xC3\xB2", "\xC3\xBB", "\xC3\xB9", "\xC3\xBF", "\xC3\x96", "\xC3\x9C", "\xC2\xA2", "\xC2\xA3", "\xC2\xA5", "\xE2\x82\xA7", "\xC6\x92",
   "\xC3\xA1", "\xC3\xAD", "\xC3\xB3", "\xC3\xBA", "\xC3\xB1", "\xC3\x91", "\xC2\xAA", "\xC2\xBA", "\xC2\xBF", "\xE2\x8C\x90", "\xC2\xAC", "\xC2\xBD", "\xC2\xBC", "\xC2\xA1", "\xC2\xAB", "\xC2\xBB",
   "\xE2\x96\x91", "\xE2\x96\x92", "\xE2\x96\x93", "\xE2\x94\x82", "\xE2\x94\xA4", "\xE2\x95\xA1", "\xE2\x95\xA2", "\xE2\x95\x96", "\xE2\x95\x95", "\xE2\x95\xA3", "\xE2\x95\x91", "\xE2\x95\x97", "\xE2\x95\x9D", "\xE2\x95\x9C", "\xE2\x95\x9B", "\xE2\x94\x90",
   "\xE2\x94\x94", "\xE2\x94\xB4", "\xE2\x94\xAC", "\xE2\x94\x9C", "\xE2\x94\x80", "\xE2\x94\xBC", "\xE2\x95\x9E", "\xE2\x95\x9F", "\xE2\x95\x9A", "\xE2\x95\x94", "\xE2\x95\xA9", "\xE2\x95\xA6", "\xE2\x95\xA0", "\xE2\x95\x90", "\xE2\x95\xAC", "\xE2\x95\xA7",
   "\xE2\x95\xA8", "\xE2\x95\xA4", "\xE2\x95\xA5", "\xE2\x95\x99", "\xE2\x95\x98", "\xE2\x95\x92", "\xE2\x95\x93", "\xE2\x95\xAB", "\xE2\x95\xAA", "\xE2\x94\x98", "\xE2\x94\x8C", "\xE2\x96\x88", "\xE2\x96\x84", "\xE2\x96\x8C", "\xE2\x96\x90", "\xE2\x96\x80",
   "\xCE\xB1", "\xC3\x9F", "\xCE\x93", "\xCF\x80", "\xCE\xA3", "\xCF\x83", "\xC2\xB5", "\xCF\x84", "\xCE\xA6", "\xCE\x98", "\xCE\xA9", "\xCE\xB4", "\xE2\x88\x9E", "\xCF\x86", "\xCE\xB5", "\xE2\x88\xA9",
   "\xE2\x89\xA1", "\xC2\xB1", "\xE2\x89\xA5", "\xE2\x89\xA4", "\xE2\x8C\xA0", "\xE2\x8C\xA1", "\xC3\xB7", "\xE2\x89\x88", "\xC2\xB0", "\xE2\x88\x99", "\xC2\xB7", "\xE2\x88\x9A", "\xE2\x81\xBF", "\xC2\xB2", "\xE2\x96\xA0", "\xC2\xA0"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of IBM775 character set */
const char *ssic0_i_table_ibm775[128] =
{
   "\xC4\x86", "\xC3\xBC", "\xC3\xA9", "\xC4\x81", "\xC3\xA4", "\xC4\xA3", "\xC3\xA5", "\xC4\x87", "\xC5\x82", "\xC4\x93", "\xC5\x96", "\xC5\x97", "\xC4\xAB", "\xC5\xB9", "\xC3\x84", "\xC3\x85",
   "\xC3\x89", "\xC3\xA6", "\xC3\x86", "\xC5\x8D", "\xC3\xB6", "\xC4\xA2", "\xC2\xA2", "\xC5\x9A", "\xC5\x9B", "\xC3\x96", "\xC3\x9C", "\xC3\xB8", "\xC2\xA3", "\xC3\x98", "\xC3\x97", "\xC2\xA4",
   "\xC4\x80", "\xC4\xAA", "\xC3\xB3", "\xC5\xBB", "\xC5\xBC", "\xC5\xBA", "\xE2\x80\x9D", "\xC2\xA6", "\xC2\xA9", "\xC2\xAE", "\xC2\xAC", "\xC2\xBD", "\xC2\xBC", "\xC5\x81", "\xC2\xAB", "\xC2\xBB",
   "\xE2\x96\x91", "\xE2\x96\x92", "\xE2\x96\x93", "\xE2\x94\x82", "\xE2\x94\xA4", "\xC4\x84", "\xC4\x8C", "\xC4\x98", "\xC4\x96", "\xE2\x95\xA3", "\xE2\x95\x91", "\xE2\x95\x97", "\xE2\x95\x9D", "\xC4\xAE", "\xC5\xA0", "\xE2\x94\x90",
   "\xE2\x94\x94", "\xE2\x94\xB4", "\xE2\x94\xAC", "\xE2\x94\x9C", "\xE2\x94\x80", "\xE2\x94\xBC", "\xC5\xB2", "\xC5\xAA", "\xE2\x95\x9A", "\xE2\x95\x94", "\xE2\x95\xA9", "\xE2\x95\xA6", "\xE2\x95\xA0", "\xE2\x95\x90", "\xE2\x95\xAC", "\xC5\xBD",
   "\xC4\x85", "\xC4\x8D", "\xC4\x99", "\xC4\x97", "\xC4\xAF", "\xC5\xA1", "\xC5\xB3", "\xC5\xAB", "\xC5\xBE", "\xE2\x94\x98", "\xE2\x94\x8C", "\xE2\x96\x88", "\xE2\x96\x84", "\xE2\x96\x8C", "\xE2\x96\x90", "\xE2\x96\x80",
   "\xC3\x93", "\xC3\x9F", "\xC5\x8C", "\xC5\x83", "\xC3\xB5", "\xC3\x95", "\xC2\xB5", "\xC5\x84", "\xC4\xB6", "\xC4\xB7", "\xC4\xBB", "\xC4\xBC", "\xC5\x86", "\xC4\x92", "\xC5\x85", "\xE2\x80\x99",
   "\xC2\xAD", "\xC2\xB1", "\xE2\x80\x9C", "\xC2\xBE", "\xC2\xB6", "\xC2\xA7", "\xC3\xB7", "\xE2\x80\x9E", "\xC2\xB0", "\xE2\x88\x99", "\xC2\xB7", "\xC2\xB9", "\xC2\xB3", "\xC2\xB2", "\xE2\x96\xA0", "\xC2\xA0"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of IBM850 character set */
const char *ssic0_i_table_ibm850[128] =
{
   "\xC3\x87", "\xC3\xBC", "\xC3\xA9", "\xC3\xA2", "\xC3\xA4", "\xC3\xA0", "\xC3\xA5", "\xC3\xA7", "\xC3\xAA", "\xC3\xAB", "\xC3\xA8", "\xC3\xAF", "\xC3\xAE", "\xC3\xAC", "\xC3\x84", "\xC3\x85",
   "\xC3\x89", "\xC3\xA6", "\xC3\x86", "\xC3\xB4", "\xC3\xB6", "\xC3\xB2", "\xC3\xBB", "\xC3\xB9", "\xC3\xBF", "\xC3\x96", "\xC3\x9C", "\xC3\xB8", "\xC2\xA3", "\xC3\x98", "\xC3\x97", "\xC6\x92",
   "\xC3\xA1", "\xC3\xAD", "\xC3\xB3", "\xC3\xBA", "\xC3\xB1", "\xC3\x91", "\xC2\xAA", "\xC2\xBA", "\xC2\xBF", "\xC2\xAE", "\xC2\xAC", "\xC2\xBD", "\xC2\xBC", "\xC2\xA1", "\xC2\xAB", "\xC2\xBB",
   "\xE2\x96\x91", "\xE2\x96\x92", "\xE2\x96\x93", "\xE2\x94\x82", "\xE2\x94\xA4", "\xC3\x81", "\xC3\x82", "\xC3\x80", "\xC2\xA9", "\xE2\x95\xA3", "\xE2\x95\x91", "\xE2\x95\x97", "\xE2\x95\x9D", "\xC2\xA2", "\xC2\xA5", "\xE2\x94\x90",
   "\xE2\x94\x94", "\xE2\x94\xB4", "\xE2\x94\xAC", "\xE2\x94\x9C", "\xE2\x94\x80", "\xE2\x94\xBC", "\xC3\xA3", "\xC3\x83", "\xE2\x95\x9A", "\xE2\x95\x94", "\xE2\x95\xA9", "\xE2\x95\xA6", "\xE2\x95\xA0", "\xE2\x95\x90", "\xE2\x95\xAC", "\xC2\xA4",
   "\xC3\xB0", "\xC3\x90", "\xC3\x8A", "\xC3\x8B", "\xC3\x88", "\xC4\xB1", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F", "\xE2\x94\x98", "\xE2\x94\x8C", "\xE2\x96\x88", "\xE2\x96\x84", "\xC2\xA6", "\xC3\x8C", "\xE2\x96\x80",
   "\xC3\x93", "\xC3\x9F", "\xC3\x94", "\xC3\x92", "\xC3\xB5", "\xC3\x95", "\xC2\xB5", "\xC3\xBE", "\xC3\x9E", "\xC3\x9A", "\xC3\x9B", "\xC3\x99", "\xC3\xBD", "\xC3\x9D", "\xC2\xAF", "\xC2\xB4",
   "\xC2\xAD", "\xC2\xB1", "\xE2\x80\x97", "\xC2\xBE", "\xC2\xB6", "\xC2\xA7", "\xC3\xB7", "\xC2\xB8", "\xC2\xB0", "\xC2\xA8", "\xC2\xB7", "\xC2\xB9", "\xC2\xB3", "\xC2\xB2", "\xE2\x96\xA0", "\xC2\xA0"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of IBM852 character set */
const char *ssic0_i_table_ibm852[128] =
{
   "\xC3\x87", "\xC3\xBC", "\xC3\xA9", "\xC3\xA2", "\xC3\xA4", "\xC5\xAF", "\xC4\x87", "\xC3\xA7", "\xC5\x82", "\xC3\xAB", "\xC5\x90", "\xC5\x91", "\xC3\xAE", "\xC5\xB9", "\xC3\x84", "\xC4\x86",
   "\xC3\x89", "\xC4\xB9", "\xC4\xBA", "\xC3\xB4", "\xC3\xB6", "\xC4\xBD", "\xC4\xBE", "\xC5\x9A", "\xC5\x9B", "\xC3\x96", "\xC3\x9C", "\xC5\xA4", "\xC5\xA5", "\xC5\x81", "\xC3\x97", "\xC4\x8D",
   "\xC3\xA1", "\xC3\xAD", "\xC3\xB3", "\xC3\xBA", "\xC4\x84", "\xC4\x85", "\xC5\xBD", "\xC5\xBE", "\xC4\x98", "\xC4\x99", "\xC2\xAC", "\xC5\xBA", "\xC4\x8C", "\xC5\x9F", "\xC2\xAB", "\xC2\xBB",
   "\xE2\x96\x91", "\xE2\x96\x92", "\xE2\x96\x93", "\xE2\x94\x82", "\xE2\x94\xA4", "\xC3\x81", "\xC3\x82", "\xC4\x9A", "\xC5\x9E", "\xE2\x95\xA3", "\xE2\x95\x91", "\xE2\x95\x97", "\xE2\x95\x9D", "\xC5\xBB", "\xC5\xBC", "\xE2\x94\x90",
   "\xE2\x94\x94", "\xE2\x94\xB4", "\xE2\x94\xAC", "\xE2\x94\x9C", "\xE2\x94\x80", "\xE2\x94\xBC", "\xC4\x82", "\xC4\x83", "\xE2\x95\x9A", "\xE2\x95\x94", "\xE2\x95\xA9", "\xE2\x95\xA6", "\xE2\x95\xA0", "\xE2\x95\x90", "\xE2\x95\xAC", "\xC2\xA4",
   "\xC4\x91", "\xC4\x90", "\xC4\x8E", "\xC3\x8B", "\xC4\x8F", "\xC5\x87", "\xC3\x8D", "\xC3\x8E", "\xC4\x9B", "\xE2\x94\x98", "\xE2\x94\x8C", "\xE2\x96\x88", "\xE2\x96\x84", "\xC5\xA2", "\xC5\xAE", "\xE2\x96\x80",
   "\xC3\x93", "\xC3\x9F", "\xC3\x94", "\xC5\x83", "\xC5\x84", "\xC5\x88", "\xC5\xA0", "\xC5\xA1", "\xC5\x94", "\xC3\x9A", "\xC5\x95", "\xC5\xB0", "\xC3\xBD", "\xC3\x9D", "\xC5\xA3", "\xC2\xB4",
   "\xC2\xAD", "\xCB\x9D", "\xCB\x9B", "\xCB\x87", "\xCB\x98", "\xC2\xA7", "\xC3\xB7", "\xC2\xB8", "\xC2\xB0", "\xC2\xA8", "\xCB\x99", "\xC5\xB1", "\xC5\x98", "\xC5\x99", "\xE2\x96\xA0", "\xC2\xA0"
};


/* ========================================================================== */
/* UTF-8 sequences for upper half of IBM858 character set */
const char *ssic0_i_table_ibm858[128] =
{
   "\xC3\x87", "\xC3\xBC", "\xC3\xA9", "\xC3\xA2", "\xC3\xA4", "\xC3\xA0", "\xC3\xA5", "\xC3\xA7", "\xC3\xAA", "\xC3\xAB", "\xC3\xA8", "\xC3\xAF", "\xC3\xAE", "\xC3\xAC", "\xC3\x84", "\xC3\x85",
   "\xC3\x89", "\xC3\xA6", "\xC3\x86", "\xC3\xB4", "\xC3\xB6", "\xC3\xB2", "\xC3\xBB", "\xC3\xB9", "\xC3\xBF", "\xC3\x96", "\xC3\x9C", "\xC3\xB8", "\xC2\xA3", "\xC3\x98", "\xC3\x97", "\xC6\x92",
   "\xC3\xA1", "\xC3\xAD", "\xC3\xB3", "\xC3\xBA", "\xC3\xB1", "\xC3\x91", "\xC2\xAA", "\xC2\xBA", "\xC2\xBF", "\xC2\xAE", "\xC2\xAC", "\xC2\xBD", "\xC2\xBC", "\xC2\xA1", "\xC2\xAB", "\xC2\xBB",
   "\xE2\x96\x91", "\xE2\x96\x92", "\xE2\x96\x93", "\xE2\x94\x82", "\xE2\x94\xA4", "\xC3\x81", "\xC3\x82", "\xC3\x80", "\xC2\xA9", "\xE2\x95\xA3", "\xE2\x95\x91", "\xE2\x95\x97", "\xE2\x95\x9D", "\xC2\xA2", "\xC2\xA5", "\xE2\x94\x90",
   "\xE2\x94\x94", "\xE2\x94\xB4", "\xE2\x94\xAC", "\xE2\x94\x9C", "\xE2\x94\x80", "\xE2\x94\xBC", "\xC3\xA3", "\xC3\x83", "\xE2\x95\x9A", "\xE2\x95\x94", "\xE2\x95\xA9", "\xE2\x95\xA6", "\xE2\x95\xA0", "\xE2\x95\x90", "\xE2\x95\xAC", "\xC2\xA4",
   "\xC3\xB0", "\xC3\x90", "\xC3\x8A", "\xC3\x8B", "\xC3\x88", "\xE2\x82\xAC", "\xC3\x8D", "\xC3\x8E", "\xC3\x8F", "\xE2\x94\x98", "\xE2\x94\x8C", "\xE2\x96\x88", "\xE2\x96\x84", "\xC2\xA6", "\xC3\x8C", "\xE2\x96\x80",
   "\xC3\x93", "\xC3\x9F", "\xC3\x94", "\xC3\x92", "\xC3\xB5", "\xC3\x95", "\xC2\xB5", "\xC3\xBE", "\xC3\x9E", "\xC3\x9A", "\xC3\x9B", "\xC3\x99", "\xC3\xBD", "\xC3\x9D", "\xC2\xAF", "\xC2\xB4",
   "\xC2\xAD", "\xC2\xB1", "\xE2\x80\x97", "\xC2\xBE", "\xC2\xB6", "\xC2\xA7", "\xC3\xB7", "\xC2\xB8", "\xC2\xB0", "\xC2\xA8", "\xC2\xB7", "\xC2\xB9", "\xC2\xB3", "\xC2\xB2", "\xE2\x96\xA0", "\xC2\xA0"
};
